-- MySQL dump 10.14  Distrib 5.5.52-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: asterisk
-- ------------------------------------------------------
-- Server version	5.5.52-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin`
--

DROP TABLE IF EXISTS `admin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `admin` (
  `variable` varchar(20) NOT NULL DEFAULT '',
  `value` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`variable`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ampusers`
--

DROP TABLE IF EXISTS `ampusers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ampusers` (
  `username` varchar(255) NOT NULL,
  `password_sha1` varchar(40) NOT NULL,
  `extension_low` varchar(20) NOT NULL DEFAULT '',
  `extension_high` varchar(20) NOT NULL DEFAULT '',
  `deptname` varchar(20) NOT NULL DEFAULT '',
  `sections` blob NOT NULL,
  PRIMARY KEY (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcement`
--

DROP TABLE IF EXISTS `announcement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `announcement` (
  `announcement_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) DEFAULT NULL,
  `recording_id` int(11) DEFAULT NULL,
  `allow_skip` int(11) DEFAULT NULL,
  `post_dest` varchar(255) DEFAULT NULL,
  `return_ivr` tinyint(1) NOT NULL DEFAULT '0',
  `noanswer` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_msg` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`announcement_id`)
) ENGINE=MyISAM AUTO_INCREMENT=355 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup`
--

DROP TABLE IF EXISTS `backup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `description` varchar(150) DEFAULT NULL,
  `immortal` varchar(25) DEFAULT NULL,
  `data` longtext,
  `email` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_cache`
--

DROP TABLE IF EXISTS `backup_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup_cache` (
  `id` varchar(50) NOT NULL,
  `manifest` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_details`
--

DROP TABLE IF EXISTS `backup_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup_details` (
  `backup_id` int(11) NOT NULL,
  `key` varchar(50) DEFAULT NULL,
  `index` varchar(25) DEFAULT NULL,
  `value` varchar(250) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_items`
--

DROP TABLE IF EXISTS `backup_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup_items` (
  `backup_id` int(11) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `path` text,
  `exclude` text
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_old`
--

DROP TABLE IF EXISTS `backup_old`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup_old` (
  `name` varchar(50) DEFAULT NULL,
  `voicemail` varchar(50) DEFAULT NULL,
  `recordings` varchar(50) DEFAULT NULL,
  `configurations` varchar(50) DEFAULT NULL,
  `cdr` varchar(55) DEFAULT NULL,
  `fop` varchar(50) DEFAULT NULL,
  `minutes` varchar(50) DEFAULT NULL,
  `hours` varchar(50) DEFAULT NULL,
  `days` varchar(50) DEFAULT NULL,
  `months` varchar(50) DEFAULT NULL,
  `weekdays` varchar(50) DEFAULT NULL,
  `command` varchar(200) DEFAULT NULL,
  `method` varchar(50) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ftpuser` varchar(50) DEFAULT NULL,
  `ftppass` varchar(50) DEFAULT NULL,
  `ftphost` varchar(50) DEFAULT NULL,
  `ftpdir` varchar(150) DEFAULT NULL,
  `sshuser` varchar(50) DEFAULT NULL,
  `sshkey` varchar(150) DEFAULT NULL,
  `sshhost` varchar(50) DEFAULT NULL,
  `sshdir` varchar(150) DEFAULT NULL,
  `emailaddr` varchar(75) DEFAULT NULL,
  `emailmaxsize` varchar(25) DEFAULT NULL,
  `emailmaxtype` varchar(5) DEFAULT NULL,
  `admin` varchar(10) DEFAULT NULL,
  `include` blob,
  `exclude` blob,
  `sudo` varchar(25) DEFAULT NULL,
  `remotesshhost` varchar(50) DEFAULT NULL,
  `remotesshuser` varchar(50) DEFAULT NULL,
  `remotesshkey` varchar(150) DEFAULT NULL,
  `remoterestore` varchar(5) DEFAULT NULL,
  `overwritebackup` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_server_details`
--

DROP TABLE IF EXISTS `backup_server_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup_server_details` (
  `server_id` int(11) NOT NULL,
  `key` varchar(50) DEFAULT NULL,
  `value` varchar(250) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_servers`
--

DROP TABLE IF EXISTS `backup_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup_servers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `desc` varchar(150) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `readonly` varchar(250) DEFAULT NULL,
  `immortal` varchar(25) DEFAULT NULL,
  `data` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_template_details`
--

DROP TABLE IF EXISTS `backup_template_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup_template_details` (
  `template_id` int(11) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `path` text,
  `exclude` text
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_templates`
--

DROP TABLE IF EXISTS `backup_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `backup_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `desc` varchar(150) DEFAULT NULL,
  `immortal` varchar(25) DEFAULT NULL,
  `data` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `callback`
--

DROP TABLE IF EXISTS `callback`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `callback` (
  `callback_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) DEFAULT NULL,
  `callbacknum` varchar(100) DEFAULT NULL,
  `destination` varchar(50) DEFAULT NULL,
  `sleep` int(11) DEFAULT NULL,
  `deptname` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`callback_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `callrecording`
--

DROP TABLE IF EXISTS `callrecording`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `callrecording` (
  `callrecording_id` int(11) NOT NULL AUTO_INCREMENT,
  `callrecording_mode` varchar(50) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  `dest` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`callrecording_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `callrecording_module`
--

DROP TABLE IF EXISTS `callrecording_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `callrecording_module` (
  `extension` varchar(50) DEFAULT NULL,
  `cidnum` varchar(50) DEFAULT '',
  `callrecording` varchar(10) DEFAULT NULL,
  `display` varchar(20) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cidlookup`
--

DROP TABLE IF EXISTS `cidlookup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `cidlookup` (
  `cidlookup_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  `sourcetype` varchar(100) NOT NULL,
  `cache` tinyint(1) NOT NULL DEFAULT '0',
  `deptname` varchar(30) DEFAULT NULL,
  `http_host` varchar(30) DEFAULT NULL,
  `http_port` varchar(30) DEFAULT NULL,
  `http_username` varchar(30) DEFAULT NULL,
  `http_password` varchar(30) DEFAULT NULL,
  `http_path` varchar(100) DEFAULT NULL,
  `http_query` varchar(100) DEFAULT NULL,
  `mysql_host` varchar(60) DEFAULT NULL,
  `mysql_dbname` varchar(60) DEFAULT NULL,
  `mysql_query` text,
  `mysql_username` varchar(30) DEFAULT NULL,
  `mysql_password` varchar(30) DEFAULT NULL,
  `mysql_charset` varchar(30) DEFAULT NULL,
  `opencnam_account_sid` varchar(34) DEFAULT NULL,
  `opencnam_auth_token` varchar(34) DEFAULT NULL,
  PRIMARY KEY (`cidlookup_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cidlookup_incoming`
--

DROP TABLE IF EXISTS `cidlookup_incoming`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `cidlookup_incoming` (
  `cidlookup_id` int(11) NOT NULL,
  `extension` varchar(50) DEFAULT NULL,
  `cidnum` varchar(30) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cronmanager`
--

DROP TABLE IF EXISTS `cronmanager`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `cronmanager` (
  `module` varchar(24) NOT NULL DEFAULT '',
  `id` varchar(24) NOT NULL DEFAULT '',
  `time` varchar(5) DEFAULT NULL,
  `freq` int(11) NOT NULL DEFAULT '0',
  `lasttime` int(11) NOT NULL DEFAULT '0',
  `command` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`module`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `custom_destinations`
--

DROP TABLE IF EXISTS `custom_destinations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `custom_destinations` (
  `custom_dest` varchar(80) NOT NULL DEFAULT '',
  `description` varchar(40) NOT NULL DEFAULT '',
  `notes` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`custom_dest`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `custom_extensions`
--

DROP TABLE IF EXISTS `custom_extensions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `custom_extensions` (
  `custom_exten` varchar(80) NOT NULL DEFAULT '',
  `description` varchar(40) NOT NULL DEFAULT '',
  `notes` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`custom_exten`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customcontexts_contexts`
--

DROP TABLE IF EXISTS `customcontexts_contexts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `customcontexts_contexts` (
  `context` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(100) NOT NULL DEFAULT '',
  `dialrules` varchar(1000) DEFAULT NULL,
  `faildestination` varchar(250) DEFAULT NULL,
  `featurefaildestination` varchar(250) DEFAULT NULL,
  `failpin` varchar(100) DEFAULT NULL,
  `failpincdr` tinyint(1) NOT NULL DEFAULT '0',
  `featurefailpin` varchar(100) DEFAULT NULL,
  `featurefailpincdr` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`context`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customcontexts_contexts_list`
--

DROP TABLE IF EXISTS `customcontexts_contexts_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `customcontexts_contexts_list` (
  `context` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(100) NOT NULL DEFAULT '',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`context`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customcontexts_includes`
--

DROP TABLE IF EXISTS `customcontexts_includes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `customcontexts_includes` (
  `context` varchar(100) NOT NULL DEFAULT '',
  `include` varchar(100) NOT NULL DEFAULT '',
  `timegroupid` int(11) DEFAULT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  `userules` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`context`,`include`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customcontexts_includes_list`
--

DROP TABLE IF EXISTS `customcontexts_includes_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `customcontexts_includes_list` (
  `context` varchar(100) NOT NULL DEFAULT '',
  `include` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(100) NOT NULL DEFAULT '',
  `missing` tinyint(1) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`context`,`include`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customcontexts_module`
--

DROP TABLE IF EXISTS `customcontexts_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `customcontexts_module` (
  `id` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customerdb`
--

DROP TABLE IF EXISTS `customerdb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `customerdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL,
  `addr1` varchar(150) NOT NULL,
  `addr2` varchar(150) DEFAULT NULL,
  `city` varchar(50) NOT NULL,
  `state` varchar(5) NOT NULL,
  `zip` varchar(12) DEFAULT NULL,
  `sip` varchar(20) DEFAULT NULL,
  `did` varchar(45) DEFAULT NULL,
  `device` varchar(50) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `serial` varchar(50) DEFAULT NULL,
  `account` varchar(6) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `username` varchar(25) DEFAULT NULL,
  `password` varchar(25) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dahdi`
--

DROP TABLE IF EXISTS `dahdi`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `dahdi` (
  `id` varchar(20) NOT NULL DEFAULT '-1',
  `keyword` varchar(30) NOT NULL DEFAULT '',
  `data` varchar(255) NOT NULL DEFAULT '',
  `flags` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dahdichandids`
--

DROP TABLE IF EXISTS `dahdichandids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `dahdichandids` (
  `channel` int(11) NOT NULL DEFAULT '0',
  `description` varchar(40) NOT NULL DEFAULT '',
  `did` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`channel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `daynight`
--

DROP TABLE IF EXISTS `daynight`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `daynight` (
  `ext` varchar(10) NOT NULL DEFAULT '',
  `dmode` varchar(40) NOT NULL DEFAULT '',
  `dest` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ext`,`dmode`,`dest`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `devices`
--

DROP TABLE IF EXISTS `devices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `devices` (
  `id` varchar(20) NOT NULL DEFAULT '',
  `tech` varchar(10) NOT NULL DEFAULT '',
  `dial` varchar(50) NOT NULL DEFAULT '',
  `devicetype` varchar(5) NOT NULL DEFAULT '',
  `user` varchar(50) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  `emergency_cid` varchar(100) DEFAULT NULL,
  KEY `id` (`id`),
  KEY `tech` (`tech`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `disa`
--

DROP TABLE IF EXISTS `disa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `disa` (
  `disa_id` int(11) NOT NULL AUTO_INCREMENT,
  `displayname` varchar(50) DEFAULT NULL,
  `pin` varchar(50) DEFAULT NULL,
  `cid` varchar(50) DEFAULT NULL,
  `context` varchar(50) DEFAULT NULL,
  `digittimeout` int(11) DEFAULT NULL,
  `resptimeout` int(11) DEFAULT NULL,
  `needconf` varchar(10) DEFAULT NULL,
  `hangup` varchar(10) DEFAULT NULL,
  `keepcid` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`disa_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `extensions`
--

DROP TABLE IF EXISTS `extensions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `extensions` (
  `context` varchar(45) NOT NULL DEFAULT 'default',
  `extension` varchar(45) NOT NULL DEFAULT '',
  `priority` varchar(5) NOT NULL DEFAULT '1',
  `application` varchar(45) NOT NULL DEFAULT '',
  `args` varchar(255) DEFAULT NULL,
  `descr` text,
  `flags` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`context`,`extension`,`priority`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fax_details`
--

DROP TABLE IF EXISTS `fax_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `fax_details` (
  `key` varchar(50) DEFAULT NULL,
  `value` varchar(510) DEFAULT NULL,
  UNIQUE KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fax_incoming`
--

DROP TABLE IF EXISTS `fax_incoming`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `fax_incoming` (
  `cidnum` varchar(20) DEFAULT NULL,
  `extension` varchar(50) DEFAULT NULL,
  `detection` varchar(20) DEFAULT NULL,
  `detectionwait` varchar(5) DEFAULT NULL,
  `destination` varchar(50) DEFAULT NULL,
  `legacy_email` varchar(50) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fax_users`
--

DROP TABLE IF EXISTS `fax_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `fax_users` (
  `user` varchar(15) DEFAULT NULL,
  `faxenabled` varchar(10) DEFAULT NULL,
  `faxemail` text,
  `faxattachformat` varchar(10) DEFAULT NULL,
  UNIQUE KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `featurecodes`
--

DROP TABLE IF EXISTS `featurecodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `featurecodes` (
  `modulename` varchar(50) NOT NULL DEFAULT '',
  `featurename` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `defaultcode` varchar(20) DEFAULT NULL,
  `customcode` varchar(20) DEFAULT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '0',
  `providedest` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`modulename`,`featurename`),
  KEY `enabled` (`enabled`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `findmefollow`
--

DROP TABLE IF EXISTS `findmefollow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `findmefollow` (
  `grpnum` varchar(20) NOT NULL,
  `strategy` varchar(50) NOT NULL,
  `grptime` smallint(6) NOT NULL,
  `grppre` varchar(100) DEFAULT NULL,
  `grplist` varchar(255) NOT NULL,
  `annmsg_id` int(11) DEFAULT NULL,
  `postdest` varchar(255) DEFAULT NULL,
  `dring` varchar(255) DEFAULT NULL,
  `remotealert_id` int(11) DEFAULT NULL,
  `needsconf` varchar(10) DEFAULT NULL,
  `toolate_id` int(11) DEFAULT NULL,
  `pre_ring` smallint(6) NOT NULL DEFAULT '0',
  `ringing` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`grpnum`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gabcast`
--

DROP TABLE IF EXISTS `gabcast`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `gabcast` (
  `ext` varchar(50) NOT NULL,
  `channbr` varchar(50) DEFAULT NULL,
  `pin` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ext`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `globals`
--

DROP TABLE IF EXISTS `globals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `globals` (
  `variable` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`variable`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `iax`
--

DROP TABLE IF EXISTS `iax`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `iax` (
  `id` varchar(20) NOT NULL DEFAULT '-1',
  `keyword` varchar(30) NOT NULL DEFAULT '',
  `data` varchar(255) NOT NULL,
  `flags` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `iaxsettings`
--

DROP TABLE IF EXISTS `iaxsettings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `iaxsettings` (
  `keyword` varchar(50) NOT NULL DEFAULT '',
  `data` varchar(255) NOT NULL DEFAULT '',
  `seq` tinyint(1) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`keyword`,`seq`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `incoming`
--

DROP TABLE IF EXISTS `incoming`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `incoming` (
  `cidnum` varchar(20) DEFAULT NULL,
  `extension` varchar(50) NOT NULL,
  `destination` varchar(50) DEFAULT NULL,
  `faxexten` varchar(20) DEFAULT NULL,
  `faxemail` varchar(50) DEFAULT NULL,
  `answer` tinyint(1) DEFAULT NULL,
  `wait` int(2) DEFAULT NULL,
  `privacyman` tinyint(1) DEFAULT NULL,
  `alertinfo` varchar(255) DEFAULT NULL,
  `ringing` varchar(20) DEFAULT NULL,
  `mohclass` varchar(80) NOT NULL DEFAULT 'default',
  `description` varchar(80) DEFAULT NULL,
  `grppre` varchar(80) DEFAULT NULL,
  `delay_answer` int(2) DEFAULT NULL,
  `pricid` varchar(20) DEFAULT NULL,
  `pmmaxretries` varchar(2) DEFAULT NULL,
  `pmminlength` varchar(2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `indications_zonelist`
--

DROP TABLE IF EXISTS `indications_zonelist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `indications_zonelist` (
  `name` varchar(80) NOT NULL,
  `iso` varchar(20) NOT NULL,
  `conf` blob,
  PRIMARY KEY (`iso`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventorydb`
--

DROP TABLE IF EXISTS `inventorydb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `inventorydb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empnum` varchar(10) DEFAULT NULL,
  `empname` varchar(20) NOT NULL,
  `building` varchar(150) DEFAULT NULL,
  `floor` varchar(10) DEFAULT NULL,
  `room` varchar(10) DEFAULT NULL,
  `section` varchar(6) DEFAULT NULL,
  `cubicle` varchar(6) DEFAULT NULL,
  `desk` varchar(6) DEFAULT NULL,
  `exten` varchar(8) DEFAULT NULL,
  `phusername` varchar(10) DEFAULT NULL,
  `phpassword` varchar(10) DEFAULT NULL,
  `mac` varchar(18) DEFAULT NULL,
  `serial` varchar(20) DEFAULT NULL,
  `device` varchar(20) DEFAULT NULL,
  `distdate` varchar(10) DEFAULT NULL,
  `ip` varchar(14) DEFAULT NULL,
  `pbxbox` varchar(20) DEFAULT NULL,
  `extrainfo` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `issabelpbx_log`
--

DROP TABLE IF EXISTS `issabelpbx_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `issabelpbx_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `section` varchar(50) DEFAULT NULL,
  `level` enum('error','warning','debug','devel-debug') NOT NULL DEFAULT 'error',
  `status` int(11) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`,`level`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `issabelpbx_settings`
--

DROP TABLE IF EXISTS `issabelpbx_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `issabelpbx_settings` (
  `keyword` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(255) DEFAULT NULL,
  `name` varchar(80) DEFAULT NULL,
  `level` tinyint(1) DEFAULT '0',
  `description` text,
  `type` varchar(25) DEFAULT NULL,
  `options` text,
  `defaultval` varchar(255) DEFAULT NULL,
  `readonly` tinyint(1) DEFAULT '0',
  `hidden` tinyint(1) DEFAULT '0',
  `category` varchar(50) DEFAULT NULL,
  `module` varchar(25) DEFAULT NULL,
  `emptyok` tinyint(1) DEFAULT '1',
  `sortorder` int(11) DEFAULT '0',
  PRIMARY KEY (`keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ivr_details`
--

DROP TABLE IF EXISTS `ivr_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ivr_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `description` varchar(150) DEFAULT NULL,
  `announcement` varchar(25) DEFAULT NULL,
  `directdial` varchar(50) DEFAULT NULL,
  `invalid_loops` varchar(10) DEFAULT NULL,
  `invalid_retry_recording` varchar(25) DEFAULT NULL,
  `invalid_destination` varchar(50) DEFAULT NULL,
  `invalid_recording` varchar(25) DEFAULT NULL,
  `retvm` varchar(8) DEFAULT NULL,
  `timeout_time` int(11) DEFAULT NULL,
  `timeout_recording` varchar(25) DEFAULT NULL,
  `timeout_retry_recording` varchar(25) DEFAULT NULL,
  `timeout_destination` varchar(50) DEFAULT NULL,
  `timeout_loops` varchar(11) DEFAULT NULL,
  `timeout_append_announce` tinyint(1) NOT NULL DEFAULT '1',
  `invalid_append_announce` tinyint(1) NOT NULL DEFAULT '1',
  `timeout_ivr_ret` tinyint(1) NOT NULL DEFAULT '0',
  `invalid_ivr_ret` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=316 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ivr_entries`
--

DROP TABLE IF EXISTS `ivr_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ivr_entries` (
  `ivr_id` int(11) NOT NULL,
  `selection` varchar(10) DEFAULT NULL,
  `dest` varchar(50) DEFAULT NULL,
  `ivr_ret` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `language_incoming`
--

DROP TABLE IF EXISTS `language_incoming`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `language_incoming` (
  `extension` varchar(50) DEFAULT NULL,
  `cidnum` varchar(50) DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `languages` (
  `language_id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(50) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  `dest` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `logfile_logfiles`
--

DROP TABLE IF EXISTS `logfile_logfiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `logfile_logfiles` (
  `name` varchar(25) NOT NULL DEFAULT '',
  `debug` varchar(25) DEFAULT NULL,
  `dtmf` varchar(25) DEFAULT NULL,
  `error` varchar(25) DEFAULT NULL,
  `fax` varchar(25) DEFAULT NULL,
  `notice` varchar(25) DEFAULT NULL,
  `verbose` varchar(25) DEFAULT NULL,
  `warning` varchar(25) DEFAULT NULL,
  `security` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `logfile_settings`
--

DROP TABLE IF EXISTS `logfile_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `logfile_settings` (
  `key` varchar(100) NOT NULL DEFAULT '',
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `manager`
--

DROP TABLE IF EXISTS `manager`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `manager` (
  `manager_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL,
  `secret` varchar(50) DEFAULT NULL,
  `deny` varchar(255) DEFAULT NULL,
  `permit` varchar(255) DEFAULT NULL,
  `read` varchar(255) DEFAULT NULL,
  `write` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`manager_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `meetme`
--

DROP TABLE IF EXISTS `meetme`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `meetme` (
  `exten` varchar(50) NOT NULL,
  `options` varchar(15) DEFAULT NULL,
  `userpin` varchar(50) DEFAULT NULL,
  `adminpin` varchar(50) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  `joinmsg_id` int(11) DEFAULT NULL,
  `music` varchar(80) DEFAULT NULL,
  `users` tinyint(4) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `miscapps`
--

DROP TABLE IF EXISTS `miscapps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `miscapps` (
  `miscapps_id` int(11) NOT NULL AUTO_INCREMENT,
  `ext` varchar(50) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  `dest` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`miscapps_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `miscdests`
--

DROP TABLE IF EXISTS `miscdests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `miscdests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) NOT NULL,
  `destdial` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `module_xml`
--

DROP TABLE IF EXISTS `module_xml`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `module_xml` (
  `id` varchar(20) NOT NULL DEFAULT 'xml',
  `time` int(11) NOT NULL DEFAULT '0',
  `data` mediumblob NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `modules`
--

DROP TABLE IF EXISTS `modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `modulename` varchar(50) NOT NULL DEFAULT '',
  `version` varchar(20) NOT NULL DEFAULT '',
  `enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=119 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `notifications` (
  `module` varchar(24) NOT NULL DEFAULT '',
  `id` varchar(24) NOT NULL DEFAULT '',
  `level` int(11) NOT NULL DEFAULT '0',
  `display_text` varchar(255) NOT NULL DEFAULT '',
  `extended_text` blob NOT NULL,
  `link` varchar(255) NOT NULL DEFAULT '',
  `reset` tinyint(4) NOT NULL DEFAULT '0',
  `candelete` tinyint(4) NOT NULL DEFAULT '0',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`module`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `outbound_route_patterns`
--

DROP TABLE IF EXISTS `outbound_route_patterns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `outbound_route_patterns` (
  `route_id` int(11) NOT NULL,
  `match_pattern_prefix` varchar(60) NOT NULL DEFAULT '',
  `match_pattern_pass` varchar(60) NOT NULL DEFAULT '',
  `match_cid` varchar(60) NOT NULL DEFAULT '',
  `prepend_digits` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`route_id`,`match_pattern_prefix`,`match_pattern_pass`,`match_cid`,`prepend_digits`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `outbound_route_sequence`
--

DROP TABLE IF EXISTS `outbound_route_sequence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `outbound_route_sequence` (
  `route_id` int(11) NOT NULL,
  `seq` int(11) NOT NULL,
  PRIMARY KEY (`route_id`,`seq`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `outbound_route_trunks`
--

DROP TABLE IF EXISTS `outbound_route_trunks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `outbound_route_trunks` (
  `route_id` int(11) NOT NULL,
  `trunk_id` int(11) NOT NULL,
  `seq` int(11) NOT NULL,
  PRIMARY KEY (`route_id`,`trunk_id`,`seq`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `outbound_routes`
--

DROP TABLE IF EXISTS `outbound_routes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `outbound_routes` (
  `route_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `outcid` varchar(40) DEFAULT NULL,
  `outcid_mode` varchar(20) DEFAULT NULL,
  `password` varchar(30) DEFAULT NULL,
  `emergency_route` varchar(4) DEFAULT NULL,
  `intracompany_route` varchar(4) DEFAULT NULL,
  `mohclass` varchar(80) DEFAULT NULL,
  `time_group_id` int(11) DEFAULT NULL,
  `dest` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`route_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `outroutemsg`
--

DROP TABLE IF EXISTS `outroutemsg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `outroutemsg` (
  `keyword` varchar(40) NOT NULL DEFAULT '',
  `data` varchar(10) NOT NULL,
  PRIMARY KEY (`keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paging_autoanswer`
--

DROP TABLE IF EXISTS `paging_autoanswer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `paging_autoanswer` (
  `useragent` varchar(255) NOT NULL,
  `var` varchar(20) NOT NULL,
  `setting` varchar(255) NOT NULL,
  PRIMARY KEY (`useragent`,`var`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paging_config`
--

DROP TABLE IF EXISTS `paging_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `paging_config` (
  `page_group` varchar(255) NOT NULL DEFAULT '',
  `force_page` int(1) NOT NULL,
  `duplex` int(1) NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`page_group`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paging_groups`
--

DROP TABLE IF EXISTS `paging_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `paging_groups` (
  `page_number` varchar(50) NOT NULL DEFAULT '',
  `ext` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`page_number`,`ext`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `parkplus`
--

DROP TABLE IF EXISTS `parkplus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `parkplus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `defaultlot` varchar(10) NOT NULL DEFAULT 'no',
  `type` varchar(10) NOT NULL DEFAULT 'public',
  `name` varchar(40) NOT NULL DEFAULT '',
  `parkext` varchar(40) NOT NULL DEFAULT '',
  `parkpos` varchar(40) NOT NULL DEFAULT '',
  `numslots` int(11) NOT NULL DEFAULT '4',
  `parkingtime` int(11) NOT NULL DEFAULT '45',
  `parkedmusicclass` varchar(100) DEFAULT 'default',
  `generatefc` varchar(10) NOT NULL DEFAULT 'yes',
  `generatehints` varchar(10) NOT NULL DEFAULT 'yes',
  `findslot` varchar(10) NOT NULL DEFAULT 'first',
  `parkedplay` varchar(10) NOT NULL DEFAULT 'both',
  `parkedcalltransfers` varchar(10) NOT NULL DEFAULT 'caller',
  `parkedcallreparking` varchar(10) NOT NULL DEFAULT 'caller',
  `alertinfo` varchar(254) NOT NULL DEFAULT '',
  `cidpp` varchar(100) NOT NULL DEFAULT '',
  `autocidpp` varchar(10) NOT NULL DEFAULT 'none',
  `announcement_id` int(11) DEFAULT NULL,
  `comebacktoorigin` varchar(10) NOT NULL DEFAULT 'yes',
  `dest` varchar(100) NOT NULL DEFAULT 'app-blackhole,hangup,1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `phpagiconf`
--

DROP TABLE IF EXISTS `phpagiconf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `phpagiconf` (
  `phpagiid` int(11) NOT NULL AUTO_INCREMENT,
  `debug` tinyint(1) DEFAULT NULL,
  `error_handler` tinyint(1) DEFAULT NULL,
  `err_email` varchar(50) DEFAULT NULL,
  `hostname` varchar(255) DEFAULT NULL,
  `tempdir` varchar(255) DEFAULT NULL,
  `festival_text2wave` varchar(255) DEFAULT NULL,
  `asman_server` varchar(255) DEFAULT NULL,
  `asman_port` int(11) NOT NULL,
  `asman_user` varchar(50) DEFAULT NULL,
  `asman_secret` varchar(255) DEFAULT NULL,
  `cepstral_swift` varchar(255) DEFAULT NULL,
  `cepstral_voice` varchar(50) DEFAULT NULL,
  `setuid` tinyint(1) DEFAULT NULL,
  `basedir` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`phpagiid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pinset_usage`
--

DROP TABLE IF EXISTS `pinset_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `pinset_usage` (
  `pinsets_id` int(11) NOT NULL,
  `dispname` varchar(30) NOT NULL DEFAULT '',
  `foreign_id` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`dispname`,`foreign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pinsets`
--

DROP TABLE IF EXISTS `pinsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `pinsets` (
  `pinsets_id` int(11) NOT NULL AUTO_INCREMENT,
  `passwords` longtext,
  `description` varchar(50) DEFAULT NULL,
  `addtocdr` tinyint(1) DEFAULT NULL,
  `deptname` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`pinsets_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queueprio`
--

DROP TABLE IF EXISTS `queueprio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `queueprio` (
  `queueprio_id` int(11) NOT NULL AUTO_INCREMENT,
  `queue_priority` varchar(50) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  `dest` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`queueprio_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queues_config`
--

DROP TABLE IF EXISTS `queues_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `queues_config` (
  `extension` varchar(20) NOT NULL DEFAULT '',
  `descr` varchar(35) NOT NULL DEFAULT '',
  `grppre` varchar(100) NOT NULL DEFAULT '',
  `alertinfo` varchar(254) NOT NULL DEFAULT '',
  `ringing` tinyint(1) NOT NULL DEFAULT '0',
  `maxwait` varchar(8) NOT NULL DEFAULT '',
  `password` varchar(20) NOT NULL DEFAULT '',
  `ivr_id` varchar(8) NOT NULL DEFAULT '0',
  `dest` varchar(50) NOT NULL DEFAULT '',
  `cwignore` tinyint(1) NOT NULL DEFAULT '0',
  `qregex` varchar(255) DEFAULT NULL,
  `agentannounce_id` int(11) DEFAULT NULL,
  `joinannounce_id` int(11) DEFAULT NULL,
  `queuewait` tinyint(1) DEFAULT '0',
  `use_queue_context` tinyint(1) DEFAULT '0',
  `togglehint` tinyint(1) DEFAULT '0',
  `qnoanswer` tinyint(1) DEFAULT '0',
  `callconfirm` tinyint(1) DEFAULT '0',
  `callconfirm_id` int(11) DEFAULT NULL,
  `monitor_type` varchar(5) DEFAULT NULL,
  `monitor_heard` int(11) DEFAULT NULL,
  `monitor_spoken` int(11) DEFAULT NULL,
  `callback_id` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`extension`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queues_details`
--

DROP TABLE IF EXISTS `queues_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `queues_details` (
  `id` varchar(45) NOT NULL DEFAULT '-1',
  `keyword` varchar(30) NOT NULL DEFAULT '',
  `data` varchar(150) NOT NULL DEFAULT '',
  `flags` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`keyword`,`data`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recordings`
--

DROP TABLE IF EXISTS `recordings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `recordings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `displayname` varchar(50) DEFAULT NULL,
  `filename` blob,
  `description` varchar(254) DEFAULT NULL,
  `fcode` tinyint(1) DEFAULT '0',
  `fcode_pass` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=456 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ringgroups`
--

DROP TABLE IF EXISTS `ringgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ringgroups` (
  `grpnum` varchar(20) NOT NULL,
  `strategy` varchar(50) NOT NULL,
  `grptime` smallint(6) NOT NULL,
  `grppre` varchar(100) DEFAULT NULL,
  `grplist` varchar(255) NOT NULL,
  `annmsg_id` int(11) DEFAULT NULL,
  `postdest` varchar(255) DEFAULT NULL,
  `description` varchar(35) NOT NULL,
  `alertinfo` varchar(255) DEFAULT NULL,
  `remotealert_id` int(11) DEFAULT NULL,
  `needsconf` varchar(10) DEFAULT NULL,
  `toolate_id` int(11) DEFAULT NULL,
  `ringing` varchar(80) DEFAULT NULL,
  `cwignore` varchar(10) DEFAULT NULL,
  `cfignore` varchar(10) DEFAULT NULL,
  `cpickup` varchar(10) DEFAULT NULL,
  `recording` varchar(10) DEFAULT 'dontcare',
  PRIMARY KEY (`grpnum`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sip`
--

DROP TABLE IF EXISTS `sip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `sip` (
  `id` varchar(20) NOT NULL DEFAULT '-1',
  `keyword` varchar(30) NOT NULL DEFAULT '',
  `data` varchar(255) NOT NULL,
  `flags` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sipsettings`
--

DROP TABLE IF EXISTS `sipsettings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `sipsettings` (
  `keyword` varchar(50) NOT NULL DEFAULT '',
  `data` varchar(255) NOT NULL DEFAULT '',
  `seq` tinyint(1) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`keyword`,`seq`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `timeconditions`
--

DROP TABLE IF EXISTS `timeconditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `timeconditions` (
  `timeconditions_id` int(11) NOT NULL AUTO_INCREMENT,
  `displayname` varchar(50) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `truegoto` varchar(50) DEFAULT NULL,
  `falsegoto` varchar(50) DEFAULT NULL,
  `deptname` varchar(50) DEFAULT NULL,
  `generate_hint` tinyint(1) DEFAULT '0',
  `priority` varchar(50) NOT NULL DEFAULT '0',
  PRIMARY KEY (`timeconditions_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `timegroups_details`
--

DROP TABLE IF EXISTS `timegroups_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `timegroups_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timegroupid` int(11) NOT NULL DEFAULT '0',
  `time` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `timegroups_groups`
--

DROP TABLE IF EXISTS `timegroups_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `timegroups_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `display` (`description`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `trunk_dialpatterns`
--

DROP TABLE IF EXISTS `trunk_dialpatterns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `trunk_dialpatterns` (
  `trunkid` int(11) NOT NULL DEFAULT '0',
  `match_pattern_prefix` varchar(50) NOT NULL DEFAULT '',
  `match_pattern_pass` varchar(50) NOT NULL DEFAULT '',
  `prepend_digits` varchar(50) NOT NULL DEFAULT '',
  `seq` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`trunkid`,`match_pattern_prefix`,`match_pattern_pass`,`prepend_digits`,`seq`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `trunks`
--

DROP TABLE IF EXISTS `trunks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `trunks` (
  `trunkid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `tech` varchar(20) NOT NULL,
  `outcid` varchar(40) NOT NULL DEFAULT '',
  `keepcid` varchar(4) DEFAULT 'off',
  `maxchans` varchar(6) DEFAULT '',
  `failscript` varchar(255) NOT NULL DEFAULT '',
  `dialoutprefix` varchar(255) NOT NULL DEFAULT '',
  `channelid` varchar(255) NOT NULL DEFAULT '',
  `usercontext` varchar(255) DEFAULT NULL,
  `provider` varchar(40) DEFAULT NULL,
  `disabled` varchar(4) DEFAULT 'off',
  `continue` varchar(4) DEFAULT 'off',
  PRIMARY KEY (`trunkid`,`tech`,`channelid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `users` (
  `extension` varchar(20) NOT NULL DEFAULT '',
  `password` varchar(20) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `voicemail` varchar(50) DEFAULT NULL,
  `ringtimer` int(3) DEFAULT NULL,
  `noanswer` varchar(100) DEFAULT NULL,
  `recording` varchar(50) DEFAULT NULL,
  `outboundcid` varchar(50) DEFAULT NULL,
  `sipname` varchar(50) DEFAULT NULL,
  `mohclass` varchar(80) DEFAULT 'default',
  `noanswer_cid` varchar(20) DEFAULT '',
  `busy_cid` varchar(20) DEFAULT '',
  `chanunavail_cid` varchar(20) DEFAULT '',
  `noanswer_dest` varchar(255) DEFAULT '',
  `busy_dest` varchar(255) DEFAULT '',
  `chanunavail_dest` varchar(255) DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vmblast`
--

DROP TABLE IF EXISTS `vmblast`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `vmblast` (
  `grpnum` int(11) NOT NULL,
  `description` varchar(35) NOT NULL,
  `audio_label` int(11) NOT NULL DEFAULT '-1',
  `password` varchar(20) NOT NULL,
  PRIMARY KEY (`grpnum`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vmblast_groups`
--

DROP TABLE IF EXISTS `vmblast_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `vmblast_groups` (
  `grpnum` varchar(50) NOT NULL DEFAULT '',
  `ext` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`grpnum`,`ext`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `voicemail_admin`
--

DROP TABLE IF EXISTS `voicemail_admin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `voicemail_admin` (
  `variable` varchar(30) NOT NULL DEFAULT '',
  `value` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`variable`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-11-14 23:59:02
-- MySQL dump 10.14  Distrib 5.5.52-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: asterisk
-- ------------------------------------------------------
-- Server version	5.5.52-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `admin`
--

LOCK TABLES `admin` WRITE;
/*!40000 ALTER TABLE `admin` DISABLE KEYS */;
INSERT INTO `admin` (`variable`, `value`) VALUES ('need_reload','false'),('version','2.11.0'),('ALLOW_SIP_ANON','yes');
/*!40000 ALTER TABLE `admin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `ampusers`
--

LOCK TABLES `ampusers` WRITE;
/*!40000 ALTER TABLE `ampusers` DISABLE KEYS */;
INSERT INTO `ampusers` (`username`, `password_sha1`, `extension_low`, `extension_high`, `deptname`, `sections`) VALUES ('admin','b7175378ff6d8063fce0e1c0c405f1b7c8af81ca','','','','*');
/*!40000 ALTER TABLE `ampusers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `announcement`
--

LOCK TABLES `announcement` WRITE;
/*!40000 ALTER TABLE `announcement` DISABLE KEYS */;
INSERT INTO `announcement` (`announcement_id`, `description`, `recording_id`, `allow_skip`, `post_dest`, `return_ivr`, `noanswer`, `repeat_msg`) VALUES (15,'1-BKP-20170920-BVOZ-ESP-5589958540',21,0,'ext-local,vms5589958540,1',0,0,''),(14,'1-BKP-20170920-BIENVENIDA-ING-5589958540',20,0,'ext-group,607,1',0,0,''),(11,'1-BKP-20170920-BVOZ-ESP-8147370215',21,0,'ext-local,vms8147370215,1',0,0,''),(12,'1-BKP-20170920-BVOZ-ING-8147370215',22,0,'ext-local,vms8147370215,1',0,0,''),(13,'1-BKP-20170920-BIENVENIDA-ING-8147370215',20,0,'ext-queues,98147370215,1',0,0,''),(16,'1-BKP-20170920-BVOZ-ING-5589958540',22,0,'ext-local,vms5589958540,1',0,0,''),(17,'1-BKP-20170920-BIENVENIDA-ING-3335605355',20,0,'ext-group,608,1',0,0,''),(19,'1-BKP-20170920-BVOZ-ESP-3335605355',21,0,'ext-local,vms3335605355,1',0,0,''),(21,'1-BKP-20170920-BVOZ-ING-3335605355',22,0,'ext-local,vms3335605355,1',0,0,''),(22,'493-OXI-20170926-BVOZ-ESP-8147370216',25,0,'ext-local,vms8147370216,1',0,0,''),(160,'543-DIS-20171124-BVOZ-FUERADESERVICIO-8177700385',197,0,'app-blackhole,hangup,1',0,0,''),(24,'555-ATD-20170926-BVOZ-ESP-8147370224',197,0,'app-blackhole,hangup,1',0,0,''),(25,'556-BRO-20170926-BVOZ-ESP-8147370226',25,0,'ext-local,vms8147370226,1',0,0,''),(26,'561-COM-20170927-BVOZ-ESP-8147370227',25,0,'ext-local,vms8147370227,1',0,0,''),(27,'563-SUO-20170927-BVOZ-ESP-8147370229-1',197,0,'app-blackhole,hangup,1',0,0,''),(352,'1404-KAR-20210909-BVOZ-LINEAOCUPADA-ESP-5588804681',58,0,'ext-local,vms5588804681,1',0,0,''),(210,'688-SEM-20180309-FUERADESERVICIO-ESP-8147370244',197,0,'app-blackhole,hangup,1',0,0,''),(31,'580-DQE-20170927-BVOZ-ESP-8147370237',25,0,'ext-local,vms8147370237,1',0,0,''),(32,'581-AMM-20170927-BVOZ-ESP-8147370238',25,0,'ext-local,vms8147370238,1',0,0,''),(74,'582-JOY-20171013-BVOZ-LINEAOCUPADA-ESP-8147370239',197,0,'app-blackhole,hangup,1',0,0,''),(82,'594-PRO-20171016-BVOZ-LINEAOCUPADA-ESP-8177700106',197,0,'app-blackhole,hangup,1',0,0,''),(81,'530-CIN-20171016-BVOZ-LINEAOCUPADA-ESP-8147370247',197,0,'app-blackhole,hangup,1',0,0,''),(80,'1333-EST-20210308-BVOZ-LINEAOCUPADA-ESP-8177700105',58,0,'ext-local,vms8177700105,1',0,0,''),(41,'564-PRO-20170927-BVOZ-ESP-5589958533',25,0,'ext-local,vms5589958533,1',0,0,''),(79,'1403-EVE-20210804-BVOZ-LINEAOCUPADA-ESP-8177700104',58,0,'ext-local,vms8177700104,1',0,0,''),(78,'1398-SER-20210804-BVOZ-LINEAOCUPADA-ESP-8177700103',58,0,'ext-local,vms8177700103,1',0,0,''),(77,'1376-UTI-20210804-BVOZ-LINEAOCUPADA-8177700102',58,0,'ext-local,vms8177700102,1',0,0,''),(103,'1327-QUA-20210308-BVOZ-LINEAOCUPADA-ESP-8177700101',58,0,'ext-local,vms8177700101,1',0,0,''),(75,'691-PRO-20180309-BVOZ-LINEAOCUPADA-ESP-8177700107',197,0,'app-blackhole,hangup,1',0,0,''),(83,'766-DES-20180712-BVOZ-LINEASUSPENDIDA-ESP-81473702',197,0,'app-blackhole,hangup,1',0,0,''),(50,'1-BKP-20170928-BVOZ-ESP-8177700100',21,0,'ext-local,vms8177700100,1',0,0,''),(51,'1-BKP-20170928-BVOZ-ING-8177700100',22,0,'ext-local,vms8177700100,1',0,0,''),(52,'1-BKP-20170928-BIENVENIDA-ING-8177700100',20,0,'ext-queues,98177700100,1',0,0,''),(53,'1-BKP-20170928-BVOZ-ESP-5588804680',21,0,'ext-local,vms5588804680,1',0,0,''),(54,'1-BKP-20170928-BVOZ-ING-5588804680',22,0,'ext-local,vms5588804680,1',0,0,''),(55,'1-BKP-20170928-BIENVENIDA-ING-5588804680',20,0,'ext-group,643,1',0,0,''),(56,'1-BKP-20170928-BVOZ-ESP-3388800130',21,0,'ext-local,vms3388800130,1',0,0,''),(57,'1-BKP-20170928-BVOZ-ING-3388800130',22,0,'ext-local,vms3388800130,1',0,0,''),(58,'1-BKP-20170928-BIENVENIDA-ING-3388800130',20,0,'ext-group,646,1',0,0,''),(59,'1-BKP-20170920-BVOZ-ESP-2228800360',21,0,'ext-local,vms2228800360,1',0,0,''),(60,'1-BKP-20170920-BVOZ-ING-2228800360',22,0,'ext-local,vms2228800360,1',0,0,''),(61,'1-BKP-20170920-BIENVENIDA-ING-2228800360',20,0,'ext-group,649,1',0,0,''),(288,'PRUEBAS-20190925-BVOZ-LINEAOCUPADA-ESP-8177701576',58,0,'ext-local,vms8177701576,1',0,0,''),(289,'924-IND-20190225-BVOZ-LINEAOCUPADA-ESP-8177701577',197,0,'app-blackhole,hangup,1',0,0,''),(65,'1-BKP-20170928-BVOZ-ESP-8447770070',21,0,'ext-local,vms8447770070,1',0,0,''),(66,'1-BKP-20170928-BVOZ-ING-8447770070',22,0,'ext-local,vms8447770070,1',0,0,''),(67,'1-BKP-20170928-BIENVENIDA-ING-8447770070',20,0,'ext-group,655,1',0,0,''),(351,'1309-TEC-20210210-BVOZ-LINEAOCUPADA-ESP-8147773890',58,0,'ext-local,vms8147773890,1',0,0,''),(70,'TEMP-8177700108',60,0,'ext-queues,18177700108,1',0,0,''),(71,'TEMP-8177700109',60,0,'ext-queues,18177700109,1',0,0,''),(72,'TEMP-8177700110',60,0,'ext-queues,18177700110,1',0,0,''),(73,'1388-SPO-20210713-BVOZ-LINEAOCUPADA-ESP-8177700111',58,0,'ext-local,vms8177700111,1',0,0,''),(130,'1450-ARQ-20211029-BVOZ-LINEAOCUPADA-ESP-9847770192',58,0,'ext-local,vms9847770192,1',0,0,''),(85,'584-REF-20171016-BVOZ-LINEAOCUPADA-ESP-8147370241',197,0,'app-blackhole,hangup,1',0,0,''),(86,'585-DIS-20171016-BVOZ-LINEAOCUPADA-ESP-8147370242',197,0,'app-blackhole,hangup,1',0,0,''),(158,'627-FAR-20171115-BVOZ-LINEAOCUPADA-ESP-8177700384',197,0,'app-blackhole,hangup,1',0,0,''),(88,'778-GRU-20180828-BVOZ-LINEAOCUPADA-ESP-8147370245',58,0,'ext-local,vms8147370245,1',0,0,''),(89,'588-ECO-20171016-BVOZ-LINEAOCUPADA-ESP-8147370246',197,0,'app-blackhole,hangup,1',0,0,''),(159,'634-LAM-20171124-BVOZ-LINEAOCUPADA-8177700385',58,0,'ext-local,vms8177700385,1',0,0,''),(91,'555-ATD-20171016-BVOZ-LINEAOCUPADA-ESP-8147370224',58,0,'ext-local,vms8147370224,1',0,0,''),(92,'555-ATD-20171017-BVOZ-LINEAOCUPADA-ESP-8147370224',58,0,'ext-local,vms8147370224,1',0,0,''),(93,'556-BRO-20171017-BVOZLINEAOCUPADA-ESP-8147370226',197,0,'app-blackhole,hangup,1',0,0,''),(94,'561-COM-20171017-BVOZLINEAOCUPADA-ESP-8147370227',197,0,'app-blackhole,hangup,1',0,0,''),(95,'563-SUO-20171017-BVOZLINEAOCUPADA-ESP-8147370229',58,0,'ext-local,vms8147370229,1',0,0,''),(209,'689-ELE-20180309-BVOZ-LINEAOCUPADA-ESP-8147370233',197,0,'app-blackhole,hangup,1',0,0,''),(354,'320-SAA-20210713-BVOZ-LINEAOCUPADA-ESP-8147773894',58,0,'ext-local,vms8147773894,1',0,0,''),(98,'821-ORG-20181017-BVOZLINEAOCUPADA-ESP-8177700113',197,0,'app-blackhole,hangup,1',0,0,''),(99,'1293-ARI-20210104-BVOZ-LINEAOCUPADA-ESP-8177700114',58,0,'ext-local,vms8177700114,1',0,0,''),(100,'827-SEI-20181004-BVOZ-LINEAOCUPADA-ESP-8177700115',197,0,'app-blackhole,hangup,1',0,0,''),(101,'969-AUT-20210316-BVOZ-LINEAOCUPADA-ESP-8177700112',58,0,'ext-local,vms8177700112,1',0,0,''),(102,'531-SER-20171019-BVOZ-FUERADESERVICIO-ESP-81473702',197,0,'ext-local,vms8147370230,1',0,0,''),(104,'549-COM-20171019-BVOZ-FUERADESERVICIO-ESP-55899585',197,0,'app-blackhole,hangup,1',0,0,''),(105,'550-CON-20171019-BVOZ-LINEAOCUPADA-ESP-5589958532',197,0,'app-blackhole,hangup,1',0,0,''),(106,'564-PRO-20171020-BVOZ-LINEASUSPENDIDA-ESP-55899585',197,0,'app-blackhole,hangup,1',0,0,''),(107,'580-EJT-20171020-BVOZ-LINEAOCUPADA-ESP-8147370237',58,0,'ext-local,vms8147370237,1',0,0,''),(108,'581-ENG-20171020-BVOZ-LINEAOCUPADA-ESP-8147370238',58,0,'ext-local,vms8147370238,1',0,0,''),(109,'576-QUA-20171020-BVOZ-LINEAOCUPADA-ESP-8147370231',58,0,'ext-local,vms8147370231,1',0,0,''),(110,'578-KBD-20171020-BVOZ-LINEAOCUPADA-ESP-8147370232',58,0,'ext-local,vms8147370232,1',0,0,''),(111,'536-COM-20171020-BVOZ-FUERADESERVICIO-ESP-81473702',197,0,'app-blackhole,hangup,1',0,0,''),(112,'554-COM-20171020-BVOZ-LINEAOCUPADA-ESP-8147370218',197,0,'app-blackhole,hangup,1',0,0,''),(113,'109-HCR-20171026-BVOZ-LINEAOCUPADA-ESP-8147370216',58,0,'ext-local,vms8147370216,1',0,0,''),(114,'1421-FIV-20211015-BVOZ-LINEAOCUPADA-8177700108',58,0,'ext-local,vms8177700108,1',0,0,''),(115,'126-CON-20171026-BVOZ-LINEAOCUPADA-ESP-8177700109',58,0,'ext-local,vms8177700109,1',0,0,''),(116,'1289-AHE-20210316-BVOZ-LINEAOCUPADA-ESP-8177700110',58,0,'ext-local,vms8177700110,1',0,0,''),(117,'346-SMA-20171026-BVOZ-FUERADESERVICIO-ESP-81777001',197,0,'app-blackhole,hangup,1',0,0,''),(118,'359-PRO-20171016-BVOZ-LINEAOCUPADA-ESP-8177700116',197,0,'app-blackhole,hangup,1',0,0,''),(119,'352-STG-20201126-BVOZ-LINEAOCUPADA-ESP-8177700117',58,0,'ext-local,vms8177700117,1',0,0,''),(120,'757-ALE-20210901-VBOZ-LINEAOUPADA-ESP-8177700118',58,0,'ext-local,vms8177700118,1',0,0,''),(121,'1334-LEA-20210322-BVOZ-LINEAOCUPADA-ESP-8177700119',197,0,'app-blackhole,hangup,1',0,0,''),(122,'1351-SOL-20210305-BVOZ-LINEAOCUPADA-ESP-8177700120',58,0,'ext-local,vms8177700120,1',0,0,''),(123,'476-HER-20171027-BVOZ-LINEAOCUPADA-ESP-8177700121',58,0,'ext-local,vms8177700121,1',0,0,''),(124,'495-COM-20171027-BVOZ-LINEAOCUPADA-ESP-8177700122',58,0,'ext-local,vms8177700122,1',0,0,''),(125,'496-SER-20171027-BVOZ-LINEAOCUPADA-ESP-8177700123',58,0,'ext-local,vms8177700123,1',0,0,''),(287,'927-NAT-20190225-BVOZ-LINEAOCUPADA-ESP-8177701575',197,0,'app-blackhole,hangup,1',0,0,''),(350,'1294-WOR-20210128-BVOZ-LINEAOCUPADA-ESP-8147773892',58,0,'ext-local,vms8147773892,1',0,0,''),(129,'677-ESP-20171016-BVOZ-LINEAOCUPADA-9847770191',58,0,'ext-local,vms9847770191,1',0,0,''),(131,'1425-cle-20211004-BVOZ-LINEAOCUPADA-ESP-8177700124',58,0,'ext-local,vms8177700124,1',0,0,''),(132,'601-LAC-20180613-BVOZ-LINEAOCUPADA-ESP-81473702',197,0,'app-blackhole,hangup,1',0,0,''),(133,'551-LEI-20171101-BVOZ-LINEAOCUPADA-ESP-2226443774',197,0,'app-blackhole,hangup,1',0,0,''),(134,'809-CON-20180828-BVOZ-LINEAOCUPADA-ESP-8177700360',58,0,'ext-local,vms8177700360,1',0,0,''),(135,'1430-ARR-20211004-BVOZ-LINEAOCUPADA-ESP-8177700361',58,0,'ext-local,vms8177700361,1',0,0,''),(136,'61-GOY-20171102-BVOZ-LINEAOCUPADA-ESP-8177700362',58,0,'ext-local,vms8177700362,1',0,0,''),(137,'292-KEE-20171103-BVOZ-LINEAOCUPADA-ESP-8177700363',197,0,'app-blackhole,hangup,1',0,0,''),(138,'419-AVE-20171103-BVOZ-LINEAOCUPADA-ESP-8177700376',58,0,'ext-local,vms8177700376,1',0,0,''),(139,'1236-HIP-20200703-BVOZ-LINEAOCUPADA-ESP-8177700365',58,0,'ext-local,vms8177700365,1',0,0,''),(140,'1446-HID-20211029-BVOZ-LINEAOCUPADA-ESP-8177700366',58,0,'ext-local,vms8177700366,1',0,0,''),(141,'130-CON-20210615-BVOZ-LINEAOCUPADA-ESP-8177700367',58,0,'ext-local,vms8177700367,1',0,0,''),(142,'1234-FHA-20200703-BVOZ-LINEAOCUPADA-ESP-8177700368',58,0,'ext-local,vms8177700368,1',0,0,''),(143,'498-TIM-20171103-BVOZ-LINEAOCUPADA-ESP-8177700369',58,0,'ext-local,vms8177700369,1',0,0,''),(144,'516-COM-20171103-BVOZ-LINEAOCUPADA-ESP-8177700371',128,0,'ext-local,vms8177700371,1',0,0,''),(145,'1451-TER-20211029-BVOZ-LINEAOCUPADA-ESP-8177700372',58,0,'ext-local,vms8177700372,1',0,0,''),(146,'1449-DIN-20211029-BVOZ-LINEAOCUPADA-ESP-8177700373',58,0,'ext-local,vms8177700373,1',0,0,''),(147,'1178-SOL-20200210-BVOZ-LINEAOCUPADA-ESP-8177700374',58,0,'ext-local,vms8177700374,1',0,0,''),(148,'1273-SIJ-20201021-BVOZ-LINEAOCUPADA-ESP-8177700375',58,0,'ext-local,vms8177700375,1',0,0,''),(149,'508-DLT-20171103-BVOZ-LINEAOCUPADA-ESP-8177700370',197,0,'app-blackhole,hangup,1',0,0,''),(174,'1-BKP-20180122-PROSPECTO-LINEAEMPRESARIAL-ESP-8177',177,0,'ext-queues,28177700100,1',0,0,''),(151,'565-SAV-20171107-BVOZ-LINEAOCUPADA-ESP-8177700364',197,0,'app-blackhole,hangup,1',0,0,''),(152,'513-NOV-20171107-BVOZ-LINEAOCUPADA-ESP-8177700378',58,0,'ext-local,vms8177700378,1',0,0,''),(168,'655-CAM-20180109-OPCION-2-ESP-8177700388',171,0,'ext-group,663,1',0,0,''),(167,'655-CAM-20180109-OPCION-1-ESP-8177700388',170,0,'ext-group,661,1',0,0,''),(155,'833-INT-20181008-BVOZ-LINEAOCUPADA-ESP-8177700381',58,0,'ext-local,vms8177700381,1',0,0,''),(156,'1256-INS-20201021-BVOZ-FUERADESERVICIO-ESP-8177700',58,0,'ext-local,vms8177700382,1',0,0,''),(157,'187-HCP-20171108-BVOZ-LINEAOCUPADA-ESP-8177700383',197,0,'app-blackhole,hangup,1',0,0,''),(161,'634-LAM-20171124-BVOZ-FUERADESERVICIO-ESP-98477701',197,0,'app-blackhole,hangup,1',0,0,''),(162,'1-BKP-20171127-PROSPECTO-GRACIAS-ESP-8177700100-1',154,0,'ext-queues,18177700100,1',0,0,''),(163,'1-BKP-20171127-PROSPECTO-GRACIAS-ESP-8177700100-2',154,0,'ext-queues,48177700100,1',0,0,''),(164,'1-BKP-20171127-PROSPECTO-GRACIAS-ESP-8177700100-3',154,0,'ext-queues,48177700100,1',0,0,''),(165,'1-BKP-20171128-PROSPECTO-NO-SELECCION-ESP-81777001',153,0,'ext-queues,58177700100,1',0,0,''),(166,'637-CON-20171130-BVOZ-LINEAOCUPADA-ESP-8177700386',58,0,'ext-local,vms8177700386,1',0,0,''),(169,'655-CAM-20180109-OPCION-3-ESP-8177700388',172,0,'ext-group,664,1',0,0,''),(170,'655-CAM-20180109-OPCION-4-ESP-8177700388',173,0,'ext-group,665,1',0,0,''),(171,'655-CAM-20180109-OPCION-5-ESP-8177700388',174,0,'ext-group,667,1',0,0,''),(172,'657-ACI-20180109-BVOZ-FUERADESERVICIO-ESP-81777003',197,0,'app-blackhole,hangup,1',0,0,''),(173,'658-SEG-20180109-BVOZ-LINEAOCUPADA-8147370221',197,0,'app-blackhole,hangup,1',0,0,''),(175,'1-BKP-20180122-PROSPECTO-ESPACIOFISICO-ESP-8177700',178,0,'ext-queues,38177700100,1',0,0,''),(176,'1-BKP-20180122-PROSPECTO-OFICINAVIRTUAL-ESP-817770',176,0,'ext-queues,48177700100,1',0,0,''),(177,'1-BKP-20180123-ENLACEAGENTE-ESP-8177700100',179,0,'ext-group,639,1',0,0,''),(178,'1-BKP-20180123-ENLACEAGENTE-ING-8177700100',183,0,'ext-queues,198177700100,1',0,0,''),(179,'1-BKP-20180123-SINSELECCION-ESP-8177700100',182,0,'ext-queues,188177700100,1',0,0,''),(180,'1-BKP-20180123-LINEAEMPR-ESP-8177700100',179,0,'ext-queues,108177700100,1',0,0,''),(181,'1-BKP-20180123-OFICINAFISICA-ESP-8177700100',179,0,'ext-queues,118177700100,1',0,0,''),(182,'1-BKP-20180123-DOMICILIOCOMERCIAL-ESP-8177700100',179,0,'ext-queues,128177700100,1',0,0,''),(183,'1-BKP-20180124-ENLACEAGENTE-ESP-5588804680',179,0,'ext-group,673,1',0,0,''),(184,'1-BKP-20180124-ENLACEAGENTE-ING-5588804680',183,0,'ext-queues,195588804680,1',0,0,''),(185,'1-BKP-20180124-SINSELECCION-ESP-5588804680',182,0,'ext-queues,185588804680,1',0,0,''),(186,'1-BKP-20180124-LINEAEMPR-ESP-5588804680',179,0,'ext-queues,105588804680,1',0,0,''),(187,'1-BKP-20180124-OFICINAFISICA-ESP-5588804680',179,0,'ext-queues,115588804680,1',0,0,''),(188,'1-BKP-20180124-DOMICILIOCOMERCIAL-ESP-5588804680',179,0,'ext-queues,125588804680,1',0,0,''),(189,'1-BKP-20180124-ENLACEAGENTE-ESP-3335605355',179,0,'ext-group,680,1',0,0,''),(190,'1-BKP-20180124-ENLACEAGENTE-ING-3335605355',183,0,'ext-queues,193335605355,1',0,0,''),(191,'1-BKP-20180124-SINSELECCION-ESP-3335605355',182,0,'ext-queues,183335605355,1',0,0,''),(192,'1-BKP-20180124-LINEAEMPR-ESP-3335605355',179,0,'ext-queues,103335605355,1',0,0,''),(193,'1-BKP-20180124-OFICINAFISICA-ESP-3335605355',179,0,'ext-queues,113335605355,1',0,0,''),(194,'1-BKP-20180124-DOMICILIOCOMERCIAL-ESP-3335605355',179,0,'ext-queues,123335605355,1',0,0,''),(195,'670-RHS-20180201-BVOZ-LINEAOCUPADA-ESP-8177700387',58,0,'ext-local,vms8177700387,1',0,0,''),(196,'665-CAM-20180201-BVOZ-LINEAOCUPADA-ESP-8177700389',197,0,'app-blackhole,hangup,1',0,0,''),(197,'830-COR-20181004-BVOZ-FUERADESERVICIO-ESP-81777006',197,0,'app-blackhole,hangup,1',0,0,''),(207,'696-JIR-20180308-BVOZ-FUERADESERVICIO-ESP-81777006',197,0,'app-blackhole,hangup,1',0,0,''),(199,'491-MAX-20190131-BVOZ-LINEAOCUPADA-ESP-81777006',58,0,'ext-local,vms8177700674,1',0,0,''),(200,'914-LEG-20190130-BVOZ-FUERADESERVICIO-ESP-81777006',197,0,'app-blackhole,hangup,1',0,0,''),(201,'831-COM-20181004-BVOZ-LINEAOCUPADA-ESP-8177700672',58,0,'ext-local,vms8177700672,1',0,0,''),(202,'0-AGE-20180208-ENLACEAGENTE-ESP-8177700670',195,0,'ext-queues,18177700670,1',0,0,''),(203,'0-AGE-20180208-OPCION-1-ESP-8177700670',192,0,'ext-queues,18177700670,1',0,0,''),(204,'0-AGE-20180208-OPCION-2-ESP-8177700670',193,0,'ext-queues,18177700670,1',0,0,''),(205,'0-AGE-20180208-OPCION-3-ESP-8177700670',194,0,'ext-queues,18177700670,1',0,0,''),(206,'676-PRO-20180208-BVOZ-LINEAOCUPADA-ESP-81777006',196,0,'ext-local,vms8177700675,1',0,0,''),(208,'743-SER-20180604-BVOZ-LINEAOCUPADA-ESP-8177700377	',197,0,'app-blackhole,hangup,1',0,0,''),(211,'669-ESP-20180322-BVOZ-LINEAOCUPADA-ESP-8177700677',197,0,'app-blackhole,hangup,1',0,0,''),(212,'700-CON-20180322-BVOZ-LINEAOCUPADA-ESP-8177700678',58,0,'ext-local,vms8177700678,1',0,0,''),(213,'701-REC-20180322-BVOZ-FUERADESERVICIO-ESP-81777006',197,0,'app-blackhole,hangup,1',0,0,''),(214,'702-SER-20180322-BVOZ-LINEAOCUPADA-ESP-8177700680',197,0,'app-blackhole,hangup,1',0,0,''),(215,'703-ACT-20180322-BVOZ-LINEAOCUPADA-ESP-8177700681',58,0,'ext-local,vms8177700681,1',0,0,''),(216,'705-FDS-20180326-BVOZ-LINEAOCUPADA-ESP-8177700682',58,0,'ext-local,vms8177700682,1',0,0,''),(217,'1227-VIB-20200606-BVOZ-LINEAOCUPADA-ESP-8177700683',197,0,'app-blackhole,hangup,1',0,0,''),(218,'1068-JJS-20190815-BVOZ-LINEAOCUPADA-ESP-8177700684',197,0,'app-blackhole,hangup,1',0,0,''),(219,'710-CRE-20180410-BVOZ-FUERADESERVICIO-ESP-81777006',197,0,'app-blackhole,hangup,1',0,0,''),(220,'839-CET-20181023-BVOZ-LINEAOCUPADA-8177700686',58,0,'ext-local,vms8177700686,1',0,0,''),(221,'714-GII-20180419-BVOZ-LINEAOCUPADA-ESP-8177700687',58,0,'ext-local,vms8177700687,1',0,0,''),(222,'278-OLM-20200212-BVOZ-LINEAOCUPADA-ESP-8177700688',58,0,'ext-local,vms8177700688,1',0,0,''),(223,'717-GLO-20180423-BVOZ-LINEAOCUPADA-ESP-8177700689',58,0,'ext-local,vms8177700689,1',0,0,''),(224,'730-MEC-20180508-BVOZ-LINEAOCUPADA-ESP-8177700691',197,0,'app-blackhole,hangup,1',0,0,''),(225,'722-MAS-20180511-BVOZ-LINEAOCUPADA-ESP-8177700106',197,0,'app-blackhole,hangup,1',0,0,''),(226,'733-COF-BVOZ-FUERADESERVICIO-ESP-8177700692',197,0,'app-blackhole,hangup,1',0,0,''),(227,'RESERVACIONES-20180516-BVOZ-LINEAOCUPA',58,0,'ext-local,vms3388800131,1',0,0,''),(228,'1-FIS-20180604-VENTA-ESP-8147370215',220,0,'ext-queues,18147370215,1',0,0,''),(229,'1-FIS-20180604-SOPORTE-ESP-8147370215',220,0,'ext-queues,28147370215,1',0,0,''),(230,'750-EXP-20180613-BVOZ-LINEAOCUPADA-ESP-8177700693',197,0,'app-blackhole,hangup,1',0,0,''),(231,'751-CIN-20180613-BVOZ-FUERADESERVICIO-ESP-81777006',197,0,'app-blackhole,hangup,1',0,0,''),(232,'752-NOX-20180613-BVOZ-LINEAOCUPADA-ESP-8177700694',197,0,'app-blackhole,hangup,1',0,0,''),(233,'768-SOP-20180706-BVOZ-FUERADESERVICIO-ESP-81473702',197,0,'app-blackhole,hangup,1',0,0,''),(234,'770-GRU-20180717-BVOZ-LINEAOCUPADA-ESP-8177700696',58,0,'ext-local,vms8177700696,1',0,0,''),(235,'779-DES-20180717-BVOZ-LINEAOCUPADA-ESP-9847770194',58,0,'ext-local,vms9847770194,1',0,0,''),(236,'781-SEC-20180717-BVOZ-LINEAOCUPADA-ESP-8177700697',58,0,'ext-local,vms8177700697,1',0,0,''),(237,'1-FIS-20180724-BVOZ-ESP-5588804685',21,0,'ext-local,vms5588804685,1',0,0,''),(238,'783-SOL-20180808-BVOZ-LINEAOCUPADA-ESP-8177700698',58,0,'ext-local,vms8177700698,1',0,0,''),(244,'807-HEL-20180903-BVOZ-LINEAOCUPADA-ESP-5589958535',197,0,'app-blackhole,hangup,1',0,0,''),(242,'753-DES-20180827-BVOZ-LINEAOCUPADA-ESP-8177701551',197,0,'app-blackhole,hangup,1',0,0,''),(243,'2-BODAPERLAYGUILLERMO-20180827-LINEAOCUPADA-ESP',58,0,'app-blackhole,hangup,1',0,0,''),(245,'635-VAT-20181029-BVOZ-FUERADESERVICIO-ESP-81777015',58,0,'app-blackhole,hangup,1',0,0,''),(246,'1046-ERP-20181019-BVOZ-LINEAOCUPADA-ESP-9847770195',197,0,'app-blackhole,hangup,1',0,0,''),(247,'854-TEC-20181102-BVOZ-LINEAOCUPADA-ESP-8177701553',58,0,'ext-local,vms8177701553,1',0,0,''),(248,'855-BUS-20181106-BVOZ-FUERADESERVICIO-ESP-81777015',197,0,'app-blackhole,hangup,1',0,0,''),(249,'851-SEG-20181107-BVOZ-LINEAOCUPADA-ESP-8147370234',197,0,'app-blackhole,hangup,1',0,0,''),(250,'871-SER-20181121-BVOZ-LINEAOCUPADA-ESP-9847770196',58,0,'ext-local,vms9847770196,1',0,0,''),(251,'863-MKT-20181121-BVOZ-LINEAOCUPADA-ESP-8718800156',58,0,'ext-local,vms8718800151,1',0,0,''),(252,'868-ROM-20181121-BVOZ-FUERADESERVICIO-ESP-87188001',197,0,'app-blackhole,hangup,1',0,0,''),(253,'872-VAL-20181122-BVOZ-LINEAOCUPADA-ESP-8177700379',58,0,'ext-local,vms8177700379,1',0,0,''),(254,'874-SIT-20181128-BVOZ-LINEAOCUPADA-ESP-8177701556',197,0,'app-blackhole,hangup,1',0,0,''),(255,'875-PLA-20181128-BVOZ-LINEAOCUPADA-ESP-8177701555',197,0,'app-blackhole,hangup,1',0,0,''),(256,'PRUEBA-20190221-5588804682',58,0,'ext-local,vms5588804682,1',0,0,''),(257,'878-SOL-2018123-BVOZ-LINEAOCUPADA-ESP-8177701558',58,0,'ext-local,vms8177701558,1',0,0,''),(258,'213-BAM-20181203-BVOZ-LINEAOCUPADA-ESP-8177700379',58,0,'ext-local,vms8177700379,1',0,0,''),(259,'880-VER-20181204-BVOZ-LINEAOCUPADA-ESP-8177701557',197,0,'app-blackhole,hangup,1',0,0,''),(260,'879-SOC-20181204-BVOZ-LINEAOCUPADA-ESP-8177701559',58,0,'ext-local,vms8177701559,1',0,0,''),(261,'791-FOO-20181205-BVOZ-LINEAOCUPADA-ESP-8177701560',58,0,'ext-local,vms8177701560,1',0,0,''),(262,'881-MAI-20181205-BVOZ-FUERADESERVICIO-ESP-81777015',197,0,'app-blackhole,hangup,1',0,0,''),(263,'882-ALB-20181211-BVOZ-FUERADESERVICIO-ESP-81777015',197,0,'app-blackhole,hangup,1',0,0,''),(264,'11-INDUSTRIASWELLER-20190913-BVOZ-LINEAOCUPADA-ES',58,0,'ext-local,vms5588804681,1',0,0,''),(265,'1-VIS-20181221-BVOZ-LINEAOCUPADA-ESP-8177701563',58,0,'ext-local,vms8177701563,1',0,0,''),(266,'888-LMS-20181227-BVOZ-LINEAOCUPADA-ESP-8177701562',58,0,'ext-local,vms8177701562,1',0,0,''),(267,'1313-SOL-20210302-BVOZ-LINEAOCUPADA-ESP-8177701564',197,0,'app-blackhole,hangup,1',0,0,''),(268,'918-MAR-20210302-BVOZ-FUERADESERVICIO-ESP-81777015',58,0,'ext-local,vms8177701565,1',0,0,''),(269,'1-BKP-RESERVACION-20190122-BVOZ-LINEAOCUPADA-ESP-5',58,0,'ext-local,vms5588804680,1',0,0,''),(270,'904-LVM-20190123-BVOZ-LINEAOCUPADA-ESP-9988001966',58,0,'ext-local,vms9988001966,1',0,0,''),(271,'904-LVM-20190123-9988001966',197,0,'app-blackhole,hangup,1',0,0,''),(272,'911-BMS-20190123-BVOZ-LINEAOCUPADA-ESP-8177701566',197,0,'app-blackhole,hangup,1',0,0,''),(273,'908-HER-20190123-BVOZ-LINEAOCUPADA-ESP-8177701567',58,0,'ext-local,vms8177701567,1',0,0,''),(274,'909-ROJ-20190123-BVOZ-LINEAOCUPADA-ESP-8177701568',58,0,'ext-local,vms8177701568,1',0,0,''),(275,'129-MUL-20190124-BVOZ-LINEAOCUPADA-ESP-8177701569',197,0,'app-blackhole,hangup,1',0,0,''),(276,'322-AAA-20190128-BVOZ-LINEAOCUPADA-ESP-8718800153',58,0,'ext-local,vms8718800153,1',0,0,''),(277,'906-REG-20190131-BVOZ-LINEAOCUPADA-8177701570',197,0,'app-blackhole,hangup,1',0,0,''),(278,'907-SKY-20190131-BVOZ-LINEAOCUPADA-8177701571',197,0,'app-blackhole,hangup,1',0,0,''),(279,'729-COO-20190207-BVOZ-LINEAOCUPADA-8177701573',58,0,'ext-local,vms8177701573,1',0,0,''),(280,'729-ATT-20190207-BVOZ-LINEAOCUPADA-8177701573',58,0,'ext-local,vms8177701574,1',0,0,''),(281,'1-EVA-20190208-BVOZ-LINEAOCUPADA-3388800131',197,0,'app-blackhole,hangup,1',0,0,''),(282,'1-EVA-20190208-BVOZ-LINEAOCUPADA-3335605354',197,0,'app-blackhole,hangup,1',0,0,''),(283,'569-ZAF-20190218-BVOZ-LINEAOCUPADA-ESP-9847770197',197,0,'app-blackhole,hangup,1',0,0,''),(284,'BK-FB-BVOZ-LINEAOCUPADA-20190307-8177700699',58,0,'ext-local,vms8177700699,1',0,0,''),(285,'925-TIT-20190222-BVOZ-LINEAOCUPADA--ESP-9988001967',58,0,'ext-local,vms9988001967,1',0,0,''),(286,'926-TRI-20190222-BVOZ-LINEAOCUPADA-ESP-8177701579',197,0,'app-blackhole,hangup,1',0,0,''),(290,'931-GEN-20190225-BVOZ-LINEAOCUPADA-ESP-8177701578',197,0,'app-blackhole,hangup,1',0,0,''),(291,'935-NEW-20190227-BVOZ-LINEAOCUPADA-ESP-8147773870',197,0,'app-blackhole,hangup,1',0,0,''),(292,'910-OFF-20190227-BVOZ-LINEAOCUPADA-ESP-8147773871',197,0,'app-blackhole,hangup,1',0,0,''),(293,'937-QUI-20190301-BVOZ-LINEAOCUPADA-ESP-8177700377',58,0,'ext-local,vms8177700377,1',0,0,''),(294,'355-PER-20190315-BVOZ-LINEAOCUPADA-ESP-8147773872',197,0,'app-blackhole,hangup,1',0,0,''),(295,'328-VER-20190315-BVOZ-LINEAOCUPADA-ESP-8147370229',197,0,'app-blackhole,hangup,1',0,0,''),(296,'956-HVA-20190319-BVOZ-LINEAOCUPADA-ESP-8147773873',58,0,'ext-local,vms8147773873,1',0,0,''),(297,'10-CIN-20190401-BVOZ-LINEAOCUPADA-ESP-5588804684',58,0,'ext-local,vms5588804684,1',0,0,''),(298,'964-SPW-20190403-BVOZ-LINEAOCUPADA-ESP-8147773874',197,0,'app-blackhole,hangup,1',0,0,''),(299,'973-MGP-20190403-BVOZ-LINEAOCUPADA-ESP-8147773875',197,0,'app-blackhole,hangup,1',0,0,''),(300,'983-MOR-20190430-BVOZ-LINEAOCUPADA-ESP-8147773877',197,0,'app-blackhole,hangup,1',0,0,''),(301,'986-DEC-20190430-BVOZ-LINEAOCUPADA-ESP-8147773876',58,0,'ext-local,vms8147773876,1',0,0,''),(302,'998-HIG-20190503-BVOZ-LINEAOCUPADA-ESP-8147773878',58,0,'ext-local,vms8147773878,1',0,0,''),(303,'1001-IND-20190514-BVOZ-LINEAOCUPADA-ESP-8147773879',58,0,'ext-local,vms8147773879,1',0,0,''),(304,'1008-TOP-20190517-BVOZ-FUERADESERVICIO-ESP-8147773',197,0,'app-blackhole,hangup,1',0,0,''),(305,'795-TIT-20190520-BVOZ-LINEAOCUPADA-ESP-8177702604',197,0,'app-blackhole,hangup,1',0,0,''),(348,'1243-IRE-20201002-BVOZ-LINEAOCUPADA-ESP-8177700116',58,0,'ext-local,vms8177700116,1',0,0,''),(307,'12-CIN-20190521-BVOZ-LINEAOCUPADA-ESP-3335605356',197,0,'app-blackhole,hangup,1',0,0,''),(308,'12-BODAANAYEDUARDO-20190524-BVOZ-LINEAOCUPADA-ESP-',197,0,'app-blackhole,hangup,1',0,0,''),(309,'1016-GIH-20190529-BVOZ-LINEAOCUPADA-ESP-8147773882',197,0,'app-blackhole,hangup,1',0,0,''),(310,'1009-AME-20190613-BVOZ-LINEAOCUPADA-ESP-8147773884',58,0,'ext-local,vms8147773884,1',0,0,''),(311,'1026-DEN-20190613-BVOZ-FUERADESERVICIO-ESP-8147773',197,0,'app-blackhole,hangup,1',0,0,''),(312,'1341-JEV-20210421-BVOZ-LINEAOCUPADA-ESP-8147773887',197,0,'app-blackhole,hangup,1',0,0,''),(322,'1100-FOO-20191002-BVOZ-LINEAOCUPADA-ESP-8447770070',197,0,'app-blackhole,hangup,1',0,0,''),(313,'1-FIS-20190709-BVOZ-LINEAOCUPADA-ESP-5589958534',58,0,'ext-local,vms5589958534,1',0,0,''),(314,'1054-VIN-20190724-BVOZ-LINEAOCUPADA-ESP-5588804687',58,0,'ext-local,vms5588804687,1',0,0,''),(315,'1039-SHI-20190712-BVOZ-LINEAOCUPADA-ESP-8147773888',58,0,'ext-local,vms8147773888,1',0,0,''),(316,'1042-MEV-20190712-BVOZ-LINEAOCUPADA-ESP-8147773889',58,0,'ext-local,vms8147773889,1',0,0,''),(317,'1047-SOL-20190722-BVOZ-FUERADESERVICIO-ESP-5589958',197,0,'app-blackhole,hangup,1',0,0,''),(318,'1047-SOL-20190722-BVOZ-FUERADESERVICIO-ESP-3335605',197,0,'app-blackhole,hangup,1',0,0,''),(319,'1034-ULT-20190729-BVOZ-LINEAOCUPADA-ESP-8177700113',58,0,'ext-local,vms8177700113,1',0,0,''),(321,'5-COO-20190827-BVOZ-LINEAOCUPADA-ESP-2228800361',197,0,'app-blackhole,hangup,1',0,0,''),(323,'1-GLO-20191021-BVOZ-LINEAOCUPADA-ESP-8177702600',58,0,'ext-local,vms8177702600,1',0,0,''),(324,'1-TEK-20191023-BVOZ-LINEAOCUPADA-ESP-8177702601',58,0,'ext-local,vms8177702601,1',0,0,''),(325,'1114-GRU-20191108-BVOZ-LINEAOCUPADA-ESP-5588804688',58,0,'ext-local,vms5588804688,1',0,0,''),(326,'1-GLO-20191021-OPCION-9-ING-8177702600',361,0,'ext-queues,18177702600,1',0,0,''),(327,'1-TEK-20211020-OPCION-9-ING-8177702601',451,0,'ext-queues,18177702601,1',0,0,''),(328,'1-BKV-20191112-BVOZ-LINEAOCUPADA-ESP-8147370224',58,0,'ext-local,vms8147370224,1',0,0,''),(329,'1124-ARR-20191112-BVOZ-LINEAOCUPADA-ESP-8177702603',58,0,'ext-local,vms8177702603,1',0,0,''),(330,'1126-OCA-20191113-BVOZ-LINEAOCUPADA-ESP-4428880131',197,0,'app-blackhole,hangup,1',0,0,''),(331,'628-PRI-20191122-BVOZ-LINEAOCUPADA-ESP-8177700106',58,0,'ext-local,vms8177700106,1',0,0,''),(332,'994-FOR-20191231-BVOZ-LINEAOCUPADA-ESP-8177700107',58,0,'ext-local,vms8177700107,1',0,0,''),(333,'1139-BIZ-20200117-BVOZ-LINEAOCUPADA-ESP-8177700115',58,0,'ext-local,vms8177700115,1',0,0,''),(334,'920-DIH-20200117-BVOZ-LINEAOCUPADA-ESP-5589958532',197,0,'app-blackhole,hangup,1',0,0,''),(335,'1166-EXP-20200122-BVOZ-LINEAOCUPADA-ESP-2226443774',58,0,'ext-local,vms2226443774,1',0,0,''),(336,'1-OC-INF-20200310-BVOZ-LINEAOCUPADA-ESP-4428880130',197,0,'app-blackhole,hangup,1',0,0,''),(337,'2-OC-ARE-20200318-BVOZ-LINEAOCUPADA-ESP-4428880132',197,0,'app-blackhole,hangup,1',0,0,''),(338,'1-MBB-20200330-BVOZ-LINEAOCUPADA-ESP-8177702605',58,0,'ext-local,vms8177702605,1',0,0,''),(339,'1-MBB-20200330-BVOZ-LINEAOCUPADA-ESP-5547776691',58,0,'ext-local,vms5547776691,1',0,0,''),(340,'1-MBB-20200330-BVOZ-LINEAOCUPADA-ESP-3388801850',58,0,'ext-local,vms3388801850,1',0,0,''),(341,'1221-CAP-20200417-BVOZ-LINEAOCUPADA-3388800134',58,0,'ext-local,vms3388800134,1',0,0,''),(342,'1220-FOR-20200421-BVOZ-LINEAOCUPADA-ESP-8177701571',197,0,'app-blackhole,hangup,1',0,0,''),(343,'754-INM-20200429-BVOZ-LINEAOCUPADA-ESP-8177700363',58,0,'ext-local,vms8177700363,1',0,0,''),(344,'13-RET-20200429-BVOZ-LINEAOCUPADA-ESP-5588804682',197,0,'app-blackhole,hangup,1',0,0,''),(345,'14-SOL-20200429-BVOZ-LINEAOCUPADA-ESP-5588804683',58,0,'ext-local,vms5588804683,1',0,0,''),(346,'16-VAL-20200429-BVOZ-LINEAOCUPADA-ESP-5588804684',197,0,'app-blackhole,hangup,1',0,0,''),(347,'1-BKP-20200507-BVOZ-LINEAOCUPADA-ESP-8177700388',58,0,'ext-local,vms8177700388,1',0,0,''),(349,'3-OC-BIE-20201030-BVOZ-LINEAOCUPADA-ESP-4428880133',197,0,'app-blackhole,hangup,1',0,0,''),(353,'1343-DR8-20210421-BVOZ-LINEAOCUPADA-ESP-8177702606',58,0,'ext-local,vms8177702606,1',0,0,'');
/*!40000 ALTER TABLE `announcement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup`
--

LOCK TABLES `backup` WRITE;
/*!40000 ALTER TABLE `backup` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup_cache`
--

LOCK TABLES `backup_cache` WRITE;
/*!40000 ALTER TABLE `backup_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup_details`
--

LOCK TABLES `backup_details` WRITE;
/*!40000 ALTER TABLE `backup_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup_items`
--

LOCK TABLES `backup_items` WRITE;
/*!40000 ALTER TABLE `backup_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup_old`
--

LOCK TABLES `backup_old` WRITE;
/*!40000 ALTER TABLE `backup_old` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_old` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup_server_details`
--

LOCK TABLES `backup_server_details` WRITE;
/*!40000 ALTER TABLE `backup_server_details` DISABLE KEYS */;
INSERT INTO `backup_server_details` (`server_id`, `key`, `value`) VALUES (1,'path','__ASTVARLIBDIR__/backups'),(2,'path','__ASTSPOOLDIR__/backup'),(3,'host','__AMPDBHOST__'),(3,'port','3306'),(3,'user','__AMPDBUSER__'),(3,'dbname','__AMPDBNAME__'),(3,'password','__AMPDBPASS__'),(4,'host','__CDRDBHOST__'),(4,'port','__CDRDBPORT__'),(4,'user','__CDRDBUSER__'),(4,'dbname','__CDRDBNAME__'),(4,'password','__CDRDBPASS__');
/*!40000 ALTER TABLE `backup_server_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup_servers`
--

LOCK TABLES `backup_servers` WRITE;
/*!40000 ALTER TABLE `backup_servers` DISABLE KEYS */;
INSERT INTO `backup_servers` (`id`, `name`, `desc`, `type`, `readonly`, `immortal`, `data`) VALUES (1,'Legacy Backup','Location of backups pre 2.10','local','a:1:{i:0;s:1:\"*\";}','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}'),(2,'Local Storage','Storage location for backups','local','a:1:{i:0;s:1:\"*\";}','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}'),(3,'Config server','PBX config server, generally a local database server','mysql','a:1:{i:0;s:1:\"*\";}','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}'),(4,'CDR server','CDR server, generally a local database server','mysql','a:1:{i:0;s:1:\"*\";}','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}');
/*!40000 ALTER TABLE `backup_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup_template_details`
--

LOCK TABLES `backup_template_details` WRITE;
/*!40000 ALTER TABLE `backup_template_details` DISABLE KEYS */;
INSERT INTO `backup_template_details` (`template_id`, `type`, `path`, `exclude`) VALUES (1,'mysql','server-3','a:1:{i:0;s:0:\"\";}'),(1,'astdb','','a:1:{i:0;s:0:\"\";}'),(2,'mysql','server-3','a:1:{i:0;s:0:\"\";}'),(2,'astdb','','a:1:{i:0;s:0:\"\";}'),(2,'mysql','server-4','a:1:{i:0;s:0:\"\";}'),(2,'dir','__ASTETCDIR__','a:1:{i:0;s:0:\"\";}'),(2,'dir','__AMPWEBROOT__','a:1:{i:0;s:0:\"\";}'),(2,'dir','__AMPBIN__','a:2:{i:0;s:20:\"__ASTVARLIBDIR__/moh\";i:1;s:23:\"__ASTVARLIBDIR__/sounds\";}'),(2,'dir','/etc/dahdi','a:1:{i:0;s:0:\"\";}'),(3,'mysql','server-4','a:1:{i:0;s:0:\"\";}'),(4,'dir','__ASTSPOOLDIR__/voicemail','a:1:{i:0;s:0:\"\";}'),(5,'dir','__ASTVARLIBDIR__/moh','a:1:{i:0;s:0:\"\";}'),(5,'dir','__ASTVARLIBDIR__/sounds/custom','a:1:{i:0;s:0:\"\";}'),(6,'mysql','server-3','a:9:{i:0;s:6:\"backup\";i:1;s:12:\"backup_cache\";i:2;s:14:\"backup_details\";i:3;s:12:\"backup_items\";i:4;s:21:\"backup_server_details\";i:5;s:14:\"backup_servers\";i:6;s:23:\"backup_template_details\";i:7;s:16:\"backup_templates\";i:8;s:0:\"\";}');
/*!40000 ALTER TABLE `backup_template_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `backup_templates`
--

LOCK TABLES `backup_templates` WRITE;
/*!40000 ALTER TABLE `backup_templates` DISABLE KEYS */;
INSERT INTO `backup_templates` (`id`, `name`, `desc`, `immortal`, `data`) VALUES (1,'Config Backup','Configurations only','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}'),(2,'Full Backup','A full backup of core settings and web files, dosen\'t include system sounds or recordings.','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}'),(3,'CDR\'s','Call Detail Records','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}'),(4,'Voice Mail','Voice Mail Storage','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}'),(5,'System Audio','All system audio - including IVR prompts and Music On Hold. DOES NOT BACKUP VOICEMAIL','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}'),(6,'Exclude Backup Settings','Exclude Backup\'s settings so that they dont get restored, usefull for a remote restore','true','a:1:{s:10:\"created_by\";s:11:\"install.php\";}');
/*!40000 ALTER TABLE `backup_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `callback`
--

LOCK TABLES `callback` WRITE;
/*!40000 ALTER TABLE `callback` DISABLE KEYS */;
/*!40000 ALTER TABLE `callback` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `callrecording`
--

LOCK TABLES `callrecording` WRITE;
/*!40000 ALTER TABLE `callrecording` DISABLE KEYS */;
/*!40000 ALTER TABLE `callrecording` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `callrecording_module`
--

LOCK TABLES `callrecording_module` WRITE;
/*!40000 ALTER TABLE `callrecording_module` DISABLE KEYS */;
/*!40000 ALTER TABLE `callrecording_module` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `cidlookup`
--

LOCK TABLES `cidlookup` WRITE;
/*!40000 ALTER TABLE `cidlookup` DISABLE KEYS */;
INSERT INTO `cidlookup` (`cidlookup_id`, `description`, `sourcetype`, `cache`, `deptname`, `http_host`, `http_port`, `http_username`, `http_password`, `http_path`, `http_query`, `mysql_host`, `mysql_dbname`, `mysql_query`, `mysql_username`, `mysql_password`, `mysql_charset`, `opencnam_account_sid`, `opencnam_auth_token`) VALUES (5,'OpenCNAM','opencnam',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cidlookup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `cidlookup_incoming`
--

LOCK TABLES `cidlookup_incoming` WRITE;
/*!40000 ALTER TABLE `cidlookup_incoming` DISABLE KEYS */;
INSERT INTO `cidlookup_incoming` (`cidlookup_id`, `extension`, `cidnum`) VALUES (0,'',''),(0,'8147370217','8147370217'),(0,'8147370240','8147370240');
/*!40000 ALTER TABLE `cidlookup_incoming` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `cronmanager`
--

LOCK TABLES `cronmanager` WRITE;
/*!40000 ALTER TABLE `cronmanager` DISABLE KEYS */;
INSERT INTO `cronmanager` (`module`, `id`, `time`, `freq`, `lasttime`, `command`) VALUES ('module_admin','UPDATES','21',24,1636923241,'/var/lib/asterisk/bin/module_admin listonline');
/*!40000 ALTER TABLE `cronmanager` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `custom_destinations`
--

LOCK TABLES `custom_destinations` WRITE;
/*!40000 ALTER TABLE `custom_destinations` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_destinations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `custom_extensions`
--

LOCK TABLES `custom_extensions` WRITE;
/*!40000 ALTER TABLE `custom_extensions` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_extensions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `customcontexts_contexts`
--

LOCK TABLES `customcontexts_contexts` WRITE;
/*!40000 ALTER TABLE `customcontexts_contexts` DISABLE KEYS */;
/*!40000 ALTER TABLE `customcontexts_contexts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `customcontexts_contexts_list`
--

LOCK TABLES `customcontexts_contexts_list` WRITE;
/*!40000 ALTER TABLE `customcontexts_contexts_list` DISABLE KEYS */;
INSERT INTO `customcontexts_contexts_list` (`context`, `description`, `locked`) VALUES ('from-internal','Default Internal Context',1),('from-internal-additional','Internal Dialplan',0),('outbound-allroutes','Outbound Routes',0);
/*!40000 ALTER TABLE `customcontexts_contexts_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `customcontexts_includes`
--

LOCK TABLES `customcontexts_includes` WRITE;
/*!40000 ALTER TABLE `customcontexts_includes` DISABLE KEYS */;
/*!40000 ALTER TABLE `customcontexts_includes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `customcontexts_includes_list`
--

LOCK TABLES `customcontexts_includes_list` WRITE;
/*!40000 ALTER TABLE `customcontexts_includes_list` DISABLE KEYS */;
INSERT INTO `customcontexts_includes_list` (`context`, `include`, `description`, `missing`, `sort`) VALUES ('from-internal','from-internal-additional','ENTIRE Basic Internal Dialplan',0,0),('from-internal','from-internal-custom','Custom Internal Dialplan',0,0),('from-internal','parkedcalls','Call Parking',0,0),('from-internal-additional','outbound-allroutes','ALL OUTBOUND ROUTES',0,51),('from-internal-additional','app-blacklist','app-blacklist',0,1),('from-internal-additional','app-cf-busy-off','app-cf-busy-off',0,2),('from-internal-additional','app-cf-busy-off-any','app-cf-busy-off-any',0,3),('from-internal-additional','app-cf-busy-on','app-cf-busy-on',0,4),('from-internal-additional','app-cf-busy-prompting-on','app-cf-busy-prompting-on',0,5),('from-internal-additional','app-cf-off','app-cf-off',0,6),('from-internal-additional','app-cf-off-any','app-cf-off-any',0,7),('from-internal-additional','app-cf-on','app-cf-on',0,8),('from-internal-additional','app-cf-prompting-on','app-cf-prompting-on',0,9),('from-internal-additional','app-cf-unavailable-off','app-cf-unavailable-off',0,10),('from-internal-additional','app-cf-unavailable-on','app-cf-unavailable-on',0,11),('from-internal-additional','app-cf-unavailable-prompt-on','app-cf-unavailable-prompt-on',0,12),('from-internal-additional','app-cf-toggle','app-cf-toggle',0,13),('from-internal-additional','app-callwaiting-cwoff','app-callwaiting-cwoff',0,14),('from-internal-additional','app-callwaiting-cwon','app-callwaiting-cwon',0,15),('from-internal-additional','ext-meetme','ext-meetme',0,16),('from-internal-additional','app-dictate-record','app-dictate-record',0,17),('from-internal-additional','app-dictate-send','app-dictate-send',0,18),('from-internal-additional','app-dnd-off','app-dnd-off',0,19),('from-internal-additional','app-dnd-on','app-dnd-on',0,20),('from-internal-additional','app-dnd-toggle','app-dnd-toggle',0,21),('from-internal-additional','app-fax','app-fax',0,22),('from-internal-additional','app-fmf-toggle','app-fmf-toggle',0,23),('from-internal-additional','ext-findmefollow','ext-findmefollow',0,24),('from-internal-additional','fmgrps','fmgrps',0,25),('from-internal-additional','app-gabcast','app-gabcast',0,26),('from-internal-additional','app-calltrace','app-calltrace',0,27),('from-internal-additional','app-echo-test','app-echo-test',0,28),('from-internal-additional','app-speakextennum','app-speakextennum',0,29),('from-internal-additional','app-speakingclock','app-speakingclock',0,30),('from-internal-additional','park-hints','park-hints',0,31),('from-internal-additional','app-pbdirectory','app-pbdirectory',0,32),('from-internal-additional','ext-queues','ext-queues',0,33),('from-internal-additional','app-recordings','app-recordings',0,36),('from-internal-additional','ext-group','ext-group',0,37),('from-internal-additional','grps','grps',0,38),('from-internal-additional','app-speeddial','app-speeddial',0,39),('from-internal-additional','vmblast-grp','vmblast-grp',0,40),('from-internal-additional','app-dialvm','app-dialvm',0,41),('from-internal-additional','app-vmmain','app-vmmain',0,42),('from-internal-additional','app-userlogonoff','app-userlogonoff',0,43),('from-internal-additional','ext-local-confirm','ext-local-confirm',0,44),('from-internal-additional','findmefollow-ringallv2','findmefollow-ringallv2',0,45),('from-internal-additional','app-pickup','app-pickup',0,46),('from-internal-additional','app-zapbarge','app-zapbarge',0,47),('from-internal-additional','app-chanspy','app-chanspy',0,48),('from-internal-additional','ext-test','ext-test',0,49),('from-internal-additional','ext-local','ext-local',0,50),('outbound-allroutes','outrt-7','rutasalidaalestra',0,101),('outbound-allroutes','outrt-12','rutasalidamarcatel',0,102),('from-internal-additional','app-queue-toggle','app-queue-toggle',0,34),('from-internal-additional','app-queue-caller-count','app-queue-caller-count',0,35),('outbound-allroutes','outrt-13','rutatest',0,103);
/*!40000 ALTER TABLE `customcontexts_includes_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `customcontexts_module`
--

LOCK TABLES `customcontexts_module` WRITE;
/*!40000 ALTER TABLE `customcontexts_module` DISABLE KEYS */;
INSERT INTO `customcontexts_module` (`id`, `value`) VALUES ('displaysortforincludes','1'),('moduledisplayname','Custom Contexts'),('modulerawname','customcontexts'),('moduleversion','0.3.2');
/*!40000 ALTER TABLE `customcontexts_module` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `customerdb`
--

LOCK TABLES `customerdb` WRITE;
/*!40000 ALTER TABLE `customerdb` DISABLE KEYS */;
/*!40000 ALTER TABLE `customerdb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `dahdi`
--

LOCK TABLES `dahdi` WRITE;
/*!40000 ALTER TABLE `dahdi` DISABLE KEYS */;
/*!40000 ALTER TABLE `dahdi` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `dahdichandids`
--

LOCK TABLES `dahdichandids` WRITE;
/*!40000 ALTER TABLE `dahdichandids` DISABLE KEYS */;
/*!40000 ALTER TABLE `dahdichandids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `daynight`
--

LOCK TABLES `daynight` WRITE;
/*!40000 ALTER TABLE `daynight` DISABLE KEYS */;
/*!40000 ALTER TABLE `daynight` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `devices`
--

LOCK TABLES `devices` WRITE;
/*!40000 ALTER TABLE `devices` DISABLE KEYS */;
INSERT INTO `devices` (`id`, `tech`, `dial`, `devicetype`, `user`, `description`, `emergency_cid`) VALUES ('8147370215','sip','SIP/8147370215','fixed','8147370215','8147370215',''),('8147370218','sip','SIP/8147370218','fixed','8147370218','8147370218',''),('8147370217','sip','SIP/8147370217','fixed','8147370217','8147370217',''),('8147370216','sip','SIP/8147370216','fixed','8147370216','8147370216',''),('8177700670','sip','SIP/8177700670','fixed','8177700670','8177700670',''),('8147370224','sip','SIP/8147370224','fixed','8147370224','8147370224',''),('8147370226','sip','SIP/8147370226','fixed','8147370226','8147370226',''),('8147370227','sip','SIP/8147370227','fixed','8147370227','8147370227',''),('8147370229','sip','SIP/8147370229','fixed','8147370229','8147370229',''),('8147370230','sip','SIP/8147370230','fixed','8147370230','8147370230',''),('8147370231','sip','SIP/8147370231','fixed','8147370231','8147370231',''),('8147370232','sip','SIP/8147370232','fixed','8147370232','8147370232',''),('8147370233','sip','SIP/8147370233','fixed','8147370233','8147370233',''),('8147370234','sip','SIP/8147370234','fixed','8147370234','8147370234',''),('8147370235','sip','SIP/8147370235','fixed','8147370235','8147370235',''),('8147370237','sip','SIP/8147370237','fixed','8147370237','8147370237',''),('8147370238','sip','SIP/8147370238','fixed','8147370238','8147370238',''),('8147370239','sip','SIP/8147370239','fixed','8147370239','8147370239',''),('8147370240','sip','SIP/8147370240','fixed','8147370240','8147370240',''),('8147370241','sip','SIP/8147370241','fixed','8147370241','8147370241',''),('8147370242','sip','SIP/8147370242','fixed','8147370242','8147370242',''),('1002','sip','SIP/1002','fixed','1002','1002',''),('8147370245','sip','SIP/8147370245','fixed','8147370245','8147370245',''),('8147370246','sip','SIP/8147370246','fixed','8147370246','8147370246',''),('8147370247','sip','SIP/8147370247','fixed','8147370247','8147370247',''),('5589958531','sip','SIP/5589958531','fixed','5589958531','5589958531',''),('5589958532','sip','SIP/5589958532','fixed','5589958532','5589958532',''),('5589958533','sip','SIP/5589958533','fixed','5589958533','5589958533',''),('5589958534','sip','SIP/5589958534','fixed','5589958534','5589958534',''),('5589958535','sip','SIP/5589958535','fixed','5589958535','5589958535',''),('5589958536','sip','SIP/5589958536','fixed','5589958536','5589958536',''),('5589958537','sip','SIP/5589958537','fixed','5589958537','5589958537',''),('5589958538','sip','SIP/5589958538','fixed','5589958538','5589958538',''),('5589958539','sip','SIP/5589958539','fixed','5589958539','5589958539',''),('5589958540','sip','SIP/5589958540','fixed','5589958540','5589958540',''),('3335605354','sip','SIP/3335605354','fixed','3335605354','3335605354',''),('3335605355','sip','SIP/3335605355','fixed','3335605355','3335605355',''),('3335605356','sip','SIP/3335605356','fixed','3335605356','3335605356',''),('3335605357','sip','SIP/3335605357','fixed','3335605357','3335605357',''),('3335605358','sip','SIP/3335605358','fixed','3335605358','3335605358',''),('2226443774','sip','SIP/2226443774','fixed','2226443774','2226443774',''),('2226443775','sip','SIP/2226443775','fixed','2226443775','2226443775',''),('2226443776','sip','SIP/2226443776','fixed','2226443776','2226443776',''),('2226443777','sip','SIP/2226443777','fixed','2226443777','2226443777',''),('2226443778','sip','SIP/2226443778','fixed','2226443778','2226443778',''),('8442887386','sip','SIP/8442887386','fixed','8442887386','8442887386',''),('8442887387','sip','SIP/8442887387','fixed','8442887387','8442887387',''),('8442887388','sip','SIP/8442887388','fixed','8442887388','8442887388',''),('8442887389','sip','SIP/8442887389','fixed','8442887389','8442887389',''),('8442887390','sip','SIP/8442887390','fixed','8442887390','8442887390',''),('9988001966','sip','SIP/9988001966','fixed','9988001966','9988001966',''),('9988001967','sip','SIP/9988001967','fixed','9988001967','9988001967',''),('9988001968','sip','SIP/9988001968','fixed','9988001968','9988001968',''),('9988001969','sip','SIP/9988001969','fixed','9988001969','9988001969',''),('9988001970','sip','SIP/9988001970','fixed','9988001970','9988001970',''),('9988001971','sip','SIP/9988001971','fixed','9988001971','9988001971',''),('9988001972','sip','SIP/9988001972','fixed','9988001972','9988001972',''),('9988001973','sip','SIP/9988001973','fixed','9988001973','9988001973',''),('9988001974','sip','SIP/9988001974','fixed','9988001974','9988001974',''),('9988001975','sip','SIP/9988001975','fixed','9988001975','9988001975',''),('8177700100','sip','SIP/8177700100','fixed','8177700100','8177700100',''),('8177700101','sip','SIP/8177700101','fixed','8177700101','8177700101',''),('8177700102','sip','SIP/8177700102','fixed','8177700102','8177700102',''),('8177700103','sip','SIP/8177700103','fixed','8177700103','8177700103',''),('8177700104','sip','SIP/8177700104','fixed','8177700104','8177700104',''),('8177700105','sip','SIP/8177700105','fixed','8177700105','8177700105',''),('8177700106','sip','SIP/8177700106','fixed','8177700106','8177700106',''),('8177700107','sip','SIP/8177700107','fixed','8177700107','8177700107',''),('8177700108','sip','SIP/8177700108','fixed','8177700108','8177700108',''),('8177700109','sip','SIP/8177700109','fixed','8177700109','8177700109',''),('8177700110','sip','SIP/8177700110','fixed','8177700110','8177700110',''),('8177700111','sip','SIP/8177700111','fixed','8177700111','8177700111',''),('8177700112','sip','SIP/8177700112','fixed','8177700112','8177700112',''),('8177700113','sip','SIP/8177700113','fixed','8177700113','8177700113',''),('8177700114','sip','SIP/8177700114','fixed','8177700114','8177700114',''),('8177700115','sip','SIP/8177700115','fixed','8177700115','8177700115',''),('8177700116','sip','SIP/8177700116','fixed','8177700116','8177700116',''),('8177700117','sip','SIP/8177700117','fixed','8177700117','8177700117',''),('8177700118','sip','SIP/8177700118','fixed','8177700118','8177700118',''),('8177700119','sip','SIP/8177700119','fixed','8177700119','8177700119',''),('8177700120','sip','SIP/8177700120','fixed','8177700120','8177700120',''),('8177700121','sip','SIP/8177700121','fixed','8177700121','8177700121',''),('8177700122','sip','SIP/8177700122','fixed','8177700122','8177700122',''),('8177700123','sip','SIP/8177700123','fixed','8177700123','8177700123',''),('8177700124','sip','SIP/8177700124','fixed','8177700124','8177700124',''),('5588804680','sip','SIP/5588804680','fixed','5588804680','5588804680',''),('3388800130','sip','SIP/3388800130','fixed','3388800130','3388800130',''),('2228800360','sip','SIP/2228800360','fixed','2228800360','2228800360',''),('8177700360','sip','SIP/8177700360','fixed','8177700360','8177700360',''),('8447770070','sip','SIP/8447770070','fixed','8447770070','8447770070',''),('5588804681','sip','SIP/5588804681','fixed','5588804681','5588804681',''),('5588804682','sip','SIP/5588804682','fixed','5588804682','5588804682',''),('5588804683','sip','SIP/5588804683','fixed','5588804683','5588804683',''),('5588804684','sip','SIP/5588804684','fixed','5588804684','5588804684',''),('5588804685','sip','SIP/5588804685','fixed','5588804685','5588804685',''),('5588804686','sip','SIP/5588804686','fixed','5588804686','5588804686',''),('5588804687','sip','SIP/5588804687','fixed','5588804687','5588804687',''),('5588804688','sip','SIP/5588804688','fixed','5588804688','5588804688',''),('5588804689','sip','SIP/5588804689','fixed','5588804689','5588804689',''),('3388800131','sip','SIP/3388800131','fixed','3388800131','3388800131',''),('3388800132','sip','SIP/3388800132','fixed','3388800132','3388800132',''),('3388800133','sip','SIP/3388800133','fixed','3388800133','3388800133',''),('3388800134','sip','SIP/3388800134','fixed','3388800134','3388800134',''),('2228800361','sip','SIP/2228800361','fixed','2228800361','2228800361',''),('2228800362','sip','SIP/2228800362','fixed','2228800362','2228800362',''),('2228800363','sip','SIP/2228800363','fixed','2228800363','2228800363',''),('2228800364','sip','SIP/2228800364','fixed','2228800364','2228800364',''),('9847770191','sip','SIP/9847770191','fixed','9847770191','9847770191',''),('9847770192','sip','SIP/9847770192','fixed','9847770192','9847770192',''),('9847770193','sip','SIP/9847770193','fixed','9847770193','9847770193',''),('9847770194','sip','SIP/9847770194','fixed','9847770194','9847770194',''),('9847770195','sip','SIP/9847770195','fixed','9847770195','9847770195',''),('9847770196','sip','SIP/9847770196','fixed','9847770196','9847770196',''),('9847770197','sip','SIP/9847770197','fixed','9847770197','9847770197',''),('9847770198','sip','SIP/9847770198','fixed','9847770198','9847770198',''),('9847770199','sip','SIP/9847770199','fixed','9847770199','9847770199',''),('8447770071','sip','SIP/8447770071','fixed','8447770071','8447770071',''),('8447770072','sip','SIP/8447770072','fixed','8447770072','8447770072',''),('8447770073','sip','SIP/8447770073','fixed','8447770073','8447770073',''),('8447770074','sip','SIP/8447770074','fixed','8447770074','8447770074',''),('1001','sip','SIP/1001','fixed','1001','1001',''),('3001','sip','SIP/3001','fixed','3001','3001',''),('2000','sip','SIP/2000','fixed','2000','2000',''),('2001','sip','SIP/2001','fixed','2001','2001',''),('2002','sip','SIP/2002','fixed','2002','2002',''),('2003','sip','SIP/2003','fixed','2003','2003',''),('2004','sip','SIP/2004','fixed','2004','2004',''),('2005','sip','SIP/2005','fixed','2005','2005',''),('2006','sip','SIP/2006','fixed','2006','2006',''),('8177700361','sip','SIP/8177700361','fixed','8177700361','8177700361',''),('8177700362','sip','SIP/8177700362','fixed','8177700362','8177700362',''),('8177700363','sip','SIP/8177700363','fixed','8177700363','8177700363',''),('8177700364','sip','SIP/8177700364','fixed','8177700364','8177700364',''),('8177700365','sip','SIP/8177700365','fixed','8177700365','8177700365',''),('8177700366','sip','SIP/8177700366','fixed','8177700366','8177700366',''),('8177700367','sip','SIP/8177700367','fixed','8177700367','8177700367',''),('8177700368','sip','SIP/8177700368','fixed','8177700368','8177700368',''),('8177700369','sip','SIP/8177700369','fixed','8177700369','8177700369',''),('8177700370','sip','SIP/8177700370','fixed','8177700370','8177700370',''),('8177700371','sip','SIP/8177700371','fixed','8177700371','8177700371',''),('8177700372','sip','SIP/8177700372','fixed','8177700372','8177700372',''),('8177700373','sip','SIP/8177700373','fixed','8177700373','8177700373',''),('8177700374','sip','SIP/8177700374','fixed','8177700374','8177700374',''),('8177700375','sip','SIP/8177700375','fixed','8177700375','8177700375',''),('8177700376','sip','SIP/8177700376','fixed','8177700376','8177700376',''),('8177700377','sip','SIP/8177700377','fixed','8177700377','8177700377',''),('8177700378','sip','SIP/8177700378','fixed','8177700378','8177700378',''),('81777001001','sip','SIP/81777001001','fixed','81777001001','81777001001',''),('8177700381','sip','SIP/8177700381','fixed','8177700381','8177700381',''),('8177700382','sip','SIP/8177700382','fixed','8177700382','8177700382',''),('8177700383','sip','SIP/8177700383','fixed','8177700383','8177700383',''),('8177700384','sip','SIP/8177700384','fixed','8177700384','8177700384',''),('8177700385','sip','SIP/8177700385','fixed','8177700385','8177700385',''),('8177700386','sip','SIP/8177700386','fixed','8177700386','8177700386',''),('8177700387','sip','SIP/8177700387','fixed','8177700387','8177700387',''),('8177700388','sip','SIP/8177700388','fixed','8177700388','8177700388',''),('8177700389','sip','SIP/8177700389','fixed','8177700389','8177700389',''),('4428880130','sip','SIP/4428880130','fixed','4428880130','4428880130',''),('4428880131','sip','SIP/4428880131','fixed','4428880131','4428880131',''),('4428880132','sip','SIP/4428880132','fixed','4428880132','4428880132',''),('4428880133','sip','SIP/4428880133','fixed','4428880133','4428880133',''),('4428880134','sip','SIP/4428880134','fixed','4428880134','4428880134',''),('4428880135','sip','SIP/4428880135','fixed','4428880135','4428880135',''),('4428880136','sip','SIP/4428880136','fixed','4428880136','4428880136',''),('4428880137','sip','SIP/4428880137','fixed','4428880137','4428880137',''),('4428880138','sip','SIP/4428880138','fixed','4428880138','4428880138',''),('4428880139','sip','SIP/4428880139','fixed','4428880139','4428880139',''),('8177700671','sip','SIP/8177700671','fixed','8177700671','8177700671',''),('8177700672','sip','SIP/8177700672','fixed','8177700672','8177700672',''),('8177700673','sip','SIP/8177700673','fixed','8177700673','8177700673',''),('8177700674','sip','SIP/8177700674','fixed','8177700674','8177700674',''),('8177700675','sip','SIP/8177700675','fixed','8177700675','8177700675',''),('8177700676','sip','SIP/8177700676','fixed','8177700676','8177700676',''),('8177700677','sip','SIP/8177700677','fixed','8177700677','8177700677',''),('8177700678','sip','SIP/8177700678','fixed','8177700678','8177700678',''),('8177700679','sip','SIP/8177700679','fixed','8177700679','8177700679',''),('8177700680','sip','SIP/8177700680','fixed','8177700680','8177700680',''),('8177700681','sip','SIP/8177700681','fixed','8177700681','8177700681',''),('8177700682','sip','SIP/8177700682','fixed','8177700682','8177700682',''),('8177700683','sip','SIP/8177700683','fixed','8177700683','8177700683',''),('8177700684','sip','SIP/8177700684','fixed','8177700684','8177700684',''),('8177700685','sip','SIP/8177700685','fixed','8177700685','8177700685',''),('8177700686','sip','SIP/8177700686','fixed','8177700686','8177700686',''),('8177700687','sip','SIP/8177700687','fixed','8177700687','8177700687',''),('8177700688','sip','SIP/8177700688','fixed','8177700688','8177700688',''),('8177700689','sip','SIP/8177700689','fixed','8177700689','8177700689',''),('8177700690','sip','SIP/8177700690','fixed','8177700690','8177700690',''),('8177700691','sip','SIP/8177700691','fixed','8177700691','8177700691',''),('8177700692','sip','SIP/8177700692','fixed','8177700692','8177700692',''),('8177700693','sip','SIP/8177700693','fixed','8177700693','8177700693',''),('8177700694','sip','SIP/8177700694','fixed','8177700694','8177700694',''),('8177700695','sip','SIP/8177700695','fixed','8177700695','8177700695',''),('8177700696','sip','SIP/8177700696','fixed','8177700696','8177700696',''),('8177700697','sip','SIP/8177700697','fixed','8177700697','8177700697',''),('8177700698','sip','SIP/8177700698','fixed','8177700698','8177700698',''),('8177700699','sip','SIP/8177700699','fixed','8177700699','8177700699',''),('4778880150','sip','SIP/4778880150','fixed','4778880150','4778880150',''),('4778880151','sip','SIP/4778880151','fixed','4778880151','4778880151',''),('4778880152','sip','SIP/4778880152','fixed','4778880152','4778880152',''),('4778880153','sip','SIP/4778880153','fixed','4778880153','4778880153',''),('4778880154','sip','SIP/4778880154','fixed','4778880154','4778880154',''),('4778880155','sip','SIP/4778880155','fixed','4778880155','4778880155',''),('4778880156','sip','SIP/4778880156','fixed','4778880156','4778880156',''),('4778880157','sip','SIP/4778880157','fixed','4778880157','4778880157',''),('4778880158','sip','SIP/4778880158','fixed','4778880158','4778880158',''),('4778880159','sip','SIP/4778880159','fixed','4778880159','4778880159',''),('8718800150','sip','SIP/8718800150','fixed','8718800150','8718800150',''),('8718800151','sip','SIP/8718800151','fixed','8718800151','8718800151',''),('8718800152','sip','SIP/8718800152','fixed','8718800152','8718800152',''),('8718800153','sip','SIP/8718800153','fixed','8718800153','8718800153',''),('8718800154','sip','SIP/8718800154','fixed','8718800154','8718800154',''),('8718800155','sip','SIP/8718800155','fixed','8718800155','8718800155',''),('8718800156','sip','SIP/8718800156','fixed','8718800156','8718800156',''),('8718800157','sip','SIP/8718800157','fixed','8718800157','8718800157',''),('8718800158','sip','SIP/8718800158','fixed','8718800158','8718800158',''),('8718800159','sip','SIP/8718800159','fixed','8718800159','8718800159',''),('8177700380','sip','SIP/8177700380','fixed','8177700380','8177700380',''),('8147370221','sip','SIP/8147370221','fixed','8147370221','8147370221',''),('8177700379','sip','SIP/8177700379','fixed','8177700379','8177700379',''),('8147370244','sip','SIP/8147370244','fixed','8147370244','8147370244',''),('2007','sip','SIP/2007','fixed','2007','2007',''),('2008','sip','SIP/2008','fixed','2008','2008',''),('2009','sip','SIP/2009','fixed','2009','2009',''),('8177701550','sip','SIP/8177701550','fixed','8177701550','8177701550',''),('5547776690','sip','SIP/5547776690','fixed','5547776690','5547776690',''),('4617770040','sip','SIP/4617770040','fixed','4617770040','4617770040',''),('4428881710','sip','SIP/4428881710','fixed','4428881710','4428881710',''),('4778880355','sip','SIP/4778880355','fixed','4778880355','4778880355',''),('6647770030','sip','SIP/6647770030','fixed','6647770030','6647770030',''),('8177701551','sip','SIP/8177701551','fixed','8177701551','8177701551',''),('8177701552','sip','SIP/8177701552','fixed','8177701552','8177701552',''),('8177701553','sip','SIP/8177701553','fixed','8177701553','8177701553',''),('8177701554','sip','SIP/8177701554','fixed','8177701554','8177701554',''),('8177701555','sip','SIP/8177701555','fixed','8177701555','8177701555',''),('8177701556','sip','SIP/8177701556','fixed','8177701556','8177701556',''),('8177701557','sip','SIP/8177701557','fixed','8177701557','8177701557',''),('8177701558','sip','SIP/8177701558','fixed','8177701558','8177701558',''),('8177701559','sip','SIP/8177701559','fixed','8177701559','8177701559',''),('8177701560','sip','SIP/8177701560','fixed','8177701560','8177701560',''),('8177701561','sip','SIP/8177701561','fixed','8177701561','8177701561',''),('8177701562','sip','SIP/8177701562','fixed','8177701562','8177701562',''),('8177701563','sip','SIP/8177701563','fixed','8177701563','8177701563',''),('8177701564','sip','SIP/8177701564','fixed','8177701564','8177701564',''),('8177701565','sip','SIP/8177701565','fixed','8177701565','8177701565',''),('8177701566','sip','SIP/8177701566','fixed','8177701566','8177701566',''),('8177701567','sip','SIP/8177701567','fixed','8177701567','8177701567',''),('8177701568','sip','SIP/8177701568','fixed','8177701568','8177701568',''),('8177701569','sip','SIP/8177701569','fixed','8177701569','8177701569',''),('8177701570','sip','SIP/8177701570','fixed','8177701570','8177701570',''),('8177701571','sip','SIP/8177701571','fixed','8177701571','8177701571',''),('8177701572','sip','SIP/8177701572','fixed','8177701572','8177701572',''),('8177701573','sip','SIP/8177701573','fixed','8177701573','8177701573',''),('8177701574','sip','SIP/8177701574','fixed','8177701574','8177701574',''),('8177701575','sip','SIP/8177701575','fixed','8177701575','8177701575',''),('8177701576','sip','SIP/8177701576','fixed','8177701576','8177701576',''),('8177701577','sip','SIP/8177701577','fixed','8177701577','8177701577',''),('8177701578','sip','SIP/8177701578','fixed','8177701578','8177701578',''),('8177701579','sip','SIP/8177701579','fixed','8177701579','8177701579',''),('5547776691','sip','SIP/5547776691','fixed','5547776691','5547776691',''),('5547776692','sip','SIP/5547776692','fixed','5547776692','5547776692',''),('5547776693','sip','SIP/5547776693','fixed','5547776693','5547776693',''),('5547776694','sip','SIP/5547776694','fixed','5547776694','5547776694',''),('5547776695','sip','SIP/5547776695','fixed','5547776695','5547776695',''),('5547776696','sip','SIP/5547776696','fixed','5547776696','5547776696',''),('5547776697','sip','SIP/5547776697','fixed','5547776697','5547776697',''),('5547776698','sip','SIP/5547776698','fixed','5547776698','5547776698',''),('5547776699','sip','SIP/5547776699','fixed','5547776699','5547776699',''),('4617770041','sip','SIP/4617770041','fixed','4617770041','4617770041',''),('4617770042','sip','SIP/4617770042','fixed','4617770042','4617770042',''),('4617770043','sip','SIP/4617770043','fixed','4617770043','4617770043',''),('4617770044','sip','SIP/4617770044','fixed','4617770044','4617770044',''),('4428881711','sip','SIP/4428881711','fixed','4428881711','4428881711',''),('4428881712','sip','SIP/4428881712','fixed','4428881712','4428881712',''),('4428881713','sip','SIP/4428881713','fixed','4428881713','4428881713',''),('4428881714','sip','SIP/4428881714','fixed','4428881714','4428881714',''),('4778880356','sip','SIP/4778880356','fixed','4778880356','4778880356',''),('4778880357','sip','SIP/4778880357','fixed','4778880357','4778880357',''),('4778880358','sip','SIP/4778880358','fixed','4778880358','4778880358',''),('4778880359','sip','SIP/4778880359','fixed','4778880359','4778880359',''),('6647770031','sip','SIP/6647770031','fixed','6647770031','6647770031',''),('6647770032','sip','SIP/6647770032','fixed','6647770032','6647770032',''),('6647770033','sip','SIP/6647770033','fixed','6647770033','6647770033',''),('6647770034','sip','SIP/6647770034','fixed','6647770034','6647770034',''),('4448880540','sip','SIP/4448880540','fixed','4448880540','4448880540',''),('4448880541','sip','SIP/4448880541','fixed','4448880541','4448880541',''),('4448880542','sip','SIP/4448880542','fixed','4448880542','4448880542',''),('4448880543','sip','SIP/4448880543','fixed','4448880543','4448880543',''),('4448880544','sip','SIP/4448880544','fixed','4448880544','4448880544',''),('4627770400','sip','SIP/4627770400','fixed','4627770400','4627770400',''),('4627770401','sip','SIP/4627770401','fixed','4627770401','4627770401',''),('4627770402','sip','SIP/4627770402','fixed','4627770402','4627770402',''),('4627770403','sip','SIP/4627770403','fixed','4627770403','4627770403',''),('4627770404','sip','SIP/4627770404','fixed','4627770404','4627770404',''),('6148880200','sip','SIP/6148880200','fixed','6148880200','6148880200',''),('6148880201','sip','SIP/6148880201','fixed','6148880201','6148880201',''),('6148880202','sip','SIP/6148880202','fixed','6148880202','6148880202',''),('6148880203','sip','SIP/6148880203','fixed','6148880203','6148880203',''),('6148880204','sip','SIP/6148880204','fixed','6148880204','6148880204',''),('6568880100','sip','SIP/6568880100','fixed','6568880100','6568880100',''),('6568880101','sip','SIP/6568880101','fixed','6568880101','6568880101',''),('6568880102','sip','SIP/6568880102','fixed','6568880102','6568880102',''),('6568880103','sip','SIP/6568880103','fixed','6568880103','6568880103',''),('6568880104','sip','SIP/6568880104','fixed','6568880104','6568880104',''),('8147773870','sip','SIP/8147773870','fixed','8147773870','8147773870',''),('8147773871','sip','SIP/8147773871','fixed','8147773871','8147773871',''),('8147773872','sip','SIP/8147773872','fixed','8147773872','8147773872',''),('8147773873','sip','SIP/8147773873','fixed','8147773873','8147773873',''),('8147773874','sip','SIP/8147773874','fixed','8147773874','8147773874',''),('8147773875','sip','SIP/8147773875','fixed','8147773875','8147773875',''),('8147773876','sip','SIP/8147773876','fixed','8147773876','8147773876',''),('8147773877','sip','SIP/8147773877','fixed','8147773877','8147773877',''),('8147773878','sip','SIP/8147773878','fixed','8147773878','8147773878',''),('8147773879','sip','SIP/8147773879','fixed','8147773879','8147773879',''),('8147773880','sip','SIP/8147773880','fixed','8147773880','8147773880',''),('8147773881','sip','SIP/8147773881','fixed','8147773881','8147773881',''),('8147773882','sip','SIP/8147773882','fixed','8147773882','8147773882',''),('8147773883','sip','SIP/8147773883','fixed','8147773883','8147773883',''),('8147773884','sip','SIP/8147773884','fixed','8147773884','8147773884',''),('8147773885','sip','SIP/8147773885','fixed','8147773885','8147773885',''),('8147773886','sip','SIP/8147773886','fixed','8147773886','8147773886',''),('8147773887','sip','SIP/8147773887','fixed','8147773887','8147773887',''),('8147773888','sip','SIP/8147773888','fixed','8147773888','8147773888',''),('8147773889','sip','SIP/8147773889','fixed','8147773889','8147773889',''),('8147773890','sip','SIP/8147773890','fixed','8147773890','8147773890',''),('8147773891','sip','SIP/8147773891','fixed','8147773891','8147773891',''),('8147773892','sip','SIP/8147773892','fixed','8147773892','8147773892',''),('8147773893','sip','SIP/8147773893','fixed','8147773893','8147773893',''),('8147773894','sip','SIP/8147773894','fixed','8147773894','8147773894',''),('9847770200','sip','SIP/9847770200','fixed','9847770200','9847770200',''),('9847770201','sip','SIP/9847770201','fixed','9847770201','9847770201',''),('9847770202','sip','SIP/9847770202','fixed','9847770202','9847770202',''),('9847770203','sip','SIP/9847770203','fixed','9847770203','9847770203',''),('9847770204','sip','SIP/9847770204','fixed','9847770204','9847770204',''),('81777001081','sip','SIP/81777001081','fixed','81777001081','81777001081',''),('2010','sip','SIP/2010','fixed','2010','2010',''),('2011','sip','SIP/2011','fixed','2011','2011',''),('2297770470','sip','SIP/2297770470','fixed','2297770470','2297770470',''),('2297770471','sip','SIP/2297770471','fixed','2297770471','2297770471',''),('2297770472','sip','SIP/2297770472','fixed','2297770472','2297770472',''),('2297770473','sip','SIP/2297770473','fixed','2297770473','2297770473',''),('2297770474','sip','SIP/2297770474','fixed','2297770474','2297770474',''),('2717770360','sip','SIP/2717770360','fixed','2717770360','2717770360',''),('2717770361','sip','SIP/2717770361','fixed','2717770361','2717770361',''),('2717770362','sip','SIP/2717770362','fixed','2717770362','2717770362',''),('2717770363','sip','SIP/2717770363','fixed','2717770363','2717770363',''),('2717770364','sip','SIP/2717770364','fixed','2717770364','2717770364',''),('3388801850','sip','SIP/3388801850','fixed','3388801850','3388801850',''),('3388801851','sip','SIP/3388801851','fixed','3388801851','3388801851',''),('3388801852','sip','SIP/3388801852','fixed','3388801852','3388801852',''),('3388801853','sip','SIP/3388801853','fixed','3388801853','3388801853',''),('3388801854','sip','SIP/3388801854','fixed','3388801854','3388801854',''),('4428881640','sip','SIP/4428881640','fixed','4428881640','4428881640',''),('4428881641','sip','SIP/4428881641','fixed','4428881641','4428881641',''),('4428881642','sip','SIP/4428881642','fixed','4428881642','4428881642',''),('4428881643','sip','SIP/4428881643','fixed','4428881643','4428881643',''),('4428881644','sip','SIP/4428881644','fixed','4428881644','4428881644',''),('5547748640','sip','SIP/5547748640','fixed','5547748640','5547748640',''),('5547748641','sip','SIP/5547748641','fixed','5547748641','5547748641',''),('5547748642','sip','SIP/5547748642','fixed','5547748642','5547748642',''),('5547748643','sip','SIP/5547748643','fixed','5547748643','5547748643',''),('5547748644','sip','SIP/5547748644','fixed','5547748644','5547748644',''),('5547748645','sip','SIP/5547748645','fixed','5547748645','5547748645',''),('5547748646','sip','SIP/5547748646','fixed','5547748646','5547748646',''),('5547748647','sip','SIP/5547748647','fixed','5547748647','5547748647',''),('5547748648','sip','SIP/5547748648','fixed','5547748648','5547748648',''),('5547748649','sip','SIP/5547748649','fixed','5547748649','5547748649',''),('6628880540','sip','SIP/6628880540','fixed','6628880540','6628880540',''),('6628880541','sip','SIP/6628880541','fixed','6628880541','6628880541',''),('6628880542','sip','SIP/6628880542','fixed','6628880542','6628880542',''),('6628880543','sip','SIP/6628880543','fixed','6628880543','6628880543',''),('6628880544','sip','SIP/6628880544','fixed','6628880544','6628880544',''),('8177702600','sip','SIP/8177702600','fixed','8177702600','8177702600',''),('8177702601','sip','SIP/8177702601','fixed','8177702601','8177702601',''),('8177702602','sip','SIP/8177702602','fixed','8177702602','8177702602',''),('8177702603','sip','SIP/8177702603','fixed','8177702603','8177702603',''),('8177702604','sip','SIP/8177702604','fixed','8177702604','8177702604',''),('8177702605','sip','SIP/8177702605','fixed','8177702605','8177702605',''),('8177702606','sip','SIP/8177702606','fixed','8177702606','8177702606',''),('8177702607','sip','SIP/8177702607','fixed','8177702607','8177702607',''),('8177702608','sip','SIP/8177702608','fixed','8177702608','8177702608',''),('8177702609','sip','SIP/8177702609','fixed','8177702609','8177702609',''),('8177702610','sip','SIP/8177702610','fixed','8177702610','8177702610',''),('8177702611','sip','SIP/8177702611','fixed','8177702611','8177702611',''),('8177702612','sip','SIP/8177702612','fixed','8177702612','8177702612',''),('8177702613','sip','SIP/8177702613','fixed','8177702613','8177702613',''),('8177702614','sip','SIP/8177702614','fixed','8177702614','8177702614',''),('8177702615','sip','SIP/8177702615','fixed','8177702615','8177702615',''),('8177702616','sip','SIP/8177702616','fixed','8177702616','8177702616',''),('8177702617','sip','SIP/8177702617','fixed','8177702617','8177702617',''),('8177702618','sip','SIP/8177702618','fixed','8177702618','8177702618',''),('8177702619','sip','SIP/8177702619','fixed','8177702619','8177702619',''),('8177702620','sip','SIP/8177702620','fixed','8177702620','8177702620',''),('8177702621','sip','SIP/8177702621','fixed','8177702621','8177702621',''),('8177702622','sip','SIP/8177702622','fixed','8177702622','8177702622',''),('8177702623','sip','SIP/8177702623','fixed','8177702623','8177702623',''),('8177702624','sip','SIP/8177702624','fixed','8177702624','8177702624',''),('8177702625','sip','SIP/8177702625','fixed','8177702625','8177702625',''),('8177702626','sip','SIP/8177702626','fixed','8177702626','8177702626',''),('8177702627','sip','SIP/8177702627','fixed','8177702627','8177702627',''),('8177702628','sip','SIP/8177702628','fixed','8177702628','8177702628',''),('8177702629','sip','SIP/8177702629','fixed','8177702629','8177702629',''),('8447770430','sip','SIP/8447770430','fixed','8447770430','8447770430',''),('8447770431','sip','SIP/8447770431','fixed','8447770431','8447770431',''),('8447770432','sip','SIP/8447770432','fixed','8447770432','8447770432',''),('8447770433','sip','SIP/8447770433','fixed','8447770433','8447770433',''),('8447770434','sip','SIP/8447770434','fixed','8447770434','8447770434',''),('8447770435','sip','SIP/8447770435','fixed','8447770435','8447770435',''),('8447770436','sip','SIP/8447770436','fixed','8447770436','8447770436',''),('8447770437','sip','SIP/8447770437','fixed','8447770437','8447770437',''),('8447770438','sip','SIP/8447770438','fixed','8447770438','8447770438',''),('8447770439','sip','SIP/8447770439','fixed','8447770439','8447770439',''),('8677770240','sip','SIP/8677770240','fixed','8677770240','8677770240',''),('8677770241','sip','SIP/8677770241','fixed','8677770241','8677770241',''),('8677770242','sip','SIP/8677770242','fixed','8677770242','8677770242',''),('8677770243','sip','SIP/8677770243','fixed','8677770243','8677770243',''),('8677770244','sip','SIP/8677770244','fixed','8677770244','8677770244',''),('8998880195','sip','SIP/8998880195','fixed','8998880195','8998880195',''),('8998880196','sip','SIP/8998880196','fixed','8998880196','8998880196',''),('8998880197','sip','SIP/8998880197','fixed','8998880197','8998880197',''),('8998880198','sip','SIP/8998880198','fixed','8998880198','8998880198',''),('8998880199','sip','SIP/8998880199','fixed','8998880199','8998880199',''),('9847770340','sip','SIP/9847770340','fixed','9847770340','9847770340',''),('9847770341','sip','SIP/9847770341','fixed','9847770341','9847770341',''),('9847770342','sip','SIP/9847770342','fixed','9847770342','9847770342',''),('9847770343','sip','SIP/9847770343','fixed','9847770343','9847770343',''),('9847770344','sip','SIP/9847770344','fixed','9847770344','9847770344',''),('9995740195','sip','SIP/9995740195','fixed','9995740195','9995740195',''),('9995740196','sip','SIP/9995740196','fixed','9995740196','9995740196',''),('9995740197','sip','SIP/9995740197','fixed','9995740197','9995740197',''),('9995740198','sip','SIP/9995740198','fixed','9995740198','9995740198',''),('9995740199','sip','SIP/9995740199','fixed','9995740199','9995740199','');
/*!40000 ALTER TABLE `devices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `disa`
--

LOCK TABLES `disa` WRITE;
/*!40000 ALTER TABLE `disa` DISABLE KEYS */;
/*!40000 ALTER TABLE `disa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `extensions`
--

LOCK TABLES `extensions` WRITE;
/*!40000 ALTER TABLE `extensions` DISABLE KEYS */;
INSERT INTO `extensions` (`context`, `extension`, `priority`, `application`, `args`, `descr`, `flags`) VALUES ('outrt-001-9_outside','_9.','1','Macro','dialout-trunk,1,${EXTEN:1}',NULL,0),('outrt-001-9_outside','_9.','2','Macro','outisbusy','No available circuits',0),('outbound-allroutes','include','1','outrt-001-9_outside','','',2);
/*!40000 ALTER TABLE `extensions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `fax_details`
--

LOCK TABLES `fax_details` WRITE;
/*!40000 ALTER TABLE `fax_details` DISABLE KEYS */;
INSERT INTO `fax_details` (`key`, `value`) VALUES ('minrate','14400'),('maxrate','14400'),('ecm','yes'),('legacy_mode','no'),('force_detection','no'),('sender_address','fax@issabel.org'),('fax_rx_email','fax@mydomain.com');
/*!40000 ALTER TABLE `fax_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `fax_incoming`
--

LOCK TABLES `fax_incoming` WRITE;
/*!40000 ALTER TABLE `fax_incoming` DISABLE KEYS */;
/*!40000 ALTER TABLE `fax_incoming` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `fax_users`
--

LOCK TABLES `fax_users` WRITE;
/*!40000 ALTER TABLE `fax_users` DISABLE KEYS */;
INSERT INTO `fax_users` (`user`, `faxenabled`, `faxemail`, `faxattachformat`) VALUES ('8147370217',NULL,NULL,NULL),('8147370216',NULL,NULL,NULL),('5589958532',NULL,NULL,NULL),('5589958535',NULL,NULL,NULL),('5589958537',NULL,NULL,NULL),('8147370215',NULL,NULL,NULL),('5589958533',NULL,NULL,NULL),('8177700101',NULL,NULL,NULL),('8177700100',NULL,NULL,NULL),('8177700102',NULL,NULL,NULL),('8177700103',NULL,NULL,NULL),('5589958540',NULL,NULL,NULL),('3335605355',NULL,NULL,NULL),('3388800130',NULL,NULL,NULL),('8177700106',NULL,NULL,NULL),('8447770070',NULL,NULL,NULL),('5588804680',NULL,NULL,NULL),('8177700107',NULL,NULL,NULL),('8177700108',NULL,NULL,NULL),('8177700109',NULL,NULL,NULL),('8177700110',NULL,NULL,NULL),('8177700111',NULL,NULL,NULL),('8177700112',NULL,NULL,NULL),('8177700113',NULL,NULL,NULL),('8177700114',NULL,NULL,NULL),('8177700115',NULL,NULL,NULL),('8177700116',NULL,NULL,NULL),('8177700117',NULL,NULL,NULL),('8177700118',NULL,NULL,NULL),('8177700119',NULL,NULL,NULL),('8177700120',NULL,NULL,NULL),('8177700121',NULL,NULL,NULL),('8177700122',NULL,NULL,NULL),('8177700123',NULL,NULL,NULL),('8177700124',NULL,NULL,NULL),('8177700105',NULL,NULL,NULL),('8177700104',NULL,NULL,NULL),('5588804681',NULL,NULL,NULL),('5588804682',NULL,NULL,NULL),('5588804683',NULL,NULL,NULL),('5588804684',NULL,NULL,NULL),('5588804685',NULL,NULL,NULL),('5588804686',NULL,NULL,NULL),('5588804687',NULL,NULL,NULL),('5588804688',NULL,NULL,NULL),('5588804689',NULL,NULL,NULL),('3388800131',NULL,NULL,NULL),('3388800132',NULL,NULL,NULL),('3388800133',NULL,NULL,NULL),('3388800134',NULL,NULL,NULL),('8147773884',NULL,NULL,NULL),('2228800361',NULL,NULL,NULL),('2228800362',NULL,NULL,NULL),('2228800363',NULL,NULL,NULL),('2228800364',NULL,NULL,NULL),('9847770190',NULL,NULL,NULL),('9847770191',NULL,NULL,NULL),('9847770192',NULL,NULL,NULL),('9847770193',NULL,NULL,NULL),('9847770194',NULL,NULL,NULL),('9847770195',NULL,NULL,NULL),('8177700385',NULL,NULL,NULL),('8147370224',NULL,NULL,NULL),('8147370226',NULL,NULL,NULL),('8147370227',NULL,NULL,NULL),('8147370229',NULL,NULL,NULL),('8147370230',NULL,NULL,NULL),('8147370233',NULL,NULL,NULL),('8147370234',NULL,NULL,NULL),('8147370237',NULL,NULL,NULL),('8147370238',NULL,NULL,NULL),('8147370239',NULL,NULL,NULL),('8147370240',NULL,NULL,NULL),('8147370241',NULL,NULL,NULL),('8147370242',NULL,NULL,NULL),('8177700384',NULL,NULL,NULL),('8147370245',NULL,NULL,NULL),('8147370246',NULL,NULL,NULL),('8147370247',NULL,NULL,NULL),('5589958531',NULL,NULL,NULL),('8147370231',NULL,NULL,NULL),('8147370232',NULL,NULL,NULL),('8147370218',NULL,NULL,NULL),('8147370235',NULL,NULL,NULL),('2226443774',NULL,NULL,NULL),('8177700360',NULL,NULL,NULL),('8177700361',NULL,NULL,NULL),('8177700362',NULL,NULL,NULL),('8177700363',NULL,NULL,NULL),('8177700364',NULL,NULL,NULL),('8177700365',NULL,NULL,NULL),('8177700366',NULL,NULL,NULL),('8177700367',NULL,NULL,NULL),('8177700368',NULL,NULL,NULL),('8177700369',NULL,NULL,NULL),('8177700371',NULL,NULL,NULL),('8177700372',NULL,NULL,NULL),('8177700373',NULL,NULL,NULL),('8177700374',NULL,NULL,NULL),('8177700375',NULL,NULL,NULL),('8177700370',NULL,NULL,NULL),('8177700376',NULL,NULL,NULL),('8177700377',NULL,NULL,NULL),('8177700378',NULL,NULL,NULL),('8147370221',NULL,NULL,NULL),('8177700380',NULL,NULL,NULL),('8177700381',NULL,NULL,NULL),('8177700382',NULL,NULL,NULL),('8177700383',NULL,NULL,NULL),('9988001975',NULL,NULL,NULL),('8177700386',NULL,NULL,NULL),('8177700681',NULL,NULL,NULL),('8177700387',NULL,NULL,NULL),('8177700389',NULL,NULL,NULL),('8177700671',NULL,NULL,NULL),('8177700379',NULL,NULL,NULL),('8177700673',NULL,NULL,NULL),('8177700674',NULL,NULL,NULL),('8177700672',NULL,NULL,NULL),('8177700675',NULL,NULL,NULL),('8177700676',NULL,NULL,NULL),('8147370244',NULL,NULL,NULL),('8177700677',NULL,NULL,NULL),('8177700678',NULL,NULL,NULL),('8177700679',NULL,NULL,NULL),('8177700680',NULL,NULL,NULL),('8177700682',NULL,NULL,NULL),('8177700683',NULL,NULL,NULL),('8177700684',NULL,NULL,NULL),('8177700685',NULL,NULL,NULL),('2007',NULL,NULL,NULL),('8177700686',NULL,NULL,NULL),('8177700687',NULL,NULL,NULL),('8177700688',NULL,NULL,NULL),('8177700689',NULL,NULL,NULL),('2000',NULL,NULL,NULL),('2001',NULL,NULL,NULL),('2002',NULL,NULL,NULL),('2003',NULL,NULL,NULL),('2004',NULL,NULL,NULL),('2005',NULL,NULL,NULL),('2006',NULL,NULL,NULL),('8177700691',NULL,NULL,NULL),('8177700692',NULL,NULL,NULL),('8177700690',NULL,NULL,NULL),('8177700693',NULL,NULL,NULL),('8177700695',NULL,NULL,NULL),('8177700694',NULL,NULL,NULL),('8177701575',NULL,NULL,NULL),('4617770040',NULL,NULL,NULL),('8177700696',NULL,NULL,NULL),('8177700697',NULL,NULL,NULL),('8177700698',NULL,NULL,NULL),('8177701550',NULL,NULL,NULL),('5547776690',NULL,NULL,NULL),('8177701551',NULL,NULL,NULL),('5589958534',NULL,NULL,NULL),('8177701552',NULL,NULL,NULL),('8177701553',NULL,NULL,NULL),('8177701554',NULL,NULL,NULL),('9847770196',NULL,NULL,NULL),('8718800151',NULL,NULL,NULL),('8718800156',NULL,NULL,NULL),('8718800152',NULL,NULL,NULL),('8177701556',NULL,NULL,NULL),('8177701555',NULL,NULL,NULL),('8177701558',NULL,NULL,NULL),('8177701557',NULL,NULL,NULL),('8177701559',NULL,NULL,NULL),('8177701560',NULL,NULL,NULL),('8177701561',NULL,NULL,NULL),('8177701563',NULL,NULL,NULL),('8177701562',NULL,NULL,NULL),('8177701564',NULL,NULL,NULL),('8177701565',NULL,NULL,NULL),('9988001966',NULL,NULL,NULL),('8177701566',NULL,NULL,NULL),('8177701567',NULL,NULL,NULL),('8177701568',NULL,NULL,NULL),('8177701569',NULL,NULL,NULL),('8718800153',NULL,NULL,NULL),('8177701570',NULL,NULL,NULL),('8177701571',NULL,NULL,NULL),('8177701572',NULL,NULL,NULL),('8177701573',NULL,NULL,NULL),('8177701574',NULL,NULL,NULL),('3335605354',NULL,NULL,NULL),('9847770197',NULL,NULL,NULL),('8177700699',NULL,NULL,NULL),('9988001967',NULL,NULL,NULL),('8177701576',NULL,NULL,NULL),('8177701577',NULL,NULL,NULL),('8177701578',NULL,NULL,NULL),('8177701579',NULL,NULL,NULL),('8147773870',NULL,NULL,NULL),('8147773871',NULL,NULL,NULL),('8147773872',NULL,NULL,NULL),('8147773873',NULL,NULL,NULL),('8147773874',NULL,NULL,NULL),('8147773875',NULL,NULL,NULL),('8147773877',NULL,NULL,NULL),('8147773876',NULL,NULL,NULL),('8147773878',NULL,NULL,NULL),('8147773879',NULL,NULL,NULL),('8147773883',NULL,NULL,NULL),('8147773882',NULL,NULL,NULL),('3335605356',NULL,NULL,NULL),('8147773881',NULL,NULL,NULL),('8147773885',NULL,NULL,NULL),('8147773887',NULL,NULL,NULL),('8147773888',NULL,NULL,NULL),('8147773889',NULL,NULL,NULL),('5589958536',NULL,NULL,NULL),('3335605357',NULL,NULL,NULL),('8177702600',NULL,NULL,NULL),('8177702601',NULL,NULL,NULL),('8177702603',NULL,NULL,NULL),('4428880131',NULL,NULL,NULL),('8177702604',NULL,NULL,NULL),('2226443775',NULL,NULL,NULL),('2226443776',NULL,NULL,NULL),('2226443777',NULL,NULL,NULL),('4428880130',NULL,NULL,NULL),('4428880132',NULL,NULL,NULL),('8177702605',NULL,NULL,NULL),('5547776691',NULL,NULL,NULL),('3388801850',NULL,NULL,NULL),('8177700388',NULL,NULL,NULL),('4428880133',NULL,NULL,NULL),('8147773891',NULL,NULL,NULL),('8147773892',NULL,NULL,NULL),('8147773890',NULL,NULL,NULL),('8177702606',NULL,NULL,NULL),('8147773894',NULL,NULL,NULL);
/*!40000 ALTER TABLE `fax_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `featurecodes`
--

LOCK TABLES `featurecodes` WRITE;
/*!40000 ALTER TABLE `featurecodes` DISABLE KEYS */;
INSERT INTO `featurecodes` (`modulename`, `featurename`, `description`, `defaultcode`, `customcode`, `enabled`, `providedest`) VALUES ('core','userlogon','User Logon','*11',NULL,1,0),('core','userlogoff','User Logoff','*12',NULL,1,0),('core','zapbarge','ZapBarge','888',NULL,1,1),('core','simu_pstn','Simulate Incoming Call','7777',NULL,1,1),('fax','simu_fax','Dial System FAX','666',NULL,1,1),('core','chanspy','ChanSpy','555',NULL,1,1),('core','pickup','Directed Call Pickup','**',NULL,1,0),('core','pickupexten','Asterisk General Call Pickup','*8',NULL,1,0),('core','blindxfer','In-Call Asterisk Blind Transfer','##',NULL,1,0),('core','atxfer','In-Call Asterisk Attended Transfer','*2',NULL,1,0),('core','automon','In-Call Asterisk Toggle Call Recording','*1',NULL,1,0),('core','disconnect','In-Call Asterisk Disconnect Code','**',NULL,1,0),('queues','que_pause_toggle','Queue Pause Toggle','*46',NULL,1,0),('infoservices','calltrace','Call Trace','*69',NULL,1,0),('infoservices','echotest','Echo Test','*43',NULL,1,1),('infoservices','speakingclock','Speaking Clock','*60',NULL,1,1),('infoservices','speakextennum','Speak Your Exten Number','*65',NULL,1,0),('voicemail','myvoicemail','My Voicemail','*97',NULL,1,0),('voicemail','dialvoicemail','Dial Voicemail','*98',NULL,1,1),('recordings','record_save','Save Recording','*77',NULL,1,0),('recordings','record_check','Check Recording','*99',NULL,1,0),('callforward','cfon','Call Forward All Activate','*72',NULL,1,0),('callforward','cfoff','Call Forward All Deactivate','*73',NULL,1,0),('callforward','cfoff_any','Call Forward All Prompting Deactivate','*74',NULL,1,0),('callforward','cfbon','Call Forward Busy Activate','*90',NULL,1,0),('callforward','cfboff','Call Forward Busy Deactivate','*91',NULL,1,0),('callforward','cfboff_any','Call Forward Busy Prompting Deactivate','*92',NULL,1,0),('callforward','cfuon','Call Forward No Answer/Unavailable Activate','*52',NULL,1,0),('callforward','cfuoff','Call Forward No Answer/Unavailable Deactivate','*53',NULL,1,0),('callwaiting','cwon','Call Waiting - Activate','*70',NULL,1,0),('callwaiting','cwoff','Call Waiting - Deactivate','*71',NULL,1,0),('dictate','dodictate','Perform dictation','*34',NULL,1,0),('dictate','senddictate','Email completed dictation','*35',NULL,1,0),('donotdisturb','dnd_on','DND Activate','*78',NULL,1,0),('donotdisturb','dnd_off','DND Deactivate','*79',NULL,1,0),('donotdisturb','dnd_toggle','DND Toggle','*76',NULL,1,0),('findmefollow','fmf_toggle','Findme Follow Toggle','*21',NULL,1,0),('paging','intercom-prefix','Intercom prefix','*80',NULL,0,0),('paging','intercom-on','User Intercom Allow','*54',NULL,0,0),('paging','intercom-off','User Intercom Disallow','*55',NULL,0,0),('pbdirectory','app-pbdirectory','Phonebook dial-by-name directory','411',NULL,1,1),('blacklist','blacklist_add','Blacklist a number','*30',NULL,1,1),('blacklist','blacklist_remove','Remove a number from the blacklist','*31',NULL,1,1),('blacklist','blacklist_last','Blacklist the last caller','*32',NULL,1,0),('speeddial','callspeeddial','Speeddial prefix','*0',NULL,1,0),('speeddial','setspeeddial','Set user speed dial','*75',NULL,1,0),('gabcast','gabdial','Connect to Gabcast','*422',NULL,1,0),('queues','que_toggle','Queue Toggle','*45',NULL,1,0),('callforward','cf_toggle','Call Forward Toggle','*740',NULL,1,0),('parking','parkedcall','Pickup ParkedCall Prefix','*85',NULL,1,1),('voicemail','directdialvoicemail','Direct Dial Prefix','*',NULL,1,0),('callforward','cfpon','Call Forward All Prompting Activate','*720',NULL,1,0),('callforward','cfbpon','Call Forward Busy Prompting Activate','*900',NULL,1,0),('callforward','cfupon','Call Forward No Answer/Unavailable Prompting Activate','*520',NULL,1,0),('conferences','conf_status','Conference Status','*87',NULL,1,0),('daynight','toggle-mode-all','All: Call Flow Toggle','*28',NULL,1,0),('queues','que_callers','Queue Callers','*47',NULL,1,0),('timeconditions','toggle-mode-all','All: Time Condition Override','*27',NULL,1,0);
/*!40000 ALTER TABLE `featurecodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `findmefollow`
--

LOCK TABLES `findmefollow` WRITE;
/*!40000 ALTER TABLE `findmefollow` DISABLE KEYS */;
INSERT INTO `findmefollow` (`grpnum`, `strategy`, `grptime`, `grppre`, `grplist`, `annmsg_id`, `postdest`, `dring`, `remotealert_id`, `needsconf`, `toolate_id`, `pre_ring`, `ringing`) VALUES ('8147370215','ringallv2',60,'','8147370215',0,'ivr-10,s,1','',0,'',0,0,'Ring'),('8147370216','ringallv2',60,'','8147370216',0,'ivr-94,s,1','',0,'',0,0,'Ring'),('2226443774','ringallv2',60,'','2226443774',0,'ivr-112,s,1','',0,'',0,0,'Ring'),('2226443775','ringallv2',20,'','8120896028#',0,'ext-local,2226443775,dest','',0,'',0,0,'Ring'),('2226443776','ringallv2',20,'','8120896028#',0,'ext-local,2226443776,dest','',0,'',0,0,'Ring'),('2226443777','ringallv2',20,'','8120896028#',0,'ext-local,2226443777,dest','',0,'',0,0,'Ring'),('2226443778','ringallv2',20,'','8120896028#',0,'ext-local,2226443778,dest','',0,'',0,0,'Ring'),('3335605354','ringallv2',60,'','3335605354',0,'app-announcement-282,s,1','',0,'',0,0,'Ring'),('3335605355','ringallv2',60,'','3335605355',0,'ivr-155,s,1','',0,'',0,0,'Ring'),('3335605356','ringallv2',60,'','8120896028#',0,'ivr-269,s,1','',0,'',0,0,'Ring'),('8177700361','ringallv2',60,'','8177700361',0,'ivr-114,s,1','',0,'',0,0,'Ring'),('8177700367','ringallv2',60,'','8177700367',0,'ivr-120,s,1','',0,'',0,0,'Ring'),('3335605358','ringallv2',20,'','8120896028#',0,'ext-local,3335605358,dest','',0,'',0,0,'Ring'),('5589958531','ringallv2',60,'','5589958531',0,'app-announcement-104,s,1','',0,'',0,0,'Ring'),('5589958532','ringall',60,'','5589958532',0,'app-announcement-334,s,1','',0,'',0,0,'Ring'),('5589958533','ringallv2',60,'','5589958533',0,'app-announcement-106,s,1','',0,'',0,0,'Ring'),('5589958534','ringallv2',60,'','5589958534',0,'ivr-278,s,1','',0,'',0,0,'Ring'),('5589958535','ringallv2',60,'','5589958535',0,'app-announcement-244,s,1','',0,'',0,0,'Ring'),('5589958536','ringallv2',60,'','5589958536',0,'app-announcement-317,s,1','',0,'',0,0,'Ring'),('5589958537','ringallv2',60,'','018007105687#',0,'app-blackhole,ring,1','',0,'',0,0,'Ring'),('5589958538','ringallv2',60,'','018007105687#',0,'app-blackhole,ring,1','',0,'',0,0,'Ring'),('5589958539','ringallv2',60,'','018007105687#',0,'app-blackhole,ring,1','',0,'',0,0,'Ring'),('5589958540','ringallv2',60,'','5589958540',0,'ivr-11,s,1','',0,'',0,0,'Ring'),('8147370217','ringallv2',60,'','8147370217',0,'app-announcement-111,s,1','',0,'',0,0,'Ring'),('8147370218','ringallv2',60,'','8147370218',0,'app-announcement-112,s,1','',0,'',0,0,'Ring'),('9847770193','ringallv2',60,'','9847770193',0,'app-announcement-161,s,1','',0,'',0,0,'Ring'),('8147370224','ringallv2',60,'','8147370224',0,'ivr-73,s,1','',0,'',0,0,'Ring'),('8147370226','ringallv2',60,'','8147370226',0,'app-announcement-93,s,1','',0,'',0,0,'Ring'),('8147370227','ringallv2',60,'','8147370227',0,'app-announcement-94,s,1','',0,'',0,0,'Ring'),('8147370229','ringallv2',60,'','8147370229',0,'app-announcement-295,s,1','',0,'',0,0,'Ring'),('8147370230','ringallv2',60,'','8147370230',0,'app-announcement-102,s,1','',0,'',0,0,'Ring'),('8147370233','ringallv2',60,'','8147370233',0,'app-announcement-209,s,1','',0,'',0,0,'Ring'),('8147370234','ringallv2',60,'','8147370234',0,'app-announcement-249,s,1','',0,'',0,0,'Ring'),('8147370235','ringallv2',60,'','8147370235',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('8147370237','ringallv2',60,'','8147370237',0,'ivr-88,s,1','',0,'',0,0,'Ring'),('8147370238','ringallv2',60,'','8147370238',0,'ivr-89,s,1','',0,'',0,0,'Ring'),('8147370239','ringallv2',60,'','8147370239',0,'app-announcement-74,s,1','',0,'',0,0,'Ring'),('8147370240','ringallv2',60,'','8147370240',0,'app-announcement-83,s,1','',0,'',0,0,'Ring'),('8147370241','ringallv2',60,'','8147370241',0,'app-announcement-85,s,1','',0,'',0,0,'Ring'),('8147370242','ringallv2',60,'','8147370242',0,'app-announcement-86,s,1','',0,'',0,0,'Ring'),('1002','ringallv2',20,'','1002',0,'ext-local,1002,dest','',0,'',0,0,'Ring'),('8147370245','ringallv2',60,'','8147370215',0,'ivr-203,s,1','',0,'',0,0,'Ring'),('8147370246','ringallv2',60,'','8147370246',0,'app-announcement-89,s,1','',0,'',0,0,'Ring'),('8147370247','ringallv2',60,'','8147370247',0,'app-announcement-81,s,1','',0,'',0,0,'Ring'),('8442887386','ringallv2',20,'','8120896028#',0,'ext-local,8442887386,dest','',0,'',0,0,'Ring'),('8442887387','ringallv2',20,'','8120896028#',0,'ext-local,8442887387,dest','',0,'',0,0,'Ring'),('8442887388','ringallv2',20,'','8120896028#',0,'ext-local,8442887388,dest','',0,'',0,0,'Ring'),('8442887389','ringallv2',20,'','8120896028#',0,'ext-local,8442887389,dest','',0,'',0,0,'Ring'),('8442887390','ringallv2',20,'','8120896028#',0,'ext-local,8442887390,dest','',0,'',0,0,'Ring'),('9988001966','ringallv2',60,'','8120896028#',0,'app-announcement-271,s,1','',0,'',0,0,'Ring'),('9988001967','ringallv2',60,'','8120896028#',0,'ivr-248,s,1','',0,'',0,0,'Ring'),('9988001968','ringallv2',20,'','8120896028#',0,'ext-local,9988001968,dest','',0,'',0,0,'Ring'),('9988001969','ringallv2',20,'','8120896028#',0,'ext-local,9988001969,dest','',0,'',0,0,'Ring'),('9988001970','ringallv2',20,'','8120896028#',0,'ext-local,9988001970,dest','',0,'',0,0,'Ring'),('9988001971','ringallv2',20,'','8120896028#',0,'ext-local,9988001971,dest','',0,'',0,0,'Ring'),('9988001972','ringallv2',20,'','8120896028#',0,'ext-local,9988001972,dest','',0,'',0,0,'Ring'),('9988001973','ringallv2',20,'','8120896028#',0,'ext-local,9988001973,dest','',0,'',0,0,'Ring'),('9988001974','ringallv2',20,'','8120896028#',0,'ext-local,9988001974,dest','',0,'',0,0,'Ring'),('9988001975','ringallv2',20,'','8120896028#',0,'ext-local,9988001975,dest','',0,'',0,0,'Ring'),('8177700100','ringallv2',1,'','8177700100',0,'ivr-150,s,1','',0,'',0,0,'Ring'),('8177700101','ringallv2',60,'','8177700101',0,'ivr-84,s,1','',0,'',0,0,'Ring'),('8177700102','ringallv2',60,'','8177700102',0,'ivr-56,s,1','',0,'',0,0,'Ring'),('8177700103','ringallv2',60,'','8177700103',0,'ivr-57,s,1','',0,'',0,0,'Ring'),('8147370231','ringallv2',60,'','8147370231',0,'ivr-90,s,1','',0,'',0,0,'Ring'),('8177700105','ringallv2',60,'','8177700105',0,'ivr-59,s,1','',0,'',0,0,'Ring'),('8177700106','ringallv2',60,'','8177700106',0,'ivr-184,s,1','',0,'',0,0,'Ring'),('8177700107','ringallv2',60,'','8177700107',0,'ivr-167,s,1','',0,'',0,0,'Ring'),('8177700108','ringallv2',60,'','8177700108',0,'ivr-95,s,1','',0,'',0,0,'Ring'),('8177700109','ringallv2',60,'','8177700109',0,'ivr-96,s,1','',0,'',0,0,'Ring'),('8177700110','ringallv2',60,'','8177700110',0,'ivr-97,s,1','',0,'',0,0,'Ring'),('8177700111','ringallv2',60,'','8177700111',0,'ivr-98,s,1','',0,'',0,0,'Ring'),('8177700112','ringallv2',60,'','8177700112',0,'ivr-82,s,1','',0,'',0,0,'Ring'),('8177700113','ringallv2',60,'','8177700113',0,'ivr-79,s,1','',0,'',0,0,'Ring'),('8177700114','ringallv2',60,'','8177700114',0,'ivr-80,s,1','',0,'',0,0,'Ring'),('8177700115','ringallv2',60,'','8177700115',0,'ivr-81,s,1','',0,'',0,0,'Ring'),('8177700116','ringallv2',60,'','8177700116',0,'ivr-99,s,1','',0,'',0,0,'Ring'),('8177700117','ringallv2',60,'','8177700117',0,'ivr-100,s,1','',0,'',0,0,'Ring'),('8177700118','ringallv2',60,'','8177700118',0,'ivr-101,s,1','',0,'',0,0,'Ring'),('8177700119','ringallv2',60,'','8177700119',0,'app-announcement-121,s,1','',0,'',0,0,'Ring'),('8177700120','ringallv2',60,'','8177700120',0,'ivr-103,s,1','',0,'',0,0,'Ring'),('8177700121','ringallv2',60,'','8177700121',0,'ivr-104,s,1','',0,'',0,0,'Ring'),('8177700122','ringallv2',60,'','8177700122',0,'ivr-105,s,1','',0,'',0,0,'Ring'),('8177700123','ringallv2',60,'','8177700123',0,'ivr-106,s,1','',0,'',0,0,'Ring'),('8177700124','ringallv2',60,'','8177700124',0,'ivr-110,s,1','',0,'',0,0,'Ring'),('5588804680','ringallv2',60,'','5588804680',0,'ivr-231,s,1','',0,'',0,0,'Ring'),('8147370232','ringallv2',60,'','8147370232',0,'ivr-91,s,1','',0,'',0,0,'Ring'),('8177700104','ringallv2',60,'','8177700104',0,'ivr-58,s,1','',0,'',0,0,'Ring'),('9847770191','ringallv2',60,'','9847770191',0,'ivr-108,s,1','',0,'',0,0,'Ring'),('3388800130','ringallv2',60,'','3388800130',0,'ivr-10,s,1','',0,'',0,0,'Ring'),('2228800360','ringallv2',60,'','2228800360',0,'ivr-273,s,1','',0,'',0,0,'Ring'),('9847770190','ringallv2',60,'','9847770190',0,'ivr-249,s,1','',0,'',0,0,'Ring'),('8447770070','ringallv2',60,'','8447770070',0,'app-announcement-322,s,1','',0,'',0,0,'Ring'),('3001','ringallv2',20,'','3001',0,'ext-queues,1000,1','',0,'',0,0,'Ring'),('8447770071','ringallv2',20,'','018008366800#',0,'ext-local,8447770071,dest','',0,'',0,0,'Ring'),('8447770074','ringallv2',20,'','0458112628563#',0,'ext-local,8447770074,dest','',0,'',0,0,'Ring'),('5588804682','ringallv2',60,'','5588804682',0,'app-announcement-344,s,1','',0,'',0,0,'Ring'),('8177700365','ringallv2',60,'','8177700365',0,'ivr-118,s,1','',0,'',0,0,'Ring'),('8177700366','ringallv2',60,'','8177700366',0,'ivr-119,s,1','',0,'',0,0,'Ring'),('8177700369','ringallv2',60,'','8177700369',0,'ivr-122,s,1','',0,'',0,0,'Ring'),('4428880130','ringallv2',60,'','4428880130',0,'app-announcement-336,s,1','',0,'',0,0,'Ring'),('8177700371','ringallv2',60,'','8177700371',0,'ivr-123,s,1','',0,'',0,0,'Ring'),('8177700370','ringallv2',60,'','8177700370',0,'app-announcement-149,s,1','',0,'',0,0,'Ring'),('8177700362','ringallv2',60,'','8177700362',0,'ivr-115,s,1','',0,'',0,0,'Ring'),('8177700376','ringallv2',60,'','8177700376',0,'ivr-117,s,1','',0,'',0,0,'Ring'),('8177700378','ringallv2',60,'','8177700378',0,'ivr-131,s,1','',0,'',0,0,'Ring'),('81777001001','ringallv2',60,'','8117276008#-8118902315#-8113762071#-8117071665#',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('8177700383','ringallv2',60,'','8177700383',0,'app-announcement-157,s,1','',0,'',0,0,'Ring'),('4428880131','ringallv2',60,'','4428880131',0,'app-announcement-330,s,1','',0,'',0,0,'Ring'),('4428880132','ringallv2',60,'','4428880132',0,'app-announcement-337,s,1','',0,'',0,0,'Ring'),('4428880133','ringallv2',60,'','4428880133',0,'app-announcement-349,s,1','',0,'',0,0,'Ring'),('4428880134','ringallv2',20,'','018008366800#',0,'ext-local,4428880134,dest','',0,'',0,0,'Ring'),('4428880135','ringallv2',60,'','018008366800#',0,'ext-local,4428880135,dest','',0,'',0,0,'Ring'),('4428880136','ringallv2',60,'','018008366800#',0,'ext-local,4428880136,dest','',0,'',0,0,'Ring'),('4428880137','ringallv2',60,'','018008366800#',0,'ext-local,4428880137,dest','',0,'',0,0,'Ring'),('4428880138','ringallv2',60,'','018008366800#',0,'ext-local,4428880138,dest','',0,'',0,0,'Ring'),('4428880139','ringallv2',60,'','018008366800#',0,'ext-local,4428880139,dest','',0,'',0,0,'Ring'),('8177700384','ringallv2',60,'','8177700384',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('8177700385','ringallv2',60,'','8177700385',0,'app-announcement-160,s,1','',0,'',0,0,'Ring'),('8177700386','ringallv2',60,'','8177700386',0,'ivr-142,s,1','',0,'',0,0,'Ring'),('8177700387','ringallv2',60,'','8177700387',0,'ivr-156,s,1','',0,'',0,0,'Ring'),('8177700388','ringallv2',60,'','8177700388',0,'ivr-143,s,1','',0,'',0,0,'Ring'),('8177700389','ringallv2',60,'','8177700389',0,'app-announcement-196,s,1','',0,'',0,0,'Ring'),('9847770199','ringallv2',60,'','9847770199',0,'ext-local,9847770199,dest','',0,'',0,0,'Ring'),('8177700380','ringallv2',60,'','8177700380',0,'app-announcement-172,s,1','',0,'',0,0,'Ring'),('8177700671','ringallv2',60,'','8177700671',0,'app-announcement-197,s,1','',0,'',0,0,'Ring'),('8177700676','ringallv2',60,'','8177700676',0,'app-announcement-207,s,1','',0,'',0,0,'Ring'),('8177700673','ringallv2',60,'','8177700673',0,'app-announcement-200,s,1','',0,'',0,0,'Ring'),('8177700670','ringallv2',20,'','8177700670',0,'ext-queues,18177700670,1','',0,'',0,0,'Ring'),('8177700674','ringallv2',60,'','8177700674',0,'ivr-161,s,1','',0,'',0,0,'Ring'),('8147370244','ringallv2',60,'','8147370244',0,'app-announcement-233,s,1','',0,'',0,0,'Ring'),('8177700672','ringallv2',60,'','8177700672',0,'ivr-162,s,1','',0,'',0,0,'Ring'),('8177700677','ringallv2',60,'','8177700677',0,'app-announcement-211,s,1','',0,'',0,0,'Ring'),('8177700678','ringallv2',60,'','8177700678',0,'ivr-171,s,1','',0,'',0,0,'Ring'),('8177700679','ringallv2',60,'','8177700679',0,'app-announcement-213,s,1','',0,'',0,0,'Ring'),('8177700680','ringallv2',60,'','8177700680',0,'app-announcement-214,s,1','',0,'',0,0,'Ring'),('8177700681','ringallv2',60,'','8177700681',0,'ivr-174,s,1','',0,'',0,0,'Ring'),('8177700683','ringallv2',60,'','8177700683',0,'app-announcement-217,s,1','',0,'',0,0,'Ring'),('8177700684','ringallv2',60,'','8177700684',0,'app-announcement-218,s,1','',0,'',0,0,'Ring'),('8177700685','ringallv2',60,'','8177700685',0,'app-announcement-219,s,1','',0,'',0,0,'Ring'),('8177700377','ringallv2',60,'','8177700377',0,'ivr-257,s,1','',0,'',0,0,'Ring'),('8177700689','ringallv2',60,'','8177700689',0,'ivr-182,s,1','',0,'',0,0,'Ring'),('8177700691','ringallv2',60,'','8177700691',0,'app-announcement-224,s,1','',0,'',0,0,'Ring'),('8177700692','ringallv2',60,'','8177700692',0,'app-announcement-226,s,1','',0,'',0,0,'Ring'),('8177700690','ringallv2',60,'','8177700690',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('8177700693','ringallv2',60,'','8177700693',0,'app-announcement-230,s,1','',0,'',0,0,'Ring'),('8177700695','ringallv2',60,'','8177700695',0,'app-announcement-231,s,1','',0,'',0,0,'Ring'),('8177700694','ringallv2',60,'','8177700694',0,'app-announcement-232,s,1','',0,'',0,0,'Ring'),('8177700381','ringallv2',60,'','8177700381',0,'ivr-134,s,1','',0,'',0,0,'Ring'),('8177700360','ringallv2',60,'','8177700360',0,'ivr-113,s,1','',0,'',0,0,'Ring'),('9847770194','ringallv2',60,'','9847770194',0,'ivr-194,s,1','',0,'',0,0,'Ring'),('5588804685','ringallv2',60,'','5588804685',0,'ivr-196,s,1','',0,'',0,0,'Ring'),('8147370221','ringallv2',60,'','8147370221',0,'ivr-145,s,1','',0,'',0,0,'Ring'),('8177700698','ringallv2',60,'','8177700698',0,'ivr-197,s,1','',0,'',0,0,'Ring'),('8177701550','ringallv2',60,'','8177701550',0,'ivr-198,s,1','',0,'',0,0,'Ring'),('8177700364','ringallv2',60,'','8177700364',0,'app-announcement-151,s,1','',0,'',0,0,'Ring'),('3388800133','ringallv2',60,'','3388800133',0,'ivr-200,s,1','',0,'',0,0,'Ring'),('8177701551','ringallv2',60,'','8177701551',0,'app-announcement-242,s,1','',0,'',0,0,'Ring'),('8177700686','ringallv2',60,'','8177700686',0,'ivr-179,s,1','',0,'',0,0,'Ring'),('5588804681','ringallv2',60,'','5588804681',0,'ivr-205,s,1','',0,'',0,0,'Ring'),('8177701552','ringallv2',60,'','8177701552',0,'app-announcement-245,s,1','',0,'',0,0,'Ring'),('9847770195','ringallv2',60,'','9847770195',0,'app-announcement-246,s,1','',0,'',0,0,'Ring'),('8177701553','ringallv2',60,'','8177701553',0,'ivr-211,s,1','',0,'',0,0,'Ring'),('8177701554','ringallv2',60,'','8177701554',0,'app-announcement-248,s,1','',0,'',0,0,'Ring'),('3388800131','ringallv2',60,'','3388800131',0,'app-announcement-281,s,1','',0,'',0,0,'Ring'),('9847770196','ringallv2',60,'','9847770196',0,'ivr-216,s,1','',0,'',0,0,'Ring'),('8718800156','ringallv2',60,'','8718800156',0,'ivr-217,s,1','',0,'',0,0,'Ring'),('8718800151','ringallv2',60,'','8718800151',0,'ivr-217,s,1','',0,'',0,0,'Ring'),('8718800152','ringallv2',60,'','8718800152',0,'app-announcement-252,s,1','',0,'',0,0,'Ring'),('8177700379','ringallv2',60,'','8177700379',0,'ivr-219,s,1','',0,'',0,0,'Ring'),('8177701556','ringallv2',60,'','8177701556',0,'app-announcement-254,s,1','',0,'',0,0,'Ring'),('5588804683','ringallv2',60,'','5588804683',0,'ivr-213,s,1','',0,'',0,0,'Ring'),('8177701558','ringallv2',60,'','8177701558',0,'ivr-222,s,1','',0,'',0,0,'Ring'),('8177701557','ringallv2',60,'','8177701557',0,'app-announcement-259,s,1','',0,'',0,0,'Ring'),('8177701559','ringallv2',60,'','8177701559',0,'ivr-224,s,1','',0,'',0,0,'Ring'),('8177701560','ringallv2',60,'','8177701560',0,'ivr-225,s,1','',0,'',0,0,'Ring'),('8177701561','ringallv2',60,'','8177701561',0,'app-announcement-262,s,1','',0,'',0,0,'Ring'),('8177701573','ringallv2',60,'','8177701573',0,'ivr-243,s,1','',0,'',0,0,'Ring'),('8177700699','ringallv2',60,'','8177700699',0,'ivr-247,s,1','',0,'',0,0,'Ring'),('8177701563','ringallv2',60,'','8177701563',0,'ivr-227,s,1','',0,'',0,0,'Ring'),('8177701562','ringallv2',60,'','8177701562',0,'ivr-228,s,1','',0,'',0,0,'Ring'),('8177701564','ringallv2',60,'','8177701564',0,'app-announcement-267,s,1','',0,'',0,0,'Ring'),('8177701566','ringallv2',60,'','8177701566',0,'app-announcement-272,s,1','',0,'',0,0,'Ring'),('8177701567','ringallv2',60,'','8177701567',0,'ivr-234,s,1','',0,'',0,0,'Ring'),('8177701568','ringallv2',60,'','8177701568',0,'ivr-235,s,1','',0,'',0,0,'Ring'),('8177701569','ringallv2',60,'','8177701569',0,'app-announcement-275,s,1','',0,'',0,0,'Ring'),('8718800153','ringallv2',60,'','8718800153',0,'ivr-238,s,1','',0,'',0,0,'Ring'),('8718800154','ringallv2',60,'','8718800154',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('8177701570','ringallv2',60,'','8177701570',0,'app-announcement-277,s,1','',0,'',0,0,'Ring'),('8177701571','ringallv2',60,'','8177701571',0,'app-announcement-342,s,1','',0,'',0,0,'Ring'),('8177701572','ringallv2',60,'','8177701572',0,'app-announcement-263,s,1','',0,'',0,0,'Ring'),('8177701574','ringallv2',60,'','8177701574',0,'ivr-244,s,1','',0,'',0,0,'Ring'),('9847770197','ringallv2',60,'','9847770197',0,'app-announcement-283,s,1','',0,'',0,0,'Ring'),('8177701575','ringallv2',60,'','8177701575',0,'app-announcement-287,s,1','',0,'',0,0,'Ring'),('8177701577','ringallv2',60,'','8177701577',0,'app-announcement-289,s,1','',0,'',0,0,'Ring'),('8177701578','ringallv2',60,'','8177701578',0,'app-announcement-290,s,1','',0,'',0,0,'Ring'),('8177701579','ringallv2',60,'','8177701579',0,'app-announcement-286,s,1','',0,'',0,0,'Ring'),('8147773870','ringallv2',60,'','8147773870',0,'app-announcement-291,s,1','',0,'',0,0,'Ring'),('8147773871','ringallv2',60,'','8147773871',0,'app-announcement-292,s,1','',0,'',0,0,'Ring'),('81777001081','ringallv2',60,'','0448119643327#-0448119643527#',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('8147773872','ringallv2',60,'','8147773872',0,'app-announcement-294,s,1','',0,'',0,0,'Ring'),('8147773873','ringallv2',60,'','8147773873',0,'ivr-259,s,1','',0,'',0,0,'Ring'),('8177701576','ringallv2',60,'','8177701576',0,'ivr-251,s,1','',0,'',0,0,'Ring'),('8177700697','ringallv2',60,'','8177700697',0,'ivr-195,s,1','',0,'',0,0,'Ring'),('8177701555','ringallv2',60,'','8177701555',0,'app-announcement-255,s,1','',0,'',0,0,'Ring'),('5588804684','ringallv2',60,'','5588804684',0,'app-announcement-346,s,1','',0,'',0,0,'Ring'),('8147773874','ringallv2',60,'','8147773874',0,'app-announcement-298,s,1','',0,'',0,0,'Ring'),('8147773875','ringallv2',60,'','8147773875',0,'app-announcement-299,s,1','',0,'',0,0,'Ring'),('8147773877','ringallv2',60,'','8147773877',0,'app-announcement-300,s,1','',0,'',0,0,'Ring'),('8147773876','ringallv2',60,'','8147773876',0,'ivr-264,s,1','',0,'',0,0,'Ring'),('8177700687','ringallv2',60,'','8177700687',0,'ivr-180,s,1','',0,'',0,0,'Ring'),('8177700688','ringallv2',60,'','8177700688',0,'ivr-181,s,1','',0,'',0,0,'Ring'),('8147773878','ringallv2',60,'','8147773878',0,'ivr-265,s,1','',0,'',0,0,'Ring'),('8147773879','ringallv2',60,'','8147773879',0,'ivr-266,s,1','',0,'',0,0,'Ring'),('8147773883','ringallv2',60,'','8147773883',0,'app-announcement-304,s,1','',0,'',0,0,'Ring'),('8147773882','ringallv2',60,'','8147773882',0,'app-announcement-309,s,1','',0,'',0,0,'Ring'),('5588804686','ringallv2',60,'','5588804686',0,'ivr-268,s,1','',0,'',0,0,'Ring'),('8147773881','ringallv2',60,'','8147773881',0,'app-announcement-308,s,1','',0,'',0,0,'Ring'),('8177700374','ringallv2',60,'','8177700374',0,'ivr-126,s,1','',0,'',0,0,'Ring'),('8147773884','ringallv2',60,'','8147773884',0,'ivr-274,s,1','',0,'',0,0,'Ring'),('8147773885','ringallv2',60,'','8147773885',0,'app-announcement-311,s,1','',0,'',0,0,'Ring'),('8147773887','ringallv2',60,'','8147773887',0,'app-announcement-312,s,1','',0,'',0,0,'Ring'),('8147773886','ringallv2',60,'','8147773886',0,'ivr-277,s,1','',0,'',0,0,'Ring'),('5588804687','ringallv2',60,'','5588804687',0,'ivr-79,s,1','',0,'',0,0,'Ring'),('8147773888','ringallv2',60,'','8147773888',0,'ivr-280,s,1','',0,'',0,0,'Ring'),('8147773889','ringallv2',60,'','8147773889',0,'ivr-281,s,1','',0,'',0,0,'Ring'),('2228800361','ringallv2',60,'','2228800361',0,'app-announcement-321,s,1','',0,'',0,0,'Ring'),('8147773893','ringallv2',60,'','8147773893',0,'ivr-289,s,1','',0,'',0,0,'Ring'),('2228800362','ringallv2',60,'','2228800362',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('8147773891','ringallv2',60,'','8147773891',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('2297770470','ringallv2',60,'','2297770470',0,'app-blackhole,hangup,1','',0,'',0,0,'Ring'),('8177700696','ringallv2',60,'','8177700696',0,'ivr-193,s,1','',0,'',0,0,'Ring'),('8177702600','ringallv2',60,'','8177702600',0,'ivr-295,s,1','',0,'',0,0,'Ring'),('8177702601','ringallv2',60,'','8177702601',0,'ivr-296,s,1','',0,'',0,0,'Ring'),('8177702602','ringallv2',60,'','8177702602',0,'ivr-297,s,1','',0,'',0,0,'Ring'),('5588804688','ringallv2',60,'','5588804688',0,'ivr-298,s,1','',0,'',0,0,'Ring'),('8177702603','ringallv2',60,'','8177702603',0,'ivr-299,s,1','',0,'',0,0,'Ring'),('8177702604','ringallv2',60,'','8177702604',0,'app-announcement-305,s,1','',0,'',0,0,'Ring'),('8147773894','ringallv2',60,'','8147773894',0,'ivr-291,s,1','',0,'',0,0,'Ring'),('8147773892','ringallv2',60,'','8147773892',0,'ivr-287,s,1','',0,'',0,0,'Ring'),('8177700363','ringallv2',60,'','8177700363',0,'ivr-116,s,1','',0,'',0,0,'Ring'),('8177700682','ringallv2',60,'','8177700682',0,'ivr-175,s,1','',0,'',0,0,'Ring'),('8177702605','ringallv2',60,'','8177702605',0,'ivr-308,s,1','',0,'',0,0,'Ring'),('5547776691','ringallv2',60,'','5547776691',0,'ivr-309,s,1','',0,'',0,0,'Ring'),('3388801850','ringallv2',60,'','3388801850',0,'ivr-310,s,1','',0,'',0,0,'Ring'),('3388800134','ringallv2',60,'','3388800134',0,'ivr-311,s,1','',0,'',0,0,'Ring'),('8177700368','ringallv2',60,'','8177700368',0,'ivr-121,s,1','',0,'',0,0,'Ring'),('8177700382','ringallv2',60,'','8177700382',0,'ivr-135,s,1','',0,'',0,0,'Ring'),('8177700375','ringallv2',60,'','8177700375',0,'ivr-127,s,1','',0,'',0,0,'Ring'),('8177700372','ringallv2',60,'','8177700372',0,'ivr-124,s,1','',0,'',0,0,'Ring'),('8177700373','ringallv2',60,'','8177700373',0,'ivr-125,s,1','',0,'',0,0,'Ring'),('8177700675','ringallv2',60,'','8177700675',0,'ivr-164,s,1','',0,'',0,0,'Ring'),('8177701565','ringallv2',60,'','8177701565',0,'ivr-230,s,1','',0,'',0,0,'Ring'),('9847770192','ringallv2',60,'','9847770192',0,'ivr-109,s,1','',0,'',0,0,'Ring'),('8177702606','ringallv2',60,'','8177702606',0,'ivr-315,s,1','',0,'',0,0,'Ring'),('8147773890','ringallv2',60,'','8147773890',0,'ivr-286,s,1','',0,'',0,0,'Ring');
/*!40000 ALTER TABLE `findmefollow` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `gabcast`
--

LOCK TABLES `gabcast` WRITE;
/*!40000 ALTER TABLE `gabcast` DISABLE KEYS */;
/*!40000 ALTER TABLE `gabcast` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `globals`
--

LOCK TABLES `globals` WRITE;
/*!40000 ALTER TABLE `globals` DISABLE KEYS */;
INSERT INTO `globals` (`variable`, `value`) VALUES ('FAX_RX','system'),('FAX_RX_EMAIL','fax@mydomain.com'),('FAX_RX_FROM','fax@issabel.org');
/*!40000 ALTER TABLE `globals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `iax`
--

LOCK TABLES `iax` WRITE;
/*!40000 ALTER TABLE `iax` DISABLE KEYS */;
/*!40000 ALTER TABLE `iax` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `iaxsettings`
--

LOCK TABLES `iaxsettings` WRITE;
/*!40000 ALTER TABLE `iaxsettings` DISABLE KEYS */;
INSERT INTO `iaxsettings` (`keyword`, `data`, `seq`, `type`) VALUES ('codecpriority','host',0,0),('bandwidth','unset',0,0),('videosupport','no',10,0),('maxregexpire','3600',10,0),('minregexpire','60',10,0),('jitterbuffer','no',4,0),('forcejitterbuffer','no',5,0),('maxjitterbuffer','200',5,0),('resyncthreshold','1000',5,0),('maxjitterinterps','10',5,0),('iax_language','',0,0),('bindaddr','',2,0),('bindport','',1,0),('delayreject','yes',0,0),('ulaw','1',0,1),('alaw','3',1,1),('slin','',2,1),('g726','',3,1),('gsm','2',4,1),('g729','4',5,1),('ilbc','',6,1),('g723','',7,1),('g726aal2','',8,1),('adpcm','',9,1),('lpc10','',10,1),('speex','',11,1),('g722','',12,1),('siren7','',13,1),('siren14','',14,1),('h261','',0,2),('h263','',1,2),('h263p','',2,2),('h264','',3,2);
/*!40000 ALTER TABLE `iaxsettings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `incoming`
--

LOCK TABLES `incoming` WRITE;
/*!40000 ALTER TABLE `incoming` DISABLE KEYS */;
INSERT INTO `incoming` (`cidnum`, `extension`, `destination`, `faxexten`, `faxemail`, `answer`, `wait`, `privacyman`, `alertinfo`, `ringing`, `mohclass`, `description`, `grppre`, `delay_answer`, `pricid`, `pmmaxretries`, `pmminlength`) VALUES ('8177700102','8177700102','from-did-direct,8177700102,1',NULL,NULL,NULL,NULL,0,'','','default','8177700102','',0,'','',''),('8147370216','8147370216','from-did-direct,8147370216,1',NULL,NULL,NULL,NULL,0,'','','default','8147370216','',0,'','',''),('8147370217','8147370217','from-did-direct,8147370217,1',NULL,NULL,NULL,NULL,0,'','','default','8147370217','',0,'','3','10'),('8147370218','8147370218','from-did-direct,8147370218,1',NULL,NULL,NULL,NULL,0,'','','default','8147370218','',0,'','',''),('8147370221','8147370221','from-did-direct,8147370221,1',NULL,NULL,NULL,NULL,0,'','','default','8147370221','',0,'','',''),('8147370224','8147370224','from-did-direct,8147370224,1',NULL,NULL,NULL,NULL,0,'','','default','8147370224','',0,'','',''),('8147370226','8147370226','from-did-direct,8147370226,1',NULL,NULL,NULL,NULL,0,'','','default','8147370226','',0,'','',''),('8147370227','8147370227','from-did-direct,8147370227,1',NULL,NULL,NULL,NULL,0,'','','default','8147370227','',0,'','',''),('8147370229','8147370229','from-did-direct,8147370229,1',NULL,NULL,NULL,NULL,0,'','','default','8147370229','',0,'','',''),('8147370230','8147370230','from-did-direct,8147370230,1',NULL,NULL,NULL,NULL,0,'','','default','8147370230','',0,'','',''),('8147370231','8147370231','from-did-direct,8147370231,1',NULL,NULL,NULL,NULL,0,'','','default','8147370231','',0,'','',''),('8147370232','8147370232','from-did-direct,8147370232,1',NULL,NULL,NULL,NULL,0,'','','default','8147370232','',0,'','',''),('8147370233','8147370233','from-did-direct,8147370233,1',NULL,NULL,NULL,NULL,0,'','','default','8147370233','',0,'','',''),('8147370234','8147370234','from-did-direct,8147370234,1',NULL,NULL,NULL,NULL,0,'','','default','8147370234','',0,'','',''),('8147370235','8147370235','from-did-direct,8147370235,1',NULL,NULL,NULL,NULL,0,'','','default','8147370235','',0,'','',''),('8147370237','8147370237','from-did-direct,8147370237,1',NULL,NULL,NULL,NULL,0,'','','default','8147370237','',0,'','',''),('8147370238','8147370238','from-did-direct,8147370238,1',NULL,NULL,NULL,NULL,0,'','','default','8147370238','',0,'','',''),('8147370239','8147370239','from-did-direct,8147370239,1',NULL,NULL,NULL,NULL,0,'','','default','8147370239','',0,'','',''),('8147370240','8147370240','from-did-direct,8147370240,1',NULL,NULL,NULL,NULL,0,'','','default','8147370240','',0,'','3','10'),('8147370241','8147370241','from-did-direct,8147370241,1',NULL,NULL,NULL,NULL,0,'','','default','8147370241','',0,'','',''),('8147370242','8147370242','from-did-direct,8147370242,1',NULL,NULL,NULL,NULL,0,'','','default','8147370242','',0,'','',''),('8147370244','8147370244','from-did-direct,8147370244,1',NULL,NULL,NULL,NULL,0,'','','default','','',0,'','',''),('8147370245','8147370245','from-did-direct,8147370245,1',NULL,NULL,NULL,NULL,0,'','','default','8147370245','',0,'','',''),('8147370246','8147370246','from-did-direct,8147370246,1',NULL,NULL,NULL,NULL,0,'','','default','8147370246','',0,'','',''),('8147370247','8147370247','from-did-direct,8147370247,1',NULL,NULL,NULL,NULL,0,'','','default','8147370247','',0,'','',''),('5589958531','5589958531','from-did-direct,5589958531,1',NULL,NULL,NULL,NULL,0,'','','default','5589958531','',0,'','',''),('5589958532','5589958532','from-did-direct,5589958532,1',NULL,NULL,NULL,NULL,0,'','','default','5589958532','',0,'','',''),('5589958533','5589958533','from-did-direct,5589958533,1',NULL,NULL,NULL,NULL,0,'','','default','5589958533','',0,'','',''),('5589958534','5589958534','from-did-direct,5589958534,1',NULL,NULL,NULL,NULL,0,'','','default','5589958534','',0,'','',''),('5589958535','5589958535','from-did-direct,5589958535,1',NULL,NULL,NULL,NULL,0,'','','default','5589958535','',0,'','',''),('5589958536','5589958536','from-did-direct,5589958536,1',NULL,NULL,NULL,NULL,0,'','','default','5589958536','',0,'','',''),('5589958537','5589958537','from-did-direct,5589958537,1',NULL,NULL,NULL,NULL,0,'','','default','5589958537','',0,'','',''),('5589958538','5589958538','from-did-direct,5589958538,1',NULL,NULL,NULL,NULL,0,'','','default','5589958538','',0,'','',''),('5589958539','5589958539','from-did-direct,5589958539,1',NULL,NULL,NULL,NULL,0,'','','default','5589958539','',0,'','',''),('8177700100','8177700100','from-did-direct,8177700100,1',NULL,NULL,NULL,NULL,0,'','','default','8177700100','',0,'','',''),('3335605354','3335605354','from-did-direct,3335605354,1',NULL,NULL,NULL,NULL,0,'','','default','3335605354','',0,'','',''),('3335605355','3335605355','from-did-direct,3335605355,1',NULL,NULL,NULL,NULL,0,'','','default','3335605355','',0,'','',''),('3335605356','3335605356','from-did-direct,3335605356,1',NULL,NULL,NULL,NULL,0,'','','default','3335605356','',0,'','',''),('3335605357','3335605357','from-did-direct,3335605357,1',NULL,NULL,NULL,NULL,0,'','','default','3335605357','',0,'','',''),('3335605358','3335605358','from-did-direct,3335605358,1',NULL,NULL,NULL,NULL,0,'','','default','3335605358','',0,'','',''),('2226443774','2226443774','from-did-direct,2226443774,1',NULL,NULL,NULL,NULL,0,'','','default','2226443774','',0,'','',''),('2226443775','2226443775','from-did-direct,2226443775,1',NULL,NULL,NULL,NULL,0,'','','default','2226443775','',0,'','',''),('2226443776','2226443776','from-did-direct,2226443776,1',NULL,NULL,NULL,NULL,0,'','','default','2226443776','',0,'','',''),('2226443777','2226443777','from-did-direct,2226443777,1',NULL,NULL,NULL,NULL,0,'','','default','2226443777','',0,'','',''),('2226443778','2226443778','from-did-direct,2226443778,1',NULL,NULL,NULL,NULL,0,'','','default','2226443778','',0,'','',''),('8442887386','8442887386','from-did-direct,8442887386,1',NULL,NULL,NULL,NULL,0,'','','default','8442887386','',0,'','',''),('8442887387','8442887387','from-did-direct,8442887387,1',NULL,NULL,NULL,NULL,0,'','','default','8442887387','',0,'','',''),('8442887388','8442887388','from-did-direct,8442887388,1',NULL,NULL,NULL,NULL,0,'','','default','8442887388','',0,'','',''),('8442887389','8442887389','from-did-direct,8442887389,1',NULL,NULL,NULL,NULL,0,'','','default','8442887389','',0,'','',''),('8442887390','8442887390','from-did-direct,8442887390,1',NULL,NULL,NULL,NULL,0,'','','default','8442887390','',0,'','',''),('9988001966','9988001966','from-did-direct,9988001966,1',NULL,NULL,NULL,NULL,0,'','','default','9988001966','',0,'','',''),('9988001967','9988001967','from-did-direct,9988001967,1',NULL,NULL,NULL,NULL,0,'','','default','9988001967','',0,'','',''),('9988001968','9988001968','from-did-direct,9988001968,1',NULL,NULL,NULL,NULL,0,'','','default','9988001968','',0,'','',''),('9988001969','9988001969','from-did-direct,9988001969,1',NULL,NULL,NULL,NULL,0,'','','default','9988001969','',0,'','',''),('9988001970','9988001970','from-did-direct,9988001970,1',NULL,NULL,NULL,NULL,0,'','','default','9988001970','',0,'','',''),('9988001971','9988001971','from-did-direct,9988001971,1',NULL,NULL,NULL,NULL,0,'','','default','9988001971','',0,'','',''),('9988001972','9988001972','from-did-direct,9988001972,1',NULL,NULL,NULL,NULL,0,'','','default','9988001972','',0,'','',''),('9988001973','9988001973','from-did-direct,9988001973,1',NULL,NULL,NULL,NULL,0,'','','default','9988001973','',0,'','',''),('9988001974','9988001974','from-did-direct,9988001974,1',NULL,NULL,NULL,NULL,0,'','','default','9988001974','',0,'','',''),('9988001975','9988001975','from-did-direct,9988001975,1',NULL,NULL,NULL,NULL,0,'','','default','9988001975','',0,'','',''),('8177700101','8177700101','from-did-direct,8177700101,1',NULL,NULL,NULL,NULL,0,'','','default','8177700101','',0,'','',''),('','','from-did-direct,8177700103,1',NULL,NULL,NULL,NULL,0,'','','default','8177700103','',0,'','3','10'),('8177700104','8177700104','from-did-direct,8177700104,1',NULL,NULL,NULL,NULL,0,'','','default','8177700104','',0,'','',''),('8177700105','8177700105','from-did-direct,8177700105,1',NULL,NULL,NULL,NULL,0,'','','default','8177700105','',0,'','',''),('8177700106','8177700106','from-did-direct,8177700106,1',NULL,NULL,NULL,NULL,0,'','','default','8177700106','',0,'','',''),('8177700107','8177700107','from-did-direct,8177700107,1',NULL,NULL,NULL,NULL,0,'','','default','8177700107','',0,'','',''),('8177700108','8177700108','from-did-direct,8177700108,1',NULL,NULL,NULL,NULL,0,'','','default','8177700108','',0,'','',''),('8177700109','8177700109','from-did-direct,8177700109,1',NULL,NULL,NULL,NULL,0,'','','default','8177700109','',0,'','',''),('8177700110','8177700110','from-did-direct,8177700110,1',NULL,NULL,NULL,NULL,0,'','','default','8177700110','',0,'','',''),('8177700111','8177700111','from-did-direct,8177700111,1',NULL,NULL,NULL,NULL,0,'','','default','8177700111','',0,'','',''),('8177700112','8177700112','from-did-direct,8177700112,1',NULL,NULL,NULL,NULL,0,'','','default','8177700112','',0,'','',''),('8177700113','8177700113','from-did-direct,8177700113,1',NULL,NULL,NULL,NULL,0,'','','default','8177700113','',0,'','',''),('8177700114','8177700114','from-did-direct,8177700114,1',NULL,NULL,NULL,NULL,0,'','','default','8177700114','',0,'','',''),('8177700115','8177700115','from-did-direct,8177700115,1',NULL,NULL,NULL,NULL,0,'','','default','8177700115','',0,'','',''),('8177700116','8177700116','from-did-direct,8177700116,1',NULL,NULL,NULL,NULL,0,'','','default','8177700116','',0,'','',''),('8177700117','8177700117','from-did-direct,8177700117,1',NULL,NULL,NULL,NULL,0,'','','default','8177700117','',0,'','',''),('8177700118','8177700118','from-did-direct,8177700118,1',NULL,NULL,NULL,NULL,0,'','','default','8177700118','',0,'','',''),('8177700119','8177700119','from-did-direct,8177700119,1',NULL,NULL,NULL,NULL,0,'','','default','8177700119','',0,'','',''),('8177700120','8177700120','from-did-direct,8177700120,1',NULL,NULL,NULL,NULL,0,'','','default','8177700120','',0,'','',''),('8177700121','8177700121','from-did-direct,8177700121,1',NULL,NULL,NULL,NULL,0,'','','default','8177700121','',0,'','',''),('8177700122','8177700122','from-did-direct,8177700122,1',NULL,NULL,NULL,NULL,0,'','','default','8177700122','',0,'','',''),('8177700123','8177700123','from-did-direct,8177700123,1',NULL,NULL,NULL,NULL,0,'','','default','8177700123','',0,'','',''),('8177700124','8177700124','from-did-direct,8177700124,1',NULL,NULL,NULL,NULL,0,'','','default','8177700124','',0,'','',''),('5588804680','5588804680','from-did-direct,5588804680,1',NULL,NULL,NULL,NULL,0,'','','default','5588804680','',0,'','',''),('3388800130','3388800130','from-did-direct,3388800130,1',NULL,NULL,NULL,NULL,0,'','','default','3388800130','',0,'','',''),('2228800360','2228800360','from-did-direct,2228800360,1',NULL,NULL,NULL,NULL,0,'','','default','2228800360','',0,'','',''),('9847770190','9847770190','from-did-direct,9847770190,1',NULL,NULL,NULL,NULL,0,'','','default','9847770190','',0,'','',''),('8447770070','8447770070','from-did-direct,8447770070,1',NULL,NULL,NULL,NULL,0,'','','default','8447770070','',0,'','',''),('5588804681','5588804681','from-did-direct,5588804681,1',NULL,NULL,NULL,NULL,0,'','','default','5588804681','',0,'','',''),('5588804682','5588804682','from-did-direct,5588804682,1',NULL,NULL,NULL,NULL,0,'','','default','5588804682','',0,'','',''),('5588804683','5588804683','from-did-direct,5588804683,1',NULL,NULL,NULL,NULL,0,'','','default','5588804683','',0,'','',''),('5588804684','5588804684','from-did-direct,5588804684,1',NULL,NULL,NULL,NULL,0,'','','default','5588804684','',0,'','',''),('5588804685','5588804685','from-did-direct,5588804685,1',NULL,NULL,NULL,NULL,0,'','','default','5588804685','',0,'','',''),('5588804686','5588804686','from-did-direct,5588804686,1',NULL,NULL,NULL,NULL,0,'','','default','5588804686','',0,'','',''),('5588804687','5588804687','from-did-direct,5588804687,1',NULL,NULL,NULL,NULL,0,'','','default','5588804687','',0,'','',''),('5588804688','5588804688','from-did-direct,5588804688,1',NULL,NULL,NULL,NULL,0,'','','default','5588804688','',0,'','',''),('5588804689','5588804689','from-did-direct,5588804689,1',NULL,NULL,NULL,NULL,0,'','','default','5588804689','',0,'','',''),('3388800131','3388800131','from-did-direct,3388800131,1',NULL,NULL,NULL,NULL,0,'','','default','3388800131','',0,'','',''),('3388800132','3388800132','from-did-direct,3388800132,1',NULL,NULL,NULL,NULL,0,'','','default','3388800132','',0,'','',''),('3388800133','3388800133','from-did-direct,3388800133,1',NULL,NULL,NULL,NULL,0,'','','default','3388800133','',0,'','',''),('3388800134','3388800134','from-did-direct,3388800134,1',NULL,NULL,NULL,NULL,0,'','','default','3388800134','',0,'','',''),('2228800361','2228800361','from-did-direct,2228800361,1',NULL,NULL,NULL,NULL,0,'','','default','2228800361','',0,'','',''),('2228800362','2228800362','from-did-direct,2228800362,1',NULL,NULL,NULL,NULL,0,'','','default','2228800362','',0,'','',''),('2228800363','2228800363','from-did-direct,2228800363,1',NULL,NULL,NULL,NULL,0,'','','default','2228800363','',0,'','',''),('2228800364','2228800364','from-did-direct,2228800364,1',NULL,NULL,NULL,NULL,0,'','','default','2228800364','',0,'','',''),('9847770191','9847770191','from-did-direct,9847770191,1',NULL,NULL,NULL,NULL,0,'','','default','9847770191','',0,'','',''),('9847770192','9847770192','from-did-direct,9847770192,1',NULL,NULL,NULL,NULL,0,'','','default','9847770192','',0,'','',''),('9847770193','9847770193','from-did-direct,9847770193,1',NULL,NULL,NULL,NULL,0,'','','default','9847770193','',0,'','',''),('9847770194','9847770194','from-did-direct,9847770194,1',NULL,NULL,NULL,NULL,0,'','','default','9847770194','',0,'','',''),('9847770195','9847770195','from-did-direct,9847770195,1',NULL,NULL,NULL,NULL,0,'','','default','9847770195','',0,'','',''),('9847770196','9847770196','from-did-direct,9847770196,1',NULL,NULL,NULL,NULL,0,'','','default','9847770196','',0,'','',''),('9847770197','9847770197','from-did-direct,9847770197,1',NULL,NULL,NULL,NULL,0,'','','default','9847770197','',0,'','',''),('9847770198','9847770198','from-did-direct,9847770198,1',NULL,NULL,NULL,NULL,0,'','','default','9847770198','',0,'','',''),('9847770199','9847770199','from-did-direct,9847770199,1',NULL,NULL,NULL,NULL,0,'','','default','9847770199','',0,'','',''),('8447770071','8447770071','from-did-direct,8447770071,1',NULL,NULL,NULL,NULL,0,'','','default','8447770071','',0,'','',''),('8447770072','8447770072','from-did-direct,8447770072,1',NULL,NULL,NULL,NULL,0,'','','default','8447770072','',0,'','',''),('8447770073','8447770073','from-did-direct,8447770073,1',NULL,NULL,NULL,NULL,0,'','','default','8447770073','',0,'','',''),('8447770074','8447770074','from-did-direct,8447770074,1',NULL,NULL,NULL,NULL,0,'','','default','8447770074','',0,'','',''),('8147370215','8147370215','from-did-direct,8147370215,1',NULL,NULL,NULL,NULL,0,'','','default','8147370215','',0,'','',''),('8177700360','8177700360','from-did-direct,8177700360,1',NULL,NULL,NULL,NULL,0,'','','default','8177700360','',0,'','',''),('8177700361','8177700361','from-did-direct,8177700361,1',NULL,NULL,NULL,NULL,0,'','','default','8177700361','',0,'','',''),('8177700362','8177700362','from-did-direct,8177700362,1',NULL,NULL,NULL,NULL,0,'','','default','8177700362','',0,'','',''),('8177700363','8177700363','from-did-direct,8177700363,1',NULL,NULL,NULL,NULL,0,'','','default','8177700363','',0,'','',''),('8177700364','8177700364','from-did-direct,8177700364,1',NULL,NULL,NULL,NULL,0,'','','default','8177700364','',0,'','',''),('8177700365','8177700365','from-did-direct,8177700365,1',NULL,NULL,NULL,NULL,0,'','','default','8177700365','',0,'','',''),('8177700366','8177700366','from-did-direct,8177700366,1',NULL,NULL,NULL,NULL,0,'','','default','8177700366','',0,'','',''),('8177700367','8177700367','from-did-direct,8177700367,1',NULL,NULL,NULL,NULL,0,'','','default','8177700367','',0,'','',''),('8177700368','8177700368','from-did-direct,8177700368,1',NULL,NULL,NULL,NULL,0,'','','default','8177700368','',0,'','',''),('8177700369','8177700369','from-did-direct,8177700369,1',NULL,NULL,NULL,NULL,0,'','','default','8177700369','',0,'','',''),('8177700370','8177700370','from-did-direct,8177700370,1',NULL,NULL,NULL,NULL,0,'','','default','8177700370','',0,'','',''),('8177700371','8177700371','from-did-direct,8177700371,1',NULL,NULL,NULL,NULL,0,'','','default','8177700371','',0,'','',''),('8177700372','8177700372','from-did-direct,8177700372,1',NULL,NULL,NULL,NULL,0,'','','default','8177700372','',0,'','',''),('8177700373','8177700373','from-did-direct,8177700373,1',NULL,NULL,NULL,NULL,0,'','','default','8177700373','',0,'','',''),('8177700374','8177700374','from-did-direct,8177700374,1',NULL,NULL,NULL,NULL,0,'','','default','8177700374','',0,'','',''),('8177700375','8177700375','from-did-direct,8177700375,1',NULL,NULL,NULL,NULL,0,'','','default','8177700375','',0,'','',''),('8177700376','8177700376','from-did-direct,8177700376,1',NULL,NULL,NULL,NULL,0,'','','default','8177700376','',0,'','',''),('8177700377','8177700377','from-did-direct,8177700377,1',NULL,NULL,NULL,NULL,0,'','','default','8177700377','',0,'','',''),('8177700378','8177700378','from-did-direct,8177700378,1',NULL,NULL,NULL,NULL,0,'','','default','8177700378','',0,'','',''),('8177700379','8177700379','from-did-direct,8177700379,1',NULL,NULL,NULL,NULL,0,'','','default','8177700379','',0,'','',''),('8177700380','8177700380','from-did-direct,8177700380,1',NULL,NULL,NULL,NULL,0,'','','default','8177700380','',0,'','',''),('8177700381','8177700381','from-did-direct,8177700381,1',NULL,NULL,NULL,NULL,0,'','','default','8177700381','',0,'','',''),('8177700382','8177700382','from-did-direct,8177700382,1',NULL,NULL,NULL,NULL,0,'','','default','8177700382','',0,'','',''),('8177700383','8177700383','from-did-direct,8177700383,1',NULL,NULL,NULL,NULL,0,'','','default','8177700383','',0,'','',''),('8177700384','8177700384','from-did-direct,8177700384,1',NULL,NULL,NULL,NULL,0,'','','default','8177700384','',0,'','',''),('8177700385','8177700385','from-did-direct,8177700385,1',NULL,NULL,NULL,NULL,0,'','','default','8177700385','',0,'','',''),('8177700386','8177700386','from-did-direct,8177700386,1',NULL,NULL,NULL,NULL,0,'','','default','8177700386','',0,'','',''),('8177700387','8177700387','from-did-direct,8177700387,1',NULL,NULL,NULL,NULL,0,'','','default','8177700387','',0,'','',''),('8177700388','8177700388','from-did-direct,8177700388,1',NULL,NULL,NULL,NULL,0,'','','default','8177700388','',0,'','',''),('8177700389','8177700389','from-did-direct,8177700389,1',NULL,NULL,NULL,NULL,0,'','','default','8177700389','',0,'','',''),('4428880130','4428880130','from-did-direct,4428880130,1',NULL,NULL,NULL,NULL,0,'','','default','4428880130','',0,'','',''),('4428880131','4428880131','from-did-direct,4428880131,1',NULL,NULL,NULL,NULL,0,'','','default','4428880131','',0,'','',''),('4428880132','4428880132','from-did-direct,4428880132,1',NULL,NULL,NULL,NULL,0,'','','default','4428880132','',0,'','',''),('4428880133','4428880133','from-did-direct,4428880133,1',NULL,NULL,NULL,NULL,0,'','','default','4428880133','',0,'','',''),('4428880134','4428880134','from-did-direct,4428880134,1',NULL,NULL,NULL,NULL,0,'','','default','4428880134','',0,'','',''),('4428880135','4428880135','from-did-direct,4428880135,1',NULL,NULL,NULL,NULL,0,'','','default','4428880135','',0,'','',''),('4428880136','4428880136','from-did-direct,4428880136,1',NULL,NULL,NULL,NULL,0,'','','default','4428880136','',0,'','',''),('4428880137','4428880137','from-did-direct,4428880137,1',NULL,NULL,NULL,NULL,0,'','','default','4428880137','',0,'','',''),('4428880138','4428880138','from-did-direct,4428880138,1',NULL,NULL,NULL,NULL,0,'','','default','4428880138','',0,'','',''),('4428880139','4428880139','from-did-direct,4428880139,1',NULL,NULL,NULL,NULL,0,'','','default','4428880139','',0,'','',''),('8177700670','8177700670','from-did-direct,8177700670,1',NULL,NULL,NULL,NULL,0,'','','default','8177700670','',0,'','',''),('8177700671','8177700671','from-did-direct,8177700671,1',NULL,NULL,NULL,NULL,0,'','','default','8177700671','',0,'','',''),('8177700672','8177700672','from-did-direct,8177700672,1',NULL,NULL,NULL,NULL,0,'','','default','8177700672','',0,'','',''),('8177700673','8177700673','from-did-direct,8177700673,1',NULL,NULL,NULL,NULL,0,'','','default','8177700673','',0,'','',''),('8177700674','8177700674','from-did-direct,8177700674,1',NULL,NULL,NULL,NULL,0,'','','default','8177700674','',0,'','',''),('8177700675','8177700675','from-did-direct,8177700675,1',NULL,NULL,NULL,NULL,0,'','','default','8177700675','',0,'','',''),('8177700676','8177700676','from-did-direct,8177700676,1',NULL,NULL,NULL,NULL,0,'','','default','8177700676','',0,'','',''),('8177700677','8177700677','from-did-direct,8177700677,1',NULL,NULL,NULL,NULL,0,'','','default','8177700677','',0,'','',''),('8177700678','8177700678','from-did-direct,8177700678,1',NULL,NULL,NULL,NULL,0,'','','default','8177700678','',0,'','',''),('8177700679','8177700679','from-did-direct,8177700679,1',NULL,NULL,NULL,NULL,0,'','','default','8177700679','',0,'','',''),('8177700680','8177700680','from-did-direct,8177700680,1',NULL,NULL,NULL,NULL,0,'','','default','8177700680','',0,'','',''),('8177700681','8177700681','from-did-direct,8177700681,1',NULL,NULL,NULL,NULL,0,'','','default','8177700681','',0,'','',''),('8177700682','8177700682','from-did-direct,8177700682,1',NULL,NULL,NULL,NULL,0,'','','default','8177700682','',0,'','',''),('8177700683','8177700683','from-did-direct,8177700683,1',NULL,NULL,NULL,NULL,0,'','','default','8177700683','',0,'','',''),('8177700684','8177700684','from-did-direct,8177700684,1',NULL,NULL,NULL,NULL,0,'','','default','8177700684','',0,'','',''),('8177700685','8177700685','from-did-direct,8177700685,1',NULL,NULL,NULL,NULL,0,'','','default','8177700685','',0,'','',''),('8177700686','8177700686','from-did-direct,8177700686,1',NULL,NULL,NULL,NULL,0,'','','default','8177700686','',0,'','',''),('8177700687','8177700687','from-did-direct,8177700687,1',NULL,NULL,NULL,NULL,0,'','','default','8177700687','',0,'','',''),('8177700688','8177700688','from-did-direct,8177700688,1',NULL,NULL,NULL,NULL,0,'','','default','8177700688','',0,'','',''),('8177700689','8177700689','from-did-direct,8177700689,1',NULL,NULL,NULL,NULL,0,'','','default','8177700689','',0,'','',''),('8177700690','8177700690','from-did-direct,8177700690,1',NULL,NULL,NULL,NULL,0,'','','default','8177700690','',0,'','',''),('8177700691','8177700691','from-did-direct,8177700691,1',NULL,NULL,NULL,NULL,0,'','','default','8177700691','',0,'','',''),('8177700692','8177700692','from-did-direct,8177700692,1',NULL,NULL,NULL,NULL,0,'','','default','8177700692','',0,'','',''),('8177700693','8177700693','from-did-direct,8177700693,1',NULL,NULL,NULL,NULL,0,'','','default','8177700693','',0,'','',''),('8177700694','8177700694','from-did-direct,8177700694,1',NULL,NULL,NULL,NULL,0,'','','default','8177700694','',0,'','',''),('8177700695','8177700695','from-did-direct,8177700695,1',NULL,NULL,NULL,NULL,0,'','','default','8177700695','',0,'','',''),('8177700696','8177700696','from-did-direct,8177700696,1',NULL,NULL,NULL,NULL,0,'','','default','8177700696','',0,'','',''),('8177700697','8177700697','from-did-direct,8177700697,1',NULL,NULL,NULL,NULL,0,'','','default','8177700697','',0,'','',''),('8177700698','8177700698','from-did-direct,8177700698,1',NULL,NULL,NULL,NULL,0,'','','default','8177700698','',0,'','',''),('8177700699','8177700699','from-did-direct,8177700699,1',NULL,NULL,NULL,NULL,0,'','','default','8177700699','',0,'','',''),('4778880150','4778880150','from-did-direct,4778880150,1',NULL,NULL,NULL,NULL,0,'','','default','4778880150','',0,'','',''),('4778880151','4778880151','from-did-direct,4778880151,1',NULL,NULL,NULL,NULL,0,'','','default','4778880151','',0,'','',''),('4778880152','4778880152','from-did-direct,4778880152,1',NULL,NULL,NULL,NULL,0,'','','default','4778880152','',0,'','',''),('4778880153','4778880153','from-did-direct,4778880153,1',NULL,NULL,NULL,NULL,0,'','','default','4778880153','',0,'','',''),('4778880154','4778880154','from-did-direct,4778880154,1',NULL,NULL,NULL,NULL,0,'','','default','4778880154','',0,'','',''),('4778880155','4778880155','from-did-direct,4778880155,1',NULL,NULL,NULL,NULL,0,'','','default','4778880155','',0,'','',''),('4778880156','4778880156','from-did-direct,4778880156,1',NULL,NULL,NULL,NULL,0,'','','default','4778880156','',0,'','',''),('4778880157','4778880157','from-did-direct,4778880157,1',NULL,NULL,NULL,NULL,0,'','','default','4778880157','',0,'','',''),('4778880158','4778880158','from-did-direct,4778880158,1',NULL,NULL,NULL,NULL,0,'','','default','4778880158','',0,'','',''),('4778880159','4778880159','from-did-direct,4778880159,1',NULL,NULL,NULL,NULL,0,'','','default','4778880159','',0,'','',''),('8718800150','8718800150','from-did-direct,8718800150,1',NULL,NULL,NULL,NULL,0,'','','default','8718800150','',0,'','',''),('8718800151','8718800151','from-did-direct,8718800151,1',NULL,NULL,NULL,NULL,0,'','','default','8718800151','',0,'','',''),('8718800152','8718800152','from-did-direct,8718800152,1',NULL,NULL,NULL,NULL,0,'','','default','8718800152','',0,'','',''),('8718800153','8718800153','from-did-direct,8718800153,1',NULL,NULL,NULL,NULL,0,'','','default','8718800153','',0,'','',''),('8718800154','8718800154','from-did-direct,8718800154,1',NULL,NULL,NULL,NULL,0,'','','default','8718800154','',0,'','',''),('8718800155','8718800155','from-did-direct,8718800155,1',NULL,NULL,NULL,NULL,0,'','','default','8718800155','',0,'','',''),('8718800156','8718800156','from-did-direct,8718800156,1',NULL,NULL,NULL,NULL,0,'','','default','8718800156','',0,'','',''),('8718800157','8718800157','from-did-direct,8718800157,1',NULL,NULL,NULL,NULL,0,'','','default','8718800157','',0,'','',''),('8718800158','8718800158','from-did-direct,8718800158,1',NULL,NULL,NULL,NULL,0,'','','default','8718800158','',0,'','',''),('8718800159','8718800159','from-did-direct,8718800159,1',NULL,NULL,NULL,NULL,0,'','','default','8718800159','',0,'','',''),('8177701550','8177701550','from-did-direct,8177701550,1',NULL,NULL,NULL,NULL,0,'','','default','8177701550','',0,'','',''),('5547776690','5547776690','from-did-direct,5547776690,1',NULL,NULL,NULL,NULL,0,'','','default','5547776690','',0,'','',''),('4617770040','4617770040','from-did-direct,4617770040,1',NULL,NULL,NULL,NULL,0,'','','default','4617770040','',0,'','',''),('4428881710','4428881710','from-did-direct,4428881710,1',NULL,NULL,NULL,NULL,0,'','','default','4428881710','',0,'','',''),('4778880355','4778880355','from-did-direct,4778880355,1',NULL,NULL,NULL,NULL,0,'','','default','4778880355','',0,'','',''),('6647770030','6647770030','from-did-direct,6647770030,1',NULL,NULL,NULL,NULL,0,'','','default','6647770030','',0,'','',''),('8177701551','8177701551','from-did-direct,8177701551,1',NULL,NULL,NULL,NULL,0,'','','default','8177701551','',0,'','',''),('8177701552','8177701552','from-did-direct,8177701552,1',NULL,NULL,NULL,NULL,0,'','','default','8177701552','',0,'','',''),('8177701553','8177701553','from-did-direct,8177701553,1',NULL,NULL,NULL,NULL,0,'','','default','8177701553','',0,'','',''),('8177701554','8177701554','from-did-direct,8177701554,1',NULL,NULL,NULL,NULL,0,'','','default','8177701554','',0,'','',''),('8177701555','8177701555','from-did-direct,8177701555,1',NULL,NULL,NULL,NULL,0,'','','default','8177701555','',0,'','',''),('8177701556','8177701556','from-did-direct,8177701556,1',NULL,NULL,NULL,NULL,0,'','','default','8177701556','',0,'','',''),('8177701557','8177701557','from-did-direct,8177701557,1',NULL,NULL,NULL,NULL,0,'','','default','8177701557','',0,'','',''),('8177701558','8177701558','from-did-direct,8177701558,1',NULL,NULL,NULL,NULL,0,'','','default','8177701558','',0,'','',''),('8177701559','8177701559','from-did-direct,8177701559,1',NULL,NULL,NULL,NULL,0,'','','default','8177701559','',0,'','',''),('8177701560','8177701560','from-did-direct,8177701560,1',NULL,NULL,NULL,NULL,0,'','','default','8177701560','',0,'','',''),('8177701561','8177701561','from-did-direct,8177701561,1',NULL,NULL,NULL,NULL,0,'','','default','8177701561','',0,'','',''),('8177701562','8177701562','from-did-direct,8177701562,1',NULL,NULL,NULL,NULL,0,'','','default','8177701562','',0,'','',''),('8177701563','8177701563','from-did-direct,8177701563,1',NULL,NULL,NULL,NULL,0,'','','default','8177701563','',0,'','',''),('8177701564','8177701564','from-did-direct,8177701564,1',NULL,NULL,NULL,NULL,0,'','','default','8177701564','',0,'','',''),('8177701565','8177701565','from-did-direct,8177701565,1',NULL,NULL,NULL,NULL,0,'','','default','8177701565','',0,'','',''),('8177701566','8177701566','from-did-direct,8177701566,1',NULL,NULL,NULL,NULL,0,'','','default','8177701566','',0,'','',''),('8177701567','8177701567','from-did-direct,8177701567,1',NULL,NULL,NULL,NULL,0,'','','default','8177701567','',0,'','',''),('8177701568','8177701568','from-did-direct,8177701568,1',NULL,NULL,NULL,NULL,0,'','','default','8177701568','',0,'','',''),('8177701569','8177701569','from-did-direct,8177701569,1',NULL,NULL,NULL,NULL,0,'','','default','8177701569','',0,'','',''),('8177701570','8177701570','from-did-direct,8177701570,1',NULL,NULL,NULL,NULL,0,'','','default','8177701570','',0,'','',''),('8177701571','8177701571','from-did-direct,8177701571,1',NULL,NULL,NULL,NULL,0,'','','default','8177701571','',0,'','',''),('8177701572','8177701572','from-did-direct,8177701572,1',NULL,NULL,NULL,NULL,0,'','','default','8177701572','',0,'','',''),('8177701573','8177701573','from-did-direct,8177701573,1',NULL,NULL,NULL,NULL,0,'','','default','8177701573','',0,'','',''),('8177701574','8177701574','from-did-direct,8177701574,1',NULL,NULL,NULL,NULL,0,'','','default','8177701574','',0,'','',''),('8177701575','8177701575','from-did-direct,8177701575,1',NULL,NULL,NULL,NULL,0,'','','default','8177701575','',0,'','',''),('8177701576','8177701576','from-did-direct,8177701576,1',NULL,NULL,NULL,NULL,0,'','','default','8177701576','',0,'','',''),('8177701577','8177701577','from-did-direct,8177701577,1',NULL,NULL,NULL,NULL,0,'','','default','8177701577','',0,'','',''),('8177701578','8177701578','from-did-direct,8177701578,1',NULL,NULL,NULL,NULL,0,'','','default','8177701578','',0,'','',''),('8177701579','8177701579','from-did-direct,8177701579,1',NULL,NULL,NULL,NULL,0,'','','default','8177701579','',0,'','',''),('5547776691','5547776691','from-did-direct,5547776691,1',NULL,NULL,NULL,NULL,0,'','','default','5547776691','',0,'','',''),('5547776692','5547776692','from-did-direct,5547776692,1',NULL,NULL,NULL,NULL,0,'','','default','5547776692','',0,'','',''),('5547776693','5547776693','from-did-direct,5547776693,1',NULL,NULL,NULL,NULL,0,'','','default','5547776693','',0,'','',''),('5547776694','5547776694','from-did-direct,5547776694,1',NULL,NULL,NULL,NULL,0,'','','default','5547776694','',0,'','',''),('5547776695','5547776695','from-did-direct,5547776695,1',NULL,NULL,NULL,NULL,0,'','','default','5547776695','',0,'','',''),('5547776696','5547776696','from-did-direct,5547776696,1',NULL,NULL,NULL,NULL,0,'','','default','5547776696','',0,'','',''),('5547776697','5547776697','from-did-direct,5547776697,1',NULL,NULL,NULL,NULL,0,'','','default','5547776697','',0,'','',''),('5547776698','5547776698','from-did-direct,5547776698,1',NULL,NULL,NULL,NULL,0,'','','default','5547776698','',0,'','',''),('5547776699','5547776699','from-did-direct,5547776699,1',NULL,NULL,NULL,NULL,0,'','','default','5547776699','',0,'','',''),('4617770041','4617770041','from-did-direct,4617770041,1',NULL,NULL,NULL,NULL,0,'','','default','4617770041','',0,'','',''),('4617770042','4617770042','from-did-direct,4617770042,1',NULL,NULL,NULL,NULL,0,'','','default','4617770042','',0,'','',''),('4617770043','4617770043','from-did-direct,4617770043,1',NULL,NULL,NULL,NULL,0,'','','default','4617770043','',0,'','',''),('4617770044','4617770044','from-did-direct,4617770044,1',NULL,NULL,NULL,NULL,0,'','','default','4617770044','',0,'','',''),('4428881711','4428881711','from-did-direct,4428881711,1',NULL,NULL,NULL,NULL,0,'','','default','4428881711','',0,'','',''),('4428881712','4428881712','from-did-direct,4428881712,1',NULL,NULL,NULL,NULL,0,'','','default','4428881712','',0,'','',''),('4428881713','4428881713','from-did-direct,4428881713,1',NULL,NULL,NULL,NULL,0,'','','default','4428881713','',0,'','',''),('4428881714','4428881714','from-did-direct,4428881714,1',NULL,NULL,NULL,NULL,0,'','','default','4428881714','',0,'','',''),('4778880356','4778880356','from-did-direct,4778880356,1',NULL,NULL,NULL,NULL,0,'','','default','4778880356','',0,'','',''),('4778880357','4778880357','from-did-direct,4778880357,1',NULL,NULL,NULL,NULL,0,'','','default','4778880357','',0,'','',''),('4778880358','4778880358','from-did-direct,4778880358,1',NULL,NULL,NULL,NULL,0,'','','default','4778880358','',0,'','',''),('4778880359','4778880359','from-did-direct,4778880359,1',NULL,NULL,NULL,NULL,0,'','','default','4778880359','',0,'','',''),('6647770031','6647770031','from-did-direct,6647770031,1',NULL,NULL,NULL,NULL,0,'','','default','6647770031','',0,'','',''),('6647770032','6647770032','from-did-direct,6647770032,1',NULL,NULL,NULL,NULL,0,'','','default','6647770032','',0,'','',''),('6647770033','6647770033','from-did-direct,6647770033,1',NULL,NULL,NULL,NULL,0,'','','default','6647770033','',0,'','',''),('6647770034','6647770034','from-did-direct,6647770034,1',NULL,NULL,NULL,NULL,0,'','','default','6647770034','',0,'','',''),('','4448880540','from-did-direct,4448880540,1',NULL,NULL,NULL,NULL,0,'','','default','4448880540','',0,'','',''),('','4448880541','from-did-direct,4448880541,1',NULL,NULL,NULL,NULL,0,'','','default','4448880541','',0,'','',''),('','4448880542','from-did-direct,4448880542,1',NULL,NULL,NULL,NULL,0,'','','default','4448880542','',0,'','',''),('','4448880543','from-did-direct,4448880543,1',NULL,NULL,NULL,NULL,0,'','','default','4448880543','',0,'','',''),('','4448880544','from-did-direct,4448880544,1',NULL,NULL,NULL,NULL,0,'','','default','4448880544','',0,'','',''),('','4627770400','from-did-direct,4627770400,1',NULL,NULL,NULL,NULL,0,'','','default','4627770400','',0,'','',''),('','4627770401','from-did-direct,4627770401,1',NULL,NULL,NULL,NULL,0,'','','default','4627770401','',0,'','',''),('','4627770402','from-did-direct,4627770402,1',NULL,NULL,NULL,NULL,0,'','','default','4627770402','',0,'','',''),('','4627770403','from-did-direct,4627770403,1',NULL,NULL,NULL,NULL,0,'','','default','4627770403','',0,'','',''),('','4627770404','from-did-direct,4627770404,1',NULL,NULL,NULL,NULL,0,'','','default','4627770404','',0,'','',''),('','6148880200','from-did-direct,6148880200,1',NULL,NULL,NULL,NULL,0,'','','default','6148880200','',0,'','',''),('','6148880201','from-did-direct,6148880201,1',NULL,NULL,NULL,NULL,0,'','','default','6148880201','',0,'','',''),('','6148880202','from-did-direct,6148880202,1',NULL,NULL,NULL,NULL,0,'','','default','6148880202','',0,'','',''),('','6148880203','from-did-direct,6148880203,1',NULL,NULL,NULL,NULL,0,'','','default','6148880203','',0,'','',''),('','6148880204','from-did-direct,6148880204,1',NULL,NULL,NULL,NULL,0,'','','default','6148880204','',0,'','',''),('','6568880100','from-did-direct,6568880100,1',NULL,NULL,NULL,NULL,0,'','','default','6568880100','',0,'','',''),('','6568880101','from-did-direct,6568880101,1',NULL,NULL,NULL,NULL,0,'','','default','6568880101','',0,'','',''),('','6568880102','from-did-direct,6568880102,1',NULL,NULL,NULL,NULL,0,'','','default','6568880102','',0,'','',''),('','6568880103','from-did-direct,6568880103,1',NULL,NULL,NULL,NULL,0,'','','default','6568880103','',0,'','',''),('','6568880104','from-did-direct,6568880104,1',NULL,NULL,NULL,NULL,0,'','','default','6568880104','',0,'','',''),('','8147773870','from-did-direct,8147773870,1',NULL,NULL,NULL,NULL,0,'','','default','8147773870','',0,'','',''),('','8147773871','from-did-direct,8147773871,1',NULL,NULL,NULL,NULL,0,'','','default','8147773871','',0,'','',''),('','8147773872','from-did-direct,8147773872,1',NULL,NULL,NULL,NULL,0,'','','default','8147773872','',0,'','',''),('','8147773873','from-did-direct,8147773873,1',NULL,NULL,NULL,NULL,0,'','','default','8147773873','',0,'','',''),('','8147773874','from-did-direct,8147773874,1',NULL,NULL,NULL,NULL,0,'','','default','8147773874','',0,'','',''),('','8147773875','from-did-direct,8147773875,1',NULL,NULL,NULL,NULL,0,'','','default','8147773875','',0,'','',''),('','8147773876','from-did-direct,8147773876,1',NULL,NULL,NULL,NULL,0,'','','default','8147773876','',0,'','',''),('','8147773877','from-did-direct,8147773877,1',NULL,NULL,NULL,NULL,0,'','','default','8147773877','',0,'','',''),('','8147773878','from-did-direct,8147773878,1',NULL,NULL,NULL,NULL,0,'','','default','8147773878','',0,'','',''),('','8147773879','from-did-direct,8147773879,1',NULL,NULL,NULL,NULL,0,'','','default','8147773879','',0,'','',''),('','8147773880','from-did-direct,8147773880,1',NULL,NULL,NULL,NULL,0,'','','default','8147773880','',0,'','',''),('','8147773881','from-did-direct,8147773881,1',NULL,NULL,NULL,NULL,0,'','','default','8147773881','',0,'','',''),('','8147773882','from-did-direct,8147773882,1',NULL,NULL,NULL,NULL,0,'','','default','8147773882','',0,'','',''),('','8147773883','from-did-direct,8147773883,1',NULL,NULL,NULL,NULL,0,'','','default','8147773883','',0,'','',''),('','8147773884','from-did-direct,8147773884,1',NULL,NULL,NULL,NULL,0,'','','default','8147773884','',0,'','',''),('','8147773885','from-did-direct,8147773885,1',NULL,NULL,NULL,NULL,0,'','','default','8147773885','',0,'','',''),('','8147773886','from-did-direct,8147773886,1',NULL,NULL,NULL,NULL,0,'','','default','8147773886','',0,'','',''),('','8147773887','from-did-direct,8147773887,1',NULL,NULL,NULL,NULL,0,'','','default','8147773887','',0,'','',''),('','8147773888','from-did-direct,8147773888,1',NULL,NULL,NULL,NULL,0,'','','default','8147773888','',0,'','',''),('','8147773889','from-did-direct,8147773889,1',NULL,NULL,NULL,NULL,0,'','','default','8147773889','',0,'','',''),('','8147773890','from-did-direct,8147773890,1',NULL,NULL,NULL,NULL,0,'','','default','8147773890','',0,'','',''),('','8147773891','from-did-direct,8147773891,1',NULL,NULL,NULL,NULL,0,'','','default','8147773891','',0,'','',''),('','8147773892','from-did-direct,8147773892,1',NULL,NULL,NULL,NULL,0,'','','default','8147773892','',0,'','',''),('','8147773893','from-did-direct,8147773893,1',NULL,NULL,NULL,NULL,0,'','','default','8147773893','',0,'','',''),('','8147773894','from-did-direct,8147773894,1',NULL,NULL,NULL,NULL,0,'','','default','8147773894','',0,'','',''),('','9847770200','from-did-direct,9847770200,1',NULL,NULL,NULL,NULL,0,'','','default','9847770200','',0,'','',''),('','9847770201','from-did-direct,9847770201,1',NULL,NULL,NULL,NULL,0,'','','default','9847770201','',0,'','',''),('','9847770202','from-did-direct,9847770202,1',NULL,NULL,NULL,NULL,0,'','','default','9847770202','',0,'','',''),('','9847770203','from-did-direct,9847770203,1',NULL,NULL,NULL,NULL,0,'','','default','9847770203','',0,'','',''),('','9847770204','from-did-direct,9847770204,1',NULL,NULL,NULL,NULL,0,'','','default','9847770204','',0,'','',''),('81777001081','81777001081','from-did-direct,81777001081,1',NULL,NULL,NULL,NULL,0,'','','default','81777001081','',0,'','','');
/*!40000 ALTER TABLE `incoming` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `indications_zonelist`
--

LOCK TABLES `indications_zonelist` WRITE;
/*!40000 ALTER TABLE `indications_zonelist` DISABLE KEYS */;
INSERT INTO `indications_zonelist` (`name`, `iso`, `conf`) VALUES ('Angola','ao','ringcadence = 1000,5000\nbusy = 425/500,0/500\ncongestion = 500/500,0500\ndial = 425\nringing = 25/1000,0/5000\ncallwaiting = 400/1000,0/5000\n'),('Argentina','ar','ringcadence = 1000,4500\ndial = 425\nbusy = 425/300,0/300\nring = 425/1000,0/4500\ncongestion = 425/200,0/300\ncallwaiting = 425/200,0/9000\ndialrecall = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425/330,0/330,425/660,0/660\nrecord = 1400/500,0/14000\ninfo = 425/100,0/100\nstutter = 425/450,0/50\n'),('Australia','au','ringcadence = 400,200,400,2000\ndial = 413+438\nbusy = 425/375,0/375\nring = 413+438/400,0/200,413+438/400,0/2000\ncongestion = 425/375,0/375,420/375,0/375\ncallwaiting = 425/200,0/200,425/200,0/4400\ndialrecall = 413+438\nrecord = !425/1000,!0/15000,425/360,0/15000\ninfo = 425/2500,0/500\nstd = !525/100,!0/100,!525/100,!0/100,!525/100,!0/100,!525/100,!0/100,!525/100\nfacility = 425\nstutter = 413+438/100,0/40\nringmobile = 400+450/400,0/200,400+450/400,0/2000\n'),('Austria','at','ringcadence = 1000,5000\ndial = 420\nbusy = 420/400,0/400\nring = 420/1000,0/5000\ncongestion = 420/200,0/200\ncallwaiting = 420/40,0/1960\ndialrecall = 420\nrecord = 1400/80,0/14920\ninfo = 950/330,1450/330,1850/330,0/1000\nstutter = 380+420\n'),('Belgium','be','ringcadence = 1000,3000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/3000\ncongestion = 425/167,0/167\ncallwaiting = 1400/175,0/175,1400/175,0/3500\ndialrecall = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\nrecord = 1400/500,0/15000\ninfo = 900/330,1400/330,1800/330,0/1000\nstutter = 425/1000,0/250\n'),('Brazil','br','ringcadence = 1000,4000\ndial = 425\nbusy = 425/250,0/250\nring = 425/1000,0/4000\ncongestion = 425/250,0/250,425/750,0/250\ncallwaiting = 425/50,0/1000\ndialrecall = 350+440\nrecord = 425/250,0/250\ninfo = 950/330,1400/330,1800/330\nstutter = 350+440\n'),('Bulgaria','bg','ringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/250,0/250\ncallwaiting = 425/150,0/150,425/150,0/4000\ndialrecall = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\nrecord = 1400/425,0/15000\ninfo = 950/330,1400/330,1800/330,0/1000\nstutter = 425/1500,0/100\n'),('Chile','cl','ringcadence = 1000,3000\ndial = 400\nbusy = 400/500,0/500\nring = 400/1000,0/3000\ncongestion = 400/200,0/200\ncallwaiting = 400/250,0/8750\ndialrecall = !400/100,!0/100,!400/100,!0/100,!400/100,!0/100,400\nrecord = 1400/500,0/15000\ninfo = 950/333,1400/333,1800/333,0/1000\nstutter = !400/100,!0/100,!400/100,!0/100,!400/100,!0/100,!400/100,!0/100,!400/100,!0/100,!400/100,!0/100,400\n'),('China','cn','ringcadence = 1000,4000\ndial = 450\nbusy = 450/350,0/350\nring = 450/1000,0/4000\ncongestion = 450/700,0/700\ncallwaiting = 450/400,0/4000\ndialrecall = 450\nrecord = 950/400,0/10000\ninfo = 450/100,0/100,450/100,0/100,450/100,0/100,450/400,0/400\nstutter = 450+425\n'),('Colombia (Republic of)','co','ringcadance = 1000,4000\ndial = 425\nbusy = 425/250,0/250\nring = 425/1000,0/4500\ncongestion = 425/100,0/250,425/350,0/250,425/650,0/250\ncallwaiting = 400+450/300,0/6000\ndialrecall = 425\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0/1000\n'),('Costa Rica','cr','ringcadence = 1203,4797\ndial = 450\nbusy = 450/330,0/330\nring = 450/1200,0/4900\ncongestion = 450/330,0/330\ncallwaiting = 450/150,0/150,450/150,0/8000\\dialrecall = !450/100,!0/100,!450/100,!0/100,!450/100,!0/100,450\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter = !450/100,!0/100,!450/100,!0/100,!450/100,!0/100,!450/100,!0/100,!42\n'),('Czech Republic','cz','ringcadence = 1000,4000\ndial = 425/330,0/330,425/660,0/660\nbusy = 425/330,0/330\nring = 425/1000,0/4000\ncongestion = 425/165,0/165\ncallwaiting = 425/330,0/9000\ndialrecall = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425/330,0/330,425/660,0/660\nrecord = 1400/500,0/14000\ninfo = 950/330,0/30,1400/330,0/30,1800/330,0/1000\nstutter = 425/450,0/50\n'),('Denmark','dk','ringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/200,0/200\ncallwaiting = !425/200,!0/600,!425/200,!0/3000,!425/200,!0/200,!425/200,0\ndialrecall = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\nrecord = 1400/80,0/15000\ninfo = 950/330,1400/330,1800/330,0/1000\nstutter = 425/450,0/50\n'),('Estonia','ee','ringcadence = 1000,4000\ndial = 425\nbusy = 425/300,0/300\nring = 425/1000,0/4000\ncongestion = 425/200,0/200\ncallwaiting = 950/650,0/325,950/325,0/30,1400/1300,0/2600\ndialrecall = 425/650,0/25\nrecord = 1400/500,0/15000\ninfo = 950/650,0/325,950/325,0/30,1400/1300,0/2600\nstutter = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\n'),('Finland','fi','ringcadence = 1000,4000\ndial = 425\nbusy = 425/300,0/300\nring = 425/1000,0/4000\ncongestion = 425/200,0/200\ncallwaiting = 425/150,0/150,425/150,0/8000\ndialrecall = 425/650,0/25\nrecord = 1400/500,0/15000\ninfo = 950/650,0/325,950/325,0/30,1400/1300,0/2600\nstutter = 425/650,0/25\n'),('France','fr','ringcadence = 1500,3500\ndial = 440\nbusy = 440/500,0/500\nring = 440/1500,0/3500\ncongestion = 440/250,0/250\ncallwait = 440/300,0/10000\ndialrecall = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330\nstutter = !440/100,!0/100,!440/100,!0/100,!440/100,!0/100,!440/100,!0/100,!440/100,!0/100,!440/100,!0/100,440\n'),('Germany','de','ringcadence = 1000,4000\ndial = 425\nbusy = 425/480,0/480\nring = 425/1000,0/4000\ncongestion = 425/240,0/240\ncallwaiting = !425/200,!0/200,!425/200,!0/5000,!425/200,!0/200,!425/200,!0/5000,!425/200,!0/200,!425/200,!0/5000,!425/200,!0/200,!425/200,!0/5000,!425/200,!0/200,!425/200,0\ndialrecall = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\nrecord = 1400/80,0/15000\ninfo = 950/330,1400/330,1800/330,0/1000\nstutter = 425+400\n'),('Greece','gr','ringcadence = 1000,4000\ndial = 425/200,0/300,425/700,0/800\nbusy = 425/300,0/300\nring = 425/1000,0/4000\ncongestion = 425/200,0/200\ncallwaiting = 425/150,0/150,425/150,0/8000\ndialrecall = 425/650,0/25\nrecord = 1400/400,0/15000\ninfo = !950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,0\nstutter = 425/650,0/25\n'),('Hong Kong','hk','ringcadence = 400,200,400,3000\ndial = 350+440\nbusy = 480+620/500,0/500\nring = 440+480/400,0/200,440+480/400,0/3000\ncongestion = 480+620/250,0/250\ncallwaiting = 440/300,0/10000\ndialrecall = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\n'),('Hungary','hu','ringcadence = 1250,3750\ndial = 425\nbusy = 425/300,0/300\nring = 425/1250,0/3750\ncongestion = 425/300,0/300\ncallwaiting = 425/40,0/1960\ndialrecall = 425+450\nrecord = 1400/400,0/15000\ninfo = !950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,0\nstutter = 350+375+400\n'),('India','in','ringcadence = 400,200,400,2000\ndial = 400*25\nbusy = 400/750,0/750\nring = 400*25/400,0/200,400*25/400,0/2000\ncongestion = 400/250,0/250\ncallwaiting = 400/200,0/100,400/200,0/7500\ndialrecall = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0/1000\nstutter = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\n'),('Iran','ir','ringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/240,0/240\ncallwaiting = 425/200,0/200,425/200,0/10000\ndialrecall = 425 record = 1400/80,0/15000\ninfo = 950/330,1400/330,1800/330,0/1000\nstutter = 400+425\n'),('Israel','il','ringcadence = 1000,3000\ndial = 414\nbusy = 414/500,0/500\nring = 414/1000,0/3000\ncongestion = 414/250,0/250\ncallwaiting = 414/100,0/100,414/100,0/100,414/600,0/3000 \ndialrecall = !414/100,!0/100,!414/100,!0/100,!414/100,!0/100,414\nrecord = 1400/500,0/15000\ninfo = 1000/330,1400/330,1800/330,0/1000\nstutter = !414/160,!0/160,!414/160,!0/160,!414/160,!0/160,!414/160,!0/160,!414/160,!0/160,!414/160,!0/160,!414/160,!0/160,!414/160,!0/160,!414/160,!0/160,!414/160,!0/160,414 \n'),('Italy','it','ringcadence = 1000,4000\ndial = 425/200,0/200,425/600,0/1000\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/200,0/200\ncallwaiting = 425/400,0/100,425/250,0/100,425/150,0/14000\ndialrecall = 470/400,425/400\nrecord = 1400/400,0/15000\ninfo = !950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,0\nstutter = 470/400,425/400\n'),('Japan','jp','ringcadence = 1000,2000\ndial = 400\nbusy = 400/500,0/500\nring = 400+415/1000,0/2000\ncongestion = 400/500,0/500\ncallwaiting = 400+16/500,0/8000\ndialrecall = !400/200,!0/200,!400/200,!0/200,!400/200,!0/200,400\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter =!400/100,!0/100,!400/100,!0/100,!400/100,!0/100,!400/100,!0/100,!400/100,!0/100,!400/100,!0/100,400\n'),('Kenya (Republic of)','ke','ringcadence = 670,3000,1500,5000\nbusy = 425/200,0/600,425/200,0/600\ncongestion = 425/200,0/600\ndial = 425\nringing = 425/670,0/3000,425/1500,0/5000\ninfo = 900/750,1400/750,1800/750,0/1250\ncallwaiting = 425\n'),('Lithuania','lt','ringcadence = 1000,4000\ndial = 425\nbusy = 425/350,0/350\nring = 425/1000,0/4000\ncongestion = 425/200,0/200\ncallwaiting = 425/150,0/150,425/150,0/4000\ndialrecall = 425/500,0/50\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,0\nstutter = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\n'),('Macao','mo','ringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/250,0/250\ncallwaiting = 425/200,0/600\nrecord = 1400/400,0/15000\ninfo = 950/333,1400/333,1800/333,0/1000\nstutter = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\n'),('Malaysia','my','ringcadence = 400,200,400,2000\ndial = 425\nbusy = 425/500,0/500\nring = 425/400,0/200,425/400,0/2000\ncongestion = 425/500,0/500\ncallwaiting = 425/100,0/4000\ndialrecall = 350+440\nrecord = 1400/500,0/60000\ninfo = 950/330,0/15,1400/330,0/15,1800/330,0/1000\nstutter = 450+425\n'),('Mexico','mx','ringcadence = 2000,4000\ndial = 425\nbusy = 425/250,0/250\nring = 425/1000,0/4000\ncongestion = 425/250,0/250\ncallwaiting = 425/200,0/600,425/200,0/10000\ndialrecall = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\nrecord = 1400/500,0/15000\ninfo = 950/330,0/30,1400/330,0/30,1800/330,0/1000\nstutter = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\n'),('Netherlands','nl','ringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/250,0/250\ncallwaiting = 425/500,0/9500\ndialrecall = 425/500,0/50\nrecord = 1400/500,0/15000\ninfo = 950/330,1400/330,1800/330,0/1000\nstutter = 425/500,0/50\n'),('New Zealand','nz','ringcadence = 400,200,400,2000\ndial = 400\nbusy = 400/250,0/250\nring = 400+450/400,0/200,400+450/400,0/2000\ncongestion = 400/375,0/375\ncallwaiting = !400/200,!0/3000,!400/200,!0/3000,!400/200,!0/3000,!400/200\ndialrecall = !400/100!0/100,!400/100,!0/100,!400/100,!0/100,400\nrecord = 1400/425,0/15000\ninfo = 400/750,0/100,400/750,0/100,400/750,0/100,400/750,0/400\nstutter = !400/100!0/100,!400/100,!0/100,!400/100,!0/100,!400/100!0/100,!400/100,!0/100,!400/100,!0/100,400\n'),('Norway','no','ringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/200,0/200\ncallwaiting = 425/200,0/600,425/200,0/10000\ndialrecall = 470/400,425/400\nrecord = 1400/400,0/15000\ninfo = !950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,0\nstutter = 470/400,425/400\n'),('Pakistan','pk','ringcadence = 400,1000,0,2000\nbusy = 400/500,0/500\nring = 400/1000,0/2000\ncongestion = 400/250,0/250\n'),('Panama','pa','ringcadence = 2000,4000\ndial = 425\nbusy = 425/320,0/320\nring = 425/1200,0/4650\ncongestion = 425/320,0/320\ncallwaiting = 425/180,0/180,425/180\\dialrecall = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!42\n'),('Philippines','phl','ringcadence = 1000,4000\ndial = 425\nbusy = 480+620/500,0/500\nring = 425+480/1000,0/4000\ncongestion = 480+620/250,0/250\ncallwaiting = 440/300,0/10000\ndialrecall = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\n'),('Poland','pl','ringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/500,0/500\ncallwaiting = 425/150,0/150,425/150,0/4000\ndialrecall = 425/500,0/50\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000,!950/330,!1400/330,!1800/330,!0/1000\nstutter = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\n'),('Portugal','pt','ringcadence = 1000,5000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/5000\ncongestion = 425/200,0/200\ncallwaiting = 440/300,0/10000\ndialrecall = 425/1000,0/200\nrecord = 1400/500,0/15000\ninfo = 950/330,1400/330,1800/330,0/1000\nstutter = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\n'),('Russian Federation','ru','ringcadence = 1000,4000\ndial = 425\nbusy = 425/350,0/350\nring = 425/800,0/3200\ncongestion = 425/350,0/350\ncallwaiting = 425/200,0/5000\ndialrecall = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\n'),('Singapore','sg','ringcadence = 400,200,400,2000\ndial = 425\nring = 425*24/400,0/200,425*24/400,0/2000 ; modulation should be 100%, not 90%\nbusy = 425/750,0/750\ncongestion = 425/250,0/250\ncallwaiting = 425*24/300,0/200,425*24/300,0/3200\nstutter = !425/200,!0/200,!425/600,!0/200,!425/200,!0/200,!425/600,!0/200,!425/200,!0/200,!425/600,!0/200,!425/200,!0/200,!425/600,!0/200,425\ninfo = 950/330,1400/330,1800/330,0/1000 ; not currently in use acc. to reference\ndialrecall = 425*24/500,0/500,425/500,0/2500 ; unspecified in IDA reference, use repeating Holding Tone A,B\nrecord = 1400/500,0/15000 ; unspecified in IDA reference, use 0.5s tone every 15s\nnutone = 425/2500,0/500\nintrusion = 425/250,0/2000\nwarning = 425/624,0/4376 ; end of period tone, warning\nacceptance = 425/125,0/125\nholdinga = !425*24/500,!0/500 ; followed by holdingb\nholdingb = !425/500,!0/2500\n'),('South Africa','za','ringcadence = 400,200,400,2000\ndial = 400*33\nbusy = 400/500,0/500\nring = 400*33/400,0/200,400*33/400,0/2000\ncongestion = 400/250,0/250\ncallwaiting = 400*33/250,0/250,400*33/250,0/250,400*33/250,0/250,400*33/250,0/250\ndialrecall = 350+440\nrecord = 1400/500,0/10000\ninfo = 950/330,1400/330,1800/330,0/330\nstutter =!400*33/100,!0/100,!400*33/100,!0/100,!400*33/100,!0/100,!400*33/100,!0/100,!400*33/100,!0/100,!400*33/100,!0/100,400*33 \n'),('Spain','es','ringcadence = 1500,3000\ndial = 425\nbusy = 425/200,0/200\nring = 425/1500,0/3000\ncongestion = 425/200,0/200,425/200,0/200,425/200,0/600\ncallwaiting = 425/175,0/175,425/175,0/3500\ndialrecall = !425/200,!0/200,!425/200,!0/200,!425/200,!0/200,425\nrecord = 1400/500,0/15000\ninfo = 950/330,0/1000\ndialout = 500\n'),('Sweden','se','ringcadence = 1000,5000\ndial = 425\nbusy = 425/250,0/250\nring = 425/1000,0/5000\ncongestion = 425/250,0/750\ncallwaiting = 425/200,0/500,425/200,0/9100\ndialrecall = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\nrecord = 1400/500,0/15000\ninfo = !950/332,!0/24,!1400/332,!0/24,!1800/332,!0/2024,!950/332,!0/24,!1400/332,!0/24,!1800/332,!0/2024,!950/332,!0/24,!1400/332,!0/24,!1800/332,!0/2024,!950/332,!0/24,!1400/332,!0/24,!1800/332,!0/2024,!950/332,!0/24,!1400/332,!0/24,!1800/332,0\nstutter = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\n'),('Switzerland','ch','ringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/200,0/200\ncallwaiting = 425/200,0/200,425/200,0/4000\ndialrecall = !425/100,!0/100,!425/100,!0/100,!425/100,!0/100,425\nrecord = 1400/80,0/15000\ninfo = 950/330,1400/330,1800/330,0/1000\nstutter = 425+340/1100,0/1100\n'),('Taiwan','tw','ringcadence = 1000,4000\ndial = 350+440\nbusy = 480+620/500,0/500\nring = 440+480/1000,0/2000\ncongestion = 480+620/250,0/250\ncallwaiting = 350+440/250,0/250,350+440/250,0/3250\ndialrecall = 300/1500,0/500\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\n'),('Tanzania (United Republic of)','tz','ringcadence = 1000,4000\nbusy = 425/1000,0/1000\ncongestion = 425/375,0/375\ndial = 425+400\nringing = 425/1000,0/4000\ninfo = 950/375,1400/375,1800/375,0/30,950/375,1400/375,1800/375,0/30,950/375,1400/375,1800/375callwaiting = 425/500,0/200\n'),('Thailand','th','ringcadence = 1000,4000\\dial = 400*50\nbusy = 400/500,0/500\nring = 420/1000,0/5000\ncongestion = 400/300,0/300\ncallwaiting = 1000/400,10000/400,1000/400\ndialrecall = 400*50/400,0/100,400*50/400,0/100\nrecord = 1400/500,0/15000\ninfo = 950/330,1400/330,1800/330\nstutter = !400/200,!0/200,!400/600,!0/200,!400/200,!0/200,!400/600,!0/200,!400/200,!0/200,!400/600,!0/200,!400/200,!0/200,!400/600,!0/200,400\n'),('Turkey','tr','ringcadance = 2000,4000\ndial = 450\nbusy = 450/500,0/500\nring = 450/2000,450/4000\ncongestion = 450/200,0/200,450/200,0/200,450/200,0/200,450/600,0/200\ncallwaiting = 450/200,0/600,450/200,0/8000\ndialrecall = 450/1000,0/250\nrecord = 1400/500,0/15000\ninfo = !950/300,!1400/300,!1800/300,!0/1000,!950/300,!1400/300,!1800/300,!0/1000,!950/300,!1400/300,!1800/300,!0/1000,0\n'),('Uganda (Republic of)','ug','ringcadence = 1000,4000\nbusy = 425/500,0/500\ncongestion = 425/250,0/250\ndial = 425\nringing = 425/1000,0/4000\ncallwaiting = 425/150,0/150,425/150,0/8000\n'),('United Kingdom','uk','ringcadence = 400,200,400,2000\ndial = 350+440\nspecialdial = 350+440/750,440/750\nbusy = 400/375,0/375\ncongestion = 400/400,0/350,400/225,0/525\nspecialcongestion = 400/200,1004/300\nunobtainable = 400\nring = 400+450/400,0/200,400+450/400,0/2000\ncallwaiting = 400/100,0/4000\nspecialcallwaiting = 400/250,0/250,400/250,0/250,400/250,0/5000\ncreditexpired = 400/125,0/125\nconfirm = 1400\nswitching = 400/200,0/400,400/2000,0/400\ninfo = 950/330,0/15,1400/330,0/15,1800/330,0/1000\nrecord = 1400/500,0/60000\nstutter = 350+440/750,440/750\n'),('United States / North America','us','ringcadence = 2000,4000\ndial = 350+440\nbusy = 480+620/500,0/500\nring = 440+480/2000,0/4000\ncongestion = 480+620/250,0/250\ncallwaiting = 440/300,0/10000\ndialrecall = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter = !350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,!350+440/100,!0/100,350+440\n'),('United States Circa 1950/ North America','us-old','ringcadence = 2000,4000\ndial = 600*120\nbusy = 500*100/500,0/500\nring = 420*40/2000,0/4000\ncongestion = 500*100/250,0/250\ncallwaiting = 440/300,0/10000\ndialrecall = !600*120/100,!0/100,!600*120/100,!0/100,!600*120/100,!0/100,600*120\nrecord = 1400/500,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter = !600*120/100,!0/100,!600*120/100,!0/100,!600*120/100,!0/100,!600*120/100,!0/100,!600*120/100,!0/100,!600*120/100,!0/100,600*120\n'),('Venezuela / South America','ve','; Tone definition source for ve found on\n; Reference: http://www.itu.int/ITU-T/inr/forms/files/tones-0203.pdf\nringcadence = 1000,4000\ndial = 425\nbusy = 425/500,0/500\nring = 425/1000,0/4000\ncongestion = 425/250,0/250\ncallwaiting = 400+450/300,0/6000\ndialrecall = 425\nrecord =  1400/500,0/15000\ninfo = !950/330,!1440/330,!1800/330,0/1000\n'),('Romania','ro','ringcadence = 1850,4150\ndial = 450\nbusy = 450/167,0/167\nring = 450*25/1850,0/4150\ncongestion = 450/500,0/500\ncallwaiting = 450/150,0/150,450/150,0/8000\ndialrecall = !450/100,!0/100,!450/100,!0/100,!450/100,!0/100,450\nrecord = 1400/400,0/15000\ninfo = !950/330,!1400/330,!1800/330,0\nstutter = !450/100,!0/100,!450/100,!0/100,!450/100,!0/100,!450/100,!0/100,!450/100,!0/100,!450/100,!0/100,450\nfacility = 450\nhowler = 3000\ndialout = 600\nintrusion = 450/150,0/4950\nspecialdial = 450*25/400,0/40\nunobtainable = !450/92,!0/110,!450/92,!0/110,!450/92,!0/110,450/362,0/110\n');
/*!40000 ALTER TABLE `indications_zonelist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `inventorydb`
--

LOCK TABLES `inventorydb` WRITE;
/*!40000 ALTER TABLE `inventorydb` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventorydb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `issabelpbx_log`
--

LOCK TABLES `issabelpbx_log` WRITE;
/*!40000 ALTER TABLE `issabelpbx_log` DISABLE KEYS */;
INSERT INTO `issabelpbx_log` (`id`, `time`, `section`, `level`, `status`, `message`) VALUES (1,'2006-11-06 01:55:36','retrieve_conf','devel-debug',0,'Started retrieve_conf, DB Connection OK'),(2,'2006-11-06 01:55:36','retrieve_conf','devel-debug',0,'Writing extensions_additional.conf');
/*!40000 ALTER TABLE `issabelpbx_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `issabelpbx_settings`
--

LOCK TABLES `issabelpbx_settings` WRITE;
/*!40000 ALTER TABLE `issabelpbx_settings` DISABLE KEYS */;
INSERT INTO `issabelpbx_settings` (`keyword`, `value`, `name`, `level`, `description`, `type`, `options`, `defaultval`, `readonly`, `hidden`, `category`, `module`, `emptyok`, `sortorder`) VALUES ('AGGRESSIVE_DUPLICATE_CHECK','0','Aggresively Check for Duplicate Extensions',0,'When set to true IssabelPBX will update its extension map every page load. This is used to check for duplicate extension numbers in the client side javascript validation. Normally the extension map is only created when Apply Configuration Settings is pressed and retrieve_conf is run.','bool','','0',0,0,'System Setup','',0,-137),('ALWAYS_SHOW_DEVICE_DETAILS','0','Show all Device Setting on Add',0,'When adding a new extension/device, setting this to true will show most available device settings that are displayed when you edit the same extension/device. Otherwise, just a few basic settings are displayed.','bool','','0',0,0,'Device Settings','',0,10),('AMPASTERISKGROUP','asterisk','System Asterisk Group',4,'The user group Asterisk should be running as, used by issabelpbx_engine. Most systems should not change this.','text','','asterisk',1,0,'System Setup','',0,-100),('AMPASTERISKUSER','asterisk','System Asterisk User',4,'The user Asterisk should be running as, used by issabelpbx_engine. Most systems should not change this.','text','','asterisk',1,0,'System Setup','',0,-100),('AMPASTERISKWEBGROUP','asterisk','System Web Group',4,'The user group your httpd should be running as, used by issabelpbx_engine. Most systems should not change this.','text','','asterisk',1,0,'System Setup','',0,-100),('AMPASTERISKWEBUSER','asterisk','System Web User',4,'The user your httpd should be running as, used by issabelpbx_engine. Most systems should not change this.','text','','asterisk',1,0,'System Setup','',0,-100),('AMPBACKUPEMAILFROM','','Email \"From:\" Address',0,'The From: field for emails when using the backup email feature.','text','','',0,0,'Backup Module','backup',1,0),('AMPBADNUMBER','1','Use bad-number Context',2,'Generate the bad-number context which traps any bogus number or feature code and plays a message to the effect. If you use the Early Dial feature on some Grandstream phones, you will want to set this to false.','bool','','1',0,0,'Dialplan and Operational','',0,-100),('AMPBIN','/var/lib/asterisk/bin','IssabelPBX bin Dir',4,'Location of the IssabelPBX command line scripts.','dir','','/var/lib/asterisk/bin',1,0,'Directory Layout','',0,-100),('AMPCGIBIN','/var/www/cgi-bin ','CGI Dir',4,'The path to Apache cgi-bin dir (leave off trailing slash).','dir','','/var/www/cgi-bin ',1,0,'Directory Layout','',0,-100),('AMPDEVGROUP','asterisk','System Device Group',4,'The user group that various device directories should be set to, used by issabelpbx_engine. Examples include /dev/zap, /dev/dahdi, /dev/misdn, /dev/mISDN and /dev/dsp. Most systems should not change this.','text','','asterisk',1,0,'System Setup','',0,-100),('AMPDEVUSER','asterisk','System Device User',4,'The user that various device directories should be set to, used by issabelpbx_engine. Examples include /dev/zap, /dev/dahdi, /dev/misdn, /dev/mISDN and /dev/dsp. Most systems should not change this.','text','','asterisk',1,0,'System Setup','',0,-100),('AMPDISABLELOG','0','Disable IssabelPBX Log',0,'Whether or not to invoke the IssabelPBX log facility.','bool','','0',0,0,'System Setup','',0,-180),('AMPENGINE','asterisk','Telephony Engine',3,'The telephony backend engine being used, asterisk is the only option currently.','select','asterisk','asterisk',1,0,'System Setup','',0,-100),('AMPEXTENSIONS','extensions','User & Devices Mode',0,'Sets the extension behavior in IssabelPBX.  If set to <b>extensions</b>, Devices and Users are administered together as a unified Extension, and appear on a single page. If set to <b>deviceanduser</b>, Devices and Users will be administered separately. Devices (e.g. each individual line on a SIP phone) and Users (e.g. <b>101</b>) will be configured independent of each other, allowing association of one User to many Devices, or allowing Users to login and logout of Devices.','select','extensions,deviceanduser','extensions',0,0,'System Setup','',0,-135),('AMPLOCALBIN','','AMPLOCALBIN Dir for retrieve_conf',2,'If this directory is defined, retrieve_conf will check for a file called <i>retrieve_conf_post_custom</i> and if that file exists, it will be included after other processing thus having full access to the current environment for additional customization.','dir','','',1,0,'Developer and Customization','',1,-100),('AMPMGRPASS','M4k48r0_','Asterisk Manager Password',2,'Password for accessing the Asterisk Manager Interface (AMI), this will be automatically updated in manager.conf.','text','','amp111',0,0,'Asterisk Manager','',0,-100),('AMPMGRUSER','admin','Asterisk Manager User',2,'Username for accessing the Asterisk Manager Interface (AMI), this will be automatically updated in manager.conf.','text','','admin',0,0,'Asterisk Manager','',0,-100),('AMPMPG123','1','Convert Music Files to WAV',3,'When set to false, the MP3 files can be loaded and WAV files converted to MP3 in the MoH module. The default behavior of true assumes you have mpg123 loaded as well as sox and will convert MP3 files to WAV. This is highly recommended as MP3 files heavily tax the system and can cause instability on a busy phone system','bool','','1',0,0,'System Setup','music',0,0),('AMPPLAYKEY','','Recordings Crypt Key',3,'Crypt key used by this recordings module when accessing the recording files. Change from the default of \"moufdsuu3nma0\" if desired.','text','','',0,0,'System Setup','recordings',1,0),('AMPSBIN','/usr/sbin','IssabelPBX sbin Dir',4,'Where (root) command line scripts are located.','dir','','/usr/sbin',1,0,'Directory Layout','',0,-100),('AMPSYSLOGLEVEL','FILE','IssabelPBX Log Routing',0,'Determine where to send log information if the log is enabled (\'Disable IssabelPBX Log\' (AMPDISABLELOG) false. There are two places to route the log messages. \'FILE\' will send all log messages to the defined \'IssabelPBX Log File\' (FPBX_LOG_FILE). All the other settings will route the log messages to your System Logging subsystem (syslog) using the specified log level. Syslog can be configured to route different levels to different locations. See \'syslog\' documentation (man syslog) on your system for more details.','select','FILE,LOG_EMERG,LOG_ALERT,LOG_CRIT,LOG_ERR,LOG_WARNING,LOG_NOTICE,LOG_INFO,LOG_DEBUG','FILE',0,0,'System Setup','',0,-190),('AMPVMUMASK','007','Asterisk VMU Mask',4,'Defaults to 077 allowing only the asterisk user to have any permission on VM files. If set to something like 007, it would allow the group to have permissions. This can be used if setting apache to a different user then asterisk, so that the apache user (and thus ARI) can have access to read/write/delete the voicemail files. If changed, some of the voicemail directory structures may have to be manually changed.','text','','007',0,0,'System Setup','',0,-100),('AMPWEBADDRESS','','IssabelPBX Web Address',4,'This is the address of your Web Server. It is mostly obsolete and derived when not supplied and will be phased out, but there are still some areas expecting a variable to be set and if you are using it this will migrate your value.','text','','',0,0,'System Setup','',1,-100),('AMPWEBROOT','/var/www/html','IssabelPBX Web Root Dir',4,'The path to Apache webroot (leave off trailing slash).','dir','','/var/www/html',1,0,'Directory Layout','',0,-100),('AMP_ACCESS_DB_CREDS','0','Allow Login With DB Credentials',0,'When Set to True, admin access to the IssabelPBX GUI will be allowed using the IssabelPBX configured AMPDBUSER and AMPDBPASS credentials. This only applies when Authorization Type is \'database\' mode.','bool','','0',0,0,'System Setup','',0,-126),('ARI_ADMIN_PASSWORD','M4k48r0_','User Portal Admin Password',0,'This is the default admin password to allow an administrator to login to ARI bypassing all security. Change this to a secure password. Default = not set','text','','ari_password',0,0,'System Setup','',0,-110),('ARI_ADMIN_USERNAME','admin','User Portal Admin Username',0,'This is the default admin name used to allow an administrator to login to ARI bypassing all security. Change this to whatever you want, do not forget to change the User Portal Admin Password as well. Default = not set','text','','',0,0,'System Setup','',1,-120),('ASTAGIDIR','/var/lib/asterisk/agi-bin','Asterisk AGI Dir',4,'This is the default directory for Asterisks agi files.','dir','','/var/lib/asterisk/agi-bin',1,0,'Directory Layout','',0,-100),('ASTCONFAPP','app_meetme','Conference Room App',0,'The asterisk application to use for conferencing. If only one is compiled into asterisk, IssabelPBX will auto detect and change this value if set wrong. The app_confbridge application is considered \"experimental\" with known issues and does not work on Asterisk 10 where it was completely rewritten and changed from the version on 1.6 and 1.8.','select','app_meetme,app_confbridge','app_meetme',0,0,'Dialplan and Operational','',0,-100),('ASTETCDIR','/etc/asterisk','Asterisk etc Dir',4,'This is the default directory for Asterisks configuration files.','dir','','/etc/asterisk',1,0,'Directory Layout','',0,-100),('ASTLOGDIR','/var/log/asterisk','Asterisk Log Dir',4,'This is the default directory for Asterisks log files.','dir','','/var/log/asterisk',1,0,'Directory Layout','',0,-100),('ASTMANAGERHOST','localhost','Asterisk Manager Host',2,'Hostname for the Asterisk Manager','text','','localhost',1,0,'Asterisk Manager','',0,-100),('ASTMANAGERPORT','5038','Asterisk Manager Port',2,'Port for the Asterisk Manager','int','1024,65535','5038',1,0,'Asterisk Manager','',0,-100),('ASTMANAGERPROXYPORT','','Asterisk Manager Proxy Port',2,'Optional port for an Asterisk Manager Proxy','int','1024,65535','',1,0,'Asterisk Manager','',1,-100),('ASTMGRWRITETIMEOUT','5000','Asterisk Manager Write Timeout',2,'Timeout, im ms, for write timeouts for cases where Asterisk disconnects frequently','int','100,100000','5000',1,0,'Asterisk Manager','',1,-100),('ASTMODDIR','/usr/lib/asterisk/modules','Asterisk Modules Dir',4,'This is the default directory for Asterisks modules.','dir','','/usr/lib/asterisk/modules',1,0,'Directory Layout','',0,-100),('ASTRUNDIR','/var/run/asterisk','Asterisk Run Dir',4,'This is the default directory for Asterisks run files.','dir','','/var/run/asterisk',1,0,'Directory Layout','',0,-100),('ASTSPOOLDIR','/var/spool/asterisk','Asterisk Spool Dir',4,'This is the default directory for Asterisks spool directory.','dir','','/var/spool/asterisk',1,0,'Directory Layout','',0,-100),('ASTSTOPPOLLINT','2','Polling Interval for Stopping Asterisk',0,'When Asterisk is stopped or restarted with the \'amportal stop/restart\' commands, it does a graceful stop waiting for active channels to hangup. This sets the polling interval to check if Asterisk is shutdown and update the countdown timer.','select','1,2,3,5,10','2',0,0,'Dialplan and Operational','',0,-100),('ASTSTOPTIMEOUT','120','Waiting Period to Stop Asterisk',0,'When Asterisk is stopped or restarted with the \'amportal stop/restart\' commands, it does a graceful stop waiting for active channels to hangup. This sets the maximum time in seconds to wait prior to force stopping Asterisk','select','0,5,10,30,60,120,300,600,1800,3600,7200,10800','120',0,0,'Dialplan and Operational','',0,-100),('ASTVARLIBDIR','/var/lib/asterisk','Asterisk bin Dir',4,'This is the default directory for Asterisks lib files.','dir','','/var/lib/asterisk',1,0,'Directory Layout','',0,-100),('ASTVERSION','11.25.0','Asterisk Version',10,'Last Asterisk Version detected (or forced)','text','','',1,1,'Internal Use','',1,0),('AST_APP_VQA','','Asterisk Application VQA',10,'Set to the application name if the application is present in this Asterisk install','text','','',1,1,'Internal Use','',1,0),('AST_FUNC_CONNECTEDLINE','CONNECTEDLINE','Asterisk Function CONNECTEDLINE',10,'Set to the function name if the function is present in this Asterisk install','text','','',1,1,'Internal Use','',1,0),('AST_FUNC_DEVICE_STATE','DEVICE_STATE','Asterisk Function DEVICE_STATE',10,'Set to the function name if the function is present in this Asterisk install','text','','',1,1,'Internal Use','',1,0),('AST_FUNC_EXTENSION_STATE','EXTENSION_STATE','Asterisk Function EXTENSION_STATE',10,'Set to the function name if the function is present in this Asterisk install','text','','',1,1,'Internal Use','',1,0),('AST_FUNC_MASTER_CHANNEL','MASTER_CHANNEL','Asterisk Function MASTER_CHANNEL',10,'Set to the function name if the function is present in this Asterisk install','text','','',1,1,'Internal Use','',1,0),('AST_FUNC_PRESENCE_STATE','PRESENCE_STATE','Asterisk Function PRESENCE_STATE',10,'Set to the function name if the function is present in this Asterisk install','text','','',1,1,'Internal Use','',1,0),('AST_FUNC_SHARED','SHARED','Asterisk Function SHARED',10,'Set to the function name if the function is present in this Asterisk install','text','','',1,1,'Internal Use','',1,0),('AS_DISPLAY_FRIENDLY_NAME','1','Display Friendly Name',0,'Normally the friendly names will be displayed on this page and the internal issabelpbx_conf configuration names are shown in the tooltip. If you prefer to view the configuration variables, and the friendly name in the tooltip, set this to false..','bool','','1',0,0,'Advanced Settings Details','',0,0),('AS_DISPLAY_HIDDEN_SETTINGS','0','Display Hidden Settings',0,'This will display settings that are normally hidden by the system. These settings are often internally used settings that are not of interest to most users.','bool','','0',1,1,'Advanced Settings Details','',0,0),('AS_DISPLAY_READONLY_SETTINGS','0','Display Readonly Settings',0,'This will display settings that are readonly. These settings are often internally used settings that are not of interest to most users. Since they are readonly they can only be viewed.','bool','','0',0,0,'Advanced Settings Details','',0,0),('AS_OVERRIDE_READONLY','0','Override Readonly Settings',0,'Setting this to true will allow you to override un-hidden readonly setting to change them. Settings that are readonly may be extremely volatile and have a high chance of breaking your system if you change them. Take extreme caution when electing to make such changes.','bool','','0',0,0,'Advanced Settings Details','',0,0),('AUTHTYPE','database','Authorization Type',3,'Authentication type to use for web admin. If type set to <b>database</b>, the primary AMP admin credentials will be the AMPDBUSER/AMPDBPASS above. When using database you can create users that are restricted to only certain module pages. When set to none, you should make sure you have provided security at the apache level. When set to webserver, IssabelPBX will expect authentication to happen at the apache level, but will take the user credentials and apply any restrictions as if it were in database mode.','select','database,none,webserver','database',1,0,'System Setup','',0,-130),('BADDESTABORT','0','Abort Config Gen on Bad Dest',3,'Setting either of these to true will result in retrieve_conf aborting during a reload if an extension conflict is detected or a destination is detected. It is usually better to allow the reload to go through and then correct the problem but these can be set if a more strict behavior is desired.','bool','','0',0,0,'GUI Behavior','',0,-100),('BLOCK_OUTBOUND_TRUNK_CNAM','0','Block CNAM on External Trunks',0,'Some carriers will reject a call if a CallerID Name (CNAM) is presented. This occurs in several areas when configuring CID on the PBX using the format of \'CNAM\' <CNUM>. To remove the CNAM part of CID on all external trunks, set this value to true. This WILL NOT remove CNAM when a trunk is called from an Intra-Company route. This can be done on each individual trunk in addition to globally if there are trunks where it is desirable to keep CNAM information, though most carriers ignore CNAM.','bool','','0',0,0,'Dialplan and Operational','',0,-100),('BRAND_ALT_JS','','Alternate JS',1,'Alternate JS file, to supplement legacy.script.js','text','','',1,1,'Styling and Logos','',1,360),('BRAND_CSS_ALT_MAINSTYLE','','Primary CSS Stylesheet',1,'Set this to replace the default mainstyle.css style sheet with your own, relative to admin.','text','','',1,0,'Styling and Logos','',1,160),('BRAND_CSS_ALT_POPOVER','','Primary CSS Popover Stylesheet Addtion',1,'Set this to replace the default popover.css style sheet with your own, relative to admin.','text','','',1,0,'Styling and Logos','',1,162),('BRAND_CSS_CUSTOM','','Optional Additional CSS Stylesheet',1,'Optional custom CSS style sheet included after the primary one and any module specific ones are loaded, relative to admin.','text','','',1,0,'Styling and Logos','',1,170),('BRAND_IMAGE_FAVICON','images/favicon.ico','Favicon',1,'Favicon','text','','images/favicon.ico',1,1,'Styling and Logos','',0,40),('BRAND_IMAGE_ISSABELPBX_FOOT','images/issabelpbx_small.png','Image: Footer',1,'Logo in footer.  Path is relative to admin.','text','','images/issabelpbx_small.png',1,0,'Styling and Logos','',1,50),('BRAND_IMAGE_ISSABELPBX_LINK_FOOT','http://www.issabel.org','Link for Footer Logo',1,'link to follow when clicking on logo, defaults to http://www.issabel.org','text','','http://www.issabel.org',1,0,'Styling and Logos','',1,120),('BRAND_IMAGE_ISSABELPBX_LINK_LEFT','http://www.issabel.org','Link for Left Logo',1,'link to follow when clicking on logo, defaults to http://www.issabel.org','text','','http://www.issabel.org',1,0,'Styling and Logos','',1,100),('BRAND_IMAGE_SPONSOR_FOOT','','Image: Footer',1,'Logo in footer.  Path is relative to admin.','text','','',1,0,'Styling and Logos','',1,50),('BRAND_IMAGE_SPONSOR_LINK_FOOT','','Link for Sponsor Footer Logo',1,'link to follow when clicking on sponsor logo','text','','',1,0,'Styling and Logos','',1,120),('BRAND_IMAGE_TANGO_LEFT','images/tango.png','Image: Left Upper',1,'Left upper logo.  Path is relative to admin.','text','','images/tango.png',1,0,'Styling and Logos','',0,40),('BRAND_ISSABELPBX_ALT_FOOT','IssabelPBX&reg;','Alt for Footer Logo',1,'alt attribute to use in place of image and title hover value. Defaults to IssabelPBX','text','','IssabelPBX&reg;',1,0,'Styling and Logos','',1,90),('BRAND_ISSABELPBX_ALT_LEFT','IssabelPBX','Alt for Left Logo',1,'alt attribute to use in place of image and title hover value. Defaults to IssabelPBX','text','','IssabelPBX',1,0,'Styling and Logos','',1,70),('BRAND_SPONSOR_ALT_FOOT','','Alt for Footer Logo',1,'alt attribute to use in place of image and title hover value. Defaults to IssabelPBX','text','','',1,0,'Styling and Logos','',1,90),('BRAND_TITLE','IssabelPBX Administration','Page Title',1,'HTML title of all pages','text','','IssabelPBX Administration',1,1,'Styling and Logos','',0,40),('BROWSER_STATS','1','Browser Stats',0,'Setting this to true will allow the development team to use google analytics to anonymously analyze browser information to help make better development decision.','bool','','1',0,0,'System Setup','',0,-100),('CCBS_AVAILABLE_TIMER_DEFAULT','4800','Max Camp-On Life Busy Default',1,'Asteirsk: ccbs_available_timer. How long a call completion request will remain active, in seconds, before expiring if the phone rang busy when first attempting the call.','select','1200,2400,3600,4800,6000,7200,10800,14400,18000,21600,25200,28800,32400','4800',0,0,'Camp-On Module','campon',0,70),('CCNR_AVAILABLE_TIMER_DEFAULT','7200','Max Camp-On Life No Answer Default',1,'Asteirsk: ccnr_available_timer. How long a call completion request will remain active, in seconds, before expiring if the phone was simply unanswered when first attempting the call.','select','1200,2400,3600,4800,6000,7200,10800,14400,18000,21600,25200,28800,32400','7200',0,0,'Camp-On Module','campon',0,80),('CC_AGENT_ALERT_INFO_DEFAULT','','Default Callback Alert-Info',1,'An optional Alert-Info setting that can be used when initiating a callback. Only valid when \'Caller Policy\' is set to \'generic\' device\'','text','','',0,0,'Camp-On Module','campon',1,120),('CC_AGENT_CID_PREPEND_DEFAULT','','Default Callback CID Prepend',1,'An optional CID Prepend setting that can be used when initiating a callback. Only valid when \'Caller Policy\' is set to a \'generic\' device\'','text','','',0,0,'Camp-On Module','campon',1,130),('CC_AGENT_DIALSTRING_DEFAULT','extension','Default Caller Callback Mode',1,'Affects Asterisk: cc_agent_dialstring. If not set a callback request will be dialed straight to the speciifc device that made the call. If using \'native\' technology support this may be the peferred mode. The \'internal\' (Callback Standard) option will intiate a call back to the caller just as if someone else on the system placed the call, which means the call can pursue Follow-Me. To avoid Follow-Me setting, choose \'extension\' (Callback Extension).','select',',extension,internal','extension',0,0,'Camp-On Module','campon',0,100),('CC_AGENT_POLICY_DEFAULT','generic','Caller Policy Default',1,'Asterisk: cc_agent_policy. Used to enable Camp-On for a user and set the Technology Mode that will be used when engaging the feature. In most cases \'generic\' should be chosen unless you have phones designed to work with channel specific capabilities.','select','never,generic,native','generic',0,0,'Camp-On Module','campon',0,40),('CC_ANNOUNCE_MONITOR_DEFAULT','1','Announce the Callee Extension',1,'When set to true the target extension being called will be announced upone answering the Callback prior to ringing the extension. Setting this to false will go directly to ringing the extension, the CID information will still reflect who is being called back.','bool','','1',0,0,'Camp-On Module','campon',0,140),('CC_BLF_CALLER_BUSY','ONHOLD','BLF Camp-On Busy Caller State',1,'This is the state that will be set for BLF subscriptions once the callee becomes available if the caller is not busy. Restart Asterisk for changes to take effect.','select','NOT_INUSE,INUSE,BUSY,UNAVAILABLE,RINGING,RINGINUSE,ONHOLD','ONHOLD',0,0,'Camp-On Module','campon',0,200),('CC_BLF_OFFERED','NOT_INUSE','BLF Camp-On Available State',1,'This is the state that will be set for BLF subscriptions after attempting a call while it is still possible to Camp-On to the last called number, prior to the offer_timer expiring. Restart Asterisk for changes to take effect.','select','NOT_INUSE,INUSE,BUSY,UNAVAILABLE,RINGING,RINGINUSE,ONHOLD','NOT_INUSE',0,0,'Camp-On Module','campon',0,180),('CC_BLF_PENDING','INUSE','BLF Camp-On Pending State',1,'This is the state that will be set for BLF subscriptions upon a successful Camp-On request, pending a callback when the party becomes available. Restart Asterisk for changes to take effect.','select','NOT_INUSE,INUSE,BUSY,UNAVAILABLE,RINGING,RINGINUSE,ONHOLD','INUSE',0,0,'Camp-On Module','campon',0,190),('CC_BLF_RECALL','RINGING','BLF Camp-On Recalling State',1,'This is the state that will be set for BLF subscriptions once the callee becomes available if the caller is not busy. Restart Asterisk for changes to take effect.','select','NOT_INUSE,INUSE,BUSY,UNAVAILABLE,RINGING,RINGINUSE,ONHOLD','RINGING',0,0,'Camp-On Module','campon',0,210),('CC_FORCE_DEFAULTS','1','Only Use Default Camp-On Settings',1,'You can force all extensions on a system to only used the default Camp-On settings. When in this mode, the individual settings will not be shown on the extension page. If there were unique settings previously configured, the data will be retained but not used unless you switch this back to false. With this set, the Caller Policy (cc_agent_policy) and Callee Policy (cc_monitor_policy) settings will still be configurable for each user so you can still enable/disable Call Camping ability on select extensions.','bool','','1',0,0,'Camp-On Module','campon',0,30),('CC_MAX_AGENTS_DEFAULT','5','Default Max Camped-On Extensions',1,'Asterisk: cc_max_agents. Only valid for when using \'native\' technology support for Caller Policy. This is the number of outstanding Call Completion requests that can be pending to different extensions. With \'generic\' device mode you can only have a single request outstanding and this will be ignored.','select','1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20','5',0,0,'Camp-On Module','campon',0,110),('CC_MAX_MONITORS_DEFAULT','5','Default Max Queued Callers',1,'Asterisk: cc_max_monitors. This is the maximum number of callers that are allowed to queue up call completion requests against this extension.','select','1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20','5',0,0,'Camp-On Module','campon',0,170),('CC_MAX_REQUESTS_GLOBAL','20','Maximum Active Camp-On Requests',1,'System wide maximum number of outstanding Camp-On requests that can be active. This limit is useful on a system that may have memory constraints since the internal state machine takes up system resources relative to the number of active requests it has to track. Restart Asterisk for changes to take effect.','int','1,1000','20',0,0,'Camp-On Module','campon',0,10),('CC_MONITOR_ALERT_INFO_DEFAULT','','Default Callee Alert-Info',1,'An optional Alert-Info setting that can be used to send to the extension being called back.','text','','',0,0,'Camp-On Module','campon',1,150),('CC_MONITOR_CID_PREPEND_DEFAULT','','Default Callee CID Prepend',1,'An optional CID Prepend setting that can be used to send to the extension being called back.\'','text','','',0,0,'Camp-On Module','campon',1,160),('CC_MONITOR_POLICY_DEFAULT','generic','Callee Policy Default',1,'Asterisk: cc_monitor_policy. Used to control if other phones are allowed to Camp On to an extension. If so, it sets the technology mode used to monitor the availability of the extension. If no specific technology support is available then it should be set to a \'generic\'. In this mode, a callback will be initiated to the extension when it changes from an InUse state to NotInUse. If it was busy when first attempted, this will be when the current call has eneded. If it simply did not answer, then this will be the next time this phone is used to make or answer a call and then hangs up. It is possible to set this to take advantage of \'native\' technology support if available and automatically fallback to \'generic\' whe not by setting it to \'always\'.','select','never,generic,native,always','generic',0,0,'Camp-On Module','campon',0,50),('CC_NON_EXTENSION_POLICY','never','Non Extensions Callee Policy',1,'If this is set to \'generic\' or \'always\' then it will be possible to attempt call completion requests when dialing non-extensions such as ring groups and other possible destinations that could work with call completion. Setting this will bypass any Callee Policies and can result in inconsistent behavior. If set, \'generic\' is the most common, \'always\' will attempt to use technology specific capabilities if the called extension uses a channel that supports that.','select','never,generic,always','never',0,0,'Camp-On Module','campon',0,20),('CC_OFFER_TIMER_DEFAULT','30','Caller Timeout to Request Default',1,'Asterisk: cc_offer_timer. How many seconds after dialing an extenion a user has to make a call completion request.','select','20,30,45,60,120,180,240,300,600','30',0,0,'Camp-On Module','campon',0,60),('CC_RECALL_TIMER_DEFAULT','15','Default Time to Ring Back Caller',1,'Asterisk: cc_recall_timer. How long in seconds to ring back a caller who\'s Caller Policy is set to \'Generic Device\'. This has no affect if set to any other setting.','select','5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60','15',0,0,'Camp-On Module','campon',0,90),('CDRDBHOST','','Remote CDR DB Host',3,'DO NOT set this unless you know what you are doing. Only used if you do not use the default values provided by IssabelPBX.<br>Hostname of db server if not the same as AMPDBHOST.','text','','',1,0,'Remote CDR Database','',1,-100),('CDRDBNAME','','Remote CDR DB Name',3,'DO NOT set this unless you know what you are doing. Only used if you do not use the default values provided by IssabelPBX.<br>Name of database used for cdr records.','text','','',1,0,'Remote CDR Database','',1,-100),('CDRDBPASS','','Remote CDR DB Password',3,'DO NOT set this unless you know what you are doing. Only used if you do not use the default values provided by IssabelPBX.<br>Password for connecting to db if its not the same as AMPDBPASS.','text','','',1,0,'Remote CDR Database','',1,-100),('CDRDBPORT','','Remote CDR DB Port',3,'DO NOT set this unless you know what you are doing. Only used if you do not use the default values provided by IssabelPBX.<br>Port number for db host.','int','1024,65536','',1,0,'Remote CDR Database','',1,-100),('CDRDBTABLENAME','','Remote CDR DB Table',3,'DO NOT set this unless you know what you are doing. Only used if you do not use the default values provided by IssabelPBX. Name of the table in the db where the cdr is stored. cdr is default.','text','','',1,0,'Remote CDR Database','',1,-100),('CDRDBTYPE','','Remote CDR DB Type',3,'DO NOT set this unless you know what you are doing. Only used if you do not use the default values provided by IssabelPBX. Defaults to your configured AMDBENGINE.','select',',mysql,postgres','',1,0,'Remote CDR Database','',1,-100),('CDRDBUSER','','Remote CDR DB User',3,'DO NOT set this unless you know what you are doing. Only used if you do not use the default values provided by IssabelPBX. Username to connect to db with if it is not the same as AMPDBUSER.','text','','',1,0,'Remote CDR Database','',1,-100),('CEL_ENABLED','1','Enable CEL Reporting',3,'Setting this true will enable the CDR module to drill down on CEL data for each CDR. Although the CDR module will assure there is a CEL table available, the reporting functionality in Asterisk and associated ODBC database and CEL configuration must be done outside of IssabelPBX either by the user or at the Distro level.','bool','','0',0,0,'CDR Report Module','cdr',0,10),('CFRINGTIMERDEFAULT','0','Call Forward Ringtimer Default',0,'This is the default time in seconds to try and connect a call that has been call forwarded by the server side CF, CFU and CFB options. (If your phones use client side CF such as SIP redirects, this will not have any affect) If set to the default of 0, it will use the standard ring timer. If set to -1 it will ring the forwarded number with no limit which is consistent with the behavior of some existing PBX systems. If set to any other value, it will ring for that duration before diverting the call to the users voicemail if they have one. This can be overridden for each extension.','select','-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120','0',0,0,'Dialplan and Operational','',0,-100),('CHECKREFERER','1','Check Server Referrer',0,'When set to the default value of true, all requests into IssabelPBX that might possibly add/edit/delete settings will be validated to assure the request is coming from the server. This will protect the system from CSRF (cross site request forgery) attacks. It will have the effect of preventing legitimately entering URLs that could modify settings which can be allowed by changing this field to false.','bool','','1',0,0,'GUI Behavior','',0,-100),('CID_PREPEND_REPLACE','1','Only Use Last CID Prepend',0,'Some modules allow the CNAM to be prepended. If a previous prepend was done, the default behavior is to remove the previous prepend and only use the most recent one. Setting this to false will turn that off allowing all prepends to be \'starcked\' in front of one another.','bool','','1',0,0,'Dialplan and Operational','',0,-100),('CONCURRENCYLIMITDEFAULT','0','Extension Concurrency Limit',0,'Default maximum number of outbound simultaneous calls that an extension can make. This is also very useful as a Security Protection against a system that has been compromised. It will limit the number of simultaneous calls that can be made on the compromised extension. This default is used when an extension is created. A default of 0 means no limit.','select','0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120','0',0,0,'Dialplan and Operational','',0,-100),('CONNECTEDLINE_PRESENCESTATE','1','Display Presence State of Callee',0,'When set to true and when CONNECTEDLINE() capabilities are configured and supported by your handset, the name displayed will include the presence state of the callee.','bool','','1',0,0,'Dialplan and Operational','',0,0),('CRONMAN_UPDATES_CHECK','1','Update Notifications',0,'IssabelPBX allows you to automatically check for updates online. The updates will NOT be automatically installed. It is STRONGYLY advised that you keep this enabled and keep updated of these important notificaions to avoid costly security issues.','bool','','1',1,0,'System Setup','',0,-100),('CUSTOMASERROR','1','Report Unknown Dest as Error',2,'If false, then the Destination Registry will not report unknown destinations as errors. This should be left to the default true and custom destinations should be moved into the new custom apps registry.','bool','','1',0,0,'GUI Behavior','',0,-100),('CWINUSEBUSY','1','Occupied Lines CW Busy',0,'For extensions that have CW enabled, report unanswered CW calls as <b>busy</b> (resulting in busy voicemail greeting). If set to no, unanswered CW calls simply report as <b>no-answer</b>.','bool','','1',0,0,'Dialplan and Operational','',0,-100),('DASHBOARD_INFO_UPDATE_TIME','30','Dashboard Info Update Frequency',0,'Update rate in seconds of the Info section of the System Status panel.','select','15,30,60,120,300,600','30',0,0,'GUI Behavior','dashboard',0,0),('DASHBOARD_STATS_UPDATE_TIME','6','Dashboard Stats Update Frequency',0,'Update rate in seconds of all sections of the System Status panel except the Info box.','select','6,10,20,30,45,60,120,300,600','6',0,0,'GUI Behavior','dashboard',0,0),('DAYNIGHTTCHOOK','0','Hook Time Conditions Module',1,'By default, the Call Flow Control module will not hook Time Conditions allowing one to associate a call flow toggle feauture code with a time condition since time conditions have their own feature code as of version 2.9. If there is already an associaiton configured (on an upgraded system), this will have no affect for the Time Conditions that are effected. Setting this to true reverts the 2.8 and prior behavior by allowing for the use of a call flow toggle to be associated with a time conditon. This can be useful for two scenarios. First, to override a Time Condition without the automatic resetting that occurs with the built in Time Condition overrides. The second use is the ability to associate a single call flow toggle with multiple time conditions thus creating a <b>master switch</b> that can be used to override several possible call flows through different time conditions.','bool','','0',0,0,'Call Flow Control Module','daynight',0,0),('DEFAULT_INTERNAL_AUTO_ANSWER','disabled','Internal Auto Answer Default',0,'Default setting for new extensions. When set to Intercom, calls to new extensions/users from other internal users act as if they were intercom calls meaning they will be auto-answered if the endpoint supports this feature and the system is configured to operate in this mode. All the normal white list and black list settings will be honored if they are set. External calls will still ring as normal, as will certain other circumstances such as blind transfers and when a Follow Me is configured and enabled. If Disabled, the phone rings as a normal phone.','select','disabled,intercom','disabled',0,0,'Dialplan and Operational','',0,-100),('DEVEL','0','Developer Mode',2,'This enables several debug features geared towards developers, including some page load timing information, some debug information in Module Admin, use of original CSS files and other future capabilities will be enabled.','bool','','0',0,0,'Developer and Customization','',0,-100),('DEVELRELOAD','0','Leave Reload Bar Up',2,'Forces the \'Apply Configuration Changes\' reload bar to always be present even when not necessary.','bool','','0',0,0,'Developer and Customization','',0,-100),('DEVICE_ALLOW','','SIP and IAX allow',0,'Default setting for SIP and IAX allow (for codecs). Codecs to allow in addition to those set in general settings unless explicitly \'disallowed\' for the device. Values van be separated with \'&\' e.g. \'ulaw&g729&g729\' where the preference order is preserved. See Asterisk documentation for details.','text','','',0,0,'Device Settings','',1,90),('DEVICE_CALLGROUP','','SIP and DAHDi callgroup',0,'Default setting for SIP, DAHDi (and Zap) callgroup. Callgroup(s) that the device is part of, can be one or more callgroups, e.g. \'1,3-5\' would be in groups 1,3,4,5. See Asterisk documentation for details.','text','','',0,0,'Device Settings','',1,100),('DEVICE_DISALLOW','','SIP and IAX disallow',0,'Default setting for SIP and IAX disallow (for codecs). Codecs to disallow, can help to reset from the general settings by setting a value of \'all\' and then specifically including allowed codecs with the \'allow\' directive. Values van be separated with \'&\' e.g. \'g729&g722\'. See Asterisk documentation for details.','text','','',0,0,'Device Settings','',1,90),('DEVICE_PICKUPGROUP','','SIP and DAHDi pickupgroup',0,'Default setting for SIP, DAHDi (and Zap) pickupgroup. Pickupgroups(s) that the device can pickup calls from, can be one or more groups, e.g. \'1,3-5\' would be in groups 1,3,4,5. Device does not have to be in a group to be able to pickup calls from that group. See Asterisk documentation for details.','text','','',0,0,'Device Settings','',1,110),('DEVICE_QUALIFY','yes','SIP and IAX qualify',0,'Default setting for SIP and IAX qualify. Whether to send periodic OPTIONS messages (for SIP) or otherwise monitor the channel, and at what point to consider the channel unavailable. A value of \'yes\' is equivalent to 2000, time in msec. Can help to keep NAT holes open with SIP but not dependable for remote client firewalls. See Asterisk documentation for details.','text','','yes',0,0,'Device Settings','',0,80),('DEVICE_REMOVE_MAILBOX','0','Remove mailbox Setting when no Voicemail',0,'If set to true, any fixed device associated with a user that has no voicemail configured will have the \"mailbox=\" setting removed in the generated technology configuration file such as sip_additional.conf. This will not affect the value in the GUI.','bool','','0',0,0,'Device Settings','',0,15),('DEVICE_SIP_CANREINVITE','no','SIP canrenivite (directmedia)',0,'Default setting for SIP canreinvite (same as directmedia). See Asterisk documentation for details.','select','no,yes,nonat,update','no',0,0,'Device Settings','',0,20),('DEVICE_SIP_ENCRYPTION','no','SIP encryption',0,'Default setting for SIP encryption. Whether to offer SRTP encrypted media (and only SRTP encrypted media) on outgoing calls to a peer. Calls will fail with HANGUPCAUSE=58 if the peer does not support SRTP. See Asterisk documentation for details.','select','no,yes','no',0,0,'Device Settings','',0,60),('DEVICE_SIP_NAT','no','SIP nat',0,'Default setting for SIP nat. A \'yes\' will attempt to handle nat, also works for local (uses the network ports and address instead of the reported ports), \'no\' follows the protocol, \'never\' tries to block it, no RFC3581, \'route\' ignores the rport information. See Asterisk documentation for details.','select','no,yes,never,route','no',0,0,'Device Settings','',0,50),('DEVICE_SIP_QUALIFYFREQ','60','SIP qualifyfreq',0,'Default setting for SIP qualifyfreq. Only valid for Asterisk 1.6 and above. Frequency that \'qualify\' OPTIONS messages will be sent to the device. Can help to keep NAT holes open but not dependable for remote client firewalls. See Asterisk documentation for details.','int','15,86400','60',0,0,'Device Settings','',0,70),('DEVICE_SIP_SENDRPID','no','SIP sendrpid',0,'Default setting for SIP sendrpid. A value of \'yes\' is equivalent to \'rpid\' and will send the \'Remote-Party-ID\' header. A value of \'pai\' is only valid starting with Asterisk 1.8 and will send the \'P-Asserted-Identity\' header. See Asterisk documentation for details.','select','no,yes,pai','no',0,0,'Device Settings','',0,40),('DEVICE_SIP_TRUSTRPID','yes','SIP trustrpid',0,'Default setting for SIP trustrpid. See Asterisk documentation for details.','select','no,yes','yes',0,0,'Device Settings','',0,30),('DEVICE_STRONG_SECRETS','1','Require Strong Secrets',0,'Requires a strong secret on SIP and IAX devices requiring at least two numeric and non-numeric characters and 6 or more characters. This can be disabled if using devices that can not meet these needs, or you prefer to put other constraints including more rigid constraints that this rule actually considers weak when it may not be.','bool','','1',0,0,'Device Settings','',0,12),('DIAL_OPTIONS','Ttr','Asterisk Dial Options',0,'Options to be passed to the Asterisk Dial Command when making internal calls or for calls ringing internal phones. The options are documented in Asterisk documentation, a subset of which are described here. The default options T and t allow the calling and called users to transfer a call with ##. The r option allows Asterisk to generate ringing back to the calling phones which is needed by some phones and sometimes needed in complex dialplan features that may otherwise result in silence to the caller.','text','','Ttr',0,0,'Dialplan and Operational','',1,0),('DIE_ISSABELPBX_VERBOSE','0','Provide Verbose Tracebacks',2,'Provides a very verbose traceback when die_issabelpbx() is called including extensive object details if present in the traceback.','bool','','0',0,0,'Developer and Customization','',0,-100),('DISABLECUSTOMCONTEXTS','0','Disable -custom Context Includes',2,'Normally IssabelPBX auto-generates a custom context that may be usable for adding custom dialplan to modify the normal behavior of IssabelPBX. It takes a good understanding of how Asterisk processes these includes to use this and in many of the cases, there is no useful application. All includes will result in a WARNING in the Asterisk log if there is no context found to include though it results in no errors. If you know that you want the includes, you can set this to true. If you comment it out IssabelPBX will revert to legacy behavior and include the contexts.','bool','','0',0,0,'Dialplan and Operational','',0,-100),('DISABLE_CSS_AUTOGEN','1','Disable Mainstyle CSS Compression',2,'Stops the automatic generation of a stripped CSS file that replaces the primary sheet, usually mainstyle.css.','bool','','0',0,0,'Developer and Customization','',0,-100),('DISPLAY_MONITOR_TRUNK_FAILURES_FIELD','0','Display Monitor Trunk Failures Option',2,'Setting this to true will expose the \"Monitor Trunk Failures\" field on the Trunks page. This field allows for a custom AGI script to be called upon a trunk failure. This is an advanced field requiring a custom script to be properly written and installed. Existing trunk page entries will not be affected if this is set to false but if the settings are changed on those pages the field will go away.','bool','','0',0,0,'Developer and Customization','',0,-100),('DITECH_VQA_INBOUND','7','Ditech VQA Inbound Setting',0,'If Ditech\'s VQA, Voice Quality application is installed, this setting will be used for all inbound calls. For more information \'core show application VQA\' at the Asterisk CLI will show the different settings.','select','0,1,2,3,4,5,6,7','7',0,0,'Dialplan and Operational','',0,-100),('DITECH_VQA_OUTBOUND','7','Ditech VQA Outbound Setting',0,'If Ditech\'s VQA, Voice Quality application is installed, this setting will be used for all outbound calls. For more information \'core show application VQA\' at the Asterisk CLI will show the different settings.','select','0,1,2,3,4,5,6,7','7',0,0,'Dialplan and Operational','',0,-100),('DIVERSIONHEADER','0','Generate Diversion Headers',0,'If this value is set to true, then calls going out your outbound routes that originate from outside your PBX and were subsequently forwarded through a call forward, ring group, follow-me or other means, will have a SIP diversion header added to the call with the original incoming DID assuming there is a DID available. This is useful with some carriers that may require this under certain circumstances.','bool','','0',0,0,'Dialplan and Operational','',0,-100),('DYNAMICHINTS','0','Dynamically Generate Hints',0,'If true, Core will not statically generate hints, but instead make a call to the AMPBIN php script, and generate_hints.php through an Asterisk #exec call. This requires asterisk.conf to be configured with <b>execincludes=yes<b> set in the [options] section.','bool','','0',1,0,'Dialplan and Operational','',0,-100),('ENABLECW','1','CW Enabled by Default',0,'Enable call waiting by default when an extension is created (Default is yes). Set to <b>no</b> to if you do not want phones to be commissioned with call waiting already enabled. The user would then be required to dial the CW feature code (*70 default) to enable their phone. Most installations should leave this alone. It allows multi-line phones to receive multiple calls on their line appearances.','bool','','1',0,0,'Dialplan and Operational','',0,-100),('EXTENSION_LIST_RINGGROUPS','0','Display Extension Ring Group Members',0,'When set to true extensions that belong to one or more Ring Groups will have a Ring Group section and link back to each group they are a member of.','bool','','0',0,0,'Ring Group Module','ringgroups',0,50),('FCBEEPONLY','0','Feature Codes Beep Only',0,'When set to true, a beep is played instead of confirmation message when activating/de-activating: CallForward, CallWaiting, DayNight, DoNotDisturb and FindMeFollow.','bool','','0',0,0,'Dialplan and Operational','',0,-100),('FOLLOWME_AUTO_CREATE','0','Create Follow Me at Extension Creation Time',1,'When creating a new user or extension, setting this to true will automatically create a new Follow Me for that user using the default settings listed below','bool','','0',0,0,'Follow Me Module','findmefollow',0,30),('FOLLOWME_DISABLED','1','Disable Follow Me Upon Creation',1,'This is the default value for the Follow Me \"Disable\" setting. When first creating a Follow Me or if auto-created with a new extension, setting this to true will disable the Follow Me setting which can be changed by the user or admin in multiple locations.','bool','','1',0,0,'Follow Me Module','findmefollow',0,40),('FOLLOWME_PRERING','7','Default Follow Me Initial Ring Time',1,'The default Initial Ring Time for a Follow Me set upon creation and used if auto-created with a new extension.','select','5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60','7',0,0,'Follow Me Module','findmefollow',0,60),('FOLLOWME_RG_STRATEGY','ringallv2-prim','Default Follow Me Ring Strategy',1,'The default Ring Strategy selected for a Follow Me set upon creation and used if auto-created with an extension.','select','ringallv2,ringallv2-prim,ringall,ringall-prim,hunt,hunt-prim,memoryhunt,memoryhunt-prim,firstavailable,firstnotonphone','ringallv2-prim',0,0,'Follow Me Module','findmefollow',0,70),('FOLLOWME_TIME','20','Default Follow Me Ring Time',1,'The default Ring Time for a Follow Me set upon creation and used if auto-created with a new extension.','select','5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120','20',0,0,'Follow Me Module','findmefollow',0,50),('FOPWEBROOT','/var/www/html/admin/modules/fw_fop/','FOP Web Root Dir',4,'Path to the Flash Operator Panel webroot or other modules providing such functionality (leave off trailing slash).','dir','','',1,0,'Flash Operator Panel','',1,-100),('FORCED_ASTVERSION','','Force Asterisk Version',4,'Normally IssabelPBX gets the current Asterisk version directly from Asterisk. This is required to generate proper dialplan for a given version. When using some custom Asterisk builds, the version may not be properly parsed and improper dialplan generated. Setting this to an equivalent Asterisk version will override what is read from Asterisk. This SHOULD be left blank unless you know what you are doing.','text','','',1,0,'System Setup','',1,-100),('FORCE_INTERNAL_AUTO_ANSWER_ALL','0','Force All Internal Auto Answer',0,'Force all extensions to operate in the Internal Auto Answer mode regardless of their individual settings. See \'Internal Auto Answer Default\' for more information.','bool','','0',0,0,'Dialplan and Operational','',0,-100),('FORCE_JS_CSS_IMG_DOWNLOAD','0','Always Download Web Assets',2,'IssabelPBX appends versioning tags on the CSS and javascript files and some of the main logo images. The versioning will help force browsers to load new versions of the files when module versions are upgraded. Setting this value to true will try to force these to be loaded to the browser every page load by appending an additional timestamp in the version information. This is useful during development and debugging where changes are being made to javascript and CSS files.','bool','','0',0,0,'Developer and Customization','',0,-100),('FPBXDBUGDISABLE','1','Disable IssabelPBX dbug Logging',2,'Set to true to stop all dbug() calls from writing to the Debug File (FPBXDBUGFILE)','bool','','1',0,0,'Developer and Customization','',0,-100),('FPBXDBUGFILE','/var/log/asterisk/issabelpbx_dbug','Debug File',2,'Full path and name of IssabelPBX debug file. Used by the dbug() function by developers.','text','','/var/log/asterisk/issabelpbx_dbug',0,0,'Developer and Customization','',0,-100),('FPBX_LOG_FILE','/var/log/asterisk/issabelpbx.log','IssabelPBX Log File',0,'Full path and name of the IssabelPBX Log File used in conjunction with the Syslog Level (AMPSYSLOGLEVEL) being set to FILE, not used otherwise. Initial installs may have some early logging sent to /tmp/issabelpbx_pre_install.log when it is first bootstrapping the installer.','text','','/var/log/asterisk/issabelpbx.log',0,0,'System Setup','',0,-150),('GENERATE_LEGACY_QUEUE_CODES','1','Generate queuenum*/** Login/off Codes',3,'Queue login and out codes were historically queunum* and queunum**. These have been largely replaced by the *45 queue toggle codes. The legacy codes are required to login or out a third party user that is not the extension dialing. These can be removed from the system by setting this to false.','bool','','1',0,0,'Queues Module','queues',0,120),('HTTPBINDADDRESS','0.0.0.0','HTTP Bind Address',2,'Address to bind to. Default is 0.0.0.0','text','','0.0.0.0',0,0,'Asterisk Builtin mini-HTTP server','',0,0),('HTTPBINDPORT','8088','HTTP Bind Port',2,'Port to bind to. Default is 8088','int','10,65536','8088',0,0,'Asterisk Builtin mini-HTTP server','',0,0),('HTTPENABLED','0','Enable the mini-HTTP Server',1,'Whether the Asterisk HTTP interface is enabled or not. This is for Asterisk, it is not directly related for IssabelPBX usage and the value of this setting is irrelevant for accessing core IssabelPBX settings. Default is no.','bool','','0',0,0,'Asterisk Builtin mini-HTTP server','',0,0),('HTTPENABLESTATIC','0','Enable Static Content',2,'Whether Asterisk should serve static content from http-static (HTML pages, CSS, javascript, etc.). Default is no.','bool','','0',0,0,'Asterisk Builtin mini-HTTP server','',0,0),('HTTPPREFIX','','HTTP Prefix',2,'HTTP Prefix allows you to specify a prefix for all requests to the server. For example, if the prefix is set to \"asterisk\" then all requests must begin with /asterisk. If this field is blank it is akin to saying all requests must being with /, essentially no prefix','text','','',0,0,'Asterisk Builtin mini-HTTP server','',1,0),('JQUERYUI_VER','1.8.9','jQuery UI Version',0,'The version of jQuery UI that we wish to use.','text','','1.8.9',1,1,'System Setup','',0,-100),('JQUERY_CSS','assets/css/jquery-ui.css','jQuery UI css',1,'css file for jquery ui','text','','assets/css/jquery-ui.css',1,1,'Styling and Logos','',0,320),('JQUERY_VER','1.7.1','jQuery Version',0,'The version of jQuery that we wish to use.','text','','1.7.1',1,1,'System Setup','',0,-100),('LOG_NOTIFICATIONS','1','Send Dashboard Notifications to Log',0,'When enabled all notification updates to the Dashboard notification panel will also be logged into the specified log file when enabled.','bool','','1',0,0,'System Setup','',0,-160),('LOG_OUT_MESSAGES','1','Log Verbose Messages',0,'IssabelPBX has many verbose and useful messages displayed to users during module installation, system installations, loading configurations and other places. In order to accumulate these messages in the log files as well as the on screen display, set this to true.','bool','','1',0,0,'System Setup','',0,-170),('mainstyle_css_generated','','Compressed Copy of Main CSS',10,'internal use','text','','',1,1,'Internal Use','',1,110),('MAXCALLS','','Dashboard Max Calls Initial Scale',2,'Use this to pre-set the scale for maximum calls on the Dashboard display. If not set, the the scale is dynamically sized based on the active calls on the system.','int','0,3000','',0,0,'GUI Behavior','dashboard',1,0),('MIXMON_DIR','','Override Call Recording Location',9,'Override the default location where asterisk will store call recordings. Be sure to set proper permissions on the directory for the asterisk user.','dir','','',1,0,'Directory Layout','',1,0),('MIXMON_FORMAT','wav','Call Recording Format',0,'Format to save recoreded calls for most call recording unless specified differently in specific applications.','select','wav,WAV,ulaw,ulaw,alaw,sln,gsm,g729','wav',0,0,'System Setup','',0,0),('MIXMON_POST','','Post Call Recording Script',9,'An optional script to be run after the call is hangup. You can include channel and MixMon variables like ${CALLFILENAME}, ${MIXMON_FORMAT} and ${MIXMON_DIR}. To ensure that you variables are properly escaped, use the following notation: ^{MY_VAR}','text','','',1,0,'Developer and Customization','',1,0),('MODULEADMINWGET','0','Use wget For Module Admin',0,'Module Admin normally tries to get its online information through direct file open type calls to URLs that go back to the issabel.org server. If it fails, typically because of content filters in firewalls that do not like the way PHP formats the requests, the code will fall back and try a wget to pull the information. This will often solve the problem. However, in such environment there can be a significant timeout before the failed file open calls to the URLs return and there are often 2-3 of these that occur. Setting this value will force IssabelPBX to avoid the attempt to open the URL and go straight to the wget calls.','bool','','0',0,0,'GUI Behavior','',0,-100),('MODULEADMIN_SKIP_CACHE','0','Disable Module Admin Caching',2,'Module Admin caches a copy of the online XML document that describes what is available on the server. Subsequent online update checks will use the cached information if it is less than 5 minutes old. To bypass the cache and force it to go to the server each time, set this to True. This should normally be false but can be helpful during testing.','bool','','0',1,0,'Developer and Customization','',0,-100),('MODULE_REPO','http://cloud.issabel.org,http://cloud2.issabel.org','Repo Server',10,'repo server','text','','http://cloud.issabel.org,http://cloud2.issabel.org',1,1,'Internal Use','',0,110),('MOHDIR','moh','MoH Subdirectory',4,'This is the subdirectory for the MoH files/directories which is located in ASTVARLIBDIR. Older installation may be using mohmp3 which was the old Asterisk default and should be set to that value if the music files are located there relative to the ASTVARLIBDIR.','select','moh,mohmp3','moh',1,0,'Directory Layout','',0,-100),('NOOPTRACE','0','NoOp Traces in Dialplan',0,'Some modules will generate lots of NoOp() commands proceeded by a [TRACE](trace_level) that can be used during development or while trying to trace call flows. These NoOp() commands serve no other purpose so if you do not want to see excessive NoOp()s in your dialplan you can set this to 0. The higher the number the more detailed level of trace NoOp()s will be generated','select','0,1,2,3,4,5,6,7,8,9,10','0',0,0,'Dialplan and Operational','',0,-100),('NOTICE_BROWSER_STATS','1','Browser Stats Notice',10,'Internal use to track if notice has been given that anonyous browser stats are being collected.','bool','','0',1,1,'Internal Use','',0,110),('OUTBOUND_CID_UPDATE','1','Display CallerID on Calling Phone',0,'When set to true and when CONNECTEDLINE() capabilities are configured and supported by your handset, the CID value being transmitted on this call will be updated on your handset in the CNAM field prepended with CID: so you know what is being presented to the caller if the outbound trunk supports and honors setting the transmitted CID.','bool','','1',0,0,'Dialplan and Operational','',0,0),('OUTBOUND_DIAL_UPDATE','1','Display Dialed Number on Calling Phone',0,'When set to true and when CONNECTEDLINE() capabilities are configured and supported by your handset, the number actually dialled will be updated on your handset in the CNUM field. This allows you to see the final manipulation of your number after outbound route and trunk dial manipulation rules have been applied. For example, if you have configured 7 digit dialing on a North America dialplan, the ultimate 10 or 11 digit transmission will be displayed back. Any \'Outbound Dial Prefixes\' configured at the trunk level will NOT be shown as these are foten analog line pauses (w) or other characters that distort the CNUM field on updates.','bool','','1',0,0,'Dialplan and Operational','',0,0),('PDFAUTHOR','www.issabel.org','tiff2pdf Author',0,'Author to pass to tiff2pdf\'s -a option','text','','www.issabel.org',1,1,'Styling and Logos','',0,0),('PHP_ERROR_HANDLER_OUTPUT','issabelpbxlog','PHP Error Log Output',0,'Where to send PHP errors, warnings and notices by the IssabelPBX PHP error handler. Set to \'dbug\', they will go to the Debug File regardless of whether dbug Loggin is disabled or not. Set to \'issabelpbxlog\' will send them to the IssabelPBX Log. Set to \'off\' and they will be ignored.','select','dbug,issabelpbxlog,off','issabelpbxlog',0,0,'System Setup','',0,-140),('POST_RELOAD','','POST_RELOAD Script',2,'Automatically execute a script after applying changes in the AMP admin. Set POST_RELOAD to the script you wish to execute after applying changes. If POST_RELOAD_DEBUG=true, you will see the output of the script in the web page.','text','','',1,0,'Developer and Customization','',1,-100),('POST_RELOAD_DEBUG','0','POST_RELOAD Debug Mode',2,'Display debug output for script used if POST_RELOAD is used.','bool','','0',0,0,'Developer and Customization','',0,-100),('PRE_RELOAD','','PRE_RELOAD Script',2,'Optional script to run just prior to doing an extension reload to Asterisk through the manager after pressing Apply Configuration Changes in the GUI.','text','','',1,0,'Developer and Customization','',1,-100),('QUEUES_EVENTS_MEMEBER_STATUS_DEFAULT','0','Memeber Status Event Default',3,'Default state for AMI to emit the QueueMemberStatus event. This setting will only affect the default for NEW queues, it won\'t change existing queues or enfore the option on in new ones.','bool','','0',0,0,'Queues Module','queues',0,120),('QUEUES_EVENTS_WHEN_CALLED_DEFAULT','0','Agent Called Events Default',3,'Default state for AMI emit events related to an agent\'s call. This setting will only affect the default for NEW queues, it won\'t change existing queues or enfore the option on in new ones.','bool','','0',0,0,'Queues Module','queues',0,120),('QUEUES_HIDE_NOANSWER','1','Hide Queue No Answer Option',0,'It is possible for a queue to NOT Answer a call and still enter callers to the queue. The normal behavior is that all  allers are answered before entering the queue. If the call is not answered, it is possible that some early media delivery would still allow callers to hear recordings, MoH, etc. but this can be inconsistent and vary. Because of the volatility of this option, it is not displayed by default. If a queue is set to not answer, the setting will be displayed for that queue regardless of this setting.','bool','','1',0,0,'Queues Module','queues',0,50),('QUEUES_MIX_MONITOR','1','Use MixMonitor for Recordings',0,'Queues: monitor-type = MixMonitor. Setting true will use the MixMonitor application instead of Monitor so the concept of \'joining/mixing\' the in/out files now goes away when this is enabled.','bool','','1',0,0,'Queues Module','queues',0,40),('QUEUES_PESISTENTMEMBERS','1','Persistent Members',0,'Queues: persistentmembers. Store each dynamic member in each queue in the astdb so that when asterisk is restarted, each member will be automatically read into their recorded queues.','bool','','1',1,0,'Queues Module','queues',0,10),('QUEUES_SHARED_LASTCALL','1','Honor Wrapup Time Across Queues',0,'Queues: shared_lastcall, only valid with Asterisk 1.6+. This will make the lastcall and calls received be the same in members logged in more than one queue. This is useful to make the queue respect the wrapuptime of another queue for a shared member.','bool','','1',1,0,'Queues Module','queues',0,20),('QUEUES_UPDATECDR','0','Set Agent Name in CDR dstchannel',0,'Queues: updatecdr, only valid with Asterisk 1.6+. This option is implemented to mimic chan_agents behavior of populating CDR dstchannel field of a call with an agent name, which is set if available at the login time with AddQueueMember membername parameter, or with static members.','bool','','0',0,0,'Queues Module','queues',0,30),('REC_POLICY','caller','Call Recording Policy',0,'Call Recording Policy used to resove the winner in a conflict between two extensions when one wants a call recorded and the other does not, if both their priorities are also the same.','select','caller,callee','caller',0,0,'Dialplan and Operational','',0,-100),('RELOADCONFIRM','1','Require Confirm with Apply Changes',0,'When set to false, will bypass the confirm on Reload Box.','bool','','1',0,0,'GUI Behavior','',0,-100),('RINGTIMER','15','Ringtime Default',0,'Default number of seconds to ring phones before sending callers to voicemail or other extension destinations. This can be set per extension/user. Phones with no voicemail or other destination options will ring indefinitely.','select','0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120','15',0,0,'Dialplan and Operational','',1,0),('SERVERINTITLE','0','Include Server Name in Browser',0,'Precede browser title with the server name.','bool','','0',0,0,'GUI Behavior','',0,-100),('SHOWLANGUAGE','1','Show Language setting',0,'Show Language setting on menu . Defaults = false','bool','','1',0,0,'GUI Behavior','',0,-100),('SIPUSERAGENT','FPBX','SIP User Agent',10,'User Agent prefix','text','','FPBX',1,1,'Internal Use','',0,110),('SSHPORT','','Dashboard Non-Std SSH Port',2,'SSH port number configured on your system if not using the default port 22, this allows the dashboard monitoring to watch the poper port.','int','1,65535','',0,0,'System Setup','dashboard',1,0),('TCINTERVAL','60','Maintenance Polling Interval',1,'The polling interval in seconds used by the Time Conditions manintenace task, launched by an Asterisk call file used to update Time Conditions override states as well as keep custom device state hint values up-to-date when being used with BLF. A shorter interval will assure that BLF keys states are accurate. The interval should be less than the shortest configured span between two time condition states, so that a manual overide during such a period is properly reset when the new period starts.','select','60,120,180,240,300,600,900','60',0,0,'Time Condition Module','timeconditions',0,0),('TCMAINT','1','Enable Maintenance Polling',1,'If set to false, this will override the execution of the Time Conditons maintenace task launched by call files. If all the feature codes for time conditions are disabled, the maintenance task will not be launched anyhow. Setting this to false would be fairly un-common. You may want to set this temporarily if debugging a system to avoid the periodic dialplan running through the CLI that the maintenance task launches and can be distracting.','bool','','1',0,0,'Time Condition Module','timeconditions',0,0),('TIMEFORMAT','12 Hour Format','Speaking Clock Time Format',0,'Time format to use with the Speaking Clock.','select','12 Hour Format,24 Hour Format','12 Hour Format',0,0,'Dialplan and Operational','infoservices',0,0),('TONEZONE','us','Country Indication Tones',0,'Choose the country tonezone that you would like Asterisk to use when creating the different standard telephony tones such as ringing, busy, congetstion, etc.','fselect','a:54:{s:2:\"ao\";s:6:\"Angola\";s:2:\"ar\";s:9:\"Argentina\";s:2:\"au\";s:9:\"Australia\";s:2:\"at\";s:7:\"Austria\";s:2:\"be\";s:7:\"Belgium\";s:2:\"br\";s:6:\"Brazil\";s:2:\"bg\";s:8:\"Bulgaria\";s:2:\"cl\";s:5:\"Chile\";s:2:\"cn\";s:5:\"China\";s:2:\"co\";s:22:\"Colombia (Republic of)\";s:2:\"cr\";s:10:\"Costa Rica\";s:2:\"cz\";s:14:\"Czech Republic\";s:2:\"dk\";s:7:\"Denmark\";s:2:\"ee\";s:7:\"Estonia\";s:2:\"fi\";s:7:\"Finland\";s:2:\"fr\";s:6:\"France\";s:2:\"de\";s:7:\"Germany\";s:2:\"gr\";s:6:\"Greece\";s:2:\"hk\";s:9:\"Hong Kong\";s:2:\"hu\";s:7:\"Hungary\";s:2:\"in\";s:5:\"India\";s:2:\"ir\";s:4:\"Iran\";s:2:\"il\";s:6:\"Israel\";s:2:\"it\";s:5:\"Italy\";s:2:\"jp\";s:5:\"Japan\";s:2:\"ke\";s:19:\"Kenya (Republic of)\";s:2:\"lt\";s:9:\"Lithuania\";s:2:\"mo\";s:5:\"Macao\";s:2:\"my\";s:8:\"Malaysia\";s:2:\"mx\";s:6:\"Mexico\";s:2:\"nl\";s:11:\"Netherlands\";s:2:\"nz\";s:11:\"New Zealand\";s:2:\"no\";s:6:\"Norway\";s:2:\"pk\";s:8:\"Pakistan\";s:2:\"pa\";s:6:\"Panama\";s:3:\"phl\";s:11:\"Philippines\";s:2:\"pl\";s:6:\"Poland\";s:2:\"pt\";s:8:\"Portugal\";s:2:\"ro\";s:7:\"Romania\";s:2:\"ru\";s:18:\"Russian Federation\";s:2:\"sg\";s:9:\"Singapore\";s:2:\"za\";s:12:\"South Africa\";s:2:\"es\";s:5:\"Spain\";s:2:\"se\";s:6:\"Sweden\";s:2:\"ch\";s:11:\"Switzerland\";s:2:\"tw\";s:6:\"Taiwan\";s:2:\"tz\";s:29:\"Tanzania (United Republic of)\";s:2:\"th\";s:8:\"Thailand\";s:2:\"tr\";s:6:\"Turkey\";s:2:\"ug\";s:20:\"Uganda (Republic of)\";s:2:\"uk\";s:14:\"United Kingdom\";s:2:\"us\";s:29:\"United States / North America\";s:6:\"us-old\";s:39:\"United States Circa 1950/ North America\";s:2:\"ve\";s:25:\"Venezuela / South America\";}','us',0,0,'Dialplan and Operational','',1,0),('TRANSFER_CONTEXT','from-internal-xfer','Asterisk TRANSFER_CONTEXT Variable',9,'This is the Asterisk Channel Variable TRANSFER_CONTEXT. In general it should NOT be changed unless you really know what you are doing. It is used to do create slightly different \'views\' when a call is being transfered. An example is hiding the paging groups so a call isn\'t accidentally transfered into a page.','text','','from-internal-xfer',1,1,'Dialplan and Operational','',1,-100),('TRUNK_OPTIONS','Tt','Asterisk Outbound Trunk Dial Options',0,'Options to be passed to the Asterisk Dial Command when making outbound calls on your trunks when not part of an Intra-Company Route. The options are documented in Asterisk documentation, a subset of which are described here. The default options T and t allow the calling and called users to transfer a call with ##. It is HIGHLY DISCOURAGED to use the r option here as this will prevent early media from being delivered from the PSTN and can result in the inability to interact with some external IVRs','text','','Tt',0,0,'Dialplan and Operational','',1,0),('TRUNK_RING_TIMER','300','Trunk Dial Timeout',2,'How many seconds to try a call on your trunks before giving up. This should normally be a very long time and is usually only changed if you have some sort of problematic trunks. This is the Asterisk Dial Command timeout parameter.','int','0,86400','300',1,0,'Dialplan and Operational','',0,-100),('USEDEVSTATE','0','Enable Custom Device States',0,'If this is set, it assumes that you are running Asterisk 1.4 or higher and want to take advantage of the func_devstate.c backport available from Asterisk 1.6. This allows custom hints to be created to support BLF for server side feature codes such as daynight, followme, etc','bool','','1',0,0,'Dialplan and Operational','',0,-100),('USEGOOGLEDNSFORENUM','0','Use Google DNS for Enum',2,'Setting this flag will generate the required global variable so that enumlookup.agi will use Google DNS 8.8.8.8 when performing an ENUM lookup. Not all DNS deals with NAPTR record, but Google does. There is a drawback to this as Google tracks every lookup. If you are not comfortable with this, do not enable this setting. Please read Google FAQ about this: <b>http://code.google.com/speed/public-dns/faq.html#privacy</b>.','bool','','0',0,0,'Dialplan and Operational','',0,-100),('USEQUEUESTATE','0','Asterisk Queues Patch 15168 Installed',3,'Setting this flag will generate the required dialplan to integrate with the following Asterisk patch: <b>https://issues.asterisk.org/view.php?id=15168</b>. This setting is obsolete on Asterisk 1.8+ systems where the hint state is now standard and always used. This asterisk patch is only available on Asterisk 1.4, trying to use this setting on Asterisk 1.6 will break some queue behavior and should be avoided','bool','','0',0,0,'Queues Module','queues',0,100),('USERESMWIBLF','0','Create Voicemail Hints',3,'Setting this flag with generate the required dialplan to integrate with res_mwi_blf which is included with the Official IssabelPBX Distro. It allows users to subscribe to other voicemail box and be notified via BLF of changes.','bool','','0',0,0,'Voicemail Module','voicemail',0,100),('USE_GOOGLE_CDN_JS','0','Use Google Distribution Network for js Downloads',0,'Setting this to true will fetch system javascript libraries such as jQuery and jQuery-ui from ajax.googleapis.com. This can be advantageous if accessing remote or multiple different IssabelPBX systems since the libraries are only cached once in your browser. If external internet connections are problematic, setting this true could result in slow systems. IssabelPBX will always fallback to the locally available libraries if the CDN is not available.','bool','','0',0,0,'System Setup','',0,-100),('USE_ISSABELPBX_MENU_CONF','0','Use issabelpbx_menu.conf Configuration',0,'When set to true, the system will check for a issabelpbx_menu.conf file amongst the normal configuraiton files and if found, it will be used to define and remap the menu tabs and contents. See the template supplied with IssabelPBX for details on how to do this.','bool','','0',0,0,'GUI Behavior','',0,-100),('USE_PACKAGED_JS','1','Use Packaged Javascript Library ',2,'IssabelPBX packages several javascript libraries and components into a compressed file called libissabelpbx.javascript.js. By default this will be loaded instead of the individual uncompressed libraries. Setting this to false will force IssabelPBX to load all the libraries as individual uncompressed files. This is useful during development and debugging.','bool','','1',0,0,'Developer and Customization','',0,-100),('VIEW_BAD_REFFERER','views/bad_refferer.php','View: bad_refferer.php',1,'bad_refferer.php view. This should never be changed except for very advanced layout changes.','text','','views/bad_refferer.php',1,1,'Styling and Logos','',0,270),('VIEW_BETA_NOTICE','views/beta_notice.php','View: beta_notice.php',1,'beta_notice.php view. This should never be changed except for very advanced layout changes','text','','views/beta_notice.php',1,1,'Styling and Logos','',0,312),('VIEW_FOOTER','views/footer.php','View: issabelpbx.php',1,'footer.php view. This should never be changed except for very advanced layout changes','text','','views/footer.php',1,1,'Styling and Logos','',0,350),('VIEW_FOOTER_CONTENT','views/footer_content.php','View: footer_content.php',1,'footer_content.php view. This should never be changed except for very advanced layout changes','text','','views/footer_content.php',1,1,'Styling and Logos','',0,360),('VIEW_HEADER','views/header.php','View: header.php',1,'header.php view. This should never be changed except for very advanced layout changes','text','','views/header.php',1,1,'Styling and Logos','',0,340),('VIEW_ISSABELPBX','views/issabelpbx.php','View: issabelpbx.php',1,'issabelpbx.php view. This should never be changed except for very advanced layout changes.','text','','views/issabelpbx.php',1,1,'Styling and Logos','',0,190),('VIEW_ISSABELPBX_ADMIN','views/issabelpbx_admin.php','View: issabelpbx_admin.php',1,'issabelpbx_admin.php view. This should never be changed except for very advanced layout changes.','text','','views/issabelpbx_admin.php',1,1,'Styling and Logos','',0,180),('VIEW_ISSABELPBX_RELOAD','views/issabelpbx_reload.php','View: issabelpbx_reload.php',1,'issabelpbx_reload.php view. This should never be changed except for very advanced layout changes.','text','','views/issabelpbx_reload.php',1,1,'Styling and Logos','',0,200),('VIEW_ISSABELPBX_RELOADBAR','views/issabelpbx_reloadbar.php','View: issabelpbx_reloadbar.php',1,'issabelpbx_reloadbar.php view. This should never be changed except for very advanced layout changes.','text','','views/issabelpbx_reloadbar.php',1,1,'Styling and Logos','',0,210),('VIEW_LOGGEDOUT','views/loggedout.php','View: loggedout.php',1,'loggedout.php view. This should never be changed except for very advanced layout changes.','text','','views/loggedout.php',1,1,'Styling and Logos','',0,280),('VIEW_LOGIN','views/login.php','View: login.php',1,'login.php view. This should never be changed except for very advanced layout changes','text','','views/login.php',1,1,'Styling and Logos','',0,330),('VIEW_MENU','views/menu.php','View: menu.php',1,'menu.php view. This should never be changed except for very advanced layout changes','text','','views/menu.php',1,1,'Styling and Logos','',0,310),('VIEW_MENUITEM_DISABLED','views/menuitem_disabled.php','View: menuitem_disabled.php',1,'menuitem_disabled.php view. This should never be changed except for very advanced layout changes.','text','','views/menuitem_disabled.php',1,1,'Styling and Logos','',0,240),('VIEW_NOACCESS','views/noaccess.php','View: noaccess.php',1,'noaccess.php view. This should never be changed except for very advanced layout changes.','text','','views/noaccess.php',1,1,'Styling and Logos','',0,250),('VIEW_OBE','views/obe.php','View: obe.php',1,'obe.php view. This should never be changed except for very advanced layout changes','text','','views/obe.php',1,1,'Styling and Logos','',0,310),('VIEW_PANEL','views/panel.php','View: panel.php',1,'panel.php view. This should never be changed except for very advanced layout changes.','text','','views/panel.php',1,1,'Styling and Logos','',0,290),('VIEW_POPOVER_JS','views/popover_js.php','View: popover_js.php',1,'popover_js.php view. This should never be changed except for very advanced layout changes','text','','views/popover_js.php',1,1,'Styling and Logos','',0,355),('VIEW_REPORTS','views/reports.php','View: reports.php',1,'reports.php view. This should never be changed except for very advanced layout changes.','text','','views/reports.php',1,1,'Styling and Logos','',0,300),('VIEW_UNAUTHORIZED','views/unauthorized.php','View: unauthorized.php',1,'unauthorized.php view. This should never be changed except for very advanced layout changes.','text','','views/unauthorized.php',1,1,'Styling and Logos','',0,260),('VIEW_WELCOME','views/welcome.php','View: welcome.php',1,'welcome.php view. This should never be changed except for very advanced layout changes.','text','','views/welcome.php',1,1,'Styling and Logos','',0,220),('VIEW_WELCOME_NONMANAGER','views/welcome_nomanager.php','View: welcome_nomanager.php',1,'welcome_nomanager.php view. This should never be changed except for very advanced layout changes.','text','','views/welcome_nomanager.php',1,1,'Styling and Logos','',0,230),('VMX_CONTEXT','from-internal','VMX Default Context',9,'Used to do extremely advanced and customized changes to the macro-vm VmX locater. Check the dialplan for a thorough understanding of how to use this.','text','','from-internal',1,0,'VmX Locater','',0,0),('VMX_LOOPDEST_CONTEXT','','VMX Default Loop Exceed Context',9,'Used to do extremely advanced and customized changes to the macro-vm VmX locater. Check the dialplan for a thorough understanding of how to use this. The default location that a caller will be sent if they press an invalid options too many times, as defined by the Maximum Loops count.','text','','',1,0,'VmX Locater','',1,0),('VMX_LOOPDEST_EXT','dovm','VMX Default Loop Exceed Extension',9,'Used to do extremely advanced and customized changes to the macro-vm VmX locater. Check the dialplan for a thorough understanding of how to use this. The default location that a caller will be sent if they press an invalid options too many times, as defined by the Maximum Loops count.','text','','dovm',1,0,'VmX Locater','',0,0),('VMX_LOOPDEST_PRI','1','VMX Default Loop Exceed Priority',9,'Used to do extremely advanced and customized changes to the macro-vm VmX locater. Check the dialplan for a thorough understanding of how to use this. The default location that a caller will be sent if they press an invalid options too many times, as defined by the Maximum Loops count.','int','1,1000','1',1,0,'VmX Locater','',0,0),('VMX_PRI','1','VMX Default Priority',9,'Used to do extremely advanced and customized changes to the macro-vm VmX locater. Check the dialplan for a thorough understanding of how to use this.','int','1,1000','1',1,0,'VmX Locater','',0,0),('VMX_TIMEDEST_CONTEXT','','VMX Default Timeout Context',9,'Used to do extremely advanced and customized changes to the macro-vm VmX locater. Check the dialplan for a thorough understanding of how to use this. The default location that a caller will be sent if they don\'t press any key (timeout) or press # which is interpreted as a timeout. Set this to \'dovm\' to go to voicemail (default).','text','','',1,0,'VmX Locater','',1,0),('VMX_TIMEDEST_EXT','dovm','VMX Default Timeout Extension',9,'Used to do extremely advanced and customized changes to the macro-vm VmX locater. Check the dialplan for a thorough understanding of how to use this. The default location that a caller will be sent if they don\'t press any key (timeout) or press # which is interpreted as a timeout. Set this to \'dovm\' to go to voicemail (default).','text','','dovm',1,0,'VmX Locater','',0,0),('VMX_TIMEDEST_PRI','1','VMX Default Timeout Priority',9,'Used to do extremely advanced and customized changes to the macro-vm VmX locater. Check the dialplan for a thorough understanding of how to use this. The default location that a caller will be sent if they don\'t press any key (timeout) or press # which is interpreted as a timeout. Set this to \'dovm\' to go to voicemail (default).','int','1,1000','1',1,0,'VmX Locater','',0,0),('VM_SHOW_IMAP','0','Provide IMAP Voicemail Fields',3,'Installations that have configured Voicemail with IMAP should set this to true so that the IMAP username and password fields are provided in the Voicemail setup screen for extensions. If an extension alread has these fields populated, they will be displayed even if this is set to false.','bool','','0',0,0,'Voicemail Module','voicemail',0,100),('WHICH_rm','/bin/rm','Path for rm',2,'The path to rm as auto-determined by the system. Overwrite as necessary.','text','','/bin/rm',1,0,'System Apps','',1,0),('XTNCONFLICTABORT','0','Abort Config Gen on Exten Conflict',3,'Setting either of these to true will result in retrieve_conf aborting during a reload if an extension conflict is detected or a destination is detected. It is usually better to allow the reload to go through and then correct the problem but these can be set if a more strict behavior is desired.','bool','','0',0,0,'GUI Behavior','',0,-100),('ZAP2DAHDICOMPAT','1','Convert ZAP Settings to DAHDi',0,'If set to true, IssabelPBX will check if you have chan_dahdi installed. If so, it will automatically use all your ZAP configuration settings (devices and trunks) and silently convert them, under the covers, to DAHDi so no changes are needed. The GUI will continue to refer to these as ZAP but it will use the proper DAHDi channels. This will also keep Zap Channel DIDs working.','bool','','0',1,0,'Dialplan and Operational','',0,-100),('WHICH_tail','/usr/bin/tail','Path for tail',2,'The path to tail as auto-determined by the system. Overwrite as necessary.','text','','/usr/bin/tail',1,0,'System Apps','',1,0);
/*!40000 ALTER TABLE `issabelpbx_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `ivr_details`
--

LOCK TABLES `ivr_details` WRITE;
/*!40000 ALTER TABLE `ivr_details` DISABLE KEYS */;
INSERT INTO `ivr_details` (`id`, `name`, `description`, `announcement`, `directdial`, `invalid_loops`, `invalid_retry_recording`, `invalid_destination`, `invalid_recording`, `retvm`, `timeout_time`, `timeout_recording`, `timeout_retry_recording`, `timeout_destination`, `timeout_loops`, `timeout_append_announce`, `invalid_append_announce`, `timeout_ivr_ret`, `invalid_ivr_ret`) VALUES (12,'1-BKP-20170920-3335605355','1-BKP-20170920-3335605355','19','','0','default','ivr-12,s,1','','',3,'23','','ext-group,609,1','0',0,0,0,0),(10,'1-FIS-20180604-8147370215','1-FIS-20180604-8147370215','221','','0','default','ivr-10,s,1','','',3,'','','app-announcement-228,s,1','0',0,0,0,0),(11,'1-BKP-20180905-RESERVACION-5589958540','1-BKP-20180905-RESERVACION-5589958540','232','','0','default','ext-queues,15589958540,1','','',1,'','','ext-queues,15589958540,1','0',0,0,0,0),(16,'493-OXI-20170926-8147370216','493-OXI-20170926-8147370216','24','','0','default','ext-group,610,1','','',3,'','','ext-group,610,1','0',0,0,0,0),(139,'543-DIS-20171124-8177700385','543-DIS-20171124-8177700385','146','','0','default','ext-queues,18177700385,1','','',1,'','','ext-queues,18177700385,1','0',0,0,0,0),(73,'1-BKV-20191112-8147370224','1-BKV-20191112-8147370224','','','0','default','ext-queues,18147370224,1','','',1,'','','ext-queues,18147370224,1','0',0,0,0,0),(74,'556-BRO-20171017-8147370226','556-BRO-20171017-8147370226','80','','0','default','ext-queues,18147370226,1','','',1,'','','ext-queues,18147370226,1','0',0,0,0,0),(75,'561-COM-20171017-8147370227','561-COM-20171017-8147370227','81','','0','default','ext-queues,18147370227,1','','',1,'','','ext-queues,18147370227,1','0',0,0,0,0),(20,'563-SUO-20170927-8147370229','563-SUO-20170927-8147370229','31','','0','default','ext-group,615,1','','',3,'','','ext-group,615,1','0',0,0,0,0),(22,'531-SER-20170927-8147370230','531-SER-20170927-8147370230','32','','0','default','ext-group,616,1','','',3,'','','ext-group,616,1','0',0,0,0,0),(24,'566-BER-20170927-8147370234','566-BER-20170927-8147370234','34','','0','default','ext-group,618,1','','',3,'','','ext-group,618,1','0',0,0,0,0),(25,'580-DQE-20170927-8147370237','580-DQE-20170927-8147370237','35','','0','default','ext-group,619,1','','',3,'','','ext-group,619,1','0',0,0,0,0),(26,'581-AMM-20170927-8147370238','581-AMM-20170927-8147370238','36','','0','default','ext-group,620,1','','',3,'','','ext-group,620,1','0',0,0,0,0),(53,'582-JOY-20171013-8147370239','582-JOY-20171013-8147370239','60','','0','default','ext-queues,18147370239,1','','',1,'','','ext-queues,18147370239,1','0',0,0,0,0),(65,'585-DIS-20171016-8147370242','585-DIS-20171016-8147370242','72','','0','default','ext-queues,18147370242,1','','',1,'','','ext-queues,18147370242,1','0',0,0,0,0),(108,'677-ESP-20171016-9847770191','677-ESP-20171016-9847770191','384','','0','default','ext-queues,19847770191,1','','',1,'','','ext-queues,19847770191,1','0',0,0,0,0),(64,'584-REF-20171016-8147370241','584-REF-20171016-8147370241','71','','0','default','ext-queues,18147370241,1','','',1,'','','ext-queues,18147370241,1','0',0,0,0,0),(62,'583-GEN-2O171016-8147370240','583-GEN-2O171016-8147370240','69','','0','default','ext-queues,18147370240,1','','',1,'','','ext-queues,18147370240,1','0',0,0,0,0),(61,'594-PRO-20171016-8177700106','594-PRO-20171016-8177700106','68','','0','default','ext-queues,18177700106,1','','',1,'','','ext-queues,18177700106,1','0',0,0,0,0),(60,'530-CIN-20171016-8147370247','530-CIN-20171016-8147370247','67','','0','default','ext-queues,18147370247,1','','',1,'','','ext-queues,18147370247,1','0',0,0,0,0),(35,'564-PRO-20170927-5589958533','564-PRO-20170927-5589958533','45','','0','default','ext-group,629,1','','',3,'','','ext-group,629,1','0',0,0,0,0),(59,'1333-EST-20210308-8177700105','1333-EST-20210308-8177700105','421','','0','default','ext-queues,18177700105,1','','',1,'','','ext-queues,18177700105,1','0',0,0,0,0),(58,'1403-EVE-20210804-8177700104','1403-EVE-20210804-8177700104','440','','0','default','ext-queues,18177700104,1','','',1,'','','ext-queues,18177700104,1','0',0,0,0,0),(57,'1398-SER-20210804-8177700103','1398-SER-20210804-8177700103','439','','0','default','ext-queues,18177700103,1','','',1,'','','ext-queues,18177700103,1','0',0,0,0,0),(84,'1327-QUA-20210308-8177700101','1327-QUA-20210308-8177700101','425','','0','default','ext-queues,18177700101,1','','',1,'','','ext-queues,18177700101,1','0',0,0,0,0),(56,'1376-UTI-20210804-8177700102','1376-UTI-20210804-8177700102','438','','0','default','ext-queues,18177700102,1','','',1,'','','ext-queues,18177700102,1','0',0,0,0,0),(156,'670-RHS-20180201-8177700387','670-RHS-20180201-8177700387','184','','0','default','ext-queues,18177700387,1','','',1,'','','ext-queues,18177700387,1','0',0,0,0,0),(44,'1-BKP-20170928-8177700100','1-BKP-20170928-8177700100','19','','0','default','ivr-44,s,1','','',3,'23','','ext-queues,18177700100,1','0',0,0,0,0),(45,'1-BKP-20170928-5588804680','1-BKP-20170928-5588804680','19','','0','default','ivr-45,s,1','','',3,'23','','ext-group,641,1','0',0,0,0,0),(46,'1-FIS-20180724-3388800130','1-FIS-20180724-3388800130','221','','3','','ext-queues,13388800130,1','','',1,'','','ext-queues,13388800130,1','0',0,0,0,0),(47,'1-BKP-20170928-2228800360','1-BKP-20170928-2228800360','19','','0','default','ivr-47,s,1','','',3,'23','','ext-group,647,1','0',0,0,0,0),(250,'927-KAI-20190225-8177701575','927-KAI-20190225-8177701575','389','','0','default','ext-queues,18177701575,1','','',1,'','309','ext-queues,18177701575,1','0',0,0,0,0),(294,'1046-ERP-20191009-2297770470','1046-ERP-20191009-2297770470','197','','0','default','app-blackhole,hangup,1','','',3,'','','app-blackhole,hangup,1','0',0,0,0,0),(52,'1-BKP-20171004-8177700108','1-BKP-20171004-8177700108','405','','0','default','ext-queues,18177700108,1','','',1,'','','ext-queues,18177700108,1','0',0,0,0,0),(137,'1196-GRU-20200306-8177700384','1196-GRU-20200306-8177700384','385','','0','default','ext-queues,18177700384,1','','',1,'','','ext-queues,18177700384,1','0',0,0,0,0),(69,'588-ECO-20171016-8147370246','588-ECO-20171016-8147370246','76','','0','default','ext-queues,18147370246,1','','',1,'','','ext-queues,18147370246,1','0',0,0,0,0),(140,'634-LAM-20171124-9847770193','634-LAM-20171124-9847770193','157','','0','default','ext-queues,19847770193,1','','',1,'','','ext-queues,19847770193,1','0',0,0,0,0),(76,'328-VER-20190315-8147370229','328-VER-20190315-8147370229','','','0','default','ext-queues,18147370229,1','','',1,'','','ext-queues,18147370229,1','0',0,0,0,0),(190,'1-BKP-20180628-208177700100','1-BKP-20180628-208177700100','368','','0','default','ext-queues,208177700100,1','default','',1,'','default','ext-queues,208177700100,1','0',0,0,0,0),(168,'689-ELE-20180309-8147370233','689-ELE-20180309-8147370233','201','','0','default','ext-queues,18147370233,1','','',1,'','','ext-queues,18147370233,1','0',0,0,0,0),(78,'851-SEG-20181107-8147370234','851-SEG-20181107-8147370234','268','','0','default','ext-queues,18147370234,1','','',1,'','','ext-queues,18147370234,1','0',0,0,0,0),(79,'1034-ULT-20190729-8177700113','1034-ULT-20190729-8177700113','343','','0','default','ext-queues,18177700113,1','','',1,'','','ext-queues,18177700113,1','0',0,0,0,0),(80,'1293-ARI-20210104-8177700114','1293-ARI-20210104-8177700114','412','','0','default','ext-queues,18177700114,1','','',1,'','','ext-queues,18177700114,1','0',0,0,0,0),(81,'1139-BIZ-20200117-8177700115','1139-BIZ-20200117-8177700115','379','','0','default','ext-queues,18177700115,1','','',1,'','','ext-queues,18177700115,1','0',0,0,0,0),(82,'969-AUT-20210316-8177700112','969-AUT-20210316-8177700112','423','','0','default','ext-queues,18177700112,1','','',1,'','','ext-queues,18177700112,1','0',0,0,0,0),(83,'531-SER-20171019-8147370230','531-SER-20171019-8147370230','90','','0','default','ext-queues,18147370230,1','','',1,'','','ext-queues,18147370230,1','0',0,0,0,0),(85,'549-COM-20171019-5589958531','549-COM-20171019-5589958531','92','','0','default','ext-queues,15589958531,1','','',1,'','','ext-queues,15589958531,1','3',0,0,0,0),(86,'920-DIH-20200117-5589958532','920-DIH-20200117-5589958532','377','','0','default','ext-queues,15589958532,1','','',1,'','','ext-queues,15589958532,1','0',0,0,0,0),(87,'564-PRO-20171020-5589958533','564-PRO-20171020-5589958533','94','','0','default','ext-queues,15589958533,1','45','',1,'','','ext-queues,15589958533,1','0',0,0,0,0),(88,'580-EJT-20171020-8147370237','580-EJT-20171020-8147370237','95','','0','default','ext-queues,18147370237,1','','',1,'','','ext-queues,18147370237,1','0',0,0,0,0),(89,'581-ENG-20171020-8147370238','581-ENG-20171020-8147370238','96','','0','default','ext-queues,18147370238,1','','',1,'','','ext-queues,18147370238,1','0',0,0,0,0),(90,'576-QUA-20171020-8147370231','576-QUA-20171020-8147370231','97','','0','default','ext-queues,18147370231,1','','',1,'','','ext-queues,18147370231,1','0',0,0,0,0),(91,'578-KBD-20171020-8147370232','578-KBD-20171020-8147370232','98','','0','default','ext-queues,18147370232,1','','',1,'','','ext-queues,18147370232,1','0',0,0,0,0),(92,'536-COM-20171020-8147370217','536-COM-20171020-8147370217','99','','0','default','ext-queues,18147370217,1','','',1,'','','ext-queues,18147370217,1','0',0,0,0,0),(93,'554-COM-20171020-8147370218','554-COM-20171020-8147370218','100','','0','default','ext-queues,18147370218,1','','',1,'','','ext-queues,18147370218,1','0',0,0,0,0),(94,'109-HCR-20171026-8147370216','109-HCR-20171026-8147370216','101','','0','default','ext-queues,18147370216,1','','',1,'','','ext-queues,18147370216,1','0',0,0,0,0),(95,'1421-FIV-20211015-8177700108','1421-FIV-20211015-8177700108','448','','0','default','ext-queues,18177700108,1','','',1,'','','ext-queues,18177700108,1','0',0,0,0,0),(289,'1077-HER-20190902-8147773893','1077-HER-20190902-8147773893','197','','0','default','app-blackhole,hangup,1','','',3,'','','app-blackhole,hangup,1','0',0,0,0,0),(96,'126-CON-20171026-8177700109','126-CON-20171026-8177700109','103','','0','default','ext-queues,18177700109,1','','',1,'','','ext-queues,18177700109,1','0',0,0,0,0),(97,'1289-AHE-20210316-8177700110','1289-AHE-20210316-8177700110','424','','0','default','ext-queues,18177700110,1','','',1,'','','ext-queues,18177700110,1','0',0,0,0,0),(98,'1388-SPO-20210713-8177700111','1388-SPO-20210713-8177700111','436','','0','default','ext-queues,18177700111,1','','',1,'','','ext-queues,18177700111,1','0',0,0,0,0),(99,'1243-IRE-20201002-8177700116','1243-IRE-20201002-8177700116','406','','0','default','ext-queues,18177700116,1','','',1,'','','ext-queues,18177700116,1','0',0,0,0,0),(100,'532-TSG-20201126-8177700117','532-TSG-20201126-8177700117','411','','0','default','ext-queues,18177700117,1','','',1,'','','ext-queues,18177700117,1','0',0,0,0,0),(101,'757-ALE-20210901-8177700118','757-ALE-20210901-8177700118','','','0','default','ext-queues,18177700118,1','','',1,'','','ext-queues,18177700118,1','0',0,0,0,0),(102,'1334-LEA-20210322-8177700119','1334-LEA-20210322-8177700119','422','','0','default','ext-queues,18177700119,1','','',1,'','','ext-queues,18177700119,1','0',0,0,0,0),(103,'1351-SOL-20210305-8177700120','1351-SOL-20210305-8177700120','434','','0','default','ext-queues,18177700120,1','','',1,'','','ext-queues,18177700120,1','0',0,0,0,0),(104,'476-HER-20171027-8177700121','476-HER-20171027-8177700121','111','','0','default','ext-queues,18177700121,1','','',1,'','','ext-queues,18177700121,1','0',0,0,0,0),(105,'495-COM-20171027-8177700122','495-COM-20171027-8177700122','112','','0','default','ext-queues,18177700122,1','','',1,'','','ext-queues,18177700122,1','0',0,0,0,0),(106,'496-SER-20171027-8177700123','496-SER-20171027-8177700123','113','','0','default','ext-queues,18177700123,1','','',1,'','','ext-queues,18177700123,1','0',0,0,0,0),(109,'1450-ARQ-20211021-9847770192','1450-ARQ-20211021-9847770192','454','','0','default','ext-queues,19847770192,1','','',1,'','','ext-queues,19847770192,1','0',0,0,0,0),(110,'1425-CLE-20211004-8177700124','1425-CLE-20211004-8177700124','446','','0','default','ext-queues,18177700124,1','','',1,'','','ext-queues,18177700124,1','0',0,0,0,0),(111,'601-LAC-20171031-8147370235','601-LAC-20171031-8147370235','116','','0','default','ext-queues,18147370235,1','','',1,'','','ext-queues,18147370235,1','0',0,0,0,0),(112,'1166-EXP-20200122-2226443774','1166-EXP-20200122-2226443774','380','','0','default','ext-queues,12226443774,1','','',1,'','','ext-queues,12226443774,1','0',0,0,0,0),(113,'809-CON-20180828-8177700360','809-CON-20180828-8177700360','236','','0','default','ext-queues,18177700360,1','','',1,'','','ext-queues,18177700360,1','0',0,0,0,0),(114,'1430-ARR-20211004-8177700361','1430-ARR-20211004-8177700361','447','','0','default','ext-queues,18177700361,1','','',1,'','','ext-queues,18177700361,1','0',0,0,0,0),(115,'61-GOY-20171102-8177700362','61-GOY-20171102-8177700362','120','','0','default','ext-queues,18177700362,1','','',1,'','','ext-queues,18177700362,1','0',0,0,0,0),(116,'754-INM-20200429-8177700363','754-INM-20200429-8177700363','397','','0','default','ext-queues,18177700363,1','','',1,'','','ext-queues,18177700363,1','0',0,0,0,0),(117,'419-AVE-20171103-8177700376','419-AVE-20171103-8177700376','122','','0','default','ext-queues,18177700376,1','','',1,'','','ext-queues,18177700376,1','0',0,0,0,0),(118,'1236-HIP-20200703-8177700365','1236-HIP-20200703-8177700365','404','','0','default','ext-queues,18177700365,1','','',1,'','','ext-queues,18177700365,1','0',0,0,0,0),(119,'1446-HID-20211029-8177700366','1446-HID-20211029-8177700366','452','','0','default','ext-queues,18177700366,1','default','',1,'','','ext-queues,18177700366,1','0',0,0,0,0),(120,'130-CON-20210615-8177700367','130-CON-20210615-8177700367','432','','0','default','ext-queues,18177700367,1','','',1,'','','ext-queues,18177700367,1','0',0,0,0,0),(121,'1234-FHA-20200703-8177700368','1234-FHA-20200703-8177700368','403','','0','default','ext-queues,18177700368,1','','',1,'','','ext-queues,18177700368,1','0',0,0,0,0),(122,'498-TIM-20171103-8177700369','498-TIM-20171103-8177700369','127','','0','default','ext-queues,18177700369,1','','',1,'','','ext-queues,18177700369,1','0',0,0,0,0),(123,'516-COM-20171103-8177700371','516-COM-20171103-8177700371','128','','0','default','ext-queues,18177700371,1','','',1,'','','ext-queues,18177700371,1','0',0,0,0,0),(124,'1451-TER-20211029-8177700372','1451-TER-20211029-8177700372','455','','0','default','ext-queues,18177700372,1','','',1,'','','ext-queues,18177700372,1','0',0,0,0,0),(125,'1449-DIN-20211029-8177700373','1449-DIN-20211029-8177700373','453','','0','default','ext-queues,18177700373,1','','',1,'','','ext-queues,18177700373,1','0',0,0,0,0),(126,'1178-REA-20200210-8177700374','1178-REA-20200210-8177700374','383','','0','default','ext-queues,18177700374,1','','',1,'','','ext-queues,18177700374,1','0',0,0,0,0),(127,'1273-SIJ-20201021-8177700375','1273-SIJ-20201021-8177700375','408','','0','default','ext-queues,18177700375,1','','',1,'','','ext-queues,18177700375,1','0',0,0,0,0),(128,'508-DLT-20171103-8177700370','508-DLT-20171103-8177700370','142','','0','default','ext-queues,18177700370,1','','',1,'','','ext-queues,18177700370,1','0',0,0,0,0),(146,'1-BKP-20180122-28177700100','1-BKP-20180122-28177700100','177','','0','default','ext-queues,28177700100,1','','',1,'','','ext-queues,28177700100,1','0',0,0,0,0),(130,'565-SAV-20171107-8177700364','565-SAV-20171107-8177700364','135','','0','default','ext-queues,18177700364,1','','',1,'','','ext-queues,18177700364,1','0',0,0,0,0),(131,'513-NOV-20190205-8177700378','513-NOV-20190205-8177700378','136','','0','default','ext-queues,18177700378,1','','',1,'','','ext-queues,18177700378,1','0',0,0,0,0),(227,'1-VIS-20181221-8177701563','1-VIS-20181221-8177701563','399','','0','default','ext-group,682,1','','',1,'','','ext-group,682,1','0',0,0,0,0),(143,'1-BKP-20200507-8177700388','1-BKP-20200507-8177700388','398','','0','default','ext-queues,18177700388,1','','',3,'','','ext-queues,18177700388,1','0',0,0,0,0),(133,'539-DIST-20171108-8177700380','539-DIST-20171108-8177700380','138','','0','default','ext-queues,18177700380,1','','',1,'','','ext-queues,18177700380,1','0',0,0,0,0),(134,'833-INT-20181008-8177700381','833-INT-20181008-8177700381','251','','0','default','ext-queues,18177700380,1','','',1,'','','ext-queues,18177700381,1','0',0,0,0,0),(135,'1256-INS-20201121-8177700382','1256-INS-20201121-8177700382','409','','0','default','ext-queues,18177700382,1','','',1,'','','ext-queues,18177700382,1','0',0,0,0,0),(136,'187-HCP-20171108-8177700383','187-HCP-20171108-8177700383','141','','0','default','ext-queues,18177700383,1','','',1,'','','ext-queues,18177700383,1','0',0,0,0,0),(141,'1-BKP-20171127-8177700100','1-BKP-20171127-8177700100-PROSPECTO','155','','0','default','ivr-141,s,1','','',3,'','','app-announcement-165,s,1','0',0,0,0,0),(142,'637-CON-20171130-8177700386','637-CON-20171130-8177700386','156','','0','default','ext-queues,18177700386,1','','',1,'','','ext-queues,18177700386,1','0',0,0,0,0),(144,'657-ACI-20180109-8177700380 ','657-ACI-20180109-8177700380 ','166','','0','default','ext-queues,18177700380,1','','',1,'','','ext-queues,18177700380,1','0',0,0,0,0),(145,'658-SEG-20180109-8147370221','658-SEG-20180109-8147370221','206','','0','default','ext-queues,18147370221,1','','',1,'','','ext-queues,18147370221,1','0',0,0,0,0),(147,'1-BKP-20180123-38177700100','1-BKP-20180123-38177700100','178','','0','default','ext-queues,38177700100,1','','',1,'','','ext-queues,38177700100,1','0',0,0,0,0),(148,'1-BKP-20180123-48177700100','1-BKP-20180123-48177700100','176','','0','default','ext-queues,48177700100,1','','',1,'','','ext-queues,48177700100,1','0',0,0,0,0),(149,'1-BKP-20180123-108177700100','1-BKP-20180123-108177700100','','','0','default','app-announcement-162,s,1','','',1,'','','app-announcement-162,s,1','0',0,0,0,0),(150,'1-BKP-20180123-8177700100','1-BKP-20180123-8177700100','180','','0','default','app-announcement-179,s,1','','',3,'','','app-announcement-179,s,1','0',0,0,0,0),(151,'1-BKP-20180124-108177700100','1-BKP-20180124-108177700100','181','','0','default','app-announcement-185,s,1','','',3,'','','app-announcement-185,s,1','0',0,0,0,0),(152,'1-BKP-20180124-105588804680','1-BKP-20180124-105588804680','','','0','default','app-announcement-162,s,1','','',1,'','','app-announcement-162,s,1','0',0,0,0,0),(153,'1-BKP-20180124-5588804680','1-BKP-20180124-5588804680','180','','0','default','app-announcement-185,s,1','','',3,'','','app-announcement-185,s,1','0',0,0,0,0),(154,'1-BKP-20180124-103335605355','1-BKP-20180124-103335605355','','','0','default','app-announcement-162,s,1','','',1,'','','app-announcement-162,s,1','0',0,0,0,0),(155,'1-BKP-20180124-3335605355','1-BKP-20180124-3335605355','180','','0','default','app-announcement-191,s,1','','',3,'','','app-announcement-191,s,1','0',0,0,0,0),(157,'665-CAM-20180201-8177700389','665-CAM-20180201-8177700389','185','','0','default','ext-queues,18177700389,1','','',1,'','','ext-queues,18177700389,1','0',0,0,0,0),(158,'830-COR-20181004-8177700671','830-COR-20181004-8177700671','249','','0','default','ext-queues,18177700671,1','','',1,'','','ext-queues,18177700671,1','0',0,0,0,0),(165,'696-JIR-20180308-8177700676','696-JIR-20180308-8177700676','198','','0','default','ext-queues,18177700676,1','','',1,'','','ext-queues,18177700676,1','0',0,0,0,0),(160,'914-LEG-20190130-8177700673','914-LEG-20190130-8177700673','295','','0','default','ext-queues,18177700673,1','','',3,'','','ext-queues,18177700673,1','0',0,0,0,0),(161,'491-MAX-20190131-8177700674','491-MAX-20190131-8177700674','297','','0','default','ext-queues,18177700674,1','','',1,'','','ext-queues,18177700674,1','0',0,0,0,0),(240,'906-REG-20190131-8177701570','906-REG-20190131-8177701570','298','','0','default','ext-queues,18177701570,1','','',1,'','','ext-queues,18177701570,1','0',0,0,0,0),(162,'831-COM-20181004-8177700672','831-COM-20181004-8177700672','250','','0','','ext-queues,18177700672,1','','',1,'','','ext-queues,18177700672,1','0',0,0,0,0),(163,'0-AGE-20180208-8177700670','0-AGE-20180208-8177700670','191','','0','default','app-announcement-202,s,1','','',3,'','','app-announcement-202,s,1','0',0,0,0,0),(164,'676-PRO-20180208-8177700675','676-PRO-20180208-8177700675','196','','0','default','ext-queues,18177700675,1','','',1,'','','ext-queues,18177700675,1','0',0,0,0,0),(166,'743-SER-20180604-8177700377','743-SER-20180604-8177700377','','','0','default','ext-queues,18177700377,1','','',1,'','','ext-queues,18177700377,1','0',0,0,0,0),(167,'994-FOR-20191231-8177700107','994-FOR-20191231-8177700107','376','','0','default','ext-queues,18177700107,1','default','',1,'','','ext-queues,18177700107,1','0',0,0,0,0),(192,'766-DES-20180712-8147370240','766-DES-20180712-8147370240','227','','0','default','ext-queues,18147370240,1','default','',1,'','','ext-queues,18147370240,1','0',0,0,0,0),(170,'699ESP-20180322-8177700677','699-ESP-20180322-8177700677','203','','0','default','ext-queues,18177700677,1','','',1,'','','ext-queues,18177700677,1','0',0,0,0,0),(171,'700-CON-20180322-8177700678','700-CON-20180322-8177700678','204','','0','default','ext-queues,18177700678,1','','',1,'','','ext-queues,18177700678,1','0',0,0,0,0),(172,'701-REC-20180322-8177700679','701-REC-20180322-8177700679','207','','0','default','ext-queues,18177700679,1','','',1,'','','ext-queues,18177700679,1','0',0,0,0,0),(173,'702-SER-20180322-8177700680','702-SER-20180322-8177700680','208','','0','default','ext-queues,18177700680,1','','',1,'','','ext-queues,18177700680,1','0',0,0,0,0),(174,'703-ACT-20180322-8177700681','703-ACT-20180322-8177700681','205','','0','default','ext-queues,18177700681,1','','',1,'','','ext-queues,18177700681,1','0',0,0,0,0),(175,'705-FDS-20180326-8177700682','705-FDS-20180326-8177700682','209','','0','default','ext-queues,18177700682,1','','',1,'','','ext-queues,18177700682,1','0',0,0,0,0),(313,'1-BKP-20200507-8177700388-QUIERO-ME-LLAMEN','1-BKP-20200507-8177700388-QUIERO-ME-LLAMEN','398','','0','default','ext-group,718,1','','',1,'','','ext-group,718,1','0',0,0,0,0),(177,'1068-JJS-20190815-8177700684','1068-JJS-20190815-8177700684','346','','0','default','ext-queues,18177700684,1','','',1,'','','ext-queues,18177700684,1','0',0,0,0,0),(178,'710-CRE-20180410-8177700685','710-CRE-20180410-8177700685','211','','0','default','ext-queues,18177700685,1','','',1,'','','ext-queues,18177700685,1','0',0,0,0,0),(179,'839-CET-20181023-8177700686','839-CET-20181023-8177700686','254','','0','default','ext-queues,18177700686,1','','',1,'','','ext-queues,18177700686,1','0',0,0,0,0),(180,'714-GII-20180419-8177700687','714-GII-20180419-8177700687','213','','0','default','ext-queues,18177700687,1','','',1,'','','ext-queues,18177700687,1','0',0,0,0,0),(181,'278-OLM-20200212-8177700688','278-OLM-20200212-8177700688','382','','0','default','ext-queues,18177700688,1','','',1,'','','ext-queues,18177700688,1','0',0,0,0,0),(182,'717-GLO-20180423-8177700689','717-GLO-20180423-8177700689','215','','0','default','ext-queues,18177700689,1','','',1,'','','ext-queues,18177700689,1','0',0,0,0,0),(183,'730-MEC-20180508-8177700691','730-MEC-20180508-8177700691','216','','0','default','ext-queues,18177700691,1','','',1,'','','ext-queues,18177700691,1','0',0,0,0,0),(184,'628-PRI-20191122-8177700106','628-PRI-20191122-8177700106','367','','0','default','ext-queues,18177700106,1','','',1,'','','ext-queues,18177700106,1','0',0,0,0,0),(185,'733-COF-20180516-8177700692','733-COF-20180516-8177700692','219','','0','default','ext-queues,18177700692,1','','',1,'','','ext-queues,18177700692,1','0',0,0,0,0),(186,'3-BODACAROLINAYJOSE-20180904-8177700690','3-BODACAROLINAYJOSE-20180904-8177700690','243','','0','default','app-blackhole,hangup,1','','',1,'','','app-blackhole,hangup,1','0',0,0,0,0),(187,'750-EXP-20180613-8177700693','750-EXP-20180613-8177700693','223','','0','default','ext-queues,18177700693,1','','',1,'','','ext-queues,18177700693,1','0',0,0,0,0),(188,'751-CIN-20180613-8177700695','751-CIN-20180613-8177700695','344','','0','default','ext-queues,18177700695,1','','',1,'','','ext-queues,18177700695,1','0',0,0,0,0),(189,'752-NOX-20180613-8177700694','752-NOX-20180613-8177700694','225','','0','default','ext-queues,18177700694,1','','',1,'','','ext-queues,18177700694,1','0',0,0,0,0),(191,'768-SOP-20180706-8147370244','768-SOP-20180706-8147370244','226','','0','default','ext-queues,18147370244,1','','',1,'','','ext-queues,18147370244,1','0',0,0,0,0),(193,'770-GRU-20180717-8177700696','770-GRU-20180717-8177700696','229','','0','default','ext-queues,18177700696,1','','',1,'','','ext-queues,18177700696,1','0',0,0,0,0),(194,'779-DES-20180717-9847770194','779-DES-20180717-9847770194','228','','0','default','ext-queues,19847770194,1','','',1,'','','ext-queues,19847770194,1','0',0,0,0,0),(195,'781-SEC-20180717-8177700697','781-SEC-20180717-8177700697','230','','0','default','ext-queues,18177700697,1','','',1,'','','ext-queues,18177700697,1','0',0,0,0,0),(196,'1-FIS-20180724-5588804685','1-FIS-20180724-5588804685','221','','0','','ext-queues,15588804685,1','','',1,'','','ext-queues,15588804685,1','0',0,0,0,0),(197,'783-SOL-20180808-8177700698','783-SOL-20180808-8177700698','231','','0','default','ext-queues,18177700698,1','','',1,'','','ext-queues,18177700698,1','0',0,0,0,0),(198,'1-BKP-RESERVACION-20180827-8177701550','1-BKP-RESERVACION-20180827-8177701550','232','','0','default','ext-queues,18177701550,1','','',1,'','','ext-queues,18177701550,1','0',0,0,0,0),(207,'13-RAT-20200429-5588804682','13-RAT-20200429-5588804682','394','','0','default','ext-queues,15588804682,1','','',1,'','','ext-queues,15588804682,1','0',0,0,0,0),(200,'1-BKP-20180827-RESERVACION-3388800133','1-BKP-20180827-RESERVACION-3388800133','232','','0','default','ext-queues,13388800133,1','','',1,'','','ext-queues,13388800133,1','0',0,0,0,0),(201,'753-DES-20180827-8177701551','753-DES-20180827-8177701551','233','','0','default','ext-queues,18177701551,1','','',1,'','','ext-queues,18177701551,1','0',0,0,0,0),(246,'569-ZAF-20190218-9847770197','569-ZAF-20190218-9847770197','304','','0','default','ext-queues,19847770197,1','','',1,'','','ext-queues,19847770197,1','0',0,0,0,0),(203,'778-GRU-20180828-8147370245','778-GRU-20180828-8147370245','237','','0','default','ext-queues,18147370245,1','','',1,'','','ext-queues,18147370245,1','0',0,0,0,0),(291,'320-SAA-20210713-8147773894','320-SAA-20210713-8147773894','433','','0','default','ext-queues,18147773894,1','','',3,'','','ext-queues,18147773894,1','0',0,0,0,0),(205,'1404-KAR-20210902-5588804681','1404-KAR-20210902-5588804681','444','','0','default','ext-queues,15588804681,1','','',1,'','','ext-queues,15588804681,1','0',0,0,0,0),(206,'807-HEL-20180903-5589958535','807-HEL-20180903-5589958535','238','','0','default','ext-queues,15589958535,1','','',1,'','','ext-queues,15589958535,1','0',0,0,0,0),(209,'635-VAT-20181029-8177701552','635-VAT-20181029-8177701552','320','','0','default','ext-queues,18177701552,1','','',1,'','','ext-queues,18177701552,1','0',0,0,0,0),(210,'1046-ERP-20190724-9847770195	','1046-ERP-20190724-9847770195	','340','','0','default','ext-group,693,1','','',3,'','','ext-group,693,1','0',0,0,0,0),(211,'854-TEC-20181102-8177701553','854-TEC-20181102-8177701553','261','','0','default','ext-queues,18177701553,1','','',1,'','','ext-queues,18177701553,1','0',0,0,0,0),(212,'','','','','3','default','ext-queues,18177701553,1','default','',10,'default','default','ext-queues,18177701553,1','3',0,0,0,0),(215,'1-EVA-20190208-3388800131','1-EVA-20190208-3388800131','300','','0','default','ext-queues,13388800131,1','','',1,'','','ext-queues,13388800131,1','0',0,0,0,0),(213,'14-SOL-20200429-5588804683','14-SOL-20200429-5588804683','395','','0','default','ext-queues,15588804683,1','','',1,'','','ext-queues,15588804683,1','0',0,0,0,0),(214,'855-BUS-20181106-8177701554','855-BUS-20181106-8177701554','262','','0','default','ext-queues,18177701554,1','','',1,'','default','ext-queues,18177701554,1','0',0,0,0,0),(245,'1-EVA-20190208-3335605354','1-EVA-20190208-3335605354','300','','0','default','ext-queues,13335605354,1','','',1,'','','ext-queues,13335605354,1','0',0,0,0,0),(216,'871-SER-20181121-9847770196','871-SER-20181121-9847770196','271','','0','default','ext-queues,19847770196,1','','',1,'','','ext-queues,19847770196,1','0',0,0,0,0),(217,'863-MKT-20181121-8718800151','863-MKT-20181121-8718800151','269','','0','default','ext-queues,18718800151,1','','',1,'','','ext-queues,18718800151,1','0',0,0,0,0),(218,'868-ROM-20181121-8718800152','868-ROM-20181121-8718800152','270','','0','default','ext-queues,18718800152,1','','',1,'','','ext-queues,18718800152,1','0',0,0,0,0),(219,'213-BAM-20181203-8177700379','213-BAM-20181203-8177700379','274','','0','default','ext-queues,18177700379,1','','',1,'','','ext-queues,18177700379,1','0',0,0,0,0),(220,'874-SIT-20181128-8177701556','874-SIT-20181128-8177701556','281','','0','default','ext-queues,18177701556,1','','',1,'','','ext-queues,18177701556,1','0',0,0,0,0),(221,'875-PLA-20181128-8177701555','875-PLA-20181128-8177701555','273','','0','default','ext-queues,18177701555,1','','',1,'','','ext-queues,18177701555,1','0',0,0,0,0),(222,'878-SOL-2018123-8177701558','878-SOL-2018123-8177701558','275','','0','default','ext-queues,18177701558,1','','',1,'','','ext-queues,18177701558,1','0',0,0,0,0),(223,'880-VER-20181204-8177701557','880-VER-20181204-8177701557','276','','0','default','ext-group,688,1','','',3,'','','ext-group,688,1','0',0,0,0,0),(278,'1-FIS-20190709-5589958534','1-FIS-20190709-5589958534','221','','0','default','ext-queues,15589958534,1','','',1,'','','ext-queues,15589958534,1','0',0,0,0,0),(224,'879-SOC-20181204-8177701559','879-SOC-20181204-8177701559','277','','0','default','ext-queues,18177701559,1','','',1,'','','ext-queues,18177701559,1','0',0,0,0,0),(225,'791-FOO-20181205-8177701560','791-FOO-20181205-8177701560','435','','0','default','ext-queues,18177701560,1','','',1,'','','ext-queues,18177701560,1','0',0,0,0,0),(226,'881-MAI-20181205-8177701561','881-MAI-20181205-8177701561','279','','0','default','ext-queues,18177701561,1','','',1,'','','ext-queues,18177701561,1','0',0,0,0,0),(228,'888-LMS-20181227-8177701562','888-LMS-20181227-8177701562','285','','0','default','ext-queues,18177701562,1','','',1,'','','ext-queues,18177701562,1','0',0,0,0,0),(229,'1313-SOL-20210302-8177701564','1313-SOL-20210302-8177701564','419','','0','default','ext-queues,18177701564,1','','',1,'','','ext-queues,18177701564,1','0',0,0,0,0),(230,'918-MAR-20210302-8177701565','918-MAR-20210302-8177701565','416','','0','default','ext-queues,18177701565,1','','',1,'','','ext-queues,18177701565,1','0',0,0,0,0),(231,'1-BKP-RESERVACION-20190122-5588804680','1-BKP-RESERVACION-20190122-5588804680','232','','0','default','ext-queues,15588804680,1','','',1,'','','ext-queues,15588804680,1','0',0,0,0,0),(232,'904-LVM-20190123-9988001966','904-LVM-20190123-9988001966','289','','0','default','ext-queues,19988001966,1','','',1,'','','ext-queues,19988001966,1','0',0,0,0,0),(233,'911-BMS-20190123-8177701566','911-BMS-20190123-8177701566','293','','0','default','ext-queues,18177701566,1','','',1,'','','ext-queues,18177701566,1','0',0,0,0,0),(234,'908-HER-20190123-8177701567','908-HER-20190123-8177701567','291','','0','default','ext-queues,18177701567,1','','',1,'','','ext-queues,18177701567,1','0',0,0,0,0),(235,'909-ROJ-20190123-8177701568','909-ROJ-20190123-8177701568','292','','0','default','ext-queues,18177701568,1','','',1,'','','ext-queues,18177701568,1','0',0,0,0,0),(237,'129-MUL-20190124-8177701569','129-MUL-20190124-8177701569','290','','0','default','ext-queues,18177701569,1','','',1,'','','ext-queues,18177701569,1','0',0,0,0,0),(238,'322-AAA-20190128-8718800153','322-AAA-20190128-8718800153','294','','0','default','ext-queues,18718800153,1','','',1,'','','ext-queues,18718800153,1','0',0,0,0,0),(239,'917-AVA-20190130-8718800154','917-AVA-20190130-8718800154','197','','0','default','app-blackhole,hangup,1','','',3,'','','app-blackhole,hangup,1','0',0,0,0,0),(241,'1220-FOR-20200421-8177701571','1220-FOR-20200421-8177701571','390','','0','default','ext-queues,18177701571,1','','',1,'','','ext-queues,18177701571,1','0',0,0,0,0),(242,'882-ALB-20181211-8177701572','882-ALB-20181211-8177701572','284','','0','','ext-queues,18177701572,1','','',1,'','','ext-queues,18177701572,1','0',0,0,0,0),(243,'729-COO-20190207-8177701573','729-COO-20190207-8177701573','302','','0','default','ext-queues,18177701573,1','','',1,'','','ext-queues,18177701573,1','0',0,0,0,0),(244,'729-ATT-20190207-8177701574','729-ATT-20190207-8177701574','301','','0','default','ext-queues,18177701574,1','','',1,'','','ext-queues,18177701574,1','0',0,0,0,0),(247,'BK-FB-20190307-8177700699','BK-FB-20190307-8177700699','19','','0','default','ext-queues,18177700699,1','','',1,'','','ext-queues,18177700699,1','0',0,0,0,0),(248,'925-TIT-20190222-9988001967','925-TIT-20190222-9988001967','305','','0','default','ext-queues,19988001967,1','','',1,'','','ext-queues,19988001967,1','0',0,0,0,0),(249,'925-TIT-20190222-9847770190','925-TIT-20190222-9847770190','305','','0','default','ext-queues,19847770190,1','','',1,'','','ext-queues,19847770190,1','0',0,0,0,0),(251,'PRUEBAS-20190903-8177701576','PRUEBAS-20190903-8177701576','','','0','default','ext-queues,18177701576,1','','',1,'','','ext-queues,18177701576,1','0',0,0,0,0),(252,'924-IND-20190225-8177701577','924-IND-20190225-8177701577','308','','0','default','ext-queues,18177701577,1','','',1,'','','ext-queues,18177701577,1','0',0,0,0,0),(253,'931-GEN-20190225-8177701578','931-GEN-20190225-8177701578','310','','0','default','ext-queues,18177701578,1','','',1,'','','ext-queues,18177701578,1','0',0,0,0,0),(254,'926-TRI-20190222-8177701579','926-TRI-20190222-8177701579','306','','0','default','ext-queues,18177701579,1','','',1,'','','ext-queues,18177701579,1','0',0,0,0,0),(255,'935-NEW-20190227-8147773870','935-NEW-20190227-8147773870','311','','0','default','ext-queues,18147773870,1','','',1,'','','ext-queues,18147773870,1','0',0,0,0,0),(256,'910-OFF-20190227-8147773871','910-OFF-20190227-8147773871','312','','0','default','ext-queues,18147773871,1','','',1,'','','ext-queues,18147773871,1','0',0,0,0,0),(257,'937-QUI-20190301-8177700377','937-QUI-20190301-8177700377','313','','0','default','ext-queues,18177700377,1','','',1,'','','ext-queues,18177700377,1','0',0,0,0,0),(258,'355-PER-20190315-8147773872','355-PER-20190315-8147773872','317','','0','default','ext-queues,18147773872,1','','',1,'','','ext-queues,18147773872,1','0',0,0,0,0),(259,'956-HVA-20190319-8147773873','956-HVA-20190319-8147773873','315','','0','default','ext-queues,18147773873,1','','',1,'','','ext-queues,18147773873,1','0',0,0,0,0),(260,'16-VAL-20200429-5588804684','16-VAL-20200429-5588804684','396','','0','default','ext-queues,15588804684,1','','',1,'','','ext-queues,15588804684,1','0',0,0,0,0),(261,'964-SPW-20190403-8147773874','964-SPW-20190403-8147773874','319','','0','default','ext-queues,18147773874,1','','',1,'','','ext-queues,18147773874,1','0',0,0,0,0),(262,'973-MGP-20190403-8147773875','973-MGP-20190403-8147773875','321','','0','default','ext-queues,18147773875,1','','',1,'','','ext-queues,18147773875,1','0',0,0,0,0),(263,'983-MOR-20190430-8147773877','983-MOR-20190430-8147773877','322','','0','default','ext-queues,18147773877,1','','',1,'','','ext-queues,18147773877,1','0',0,0,0,0),(264,'986-DEC-20190430-8147773876','986-DEC-20190430-8147773876','323','','0','default','ext-queues,18147773876,1','','',1,'','','ext-queues,18147773876,1','0',0,0,0,0),(265,'998-HIG-20190503-8147773878','998-HIG-20190503-8147773878','324','','0','default','ext-queues,18147773878,1','','',1,'','','ext-queues,18147773878,1','0',0,0,0,0),(266,'1001-IND-20190514-8147773879','1001-IND-20190514-8147773879','326','','0','default','ext-queues,18147773879,1','','',1,'','','ext-queues,18147773879,1','0',0,0,0,0),(267,'1008-TOP-20190517-8147773883','1008-TOP-20190517-8147773883','327','','0','default','ext-queues,18147773883,1','','',1,'','','ext-queues,18147773883,1','0',0,0,0,0),(268,'795-TIT-20190520-8177702604','795-TIT-20190520-8177702604','328','','0','default','ext-queues,18177702604,1','','',3,'','','app-announcement-306,s,1','0',0,0,0,0),(269,'12-CIN-20190521-3335605356','12-CIN-20190521-3335605356','318','','0','','ext-queues,13335605356,1','','',1,'','','ext-queues,13335605356,1','0',0,0,0,0),(270,'1-BKP-20190523-8177700100','1-BKP-20190523-8177700100','330','','0','default','ext-queues,1008177700100,1','','',3,'','','ext-queues,1008177700100,1','0',0,0,0,0),(271,'12-BODAANAYEDUARDO-20190524-8147773881','12-BODAANAYEDUARDO-20190524-8147773881','329','','0','default','ext-queues,18147773881,1','','',1,'','','ext-queues,18147773881,1','0',0,0,0,0),(272,'1016-GIH-20190529-8147773882','1016-GIH-20190529-8147773882','331','','0','default','ext-queues,18147773882,1','','',1,'','','ext-queues,18147773882,1','0',0,0,0,0),(273,'706-LUX-20190531-2228800360','706-LUX-20190531-2228800360','332','','0','default','ext-group,686,1','','',3,'','','ext-group,686,1','0',0,0,0,0),(274,'1009-AME-20190613-8147773884','1009-AME-20190613-8147773884','333','','0','default','ext-queues,18147773884,1','','',1,'','','ext-queues,18147773884,1','0',0,0,0,0),(275,'1026-DEN-20190613-8147773885','1026-DEN-20190613-8147773885','334','','0','default','ext-queues,18147773885,1','','',1,'','','ext-queues,18147773885,1','0',0,0,0,0),(276,'1341-JEV-20210421-8147773887','1341-JEV-20210421-8147773887','427','','0','default','ext-queues,18147773887,1','','',1,'','','ext-queues,18147773887,1','0',0,0,0,0),(277,'1027-MIL-20190619-8147773886','1027-MIL-20190619-8147773886','342','','0','default','ext-group,691,1','','',3,'','','ext-group,691,1','0',0,0,0,0),(279,'1-FIS-20190709-5588804687','1-FIS-20190709-5588804687','221','','0','default','ext-queues,15588804687,1','','',1,'','','ext-queues,15588804687,1','0',0,0,0,0),(280,'1039-SHI-20190712-8147773888','1039-SHI-20190712-8147773888','337','','0','default','ext-queues,18147773888,1','','',1,'','','ext-queues,18147773888,1','0',0,0,0,0),(281,'1042-MEV-20190712-8147773889','1042-MEV-20190712-8147773889','338','','0','default','ext-queues,18147773889,1','','',1,'','','ext-queues,18147773889,1','0',0,0,0,0),(282,'1047-SOL-20190722-5589958536','1047-SOL-20190722-5589958536','339','','0','default','ext-queues,15589958536,1','','',1,'','','ext-queues,15589958536,1','0',0,0,0,0),(283,'1047-SOL-20190722-3335605357','1047-SOL-20190722-3335605357','339','','0','default','ext-queues,13335605357,1','','',1,'','','ext-queues,13335605357,1','0',0,0,0,0),(284,'1054-VIN-20190724-5588804687','1054-VIN-20190724-5588804687','341','','0','default','ext-queues,15588804687,1','','',1,'','default','ext-queues,15588804687,1','0',0,0,0,0),(285,'1-BKP-20190725-5000000000','1-BKP-20190725-5000000000','19','','0','default','ext-queues,15000000000,1','','',3,'','','ext-queues,15000000000,1','0',0,0,0,0),(286,'1309-COM-20210210-8147773890','1309-COM-20210210-8147773890','449','','0','default','ext-queues,18147773890,1','','',3,'','','ext-queues,18147773890,1','0',0,0,0,0),(287,'1294-WOR-20210128-8147773892','1294-WOR-20210128-8147773892','413','','0','default','ext-queues,18147773892,1','','',3,'','','ext-queues,18147773892,1','0',0,0,0,0),(288,'5-COO-20190827-2228800361','5-COO-20190827-2228800361','350','','0','default','ext-queues,12228800361,1','','',1,'','','ext-queues,12228800361,1','0',0,0,0,0),(290,'1046-ERP-20190724-2228800362','1046-ERP-20190724-2228800362','197','','0','default','app-blackhole,hangup,1','','',3,'','','app-blackhole,hangup,1','0',0,0,0,0),(292,'1095-MEN-20190930-8147773891','1095-MEN-20190930-8147773891','356','','0','default','ext-group,699,1','','',3,'','','ext-group,699,1','0',0,0,0,0),(293,'1100-FOO-20191002-8447770070','1100-FOO-20191002-8447770070','280','','0','default','ext-queues,18447770070,1','','',1,'','','ext-queues,18447770070,1','0',0,0,0,0),(295,'1-GLO-20191021-8177702600','1-GLO-20191021-8177702600','360','','0','default','ext-queues,18177702600,1','','',1,'','','ext-queues,18177702600,1','0',0,0,0,0),(296,'1-TEK-20191023-8177702601','1-TEK-20191023-8177702601','450','','0','default','ext-queues,18177702601,1','','',1,'','','ext-queues,18177702601,1','0',0,0,0,0),(297,'1123-AIP-20191107-8177702602','1123-AIP-20191107-8177702602','197','','0','default','app-blackhole,hangup,1','','',3,'','','app-blackhole,hangup,1','0',0,0,0,0),(298,'1114-GRU-20191108-5588804688','1114-GRU-20191108-5588804688','362','','0','default','ext-queues,15588804688,1','','',1,'','','ext-queues,15588804688,1','0',0,0,0,0),(299,'1124-ARR-20191112-8177702603','1124-ARR-20191112-8177702603','365','','0','default','ext-queues,18177702603,1','','',3,'','','ext-queues,18177702603,1','0',0,0,0,0),(300,'1126-OCA-20191113-4428880131','1126-OCA-20191113-4428880131','402','','0','default','ext-queues,14428880131,1','','',1,'','','ext-queues,14428880131,1','0',0,0,0,0),(301,'1-BKP-20191202-308177700100','1-BKP-20191202-308177700100','369','','0','default','ext-queues,308177700100,1','','',3,'','','ext-queues,308177700100,1','3',0,0,0,0),(302,'1-BKP-20191202-308147370215','1-BKP-20191202-308147370215','371','','0','default','ext-queues,308147370215,1','','',3,'','','ext-queues,308147370215,1','0',0,0,0,0),(303,'1-GLO-20191202-318177700100','1-GLO-20191202-318177700100','373','','0','default','ext-queues,318177700100,1','','',3,'','','ext-queues,318177700100,1','0',0,0,0,0),(304,'1-GLO-20191202-28177702601','1-GLO-20191202-28177702601','372','','0','default','ext-queues,28177702601,1','','',3,'','','ext-queues,28177702601,1','0',0,0,0,0),(305,'1-BKP-20191203-328177700100','1-BKP-20191203-328177700100','374','','0','default','ext-queues,328177700100,1','','',3,'','','ext-queues,328177700100,1','0',0,0,0,0),(306,'1-OC-INF-20200310-4428880130','1-OC-INF-20200310-4428880130','386','','0','default','ext-queues,14428880130,1','','',1,'','','ext-queues,14428880130,1','0',0,0,0,0),(307,'2-OC-ARE-20200318-4428880132','2-OC-ARE-20200318-4428880132','387','','0','default','ext-queues,14428880132,1','','',1,'','','ext-queues,14428880132,1','0',0,0,0,0),(308,'1-MBB-20200330-8177702605','1-MBB-20200330-8177702605','388','','0','default','ext-queues,18177702605,1','','',1,'','','ext-queues,18177702605,1','0',0,0,0,0),(309,'1-MBB-20200330-5547776691','1-MBB-20200330-5547776691','388','','0','default','ext-queues,15547776691,1','','',1,'','','ext-queues,15547776691,1','0',0,0,0,0),(310,'1-MBB-20200330-3388801850','1-MBB-20200330-3388801850','388','','0','default','ext-queues,13388801850,1','','',1,'','','ext-queues,13388801850,1','0',0,0,0,0),(311,'1221-CAP-20200417-3388800134','1221-CAP-20200417-3388800134','392','','0','default','ext-queues,13388800134,1','','',3,'','default','ext-queues,13388800134,1','0',0,0,0,0),(312,'1227-VIB-20200603-8177700683','1227-VIB-20200603-8177700683','401','','0','default','app-blackhole,hangup,1','default','',3,'','','ext-queues,18177700683,1','0',0,0,0,0),(314,'3-OC-BIE-20201030-4428880133','3-OC-BIE-20201030-4428880133','410','','0','default','ext-queues,14428880133,1','','',1,'','','ext-queues,14428880133,1','0',0,0,0,0),(315,'1343-DR8-20210421-8177702606','1343-DR8-20210421-8177702606','437','','0','default','ext-queues,18177702606,1','','',1,'','','ext-queues,18177702606,1','0',0,0,0,0);
/*!40000 ALTER TABLE `ivr_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `ivr_entries`
--

LOCK TABLES `ivr_entries` WRITE;
/*!40000 ALTER TABLE `ivr_entries` DISABLE KEYS */;
INSERT INTO `ivr_entries` (`ivr_id`, `selection`, `dest`, `ivr_ret`) VALUES (277,'0','ext-group,691,1',0),(277,'1','ext-group,687,1',0),(10,'2','app-announcement-229,s,1',0),(10,'1','app-announcement-228,s,1',0),(277,'2','ext-group,689,1',0),(268,'1','ext-group,684,1',0),(12,'1','ext-group,609,1',0),(12,'2','ext-group,605,1',0),(12,'9','app-announcement-17,s,1',0),(44,'1','ext-queues,18177700100,1',0),(44,'2','ext-group,639,1',0),(44,'9','app-announcement-52,s,1',0),(45,'1','ivr-152,s,1',0),(45,'2','ext-group,642,1',0),(45,'9','app-announcement-55,s,1',0),(295,'9','app-announcement-326,s,1',0),(277,'3','ext-group,690,1',0),(47,'1','ext-group,647,1',0),(47,'2','ext-group,648,1',0),(47,'9','app-announcement-61,s,1',0),(314,'1','ext-group,720,1',0),(268,'2','ext-group,685,1',0),(268,'9','ext-queues,18177702604,1',0),(314,'2','ext-group,721,1',0),(314,'3','ext-group,722,1',0),(314,'4','ext-group,723,1',0),(44,'1000','ext-group,656,1',0),(44,'1111','ext-group,657,1',0),(44,'1112','ext-group,658,1',0),(44,'1114','ext-group,659,1',0),(44,'1115','ext-group,660,1',0),(141,'1','app-announcement-162,s,1',0),(141,'2','app-announcement-163,s,1',0),(141,'3','app-announcement-164,s,1',0),(312,'1','ext-group,714,1',0),(312,'2','ext-group,715,1',0),(312,'3','ext-group,716,1',0),(143,'100','ext-group,713,1',0),(149,'1','app-announcement-180,s,1',0),(149,'2','app-announcement-181,s,1',0),(149,'3','app-announcement-182,s,1',0),(150,'2','app-announcement-177,s,1',0),(150,'5','ext-meetme,81777001002,1',0),(150,'9','app-announcement-178,s,1',0),(150,'1000','ext-group,656,1',0),(150,'1111','ext-group,657,1',0),(150,'1112','ext-group,658,1',0),(150,'1114','ext-group,659,1',0),(151,'1','app-announcement-186,s,1',0),(151,'2','app-announcement-187,s,1',0),(151,'3','app-announcement-188,s,1',0),(152,'1','app-announcement-186,s,1',0),(152,'2','app-announcement-187,s,1',0),(152,'3','app-announcement-188,s,1',0),(153,'1','ivr-152,s,1',0),(153,'2','app-announcement-183,s,1',0),(153,'9','app-announcement-184,s,1',0),(153,'1000','ext-group,668,1',0),(153,'1111','ext-group,669,1',0),(153,'1112','ext-group,670,1',0),(153,'1114','ext-group,671,1',0),(153,'1115','ext-group,672,1',0),(154,'1','app-announcement-192,s,1',0),(154,'2','app-announcement-193,s,1',0),(154,'3','app-announcement-194,s,1',0),(155,'1','ivr-154,s,1',0),(155,'2','ext-group,680,1',0),(155,'9','app-announcement-190,s,1',0),(155,'1000','ext-group,674,1',0),(155,'1111','ext-group,675,1',0),(155,'1112','ext-group,676,1',0),(155,'1114','ext-group,677,1',0),(155,'1115','ext-group,678,1',0),(163,'1','app-announcement-203,s,1',0),(163,'2','app-announcement-204,s,1',0),(163,'3','app-announcement-205,s,1',0),(163,'4','app-announcement-202,s,1',0),(299,'1','ext-queues,18177702603,1',0),(299,'2','ext-group,705,1',0),(118,'5','ext-meetme,81777003655,1',0),(121,'5','ext-meetme,81777003685,1',0),(150,'1115','ext-group,660,1',0),(150,'1','ivr-149,s,1',0),(150,'6','ext-meetme,81777001003,1',0),(308,'1','ext-meetme,81777026051,1',0),(308,'2','ext-meetme,81777026052,1',0),(308,'3','ext-meetme,81777026053,1',0),(308,'4','ext-meetme,81777026054,1',0),(308,'5','ext-meetme,81777026055,1',0),(309,'1','ext-meetme,55477766911,1',0),(309,'2','ext-meetme,55477766912,1',0),(309,'3','ext-meetme,55477766913,1',0),(309,'4','ext-meetme,55477766913,1',0),(309,'5','ext-meetme,55477766915,1',0),(310,'1','ext-meetme,33888018501,1',0),(310,'2','ext-meetme,33888018502,1',0),(310,'3','ext-meetme,33888018503,1',0),(310,'4','ext-meetme,33888018504,1',0),(310,'5','ext-meetme,33888018505,1',0),(250,'5','ext-meetme,81777015755,1',0),(311,'1','ext-group,709,1',0),(311,'2','ext-group,710,1',0),(311,'3','ext-group,711,1',0),(311,'4','ext-group,712,1',0),(311,'0','ext-queues,13388800134,1',0),(116,'5','ext-meetme,81777003631,1',0),(241,'5','ext-meetme,81777015715,1',0),(312,'4','ext-group,717,1',0),(296,'1','ext-group,724,1',0),(296,'2','ext-group,725,1',0),(296,'3','ext-group,726,1',0),(296,'9','app-announcement-327,s,1',0),(95,'2','ext-group,740,1',0),(95,'1','ext-group,739,1',0),(286,'1','ext-group,734,1',0),(286,'2','ext-group,732,1',0),(286,'3','ext-group,733,1',0);
/*!40000 ALTER TABLE `ivr_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `language_incoming`
--

LOCK TABLES `language_incoming` WRITE;
/*!40000 ALTER TABLE `language_incoming` DISABLE KEYS */;
/*!40000 ALTER TABLE `language_incoming` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `logfile_logfiles`
--

LOCK TABLES `logfile_logfiles` WRITE;
/*!40000 ALTER TABLE `logfile_logfiles` DISABLE KEYS */;
INSERT INTO `logfile_logfiles` (`name`, `debug`, `dtmf`, `error`, `fax`, `notice`, `verbose`, `warning`, `security`) VALUES ('full','on','off','on','off','on','on','on','off'),('console','on','off','on','off','on','on','on','off'),('messages','off','off','on','off','on','off','on','on');
/*!40000 ALTER TABLE `logfile_logfiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `logfile_settings`
--

LOCK TABLES `logfile_settings` WRITE;
/*!40000 ALTER TABLE `logfile_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `logfile_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `manager`
--

LOCK TABLES `manager` WRITE;
/*!40000 ALTER TABLE `manager` DISABLE KEYS */;
/*!40000 ALTER TABLE `manager` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `meetme`
--

LOCK TABLES `meetme` WRITE;
/*!40000 ALTER TABLE `meetme` DISABLE KEYS */;
INSERT INTO `meetme` (`exten`, `options`, `userpin`, `adminpin`, `description`, `joinmsg_id`, `music`, `users`) VALUES ('81777001002','woTciM','1111','1112','1-BKP-20200318-8177700100-EQUIPO-TECNOLOGIA',0,'inherit',0),('81777001003','woiM','1852','0613','1-BKP-20200318-8177700100-EQUIPO-GLOBALBNET',0,'inherit',0),('81777026051','ociM','','','1-MBB-20200330-8177702605-CONFERENCIA1',0,'inherit',10),('81777026052','TciM','','','1-MBB-20200330-8177702605-CONFERENCIA2',0,'inherit',10),('81777026053','ociM','','','1-MBB-20200330-8177702605-CONFERENCIA3',0,'inherit',10),('81777026054','ociM','','','1-MBB-20200330-8177702605-CONFERENCIA4',0,'inherit',10),('81777026055','ociM','','','1-MBB-20200330-8177702605-CONFERENCIA5',0,'inherit',10),('55477766911','ociM','','','1-MBB-20200330-5547776691-CONFERENCIA1',0,'inherit',10),('55477766912','ociM','','','1-MBB-20200330-5547776691-CONFERENCIA2',0,'inherit',10),('55477766913','ociM','','','1-MBB-20200330-5547776691-CONFERENCIA3',0,'inherit',10),('55477766914','ociM','','','1-MBB-20200330-5547776691-CONFERENCIA4',0,'inherit',10),('55477766915','ociM','','','1-MBB-20200330-5547776691-CONFERENCIA5',0,'inherit',10),('33888018501','ociM','','','1-MBB-20200330-3388801850-CONFERENCIA1',0,'inherit',10),('33888018502','ociM','','','1-MBB-20200330-3388801850-CONFERENCIA2',0,'inherit',10),('33888018503','ociM','','','1-MBB-20200330-3388801850-CONFERENCIA3',0,'inherit',10),('33888018504','ociM','','','1-MBB-20200330-3388801850-CONFERENCIA4',0,'inherit',10),('33888018505','ociM','','','1-MBB-20200330-3388801850-CONFERENCIA5',0,'inherit',10),('81777015755','ociM','','','927-KAI-20200331-8177701575-CONFERENCIA5',0,'inherit',0),('81777003631','ociM','','','754-INM-20200429-8177700363-CONFERENCIA5',0,'inherit',0),('81777015715','ociM','','','1220-FOR-20200422-81777015715-CONFERENCIA5',0,'inherit',0),('81777003685','ociM','','','1234-FHAM-20200703-8177700368-CONFERENCIA5',0,'inherit',0),('81777003655','ociM','','','1236-HIP-20200703-8177700365-CONFERENCIA5',0,'inherit',0);
/*!40000 ALTER TABLE `meetme` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `miscapps`
--

LOCK TABLES `miscapps` WRITE;
/*!40000 ALTER TABLE `miscapps` DISABLE KEYS */;
/*!40000 ALTER TABLE `miscapps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `miscdests`
--

LOCK TABLES `miscdests` WRITE;
/*!40000 ALTER TABLE `miscdests` DISABLE KEYS */;
/*!40000 ALTER TABLE `miscdests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `module_xml`
--

LOCK TABLES `module_xml` WRITE;
/*!40000 ALTER TABLE `module_xml` DISABLE KEYS */;
INSERT INTO `module_xml` (`id`, `time`, `data`) VALUES ('mod_serialized',1636923243,'a:61:{s:7:\"builtin\";a:13:{s:7:\"rawname\";s:7:\"builtin\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Basic\";s:4:\"name\";s:7:\"Builtin\";s:7:\"version\";s:7:\"2.3.0.2\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:9:\"menuitems\";a:1:{s:8:\"modules1\";s:12:\"Module Admin\";}s:11:\"displayname\";s:7:\"Builtin\";s:5:\"items\";a:1:{s:8:\"modules1\";a:5:{s:4:\"name\";s:12:\"Module Admin\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;s:7:\"display\";s:7:\"modules\";}}s:6:\"status\";i:2;s:4:\"repo\";s:5:\"local\";s:7:\"license\";s:0:\"\";}s:12:\"announcement\";a:17:{s:7:\"rawname\";s:12:\"announcement\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:13:\"Announcements\";s:7:\"version\";s:8:\"2.11.0.4\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:119:\"Plays back one of the system recordings (optionally allowing the user to skip it) and then goes to another destination.\";s:7:\"depends\";a:2:{s:7:\"version\";s:11:\"2.5.0alpha1\";s:6:\"module\";s:19:\"recordings ge 3.3.8\";}s:9:\"menuitems\";a:1:{s:12:\"announcement\";s:13:\"Announcements\";}s:8:\"popovers\";a:1:{s:12:\"announcement\";a:1:{s:7:\"display\";s:12:\"announcement\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:13:\"Announcements\";s:5:\"items\";a:1:{s:12:\"announcement\";a:4:{s:4:\"name\";s:13:\"Announcements\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.4\";}s:12:\"asterisk-cli\";a:16:{s:7:\"rawname\";s:12:\"asterisk-cli\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:12:\"Asterisk CLI\";s:7:\"version\";s:8:\"2.11.0.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:5:\"Admin\";s:11:\"description\";s:88:\"Provides an interface allowing you to run a command as if it was typed into Asterisk CLI\";s:9:\"menuitems\";a:1:{s:3:\"cli\";s:12:\"Asterisk CLI\";}s:7:\"depends\";a:1:{s:6:\"engine\";s:8:\"asterisk\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:12:\"Asterisk CLI\";s:5:\"items\";a:1:{s:3:\"cli\";a:4:{s:4:\"name\";s:12:\"Asterisk CLI\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.3\";}s:12:\"asteriskinfo\";a:16:{s:7:\"rawname\";s:12:\"asteriskinfo\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:13:\"Asterisk Info\";s:7:\"version\";s:9:\"2.11.0.89\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:7:\"Reports\";s:11:\"description\";s:57:\"Provides a snapshot of the current Asterisk configuration\";s:9:\"menuitems\";a:1:{s:12:\"asteriskinfo\";s:13:\"Asterisk Info\";}s:7:\"depends\";a:2:{s:6:\"engine\";s:8:\"asterisk\";s:7:\"version\";s:8:\"2.5.0rc3\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:13:\"Asterisk Info\";s:5:\"items\";a:1:{s:12:\"asteriskinfo\";a:4:{s:4:\"name\";s:13:\"Asterisk Info\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:7:\"Reports\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.0.89\";}s:6:\"backup\";a:16:{s:7:\"rawname\";s:6:\"backup\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:16:\"Backup & Restore\";s:7:\"version\";s:9:\"2.11.0.22\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:5:\"Admin\";s:11:\"description\";s:48:\"Backup & Restore for your IssabelPBX environment\";s:9:\"menuitems\";a:4:{s:6:\"backup\";s:16:\"Backup & Restore\";s:14:\"backup_servers\";s:26:\"Backup & Restore - Servers\";s:16:\"backup_templates\";s:28:\"Backup & Restore - Templates\";s:14:\"backup_restore\";s:26:\"Backup & Restore - Restore\";}s:7:\"depends\";a:1:{s:6:\"module\";s:4:\"core\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:16:\"Backup & Restore\";s:5:\"items\";a:4:{s:6:\"backup\";a:5:{s:4:\"name\";s:16:\"Backup & Restore\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}s:14:\"backup_servers\";a:6:{s:4:\"name\";s:26:\"Backup & Restore - Servers\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";s:6:\"hidden\";s:4:\"true\";}s:16:\"backup_templates\";a:6:{s:4:\"name\";s:28:\"Backup & Restore - Templates\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";s:6:\"hidden\";s:4:\"true\";}s:14:\"backup_restore\";a:6:{s:4:\"name\";s:26:\"Backup & Restore - Restore\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";s:6:\"hidden\";s:4:\"true\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.0.22\";}s:9:\"blacklist\";a:15:{s:7:\"rawname\";s:9:\"blacklist\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:9:\"Blacklist\";s:7:\"version\";s:8:\"2.11.0.6\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:5:\"Admin\";s:9:\"menuitems\";a:1:{s:9:\"blacklist\";s:9:\"Blacklist\";}s:7:\"depends\";a:1:{s:6:\"module\";s:15:\"core ge 2.5.1.2\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:9:\"Blacklist\";s:5:\"items\";a:1:{s:9:\"blacklist\";a:5:{s:4:\"name\";s:9:\"Blacklist\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.6\";}s:8:\"callback\";a:16:{s:7:\"rawname\";s:8:\"callback\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:8:\"Callback\";s:7:\"version\";s:8:\"2.11.0.4\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:9:\"menuitems\";a:1:{s:8:\"callback\";s:8:\"Callback\";}s:8:\"popovers\";a:1:{s:8:\"callback\";a:1:{s:7:\"display\";s:8:\"callback\";}}s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.4.0\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:8:\"Callback\";s:5:\"items\";a:1:{s:8:\"callback\";a:4:{s:4:\"name\";s:8:\"Callback\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.4\";}s:11:\"callforward\";a:13:{s:7:\"rawname\";s:11:\"callforward\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:12:\"Call Forward\";s:7:\"version\";s:6:\"2.11.5\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:7:\"AGPLv3+\";s:11:\"licenselink\";s:40:\"http://www.gnu.org/licenses/agpl-3.0.txt\";s:11:\"description\";s:33:\"Provides callforward featurecodes\";s:8:\"category\";s:12:\"Applications\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:12:\"Call Forward\";s:6:\"status\";i:2;s:9:\"dbversion\";s:6:\"2.11.5\";}s:13:\"callrecording\";a:18:{s:7:\"rawname\";s:13:\"callrecording\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:14:\"Call Recording\";s:7:\"version\";s:8:\"2.11.0.9\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:50:\"Provides much of the call recording functionality.\";s:9:\"menuitems\";a:1:{s:13:\"callrecording\";s:14:\"Call Recording\";}s:8:\"popovers\";a:1:{s:13:\"callrecording\";a:1:{s:7:\"display\";s:13:\"callrecording\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:14:\"Call Recording\";s:5:\"items\";a:1:{s:13:\"callrecording\";a:4:{s:4:\"name\";s:14:\"Call Recording\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.9\";}s:11:\"callwaiting\";a:13:{s:7:\"rawname\";s:11:\"callwaiting\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:12:\"Call Waiting\";s:11:\"description\";s:46:\"Provides an option to turn on/off call waiting\";s:8:\"category\";s:12:\"Applications\";s:7:\"version\";s:8:\"2.11.0.4\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:12:\"Call Waiting\";s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.4\";}s:3:\"cdr\";a:16:{s:7:\"rawname\";s:3:\"cdr\";s:4:\"repo\";s:8:\"standard\";s:11:\"description\";s:63:\"Call Data Record report tools for viewing reports of your calls\";s:4:\"name\";s:11:\"CDR Reports\";s:7:\"version\";s:9:\"2.11.0.12\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:7:\"Reports\";s:9:\"menuitems\";a:1:{s:3:\"cdr\";s:11:\"CDR Reports\";}s:7:\"depends\";a:1:{s:6:\"module\";s:13:\"core ge 2.6.0\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:11:\"CDR Reports\";s:5:\"items\";a:1:{s:3:\"cdr\";a:4:{s:4:\"name\";s:11:\"CDR Reports\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:7:\"Reports\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.0.12\";}s:9:\"cidlookup\";a:16:{s:7:\"rawname\";s:9:\"cidlookup\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:15:\"CallerID Lookup\";s:7:\"version\";s:9:\"2.11.1.12\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:11:\"description\";s:114:\"Allows CallerID Lookup of incoming calls against different sources (OpenCNAM, MySQL, HTTP, ENUM, Phonebook Module)\";s:8:\"category\";s:5:\"Admin\";s:9:\"menuitems\";a:1:{s:9:\"cidlookup\";s:23:\"CallerID Lookup Sources\";}s:7:\"depends\";a:2:{s:6:\"engine\";s:12:\"asterisk 1.6\";s:6:\"module\";s:26:\"framework ge 2.11.0.0rc1.6\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:15:\"CallerID Lookup\";s:5:\"items\";a:1:{s:9:\"cidlookup\";a:4:{s:4:\"name\";s:23:\"CallerID Lookup Sources\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.1.12\";}s:11:\"conferences\";a:17:{s:7:\"rawname\";s:11:\"conferences\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:11:\"Conferences\";s:7:\"version\";s:8:\"2.11.0.6\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:85:\"Allow creation of conference rooms (meet-me) where multiple people can talk together.\";s:7:\"depends\";a:2:{s:7:\"version\";s:11:\"2.5.0alpha1\";s:6:\"module\";s:19:\"recordings ge 3.3.8\";}s:9:\"menuitems\";a:1:{s:11:\"conferences\";s:11:\"Conferences\";}s:8:\"popovers\";a:1:{s:11:\"conferences\";a:1:{s:7:\"display\";s:11:\"conferences\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:11:\"Conferences\";s:5:\"items\";a:1:{s:11:\"conferences\";a:4:{s:4:\"name\";s:11:\"Conferences\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.6\";}s:4:\"core\";a:20:{s:7:\"rawname\";s:4:\"core\";s:4:\"repo\";s:8:\"standard\";s:8:\"category\";s:12:\"Applications\";s:4:\"name\";s:4:\"Core\";s:7:\"version\";s:9:\"2.11.0.35\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:7:\"depends\";a:2:{s:6:\"module\";s:22:\"framework ge 2.11.0.30\";s:7:\"version\";s:12:\"2.11.0alpha0\";}s:12:\"requirements\";a:1:{s:4:\"file\";s:18:\"/usr/sbin/asterisk\";}s:9:\"menuitems\";a:10:{s:10:\"extensions\";s:10:\"Extensions\";s:5:\"users\";s:5:\"Users\";s:7:\"devices\";s:7:\"Devices\";s:3:\"did\";s:14:\"Inbound Routes\";s:13:\"dahdichandids\";s:18:\"DAHDI Channel DIDs\";s:7:\"routing\";s:15:\"Outbound Routes\";s:6:\"trunks\";s:6:\"Trunks\";s:16:\"advancedsettings\";s:17:\"Advanced Settings\";s:8:\"ampusers\";s:14:\"Administrators\";s:4:\"wiki\";s:18:\"IssabelPBX Support\";}s:8:\"popovers\";a:2:{s:10:\"extensions\";a:1:{s:7:\"display\";s:10:\"extensions\";}s:5:\"users\";a:1:{s:7:\"display\";s:5:\"users\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:4:\"Core\";s:7:\"methods\";a:1:{s:10:\"get_config\";a:1:{i:480;a:1:{i:0;s:18:\"core_do_get_config\";}}}s:5:\"items\";a:10:{s:10:\"extensions\";a:5:{s:4:\"name\";s:10:\"Extensions\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}s:5:\"users\";a:5:{s:4:\"name\";s:5:\"Users\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}s:7:\"devices\";a:5:{s:4:\"name\";s:7:\"Devices\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}s:3:\"did\";a:4:{s:4:\"name\";s:14:\"Inbound Routes\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Connectivity\";s:4:\"sort\";i:0;}s:13:\"dahdichandids\";a:4:{s:4:\"name\";s:18:\"DAHDI Channel DIDs\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Connectivity\";s:4:\"sort\";i:0;}s:7:\"routing\";a:4:{s:4:\"name\";s:15:\"Outbound Routes\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Connectivity\";s:4:\"sort\";i:0;}s:6:\"trunks\";a:4:{s:4:\"name\";s:6:\"Trunks\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Connectivity\";s:4:\"sort\";i:0;}s:16:\"advancedsettings\";a:4:{s:4:\"name\";s:17:\"Advanced Settings\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}s:8:\"ampusers\";a:4:{s:4:\"name\";s:14:\"Administrators\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}s:4:\"wiki\";a:8:{s:4:\"name\";s:18:\"IssabelPBX Support\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;s:4:\"href\";s:22:\"http://www.issabel.com\";s:6:\"target\";s:6:\"_blank\";s:6:\"access\";s:3:\"all\";s:13:\"requires_auth\";s:5:\"false\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.0.35\";}s:13:\"customappsreg\";a:17:{s:7:\"rawname\";s:13:\"customappsreg\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:19:\"Custom Applications\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:5:\"Admin\";s:11:\"description\";s:147:\"Registry to add custom extensions and destinations that may be created and used so that the Extensions and Destinations Registry can include these.\";s:9:\"menuitems\";a:2:{s:12:\"customextens\";s:17:\"Custom Extensions\";s:11:\"customdests\";s:19:\"Custom Destinations\";}s:8:\"popovers\";a:1:{s:13:\"customappsreg\";a:1:{s:7:\"display\";s:11:\"customdests\";}}s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.4.0\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:19:\"Custom Applications\";s:5:\"items\";a:2:{s:12:\"customextens\";a:4:{s:4:\"name\";s:17:\"Custom Extensions\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}s:11:\"customdests\";a:4:{s:4:\"name\";s:19:\"Custom Destinations\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:14:\"customcontexts\";a:15:{s:7:\"rawname\";s:14:\"customcontexts\";s:4:\"repo\";s:11:\"unsupported\";s:4:\"name\";s:15:\"Custom Contexts\";s:7:\"version\";s:8:\"2.11.0.2\";s:8:\"category\";s:12:\"Connectivity\";s:7:\"license\";s:6:\"GPLv2+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-2.0.txt\";s:11:\"description\";s:506:\"Creates custom contexts which can be used to allow limited access to dialplan applications. Allows for time restrictions on any dialplan access. Allows for pattern matching to allow/deny. Allows for failover destinations, and PIN protected failover. This can be very useful for multi-tennant systems. Inbound routing can be done using DID or zap channel routing,	this module allows for selective outbound routing. House/public phones can be placed in a restricted context allowing them only internal calls.\";s:9:\"menuitems\";a:2:{s:14:\"customcontexts\";s:15:\"Custom Contexts\";s:19:\"customcontextsadmin\";s:21:\"Custom Contexts Admin\";}s:7:\"depends\";a:2:{s:7:\"version\";s:11:\"2.8.0alpha1\";s:6:\"module\";a:2:{i:0;s:4:\"core\";i:1;s:14:\"timeconditions\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:15:\"Custom Contexts\";s:5:\"items\";a:2:{s:14:\"customcontexts\";a:4:{s:4:\"name\";s:15:\"Custom Contexts\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Connectivity\";s:4:\"sort\";i:0;}s:19:\"customcontextsadmin\";a:4:{s:4:\"name\";s:21:\"Custom Contexts Admin\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Connectivity\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:10:\"customerdb\";a:12:{s:7:\"rawname\";s:10:\"customerdb\";s:4:\"name\";s:11:\"Customer DB\";s:7:\"version\";s:7:\"2.5.0.4\";s:4:\"type\";s:4:\"tool\";s:8:\"category\";s:17:\"Third Party Addon\";s:9:\"menuitems\";a:1:{s:10:\"customerdb\";s:11:\"Customer DB\";}s:11:\"displayname\";s:11:\"Customer DB\";s:5:\"items\";a:1:{s:10:\"customerdb\";a:4:{s:4:\"name\";s:11:\"Customer DB\";s:4:\"type\";s:4:\"tool\";s:8:\"category\";s:17:\"Third Party Addon\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:4:\"repo\";s:5:\"local\";s:9:\"dbversion\";s:7:\"2.5.0.4\";s:7:\"license\";s:0:\"\";}s:9:\"dashboard\";a:18:{s:7:\"rawname\";s:9:\"dashboard\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:16:\"System Dashboard\";s:7:\"version\";s:8:\"2.11.0.5\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:8:\"category\";s:7:\"Reports\";s:11:\"description\";s:117:\"Provides a system information dashboard, showing information about Calls, CPU, Memory, Disks, Network, and processes.\";s:9:\"menuitems\";a:1:{s:9:\"dashboard\";s:24:\"IssabelPBX System Status\";}s:7:\"depends\";a:1:{s:7:\"version\";s:10:\"2.3.0beta2\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:16:\"System Dashboard\";s:5:\"items\";a:1:{s:9:\"dashboard\";a:6:{s:4:\"name\";s:24:\"IssabelPBX System Status\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:7:\"Reports\";s:4:\"sort\";i:0;s:7:\"display\";s:5:\"index\";s:6:\"access\";s:3:\"all\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.5\";}s:8:\"daynight\";a:17:{s:7:\"rawname\";s:8:\"daynight\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:17:\"Call Flow Control\";s:7:\"version\";s:8:\"2.11.0.6\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:146:\"Call Flow manual toggle control - allows for two destinations to be chosen and provides a feature code		that toggles between the two destinations.\";s:7:\"depends\";a:1:{s:7:\"version\";s:11:\"2.5.0alpha1\";}s:9:\"menuitems\";a:1:{s:8:\"daynight\";s:17:\"Call Flow Control\";}s:8:\"popovers\";a:1:{s:8:\"daynight\";a:1:{s:7:\"display\";s:8:\"daynight\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:17:\"Call Flow Control\";s:5:\"items\";a:1:{s:8:\"daynight\";a:5:{s:4:\"name\";s:17:\"Call Flow Control\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.6\";}s:7:\"dictate\";a:13:{s:7:\"rawname\";s:7:\"dictate\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:9:\"Dictation\";s:7:\"version\";s:8:\"2.11.0.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:189:\"This uses the app_dictate module of Asterisk to let users record dictate into their phones. When complete, the dictations can be emailed to an email address specified in the extension page.\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:9:\"Dictation\";s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.3\";}s:4:\"disa\";a:17:{s:7:\"rawname\";s:4:\"disa\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:4:\"DISA\";s:7:\"version\";s:8:\"2.11.0.6\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:9:\"menuitems\";a:1:{s:4:\"disa\";s:4:\"DISA\";}s:8:\"popovers\";a:1:{s:4:\"disa\";a:1:{s:7:\"display\";s:4:\"disa\";}}s:11:\"description\";s:264:\"DISA Allows you \'Direct Inward System Access\'. This gives you the ability to have an option on an IVR that gives you a dial tone, and you\'re able to dial out from the IssabelPBX machine as if you were connected to a standard extension. It appears as a Destination.\";s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.4.0\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:4:\"DISA\";s:5:\"items\";a:1:{s:4:\"disa\";a:4:{s:4:\"name\";s:4:\"DISA\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.6\";}s:12:\"donotdisturb\";a:13:{s:7:\"rawname\";s:12:\"donotdisturb\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:20:\"Do-Not-Disturb (DND)\";s:7:\"version\";s:8:\"2.11.0.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:11:\"description\";s:34:\"Provides donotdisturb featurecodes\";s:8:\"category\";s:12:\"Applications\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:20:\"Do-Not-Disturb (DND)\";s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.3\";}s:10:\"dundicheck\";a:16:{s:7:\"rawname\";s:10:\"dundicheck\";s:4:\"repo\";s:11:\"unsupported\";s:4:\"name\";s:21:\"DUNDi Lookup Registry\";s:7:\"version\";s:8:\"2.11.0.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:11:\"description\";s:334:\"This module will check all configured and enabled DUNDi trunks as part of the extension registry function, and report back conflicts if		other sites have the same extensions. This does not filter against the route patterns - it will take any number being created and		report a conflict if that trunk could be used to call that number.\";s:9:\"menuitems\";a:1:{s:10:\"dundicheck\";s:12:\"DUNDi Lookup\";}s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.4.0\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:8:\"category\";s:5:\"Admin\";s:11:\"displayname\";s:21:\"DUNDi Lookup Registry\";s:5:\"items\";a:1:{s:10:\"dundicheck\";a:4:{s:4:\"name\";s:12:\"DUNDi Lookup\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.3\";}s:3:\"fax\";a:16:{s:7:\"rawname\";s:3:\"fax\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:17:\"Fax Configuration\";s:7:\"version\";s:8:\"2.11.0.9\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:8:\"Settings\";s:9:\"menuitems\";a:1:{s:3:\"fax\";s:17:\"Fax Configuration\";}s:11:\"description\";s:55:\"Adds configurations, options and GUI for inbound faxing\";s:7:\"depends\";a:1:{s:7:\"version\";s:10:\"2.7.0beta1\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:17:\"Fax Configuration\";s:5:\"items\";a:1:{s:3:\"fax\";a:4:{s:4:\"name\";s:17:\"Fax Configuration\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.9\";}s:16:\"featurecodeadmin\";a:17:{s:7:\"rawname\";s:16:\"featurecodeadmin\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:18:\"Feature Code Admin\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:8:\"category\";s:5:\"Admin\";s:9:\"menuitems\";a:1:{s:16:\"featurecodeadmin\";s:13:\"Feature Codes\";}s:7:\"depends\";a:1:{s:7:\"version\";s:11:\"2.5.0alpha1\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:18:\"Feature Code Admin\";s:5:\"items\";a:1:{s:16:\"featurecodeadmin\";a:4:{s:4:\"name\";s:13:\"Feature Codes\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:12:\"findmefollow\";a:16:{s:7:\"rawname\";s:12:\"findmefollow\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:9:\"Follow Me\";s:7:\"version\";s:8:\"2.11.0.6\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:7:\"depends\";a:2:{s:7:\"version\";s:11:\"2.5.0alpha1\";s:6:\"module\";s:19:\"recordings ge 3.3.8\";}s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:358:\"Much like a ring group, but works on individual extensions. When someone calls the extension, it can be setup to ring for a number of seconds before trying to ring other extensions and/or external numbers, or to ring all at once, or in other various \'hunt\' configurations. Most commonly used to ring someone\'s cell phone if they don\'t answer their extension.\";s:9:\"menuitems\";a:1:{s:12:\"findmefollow\";s:9:\"Follow Me\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:9:\"Follow Me\";s:5:\"items\";a:1:{s:12:\"findmefollow\";a:5:{s:4:\"name\";s:9:\"Follow Me\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.6\";}s:9:\"framework\";a:16:{s:7:\"rawname\";s:9:\"framework\";s:7:\"modtype\";s:9:\"framework\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:20:\"IssabelPBX Framework\";s:7:\"version\";s:9:\"2.11.0.43\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:11:\"description\";s:115:\"This module provides a facility to install bug fixes to the framework code that is not otherwise housed in a module\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:8:\"category\";s:5:\"Admin\";s:11:\"displayname\";s:20:\"IssabelPBX Framework\";s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.0.43\";}s:6:\"fw_ari\";a:16:{s:7:\"rawname\";s:6:\"fw_ari\";s:7:\"modtype\";s:9:\"framework\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:24:\"IssabelPBX ARI Framework\";s:7:\"version\";s:8:\"2.11.1.5\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:11:\"description\";s:202:\"This module provides a facility to install bug fixes to the ARI code that is not otherwise housed in a module, it used to be part of framework but has been removed to isolate ARI from Framework updates.\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:8:\"category\";s:5:\"Admin\";s:9:\"menuitems\";a:1:{s:6:\"fw_ari\";s:10:\"User Panel\";}s:11:\"displayname\";s:24:\"IssabelPBX ARI Framework\";s:5:\"items\";a:1:{s:6:\"fw_ari\";a:8:{s:4:\"name\";s:10:\"User Panel\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:10:\"User Panel\";s:4:\"sort\";i:0;s:4:\"href\";s:11:\"/recordings\";s:6:\"target\";s:3:\"ari\";s:6:\"access\";s:3:\"all\";s:13:\"requires_auth\";s:5:\"false\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.1.5\";}s:12:\"fw_langpacks\";a:14:{s:7:\"rawname\";s:12:\"fw_langpacks\";s:7:\"modtype\";s:9:\"framework\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:31:\"IssabelPBX Localization Updates\";s:7:\"version\";s:6:\"2.11.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:11:\"description\";s:505:\"This module provides a facility to install new and updated localization translations for all components in IssabelPBX. Localization i18n translations are still kept with each module and other components such as the User Portal (ARI). This provides an easy ability to bring all components up-to-date without the need of publishing dozens of modules for every minor change. The localization updates used will be the latest available for all modules and will not consider the current version you are running.\";s:8:\"category\";s:5:\"Admin\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:31:\"IssabelPBX Localization Updates\";s:6:\"status\";i:2;s:9:\"dbversion\";s:6:\"2.11.2\";}s:7:\"gabcast\";a:13:{s:7:\"rawname\";s:7:\"gabcast\";s:4:\"name\";s:7:\"Gabcast\";s:7:\"version\";s:7:\"2.5.0.2\";s:4:\"type\";s:4:\"tool\";s:8:\"category\";s:17:\"Third Party Addon\";s:9:\"menuitems\";a:1:{s:7:\"gabcast\";s:7:\"Gabcast\";}s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.4.0\";}s:11:\"displayname\";s:7:\"Gabcast\";s:5:\"items\";a:1:{s:7:\"gabcast\";a:4:{s:4:\"name\";s:7:\"Gabcast\";s:4:\"type\";s:4:\"tool\";s:8:\"category\";s:17:\"Third Party Addon\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:4:\"repo\";s:5:\"local\";s:9:\"dbversion\";s:7:\"2.5.0.2\";s:7:\"license\";s:0:\"\";}s:11:\"iaxsettings\";a:15:{s:7:\"rawname\";s:11:\"iaxsettings\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:21:\"Asterisk IAX Settings\";s:7:\"version\";s:8:\"2.11.0.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:11:\"licenselink\";s:40:\"http://www.gnu.org/licenses/agpl-3.0.txt\";s:7:\"license\";s:6:\"AGPLv3\";s:8:\"category\";s:8:\"Settings\";s:9:\"menuitems\";a:1:{s:11:\"iaxsettings\";s:21:\"Asterisk IAX Settings\";}s:11:\"description\";s:210:\"Use to configure Various Asterisk IAX Settings in the General section of iax.conf. The module assumes Asterisk version 1.4 or higher. Some settings may not exist in Asterisk 1.2 and will be ignored by Asterisk.\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:21:\"Asterisk IAX Settings\";s:5:\"items\";a:1:{s:11:\"iaxsettings\";a:4:{s:4:\"name\";s:21:\"Asterisk IAX Settings\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.3\";}s:12:\"infoservices\";a:15:{s:7:\"rawname\";s:12:\"infoservices\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:13:\"Info Services\";s:7:\"version\";s:8:\"2.11.0.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:180:\"Provides a number of applications accessible by feature codes: company directory, call trace (last call information), echo test, speaking clock, and speak current extension number.\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:13:\"Info Services\";s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.3\";}s:11:\"inventorydb\";a:12:{s:7:\"rawname\";s:11:\"inventorydb\";s:4:\"name\";s:9:\"Inventory\";s:7:\"version\";s:7:\"2.5.0.2\";s:4:\"type\";s:4:\"tool\";s:8:\"category\";s:17:\"Third Party Addon\";s:9:\"menuitems\";a:1:{s:11:\"inventorydb\";s:9:\"Inventory\";}s:11:\"displayname\";s:9:\"Inventory\";s:5:\"items\";a:1:{s:11:\"inventorydb\";a:4:{s:4:\"name\";s:9:\"Inventory\";s:4:\"type\";s:4:\"tool\";s:8:\"category\";s:17:\"Third Party Addon\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:4:\"repo\";s:5:\"local\";s:9:\"dbversion\";s:7:\"2.5.0.2\";s:7:\"license\";s:0:\"\";}s:3:\"ivr\";a:17:{s:7:\"rawname\";s:3:\"ivr\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:3:\"IVR\";s:7:\"version\";s:9:\"2.11.0.10\";s:9:\"publisher\";s:17:\"Isabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:219:\"Creates Digital Receptionist (aka Auto-Attendant, aka Interactive Voice Response) menus. These can be used to send callers to different locations (eg, Press 1 for sales) and/or allow direct-dialing of extension numbers.\";s:7:\"depends\";a:2:{s:7:\"version\";s:11:\"2.5.0alpha1\";s:6:\"module\";s:19:\"recordings ge 3.3.8\";}s:9:\"menuitems\";a:1:{s:3:\"ivr\";s:3:\"IVR\";}s:8:\"popovers\";a:1:{s:3:\"ivr\";a:2:{s:7:\"display\";s:3:\"ivr\";s:6:\"action\";s:3:\"add\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:3:\"IVR\";s:5:\"items\";a:1:{s:3:\"ivr\";a:4:{s:4:\"name\";s:3:\"IVR\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.0.10\";}s:7:\"javassh\";a:15:{s:7:\"rawname\";s:7:\"javassh\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:8:\"Java SSH\";s:7:\"version\";s:6:\"2.11.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:7:\"AGPLv3+\";s:11:\"licenselink\";s:40:\"http://www.gnu.org/licenses/agpl-3.0.txt\";s:8:\"category\";s:5:\"Admin\";s:11:\"description\";s:60:\"Provides a Java applet to access the system shell using SSH.\";s:9:\"menuitems\";a:1:{s:7:\"javassh\";s:8:\"Java SSH\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:8:\"Java SSH\";s:5:\"items\";a:1:{s:7:\"javassh\";a:4:{s:4:\"name\";s:8:\"Java SSH\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:6:\"2.11.2\";}s:9:\"languages\";a:17:{s:7:\"rawname\";s:9:\"languages\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:9:\"Languages\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:96:\"Adds the ability to changes the language within a call flow and add language attribute to users.\";s:9:\"menuitems\";a:1:{s:9:\"languages\";s:9:\"Languages\";}s:8:\"popovers\";a:1:{s:9:\"languages\";a:1:{s:7:\"display\";s:9:\"languages\";}}s:7:\"depends\";a:1:{s:7:\"version\";s:11:\"2.5.0alpha1\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:9:\"Languages\";s:5:\"items\";a:1:{s:9:\"languages\";a:4:{s:4:\"name\";s:9:\"Languages\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:8:\"logfiles\";a:15:{s:7:\"rawname\";s:8:\"logfiles\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:17:\"Asterisk Logfiles\";s:12:\"canuninstall\";s:2:\"no\";s:7:\"version\";s:8:\"2.11.1.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:7:\"Reports\";s:9:\"menuitems\";a:2:{s:8:\"logfiles\";s:17:\"Asterisk Logfiles\";s:17:\"logfiles_settings\";s:25:\"Asterisk Logfile Settings\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:17:\"Asterisk Logfiles\";s:5:\"items\";a:2:{s:8:\"logfiles\";a:4:{s:4:\"name\";s:17:\"Asterisk Logfiles\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:7:\"Reports\";s:4:\"sort\";i:0;}s:17:\"logfiles_settings\";a:4:{s:4:\"name\";s:25:\"Asterisk Logfile Settings\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.1.3\";}s:7:\"manager\";a:14:{s:7:\"rawname\";s:7:\"manager\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:22:\"Asterisk Manager Users\";s:7:\"version\";s:8:\"2.11.0.5\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:8:\"Settings\";s:9:\"menuitems\";a:1:{s:7:\"manager\";s:22:\"Asterisk Manager Users\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:22:\"Asterisk Manager Users\";s:5:\"items\";a:1:{s:7:\"manager\";a:4:{s:4:\"name\";s:22:\"Asterisk Manager Users\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.5\";}s:8:\"miscapps\";a:16:{s:7:\"rawname\";s:8:\"miscapps\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:17:\"Misc Applications\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:108:\"Adds the ability to create feature codes that can go to any IssabelPBX destination (such as an IVR or queue)\";s:9:\"menuitems\";a:1:{s:8:\"miscapps\";s:17:\"Misc Applications\";}s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.4.0\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:17:\"Misc Applications\";s:5:\"items\";a:1:{s:8:\"miscapps\";a:4:{s:4:\"name\";s:17:\"Misc Applications\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:9:\"miscdests\";a:17:{s:7:\"rawname\";s:9:\"miscdests\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:17:\"Misc Destinations\";s:7:\"version\";s:8:\"2.11.0.4\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:190:\"Allows creating destinations that dial any local number (extensions, feature codes, outside phone numbers) that can be used by other modules (eg, IVR, time conditions) as a call destination.\";s:7:\"depends\";a:1:{s:7:\"version\";s:11:\"2.5.0alpha1\";}s:9:\"menuitems\";a:1:{s:9:\"miscdests\";s:17:\"Misc Destinations\";}s:8:\"popovers\";a:1:{s:9:\"miscdests\";a:1:{s:7:\"display\";s:9:\"miscdests\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:17:\"Misc Destinations\";s:5:\"items\";a:1:{s:9:\"miscdests\";a:4:{s:4:\"name\";s:17:\"Misc Destinations\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.4\";}s:5:\"music\";a:17:{s:7:\"rawname\";s:5:\"music\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:13:\"Music on Hold\";s:7:\"version\";s:8:\"2.11.0.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:8:\"category\";s:8:\"Settings\";s:11:\"description\";s:80:\"Uploading and management of sound files (wav, mp3) to be used for on-hold music.\";s:9:\"menuitems\";a:1:{s:5:\"music\";s:13:\"Music on Hold\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:13:\"Music on Hold\";s:5:\"items\";a:1:{s:5:\"music\";a:4:{s:4:\"name\";s:13:\"Music on Hold\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.3\";}s:11:\"outroutemsg\";a:16:{s:7:\"rawname\";s:11:\"outroutemsg\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:25:\"Route Congestion Messages\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:8:\"Settings\";s:11:\"description\";s:154:\"Configures message or congestion tones played when all trunks are busy in a route. Allows different messages for Emergency Routes and Intra-Company Routes\";s:9:\"menuitems\";a:1:{s:11:\"outroutemsg\";s:25:\"Route Congestion Messages\";}s:7:\"depends\";a:1:{s:6:\"module\";s:19:\"recordings ge 3.3.8\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:25:\"Route Congestion Messages\";s:5:\"items\";a:1:{s:11:\"outroutemsg\";a:4:{s:4:\"name\";s:25:\"Route Congestion Messages\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:6:\"paging\";a:18:{s:7:\"rawname\";s:6:\"paging\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:19:\"Paging and Intercom\";s:7:\"version\";s:8:\"2.11.0.9\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.4.0\";}s:11:\"description\";s:345:\"Allows creation of paging groups to make announcements using the speaker built into most SIP phones. 	Also creates an Intercom feature code that can be used as a prefix to talk directly to one person, as well as optional feature codes to block/allow intercom calls to all users as well as blocking specific users or only allowing specific users.\";s:9:\"menuitems\";a:1:{s:6:\"paging\";s:19:\"Paging and Intercom\";}s:12:\"requirements\";a:1:{s:6:\"module\";s:11:\"conferences\";}s:8:\"popovers\";a:1:{s:6:\"paging\";a:2:{s:7:\"display\";s:6:\"paging\";s:6:\"action\";s:3:\"add\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:19:\"Paging and Intercom\";s:5:\"items\";a:1:{s:6:\"paging\";a:4:{s:4:\"name\";s:19:\"Paging and Intercom\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.9\";}s:7:\"parking\";a:16:{s:7:\"rawname\";s:7:\"parking\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:11:\"Parking Lot\";s:7:\"version\";s:9:\"2.11.0.15\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:139:\"Manages parking lot extensions and other options.	Parking is a way of putting calls \"on hold\", and then picking them up from any extension.\";s:9:\"menuitems\";a:1:{s:7:\"parking\";s:7:\"Parking\";}s:7:\"depends\";a:2:{s:6:\"engine\";s:15:\"asterisk ge 1.8\";s:7:\"version\";s:4:\"2.11\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:11:\"Parking Lot\";s:5:\"items\";a:1:{s:7:\"parking\";a:4:{s:4:\"name\";s:7:\"Parking\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.0.15\";}s:11:\"pbdirectory\";a:14:{s:7:\"rawname\";s:11:\"pbdirectory\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:19:\"Phonebook Directory\";s:7:\"version\";s:8:\"2.11.0.5\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:5:\"Admin\";s:11:\"description\";s:55:\"Provides a dial-by-name directory for phonebook entries\";s:7:\"depends\";a:2:{s:7:\"version\";s:5:\"2.4.0\";s:6:\"module\";a:2:{i:0;s:9:\"phonebook\";i:1;s:9:\"speeddial\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:19:\"Phonebook Directory\";s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.5\";}s:9:\"phonebook\";a:15:{s:7:\"rawname\";s:9:\"phonebook\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:9:\"Phonebook\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:11:\"description\";s:95:\"Provides a phonebook for IssabelPBX, it can be used as base for Caller ID Lookup and Speed Dial\";s:8:\"category\";s:5:\"Admin\";s:9:\"menuitems\";a:1:{s:9:\"phonebook\";s:18:\"Asterisk Phonebook\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:9:\"Phonebook\";s:5:\"items\";a:1:{s:9:\"phonebook\";a:5:{s:4:\"name\";s:18:\"Asterisk Phonebook\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:10:\"phpagiconf\";a:15:{s:7:\"rawname\";s:10:\"phpagiconf\";s:4:\"repo\";s:11:\"unsupported\";s:4:\"name\";s:13:\"PHPAGI Config\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:8:\"Settings\";s:9:\"menuitems\";a:1:{s:10:\"phpagiconf\";s:13:\"PHPAGI Config\";}s:7:\"depends\";a:1:{s:6:\"module\";s:15:\"manager ge1.0.4\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:13:\"PHPAGI Config\";s:5:\"items\";a:1:{s:10:\"phpagiconf\";a:4:{s:4:\"name\";s:13:\"PHPAGI Config\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:7:\"phpinfo\";a:13:{s:7:\"rawname\";s:7:\"phpinfo\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:8:\"PHP Info\";s:7:\"version\";s:8:\"2.11.0.1\";s:9:\"publisher\";s:10:\"IssabelPBX\";s:7:\"license\";s:6:\"GPLv2+\";s:8:\"category\";s:7:\"Reports\";s:9:\"menuitems\";a:1:{s:7:\"phpinfo\";s:8:\"PHP Info\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:8:\"PHP Info\";s:5:\"items\";a:1:{s:7:\"phpinfo\";a:4:{s:4:\"name\";s:8:\"PHP Info\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:7:\"Reports\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.1\";}s:7:\"pinsets\";a:17:{s:7:\"rawname\";s:7:\"pinsets\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:8:\"PIN Sets\";s:7:\"version\";s:8:\"2.11.0.9\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:8:\"Settings\";s:11:\"description\";s:103:\"Allow creation of lists of PINs (numbers for passwords) that can be used by other modules (eg, trunks).\";s:9:\"menuitems\";a:1:{s:7:\"pinsets\";s:8:\"PIN Sets\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:7:\"depends\";a:1:{s:6:\"module\";s:4:\"core\";}s:11:\"displayname\";s:8:\"PIN Sets\";s:7:\"methods\";a:1:{s:10:\"get_config\";a:1:{i:481;a:1:{i:0;s:18:\"pinsets_get_config\";}}}s:5:\"items\";a:1:{s:7:\"pinsets\";a:4:{s:4:\"name\";s:8:\"PIN Sets\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.9\";}s:15:\"printextensions\";a:15:{s:7:\"rawname\";s:15:\"printextensions\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:16:\"Print Extensions\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:7:\"Reports\";s:11:\"description\";s:130:\"Creates a printable list of extension numbers used throughout the system from all modules that provide an internal callable number\";s:9:\"menuitems\";a:1:{s:15:\"printextensions\";s:16:\"Print Extensions\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:16:\"Print Extensions\";s:5:\"items\";a:1:{s:15:\"printextensions\";a:4:{s:4:\"name\";s:16:\"Print Extensions\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:7:\"Reports\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:9:\"queueprio\";a:17:{s:7:\"rawname\";s:9:\"queueprio\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:16:\"Queue Priorities\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:73:\"Adds the ability to set a callers priority higher before entering a queue\";s:9:\"menuitems\";a:1:{s:9:\"queueprio\";s:16:\"Queue Priorities\";}s:8:\"popovers\";a:1:{s:9:\"queueprio\";a:1:{s:7:\"display\";s:9:\"queueprio\";}}s:7:\"depends\";a:1:{s:7:\"version\";s:11:\"2.5.0alpha1\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:16:\"Queue Priorities\";s:5:\"items\";a:1:{s:9:\"queueprio\";a:4:{s:4:\"name\";s:16:\"Queue Priorities\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:6:\"queues\";a:17:{s:7:\"rawname\";s:6:\"queues\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:6:\"Queues\";s:7:\"version\";s:9:\"2.11.0.27\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv2+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-2.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:198:\"Creates a queue where calls are placed on hold and answered on a first-in, first-out basis. Many options are available, including ring strategy for agents, caller announcements, max wait times, etc.\";s:7:\"depends\";a:2:{s:7:\"version\";s:11:\"2.5.0alpha1\";s:6:\"module\";a:2:{i:0;s:19:\"recordings ge 3.3.8\";i:1;s:21:\"core ge 2.11.0.0rc1.2\";}}s:9:\"menuitems\";a:1:{s:6:\"queues\";s:6:\"Queues\";}s:8:\"popovers\";a:1:{s:6:\"queues\";a:1:{s:7:\"display\";s:6:\"queues\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:6:\"Queues\";s:5:\"items\";a:1:{s:6:\"queues\";a:5:{s:4:\"name\";s:6:\"Queues\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;s:13:\"needsenginedb\";s:3:\"yes\";}}s:6:\"status\";i:2;s:9:\"dbversion\";s:9:\"2.11.0.27\";}s:10:\"recordings\";a:17:{s:7:\"rawname\";s:10:\"recordings\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:10:\"Recordings\";s:7:\"version\";s:7:\"3.4.0.3\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:12:\"canuninstall\";s:2:\"no\";s:8:\"category\";s:5:\"Admin\";s:11:\"description\";s:76:\"Creates and manages system recordings, used by many other modules (eg, IVR).\";s:9:\"menuitems\";a:1:{s:10:\"recordings\";s:17:\"System Recordings\";}s:7:\"depends\";a:1:{s:7:\"version\";s:11:\"2.5.0alpha1\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:10:\"Recordings\";s:5:\"items\";a:1:{s:10:\"recordings\";a:4:{s:4:\"name\";s:17:\"System Recordings\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:7:\"3.4.0.3\";}s:7:\"restart\";a:16:{s:7:\"rawname\";s:7:\"restart\";s:4:\"repo\";s:11:\"unsupported\";s:4:\"name\";s:18:\"Bulk Phone Restart\";s:7:\"version\";s:8:\"2.11.0.2\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:5:\"Admin\";s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.5.0\";}s:11:\"description\";s:147:\"This module allows users to restart one or multiple phones that support being restarted via a SIP NOTIFY command through Asterisk\'s sip_notify.conf\";s:9:\"menuitems\";a:1:{s:7:\"restart\";s:13:\"Phone Restart\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:18:\"Bulk Phone Restart\";s:5:\"items\";a:1:{s:7:\"restart\";a:4:{s:4:\"name\";s:13:\"Phone Restart\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:5:\"Admin\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.2\";}s:10:\"ringgroups\";a:17:{s:7:\"rawname\";s:10:\"ringgroups\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:11:\"Ring Groups\";s:7:\"version\";s:8:\"2.11.0.6\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:317:\"Creates a group of extensions that all ring together. Extensions can be rung all at once, or in various \'hunt\' configurations. Additionally, external numbers are supported, and there is a call confirmation option where the callee has to confirm if they actually want to take the call before the caller is transferred.\";s:7:\"depends\";a:2:{s:7:\"version\";s:11:\"2.5.0alpha1\";s:6:\"module\";s:19:\"recordings ge 3.3.8\";}s:9:\"menuitems\";a:1:{s:10:\"ringgroups\";s:11:\"Ring Groups\";}s:8:\"popovers\";a:1:{s:10:\"ringgroups\";a:1:{s:7:\"display\";s:10:\"ringgroups\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:11:\"Ring Groups\";s:5:\"items\";a:1:{s:10:\"ringgroups\";a:4:{s:4:\"name\";s:11:\"Ring Groups\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.6\";}s:11:\"sipsettings\";a:18:{s:7:\"rawname\";s:11:\"sipsettings\";s:4:\"repo\";s:8:\"standard\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:4:\"name\";s:21:\"Asterisk SIP Settings\";s:7:\"version\";s:8:\"2.11.0.9\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:7:\"AGPLv3+\";s:11:\"licenselink\";s:40:\"http://www.gnu.org/licenses/agpl-3.0.txt\";s:8:\"category\";s:8:\"Settings\";s:9:\"menuitems\";a:1:{s:11:\"sipsettings\";s:21:\"Asterisk SIP Settings\";}s:11:\"description\";s:278:\"Use to configure Various Asterisk SIP Settings in the General section of sip.conf. Also includes an auto-configuration tool to determine NAT settings. The module assumes Asterisk version 1.4 or higher. Some settings may not exist in Asterisk 1.2 and will be ignored by Asterisk.\";s:7:\"depends\";a:1:{s:6:\"module\";s:23:\"core ge 2.11.0.0beta2.4\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:21:\"Asterisk SIP Settings\";s:5:\"items\";a:1:{s:11:\"sipsettings\";a:4:{s:4:\"name\";s:21:\"Asterisk SIP Settings\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.9\";}s:9:\"speeddial\";a:13:{s:7:\"rawname\";s:9:\"speeddial\";s:4:\"repo\";s:8:\"extended\";s:4:\"name\";s:20:\"Speed Dial Functions\";s:7:\"version\";s:8:\"2.11.0.4\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:8:\"Settings\";s:7:\"depends\";a:1:{s:6:\"module\";s:9:\"phonebook\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:20:\"Speed Dial Functions\";s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.4\";}s:14:\"timeconditions\";a:17:{s:7:\"rawname\";s:14:\"timeconditions\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:15:\"Time Conditions\";s:7:\"version\";s:8:\"2.11.1.1\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:238:\"Creates a condition where calls will go to one of two destinations (eg, an extension, IVR, ring group..) based on the time and/or date. This can be used for example to ring a receptionist during the day, or go directly to an IVR at night.\";s:7:\"depends\";a:1:{s:7:\"version\";s:11:\"2.5.0alpha1\";}s:9:\"menuitems\";a:2:{s:14:\"timeconditions\";s:15:\"Time Conditions\";s:10:\"timegroups\";s:11:\"Time Groups\";}s:8:\"popovers\";a:1:{s:14:\"timeconditions\";a:1:{s:7:\"display\";s:14:\"timeconditions\";}}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:15:\"Time Conditions\";s:5:\"items\";a:2:{s:14:\"timeconditions\";a:4:{s:4:\"name\";s:15:\"Time Conditions\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}s:10:\"timegroups\";a:4:{s:4:\"name\";s:11:\"Time Groups\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.1.1\";}s:7:\"vmblast\";a:17:{s:7:\"rawname\";s:7:\"vmblast\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:18:\"Voicemail Blasting\";s:7:\"version\";s:8:\"2.11.0.4\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:12:\"Applications\";s:11:\"description\";s:123:\"Creates a group of extensions that calls a group of voicemail boxes and allows you to leave a message for them all at once.\";s:9:\"menuitems\";a:1:{s:7:\"vmblast\";s:18:\"Voicemail Blasting\";}s:8:\"popovers\";a:1:{s:7:\"vmblast\";a:1:{s:7:\"display\";s:7:\"vmblast\";}}s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.4.0\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:11:\"displayname\";s:18:\"Voicemail Blasting\";s:5:\"items\";a:1:{s:7:\"vmblast\";a:4:{s:4:\"name\";s:18:\"Voicemail Blasting\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:12:\"Applications\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.4\";}s:9:\"voicemail\";a:18:{s:7:\"rawname\";s:9:\"voicemail\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:9:\"Voicemail\";s:7:\"version\";s:8:\"2.11.1.6\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:10:\"candisable\";s:2:\"no\";s:12:\"canuninstall\";s:2:\"no\";s:11:\"description\";s:69:\"This module allows you to configure Voicemail for a user or extension\";s:8:\"category\";s:8:\"Settings\";s:9:\"menuitems\";a:1:{s:9:\"voicemail\";s:15:\"Voicemail Admin\";}s:7:\"depends\";a:1:{s:7:\"version\";s:11:\"2.5.0alpha1\";}s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.11\";}s:11:\"displayname\";s:9:\"Voicemail\";s:5:\"items\";a:1:{s:9:\"voicemail\";a:4:{s:4:\"name\";s:15:\"Voicemail Admin\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:8:\"Settings\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.1.6\";}s:13:\"weakpasswords\";a:16:{s:7:\"rawname\";s:13:\"weakpasswords\";s:4:\"repo\";s:8:\"standard\";s:4:\"name\";s:23:\"Weak Password Detection\";s:7:\"version\";s:8:\"2.11.0.1\";s:9:\"publisher\";s:18:\"Issabel Foundation\";s:7:\"license\";s:6:\"GPLv3+\";s:11:\"licenselink\";s:39:\"http://www.gnu.org/licenses/gpl-3.0.txt\";s:8:\"category\";s:7:\"Reports\";s:7:\"depends\";a:1:{s:7:\"version\";s:5:\"2.5.0\";}s:11:\"description\";s:80:\"This module detects weak SIP secrets and sets security notifications accordingly\";s:9:\"supported\";a:1:{s:7:\"version\";s:4:\"2.10\";}s:9:\"menuitems\";a:1:{s:13:\"weakpasswords\";s:23:\"Weak Password Detection\";}s:11:\"displayname\";s:23:\"Weak Password Detection\";s:5:\"items\";a:1:{s:13:\"weakpasswords\";a:4:{s:4:\"name\";s:23:\"Weak Password Detection\";s:4:\"type\";s:5:\"setup\";s:8:\"category\";s:7:\"Reports\";s:4:\"sort\";i:0;}}s:6:\"status\";i:2;s:9:\"dbversion\";s:8:\"2.11.0.1\";}}'),('extmap_serialized',1635967347,'a:858:{i:33888018501;s:50:\"Conference: 1-MBB-20200330-3388801850-CONFERENCIA1\";i:33888018502;s:50:\"Conference: 1-MBB-20200330-3388801850-CONFERENCIA2\";i:33888018503;s:50:\"Conference: 1-MBB-20200330-3388801850-CONFERENCIA3\";i:33888018504;s:50:\"Conference: 1-MBB-20200330-3388801850-CONFERENCIA4\";i:33888018505;s:50:\"Conference: 1-MBB-20200330-3388801850-CONFERENCIA5\";i:55477766911;s:50:\"Conference: 1-MBB-20200330-5547776691-CONFERENCIA1\";i:55477766912;s:50:\"Conference: 1-MBB-20200330-5547776691-CONFERENCIA2\";i:55477766913;s:50:\"Conference: 1-MBB-20200330-5547776691-CONFERENCIA3\";i:55477766914;s:50:\"Conference: 1-MBB-20200330-5547776691-CONFERENCIA4\";i:55477766915;s:50:\"Conference: 1-MBB-20200330-5547776691-CONFERENCIA5\";i:81777001002;s:55:\"Conference: 1-BKP-20200318-8177700100-EQUIPO-TECNOLOGIA\";i:81777001003;s:55:\"Conference: 1-BKP-20200318-8177700100-EQUIPO-GLOBALBNET\";i:81777003631;s:52:\"Conference: 754-INM-20200429-8177700363-CONFERENCIA5\";i:81777003655;s:53:\"Conference: 1236-HIP-20200703-8177700365-CONFERENCIA5\";i:81777003685;s:54:\"Conference: 1234-FHAM-20200703-8177700368-CONFERENCIA5\";i:81777015715;s:54:\"Conference: 1220-FOR-20200422-81777015715-CONFERENCIA5\";i:81777015755;s:52:\"Conference: 927-KAI-20200331-8177701575-CONFERENCIA5\";i:81777026051;s:50:\"Conference: 1-MBB-20200330-8177702605-CONFERENCIA1\";i:81777026052;s:50:\"Conference: 1-MBB-20200330-8177702605-CONFERENCIA2\";i:81777026053;s:50:\"Conference: 1-MBB-20200330-8177702605-CONFERENCIA3\";i:81777026054;s:50:\"Conference: 1-MBB-20200330-8177702605-CONFERENCIA4\";i:81777026055;s:50:\"Conference: 1-MBB-20200330-8177702605-CONFERENCIA5\";s:3:\"*30\";s:57:\"Featurecode: blacklist_add (blacklist:Blacklist a number)\";s:3:\"*32\";s:65:\"Featurecode: blacklist_last (blacklist:Blacklist the last caller)\";s:3:\"*31\";s:76:\"Featurecode: blacklist_remove (blacklist:Remove a number from the blacklist)\";s:3:\"*72\";s:57:\"Featurecode: cfon (callforward:Call Forward All Activate)\";s:3:\"*73\";s:60:\"Featurecode: cfoff (callforward:Call Forward All Deactivate)\";s:4:\"*720\";s:68:\"Featurecode: cfpon (callforward:Call Forward All Prompting Activate)\";s:3:\"*74\";s:74:\"Featurecode: cfoff_any (callforward:Call Forward All Prompting Deactivate)\";s:3:\"*90\";s:59:\"Featurecode: cfbon (callforward:Call Forward Busy Activate)\";s:3:\"*91\";s:62:\"Featurecode: cfboff (callforward:Call Forward Busy Deactivate)\";s:4:\"*900\";s:70:\"Featurecode: cfbpon (callforward:Call Forward Busy Prompting Activate)\";s:3:\"*92\";s:76:\"Featurecode: cfboff_any (callforward:Call Forward Busy Prompting Deactivate)\";s:3:\"*52\";s:76:\"Featurecode: cfuon (callforward:Call Forward No Answer/Unavailable Activate)\";s:3:\"*53\";s:79:\"Featurecode: cfuoff (callforward:Call Forward No Answer/Unavailable Deactivate)\";s:4:\"*520\";s:87:\"Featurecode: cfupon (callforward:Call Forward No Answer/Unavailable Prompting Activate)\";s:4:\"*740\";s:56:\"Featurecode: cf_toggle (callforward:Call Forward Toggle)\";s:3:\"*70\";s:55:\"Featurecode: cwon (callwaiting:Call Waiting - Activate)\";s:3:\"*71\";s:58:\"Featurecode: cwoff (callwaiting:Call Waiting - Deactivate)\";s:3:\"*87\";s:56:\"Featurecode: conf_status (conferences:Conference Status)\";s:2:\"*8\";s:60:\"Featurecode: pickupexten (core:Asterisk General Call Pickup)\";i:555;s:35:\"Featurecode: chanspy (core:ChanSpy)\";s:2:\"**\";s:63:\"Featurecode: disconnect (core:In-Call Asterisk Disconnect Code)\";s:2:\"*2\";s:61:\"Featurecode: atxfer (core:In-Call Asterisk Attended Transfer)\";s:2:\"##\";s:61:\"Featurecode: blindxfer (core:In-Call Asterisk Blind Transfer)\";s:2:\"*1\";s:66:\"Featurecode: automon (core:In-Call Asterisk Toggle Call Recording)\";i:7777;s:52:\"Featurecode: simu_pstn (core:Simulate Incoming Call)\";s:3:\"*12\";s:42:\"Featurecode: userlogoff (core:User Logoff)\";s:3:\"*11\";s:40:\"Featurecode: userlogon (core:User Logon)\";i:888;s:37:\"Featurecode: zapbarge (core:ZapBarge)\";s:3:\"*28\";s:61:\"Featurecode: toggle-mode-all (daynight:All: Call Flow Toggle)\";s:3:\"*35\";s:60:\"Featurecode: senddictate (dictate:Email completed dictation)\";s:3:\"*34\";s:50:\"Featurecode: dodictate (dictate:Perform dictation)\";s:3:\"*78\";s:47:\"Featurecode: dnd_on (donotdisturb:DND Activate)\";s:3:\"*79\";s:50:\"Featurecode: dnd_off (donotdisturb:DND Deactivate)\";s:3:\"*76\";s:49:\"Featurecode: dnd_toggle (donotdisturb:DND Toggle)\";i:666;s:43:\"Featurecode: simu_fax (fax:Dial System FAX)\";s:3:\"*21\";s:59:\"Featurecode: fmf_toggle (findmefollow:Findme Follow Toggle)\";s:4:\"*422\";s:49:\"Featurecode: gabdial (gabcast:Connect to Gabcast)\";s:3:\"*69\";s:48:\"Featurecode: calltrace (infoservices:Call Trace)\";s:3:\"*43\";s:46:\"Featurecode: echotest (infoservices:Echo Test)\";s:3:\"*65\";s:65:\"Featurecode: speakextennum (infoservices:Speak Your Exten Number)\";s:3:\"*60\";s:56:\"Featurecode: speakingclock (infoservices:Speaking Clock)\";s:3:\"*85\";s:58:\"Featurecode: parkedcall (parking:Pickup ParkedCall Prefix)\";i:411;s:75:\"Featurecode: app-pbdirectory (pbdirectory:Phonebook dial-by-name directory)\";s:3:\"*47\";s:47:\"Featurecode: que_callers (queues:Queue Callers)\";s:3:\"*46\";s:57:\"Featurecode: que_pause_toggle (queues:Queue Pause Toggle)\";s:3:\"*45\";s:45:\"Featurecode: que_toggle (queues:Queue Toggle)\";s:3:\"*99\";s:54:\"Featurecode: record_check (recordings:Check Recording)\";s:3:\"*77\";s:52:\"Featurecode: record_save (recordings:Save Recording)\";s:3:\"*75\";s:57:\"Featurecode: setspeeddial (speeddial:Set user speed dial)\";s:2:\"*0\";s:55:\"Featurecode: callspeeddial (speeddial:Speeddial prefix)\";s:3:\"*27\";s:74:\"Featurecode: toggle-mode-all (timeconditions:All: Time Condition Override)\";s:3:\"*98\";s:53:\"Featurecode: dialvoicemail (voicemail:Dial Voicemail)\";s:1:\"*\";s:63:\"Featurecode: directdialvoicemail (voicemail:Direct Dial Prefix)\";s:3:\"*97\";s:49:\"Featurecode: myvoicemail (voicemail:My Voicemail)\";s:0:\"\";s:32:\"ParkPlus: PickupSlot Default Lot\";i:1;s:32:\"ParkPlus: PickupSlot Default Lot\";i:2;s:32:\"ParkPlus: PickupSlot Default Lot\";i:3;s:32:\"ParkPlus: PickupSlot Default Lot\";i:1000;s:11:\"Queue: cola\";i:10011;s:12:\"Queue: 10011\";i:1008177700100;s:24:\"Queue: 1008177700100-ESP\";i:1018177700100;s:24:\"Queue: 1018177700100-ESP\";i:103335605355;s:23:\"Queue: 103335605355-ESP\";i:105588804680;s:23:\"Queue: 105588804680-ESP\";i:108147370215;s:19:\"Queue: 108147370215\";i:108177700100;s:23:\"Queue: 108177700100-ESP\";i:113335605355;s:23:\"Queue: 113335605355-ESP\";i:115588804680;s:23:\"Queue: 115588804680-ESP\";i:118177700100;s:23:\"Queue: 118177700100-ESP\";i:12226443774;s:22:\"Queue: 12226443774-ESP\";i:12228800361;s:22:\"Queue: 12228800361-ESP\";i:123335605355;s:23:\"Queue: 123335605355-ESP\";i:125588804680;s:23:\"Queue: 125588804680-ESP\";i:128177700100;s:23:\"Queue: 128177700100-ESP\";i:133335605355;s:23:\"Queue: 133335605355-ESP\";i:13335605354;s:22:\"Queue: 13335605354-ESP\";i:13335605356;s:22:\"Queue: 13335605356-ESP\";i:13335605357;s:22:\"Queue: 13335605357-ESP\";i:13388800130;s:22:\"Queue: 13388800130-ESP\";i:13388800131;s:22:\"Queue: 13388800131-ESP\";i:13388800133;s:22:\"Queue: 13388800133-ESP\";i:13388800134;s:22:\"Queue: 13388800134-ESP\";i:13388801850;s:18:\"Queue: 13388801850\";i:135588804680;s:23:\"Queue: 135588804680-ESP\";i:138177700100;s:23:\"Queue: 138177700100-ESP\";i:14428880130;s:22:\"Queue: 14428880130-ESP\";i:14428880131;s:22:\"Queue: 14428880131-ESP\";i:14428880132;s:22:\"Queue: 14428880132-ESP\";i:14428880133;s:22:\"Queue: 14428880133-ESP\";i:15000000000;s:22:\"Queue: 15000000000-ESP\";i:15547776691;s:22:\"Queue: 15547776691-ESP\";i:15588804680;s:22:\"Queue: 15588804680-ESP\";i:15588804681;s:22:\"Queue: 15588804681-ESP\";i:15588804682;s:22:\"Queue: 15588804682-ESP\";i:15588804683;s:22:\"Queue: 15588804683-ESP\";i:15588804684;s:22:\"Queue: 15588804684-ESP\";i:15588804685;s:22:\"Queue: 15588804685-ESP\";i:15588804686;s:22:\"Queue: 15588804686-ESP\";i:15588804687;s:22:\"Queue: 15588804687-ESP\";i:15588804688;s:22:\"Queue: 15588804688-ESP\";i:15589958531;s:22:\"Queue: 15589958531-ESP\";i:15589958532;s:22:\"Queue: 15589958532-ESP\";i:15589958533;s:22:\"Queue: 15589958533-ESP\";i:15589958534;s:22:\"Queue: 15589958534-ESP\";i:15589958535;s:22:\"Queue: 15589958535-ESP\";i:15589958536;s:22:\"Queue: 15589958536-ESP\";i:15589958540;s:22:\"Queue: 15589958540-ESP\";i:18147370215;s:22:\"Queue: 18147370215-ESP\";i:18147370216;s:22:\"Queue: 18147370216-ESP\";i:18147370217;s:22:\"Queue: 18147370217-ESP\";i:18147370218;s:22:\"Queue: 18147370218-ESP\";i:18147370221;s:22:\"Queue: 18147370221-ESP\";i:18147370224;s:22:\"Queue: 18147370224-ESP\";i:18147370226;s:22:\"Queue: 18147370226-ESP\";i:18147370227;s:22:\"Queue: 18147370227-ESP\";i:18147370229;s:22:\"Queue: 18147370229-ESP\";i:18147370230;s:22:\"Queue: 18147370230-ESP\";i:18147370231;s:22:\"Queue: 18147370231-ESP\";i:18147370232;s:22:\"Queue: 18147370232-ESP\";i:18147370233;s:22:\"Queue: 18147370233-ESP\";i:18147370234;s:22:\"Queue: 18147370234-ESP\";i:18147370235;s:22:\"Queue: 18147370235-ESP\";i:18147370237;s:22:\"Queue: 18147370237-ESP\";i:18147370238;s:22:\"Queue: 18147370238-ESP\";i:18147370239;s:22:\"Queue: 18147370239-ESP\";i:18147370240;s:22:\"Queue: 18147370240-ESP\";i:18147370241;s:21:\"Queue: 8147370241-ESP\";i:18147370242;s:22:\"Queue: 18147370242-ESP\";i:18147370244;s:22:\"Queue: 18147370244-ESP\";i:18147370245;s:22:\"Queue: 18147370245-ESP\";i:18147370246;s:22:\"Queue: 18147370246-ESP\";i:18147370247;s:22:\"Queue: 18147370247-ESP\";i:18147773870;s:22:\"Queue: 18147773870-ESP\";i:18147773871;s:22:\"Queue: 18147773871-ESP\";i:18147773872;s:22:\"Queue: 18147773872-ESP\";i:18147773873;s:22:\"Queue: 18147773873-ESP\";i:18147773874;s:22:\"Queue: 18147773874-ESP\";i:18147773875;s:22:\"Queue: 18147773875-ESP\";i:18147773876;s:22:\"Queue: 18147773876-ESP\";i:18147773877;s:22:\"Queue: 18147773877-ESP\";i:18147773878;s:22:\"Queue: 18147773878-ESP\";i:18147773879;s:22:\"Queue: 18147773879-ESP\";i:18147773881;s:22:\"Queue: 18147773881-ESP\";i:18147773882;s:22:\"Queue: 18147773882-ESP\";i:18147773883;s:22:\"Queue: 18147773883-ESP\";i:18147773884;s:22:\"Queue: 18147773884-ESP\";i:18147773885;s:22:\"Queue: 18147773885-ESP\";i:18147773887;s:22:\"Queue: 18147773887-ESP\";i:18147773888;s:22:\"Queue: 18147773888-ESP\";i:18147773889;s:22:\"Queue: 18147773889-ESP\";i:18147773890;s:22:\"Queue: 18147773890-ESP\";i:18147773892;s:22:\"Queue: 18147773892-ESP\";i:18147773894;s:22:\"Queue: 18147773894-ESP\";i:18177700100;s:22:\"Queue: 18177700100-ESP\";i:18177700101;s:22:\"Queue: 18177700101-ESP\";i:18177700102;s:22:\"Queue: 18177700102-ESP\";i:18177700103;s:22:\"Queue: 18177700103-ESP\";i:18177700104;s:22:\"Queue: 18177700104-ESP\";i:18177700105;s:22:\"Queue: 18177700105-ESP\";i:18177700106;s:22:\"Queue: 18177700106-ESP\";i:18177700107;s:22:\"Queue: 18177700107-ESP\";i:18177700108;s:22:\"Queue: 18177700108-ESP\";i:18177700109;s:22:\"Queue: 18177700109-ESP\";i:18177700110;s:22:\"Queue: 18177700110-ESP\";i:18177700111;s:22:\"Queue: 18177700111-ESP\";i:18177700112;s:22:\"Queue: 18177700112-ESP\";i:18177700113;s:22:\"Queue: 18177700113-ESP\";i:18177700114;s:22:\"Queue: 18177700114-ESP\";i:18177700115;s:22:\"Queue: 18177700115-ESP\";i:18177700116;s:22:\"Queue: 18177700116-ESP\";i:18177700117;s:22:\"Queue: 18177700117-ESP\";i:18177700118;s:22:\"Queue: 18177700118-ESP\";i:18177700119;s:22:\"Queue: 18177700119-ESP\";i:18177700120;s:22:\"Queue: 18177700120-ESP\";i:18177700121;s:22:\"Queue: 18177700121-ESP\";i:18177700122;s:22:\"Queue: 18177700122-ESP\";i:18177700123;s:22:\"Queue: 18177700123-ESP\";i:18177700124;s:22:\"Queue: 18177700124-ESP\";i:18177700360;s:22:\"Queue: 18177700360-ESP\";i:18177700361;s:22:\"Queue: 18177700361-ESP\";i:18177700362;s:22:\"Queue: 18177700362-ESP\";i:18177700363;s:22:\"Queue: 18177700363-ESP\";i:18177700364;s:22:\"Queue: 18177700364-ESP\";i:18177700365;s:22:\"Queue: 18177700365-ESP\";i:18177700366;s:22:\"Queue: 18177700366-ESP\";i:18177700367;s:22:\"Queue: 18177700367-ESP\";i:18177700368;s:22:\"Queue: 18177700368-ESP\";i:18177700369;s:22:\"Queue: 18177700369-ESP\";i:18177700370;s:22:\"Queue: 18177700370-ESP\";i:18177700371;s:22:\"Queue: 18177700371-ESP\";i:18177700372;s:22:\"Queue: 18177700372-ESP\";i:18177700373;s:22:\"Queue: 18177700373-ESP\";i:18177700374;s:22:\"Queue: 18177700374-ESP\";i:18177700375;s:22:\"Queue: 18177700375-ESP\";i:18177700376;s:22:\"Queue: 18177700376-ESP\";i:18177700377;s:22:\"Queue: 18177700377-ESP\";i:18177700378;s:22:\"Queue: 18177700378-ESP\";i:18177700379;s:22:\"Queue: 18177700379-ESP\";i:18177700380;s:22:\"Queue: 18177700380-ESP\";i:18177700381;s:22:\"Queue: 18177700381-ESP\";i:18177700382;s:22:\"Queue: 18177700382-ESP\";i:18177700383;s:22:\"Queue: 18177700383-ESP\";i:18177700384;s:22:\"Queue: 18177700384-ESP\";i:18177700385;s:22:\"Queue: 18177700385-ESP\";i:18177700386;s:22:\"Queue: 18177700386-ESP\";i:18177700387;s:22:\"Queue: 18177700387-ESP\";i:18177700388;s:22:\"Queue: 18177700388-ESP\";i:18177700389;s:22:\"Queue: 18177700389-ESP\";i:18177700670;s:22:\"Queue: 18177700670-ESP\";i:18177700671;s:22:\"Queue: 18177700671-ESP\";i:18177700672;s:22:\"Queue: 18177700672-ESP\";i:18177700673;s:22:\"Queue: 18177700673-ESP\";i:18177700674;s:22:\"Queue: 18177700674-ESP\";i:18177700675;s:22:\"Queue: 18177700675-ESP\";i:18177700676;s:22:\"Queue: 18177700676-ESP\";i:18177700677;s:22:\"Queue: 18177700677-ESP\";i:18177700678;s:22:\"Queue: 18177700678-ESP\";i:18177700679;s:22:\"Queue: 18177700679-ESP\";i:18177700680;s:22:\"Queue: 18177700680-ESP\";i:18177700681;s:22:\"Queue: 18177700681-ESP\";i:18177700682;s:22:\"Queue: 18177700682-ESP\";i:18177700683;s:22:\"Queue: 18177700683-ESP\";i:18177700684;s:22:\"Queue: 18177700684-ESP\";i:18177700685;s:22:\"Queue: 18177700685-ESP\";i:18177700686;s:22:\"Queue: 18177700686-ESP\";i:18177700687;s:22:\"Queue: 18177700687-ESP\";i:18177700688;s:22:\"Queue: 18177700688-ESP\";i:18177700689;s:22:\"Queue: 18177700689-ESP\";i:18177700690;s:22:\"Queue: 18177700690-ESP\";i:18177700691;s:22:\"Queue: 18177700691-ESP\";i:18177700692;s:22:\"Queue: 18177700692-ESP\";i:18177700693;s:22:\"Queue: 18177700693-ESP\";i:18177700694;s:22:\"Queue: 18177700694-ESP\";i:18177700695;s:22:\"Queue: 18177700695-ESP\";i:18177700696;s:22:\"Queue: 18177700696-ESP\";i:18177700697;s:22:\"Queue: 18177700697-ESP\";i:18177700698;s:22:\"Queue: 18177700698-ESP\";i:18177700699;s:24:\"Queue: 18177700699-BK-FB\";i:18177701550;s:22:\"Queue: 18177701550-ESP\";i:18177701551;s:22:\"Queue: 18177701551-ESP\";i:18177701552;s:22:\"Queue: 18177701552-ESP\";i:18177701553;s:22:\"Queue: 18177701553-ESP\";i:18177701554;s:22:\"Queue: 18177701554-ESP\";i:18177701555;s:22:\"Queue: 18177701555-ESP\";i:18177701556;s:22:\"Queue: 18177701556-ESP\";i:18177701557;s:22:\"Queue: 18177701557-ESP\";i:18177701558;s:22:\"Queue: 18177701558-ESP\";i:18177701559;s:22:\"Queue: 18177701559-ESP\";i:18177701560;s:22:\"Queue: 18177701560-ESP\";i:18177701561;s:22:\"Queue: 18177701561-ESP\";i:18177701562;s:22:\"Queue: 18177701562-ESP\";i:18177701563;s:22:\"Queue: 18177701563-ESP\";i:18177701564;s:22:\"Queue: 18177701564-ESP\";i:18177701565;s:22:\"Queue: 18177701565-ESP\";i:18177701566;s:22:\"Queue: 18177701566-ESP\";i:18177701567;s:22:\"Queue: 18177701567-ESP\";i:18177701568;s:22:\"Queue: 18177701568-ESP\";i:18177701569;s:22:\"Queue: 18177701569-esp\";i:18177701570;s:22:\"Queue: 18177701570-ESP\";i:18177701571;s:22:\"Queue: 18177701571-ESP\";i:18177701572;s:22:\"Queue: 18177701572-ESP\";i:18177701573;s:22:\"Queue: 18177701573-ESP\";i:18177701574;s:22:\"Queue: 18177701574-ESP\";i:18177701575;s:22:\"Queue: 18177701575-ESP\";i:18177701576;s:22:\"Queue: 18177701576-ESP\";i:18177701577;s:22:\"Queue: 18177701577-ESP\";i:18177701578;s:22:\"Queue: 18177701578-ESP\";i:18177701579;s:22:\"Queue: 18177701579-ESP\";i:18177702600;s:22:\"Queue: 18177702600-ESP\";i:18177702601;s:22:\"Queue: 18177702601-ESP\";i:18177702603;s:22:\"Queue: 18177702603-ESP\";i:18177702604;s:22:\"Queue: 18177702604-ESP\";i:18177702605;s:22:\"Queue: 18177702605-ESP\";i:18177702606;s:22:\"Queue: 18177702606-ESP\";i:183335605355;s:23:\"Queue: 183335605355-ESP\";i:18447770070;s:22:\"Queue: 18447770070-ESP\";i:185588804680;s:23:\"Queue: 185588804680-ESP\";i:18718800151;s:18:\"Queue: 18718800151\";i:18718800152;s:22:\"Queue: 18718800152-ESP\";i:18718800153;s:22:\"Queue: 18718800153-ESP\";i:18718800156;s:22:\"Queue: 18718800156-ESP\";i:188177700100;s:23:\"Queue: 188177700100-ESP\";i:193335605355;s:23:\"Queue: 193335605355-ING\";i:195588804680;s:23:\"Queue: 195588804680-ESP\";i:198177700100;s:23:\"Queue: 198177700100-ING\";i:19847770190;s:22:\"Queue: 19847770190-ESP\";i:19847770191;s:21:\"Queue: 19847770191ESP\";i:19847770192;s:22:\"Queue: 19847770192-ESP\";i:19847770193;s:22:\"Queue: 19847770193-ESP\";i:19847770194;s:22:\"Queue: 19847770194-ESP\";i:19847770196;s:22:\"Queue: 19847770196-ESP\";i:19847770197;s:22:\"Queue: 19847770197-ESP\";i:19988001966;s:22:\"Queue: 19988001966-ESP\";i:19988001967;s:22:\"Queue: 19988001967-ESP\";i:208177700100;s:23:\"Queue: 208177700100-ESP\";i:28147370215;s:22:\"Queue: 28147370215-ESP\";i:28177700100;s:39:\"Queue: 28177700100-QUIERO-QUE-ME-LLAMEN\";i:28177700388;s:18:\"Queue: 28177700388\";i:28177700690;s:22:\"Queue: 28177700690-ESP\";i:28177702601;s:22:\"Queue: 28177702601-ESP\";i:308147370215;s:23:\"Queue: 308147370215-ESP\";i:308177700100;s:23:\"Queue: 308177700100-ESP\";i:318177700100;s:19:\"Queue: 318177700100\";i:328177700100;s:23:\"Queue: 328177700100-ESP\";i:38177700100;s:39:\"Queue: 38177700100-QUIERO-QUE-ME-LLAMEN\";i:48177700100;s:39:\"Queue: 48177700100-QUIERO-QUE-ME-LLAMEN\";i:58177700100;s:39:\"Queue: 58177700100-QUIERO-QUE-ME-LLAMEN\";i:98147370215;s:22:\"Queue: 98147370215-ING\";i:98177700100;s:22:\"Queue: 98177700100-ING\";i:600;s:39:\"Ring Group: 1-BKP-20170920-8147370215-1\";i:601;s:39:\"Ring Group: 1-BKP-20170920-8147370215-2\";i:602;s:39:\"Ring Group: 1-BKP-20170920-5589958540-1\";i:603;s:39:\"Ring Group: 1-BKP-20170920-5589958540-2\";i:605;s:39:\"Ring Group: 1-BKP-20170920-3335605355-2\";i:606;s:39:\"Ring Group: 1-BKP-20170920-8147370215-9\";i:607;s:39:\"Ring Group: 1-BKP-20170920-5589958540-9\";i:608;s:39:\"Ring Group: 1-BKP-20170920-3335605355-9\";i:609;s:39:\"Ring Group: 1-BKP-20170920-3335605355-1\";i:610;s:41:\"Ring Group: 493-OXI-20170926-8147370216-1\";i:611;s:41:\"Ring Group: 547-TOD-20170926-8147370221-1\";i:612;s:41:\"Ring Group: 555-ATD-20170926-8147370224-1\";i:613;s:41:\"Ring Group: 556-BRO-20170926-8147370226-1\";i:614;s:41:\"Ring Group: 561-COM-20170927-8147370227-1\";i:616;s:41:\"Ring Group: 531-SER-20170927-8147370230-1\";i:617;s:41:\"Ring Group: 558-SER-20170927-8147370233-1\";i:618;s:41:\"Ring Group: 566-BER-20170927-8147370234-1\";i:619;s:41:\"Ring Group: 580-DQE-20170927-8147370237-1\";i:620;s:41:\"Ring Group: 581-AMM-20170927-8147370238-1\";i:629;s:41:\"Ring Group: 564-PRO-20170927-5589958533-1\";i:638;s:39:\"Ring Group: 1-BKP-20170928-8177700100-1\";i:639;s:39:\"Ring Group: 1-BKP-20170928-8177700100-2\";i:640;s:39:\"Ring Group: 1-BKP-20170928-8177700100-9\";i:641;s:39:\"Ring Group: 1-BKP-20170928-5588804680-1\";i:642;s:39:\"Ring Group: 1-BKP-20170928-5588804680-2\";i:643;s:39:\"Ring Group: 1-BKP-20170928-5588804680-9\";i:644;s:39:\"Ring Group: 1-BKP-20170928-3388800130-1\";i:645;s:39:\"Ring Group: 1-BKP-20170928-3388800130-2\";i:646;s:39:\"Ring Group: 1-BKP-20170928-3388800130-9\";i:653;s:39:\"Ring Group: 1-BKP-20170928-8447770070-1\";i:654;s:39:\"Ring Group: 1-BKP-20170928-8447770070-2\";i:655;s:39:\"Ring Group: 1-BKP-20170928-8447770070-9\";i:656;s:42:\"Ring Group: 1-BKP-20171113-8177700100-1000\";i:657;s:42:\"Ring Group: 1-BKP-20171113-8177700100-1111\";i:658;s:42:\"Ring Group: 1-BKP-20171113-8177700100-1112\";i:659;s:42:\"Ring Group: 1-BKP-20171113-8177700100-1114\";i:660;s:42:\"Ring Group: 1-BKP-20171113-8177700100-1115\";i:661;s:41:\"Ring Group: 655-CAM-20180109-8177700388-1\";i:663;s:41:\"Ring Group: 655-CAM-20180109-8177700388-2\";i:664;s:41:\"Ring Group: 655-CAM-20180109-8177700388-3\";i:665;s:41:\"Ring Group: 655-CAM-20180109-8177700388-4\";i:667;s:41:\"Ring Group: 655-CAM-20180109-8177700388-5\";i:668;s:42:\"Ring Group: 1-BKP-20180124-5588804680-1000\";i:669;s:42:\"Ring Group: 1-BKP-20180124-5588804680-1111\";i:670;s:42:\"Ring Group: 1-BKP-20180124-5588804680-1112\";i:671;s:42:\"Ring Group: 1-BKP-20180124-5588804680-1114\";i:672;s:42:\"Ring Group: 1-BKP-20180124-5588804680-1115\";i:673;s:39:\"Ring Group: 1-BKP-20180124-5588804680-2\";i:674;s:42:\"Ring Group: 1-BKP-20180124-3335605355-1000\";i:675;s:42:\"Ring Group: 1-BKP-20180124-3335605355-1111\";i:676;s:42:\"Ring Group: 1-BKP-20180124-3335605355-1112\";i:677;s:42:\"Ring Group: 1-BKP-20180124-3335605355-1114\";i:678;s:42:\"Ring Group: 1-BKP-20180124-3335605355-1115\";i:680;s:39:\"Ring Group: 1-BKP-20180124-3335605355-2\";i:681;s:41:\"Ring Group: 563-SUO-20180619-8147370229-1\";i:682;s:39:\"Ring Group: 1-VIS-20181221-8177701563-1\";i:683;s:41:\"Ring Group: 917-AVA-20190130-8718800154-1\";i:686;s:41:\"Ring Group: 706-LUX-20190531-2228800360-1\";i:687;s:42:\"Ring Group: 1027-MIL-20190621-8147773886-1\";i:688;s:41:\"Ring Group: 880-VER-20190619-8177701557-1\";i:689;s:42:\"Ring Group: 1027-MIL-20190621-8147773886-2\";i:690;s:42:\"Ring Group: 1027-MIL-20190621-8147773886-3\";i:691;s:42:\"Ring Group: 1027-MIL-20190621-8147773886-0\";i:693;s:42:\"Ring Group: 1046-ERP-20190724-9847770195-1\";i:694;s:42:\"Ring Group: 1050-INM-20190823-8147773892-1\";i:697;s:42:\"Ring Group: 1046-ERP-20190724-2228800362-1\";i:700;s:42:\"Ring Group: 1046-ERP-20190724-2297770470-1\";i:701;s:42:\"Ring Group: 1123-AIP-20191107-8177702602-1\";i:702;s:42:\"Ring Group: 1123-AIP-20191107-8177702602-2\";i:703;s:42:\"Ring Group: 1123-AIP-20191107-8177702602-3\";i:704;s:42:\"Ring Group: 1123-AIP-20191107-8177702602-4\";i:705;s:42:\"Ring Group: 1124-ARR-20191112-8177702603-1\";i:709;s:42:\"Ring Group: 1221-CAP-20200417-3388800134-1\";i:710;s:42:\"Ring Group: 1221-CAP-20200417-3388800134-2\";i:711;s:42:\"Ring Group: 1221-CAP-20200417-3388800134-3\";i:712;s:42:\"Ring Group: 1221-CAP-20200417-3388800134-4\";i:713;s:41:\"Ring Group: 1-BKP-20200507-8177700388-100\";i:714;s:42:\"Ring Group: 1227-VIB-20200603-8177700683-1\";i:715;s:42:\"Ring Group: 1227-VIB-20200603-8177700683-2\";i:716;s:42:\"Ring Group: 1227-VIB-20200603-8177700683-3\";i:717;s:42:\"Ring Group: 1227-VIB-20200603-8177700683-4\";i:718;s:39:\"Ring Group: 1-BKP-20200603-8177700388-1\";i:724;s:39:\"Ring Group: 1-TEK-20210106-8177702601-1\";i:725;s:39:\"Ring Group: 1-TEK-20210106-8177702601-2\";i:726;s:39:\"Ring Group: 1-TEK-20210106-8177702601-3\";i:732;s:42:\"Ring Group: 1309-TEC-20210210-8147773890-2\";i:733;s:42:\"Ring Group: 1309-TEC-20210210-8147773890-3\";i:734;s:42:\"Ring Group: 1309-TEC-20210210-8147773890-1\";i:735;s:42:\"Ring Group: 1343-DR8-20210421-8177702606-1\";i:736;s:42:\"Ring Group: 1343-DR8-20210421-8177702606-2\";i:737;s:42:\"Ring Group: 1343-DR8-20210421-8177702606-3\";i:738;s:42:\"Ring Group: 1343-DR8-20210421-8177702606-4\";i:739;s:42:\"Ring Group: 1421-FIV-20211015-8177700108-1\";i:740;s:42:\"Ring Group: 1421-FIV-20211015-8177700108-2\";i:500;s:41:\"Voicemail Group: Bkpital-Voicemail-ingles\";i:1001;s:20:\"User Extension: 1001\";i:1002;s:20:\"User Extension: 1002\";i:2000;s:20:\"User Extension: 2000\";i:2001;s:20:\"User Extension: 2001\";i:2002;s:20:\"User Extension: 2002\";i:2003;s:20:\"User Extension: 2003\";i:2004;s:20:\"User Extension: 2004\";i:2005;s:20:\"User Extension: 2005\";i:2006;s:20:\"User Extension: 2006\";i:2007;s:20:\"User Extension: 2007\";i:2008;s:20:\"User Extension: 2008\";i:2009;s:20:\"User Extension: 2009\";i:2010;s:20:\"User Extension: 2010\";i:2011;s:20:\"User Extension: 2011\";i:3001;s:20:\"User Extension: 3001\";i:2226443774;s:26:\"User Extension: 2226443774\";i:2226443775;s:26:\"User Extension: 2226443775\";i:2226443776;s:26:\"User Extension: 2226443776\";i:2226443777;s:26:\"User Extension: 2226443777\";i:2226443778;s:26:\"User Extension: 2226443778\";i:2228800360;s:26:\"User Extension: 2228800360\";i:2228800361;s:26:\"User Extension: 2228800361\";i:2228800362;s:26:\"User Extension: 2228800362\";i:2228800363;s:26:\"User Extension: 2228800363\";i:2228800364;s:26:\"User Extension: 2228800364\";i:2297770470;s:26:\"User Extension: 2297770470\";i:2297770471;s:26:\"User Extension: 2297770471\";i:2297770472;s:26:\"User Extension: 2297770472\";i:2297770473;s:26:\"User Extension: 2297770473\";i:2297770474;s:26:\"User Extension: 2297770474\";i:2717770360;s:26:\"User Extension: 2717770360\";i:2717770361;s:26:\"User Extension: 2717770361\";i:2717770362;s:26:\"User Extension: 2717770362\";i:2717770363;s:26:\"User Extension: 2717770363\";i:2717770364;s:26:\"User Extension: 2717770364\";i:3335605354;s:26:\"User Extension: 3335605354\";i:3335605355;s:26:\"User Extension: 3335605355\";i:3335605356;s:26:\"User Extension: 3335605356\";i:3335605357;s:26:\"User Extension: 3335605357\";i:3335605358;s:26:\"User Extension: 3335605358\";i:3388800130;s:26:\"User Extension: 3388800130\";i:3388800131;s:26:\"User Extension: 3388800131\";i:3388800132;s:26:\"User Extension: 3388800132\";i:3388800133;s:26:\"User Extension: 3388800133\";i:3388800134;s:26:\"User Extension: 3388800134\";i:3388801850;s:26:\"User Extension: 3388801850\";i:3388801851;s:26:\"User Extension: 3388801851\";i:3388801852;s:26:\"User Extension: 3388801852\";i:3388801853;s:26:\"User Extension: 3388801853\";i:3388801854;s:26:\"User Extension: 3388801854\";i:4428880130;s:26:\"User Extension: 4428880130\";i:4428880131;s:26:\"User Extension: 4428880131\";i:4428880132;s:26:\"User Extension: 4428880132\";i:4428880133;s:26:\"User Extension: 4428880133\";i:4428880134;s:26:\"User Extension: 4428880134\";i:4428880135;s:26:\"User Extension: 4428880135\";i:4428880136;s:26:\"User Extension: 4428880136\";i:4428880137;s:26:\"User Extension: 4428880137\";i:4428880138;s:26:\"User Extension: 4428880138\";i:4428880139;s:26:\"User Extension: 4428880139\";i:4428881640;s:26:\"User Extension: 4428881640\";i:4428881641;s:26:\"User Extension: 4428881641\";i:4428881642;s:26:\"User Extension: 4428881642\";i:4428881643;s:26:\"User Extension: 4428881643\";i:4428881644;s:26:\"User Extension: 4428881644\";i:4428881710;s:26:\"User Extension: 4428881710\";i:4428881711;s:26:\"User Extension: 4428881711\";i:4428881712;s:26:\"User Extension: 4428881712\";i:4428881713;s:26:\"User Extension: 4428881713\";i:4428881714;s:26:\"User Extension: 4428881714\";i:4448880540;s:26:\"User Extension: 4448880540\";i:4448880541;s:26:\"User Extension: 4448880541\";i:4448880542;s:26:\"User Extension: 4448880542\";i:4448880543;s:26:\"User Extension: 4448880543\";i:4448880544;s:26:\"User Extension: 4448880544\";i:4617770040;s:26:\"User Extension: 4617770040\";i:4617770041;s:26:\"User Extension: 4617770041\";i:4617770042;s:26:\"User Extension: 4617770042\";i:4617770043;s:26:\"User Extension: 4617770043\";i:4617770044;s:26:\"User Extension: 4617770044\";i:4627770400;s:26:\"User Extension: 4627770400\";i:4627770401;s:26:\"User Extension: 4627770401\";i:4627770402;s:26:\"User Extension: 4627770402\";i:4627770403;s:26:\"User Extension: 4627770403\";i:4627770404;s:26:\"User Extension: 4627770404\";i:4778880150;s:26:\"User Extension: 4778880150\";i:4778880151;s:26:\"User Extension: 4778880151\";i:4778880152;s:26:\"User Extension: 4778880152\";i:4778880153;s:26:\"User Extension: 4778880153\";i:4778880154;s:26:\"User Extension: 4778880154\";i:4778880155;s:26:\"User Extension: 4778880155\";i:4778880156;s:26:\"User Extension: 4778880156\";i:4778880157;s:26:\"User Extension: 4778880157\";i:4778880158;s:26:\"User Extension: 4778880158\";i:4778880159;s:26:\"User Extension: 4778880159\";i:4778880355;s:26:\"User Extension: 4778880355\";i:4778880356;s:26:\"User Extension: 4778880356\";i:4778880357;s:26:\"User Extension: 4778880357\";i:4778880358;s:26:\"User Extension: 4778880358\";i:4778880359;s:26:\"User Extension: 4778880359\";i:5547748640;s:26:\"User Extension: 5547748640\";i:5547748641;s:26:\"User Extension: 5547748641\";i:5547748642;s:26:\"User Extension: 5547748642\";i:5547748643;s:26:\"User Extension: 5547748643\";i:5547748644;s:26:\"User Extension: 5547748644\";i:5547748645;s:26:\"User Extension: 5547748645\";i:5547748646;s:26:\"User Extension: 5547748646\";i:5547748647;s:26:\"User Extension: 5547748647\";i:5547748648;s:26:\"User Extension: 5547748648\";i:5547748649;s:26:\"User Extension: 5547748649\";i:5547776690;s:26:\"User Extension: 5547776690\";i:5547776691;s:26:\"User Extension: 5547776691\";i:5547776692;s:26:\"User Extension: 5547776692\";i:5547776693;s:26:\"User Extension: 5547776693\";i:5547776694;s:26:\"User Extension: 5547776694\";i:5547776695;s:26:\"User Extension: 5547776695\";i:5547776696;s:26:\"User Extension: 5547776696\";i:5547776697;s:26:\"User Extension: 5547776697\";i:5547776698;s:26:\"User Extension: 5547776698\";i:5547776699;s:26:\"User Extension: 5547776699\";i:5588804680;s:26:\"User Extension: 5588804680\";i:5588804681;s:26:\"User Extension: 5588804681\";i:5588804682;s:26:\"User Extension: 5588804682\";i:5588804683;s:26:\"User Extension: 5588804683\";i:5588804684;s:26:\"User Extension: 5588804684\";i:5588804685;s:26:\"User Extension: 5588804685\";i:5588804686;s:26:\"User Extension: 5588804686\";i:5588804687;s:26:\"User Extension: 5588804687\";i:5588804688;s:26:\"User Extension: 5588804688\";i:5588804689;s:26:\"User Extension: 5588804689\";i:5589958531;s:26:\"User Extension: 5589958531\";i:5589958532;s:26:\"User Extension: 5589958532\";i:5589958533;s:26:\"User Extension: 5589958533\";i:5589958534;s:26:\"User Extension: 5589958534\";i:5589958535;s:26:\"User Extension: 5589958535\";i:5589958536;s:26:\"User Extension: 5589958536\";i:5589958537;s:26:\"User Extension: 5589958537\";i:5589958538;s:26:\"User Extension: 5589958538\";i:5589958539;s:26:\"User Extension: 5589958539\";i:5589958540;s:26:\"User Extension: 5589958540\";i:6148880200;s:26:\"User Extension: 6148880200\";i:6148880201;s:26:\"User Extension: 6148880201\";i:6148880202;s:26:\"User Extension: 6148880202\";i:6148880203;s:26:\"User Extension: 6148880203\";i:6148880204;s:26:\"User Extension: 6148880204\";i:6568880100;s:26:\"User Extension: 6568880100\";i:6568880101;s:26:\"User Extension: 6568880101\";i:6568880102;s:26:\"User Extension: 6568880102\";i:6568880103;s:26:\"User Extension: 6568880103\";i:6568880104;s:26:\"User Extension: 6568880104\";i:6628880540;s:26:\"User Extension: 6628880540\";i:6628880541;s:26:\"User Extension: 6628880541\";i:6628880542;s:26:\"User Extension: 6628880542\";i:6628880543;s:26:\"User Extension: 6628880543\";i:6628880544;s:26:\"User Extension: 6628880544\";i:6647770030;s:26:\"User Extension: 6647770030\";i:6647770031;s:26:\"User Extension: 6647770031\";i:6647770032;s:26:\"User Extension: 6647770032\";i:6647770033;s:26:\"User Extension: 6647770033\";i:6647770034;s:26:\"User Extension: 6647770034\";i:8147370215;s:26:\"User Extension: 8147370215\";i:8147370216;s:26:\"User Extension: 8147370216\";i:8147370217;s:26:\"User Extension: 8147370217\";i:8147370218;s:26:\"User Extension: 8147370218\";i:8147370221;s:26:\"User Extension: 8147370221\";i:8147370224;s:26:\"User Extension: 8147370224\";i:8147370226;s:26:\"User Extension: 8147370226\";i:8147370227;s:26:\"User Extension: 8147370227\";i:8147370229;s:26:\"User Extension: 8147370229\";i:8147370230;s:26:\"User Extension: 8147370230\";i:8147370231;s:26:\"User Extension: 8147370231\";i:8147370232;s:26:\"User Extension: 8147370232\";i:8147370233;s:26:\"User Extension: 8147370233\";i:8147370234;s:26:\"User Extension: 8147370234\";i:8147370235;s:26:\"User Extension: 8147370235\";i:8147370237;s:26:\"User Extension: 8147370237\";i:8147370238;s:26:\"User Extension: 8147370238\";i:8147370239;s:26:\"User Extension: 8147370239\";i:8147370240;s:26:\"User Extension: 8147370240\";i:8147370241;s:26:\"User Extension: 8147370241\";i:8147370242;s:26:\"User Extension: 8147370242\";i:8147370244;s:26:\"User Extension: 8147370244\";i:8147370245;s:26:\"User Extension: 8147370245\";i:8147370246;s:26:\"User Extension: 8147370246\";i:8147370247;s:26:\"User Extension: 8147370247\";i:8147773870;s:26:\"User Extension: 8147773870\";i:8147773871;s:26:\"User Extension: 8147773871\";i:8147773872;s:26:\"User Extension: 8147773872\";i:8147773873;s:26:\"User Extension: 8147773873\";i:8147773874;s:26:\"User Extension: 8147773874\";i:8147773875;s:26:\"User Extension: 8147773875\";i:8147773876;s:26:\"User Extension: 8147773876\";i:8147773877;s:26:\"User Extension: 8147773877\";i:8147773878;s:26:\"User Extension: 8147773878\";i:8147773879;s:26:\"User Extension: 8147773879\";i:8147773880;s:26:\"User Extension: 8147773880\";i:8147773881;s:26:\"User Extension: 8147773881\";i:8147773882;s:26:\"User Extension: 8147773882\";i:8147773883;s:26:\"User Extension: 8147773883\";i:8147773884;s:26:\"User Extension: 8147773884\";i:8147773885;s:26:\"User Extension: 8147773885\";i:8147773886;s:26:\"User Extension: 8147773886\";i:8147773887;s:26:\"User Extension: 8147773887\";i:8147773888;s:26:\"User Extension: 8147773888\";i:8147773889;s:26:\"User Extension: 8147773889\";i:8147773890;s:26:\"User Extension: 8147773890\";i:8147773891;s:26:\"User Extension: 8147773891\";i:8147773892;s:26:\"User Extension: 8147773892\";i:8147773893;s:26:\"User Extension: 8147773893\";i:8147773894;s:26:\"User Extension: 8147773894\";i:8177700100;s:26:\"User Extension: 8177700100\";i:8177700101;s:26:\"User Extension: 8177700101\";i:8177700102;s:26:\"User Extension: 8177700102\";i:8177700103;s:26:\"User Extension: 8177700103\";i:8177700104;s:26:\"User Extension: 8177700104\";i:8177700105;s:26:\"User Extension: 8177700105\";i:8177700106;s:26:\"User Extension: 8177700106\";i:8177700107;s:26:\"User Extension: 8177700107\";i:8177700108;s:26:\"User Extension: 8177700108\";i:8177700109;s:26:\"User Extension: 8177700109\";i:8177700110;s:26:\"User Extension: 8177700110\";i:8177700111;s:26:\"User Extension: 8177700111\";i:8177700112;s:26:\"User Extension: 8177700112\";i:8177700113;s:26:\"User Extension: 8177700113\";i:8177700114;s:26:\"User Extension: 8177700114\";i:8177700115;s:26:\"User Extension: 8177700115\";i:8177700116;s:26:\"User Extension: 8177700116\";i:8177700117;s:26:\"User Extension: 8177700117\";i:8177700118;s:26:\"User Extension: 8177700118\";i:8177700119;s:26:\"User Extension: 8177700119\";i:8177700120;s:26:\"User Extension: 8177700120\";i:8177700121;s:26:\"User Extension: 8177700121\";i:8177700122;s:26:\"User Extension: 8177700122\";i:8177700123;s:26:\"User Extension: 8177700123\";i:8177700124;s:26:\"User Extension: 8177700124\";i:8177700360;s:26:\"User Extension: 8177700360\";i:8177700361;s:26:\"User Extension: 8177700361\";i:8177700362;s:26:\"User Extension: 8177700362\";i:8177700363;s:26:\"User Extension: 8177700363\";i:8177700364;s:26:\"User Extension: 8177700364\";i:8177700365;s:26:\"User Extension: 8177700365\";i:8177700366;s:26:\"User Extension: 8177700366\";i:8177700367;s:26:\"User Extension: 8177700367\";i:8177700368;s:26:\"User Extension: 8177700368\";i:8177700369;s:26:\"User Extension: 8177700369\";i:8177700370;s:26:\"User Extension: 8177700370\";i:8177700371;s:26:\"User Extension: 8177700371\";i:8177700372;s:26:\"User Extension: 8177700372\";i:8177700373;s:26:\"User Extension: 8177700373\";i:8177700374;s:26:\"User Extension: 8177700374\";i:8177700375;s:26:\"User Extension: 8177700375\";i:8177700376;s:26:\"User Extension: 8177700376\";i:8177700377;s:26:\"User Extension: 8177700377\";i:8177700378;s:26:\"User Extension: 8177700378\";i:8177700379;s:26:\"User Extension: 8177700379\";i:8177700380;s:26:\"User Extension: 8177700380\";i:8177700381;s:26:\"User Extension: 8177700381\";i:8177700382;s:26:\"User Extension: 8177700382\";i:8177700383;s:26:\"User Extension: 8177700383\";i:8177700384;s:26:\"User Extension: 8177700384\";i:8177700385;s:26:\"User Extension: 8177700385\";i:8177700386;s:26:\"User Extension: 8177700386\";i:8177700387;s:26:\"User Extension: 8177700387\";i:8177700388;s:26:\"User Extension: 8177700388\";i:8177700389;s:26:\"User Extension: 8177700389\";i:8177700670;s:26:\"User Extension: 8177700670\";i:8177700671;s:26:\"User Extension: 8177700671\";i:8177700672;s:26:\"User Extension: 8177700672\";i:8177700673;s:26:\"User Extension: 8177700673\";i:8177700674;s:26:\"User Extension: 8177700674\";i:8177700675;s:26:\"User Extension: 8177700675\";i:8177700676;s:26:\"User Extension: 8177700676\";i:8177700677;s:26:\"User Extension: 8177700677\";i:8177700678;s:26:\"User Extension: 8177700678\";i:8177700679;s:26:\"User Extension: 8177700679\";i:8177700680;s:26:\"User Extension: 8177700680\";i:8177700681;s:26:\"User Extension: 8177700681\";i:8177700682;s:26:\"User Extension: 8177700682\";i:8177700683;s:26:\"User Extension: 8177700683\";i:8177700684;s:26:\"User Extension: 8177700684\";i:8177700685;s:26:\"User Extension: 8177700685\";i:8177700686;s:26:\"User Extension: 8177700686\";i:8177700687;s:26:\"User Extension: 8177700687\";i:8177700688;s:26:\"User Extension: 8177700688\";i:8177700689;s:26:\"User Extension: 8177700689\";i:8177700690;s:26:\"User Extension: 8177700690\";i:8177700691;s:26:\"User Extension: 8177700691\";i:8177700692;s:26:\"User Extension: 8177700692\";i:8177700693;s:26:\"User Extension: 8177700693\";i:8177700694;s:26:\"User Extension: 8177700694\";i:8177700695;s:26:\"User Extension: 8177700695\";i:8177700696;s:26:\"User Extension: 8177700696\";i:8177700697;s:26:\"User Extension: 8177700697\";i:8177700698;s:26:\"User Extension: 8177700698\";i:8177700699;s:26:\"User Extension: 8177700699\";i:8177701550;s:26:\"User Extension: 8177701550\";i:8177701551;s:26:\"User Extension: 8177701551\";i:8177701552;s:26:\"User Extension: 8177701552\";i:8177701553;s:26:\"User Extension: 8177701553\";i:8177701554;s:26:\"User Extension: 8177701554\";i:8177701555;s:26:\"User Extension: 8177701555\";i:8177701556;s:26:\"User Extension: 8177701556\";i:8177701557;s:26:\"User Extension: 8177701557\";i:8177701558;s:26:\"User Extension: 8177701558\";i:8177701559;s:26:\"User Extension: 8177701559\";i:8177701560;s:26:\"User Extension: 8177701560\";i:8177701561;s:26:\"User Extension: 8177701561\";i:8177701562;s:26:\"User Extension: 8177701562\";i:8177701563;s:26:\"User Extension: 8177701563\";i:8177701564;s:26:\"User Extension: 8177701564\";i:8177701565;s:26:\"User Extension: 8177701565\";i:8177701566;s:26:\"User Extension: 8177701566\";i:8177701567;s:26:\"User Extension: 8177701567\";i:8177701568;s:26:\"User Extension: 8177701568\";i:8177701569;s:26:\"User Extension: 8177701569\";i:8177701570;s:26:\"User Extension: 8177701570\";i:8177701571;s:26:\"User Extension: 8177701571\";i:8177701572;s:26:\"User Extension: 8177701572\";i:8177701573;s:26:\"User Extension: 8177701573\";i:8177701574;s:26:\"User Extension: 8177701574\";i:8177701575;s:26:\"User Extension: 8177701575\";i:8177701576;s:26:\"User Extension: 8177701576\";i:8177701577;s:26:\"User Extension: 8177701577\";i:8177701578;s:26:\"User Extension: 8177701578\";i:8177701579;s:26:\"User Extension: 8177701579\";i:8177702600;s:26:\"User Extension: 8177702600\";i:8177702601;s:26:\"User Extension: 8177702601\";i:8177702602;s:26:\"User Extension: 8177702602\";i:8177702603;s:26:\"User Extension: 8177702603\";i:8177702604;s:26:\"User Extension: 8177702604\";i:8177702605;s:26:\"User Extension: 8177702605\";i:8177702606;s:26:\"User Extension: 8177702606\";i:8177702607;s:26:\"User Extension: 8177702607\";i:8177702608;s:26:\"User Extension: 8177702608\";i:8177702609;s:26:\"User Extension: 8177702609\";i:8177702610;s:26:\"User Extension: 8177702610\";i:8177702611;s:26:\"User Extension: 8177702611\";i:8177702612;s:26:\"User Extension: 8177702612\";i:8177702613;s:26:\"User Extension: 8177702613\";i:8177702614;s:26:\"User Extension: 8177702614\";i:8177702615;s:26:\"User Extension: 8177702615\";i:8177702616;s:26:\"User Extension: 8177702616\";i:8177702617;s:26:\"User Extension: 8177702617\";i:8177702618;s:26:\"User Extension: 8177702618\";i:8177702619;s:26:\"User Extension: 8177702619\";i:8177702620;s:26:\"User Extension: 8177702620\";i:8177702621;s:26:\"User Extension: 8177702621\";i:8177702622;s:26:\"User Extension: 8177702622\";i:8177702623;s:26:\"User Extension: 8177702623\";i:8177702624;s:26:\"User Extension: 8177702624\";i:8177702625;s:26:\"User Extension: 8177702625\";i:8177702626;s:26:\"User Extension: 8177702626\";i:8177702627;s:26:\"User Extension: 8177702627\";i:8177702628;s:26:\"User Extension: 8177702628\";i:8177702629;s:26:\"User Extension: 8177702629\";i:8442887386;s:26:\"User Extension: 8442887386\";i:8442887387;s:26:\"User Extension: 8442887387\";i:8442887388;s:26:\"User Extension: 8442887388\";i:8442887389;s:26:\"User Extension: 8442887389\";i:8442887390;s:26:\"User Extension: 8442887390\";i:8447770070;s:26:\"User Extension: 8447770070\";i:8447770071;s:26:\"User Extension: 8447770071\";i:8447770072;s:26:\"User Extension: 8447770072\";i:8447770073;s:26:\"User Extension: 8447770073\";i:8447770074;s:26:\"User Extension: 8447770074\";i:8447770430;s:26:\"User Extension: 8447770430\";i:8447770431;s:26:\"User Extension: 8447770431\";i:8447770432;s:26:\"User Extension: 8447770432\";i:8447770433;s:26:\"User Extension: 8447770433\";i:8447770434;s:26:\"User Extension: 8447770434\";i:8447770435;s:26:\"User Extension: 8447770435\";i:8447770436;s:26:\"User Extension: 8447770436\";i:8447770437;s:26:\"User Extension: 8447770437\";i:8447770438;s:26:\"User Extension: 8447770438\";i:8447770439;s:26:\"User Extension: 8447770439\";i:8677770240;s:26:\"User Extension: 8677770240\";i:8677770241;s:26:\"User Extension: 8677770241\";i:8677770242;s:26:\"User Extension: 8677770242\";i:8677770243;s:26:\"User Extension: 8677770243\";i:8677770244;s:26:\"User Extension: 8677770244\";i:8718800150;s:26:\"User Extension: 8718800150\";i:8718800151;s:26:\"User Extension: 8718800151\";i:8718800152;s:26:\"User Extension: 8718800152\";i:8718800153;s:26:\"User Extension: 8718800153\";i:8718800154;s:26:\"User Extension: 8718800154\";i:8718800155;s:26:\"User Extension: 8718800155\";i:8718800156;s:26:\"User Extension: 8718800156\";i:8718800157;s:26:\"User Extension: 8718800157\";i:8718800158;s:26:\"User Extension: 8718800158\";i:8718800159;s:26:\"User Extension: 8718800159\";i:8998880195;s:26:\"User Extension: 8998880195\";i:8998880196;s:26:\"User Extension: 8998880196\";i:8998880197;s:26:\"User Extension: 8998880197\";i:8998880198;s:26:\"User Extension: 8998880198\";i:8998880199;s:26:\"User Extension: 8998880199\";i:9847770190;s:26:\"User Extension: 9847770190\";i:9847770191;s:26:\"User Extension: 9847770191\";i:9847770192;s:26:\"User Extension: 9847770192\";i:9847770193;s:26:\"User Extension: 9847770193\";i:9847770194;s:26:\"User Extension: 9847770194\";i:9847770195;s:26:\"User Extension: 9847770195\";i:9847770196;s:26:\"User Extension: 9847770196\";i:9847770197;s:26:\"User Extension: 9847770197\";i:9847770198;s:26:\"User Extension: 9847770198\";i:9847770199;s:26:\"User Extension: 9847770199\";i:9847770200;s:26:\"User Extension: 9847770200\";i:9847770201;s:26:\"User Extension: 9847770201\";i:9847770202;s:26:\"User Extension: 9847770202\";i:9847770203;s:26:\"User Extension: 9847770203\";i:9847770204;s:26:\"User Extension: 9847770204\";i:9847770340;s:26:\"User Extension: 9847770340\";i:9847770341;s:26:\"User Extension: 9847770341\";i:9847770342;s:26:\"User Extension: 9847770342\";i:9847770343;s:26:\"User Extension: 9847770343\";i:9847770344;s:26:\"User Extension: 9847770344\";i:9988001966;s:26:\"User Extension: 9988001966\";i:9988001967;s:26:\"User Extension: 9988001967\";i:9988001968;s:26:\"User Extension: 9988001968\";i:9988001969;s:26:\"User Extension: 9988001969\";i:9988001970;s:26:\"User Extension: 9988001970\";i:9988001971;s:26:\"User Extension: 9988001971\";i:9988001972;s:26:\"User Extension: 9988001972\";i:9988001973;s:26:\"User Extension: 9988001973\";i:9988001974;s:26:\"User Extension: 9988001974\";i:9988001975;s:26:\"User Extension: 9988001975\";i:9995740195;s:26:\"User Extension: 9995740195\";i:9995740196;s:26:\"User Extension: 9995740196\";i:9995740197;s:26:\"User Extension: 9995740197\";i:9995740198;s:26:\"User Extension: 9995740198\";i:9995740199;s:26:\"User Extension: 9995740199\";i:81777001001;s:27:\"User Extension: 81777001001\";i:81777001081;s:27:\"User Extension: 81777001081\";}'),('module_repo',1501883642,'http://cloud.issabel.org,http://cloud2.issabel.org'),('repos_serialized',1501881632,'a:1:{s:8:\"standard\";i:1;}'),('installid',1636836843,'4958547cf4ac0f7bd86664d1606137f0'),('type',1636836843,''),('xml',1636923243,'<xml>\n<module>\n	<rawname>daynight</rawname>\n	<repo>standard</repo>\n	<name>Call Flow Control</name>\n	<version>2.11.0.6</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n	<description>\n		Call Flow manual toggle control - allows for two destinations to be chosen and provides a feature code\n		that toggles between the two destinations.\n	</description>\n	<changelog>\n		*2.11.0.6* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.5.0alpha1</version>\n	</depends>\n	<menuitems>\n		<daynight needsenginedb=\"yes\">Call Flow Control</daynight>\n	</menuitems>\n	<popovers>\n		<daynight>\n			<display>daynight</display>\n		</daynight>\n 	</popovers>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/daynight-2.11.0.6.tgz</location>\n        <md5sum>d9b951444150e1edd9454a2b165c714f</md5sum>\n</module>\n<module>\n	<rawname>trunkbalance</rawname>\n	<name>Trunk Balance</name>\n	<version>1.1.5</version>\n	<publisher>POSSA</publisher>\n	<license>GPLv2+</license>\n	<candisable>yes</candisable>\n	<canuninstall>yes</canuninstall>\n    <repo>extended</repo>\n	<category>Advanced</category>\n	<changelog>\n		*1.1.5* Accept Self Signed Certs in URL\n		*1.1.4* Remove auto check for updates\n		*1.1.2* Added trunk disable toggle\n		*1.1.1* Allow multiple matching and non-matching rules\n		*1.1.0* Additional flexibility for billing periods\n		*1.0.2* pass dialed number directly to dialout macro\n		*1.0.1* fixed max unique call logic\n		*1.0.0* revised to work with FreePBX 2.10\n		*0.0.4.3* Allow balance of DAHDI trunks and move to Github\n		*0.0.4.2* bug fix\n		*0.0.4.1* added timeconditions module dependency\n		*0.0.4* added time condition\n		*0.0.3.3* bug fix\n		*0.0.3.2* bug fix\n		*0.0.3* freePBX 2.6 dependency\n		*0.0.2* display bug with Freepbx 2.5; improved uninstall. \n		*0.0.1* alpha release\n	</changelog>	\n	<embedcategory>Advanced</embedcategory>\n	<depends>\n		<module>core</module>\n		<version>ge 2.6</version>\n		<module>timeconditions ge2.6</module>\n	</depends>\n	<description>Restrict outbound calls or balance calls over multiple trunks based on user specified parameters</description>\n	<menuitems>\n		<trunkbalance>Trunk Balance</trunkbalance>\n	</menuitems>\n	<info>https://github.com/POSSA/freepbx-trunk-balancing</info>\n        <location>release/2.11/trunkbalance-1.1.5.tgz</location>\n</module>\n<module>\n  <rawname>pbdirectory</rawname>\n  <repo>extended</repo>\n  <name>Phonebook Directory</name>\n  <version>2.11.0.5</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n  <category>Admin</category>\n        <location>release/2.11/pbdirectory-2.11.0.5.tgz</location>\n  <description>Provides a dial-by-name directory for phonebook entries</description>\n	<changelog>\n		*2.11.0.5* Issabel Foundation release\n		*2.9.0.0* Forked from FreePBX modules, original publisher Sangoma Technologies\n	</changelog>\n  <depends>\n    <version>2.4.0</version>\n    <module>phonebook</module>\n    <module>speeddial</module>\n  </depends>\n        <md5sum>c7bfe1d64db5ca90988f520294bfa218</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n	<rawname>callwaiting</rawname>\n	<repo>standard</repo>\n	<name>Call Waiting</name>\n	<description>Provides an option to turn on/off call waiting</description>\n	<category>Applications</category>\n	<version>2.11.0.4</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<changelog>\n		*2.11.0.4* Initial Issabel Foundation release\n		*1.1* First release for 2.2\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/callwaiting-2.11.0.4.tgz</location>\n        <md5sum>aa1e288a433366b7dd032e5024f87f28</md5sum>\n</module>\n<module>\n	<rawname>queues</rawname>\n	<repo>standard</repo>\n	<name>Queues</name>\n	<version>2.11.0.30</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv2+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-2.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n	<description>\n		Creates a queue where calls are placed on hold and answered on a first-in, first-out basis. Many options are available, including ring strategy for agents, caller announcements, max wait times, etc.\n	</description>\n	<changelog>\n        *2.11.0.30* Fix recordings being deleted when queue continue is selected\n        *2.11.0.29* Rebranding\n        *2.11.0.28* Set url parameter to variable QURL\n		*2.11.0.26* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.5.0alpha1</version>\n		<module>recordings ge 3.3.8</module>\n        <module>core ge 2.11.0.0rc1.2</module>\n        <module>framework ge 2.11.0.47</module>\n	</depends>\n	<menuitems>\n		<queues needsenginedb=\"yes\">Queues</queues>\n	</menuitems>\n	<popovers>\n		<queues>\n			<display>queues</display>\n		</queues>\n	</popovers>\n	<supported>\n		<version>2.11.0</version>\n	</supported>\n        <location>release/2.11/queues-2.11.0.30.tgz</location>\n        <md5sum>a524c7984991a3739729c2469db1d33a</md5sum>\n</module>\n<module>\n    <rawname>dynamicfeatures</rawname>\n    <repo>extended</repo>\n    <name>Dynamic Features</name>\n    <version>2.11.0.0</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n    <description>\n        Adds the ability to configure custom dynamic features to be executed while on a call\n    </description>\n    <menuitems>\n        <dynamicfeatures>Dynamic Features</dynamicfeatures>\n    </menuitems>\n    <changelog>\n        *2.11.0.0* Initial Issabel Foundation release\n    </changelog>\n    <depends>\n        <version>2.11.0</version>\n    </depends>\n        <location>release/2.11/dynamicfeatures-2.11.0.0.tgz</location>\n        <md5sum>047d2271bfed7396ed6173b379d3b83b</md5sum>\n    <supported>\n        <version>2.10</version>\n    </supported>\n</module>\n<module>\n    <rawname>music</rawname>\n    <repo>standard</repo>\n    <name>Music on Hold</name>\n    <version>2.11.0.3</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <candisable>no</candisable>\n    <canuninstall>no</canuninstall>\n    <category>Settings</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n    <description>Uploading and management of sound files (wav, mp3) to be used for on-hold music.</description>\n    <changelog>\n        *2.11.0.3* Initial Issabel Foundation release\n    </changelog>\n    <menuitems>\n        <music>Music on Hold</music>\n    </menuitems>\n        <location>release/2.11/music-2.11.0.3.tgz</location>\n        <md5sum>8bc39e892baab56322553f3f56b2577e</md5sum>\n    <supported>\n        <version>2.10</version>\n    </supported>\n</module>\n<module>\n    <rawname>ivr</rawname>\n    <repo>standard</repo>\n    <name>IVR</name>\n    <version>2.11.0.12</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n    <description>\n        Creates Digital Receptionist (aka Auto-Attendant, aka Interactive Voice Response) menus. These can be used to send callers to different locations (eg, Press 1 for sales) and/or allow direct-dialing of extension numbers.\n    </description>\n    <changelog>\n        *2.11.0.12* Added spoken options support using Asterisk 16 ppeech functions\n        *2.11.0.11* Rebranding\n        *2.11.0.10* Initial Issabel Foundation release\n    </changelog>\n    <depends>\n        <version>2.5.0alpha1</version>\n        <module>recordings ge 3.3.8</module>\n        <module>framework ge 2.11.0.47</module>\n    </depends>\n    <menuitems>\n        <ivr>IVR</ivr>\n    </menuitems>\n    <popovers>\n        <ivr>\n            <display>ivr</display>\n            <action>add</action>\n        </ivr>\n    </popovers>\n    <supported>\n        <version>2.11.0</version>\n    </supported>\n        <location>release/2.11/ivr-2.11.0.12.tgz</location>\n        <md5sum>bdf52ef9550bf93e46f4a3946d79d458</md5sum>\n</module>\n<module>\n	<rawname>weakpasswords</rawname>\n	<repo>standard</repo>\n	<name>Weak Password Detection</name>\n	<version>2.11.0.1</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Reports</category>\n	<changelog>\n		*2.11.0.1* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.5.0</version>\n	</depends>\n	<description>This module detects weak SIP secrets and sets security notifications accordingly\n	</description>\n	<supported>\n		<version>2.10</version>\n	</supported>\n	<menuitems>\n		<weakpasswords>Weak Password Detection</weakpasswords>\n	</menuitems>\n        <location>release/2.11/weakpasswords-2.11.0.1.tgz</location>\n        <md5sum>7ed5e01ef3516d3d3b99c2116f3a71ec</md5sum>\n</module>\n<module>\n    <rawname>dialplaninjection</rawname>\n    <name>Dialplan Injection</name>\n    <version>0.1.1n</version>\n    <type>setup</type>\n    <publisher>POSSA</publisher>\n    <category>Advanced</category>\n    <embedcategory>Advanced</embedcategory>\n    <description>Acts as a dialplan destination and can execute a variety of Asterisk commands</description>\n    <menuitems>\n        <dialplaninjection>Dialplan Injection</dialplaninjection>\n    </menuitems>\n        <depends>\n                <module>core</module>\n        </depends>\n        <changelog>\n            Lorne Gaetz: Initial commit\n    </changelog>\n    <attention>\n        This is an advanced module, and you should not use it without understanding asterisk dialplans!\n        This is meant as a convenience tool for someone who would have had to resort to config editing.\n        If you experience problems with it, just disable it and no harm done.\n    </attention>\n</module>\n<module>\n	<rawname>javassh</rawname>\n	<repo>extended</repo>\n	<name>Java SSH</name>\n	<version>2.11.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>AGPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/agpl-3.0.txt</licenselink>\n	<category>Admin</category>\n	<description>Provides a Java applet to access the system shell using SSH.</description>\n	<menuitems>\n		<javassh>Java SSH</javassh>\n	</menuitems>\n	<changelog>\n		*2.11.2* Initial Issabel Foundation release\n	</changelog>\n        <location>release/2.11/javassh-2.11.2.tgz</location>\n        <md5sum>51b90ffd23d4456af91928733019119c</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n  <rawname>timeconditions</rawname>\n  <repo>standard</repo>\n  <name>Time Conditions</name>\n  <version>2.11.1.2</version>\n  <publisher>Issabel Foundation</publisher>\n  <license>GPLv3+</license>\n  <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n  <category>Applications</category>\n  <embedcategory>Inbound Call Control</embedcategory>\n  <description>\n    Creates a condition where calls will go to one of two destinations (eg, an extension, IVR, ring group..) based on the time and/or date. This can be used for example to ring a receptionist during the day, or go directly to an IVR at night.\n  </description>\n  <changelog>\n    *2.11.1.2* Add autofill holidays function\n    *2.11.1.1* Initial Issabel Foundation release\n  </changelog>\n  <depends>\n    <version>2.5.0alpha1</version>\n  </depends>\n  <menuitems>\n    <timeconditions>Time Conditions</timeconditions>\n    <timegroups>Time Groups</timegroups>\n  </menuitems>\n  <popovers>\n    <timeconditions>\n      <display>timeconditions</display>\n    </timeconditions>\n  </popovers>\n        <location>release/2.11/timeconditions-2.11.1.2.tgz</location>\n        <md5sum>abb6b77e4a82799f83475f7af34f64d1</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n	<rawname>queuemetrics</rawname>\n	<name>QueueMetrics</name>\n	<version>2.11.0.3</version>\n	<repo>unsupported</repo>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Settings</category>\n	<description>A module for QueueMetrics, that allows you to set if IVR selections should be logged to the queue logs.</description>\n	<depends>\n		<module>ivr ge 2.11.0.1</module>\n		<version>2.11.0alpha1</version>\n		<phpversion>5.3.0</phpversion>\n	</depends>\n	<menuitems>\n		<queuemetrics>QueueMetrics</queuemetrics>\n	</menuitems>\n	<changelog>\n		*2.11.0.3* Initial Issabel Foundation release\n		*2.11.0.2* Include license file\n		*2.11.0.1* Packaging of ver 2.11.0.1\n		*2.11.0.0* Move from contributed to 2.11 branch\n		*2.10.0.3* Fix QueueMetrics naming\n		*2.10.0.2* Need to log to NONE for queuename for QueueMetrics\n		*2.10.0.1* Change the way data is logged for QueueMetrics\n		*2.10.0.0* First Implementation\n	</changelog>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/queuemetrics-2.11.0.3.tgz</location>\n        <md5sum>015d4ea6921769da33354107fde1afb4</md5sum>\n</module>\n<module>\n	<rawname>infoservices</rawname>\n	<repo>standard</repo>\n	<name>Info Services</name>\n	<version>2.11.0.3</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<candisable>no</candisable>\n	<canuninstall>no</canuninstall>\n	<category>Applications</category>\n	<description>Provides a number of applications accessible by feature codes: company directory, call trace (last call information), echo test, speaking clock, and speak current extension number.</description>\n	<changelog>\n		*2.11.0.3* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/infoservices-2.11.0.3.tgz</location>\n        <md5sum>62751bc58a996583b3fe95f1c493c94a</md5sum>\n</module>\n<module>\n	<rawname>iaxsettings</rawname>\n	<repo>standard</repo>\n	<name>Asterisk IAX Settings</name>\n	<version>2.11.0.3</version>\n	<publisher>Issabel Foundation</publisher>\n	<licenselink>http://www.gnu.org/licenses/agpl-3.0.txt</licenselink>\n	<license>AGPLv3</license>\n    <category>Settings</category>\n    <embedcategory>Advanced</embedcategory>\n	<menuitems>\n		<iaxsettings>Asterisk IAX Settings</iaxsettings>\n	</menuitems>\n	<description>\n		Use to configure Various Asterisk IAX Settings in the General section of iax.conf. The module assumes Asterisk version 1.4 or higher. Some settings may not exist in Asterisk 1.2 and will be ignored by Asterisk.\n	</description>\n	<changelog>\n		*2.11.0.3* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/iaxsettings-2.11.0.3.tgz</location>\n        <md5sum>9af6b5391200627e9c7dceaed5ac6a65</md5sum>\n</module>\n<module>\n	<rawname>conferences</rawname>\n	<repo>standard</repo>\n	<name>Conferences</name>\n	<version>2.11.0.6</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n	<description>Allow creation of conference rooms (meet-me) where multiple people can talk together.</description>\n	<changelog>\n		*2.11.0.6* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.5.0alpha1</version>\n		<module>recordings ge 3.3.8</module>\n	</depends>\n	<menuitems>\n		<conferences>Conferences</conferences>\n	</menuitems>\n	<popovers>\n		<conferences>\n			<display>conferences</display>\n		</conferences>\n 	</popovers>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/conferences-2.11.0.6.tgz</location>\n        <md5sum>b7b33ea0ab781d8e165b533dd72d852b</md5sum>\n</module>\n<module>\n	<rawname>asterisk-cli</rawname>\n	<repo>extended</repo>\n	<name>Asterisk CLI</name>\n	<version>2.11.0.3</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Admin</category>\n	<description>Provides an interface allowing you to run a command as if it was typed into Asterisk CLI</description>\n	<menuitems>\n		<cli>Asterisk CLI</cli>\n	</menuitems>\n	<depends>\n		<engine>asterisk</engine>\n	</depends>\n        <location>release/2.11/asterisk-cli-2.11.0.3.tgz</location>\n        <md5sum>ba056c7eed0a3543eb7f3461e4dd7e5a</md5sum>\n	<changelog>\n		*2.11.0.3* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n</module>\n<module>\n	<rawname>dundicheck</rawname>\n	<repo>unsupported</repo>\n	<name>DUNDi Lookup Registry</name>\n	<version>2.11.0.3</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<changelog>\n		*2.11.0.3* Initial Issabel Foundation release\n	</changelog>\n	<description>\n		This module will check all configured and enabled DUNDi trunks as part of the extension registry function, and report back conflicts if\n		other sites have the same extensions. This does not filter against the route patterns - it will take any number being created and\n		report a conflict if that trunk could be used to call that number.\n	</description>\n	<menuitems>\n		<dundicheck>DUNDi Lookup</dundicheck>\n	</menuitems>\n	<depends>\n		<version>2.4.0</version>\n	</depends>\n	<supported>\n		<version>2.10</version>\n	</supported>\n	<category>Admin</category>\n        <location>release/2.11/dundicheck-2.11.0.3.tgz</location>\n        <md5sum>c898abf4f81bb48b0c5ae341570422ca</md5sum>\n</module>\n<module>\n        <rawname>writequeuelog</rawname>\n        <repo>standard</repo>\n        <name>Write a line into queue log</name>\n        <version>2.11.0.0</version>\n        <category>Applications</category>\n        <embedcategory>Advanced</embedcategory>\n        <publisher>Issabel Foundation</publisher>\n        <license>GPLv3+</license>\n        <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n        <description>\n            Adds the ability to write into queue_log\n        </description>\n        <menuitems>\n                <writequeuelog>Write in Queue Log</writequeuelog>\n        </menuitems>\n        <changelog>\n                *2.11.1.0*  Initial Release\n        </changelog>\n        <depends>\n                <version>2.5.0</version>\n        </depends>\n        <supported>\n                <version>2.10</version>\n        </supported>\n        <location>release/2.11/writequeuelog-2.11.0.0.tgz</location>\n        <md5sum>f1897339d16dbed9a28e20c36623e5bf</md5sum>\n</module>\n<module>\n	<rawname>backup</rawname>\n	<repo>standard</repo>\n	<name>Backup &amp; Restore</name>\n	<version>2.11.0.23</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Admin</category>\n	<description>Backup &amp; Restore for your IssabelPBX environment</description>\n	<menuitems>\n		<backup needsenginedb=\"yes\">Backup &amp; Restore</backup>\n		<backup_servers needsenginedb=\"yes\" hidden=\"true\">Backup &amp; Restore - Servers</backup_servers>\n		<backup_templates needsenginedb=\"yes\" hidden=\"true\">Backup &amp; Restore - Templates</backup_templates>\n		<backup_restore needsenginedb=\"yes\" hidden=\"true\">Backup &amp; Restore - Restore</backup_restore>\n	</menuitems>\n	<depends>\n		<module>core</module>\n	</depends>\n	<changelog>\n        *2.11.0.23* Rebranding\n		*2.11.0.22* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/backup-2.11.0.23.tgz</location>\n</module>\n<module>\n	<rawname>donotdisturb</rawname>\n	<repo>standard</repo>\n	<name>Do-Not-Disturb (DND)</name>\n	<version>2.11.0.3</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<changelog>\n		*2.11.0.3* Initial Issabel Foundation release\n	</changelog>\n	<description>Provides donotdisturb featurecodes</description>\n	<category>Applications</category>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/donotdisturb-2.11.0.3.tgz</location>\n        <md5sum>b006e556a1729682ffef7a6d70350cde</md5sum>\n</module>\n<module>\n	<rawname>featurecodeadmin</rawname>\n	<repo>standard</repo>\n	<name>Feature Code Admin</name>\n	<version>2.11.0.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<candisable>no</candisable>\n	<canuninstall>no</canuninstall>\n    <category>Admin</category>\n    <embedcategory>Basic</embedcategory>\n	<menuitems>\n		<featurecodeadmin>Feature Codes</featurecodeadmin>\n	</menuitems>\n        <location>release/2.11/featurecodeadmin-2.11.0.2.tgz</location>\n	<changelog>\n		*2.11.0.2* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.5.0alpha1</version>\n	</depends>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <md5sum>32e039a754c68c399e567da0408ae2b1</md5sum>\n</module>\n<module>\n	<rawname>accountcodepreserve</rawname>\n	<repo>extended</repo>\n	<name>Preserve Accountcode</name>\n	<version>2.11.0.0</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv2</license>\n	<type>setup</type>\n	<category>Admin</category>\n	<description>This module preservers the first callee\'s account code, that has an accountcode, that it encounters. This preserved accoutcode will be used to set the CDR(accountcode) for any outbound calls that result from any type of redirected call (CF, VmX, Follow-Me, etc.). The account code for each user is pulled out of their associated device settings, which means this is only supported in extension mode and would have to be updated for deviceanduser mode, requiring a new accountcode field to be defined for the user on the extension/user screen.\n	</description>\n	<changelog>\n		*2.11.0.0* Initial Issabel Foundation release\n		*2.5.0* Initial Release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/accountcodepreserve-2.11.0.0.tgz</location>\n        <md5sum>95d237021fdedfe3ffb86b6287c01ec5</md5sum>\n</module>\n<module>\n    <rawname>queueprio</rawname>\n    <repo>extended</repo>\n    <name>Queue Priorities</name>\n    <version>2.11.0.2</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n    <description>\n        Adds the ability to set a callers priority higher before entering a queue\n    </description>\n    <menuitems>\n        <queueprio>Queue Priorities</queueprio>\n    </menuitems>\n    <popovers>\n        <queueprio>\n            <display>queueprio</display>\n        </queueprio>\n    </popovers>\n    <changelog>\n        *2.11.0.2* Initial Issabel Foundation release\n    </changelog>\n    <depends>\n        <version>2.5.0alpha1</version>\n    </depends>\n        <location>release/2.11/queueprio-2.11.0.2.tgz</location>\n        <md5sum>f3f8a5b94fb0a0fe9a27a83f6621132e</md5sum>\n    <supported>\n        <version>2.10</version>\n    </supported>\n</module>\n<module>\n	<rawname>blacklist</rawname>\n	<repo>standard</repo>\n	<name>Blacklist</name>\n	<version>2.11.0.6</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Admin</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n	<menuitems>\n		<blacklist needsenginedb=\"yes\">Blacklist</blacklist>\n	</menuitems>\n	<changelog>\n		*2.11.0.6* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<module>core ge 2.5.1.2</module>\n	</depends>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/blacklist-2.11.0.6.tgz</location>\n        <md5sum>3638160171d4ebfb692c11a2f88c9b10</md5sum>\n</module>\n<module>\n	<rawname>inventorydb</rawname>\n	<name>Inventory</name>\n	<version>2.5.0.2</version>\n	<type>tool</type>\n	<category>Third Party Addon</category>\n	<menuitems>\n		<inventorydb>Inventory</inventorydb>\n	</menuitems>\n	<changelog>\n		*2.5.0.2* localization updates\n		*2.5.0.1* localization, Swedish\n		*2.5.0* #2845 tabindex\n		*2.4.0.1* #2645 API error - NOTICE: This module will be removed from future versions\n		*2.4.0* bumped for 2.4\n		*1.1.0* Added SQLite3 support. Fixes ticket:1783, bump for rc1\n		*1.0.3* Add he_IL translation\n	</changelog>\n        <location>release/2.11/inventorydb-2.5.0.2.tgz</location>\n        <md5sum>6c4e97b7bdfbad905f83c29d129b1bbc</md5sum>\n</module>\n\n<module>\n	<rawname>fax</rawname>\n	<repo>standard</repo>\n	<name>Fax Configuration</name>\n	<version>2.11.0.10</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Settings</category>\n	<menuitems>\n		<fax>Fax Configuration</fax>\n	</menuitems>\n	<description>Adds configurations, options and GUI for inbound faxing</description>\n	<changelog>\n        *2.11.0.10* Rebranding\n		*2.11.0.9* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n        <module>framework ge 2.11.0.47</module>\n	</depends>\n	<supported>\n        <version>2.11.0</version>\n	</supported>\n        <location>release/2.11/fax-2.11.0.10.tgz</location>\n        <md5sum>11a918dc1f4e163fb56ee17d903e85db</md5sum>\n</module>\n<module>\n	<rawname>voicemail</rawname>\n	<repo>standard</repo>\n	<name>Voicemail</name>\n	<version>2.11.1.7</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<candisable>no</candisable>\n	<canuninstall>no</canuninstall>\n	<changelog>\n        *2.11.1.7* Rebranding\n		*2.11.1.6* Initial Issabel Foundation release\n	</changelog>\n	<description>This module allows you to configure Voicemail for a user or extension</description>\n    <category>Settings</category>\n    <embedcategory>Advanced</embedcategory>\n	<menuitems>\n		<voicemail>Voicemail Admin</voicemail>\n	</menuitems>\n	<depends>\n        <version>2.5.0alpha1</version>\n        <module>framework ge 2.11.0.47</module>\n	</depends>\n	<supported>\n		<version>2.11.0</version>\n	</supported>\n        <location>release/2.11/voicemail-2.11.1.7.tgz</location>\n        <md5sum>fcb6cb5b1d82faa62a0993edd9c06393</md5sum>\n</module>\n<module>\n	<rawname>manager</rawname>\n	<repo>standard</repo>\n	<name>Asterisk Manager Users</name>\n	<version>2.11.0.5</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Settings</category>\n	<menuitems>\n		<manager>Asterisk Manager Users</manager>\n	</menuitems>\n	<changelog>\n		*2.11.0.5* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/manager-2.11.0.5.tgz</location>\n        <md5sum>d1443f8aa5bc98afae791ce4392b0835</md5sum>\n</module>\n<module>\n    <rawname>core</rawname>\n    <repo>standard</repo>\n    <category>Applications</category>\n    <embedcategory>Basic</embedcategory>\n    <name>Core</name>\n    <version>2.11.0.48</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <candisable>no</candisable>\n    <canuninstall>no</canuninstall>\n    <changelog>\n        *2.11.0.48* Multi Park support\n        *2.11.0.47* Bump release for Aug 2018 .iso and rebranding\n        *2.11.0.45* Added options for features and manager settings\n        *2.11.0.35* Initial Issabel Foundation release\n    </changelog>\n    <depends>\n        <module>framework ge 2.11.0.30</module>\n        <version>2.11.0alpha0</version>\n    </depends>\n    <requirements>\n        <file>/usr/sbin/asterisk</file>\n    </requirements>\n    <menuitems>\n        <extensions needsenginedb=\"yes\">Extensions</extensions>\n        <users needsenginedb=\"yes\">Users</users>\n        <devices needsenginedb=\"yes\">Devices</devices>\n        <did category=\"Connectivity\">Inbound Routes</did>\n        <dahdichandids category=\"Connectivity\">DAHDI Channel DIDs</dahdichandids>\n        <routing category=\"Connectivity\">Outbound Routes</routing>\n        <trunks category=\"Connectivity\">Trunks</trunks>\n        <advancedsettings category=\"Settings\">Advanced Settings</advancedsettings>\n        <ampusers category=\"Admin\">Administrators</ampusers>\n        <wiki category=\"Admin\" requires_auth=\"false\" href=\"http://www.issabel.com\" target=\"_blank\" access=\"all\">IssabelPBX Support</wiki>\n    </menuitems>\n    <popovers>\n        <extensions>\n            <display>extensions</display>\n        </extensions>\n        <users>\n            <display>users</display>\n        </users>\n     </popovers>\n    <methods>\n        <get_config pri=\"480\">core_do_get_config</get_config>\n    </methods>\n     <supported>\n         <version>2.11</version>\n    </supported>\n        <location>release/2.11/core-2.11.0.48.tgz</location>\n        <md5sum>77d54670bcdf36e2f540d304df5461d9</md5sum>\n</module>\n<module>\n	<rawname>customcontexts</rawname>\n	<repo>unsupported</repo>\n	<name>Class of Service</name>\n	<version>2.11.0.2</version>\n    <category>Connectivity</category>\n    <embedcategory>Basic</embedcategory>\n	<license>GPLv2+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-2.0.txt</licenselink>\n	<description>\n		Creates custom contexts which can be used to allow limited access to dialplan applications. Allows for time restrictions on any dialplan access. Allows for pattern matching to allow/deny. Allows for failover destinations, and PIN protected failover. This can be very useful for multi-tennant systems. Inbound routing can be done using DID or zap channel routing, this module allows for selective outbound routing. House/public phones can be placed in a restricted context allowing them only internal calls.\n	</description>\n	<menuitems>\n		<customcontexts>Class of Service</customcontexts>\n		<customcontextsadmin>Class of Service Admin</customcontextsadmin>\n	</menuitems>\n	<depends>\n		<version>2.8.0alpha1</version>\n		<module>core</module>\n		<module>timeconditions</module>\n	</depends>\n	<changelog>\n		*2.11.0.2* Initial Issabel Foundation release\n	</changelog>\n	<attention>\n		This is an advanced module, and you should not use it without understanding asterisk dialplans! This is meant as a convenience tool for someone who would have had to resort to config editing. If you experience problems with it, just disable it and no harm done. REMEMBER! Any device placed in a restricted context will have no access to the dialplan if this module is disabled until it is placed in a normal context!\n	</attention>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/customcontexts-2.11.0.2.tgz</location>\n        <md5sum>30f4673ac6ccb235b8194de47e15dd5d</md5sum>\n</module>\n<module>\n	<rawname>cdr</rawname>\n	<repo>standard</repo>\n	<description>Call Data Record report tools for viewing reports of your calls</description>\n	<name>CDR Reports</name>\n	<version>2.11.0.12</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Reports</category>\n	<menuitems>\n		<cdr>CDR Reports</cdr>\n	</menuitems>\n	<changelog>\n		*2.11.0.12* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<module>core ge 2.6.0</module>\n	</depends>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/cdr-2.11.0.12.tgz</location>\n        <md5sum>d8eb6038194c491a7899aa62fcef412f</md5sum>\n</module>\n<module>\n    <rawname>announcement</rawname>\n    <repo>standard</repo>\n    <name>Announcements</name>\n    <version>2.11.0.5</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <changelog>\n        *2.11.0.5* Adds Text to Speech support via PicoTTS\n        *2.11.0.4* Initial Issabel Foundation release\n    </changelog>\n    <category>Applications</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n    <description>\n        Plays back one of the system recordings or TTS (optionally allowing the user to skip it) and then goes to another destination.\n    </description>\n    <depends>\n        <version>2.5.0alpha1</version>\n        <module>recordings ge 3.3.8</module>\n    </depends>\n    <menuitems>\n        <announcement>Announcements</announcement>\n    </menuitems>\n    <popovers>\n        <announcement>\n            <display>announcement</display>\n        </announcement>\n     </popovers>\n    <supported>\n        <version>2.10</version>\n    </supported>\n        <location>release/2.11/announcement-2.11.0.5.tgz</location>\n        <md5sum>98f99ffb3aca6b5ff409c03830181494</md5sum>\n</module>\n<module>\n  <rawname>speeddial</rawname>\n  <repo>extended</repo>\n  <name>Speed Dial Functions</name>\n  <version>2.11.0.4</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<changelog>\n		*2.11.0.4* Initial Issabel Foundation release\n	</changelog>\n  <category>Settings</category>\n  <depends>\n    <module>phonebook</module>\n  </depends>\n        <location>release/2.11/speeddial-2.11.0.4.tgz</location>\n        <md5sum>39c2ad1c77fd4ab8a263360d1626aea9</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n  <rawname>phpinfo</rawname>\n  <repo>extended</repo>\n  <name>PHP Info</name>\n  <version>2.11.0.1</version>\n  <publisher>IssabelPBX</publisher>\n  <license>GPLv2+</license>\n  <changelog>\n	*2.11.0.1* Initial Issabel Foundation release\n  </changelog>\n  <category>Reports</category>\n  <menuitems>\n    <phpinfo>PHP Info</phpinfo>\n  </menuitems>\n        <location>release/2.11/phpinfo-2.11.0.1.tgz</location>\n        <md5sum>000ec68e16dd39753e04c9bb9d2154db</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n	<rawname>asteriskinfo</rawname>\n	<repo>standard</repo>\n	<name>Asterisk Info</name>\n	<version>2.11.0.89</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Reports</category>\n    <embedcategory>Advanced</embedcategory>\n	<description>\n		Provides a snapshot of the current Asterisk configuration\n	</description>\n	<menuitems>\n		<asteriskinfo>Asterisk Info</asteriskinfo>\n	</menuitems>\n	<depends>\n		<engine>asterisk</engine>\n		<version>2.5.0rc3</version>\n	</depends>\n	<changelog>\n		*2.11.0.9* Initial Issabel Foundation release\n		*0.1.0* Initial release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/asteriskinfo-2.11.0.89.tgz</location>\n        <md5sum>78be9997f6eea8d7b3252a46a1160dc6</md5sum>\n</module>\n<module>\n  <rawname>printextensions</rawname>\n  <repo>standard</repo>\n  <name>Print Extensions</name>\n  <version>2.11.0.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n  <category>Reports</category>\n  <description>Creates a printable list of extension numbers used throughout the system from all modules that provide an internal callable number</description>\n  <menuitems>\n    <printextensions>Print Extensions</printextensions>\n  </menuitems>\n	<changelog>\n		*2.11.0.2* Initial Issabel Foundation release\n	</changelog>\n        <location>release/2.11/printextensions-2.11.0.2.tgz</location>\n        <md5sum>fd26be22d1c75a2bc4a4828beb2e0e8d</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n	<rawname>tts</rawname>\n	<name>Text To Speech</name>\n	<version>2.11.0.10</version>\n	<repo>extended</repo>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<type>setup</type>\n	<description>Allows you to configure text to speech, and is derived from texttospeech provided in contributed modules.</description>\n	<category>Applications</category>\n	<menuitems>\n		<tts>Text To Speech</tts>\n	</menuitems>\n	<depends>\n		<engine>asterisk ge 1.6</engine>\n		<module>ttsengines</module>\n	</depends>\n        <location>release/2.11/tts-2.11.0.10.tgz</location>\n	<changelog>\n		2.11.0.10 Initial Issabel Foundation release\n	</changelog>\n	<popovers>\n		<tts>\n			<display>tts</display>\n		</tts>\n	</popovers>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <md5sum>981fea779c6b6eebe4ebfb3c1461a279</md5sum>\n</module>\n<module>\n	<rawname>dahdiconfig</rawname>\n	<repo>extended</repo>\n	<category>Connectivity</category>\n	<name>DAHDi Config</name>\n	<version>2.11.53</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<candisable>yes</candisable>\n	<canuninstall>yes</canuninstall>\n	<changelog>\n			*2.11.53* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n	<depends>\n		<phpversion>5.3.0</phpversion>\n		<version>2.10</version>\n	</depends>\n	<menuitems>\n		<dahdi needsenginedb=\"yes\">DAHDi Config</dahdi>\n	</menuitems>\n        <location>release/2.11/dahdiconfig-2.11.53.tgz</location>\n        <md5sum>87b7955672749e699de808be10df68e4</md5sum>\n</module>\n<module>\n	<rawname>framework</rawname>\n	<modtype>framework</modtype>\n	<repo>standard</repo>\n	<name>IssabelPBX Framework</name>\n	<version>2.11.0.48</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<candisable>no</candisable>\n	<canuninstall>no</canuninstall>\n	<changelog>\n        *2.11.0.48* Multi Park, ODBC functions, Supports for Asterisk 16\n        *2.11.0.47* Bump release for Aug 2018 iso and rebranding\n        *2.11.0.46* Add default res_parking.conf used in asterisk 13\n		*2.11.0.45* Update release\n		*2.11.0.44* GitHub release\n		*2.11.0.43* Initial Issabel Foundation release\n	</changelog>\n	<description>\n		This module provides a facility to install bug fixes to the framework code that is not otherwise housed in a module\n	</description>\n	<supported>\n		<version>2.11</version>\n	</supported>\n	<category>Admin</category>\n        <location>release/2.11/framework-2.11.0.48.tgz</location>\n        <md5sum>ad1fa0310893be1148ceab7bd7edc32f</md5sum>\n</module>\n<module>\n	<rawname>cidlookup</rawname>\n	<repo>standard</repo>\n	<name>CallerID Lookup</name>\n	<version>2.11.1.12</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<description>Allows CallerID Lookup of incoming calls against different sources (OpenCNAM, MySQL, HTTP, ENUM, Phonebook Module)</description>\n    <category>Admin</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n	<changelog>\n		*2.11.1.12* Initial Issabel Foundation release\n	</changelog>\n	<menuitems>\n		<cidlookup>CallerID Lookup Sources</cidlookup>\n	</menuitems>\n	<depends>\n		<engine>asterisk 1.6</engine>\n		<module>framework ge 2.11.0.0rc1.6</module>\n	</depends>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/cidlookup-2.11.1.12.tgz</location>\n        <md5sum>e17efc84bf3813c84b92a925eec7a2c5</md5sum>\n</module>\n<module>\n	<rawname>vmblast</rawname>\n	<repo>standard</repo>\n	<name>Voicemail Blasting</name>\n	<version>2.11.0.4</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n	<description>\n		Creates a group of extensions that calls a group of voicemail boxes and allows you to leave a message for them all at once.\n	</description>\n	<changelog>\n		*2.11.0.4* Initial Issabel Foundation release\n	</changelog>\n	<menuitems>\n		<vmblast>Voicemail Blasting</vmblast>\n	</menuitems>\n	<popovers>\n		<vmblast>\n			<display>vmblast</display>\n		</vmblast>\n 	</popovers>\n	<depends>\n		<version>2.4.0</version>\n	</depends>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/vmblast-2.11.0.4.tgz</location>\n        <md5sum>9c2a9300c603b4dccd6e6272e9082d7a</md5sum>\n</module>\n<module>\n    <rawname>dynroute</rawname>\n    <repo>standard</repo>\n    <name>Dynamic Routes</name>\n    <version>2.11.3.2</version>\n    <publisher>voipsupport.it</publisher>\n    <license>GPLv3+</license>\n    <type>setup</type>\n    <category>Advanced</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n    <description>\n        Allows to route call based on lookup in sql database and/or user input and to store results in channel variables\n    </description>\n    <changelog>\n        See CHANGES.txt file in module directory for full details.\n        *2.11.3.2* Bug fix\n        *2.11.3.1* Bug fix\n        *2.11.3.0* Asterisk variable source type\n        *2.11.2.0* AGI support\n        *2.11.1.0* Web service support\n        *2.11.0.0* ODBC support, popover compatibility, GUI cleanup, Updated Italian, Dutch translations\n        *2.10.0.2* Bug fix for db server name that was not saved, cleanups, dutch translations\n        *2.10.0.1* Security: prevent scripts from being called directly.\n        Updated uninstall from sql to php script, cosmetic and tooltip corrections.\n        *2.10.0.0* Only update is to change Category to be compatible with new menu categories (now under Applications instead of Inbound Call Control)\n        *2.8.0.0* Added ability to get dtmf input (with optional announcement) and storage of input and/or sql result in channel variables for use in further dynamic routes or custom extensions.\n        *2.6.0.2* First Release\n    </changelog>\n    <depends>\n        <version>ge2.11</version>\n        <module></module>\n    </depends>\n    <menuitems>\n        <dynroute>Dynamic Routes</dynroute>\n    </menuitems>\n        <popovers>\n                <dynroute>\n                        <display>dynroute</display>\n            <action>add</action>\n                </dynroute>\n        </popovers>\n        <location>release/2.11/dynroute-2.11.3.2.tgz</location>\n        <md5sum>0c7e3e6c0cf0e0ecad604e26af634878</md5sum>\n</module>\n<module>\n	<rawname>dashboard</rawname>\n	<repo>standard</repo>\n	<name>System Dashboard</name>\n	<version>2.11.0.5</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<candisable>no</candisable>\n	<canuninstall>no</canuninstall>\n	<category>Reports</category>\n	<description>\n		Provides a system information dashboard, showing information about Calls, CPU, Memory, Disks, Network, and processes.\n	</description>\n	<menuitems>\n		<dashboard display=\"index\" access=\"all\">IssabelPBX System Status</dashboard>\n	</menuitems>\n	<depends>\n		<version>2.3.0beta2</version>\n	</depends>\n	<changelog>\n		*2.11.0.5* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/dashboard-2.11.0.5.tgz</location>\n        <md5sum>f9746dda13e9df9adff71700fbcab253</md5sum>\n</module>\n<module>\n	<rawname>callforward</rawname>\n	<repo>standard</repo>\n	<name>Call Forward</name>\n	<version>2.11.5</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>AGPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/agpl-3.0.txt</licenselink>\n	<changelog>\n		*2.11.5* Initial Issabel Foundation release\n	</changelog>\n	<description>Provides callforward featurecodes</description>\n	<category>Applications</category>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/callforward-2.11.5.tgz</location>\n        <md5sum>6248a13b89e9c9345799096347b3f8bf</md5sum>\n</module>\n<module>\n	<rawname>miscdests</rawname>\n	<repo>extended</repo>\n	<name>Misc Destinations</name>\n	<version>2.11.0.4</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n	<description>Allows creating destinations that dial any local number (extensions, feature codes, outside phone numbers) that can be used by other modules (eg, IVR, time conditions) as a call destination.</description>\n	<changelog>\n		*2.11.0.4* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.5.0alpha1</version>\n	</depends>\n	<menuitems>\n		<miscdests>Misc Destinations</miscdests>\n	</menuitems>\n	<popovers>\n		<miscdests>\n			<display>miscdests</display>\n		</miscdests>\n	</popovers>\n        <location>release/2.11/miscdests-2.11.0.4.tgz</location>\n        <md5sum>6736d35eb781351534e7dc348f49d8e6</md5sum>\n	<supported>\n		<version>2.10</version>\n	</supported>\n</module>\n<module>\n  <rawname>restart</rawname>\n  <repo>unsupported</repo>\n  <name>Bulk Phone Restart</name>\n  <version>2.11.0.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n  <category>Admin</category>\n	<changelog>\n		*2.11.0.2* Initial Issabel Foundation release\n		*2.6.0.0* Initial release\n	</changelog>\n  <depends>\n    <version>2.5.0</version>\n  </depends>\n  <description>This module allows users to restart one or multiple phones that support being restarted via a SIP NOTIFY command through Asterisk\'s sip_notify.conf \n	</description>\n  <menuitems>\n    <restart>Phone Restart</restart>\n  </menuitems>\n        <location>release/2.11/restart-2.11.0.2.tgz</location>\n        <md5sum>3dd2a9e0253544c662c94648d2021bb5</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n	<rawname>bosssecretary</rawname>\n	<name>Boss Secretary</name>\n	<version>1.0</version>\n	<changelog>\n		*1.0* Module changed to new dialpan. Module is now compatible with Asterisk 1.6X and newer with all BLF functionality.\n	</changelog>\n    <repo>extended</repo>\n	<publisher>Issabel Foundation</publisher>\n	<category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n	<description>\n		The boss-secretary module creates a special ring group which includes\none or more \"bosses\" and one or more secretaries\". When someone calls\nthe boss\' extension, the secretary (or secretaries) extension will ring only, allowing the secretary to answer his or her boss\' call. Only secretary ( or secretaries ) or \'chief extensions\' are authorized to call directly to boss extension. With feature code you can turn on or off secretary group. \n	</description>\n	<menuitems>\n		<bosssecretary>Boss Secretary</bosssecretary>\n	</menuitems>\n</module>\n<module>\n	<rawname>fw_fop</rawname>\n	<repo>unsupported</repo>\n	<name>IssabelPBX FOP Framework</name>\n	<version>2.10.0.3</version>\n	<publisher>IssabelPBX</publisher>\n	<license>GPLv2+</license>\n	<menuitems>\n		<fw_fop href=\"modules/fw_fop/\" target=\"_fop\" access=\"all\">FOP Panel</fw_fop>\n	</menuitems>\n	<changelog>\n		*2.10.0.3* #5818\n		*2.10.0.2* #5496\n		*2.10.0.1* fix for fw_fop_parse_zapata\n		*2.10.0.0* upgrade xml info, category, support info\n		*2.10.0beta2.0* moving FOP to full module\n		*2.10.0beta1.0* beta1 release, see svn log\n		*2.9.0.1* #4401, #4914, #4404 \n		*2.9.0.0* 2.9 Update\n	</changelog>\n	<description>\n		This module provides the original FOP (Flash Operator Panel) which is known to have issues on Asterisk 1.8 and is no longer supported in favor of FOP2.\n	</description>\n	<category>Admin</category>\n	<depends>\n		<version>2.9.0beta2</version>\n	</depends>\n        <location>release/2.11/fw_fop-2.10.0.3.tgz</location>\n        <md5sum>85af7e6568ec89f8cd31a27dda42fc01</md5sum>\n</module>\n<module>\n	<rawname>dictate</rawname>\n	<repo>extended</repo>\n	<name>Dictation</name>\n	<version>2.11.0.3</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Applications</category>\n	<changelog>\n		*2.11.0.3* Initial Issabel Foundation release\n	</changelog>\n	<description>This uses the app_dictate module of Asterisk to let users record dictate into their phones. When complete, the dictations can be emailed to an email address specified in the extension page.</description>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/dictate-2.11.0.3.tgz</location>\n        <md5sum>967c00998438a7f0cee9863101ace629</md5sum>\n</module>\n<module>\n	<rawname>asternic</rawname>\n	<name>Asternic</name>\n	<version>2.11.0.0</version>\n	<repo>unsupported</repo>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Settings</category>\n	<description>A module for Asternic Call Center Stats PRO, that allows you to set if IVR selections should be logged to the queue logs.</description>\n	<depends>\n		<module>ivr ge 2.11.0.1</module>\n		<version>2.11.0alpha1</version>\n		<phpversion>5.3.0</phpversion>\n	</depends>\n	<menuitems>\n		<asternic>Asternic</asternic>\n	</menuitems>\n	<changelog>\n		*2.11.0.0* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/asternic-2.11.0.0.tgz</location>\n        <md5sum>e1fb9c4d68eecfca3a4da98fc85ce66d</md5sum>\n</module>\n<module>\n	<rawname>bulkextensions</rawname>\n	<repo>extended</repo>\n    <name>Bulk Extensions</name>\n	<description>Bulk Extensions uses CSV files to import and export extensions.</description>\n	<version>2.11.0.7</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Applications</category>\n	<menuitems>\n		<bulkextensions>Bulk Extensions</bulkextensions>\n	</menuitems>\n	<depends>\n		<version>ge2.10</version>\n	</depends>\n        <location>release/2.11/bulkextensions-2.11.0.7.tgz</location>\n	<info/>\n	<changelog>\n		*2.11.0.7* Initial Issabel Foundation release\n		*2.5.0.5* Add permit/deny fields provided by 4Colo. Fixed a small bug in table.csv. Fixed spelling error in template.csv. Added localization for table.csv. See CHANGES for how-to.\n		*0.1*	First release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <md5sum>2e53632661bc4824f7cf2935cefe75a0</md5sum>\n</module>\n<module>\n	<rawname>campon</rawname>\n	<repo>standard</repo>\n	<name>Camp-On</name>\n	<version>2.11.0.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Settings</category>\n	<changelog>\n		*2.11.0.3* Initial Issabel Foundation release\n	</changelog>\n	<description>This module implements the Call Completion Supplemental Services (CCSS) often referred to as Call Camping or Camp-On. It allows a caller to request the system call them back when a busy or non-responding extension becomes available. Requires Asterisk 1.8 or higher.\n	</description>\n	<depends>\n		<engine>asterisk 1.8</engine>\n	</depends>\n	<supported>\n		<version>2.9</version>\n	</supported>\n        <location>release/2.11/campon-2.11.0.2.tgz</location>\n        <md5sum>7f2488575d81239ff3e58a6fa626d543</md5sum>\n</module>\n<module>\n	<rawname>sipsettings</rawname>\n	<repo>standard</repo>\n	<candisable>no</candisable>\n	<canuninstall>no</canuninstall>\n	<name>Asterisk SIP Settings</name>\n	<version>2.11.0.9</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>AGPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/agpl-3.0.txt</licenselink>\n    <category>Settings</category>\n    <embedcategory>Advanced</embedcategory>\n	<menuitems>\n		<sipsettings>Asterisk SIP Settings</sipsettings>\n	</menuitems>\n	<description>\n		Use to configure Various Asterisk SIP Settings in the General section of sip.conf. Also includes an auto-configuration tool to determine NAT settings. The module assumes Asterisk version 1.4 or higher. Some settings may not exist in Asterisk 1.2 and will be ignored by Asterisk.\n	</description>\n	<changelog>\n		*2.11.0.9* Initial Issabel Foundation release\n	</changelog>\n    <depends>\n        <module>core ge 2.11.0.0beta2.4</module>\n    </depends>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/sipsettings-2.11.0.9.tgz</location>\n        <md5sum>ce4cd15d926ae9276e86e4d72d57accf</md5sum>\n</module>\n<module>\n  <rawname>phpagiconf</rawname>\n  <repo>unsupported</repo>\n  <name>PHPAGI Config</name>\n  <version>2.11.0.2</version>\n  <publisher>Issabel Foundation</publisher>\n  <license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n  <category>Settings</category>\n  <menuitems>\n    <phpagiconf>PHPAGI Config</phpagiconf>\n  </menuitems>\n  <depends>\n    <module>manager ge1.0.4</module>\n  </depends>\n  <changelog>\n    *2.11.0.2* Initial Issabel Foundation release\n  </changelog>\n        <location>release/2.11/phpagiconf-2.11.0.2.tgz</location>\n        <md5sum>df37b454a9396ba53f1f5df81b25ada1</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n	<rawname>fw_langpacks</rawname>\n	<modtype>framework</modtype>\n	<repo>extended</repo>\n	<name>IssabelPBX Localization Updates</name>\n	<version>2.11.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<changelog>\n		*2.11.2* Initial Issabel Foundation release\n	</changelog>\n	<description>\n		This module provides a facility to install new and updated localization translations for all components in IssabelPBX. Localization i18n translations are still kept with each module and other components such as the User Portal (ARI). This provides an easy ability to bring all components up-to-date without the need of publishing dozens of modules for every minor change. The localization updates used will be the latest available for all modules and will not consider the current version you are running.\n	</description>\n	<category>Admin</category>\n        <location>release/2.11/fw_langpacks-2.11.2.tgz</location>\n        <md5sum>35fdd36e3cb134bd3462cd5808207120</md5sum>\n	<supported>\n		<version>2.11</version>\n	</supported>\n</module>\n<module>\n	<rawname>findmefollow</rawname>\n	<repo>standard</repo>\n	<name>Follow Me</name>\n	<version>2.11.0.6</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<changelog>\n		*2.11.0.6* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.5.0alpha1</version>\n		<module>recordings ge 3.3.8</module>\n	</depends>\n    <category>Applications</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n	<description>\n		Much like a ring group, but works on individual extensions. When someone calls the extension, it can be setup to ring for a number of seconds before trying to ring other extensions and/or external numbers, or to ring all at once, or in other various \'hunt\' configurations. Most commonly used to ring someone\'s cell phone if they don\'t answer their extension.\n	</description>\n	<menuitems>\n		<findmefollow needsenginedb=\"yes\">Follow Me</findmefollow>\n	</menuitems>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/findmefollow-2.11.0.6.tgz</location>\n        <md5sum>a7df4c8450760ea9e21b3437bb86206d</md5sum>\n</module>\n<module>\n	<rawname>digium_phones</rawname>\n	<repo>standard</repo>\n	<type>setup</type>\n	<category>Connectivity</category>\n	<name>Digium Phones Config</name>\n	<version>2.11.3.3</version>\n	<publisher>Digium</publisher>\n	<license>GPLv2</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<candisable>yes</candisable>\n	<canuninstall>yes</canuninstall>\n	<changelog>\n        *2.11.3.3* Rebranding\n		*2.11.3.2* IssabelPBX initial release\n		*2.11.0.1* FreePBX/Schmoozecom Release\n		*0.1* initial commit\n	</changelog>\n	<depends>\n		<phpversion>5.2.0</phpversion>\n		<version>2.10</version>\n        <module>framework ge 2.11.0.47</module>\n    </depends>\n	<menuitems>\n		<digium_phones needsenginedb=\"yes\">Digium Phones</digium_phones>\n	</menuitems>\n	<supported>\n		<version>2.11.0</version>\n	</supported>\n        <location>release/2.11/digium_phones-2.11.3.3.tgz</location>\n        <md5sum>f1dbf298e09c54ef69078e79104f6997</md5sum>\n</module>\n<module>\n    <rawname>recordings</rawname>\n    <repo>standard</repo>\n    <name>Recordings</name>\n    <version>3.4.0.4</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <canuninstall>no</canuninstall>\n    <category>Admin</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n    <description>Creates and manages system recordings, used by many other modules (eg, IVR).</description>\n    <changelog>\n        *3.4.0.4* Adds recording from browser\n        *3.4.0.3* Initial Issabel Foundation release\n    </changelog>\n    <menuitems>\n        <recordings>System Recordings</recordings>\n    </menuitems>\n    <depends>\n       <module>framework ge 2.11.0.47</module>\n    </depends>\n    <supported>\n        <version>2.11</version>\n    </supported>\n        <location>release/2.11/recordings-3.4.0.4.tgz</location>\n        <md5sum>f7f1dc5521bdcddc444620a81d300176</md5sum>\n</module>\n<module>\n    <rawname>motif</rawname>\n    <name>Google Voice/Chan Motif</name>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <type>setup</type>\n    <repo>standard</repo>\n    <category>Connectivity</category>\n	<version>2.11.17</version>\n    <description>\n        Manage Google Voice Trunks with Chan Motif\n    </description>\n    <changelog>\n	*2.11.17* Initial Issabel Foundation release\n    </changelog>\n    <depends>\n        <engine>asterisk 11</engine>\n        <module>core ge 2.11.0.0beta2.4</module>\n    </depends>\n    <menuitems>\n        <motif>Google Voice (Motif)</motif>\n    </menuitems>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/motif-2.11.17.tgz</location>\n        <md5sum>b9b9eff259a0d7918e77abba78c1eda5</md5sum>\n</module>\n<module>\n	<rawname>pinsets</rawname>\n	<repo>standard</repo>\n	<name>PIN Sets</name>\n	<version>2.11.0.9</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Settings</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n	<description>Allow creation of lists of PINs (numbers for passwords) that can be used by other modules (eg, trunks).</description>\n	<changelog>\n		*2.11.0.9* Initial Issabel Foundation release\n	</changelog>\n	<menuitems>\n		<pinsets>PIN Sets</pinsets>\n	</menuitems>\n	<supported>\n		<version>2.10</version>\n	</supported>\n	<depends>\n		<module>core</module>\n	</depends>\n        <location>release/2.11/pinsets-2.11.0.9.tgz</location>\n	<methods>\n		<get_config pri=\"481\">pinsets_get_config</get_config>\n	</methods>\n        <md5sum>f1fc09766e4373bafd7ea553f82b90fe</md5sum>\n</module>\n<module>\n  <rawname>phonebook</rawname>\n  <repo>extended</repo>\n  <name>Phonebook</name>\n  <version>2.11.0.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n  <description>Provides a phonebook for IssabelPBX, it can be used as base for Caller ID Lookup and Speed Dial</description>\n  <category>Admin</category>\n  <menuitems>\n    <phonebook needsenginedb=\"yes\">Asterisk Phonebook</phonebook>\n  </menuitems>\n        <location>release/2.11/phonebook-2.11.0.2.tgz</location>\n        <md5sum>667c2f1d7a490e55ae54b23db1194ac7</md5sum>\n  <changelog>\n  		*2.11.0.2* Initial Issabel Foundation release\n	</changelog>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n        <rawname>setcid</rawname>\n        <repo>standard</repo>\n        <name>Set CallerID</name>\n        <version>2.11.1.0</version>\n        <category>Applications</category>\n        <embedcategory>Inbound Call Control</embedcategory>\n        <publisher>Issabel Foundation</publisher>\n        <license>GPLv3+</license>\n        <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n        <description>\n                Adds the ability to change the CallerID within a call flow.\n        </description>\n        <menuitems>\n                <setcid>Set CallerID</setcid>\n        </menuitems>\n        <changelog>\n                *2.11.1.0* Add custom Variables support\n                *2.11.0.4* Initial Issabel Foundation release\n        </changelog>\n        <depends>\n                <version>2.5.0</version>\n        </depends>\n        <supported>\n                <version>2.10</version>\n        </supported>\n        <location>release/2.11/setcid-2.11.1.0.tgz</location>\n        <md5sum>3877aaaef9cd3348ee5903c68a7f7a8b</md5sum>\n</module>\n<module>\n	<rawname>managersettings</rawname>\n	<repo>standard</repo>\n	<name>Asterisk Manager Settings</name>\n	<version>2.11.0.0</version>\n	<publisher>Issabel Foundation</publisher>\n	<licenselink>http://www.gnu.org/licenses/agpl-3.0.txt</licenselink>\n	<license>AGPLv3</license>\n    <category>Settings</category>\n    <embedcategory>Advanced</embedcategory>\n	<menuitems>\n		<managersettings>Asterisk Manager Settings</managersettings>\n	</menuitems>\n	<description>\n		Use to configure Various Asterisk Manager Settings in the General section of manager.conf. The module assumes Asterisk version 11 or higher.\n	</description>\n	<changelog>\n		*2.11.0.0* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/managersettings-2.11.0.0.tgz</location>\n        <md5sum>548af5d87d3efd79cf77431fa713a66e</md5sum>\n</module>\n<module>\n	<rawname>logfiles</rawname>\n	<repo>standard</repo>\n	<name>Asterisk Logfiles</name>\n	<canuninstall>no</canuninstall>\n	<version>2.11.1.4</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<changelog>\n        *2.11.1.4* Rebranding\n		*2.11.1.3* Initial Issabel Foundation release\n	</changelog>\n	<category>Reports</category>\n	<embedcategory>Advanced</embedcategory>\n	<menuitems>\n		<logfiles>Asterisk Logfiles</logfiles>\n		<logfiles_settings category=\"Settings\">Asterisk Logfile Settings</logfiles_settings>\n	</menuitems>\n	<supported>\n		<version>2.11.0</version>\n    </supported>\n    <depends>\n       <module>framework ge 2.11.0.47</module>\n    </depends>\n        <location>release/2.11/logfiles-2.11.1.4.tgz</location>\n        <md5sum>c69dbe1de5481980a8c67c0d59d82229</md5sum>\n</module>\n<module>\n	<rawname>disa</rawname>\n	<repo>extended</repo>\n	<name>DISA</name>\n	<version>2.11.0.6</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Remote Access</embedcategory>\n	<menuitems>\n		<disa>DISA</disa>\n	</menuitems>\n	<popovers>\n		<disa>\n			<display>disa</display>\n		</disa>\n 	</popovers>\n	<description>DISA Allows you \'Direct Inward System Access\'. This gives you the ability to have an option on an IVR that gives you a dial tone, and you\'re able to dial out from the IssabelPBX machine as if you were connected to a standard extension. It appears as a Destination.</description>\n	<changelog>\n		*2.11.0.6* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.4.0</version>\n	</depends>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/disa-2.11.0.6.tgz</location>\n        <md5sum>bf9ccaa4f81925748b63ab0fcbf50912</md5sum>\n</module>\n<module>\n    <rawname>outroutemsg</rawname>\n    <repo>standard</repo>\n    <name>Route Congestion Messages</name>\n    <version>2.11.0.3</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Settings</category>\n    <embedcategory>Advanced</embedcategory>\n    <description>Configures message or congestion tones played when all trunks are busy in a route. Allows different messages for Emergency Routes and Intra-Company Routes\n    </description>\n    <menuitems>\n        <outroutemsg>Route Congestion Messages</outroutemsg>\n    </menuitems>\n    <changelog>\n        *2.11.0.3* Add HangupCause check for unallocated numbers and info tone\n        *2.11.0.2* Initial Issabel Foundation release\n    </changelog>\n    <depends>\n        <module>recordings ge 3.3.8</module>\n    </depends>\n        <location>release/2.11/outroutemsg-2.11.0.3.tgz</location>\n        <md5sum>279f092d2132d8b427cb371f3336e757</md5sum>\n    <supported>\n        <version>2.10</version>\n    </supported>\n</module>\n<module>\n	<rawname>ringgroups</rawname>\n	<repo>standard</repo>\n	<name>Ring Groups</name>\n	<version>2.11.0.6</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n	<description>\n		Creates a group of extensions that all ring together. Extensions can be rung all at once, or in various \'hunt\' configurations. Additionally, external numbers are supported, and there is a call confirmation option where the callee has to confirm if they actually want to take the call before the caller is transferred.\n	</description>\n	<changelog>\n		*2.11.0.6* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.5.0alpha1</version>\n		<module>recordings ge 3.3.8</module>\n	</depends>\n	<menuitems>\n		<ringgroups>Ring Groups</ringgroups>\n	</menuitems>\n	<popovers>\n		<ringgroups>\n			<display>ringgroups</display>\n		</ringgroups>\n 	</popovers>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/ringgroups-2.11.0.6.tgz</location>\n        <md5sum>24b4c2743d49b49c888405b36d70d641</md5sum>\n</module>\n<module>\n	<rawname>customerdb</rawname>\n	<name>Customer DB</name>\n	<version>2.5.0.4</version>\n	<type>tool</type>\n	<category>Third Party Addon</category>\n	<menuitems>\n		<customerdb>Customer DB</customerdb>\n	</menuitems>\n	<changelog>\n		*2.5.0.4* localization updates\n		*2.5.0.3* localization enclosures\n		*2.5.0.2* #2987 sqlite3 install script changes\n		*2.5.0.1* #2781 allow sqlite table creation\n		*2.5.0* #2845 tabindex\n		*2.4.0* it translations, bump for 2.4\n		*1.2.3.1* bump for rc1\n		*1.2.3* Add he_IL translation\n	</changelog>\n        <location>release/2.11/customerdb-2.5.0.4.tgz</location>\n        <md5sum>4cd70ff6e38632bc0a9aa2d1dcc37745</md5sum>\n</module>\n\n<module>\n	<rawname>hotelwakeup</rawname>\n	<name>Wake Up Calls</name>\n	<repo>standard</repo>\n	<version>2.11.3</version>\n	<license>GPLv2</license>\n	<publisher>POSSA</publisher>\n	<category>Applications</category>\n		<description>IssabelPBX module for generating reminder and wakeup calls</description>\n	<info>https://github.com/POSSA/Hotel-Style-Wakeup-Calls</info>\n	 <changelog>\n		 *2.11.3* Initial Issabel Foundation release\n	</changelog>\n	<menuitems>\n		<hotelwakeup>Wake Up Calls</hotelwakeup>\n	</menuitems>\n	<depends>\n		<module>ivr gt1.0</module>\n		<version>ge 2.9</version>\n		<engine>asterisk 1.2</engine>\n	</depends>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/hotelwakeup-2.11.3.tgz</location>\n        <md5sum>8cc536cd850013c65c55ce85d8ce94f8</md5sum>\n</module>\n<module>\n    <rawname>paging</rawname>\n    <repo>standard</repo>\n    <name>Paging and Intercom</name>\n    <version>2.11.0.10</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n    <changelog>\n        *2.11.0.10* Rebranding\n        *2.11.0.9* Initial Issabel Foundation release\n    </changelog>\n    <depends>\n        <version>2.11.0</version>\n        <module>framework ge 2.11.0.47</module>\n    </depends>\n    <description>Allows creation of paging groups to make announcements using the speaker built into most SIP phones. \n        Also creates an Intercom feature code that can be used as a prefix to talk directly to one person, as well as optional feature codes to block/allow intercom calls to all users as well as blocking specific users or only allowing specific users.</description>\n    <menuitems>\n        <paging>Paging and Intercom</paging>\n    </menuitems>\n    <requirements>\n        <module>conferences</module>\n    </requirements>\n    <popovers>\n        <paging>\n            <display>paging</display>\n            <action>add</action>\n        </paging>\n    </popovers>\n        <location>release/2.11/paging-2.11.0.10.tgz</location>\n        <md5sum>154ed1f3baff828a67f2bad663e81e6d</md5sum>\n    <supported>\n		<version>2.11.0</version>\n    </supported>\n</module>\n<module>\n  <rawname>extensionsettings</rawname>\n  <repo>unsupported</repo>\n  <name>Extension Settings</name>\n  <version>2.11.0.2</version>\n  <publisher>Mikael Carlsson</publisher>\n  <license>GPLv2</license>\n  <category>Settings</category>\n  <description>Creates a list of all extensions and their current settings for CW, CF, CFB, CFU, VMXB and VMXU</description>\n  <menuitems>\n    <extensionsettings>Extension Settings</extensionsettings>\n  </menuitems>\n  <changelog>\n		*2.11.0.2* Initial Issabel Foundation release\n	</changelog>\n        <md5sum>c2253809614e923ad16126c38cb81258</md5sum>\n        <location>release/2.11/extensionsettings-2.11.0.2.tgz</location>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n    <rawname>miscapps</rawname>\n    <repo>extended</repo>\n    <name>Misc Applications</name>\n    <version>2.11.0.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n    <description>\n		Adds the ability to create feature codes that can go to any IssabelPBX destination (such as an IVR or queue)\n	</description>\n    <menuitems>\n        <miscapps>Misc Applications</miscapps>\n    </menuitems>\n    <changelog>\n  		*2.11.0.2* Initial Issabel Foundation release\n	</changelog>\n    <depends>\n        <version>2.4.0</version>\n    </depends>\n        <location>release/2.11/miscapps-2.11.0.2.tgz</location>\n        <md5sum>8c88bb73e52fd41cebc86a30c5d60bd2</md5sum>\n    <supported>\n        <version>2.10</version>\n    </supported>\n</module>\n<module>\n	<rawname>bulkdids</rawname>\n	<repo>extended</repo>\n	<name>Bulk DIDs</name>\n	<description>Bulk DIDs uses CSV files to import bulk DIDs with a destination.</description>\n	<version>2.11.1.4</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<category>Applications</category>\n	<menuitems>\n		<bulkdids>Bulk DIDs</bulkdids>\n	</menuitems>\n	<depends>\n		<version>ge2.10alpha0</version>\n	</depends>\n        <location>release/2.11/bulkdids-2.11.1.4.tgz</location>\n	<info/>\n	<changelog>\n		*2.11.1.4* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <md5sum>61813f3b3e96d0677b93520fadfbc5b9</md5sum>\n</module>\n<module>\n	<rawname>directory</rawname>\n	<repo>standard</repo>\n	<name>Directory</name>\n	<version>2.11.0.5</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<type>setup</type>\n	<category>Applications</category>\n	<menuitems>\n		<directory>Directory</directory>\n	</menuitems>\n	<popovers>\n		<directory>\n			<display>directory</display>\n			<action>add</action>\n		</directory>\n 	</popovers>\n	<depends>\n		<version>2.8.0alpha1</version>\n		<module>recordings ge 3.3.8</module>\n	</depends>\n	<changelog>\n		*2.11.0.5* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/directory-2.11.0.5.tgz</location>\n        <md5sum>fcdf1f60efd15ab2a611dcf77f6c946c</md5sum>\n</module>\n<module>\n	<rawname>customappsreg</rawname>\n	<repo>standard</repo>\n	<name>Custom Applications</name>\n	<version>2.11.0.2</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Admin</category>\n    <embedcategory>Advanced</embedcategory>\n	<description>\n		Registry to add custom extensions and destinations that may be created and used so that the Extensions and Destinations Registry can include these.\n	</description>\n	<menuitems>\n		<customextens>Custom Extensions</customextens>\n		<customdests>Custom Destinations</customdests>\n	</menuitems>\n	<popovers>\n		<customappsreg>\n			<display>customdests</display>\n		</customappsreg>\n 	</popovers>\n	<changelog>\n		*2.11.0.2* Initial Issabel Foundation release\n	</changelog>\n  <depends>\n    <version>2.4.0</version>\n  </depends>\n        <location>release/2.11/customappsreg-2.11.0.2.tgz</location>\n        <md5sum>16bec09eafa00acc3f6f21deadb0480a</md5sum>\n  <supported>\n    <version>2.10</version>\n  </supported>\n</module>\n<module>\n    <rawname>parking</rawname>\n    <repo>standard</repo>\n    <name>Parking Lot</name>\n    <version>2.11.0.16</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n    <description>Manages parking lot extensions and other options.\n    Parking is a way of putting calls \"on hold\", and then picking them up from any extension.\n    </description>\n    <changelog>\n        *2.11.0.16* Add support for mutiple parking lots\n        *2.11.0.15* Initial Issabel Foundation release\n    </changelog>\n    <menuitems>\n        <parking>Parking</parking>\n    </menuitems>\n    <depends>\n        <engine>asterisk ge 1.8</engine>\n        <version>2.11</version>\n        <module>core ge 2.11.0.48</module>\n    </depends>\n    <supported>\n        <version>2.11</version>\n    </supported>\n        <location>release/2.11/parking-2.11.0.16.tgz</location>\n        <md5sum>c755d0a3723a95e05e610c1b368d4cec</md5sum>\n</module>\n<module>\n	<rawname>superfecta</rawname>\n	<repo>extended</repo>\n	<name>CID Superfecta</name>\n	<version>2.11.18</version>\n	<type>setup</type>\n	<category>Admin</category>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv2+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-2.0.txt</licenselink>\n	<description>\n		Provides simultaneous use of, and complete control over multiple caller id data sources.\n	</description>\n	<changelog>\n        *2.11.18* Rebranding Changes\n		*2.11.17* Initial Issabel Foundation release\n	</changelog>\n	<menuitems>\n		<superfecta>CID Superfecta</superfecta>\n	</menuitems>\n	<info>https://github.com/POSSA/Caller-ID-Superfecta/wiki</info>\n	<supported>\n		<version>2.11.0</version>\n    </supported>\n	<depends>\n        <module>framework ge 2.11.0.47</module>\n	</depends>\n        <location>release/2.11/superfecta-2.11.18.tgz</location>\n        <md5sum>c52858e1a33f4697f223ec2cd26d21f3</md5sum>\n</module>\n<module>\n	<rawname>callrecording</rawname>\n	<repo>standard</repo>\n	<name>Call Recording</name>\n	<version>2.11.0.10</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n	<candisable>no</candisable>\n	<canuninstall>no</canuninstall>\n	<category>Applications</category>\n    <embedcategory>Inbound Call Control</embedcategory>\n	<description>\n		Provides much of the call recording functionality.\n	</description>\n	<menuitems>\n		<callrecording>Call Recording</callrecording>\n	</menuitems>\n 	<popovers>\n		<callrecording>\n			<display>callrecording</display>\n		</callrecording>\n 	</popovers>\n	<changelog>\n		*2.11.0.10* Embed in Issabel Menu\n		*2.11.0.9* Initial Issabel Foundation release\n	</changelog>\n	<supported>\n		<version>2.11</version>\n	</supported>\n        <location>release/2.11/callrecording-2.11.0.10.tgz</location>\n        <md5sum>f04b934f672c1e1ee462d50fbdf68ba7</md5sum>\n</module>\n<module>\n    <rawname>gabcast</rawname>\n    <name>Gabcast</name>\n    <version>2.5.0.2</version>\n    <type>tool</type>\n    <category>Third Party Addon</category>\n    <menuitems>\n        <gabcast>Gabcast</gabcast>\n    </menuitems>\n    <changelog>\n        *2.5.0.2* localization updates\n        *2.5.0.1* added localization ability\n        *2.5.0* localization fixes\n        *2.4.0.1* added depends on 2.4.0\n        *2.4.0* add dest registry, fix rnav formating\n        *1.2.5.1* bump for rc1\n        *1.2.5* #2070 fix proper use of script tags\n        *1.2.4* changed ${CALLERID(number)} to ${AMPUSER} to accomodate CID number masquerading\n        *1.2.3* Add he_IL translation\n        *1.2.2* Fix issue where you were unable to add a channel \n    </changelog>\n    <depends>\n        <version>2.4.0</version>\n    </depends>\n        <location>release/2.11/gabcast-2.5.0.2.tgz</location>\n        <md5sum>1bfb8f2e901a3c241c5073c9f6467d0d</md5sum>\n</module>\n<module>\n	<rawname>callback</rawname>\n	<repo>extended</repo>\n	<name>Callback</name>\n	<version>2.11.0.4</version>\n	<publisher>Issabel Foundation</publisher>\n	<license>GPLv3+</license>\n	<licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Remote Access</embedcategory>\n	<menuitems>\n		<callback>Callback</callback>\n	</menuitems>\n	<popovers>\n		<callback>\n			<display>callback</display>\n		</callback>\n 	</popovers>\n	<changelog>\n		*2.11.0.4* Initial Issabel Foundation release\n	</changelog>\n	<depends>\n		<version>2.4.0</version>\n	</depends>\n	<supported>\n		<version>2.10</version>\n	</supported>\n        <location>release/2.11/callback-2.11.0.4.tgz</location>\n        <md5sum>24cbbf1f49918d9319511406251ed5b2</md5sum>\n</module>\n<module>\n    <rawname>languages</rawname>\n    <repo>extended</repo>\n    <name>Languages</name>\n    <version>2.11.0.2</version>\n    <publisher>Issabel Foundation</publisher>\n    <license>GPLv3+</license>\n    <licenselink>http://www.gnu.org/licenses/gpl-3.0.txt</licenselink>\n    <category>Applications</category>\n    <embedcategory>Internal Options &amp; Configuration</embedcategory>\n    <description>\n        Adds the ability to changes the language within a call flow and add language attribute to users.\n    </description>\n    <menuitems>\n        <languages>Languages</languages>\n    </menuitems>\n    <popovers>\n        <languages>\n            <display>languages</display>\n        </languages>\n    </popovers>\n    <changelog>\n        *2.11.0.2* Initial Issabel Foundation release\n    </changelog>\n    <depends>\n        <version>2.5.0alpha1</version>\n    </depends>\n        <location>release/2.11/languages-2.11.0.2.tgz</location>\n        <md5sum>c1ebf0621cfd27e584637693a712a495</md5sum>\n    <supported>\n        <version>2.10</version>\n    </supported>\n</module>\n</xml>\n\n');
/*!40000 ALTER TABLE `module_xml` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `modules`
--

LOCK TABLES `modules` WRITE;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` (`id`, `modulename`, `version`, `enabled`) VALUES (59,'core','2.11.0.35',1),(60,'iaxsettings','2.11.0.3',1),(61,'paging','2.11.0.9',1),(62,'featurecodeadmin','2.11.0.2',1),(63,'asteriskinfo','2.11.0.89',1),(64,'callwaiting','2.11.0.4',1),(65,'restart','2.11.0.2',1),(66,'phpagiconf','2.11.0.2',1),(67,'music','2.11.0.3',1),(68,'dictate','2.11.0.3',1),(69,'ringgroups','2.11.0.6',1),(70,'infoservices','2.11.0.3',1),(71,'timeconditions','2.11.1.1',1),(72,'ivr','2.11.0.10',1),(73,'callrecording','2.11.0.9',1),(74,'phonebook','2.11.0.2',1),(75,'gabcast','2.5.0.2',1),(76,'inventorydb','2.5.0.2',1),(77,'logfiles','2.11.1.3',1),(78,'outroutemsg','2.11.0.2',1),(79,'miscapps','2.11.0.2',1),(80,'manager','2.11.0.5',1),(81,'customcontexts','2.11.0.2',1),(82,'vmblast','2.11.0.4',1),(83,'printextensions','2.11.0.2',1),(84,'framework','2.11.0.43',1),(85,'sipsettings','2.11.0.9',1),(86,'voicemail','2.11.1.6',1),(87,'callforward','2.11.5',1),(88,'announcement','2.11.0.4',1),(89,'miscdests','2.11.0.4',1),(90,'dashboard','2.11.0.5',1),(91,'recordings','3.4.0.3',1),(92,'asterisk-cli','2.11.0.3',1),(93,'weakpasswords','2.11.0.1',1),(94,'queues','2.11.0.27',1),(95,'cidlookup','2.11.1.12',1),(96,'donotdisturb','2.11.0.3',1),(97,'backup','2.11.0.22',1),(98,'customappsreg','2.11.0.2',1),(99,'conferences','2.11.0.6',1),(100,'pbdirectory','2.11.0.5',1),(101,'blacklist','2.11.0.6',1),(102,'disa','2.11.0.6',1),(103,'cdr','2.11.0.12',1),(104,'javassh','2.11.2',1),(105,'queueprio','2.11.0.2',1),(106,'callback','2.11.0.4',1),(107,'speeddial','2.11.0.4',1),(108,'pinsets','2.11.0.9',1),(109,'fw_langpacks','2.11.2',1),(110,'languages','2.11.0.2',1),(111,'customerdb','2.5.0.4',1),(112,'parking','2.11.0.15',1),(113,'fax','2.11.0.9',1),(114,'findmefollow','2.11.0.6',1),(115,'dundicheck','2.11.0.3',1),(116,'phpinfo','2.11.0.1',1),(117,'daynight','2.11.0.6',1),(118,'fw_ari','2.11.1.5',1);
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` (`module`, `id`, `level`, `display_text`, `extended_text`, `link`, `reset`, `candelete`, `timestamp`) VALUES ('issabelpbx','NOEMAIL',600,'No email address for online update checks','You are automatically checking for online updates nightly but you have no email address setup to send the results. This can be set in Module Admin. They will continue to show up here.','',0,0,1636955641),('weakpasswords','all',200,'5 extensions/trunks have weak secrets','Warning: The use of weak SIP/IAX passwords can compromise this system resulting in toll theft of your telephony service.  You should change the reported devices and trunks to use strong secrets.<br /><br />Extension: 2000 / Secret has consecutive digit 1<br>Extension: 2002 / Secret has consecutive digit 1<br>Extension: 2003 / Secret has consecutive digit 1<br>Extension: 2005 / Secret has consecutive digit 1<br>Extension: 2006 / Secret has consecutive digit 1<br>','',0,0,1635967355),('retrieve_conf','BADDEST',400,'There are 9 bad destinations','DEST STATUS: ORPHAN\n   Announcement: 531-SER-20171019-BVOZ-FUERADESERVICIO-ESP-81473702\n   Queue: 18147370226-ESP (18147370226)\n   Queue: 18147370234-ESP (18147370234)\n   Queue: 19847770192-ESP (19847770192)\n   Ring Group: 547-TOD-20170926-8147370221-1 (611)\n   Ring Group: 531-SER-20170927-8147370230-1 (616)\n   Ring Group: 558-SER-20170927-8147370233-1 (617)\n   Ring Group: 566-BER-20170927-8147370234-1 (618)\nDEST STATUS: EMPTY\n   Queue: 10011 (10011)\n','',0,0,1635967347),('issabelpbx','NEWUPDATES',300,'There are 15 modules available for online upgrades','announcement 2.11.0.5 (current: 2.11.0.4)\nbackup 2.11.0.23 (current: 2.11.0.22)\ncallrecording 2.11.0.10 (current: 2.11.0.9)\ncore 2.11.0.48 (current: 2.11.0.35)\nfax 2.11.0.10 (current: 2.11.0.9)\nframework 2.11.0.48 (current: 2.11.0.43)\nivr 2.11.0.12 (current: 2.11.0.10)\nlogfiles 2.11.1.4 (current: 2.11.1.3)\noutroutemsg 2.11.0.3 (current: 2.11.0.2)\npaging 2.11.0.10 (current: 2.11.0.9)\nparking 2.11.0.16 (current: 2.11.0.15)\nqueues 2.11.0.30 (current: 2.11.0.27)\nrecordings 3.4.0.4 (current: 3.4.0.3)\ntimeconditions 2.11.1.2 (current: 2.11.1.1)\nvoicemail 2.11.1.7 (current: 2.11.1.6)\n','',0,0,1636923244);
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `outbound_route_patterns`
--

LOCK TABLES `outbound_route_patterns` WRITE;
/*!40000 ALTER TABLE `outbound_route_patterns` DISABLE KEYS */;
INSERT INTO `outbound_route_patterns` (`route_id`, `match_pattern_prefix`, `match_pattern_pass`, `match_cid`, `prepend_digits`) VALUES (7,'999','001XXXXXXXXXX','',''),(7,'999','01800XXXXXXX','',''),(7,'999','01XXXXXXXXXX','',''),(7,'999','044XXXXXXXXXX','',''),(7,'999','045XXXXXXXXXX','',''),(7,'999','56XXXXXX','',''),(7,'999','XXXXXXXX','',''),(7,'999','XXXXXXXXXX','',''),(12,'','001XXXXXXXXXX','',''),(12,'','01800XXXXXXX','',''),(12,'','01XXXXXXXXXX','',''),(12,'','044XXXXXXXXXX','',''),(12,'','045XXXXXXXXXX','',''),(12,'','56XXXXXX','',''),(12,'','XXXXXXX','',''),(12,'','XXXXXXXX','',''),(12,'','XXXXXXXXXX','',''),(13,'777','XXXXXXXXXX','','');
/*!40000 ALTER TABLE `outbound_route_patterns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `outbound_route_sequence`
--

LOCK TABLES `outbound_route_sequence` WRITE;
/*!40000 ALTER TABLE `outbound_route_sequence` DISABLE KEYS */;
INSERT INTO `outbound_route_sequence` (`route_id`, `seq`) VALUES (7,0),(12,1),(13,2);
/*!40000 ALTER TABLE `outbound_route_sequence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `outbound_route_trunks`
--

LOCK TABLES `outbound_route_trunks` WRITE;
/*!40000 ALTER TABLE `outbound_route_trunks` DISABLE KEYS */;
INSERT INTO `outbound_route_trunks` (`route_id`, `trunk_id`, `seq`) VALUES (7,2,0),(7,3,1),(7,4,2),(7,5,3),(7,6,4),(7,7,5),(7,8,6),(7,9,7),(7,10,8),(7,11,9),(7,12,10),(7,13,11),(7,14,12),(7,15,13),(7,16,14),(7,17,15),(7,18,16),(7,19,17),(7,20,18),(7,21,19),(7,22,20),(7,23,21),(7,24,22),(7,25,23),(7,26,24),(7,27,59),(7,28,58),(7,29,25),(7,30,27),(7,31,26),(7,32,28),(7,33,29),(7,34,30),(7,35,31),(7,36,32),(7,37,33),(7,38,34),(7,39,35),(7,40,36),(7,41,37),(7,42,38),(7,43,39),(7,44,40),(7,45,41),(7,46,42),(7,47,43),(7,48,44),(7,49,45),(7,50,46),(7,51,47),(7,52,48),(7,53,49),(7,54,50),(7,55,51),(7,56,52),(7,57,53),(7,58,54),(7,59,55),(7,60,56),(7,61,57),(12,62,0),(13,11,0);
/*!40000 ALTER TABLE `outbound_route_trunks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `outbound_routes`
--

LOCK TABLES `outbound_routes` WRITE;
/*!40000 ALTER TABLE `outbound_routes` DISABLE KEYS */;
INSERT INTO `outbound_routes` (`route_id`, `name`, `outcid`, `outcid_mode`, `password`, `emergency_route`, `intracompany_route`, `mohclass`, `time_group_id`, `dest`) VALUES (13,'rutatest','8147370230','','','','','default',NULL,''),(7,'rutasalidaalestra','','','','','','none',NULL,''),(12,'rutasalidamarcatel','8147370230','','','','','default',NULL,'');
/*!40000 ALTER TABLE `outbound_routes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `outroutemsg`
--

LOCK TABLES `outroutemsg` WRITE;
/*!40000 ALTER TABLE `outroutemsg` DISABLE KEYS */;
/*!40000 ALTER TABLE `outroutemsg` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `paging_autoanswer`
--

LOCK TABLES `paging_autoanswer` WRITE;
/*!40000 ALTER TABLE `paging_autoanswer` DISABLE KEYS */;
INSERT INTO `paging_autoanswer` (`useragent`, `var`, `setting`) VALUES ('default','CALLINFO','Call-Info: <uri>\\;answer-after=0'),('default','ALERTINFO','Alert-Info: Ring Answer'),('default','SIPURI','intercom=true'),('Mitel','CALLINFO','Call-Info: <sip:broadworks.net>\\;answer-after=0'),('Panasonic','ALERTINFO','Alert-Info: Intercom'),('Polycom','ALERTINFO','Alert-Info: info=Auto Answer'),('Digium','ALERTINFO','Alert-Info: ring-answer');
/*!40000 ALTER TABLE `paging_autoanswer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `paging_config`
--

LOCK TABLES `paging_config` WRITE;
/*!40000 ALTER TABLE `paging_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `paging_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `paging_groups`
--

LOCK TABLES `paging_groups` WRITE;
/*!40000 ALTER TABLE `paging_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `paging_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `parkplus`
--

LOCK TABLES `parkplus` WRITE;
/*!40000 ALTER TABLE `parkplus` DISABLE KEYS */;
INSERT INTO `parkplus` (`id`, `defaultlot`, `type`, `name`, `parkext`, `parkpos`, `numslots`, `parkingtime`, `parkedmusicclass`, `generatefc`, `generatehints`, `findslot`, `parkedplay`, `parkedcalltransfers`, `parkedcallreparking`, `alertinfo`, `cidpp`, `autocidpp`, `announcement_id`, `comebacktoorigin`, `dest`) VALUES (1,'yes','public','Default Lot','','',4,45,'default','yes','yes','first','both','caller','caller','','','none',NULL,'yes','app-blackhole,hangup,1');
/*!40000 ALTER TABLE `parkplus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `phpagiconf`
--

LOCK TABLES `phpagiconf` WRITE;
/*!40000 ALTER TABLE `phpagiconf` DISABLE KEYS */;
/*!40000 ALTER TABLE `phpagiconf` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `pinset_usage`
--

LOCK TABLES `pinset_usage` WRITE;
/*!40000 ALTER TABLE `pinset_usage` DISABLE KEYS */;
/*!40000 ALTER TABLE `pinset_usage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `pinsets`
--

LOCK TABLES `pinsets` WRITE;
/*!40000 ALTER TABLE `pinsets` DISABLE KEYS */;
/*!40000 ALTER TABLE `pinsets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `queueprio`
--

LOCK TABLES `queueprio` WRITE;
/*!40000 ALTER TABLE `queueprio` DISABLE KEYS */;
/*!40000 ALTER TABLE `queueprio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `queues_config`
--

LOCK TABLES `queues_config` WRITE;
/*!40000 ALTER TABLE `queues_config` DISABLE KEYS */;
INSERT INTO `queues_config` (`extension`, `descr`, `grppre`, `alertinfo`, `ringing`, `maxwait`, `password`, `ivr_id`, `dest`, `cwignore`, `qregex`, `agentannounce_id`, `joinannounce_id`, `queuewait`, `use_queue_context`, `togglehint`, `qnoanswer`, `callconfirm`, `callconfirm_id`, `monitor_type`, `monitor_heard`, `monitor_spoken`, `callback_id`) VALUES ('1000','cola','','',2,'180','','none','ext-local,vms8177700108,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700109','18177700109-ESP','','',2,'180','','none','app-announcement-115,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700111','18177700111-ESP','','',2,'180','','none','app-announcement-117,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700108','18177700108-ESP','','',0,'180','','none','app-announcement-114,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370239','18147370239-ESP','','',0,'180','','none','app-announcement-74,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700387','18177700387-ESP','','',0,'180','','none','app-announcement-195,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370215','18147370215-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('98147370215','98147370215-ING','','',0,'180','','none','app-announcement-12,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700101','18177700101-ESP','','',0,'180','','none','app-announcement-103,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700102','18177700102-ESP','','',0,'180','','none','app-announcement-77,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700103','18177700103-ESP','','',0,'180','','none','app-announcement-78,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700104','18177700104-ESP','','',0,'180','','none','app-announcement-79,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700105','18177700105-ESP','','',0,'180','','none','app-announcement-80,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370247','18147370247-ESP','','',0,'180','','none','app-announcement-81,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700106','18177700106-ESP','','',0,'180','','none','app-announcement-225,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370240','18147370240-ESP','','',0,'180','','none','app-announcement-83,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19847770191','19847770191ESP','','',0,'180','','none','app-announcement-129,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370241','8147370241-ESP','','',0,'180','','none','app-announcement-85,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370242','18147370242-ESP','','',0,'180','','none','app-announcement-86,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700384','18177700384-ESP','','',0,'180','','none','app-announcement-158,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370245','18147370245-ESP','','',0,'180','','none','app-announcement-88,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370246','18147370246-ESP','','',0,'180','','none','app-announcement-89,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370224','18147370224-ESP','','',0,'180','','none','app-announcement-91,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370226','18147370226-ESP','','',0,'180','','none','app-announcement-30,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370227','18147370227-ESP','','',0,'180','','none','app-announcement-94,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370229','18147370229-ESP','','',0,'180','','none','app-announcement-95,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370233','18147370233-ESP','','',0,'180','','none','app-announcement-209,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370234','18147370234-ESP','','',0,'180','','none','app-announcement-97,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700113','18177700113-ESP','','',0,'180','','none','app-announcement-98,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700114','18177700114-ESP','','',0,'180','','none','app-announcement-99,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700115','18177700115-ESP','','',0,'180','','none','app-announcement-100,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700112','18177700112-ESP','','',0,'180','','none','app-announcement-101,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370230','18147370230-ESP','','',0,'180','','none','app-announcement-102,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15589958531','15589958531-ESP','','',0,'180','','none','app-announcement-104,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15589958532','15589958532-ESP','','',0,'180','','none','app-announcement-105,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15589958533','15589958533-ESP','','',0,'180','','none','app-announcement-106,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370237','18147370237-ESP','','',0,'180','','none','app-announcement-107,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370238','18147370238-ESP','','',0,'180','','none','app-announcement-108,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370231','18147370231-ESP','','',0,'180','','none','app-announcement-109,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370232','18147370232-ESP','','',0,'180','','none','app-announcement-110,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370217','18147370217-ESP','','',0,'180','','none','app-announcement-111,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370218','18147370218-ESP','','',0,'180','','none','app-announcement-112,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370216','18147370216-ESP','','',0,'180','','none','app-announcement-113,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700110','18177700110-ESP','','',2,'180','','none','app-announcement-116,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700116','18177700116-ESP','','',0,'180','','none','app-announcement-118,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700117','18177700117-ESP','','',0,'180','','none','app-announcement-119,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700118','18177700118-ESP','','',0,'180','','none','app-announcement-120,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700119','18177700119-ESP','','',0,'180','','none','ext-local,vms8177700119,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700120','18177700120-ESP','','',0,'180','','none','app-announcement-122,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700121','18177700121-ESP','','',0,'180','','none','app-announcement-123,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700122','18177700122-ESP','','',0,'180','','none','app-announcement-124,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700123','18177700123-ESP','','',0,'180','','none','app-announcement-125,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19847770192','19847770192-ESP','','',0,'180','','none','app-announcement-126,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700124','18177700124-ESP','','',0,'180','','none','app-announcement-131,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370235','18147370235-ESP','','',0,'180','','none','app-announcement-132,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('12226443774','12226443774-ESP','','',0,'180','','none','app-announcement-335,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700360','18177700360-ESP','','',0,'180','','none','app-announcement-134,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700361','18177700361-ESP','','',0,'180','','none','app-announcement-135,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700362','18177700362-ESP','','',0,'180','','none','app-announcement-136,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700363','18177700363-ESP','','',0,'180','','none','app-announcement-137,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700376','18177700376-ESP','','',0,'180','','none','app-announcement-138,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700365','18177700365-ESP','','',0,'180','','none','app-announcement-139,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700366','18177700366-ESP','','',0,'180','','none','app-announcement-140,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700367','18177700367-ESP','','',0,'180','','none','app-announcement-141,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700368','18177700368-ESP','','',0,'180','','none','app-announcement-142,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700369','18177700369-ESP','','',0,'180','','none','app-announcement-143,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700371','18177700371-ESP','','',0,'180','','none','app-announcement-144,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700372','18177700372-ESP','','',0,'180','','none','app-announcement-145,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700373','18177700373-ESP','','',0,'180','','none','app-announcement-146,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700374','18177700374-ESP','','',0,'180','','none','app-announcement-147,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700375','18177700375-ESP','','',0,'180','','none','app-announcement-148,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700370','18177700370-ESP','','',0,'180','','none','app-announcement-149,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('108177700100','108177700100-ESP','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700364','18177700364-ESP','','',0,'180','','none','app-announcement-151,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700378','18177700378-ESP','','',0,'180','','none','app-announcement-152,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370221','18147370221-ESP','','',0,'180','','none','app-announcement-173,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700380','18177700380-ESP','','',0,'180','','none','app-announcement-172,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700381','18177700381-ESP','','',0,'180','','none','app-announcement-155,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700382','18177700382-ESP','','',0,'180','','none','app-announcement-156,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700383','18177700383-ESP','','',0,'180','','none','app-announcement-157,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('10011','10011','','',0,'','','none','',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700100','18177700100-ESP','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('98177700100','98177700100-ING','','',0,'180','','none','app-announcement-51,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('28177700100','28177700100-QUIERO-QUE-ME-LLAMEN','','',0,'60','','none','ivr-44,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700385','18177700385-ESP','','',0,'180','','none','app-announcement-160,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19847770193','19847770193-ESP','','',0,'180','','none','app-announcement-159,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('38177700100','38177700100-QUIERO-QUE-ME-LLAMEN','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('48177700100','48177700100-QUIERO-QUE-ME-LLAMEN','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('58177700100','58177700100-QUIERO-QUE-ME-LLAMEN','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700386','18177700386-ESP','','',0,'180','','none','app-announcement-166,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('118177700100','118177700100-ESP','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('128177700100','128177700100-ESP','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('138177700100','138177700100-ESP','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('198177700100','198177700100-ING','','',0,'180','','none','app-announcement-51,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('188177700100','188177700100-ESP','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('105588804680','105588804680-ESP','','',0,'180','','none','app-announcement-53,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('115588804680','115588804680-ESP','','',0,'180','','none','app-announcement-54,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('125588804680','125588804680-ESP','','',0,'180','','none','app-announcement-54,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('135588804680','135588804680-ESP','','',0,'180','','none','app-announcement-53,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('185588804680','185588804680-ESP','','',0,'180','','none','app-announcement-53,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('195588804680','195588804680-ESP','','',0,'180','','none','app-announcement-53,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('103335605355','103335605355-ESP','','',0,'180','','none','app-announcement-19,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('113335605355','113335605355-ESP','','',0,'180','','none','app-announcement-19,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('123335605355','123335605355-ESP','','',0,'180','','none','app-announcement-19,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('133335605355','133335605355-ESP','','',0,'180','','none','app-announcement-19,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('183335605355','183335605355-ESP','','',0,'180','','none','app-announcement-19,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('193335605355','193335605355-ING','','',0,'180','','none','app-announcement-19,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700389','18177700389-ESP','','',0,'180','','none','app-announcement-196,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700671','18177700671-ESP','','',0,'180','','none','app-announcement-197,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700379','18177700379-ESP','','',0,'180','','none','app-announcement-253,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700673','18177700673-ESP','','',0,'180','','none','app-announcement-200,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700674','18177700674-ESP','','',0,'180','','none','app-announcement-200,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700672','18177700672-ESP','','',0,'180','','none','app-announcement-201,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700670','18177700670-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700675','18177700675-ESP','','',0,'180','','none','app-announcement-206,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700676','18177700676-ESP','','',0,'180','','none','app-announcement-207,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700377','18177700377-ESP','','',0,'180','','none','app-announcement-293,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700107','18177700107-ESP','','',0,'180','','none','app-announcement-75,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147370244','18147370244-ESP','','',0,'180','','none','app-announcement-233,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700677','18177700677-ESP','','',0,'180','','none','app-announcement-211,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700678','18177700678-ESP','','',0,'180','','none','app-announcement-212,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700679','18177700679-ESP','','',0,'180','','none','app-announcement-213,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700680','18177700680-ESP','','',0,'180','','none','app-announcement-214,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700681','18177700681-ESP','','',0,'180','','none','app-announcement-215,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700682','18177700682-ESP','','',0,'180','','none','app-announcement-216,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700683','18177700683-ESP','','',0,'180','','none','app-announcement-217,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700684','18177700684-ESP','','',0,'180','','none','app-announcement-218,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700685','18177700685-ESP','','',0,'180','','none','app-announcement-219,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700686','18177700686-ESP','','',0,'180','','none','app-announcement-220,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700687','18177700687-ESP','','',0,'180','','none','app-announcement-221,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700688','18177700688-ESP','','',0,'180','','none','app-announcement-222,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700689','18177700689-ESP','','',0,'180','','none','app-announcement-223,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700691','18177700691-ESP','','',0,'180','','none','app-announcement-224,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700692','18177700692-ESP','','',0,'180','','none','app-announcement-226,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700690','18177700690-ESP','','',0,'180','','none','app-announcement-227,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('28177700690','28177700690-ESP','','',0,'180','','none','app-announcement-227,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('28147370215','28147370215-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700693','18177700693-ESP','','',0,'180','','none','app-announcement-230,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700695','18177700695-ESP','','',0,'3','','none','app-announcement-231,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700694','18177700694-ESP','','',0,'180','','none','app-announcement-232,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('208177700100','208177700100-ESP','','',0,'180','','none','app-announcement-50,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700696','18177700696-ESP','','',0,'180','','none','app-announcement-234,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19847770194','19847770194-ESP','','',0,'180','','none','app-announcement-235,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700697','18177700697-ESP','','',0,'180','','none','app-announcement-236,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804685','15588804685-ESP','','',0,'180','','none','app-announcement-237,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('13388800130','13388800130-ESP','','',0,'180','','none','app-announcement-237,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700698','18177700698-ESP','','',0,'180','','none','app-announcement-238,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('108147370215','108147370215','','',0,'180','','none','ext-local,vms8147370215,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701550','18177701550-ESP','','',0,'180','','none','app-announcement-227,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15589958540','15589958540-ESP','','',0,'180','','none','app-announcement-227,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('13388800133','13388800133-ESP','','',0,'180','','none','app-announcement-227,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701551','18177701551-ESP','','',0,'180','','none','app-announcement-242,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15589958534','15589958534-ESP','','',0,'180','','none','app-announcement-313,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15589958535','15589958535-ESP','','',0,'180','','none','app-announcement-244,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804681','15588804681-ESP','','',0,'180','','none','app-announcement-352,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804682','15588804682-ESP','','',0,'180','','none','app-announcement-344,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701552','18177701552-ESP','','',0,'180','','none','app-announcement-245,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804686','15588804686-ESP','','',0,'180','','none','app-announcement-305,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701553','18177701553-ESP','','',0,'180','','none','app-announcement-247,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804683','15588804683-ESP','','',0,'180','','none','app-announcement-345,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701554','18177701554-ESP','','',0,'180','','none','app-announcement-248,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('13388800131','13388800131-ESP','','',0,'180','','none','app-announcement-281,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19847770196','19847770196-ESP','','',0,'180','','none','app-announcement-250,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18718800156','18718800156-ESP','','',0,'180','','none','app-announcement-251,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18718800151','18718800151','','',0,'180','','none','app-announcement-251,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18718800152','18718800152-ESP','','',0,'180','','none','app-announcement-144,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701556','18177701556-ESP','','',0,'180','','none','app-announcement-254,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701555','18177701555-ESP','','',0,'180','','none','app-announcement-255,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701558','18177701558-ESP','','',0,'180','','none','app-announcement-257,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701557','18177701557-ESP','','',0,'180','','none','app-announcement-259,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701559','18177701559-ESP','','',0,'180','','none','app-announcement-260,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701560','18177701560-ESP','','',0,'180','','none','app-announcement-261,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701561','18177701561-ESP','','',0,'180','','none','app-announcement-262,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701563','18177701563-ESP','','',0,'3','','none','app-announcement-265,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701562','18177701562-ESP','','',0,'180','','none','app-announcement-266,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701564','18177701564-ESP','','',0,'180','','none','app-announcement-267,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701565','18177701565-ESP','','',0,'180','','none','app-announcement-268,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804680','15588804680-ESP','','',0,'180','','none','app-announcement-269,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19988001966','19988001966-ESP','','',0,'180','','none','app-announcement-270,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701566','18177701566-ESP','','',0,'180','','none','app-announcement-272,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701567','18177701567-ESP','','',0,'180','','none','app-announcement-273,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701568','18177701568-ESP','','',0,'180','','none','app-announcement-274,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701569','18177701569-esp','','',0,'180','','none','app-announcement-275,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18718800153','18718800153-ESP','','',0,'180','','none','app-announcement-276,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701570','18177701570-ESP','','',0,'180','','none','app-announcement-277,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701571','18177701571-ESP','','',0,'180','','none','app-announcement-278,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701572','18177701572-ESP','','',0,'180','','none','app-announcement-263,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701573','18177701573-ESP','','',0,'180','','none','app-announcement-279,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701574','18177701574-ESP','','',0,'180','','none','app-announcement-280,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('13335605354','13335605354-ESP','','',0,'180','','none','app-announcement-282,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19847770197','19847770197-ESP','','',0,'180','','none','app-announcement-283,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700699','18177700699-BK-FB','','',0,'180','','none','app-announcement-284,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19988001967','19988001967-ESP','','',0,'180','','none','app-announcement-285,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('19847770190','19847770190-ESP','','',0,'180','','none','app-announcement-285,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701575','18177701575-ESP','','',0,'180','','none','app-announcement-287,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701576','18177701576-ESP','','',0,'180','','none','app-announcement-288,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701577','18177701577-ESP','','',0,'180','','none','app-announcement-289,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701578','18177701578-ESP','','',0,'180','','none','app-announcement-290,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177701579','18177701579-ESP','','',0,'180','','none','app-announcement-286,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773870','18147773870-ESP','','',0,'180','','none','app-announcement-291,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773871','18147773871-ESP','','',0,'180','','none','app-announcement-292,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773872','18147773872-ESP','','',0,'180','','none','app-announcement-294,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773873','18147773873-ESP','','',0,'180','','none','app-announcement-296,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804684','15588804684-ESP','','',0,'180','','none','app-announcement-346,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773874','18147773874-ESP','','',0,'180','','none','app-announcement-298,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773875','18147773875-ESP','','',0,'180','','none','app-announcement-299,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773877','18147773877-ESP','','',0,'180','','none','app-announcement-300,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773876','18147773876-ESP','','',0,'180','','none','app-announcement-301,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773878','18147773878-ESP','','',0,'180','','none','app-announcement-302,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773879','18147773879-ESP','','',0,'180','','none','app-announcement-303,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773883','18147773883-ESP','','',0,'180','','none','app-announcement-304,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773882','18147773882-ESP','','',0,'180','','none','app-announcement-309,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('13335605356','13335605356-ESP','','',0,'180','','none','app-announcement-307,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('1008177700100','1008177700100-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773881','18147773881-ESP','','',0,'180','','none','app-announcement-308,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773884','18147773884-ESP','','',0,'180','','none','app-announcement-310,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773885','18147773885-ESP','','',0,'180','','none','app-announcement-311,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773887','18147773887-ESP','','',0,'180','','none','app-announcement-312,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804687','15588804687-ESP','','',0,'180','','none','app-announcement-314,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773888','18147773888-ESP','','',0,'180','','none','app-announcement-315,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773889','18147773889-ESP','','',0,'180','','none','app-announcement-316,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15589958536','15589958536-ESP','','',0,'180','','none','app-announcement-317,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('13335605357','13335605357-ESP','','',0,'180','','none','app-announcement-318,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15000000000','15000000000-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('12228800361','12228800361-ESP','','',0,'180','','none','app-announcement-321,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18447770070','18447770070-ESP','','',0,'180','','none','app-announcement-322,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('1018177700100','1018177700100-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177702600','18177702600-ESP','','',0,'180','','none','app-announcement-323,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177702601','18177702601-ESP','','',0,'180','','none','app-announcement-324,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15588804688','15588804688-ESP','','',0,'180','','none','app-announcement-325,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177702603','18177702603-ESP','','',0,'180','','none','app-announcement-329,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('14428880131','14428880131-ESP','','',0,'180','','none','app-announcement-330,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177702604','18177702604-ESP','','',0,'180','','none','app-announcement-305,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('308177700100','308177700100-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('308147370215','308147370215-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('318177700100','318177700100','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('28177702601','28177702601-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('328177700100','328177700100-ESP','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('14428880130','14428880130-ESP','','',0,'180','','none','app-announcement-336,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('14428880132','14428880132-ESP','','',0,'180','','none','app-announcement-337,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177702605','18177702605-ESP','','',0,'180','','none','app-announcement-338,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('15547776691','15547776691-ESP','','',0,'180','','none','app-announcement-339,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('13388801850','13388801850','','',0,'180','','none','app-announcement-340,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('13388800134','13388800134-ESP','','',0,'180','','none','app-announcement-341,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177700388','18177700388-ESP','','',0,'180','','none','app-announcement-347,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('28177700388','28177700388','','',0,'180','','none','app-blackhole,hangup,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('14428880133','14428880133-ESP','','',0,'180','','none','app-announcement-349,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773892','18147773892-ESP','','',0,'180','','none','app-announcement-350,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773890','18147773890-ESP','','',0,'180','','none','app-announcement-351,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18177702606','18177702606-ESP','','',0,'180','','none','app-announcement-353,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none'),('18147773894','18147773894-ESP','','',0,'180','','none','app-announcement-354,s,1',0,'',0,0,0,0,0,0,0,0,'',0,0,'none');
/*!40000 ALTER TABLE `queues_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `queues_details`
--

LOCK TABLES `queues_details` WRITE;
/*!40000 ALTER TABLE `queues_details` DISABLE KEYS */;
INSERT INTO `queues_details` (`id`, `keyword`, `data`, `flags`) VALUES ('18177700111','member','Agent/2003,0',3),('18177700109','member','Agent/2000,0',0),('18177700109','penaltymemberslimit','0',0),('18177700109','autopause','no',0),('18177700109','autopausedelay','0',0),('18177700109','servicelevel','60',0),('18177700109','memberdelay','0',0),('18177700109','timeoutrestart','no',0),('18177700109','skip_joinannounce','',0),('18177700109','cron_schedule','never',0),('18177700109','autopausebusy','no',0),('18177700109','autopauseunavail','no',0),('18177700109','timeoutpriority','app',0),('18177700109','announce-holdtime','no',0),('18177700109','announce-position','no',0),('18177700109','queue-youarenext','silence/1',0),('18177700109','queue-thereare','silence/1',0),('18177700109','queue-callswaiting','silence/1',0),('18177700109','queue-thankyou','',0),('18177700109','periodic-announce-frequency','0',0),('18177700109','monitor-format','',0),('18177700109','maxlen','0',0),('18177700109','joinempty','yes',0),('18177700109','leavewhenempty','no',0),('18177700109','strategy','random',0),('18177700109','timeout','0',0),('18177700109','retry','5',0),('18177700109','wrapuptime','0',0),('18177700109','announce-frequency','0',0),('18147370224','member','Agent/2011,0',11),('1000','servicelevel','60',0),('1000','memberdelay','0',0),('1000','timeoutrestart','no',0),('1000','skip_joinannounce','',0),('1000','cron_schedule','never',0),('1000','autopausebusy','no',0),('1000','autopauseunavail','no',0),('1000','timeoutpriority','app',0),('1000','maxlen','0',0),('1000','joinempty','yes',0),('1000','leavewhenempty','no',0),('1000','strategy','random',0),('1000','timeout','0',0),('1000','retry','5',0),('1000','wrapuptime','0',0),('1000','announce-frequency','0',0),('1000','announce-holdtime','no',0),('1000','announce-position','no',0),('1000','queue-youarenext','silence/1',0),('1000','queue-thereare','silence/1',0),('1000','queue-callswaiting','silence/1',0),('1000','queue-thankyou','',0),('1000','periodic-announce-frequency','0',0),('1000','monitor-format','',0),('1000','monitor-join','yes',0),('1000','eventwhencalled','no',0),('1000','eventmemberstatus','no',0),('1000','weight','0',0),('1000','autofill','no',0),('1000','ringinuse','yes',0),('1000','reportholdtime','no',0),('1000','autopause','no',0),('1000','autopausedelay','0',0),('18177700109','member','Agent/2004,0',4),('18177700109','monitor-join','yes',0),('18177700109','eventwhencalled','no',0),('18177700109','eventmemberstatus','no',0),('19847770192','member','Agent/2006,0',6),('18177700111','member','Agent/2000,0',0),('18177700110','member','Agent/2006,0',6),('18177700110','autopause','no',0),('18177700111','member','Agent/2001,0',1),('18177700110','member','Agent/2002,0',2),('18177700110','member','Agent/2001,0',1),('18177700110','member','Agent/2000,0',0),('18177700110','answered_elsewhere','0',0),('18177700110','penaltymemberslimit','0',0),('18177700110','timeoutpriority','app',0),('18177700110','autopausedelay','0',0),('18177700110','servicelevel','60',0),('18177700110','memberdelay','0',0),('18177700110','timeoutrestart','no',0),('18177700110','skip_joinannounce','',0),('18177700110','cron_schedule','never',0),('18177700110','announce-holdtime','no',0),('18177700110','announce-position','no',0),('18177700110','queue-youarenext','silence/1',0),('18177700110','queue-thereare','silence/1',0),('18177700110','queue-callswaiting','silence/1',0),('18177700110','queue-thankyou','',0),('18177700110','periodic-announce-frequency','0',0),('18177700110','monitor-format','',0),('18177700110','maxlen','0',0),('18177700110','joinempty','yes',0),('18177700110','leavewhenempty','no',0),('18177700110','strategy','random',0),('18177700110','timeout','0',0),('18177700110','retry','5',0),('18177700110','wrapuptime','0',0),('18177700110','announce-frequency','0',0),('18177700111','answered_elsewhere','0',0),('18177700111','monitor-format','',0),('18177700111','monitor-join','yes',0),('18177700111','eventwhencalled','no',0),('18177700111','eventmemberstatus','no',0),('18177700111','weight','0',0),('18177700111','autofill','no',0),('18177700111','ringinuse','yes',0),('18177700111','reportholdtime','no',0),('18177700111','autopause','no',0),('18177700111','autopausedelay','0',0),('18177700111','timeout','0',0),('18177700111','retry','5',0),('18177700111','wrapuptime','0',0),('18177700111','announce-frequency','0',0),('18177700111','announce-holdtime','no',0),('18177700111','announce-position','no',0),('18177700111','queue-youarenext','silence/1',0),('18177700111','queue-thereare','silence/1',0),('18177700111','queue-callswaiting','silence/1',0),('18177700111','queue-thankyou','',0),('18177700111','periodic-announce-frequency','0',0),('18177700111','maxlen','0',0),('18177700111','joinempty','yes',0),('18177700111','leavewhenempty','no',0),('18177700111','strategy','random',0),('1000','answered_elsewhere','0',0),('18177700109','member','Agent/2001,0',1),('18177700109','member','Agent/2002,0',2),('18177700109','member','Agent/2003,0',3),('19847770192','member','Agent/2003,0',3),('19847770192','member','Agent/2002,0',2),('18177700111','skip_joinannounce','',0),('18177700111','cron_schedule','never',0),('18177700111','autopausebusy','no',0),('18177700111','autopauseunavail','no',0),('18177700111','servicelevel','60',0),('18177700111','memberdelay','0',0),('18177700111','timeoutrestart','no',0),('18147370239','member','Agent/2002,0',2),('18147370239','member','Agent/2003,0',3),('18177700109','answered_elsewhere','0',0),('18177700111','member','Agent/2004,0',4),('18177700111','member','Agent/2002,0',2),('18177700111','timeoutpriority','app',0),('18147370215','member','Agent/2003,0',3),('18177700110','member','Agent/2007,0',7),('18177700110','member','Agent/2005,0',5),('18177700110','member','Agent/2004,0',4),('14428880133','joinempty','yes',0),('18177700108','member','Agent/2009,0',9),('18177700108','member','Agent/2008,0',8),('18177700108','member','Agent/2005,0',5),('18177700108','member','Agent/2006,0',6),('18177700108','member','Agent/2007,0',7),('18177700108','timeoutpriority','app',0),('18177700108','penaltymemberslimit','0',0),('18177700108','eventmemberstatus','no',0),('18177700108','weight','0',0),('18177700108','autofill','no',0),('18177700108','ringinuse','yes',0),('18177700108','reportholdtime','no',0),('18177700108','autopause','no',0),('18177700108','autopausedelay','0',0),('18177700108','servicelevel','60',0),('18177700108','memberdelay','0',0),('18177700108','timeoutrestart','no',0),('18177700108','skip_joinannounce','',0),('18177700108','cron_schedule','never',0),('18177700108','autopausebusy','no',0),('18177700108','autopauseunavail','no',0),('18177700108','maxlen','0',0),('18177700108','joinempty','yes',0),('18177700108','leavewhenempty','no',0),('18177700108','strategy','random',0),('18177700108','timeout','0',0),('18177700108','retry','5',0),('18177700108','wrapuptime','0',0),('18177700108','announce-frequency','0',0),('18177700108','announce-holdtime','no',0),('18177700108','announce-position','no',0),('18177700108','queue-youarenext','silence/1',0),('18177700108','queue-thereare','silence/1',0),('18177700108','queue-callswaiting','silence/1',0),('18177700108','queue-thankyou','',0),('18177700108','periodic-announce-frequency','0',0),('18177700108','monitor-format','',0),('18177700108','monitor-join','yes',0),('18177700108','eventwhencalled','no',0),('18177700109','member','Agent/2008,0',8),('18177700109','member','Agent/2007,0',7),('18177700109','weight','0',0),('18177700109','autofill','no',0),('18177700109','ringinuse','yes',0),('18177700109','reportholdtime','no',0),('18177700110','autopauseunavail','no',0),('18177700110','monitor-join','yes',0),('18177700110','eventwhencalled','no',0),('18177700110','eventmemberstatus','no',0),('18177700110','weight','0',0),('18177700110','autofill','no',0),('18177700110','ringinuse','yes',0),('18177700110','reportholdtime','no',0),('18177700111','member','Agent/2009,0',9),('18177700111','member','Agent/2008,0',8),('18177700111','member','Agent/2007,0',7),('18177700111','member','Agent/2006,0',6),('18177700111','member','Agent/2005,0',5),('18177700110','autopausebusy','no',0),('18177700108','member','Agent/2003,0',3),('18177700110','member','Agent/2003,0',3),('18147370239','member','Agent/2004,0',4),('18147370239','member','Agent/2005,0',5),('18147370239','cron_schedule','never',0),('18147370239','autopausebusy','no',0),('18147370239','autopauseunavail','no',0),('18147370239','queue-youarenext','silence/1',0),('18147370239','queue-thereare','silence/1',0),('18147370239','queue-callswaiting','silence/1',0),('18147370239','queue-thankyou','',0),('18147370239','periodic-announce-frequency','0',0),('18147370239','monitor-format','',0),('18147370239','monitor-join','yes',0),('18147370239','eventwhencalled','no',0),('18147370239','eventmemberstatus','no',0),('18147370239','weight','0',0),('18147370239','autofill','no',0),('18147370239','ringinuse','yes',0),('18147370239','reportholdtime','no',0),('18147370239','autopause','no',0),('18147370239','autopausedelay','0',0),('18147370239','servicelevel','60',0),('18147370239','memberdelay','0',0),('18147370239','timeoutrestart','no',0),('18147370239','skip_joinannounce','',0),('18147370239','maxlen','0',0),('18147370239','joinempty','yes',0),('18147370239','leavewhenempty','no',0),('18147370239','strategy','random',0),('18177700387','member','Agent/2001,0',1),('18177700387','member','Agent/2002,0',2),('18177700387','autopausedelay','0',0),('18177700387','servicelevel','60',0),('18177700387','memberdelay','0',0),('18177700387','timeoutrestart','no',0),('18177700387','skip_joinannounce','',0),('18177700387','cron_schedule','never',0),('18177700387','autopausebusy','no',0),('18177700387','autopauseunavail','no',0),('18177700387','timeoutpriority','app',0),('18177700387','penaltymemberslimit','0',0),('18177700387','timeout','0',0),('18177700387','retry','5',0),('18177700387','wrapuptime','0',0),('18177700387','announce-frequency','0',0),('18177700387','announce-holdtime','no',0),('18177700387','announce-position','no',0),('18177700387','queue-youarenext','silence/1',0),('18177700387','queue-thereare','silence/1',0),('18177700387','queue-callswaiting','silence/1',0),('18177700387','queue-thankyou','',0),('18177700387','periodic-announce-frequency','0',0),('18177700387','monitor-format','',0),('18177700387','monitor-join','yes',0),('18177700387','eventwhencalled','no',0),('18177700387','eventmemberstatus','no',0),('18177700387','weight','0',0),('18177700387','autofill','no',0),('18177700387','ringinuse','yes',0),('18147370215','member','Agent/2001,0',1),('18147370215','member','Agent/2000,0',0),('18147370215','answered_elsewhere','0',0),('18147370215','timeoutpriority','app',0),('18147370215','cron_schedule','never',0),('18147370215','autopausebusy','no',0),('18147370215','autopauseunavail','no',0),('18147370215','queue-callswaiting','silence/1',0),('18147370215','queue-thankyou','',0),('18147370215','periodic-announce-frequency','0',0),('18147370215','monitor-format','',0),('18147370215','monitor-join','yes',0),('18147370215','eventwhencalled','no',0),('18147370215','eventmemberstatus','no',0),('18147370215','weight','0',0),('18147370215','autofill','no',0),('18147370215','ringinuse','yes',0),('18147370215','reportholdtime','no',0),('18147370215','autopause','no',0),('18147370215','maxlen','0',0),('18147370215','joinempty','yes',0),('18147370215','leavewhenempty','no',0),('18147370215','strategy','random',0),('18147370215','timeout','0',0),('18147370215','retry','5',0),('18147370215','wrapuptime','0',0),('18147370215','announce-frequency','0',0),('18147370215','announce-holdtime','no',0),('18147370215','announce-position','no',0),('18147370215','queue-youarenext','silence/1',0),('18147370215','queue-thereare','silence/1',0),('98147370215','member','Agent/2009,0',9),('98147370215','answered_elsewhere','0',0),('98147370215','member','Agent/2000,0',0),('98147370215','queue-youarenext','silence/1',0),('98147370215','queue-thereare','silence/1',0),('98147370215','queue-callswaiting','silence/1',0),('98147370215','queue-thankyou','',0),('98147370215','periodic-announce-frequency','0',0),('98147370215','monitor-format','',0),('98147370215','monitor-join','yes',0),('98147370215','eventwhencalled','no',0),('98147370215','eventmemberstatus','no',0),('98147370215','weight','0',0),('98147370215','autofill','no',0),('98147370215','ringinuse','yes',0),('98147370215','reportholdtime','no',0),('98147370215','autopause','no',0),('98147370215','autopausedelay','0',0),('98147370215','servicelevel','60',0),('98147370215','memberdelay','0',0),('98147370215','timeoutrestart','no',0),('98147370215','skip_joinannounce','',0),('98147370215','cron_schedule','never',0),('98147370215','autopausebusy','no',0),('98147370215','autopauseunavail','no',0),('98147370215','timeoutpriority','app',0),('98147370215','penaltymemberslimit','0',0),('98147370215','maxlen','0',0),('98147370215','joinempty','yes',0),('98147370215','leavewhenempty','no',0),('98147370215','strategy','random',0),('18147370215','member','Agent/2004,0',4),('18147370215','member','Agent/2005,0',5),('18147370215','member','Agent/2006,0',6),('18147370215','member','Agent/2007,0',7),('18147370215','member','Agent/2008,0',8),('18147370215','memberdelay','0',0),('18147370215','timeoutrestart','no',0),('18147370215','skip_joinannounce','',0),('18177700101','member','Agent/2004,0',4),('18177700101','member','Agent/2005,0',5),('18177700101','member','Agent/2006,0',6),('18177700101','member','Agent/2001,0',1),('18177700101','autopausebusy','no',0),('18177700101','autopauseunavail','no',0),('18177700101','timeoutpriority','app',0),('18177700101','autofill','no',0),('18177700101','ringinuse','yes',0),('18177700101','reportholdtime','no',0),('18177700101','autopause','no',0),('18177700101','autopausedelay','0',0),('18177700101','servicelevel','60',0),('18177700101','memberdelay','0',0),('18177700101','timeoutrestart','no',0),('18177700101','skip_joinannounce','',0),('18177700101','cron_schedule','never',0),('18177700101','announce-frequency','0',0),('18177700101','announce-holdtime','no',0),('18177700101','announce-position','no',0),('18177700101','queue-youarenext','silence/1',0),('18177700101','queue-thereare','silence/1',0),('18177700101','queue-callswaiting','silence/1',0),('18177700101','queue-thankyou','',0),('18177700101','maxlen','0',0),('18177700101','joinempty','yes',0),('18177700101','leavewhenempty','no',0),('18177700101','strategy','random',0),('18177700101','timeout','0',0),('18177700101','retry','5',0),('18177700101','wrapuptime','0',0),('18177700102','answered_elsewhere','0',0),('18177700102','member','Agent/2000,0',0),('18177700102','member','Agent/2001,0',1),('18177700102','autopausedelay','0',0),('18177700102','servicelevel','60',0),('18177700102','memberdelay','0',0),('18177700102','timeoutrestart','no',0),('18177700102','skip_joinannounce','',0),('18177700102','cron_schedule','never',0),('18177700102','autopausebusy','no',0),('18177700102','autopauseunavail','no',0),('18177700102','timeoutpriority','app',0),('18177700102','penaltymemberslimit','0',0),('18177700102','timeout','0',0),('18177700102','retry','5',0),('18177700102','wrapuptime','0',0),('18177700102','announce-frequency','0',0),('18177700102','announce-holdtime','no',0),('18177700102','announce-position','no',0),('18177700102','queue-youarenext','silence/1',0),('18177700102','queue-thereare','silence/1',0),('18177700102','queue-callswaiting','silence/1',0),('18177700102','queue-thankyou','',0),('18177700102','periodic-announce-frequency','0',0),('18177700102','monitor-format','',0),('18177700102','monitor-join','yes',0),('18177700102','eventwhencalled','no',0),('18177700102','eventmemberstatus','no',0),('18177700102','weight','0',0),('18177700102','autofill','no',0),('18177700102','ringinuse','yes',0),('18177700103','answered_elsewhere','0',0),('18177700103','member','Agent/2000,0',0),('18177700103','queue-youarenext','silence/1',0),('18177700103','queue-thereare','silence/1',0),('18177700103','queue-callswaiting','silence/1',0),('18177700103','queue-thankyou','',0),('18177700103','periodic-announce-frequency','0',0),('18177700103','monitor-format','',0),('18177700103','monitor-join','yes',0),('18177700103','eventwhencalled','no',0),('18177700103','eventmemberstatus','no',0),('18177700103','weight','0',0),('18177700103','autofill','no',0),('18177700103','ringinuse','yes',0),('18177700103','reportholdtime','no',0),('18177700103','autopause','no',0),('18177700103','autopausedelay','0',0),('18177700103','servicelevel','60',0),('18177700103','memberdelay','0',0),('18177700103','timeoutrestart','no',0),('18177700103','skip_joinannounce','',0),('18177700103','cron_schedule','never',0),('18177700103','autopausebusy','no',0),('18177700103','autopauseunavail','no',0),('18177700103','timeoutpriority','app',0),('18177700103','penaltymemberslimit','0',0),('18177700103','maxlen','0',0),('18177700103','joinempty','yes',0),('18177700103','leavewhenempty','no',0),('18177700103','strategy','random',0),('18177700104','answered_elsewhere','0',0),('18177700104','member','Agent/2000,0',0),('18177700104','queue-youarenext','silence/1',0),('18177700104','queue-thereare','silence/1',0),('18177700104','queue-callswaiting','silence/1',0),('18177700104','queue-thankyou','',0),('18177700104','periodic-announce-frequency','0',0),('18177700104','monitor-format','',0),('18177700104','monitor-join','yes',0),('18177700104','eventwhencalled','no',0),('18177700104','eventmemberstatus','no',0),('18177700104','weight','0',0),('18177700104','autofill','no',0),('18177700104','ringinuse','yes',0),('18177700104','reportholdtime','no',0),('18177700104','autopause','no',0),('18177700104','autopausedelay','0',0),('18177700104','servicelevel','60',0),('18177700104','memberdelay','0',0),('18177700104','timeoutrestart','no',0),('18177700104','skip_joinannounce','',0),('18177700104','cron_schedule','never',0),('18177700104','autopausebusy','no',0),('18177700104','autopauseunavail','no',0),('18177700104','timeoutpriority','app',0),('18177700104','penaltymemberslimit','0',0),('18177700104','maxlen','0',0),('18177700104','joinempty','yes',0),('18177700104','leavewhenempty','no',0),('18177700104','strategy','random',0),('18177700105','answered_elsewhere','0',0),('18177700105','member','Agent/2000,0',0),('18177700105','queue-youarenext','silence/1',0),('18177700105','queue-thereare','silence/1',0),('18177700105','queue-callswaiting','silence/1',0),('18177700105','queue-thankyou','',0),('18177700105','periodic-announce-frequency','0',0),('18177700105','monitor-format','',0),('18177700105','monitor-join','yes',0),('18177700105','eventwhencalled','no',0),('18177700105','eventmemberstatus','no',0),('18177700105','weight','0',0),('18177700105','autofill','no',0),('18177700105','ringinuse','yes',0),('18177700105','reportholdtime','no',0),('18177700105','autopause','no',0),('18177700105','autopausedelay','0',0),('18177700105','servicelevel','60',0),('18177700105','memberdelay','0',0),('18177700105','timeoutrestart','no',0),('18177700105','skip_joinannounce','',0),('18177700105','cron_schedule','never',0),('18177700105','autopausebusy','no',0),('18177700105','autopauseunavail','no',0),('18177700105','timeoutpriority','app',0),('18177700105','penaltymemberslimit','0',0),('18177700105','maxlen','0',0),('18177700105','joinempty','yes',0),('18177700105','leavewhenempty','no',0),('18177700105','strategy','random',0),('18147370247','answered_elsewhere','0',0),('18147370247','member','Agent/2000,0',0),('18147370247','queue-youarenext','silence/1',0),('18147370247','queue-thereare','silence/1',0),('18147370247','queue-callswaiting','silence/1',0),('18147370247','queue-thankyou','',0),('18147370247','periodic-announce-frequency','0',0),('18147370247','monitor-format','',0),('18147370247','monitor-join','yes',0),('18147370247','eventwhencalled','no',0),('18147370247','eventmemberstatus','no',0),('18147370247','weight','0',0),('18147370247','autofill','no',0),('18147370247','ringinuse','yes',0),('18147370247','reportholdtime','no',0),('18147370247','autopause','no',0),('18147370247','autopausedelay','0',0),('18147370247','servicelevel','60',0),('18147370247','memberdelay','0',0),('18147370247','timeoutrestart','no',0),('18147370247','skip_joinannounce','',0),('18147370247','cron_schedule','never',0),('18147370247','autopausebusy','no',0),('18147370247','autopauseunavail','no',0),('18147370247','timeoutpriority','app',0),('18147370247','penaltymemberslimit','0',0),('18147370247','maxlen','0',0),('18147370247','joinempty','yes',0),('18147370247','leavewhenempty','no',0),('18147370247','strategy','random',0),('18177700106','member','Agent/2000,0',0),('18177700106','member','Agent/2001,0',1),('18177700106','member','Agent/2002,0',2),('18177700106','autopausedelay','0',0),('18177700106','servicelevel','60',0),('18177700106','memberdelay','0',0),('18177700106','timeoutrestart','no',0),('18177700106','skip_joinannounce','',0),('18177700106','cron_schedule','never',0),('18177700106','autopausebusy','no',0),('18177700106','autopauseunavail','no',0),('18177700106','timeoutpriority','app',0),('18177700106','penaltymemberslimit','0',0),('18177700106','timeout','0',0),('18177700106','retry','5',0),('18177700106','wrapuptime','0',0),('18177700106','announce-frequency','0',0),('18177700106','announce-holdtime','no',0),('18177700106','announce-position','no',0),('18177700106','queue-youarenext','silence/1',0),('18177700106','queue-thereare','silence/1',0),('18177700106','queue-callswaiting','silence/1',0),('18177700106','queue-thankyou','',0),('18177700106','periodic-announce-frequency','0',0),('18177700106','monitor-format','',0),('18177700106','monitor-join','yes',0),('18177700106','eventwhencalled','no',0),('18177700106','eventmemberstatus','no',0),('18177700106','weight','0',0),('18177700106','autofill','no',0),('18177700106','ringinuse','yes',0),('18147370240','member','Agent/2000,0',0),('18147370240','member','Agent/2001,0',1),('18147370240','member','Agent/2002,0',2),('18147370240','autopausedelay','0',0),('18147370240','servicelevel','60',0),('18147370240','memberdelay','0',0),('18147370240','timeoutrestart','no',0),('18147370240','skip_joinannounce','',0),('18147370240','cron_schedule','never',0),('18147370240','autopausebusy','no',0),('18147370240','autopauseunavail','no',0),('18147370240','timeoutpriority','app',0),('18147370240','penaltymemberslimit','0',0),('18147370240','timeout','0',0),('18147370240','retry','5',0),('18147370240','wrapuptime','0',0),('18147370240','announce-frequency','0',0),('18147370240','announce-holdtime','no',0),('18147370240','announce-position','no',0),('18147370240','queue-youarenext','silence/1',0),('18147370240','queue-thereare','silence/1',0),('18147370240','queue-callswaiting','silence/1',0),('18147370240','queue-thankyou','',0),('18147370240','periodic-announce-frequency','0',0),('18147370240','monitor-format','',0),('18147370240','monitor-join','yes',0),('18147370240','eventwhencalled','no',0),('18147370240','eventmemberstatus','no',0),('18147370240','weight','0',0),('18147370240','autofill','no',0),('18147370240','ringinuse','yes',0),('19847770191','answered_elsewhere','0',0),('19847770191','member','Agent/2000,0',0),('19847770191','member','Agent/2001,0',1),('19847770191','member','Agent/2002,0',2),('19847770191','member','Agent/2003,0',3),('19847770191','member','Agent/2004,0',4),('19847770191','member','Agent/2005,0',5),('19847770191','member','Agent/2006,0',6),('19847770191','member','Agent/2007,0',7),('19847770191','servicelevel','60',0),('19847770191','autopause','no',0),('19847770191','autopausedelay','0',0),('19847770191','maxlen','0',0),('19847770191','joinempty','yes',0),('19847770191','leavewhenempty','no',0),('19847770191','strategy','random',0),('19847770191','timeout','0',0),('19847770191','retry','5',0),('19847770191','wrapuptime','0',0),('19847770191','announce-frequency','0',0),('19847770191','announce-holdtime','no',0),('19847770191','announce-position','no',0),('19847770191','queue-youarenext','silence/1',0),('19847770191','queue-thereare','silence/1',0),('19847770191','queue-callswaiting','silence/1',0),('19847770191','queue-thankyou','',0),('19847770191','periodic-announce-frequency','0',0),('19847770191','monitor-format','',0),('19847770191','monitor-join','yes',0),('19847770191','eventwhencalled','no',0),('19847770191','eventmemberstatus','no',0),('18147370241','answered_elsewhere','0',0),('18147370241','member','Agent/2000,0',0),('18147370241','queue-youarenext','silence/1',0),('18147370241','queue-thereare','silence/1',0),('18147370241','queue-callswaiting','silence/1',0),('18147370241','queue-thankyou','',0),('18147370241','periodic-announce-frequency','0',0),('18147370241','monitor-format','',0),('18147370241','monitor-join','yes',0),('18147370241','eventwhencalled','no',0),('18147370241','eventmemberstatus','no',0),('18147370241','weight','0',0),('18147370241','autofill','no',0),('18147370241','ringinuse','yes',0),('18147370241','reportholdtime','no',0),('18147370241','autopause','no',0),('18147370241','autopausedelay','0',0),('18147370241','servicelevel','60',0),('18147370241','memberdelay','0',0),('18147370241','timeoutrestart','no',0),('18147370241','skip_joinannounce','',0),('18147370241','cron_schedule','never',0),('18147370241','autopausebusy','no',0),('18147370241','autopauseunavail','no',0),('18147370241','timeoutpriority','app',0),('18147370241','penaltymemberslimit','0',0),('18147370241','maxlen','0',0),('18147370241','joinempty','yes',0),('18147370241','leavewhenempty','no',0),('18147370241','strategy','random',0),('18147370242','answered_elsewhere','0',0),('18147370242','member','Agent/2000,0',0),('18147370242','queue-youarenext','silence/1',0),('18147370242','queue-thereare','silence/1',0),('18147370242','queue-callswaiting','silence/1',0),('18147370242','queue-thankyou','',0),('18147370242','periodic-announce-frequency','0',0),('18147370242','monitor-format','',0),('18147370242','monitor-join','yes',0),('18147370242','eventwhencalled','no',0),('18147370242','eventmemberstatus','no',0),('18147370242','weight','0',0),('18147370242','autofill','no',0),('18147370242','ringinuse','yes',0),('18147370242','reportholdtime','no',0),('18147370242','autopause','no',0),('18147370242','autopausedelay','0',0),('18147370242','servicelevel','60',0),('18147370242','memberdelay','0',0),('18147370242','timeoutrestart','no',0),('18147370242','skip_joinannounce','',0),('18147370242','cron_schedule','never',0),('18147370242','autopausebusy','no',0),('18147370242','autopauseunavail','no',0),('18147370242','timeoutpriority','app',0),('18147370242','penaltymemberslimit','0',0),('18147370242','maxlen','0',0),('18147370242','joinempty','yes',0),('18147370242','leavewhenempty','no',0),('18147370242','strategy','random',0),('18177700384','cron_schedule','never',0),('18177700384','autopausebusy','no',0),('18177700384','autopauseunavail','no',0),('18177700384','memberdelay','0',0),('18177700384','weight','0',0),('18177700384','autofill','no',0),('18177700384','ringinuse','yes',0),('18177700384','reportholdtime','no',0),('18177700384','autopause','no',0),('18177700384','autopausedelay','0',0),('18177700384','servicelevel','60',0),('18177700384','announce-holdtime','no',0),('18177700384','member','Agent/2007,0',7),('18177700384','member','Agent/2008,0',8),('18177700384','eventmemberstatus','no',0),('18177700384','eventwhencalled','no',0),('18177700384','maxlen','0',0),('18177700384','joinempty','yes',0),('18177700384','leavewhenempty','no',0),('18177700384','strategy','random',0),('18177700384','timeout','0',0),('18177700384','retry','5',0),('18177700384','wrapuptime','0',0),('18177700384','announce-frequency','0',0),('28177700100','answered_elsewhere','0',0),('98177700100','member','Agent/2001,0',1),('98177700100','member','Agent/2000,0',0),('28177700100','member','Agent/2007,0',7),('28177700100','autopauseunavail','no',0),('28177700100','timeoutpriority','app',0),('18147370245','member','Agent/2000,0',0),('18147370245','member','Agent/2001,0',1),('18147370245','member','Agent/2002,0',2),('18147370245','autopausedelay','0',0),('18147370245','servicelevel','60',0),('18147370245','memberdelay','0',0),('18147370245','timeoutrestart','no',0),('18147370245','skip_joinannounce','',0),('18147370245','cron_schedule','never',0),('18147370245','autopausebusy','no',0),('18147370245','autopauseunavail','no',0),('18147370245','timeoutpriority','app',0),('18147370245','penaltymemberslimit','0',0),('18147370245','timeout','0',0),('18147370245','retry','5',0),('18147370245','wrapuptime','0',0),('18147370245','announce-frequency','0',0),('18147370245','announce-holdtime','no',0),('18147370245','announce-position','no',0),('18147370245','queue-youarenext','silence/1',0),('18147370245','queue-thereare','silence/1',0),('18147370245','queue-callswaiting','silence/1',0),('18147370245','queue-thankyou','',0),('18147370245','periodic-announce-frequency','0',0),('18147370245','monitor-format','',0),('18147370245','monitor-join','yes',0),('18147370245','eventwhencalled','no',0),('18147370245','eventmemberstatus','no',0),('18147370245','weight','0',0),('18147370245','autofill','no',0),('18147370245','ringinuse','yes',0),('18147370246','answered_elsewhere','0',0),('18147370246','member','Agent/2000,0',0),('18147370246','queue-youarenext','silence/1',0),('18147370246','queue-thereare','silence/1',0),('18147370246','queue-callswaiting','silence/1',0),('18147370246','queue-thankyou','',0),('18147370246','periodic-announce-frequency','0',0),('18147370246','monitor-format','',0),('18147370246','monitor-join','yes',0),('18147370246','eventwhencalled','no',0),('18147370246','eventmemberstatus','no',0),('18147370246','weight','0',0),('18147370246','autofill','no',0),('18147370246','ringinuse','yes',0),('18147370246','reportholdtime','no',0),('18147370246','autopause','no',0),('18147370246','autopausedelay','0',0),('18147370246','servicelevel','60',0),('18147370246','memberdelay','0',0),('18147370246','timeoutrestart','no',0),('18147370246','skip_joinannounce','',0),('18147370246','cron_schedule','never',0),('18147370246','autopausebusy','no',0),('18147370246','autopauseunavail','no',0),('18147370246','timeoutpriority','app',0),('18147370246','penaltymemberslimit','0',0),('18147370246','maxlen','0',0),('18147370246','joinempty','yes',0),('18147370246','leavewhenempty','no',0),('18147370246','strategy','random',0),('18177700385','member','Agent/2003,0',3),('28177700100','autofill','no',0),('28177700100','ringinuse','yes',0),('28177700100','reportholdtime','no',0),('28177700100','autopause','no',0),('18177700385','member','Agent/2005,0',5),('18177700385','member','Agent/2006,0',6),('18177700385','member','Agent/2007,0',7),('28177700100','member','Agent/2003,0',3),('28177700100','weight','0',0),('28177700100','member','Agent/2000,0',0),('28177700100','member','Agent/2001,0',1),('28177700100','timeoutrestart','no',0),('28177700100','skip_joinannounce','',0),('28177700100','memberdelay','0',0),('28177700100','maxlen','0',0),('28177700100','joinempty','yes',0),('28177700100','leavewhenempty','no',0),('28177700100','strategy','random',0),('28177700100','timeout','60',0),('28177700100','retry','5',0),('28177700100','wrapuptime','0',0),('28177700100','announce-frequency','0',0),('28177700100','announce-holdtime','no',0),('28177700100','announce-position','no',0),('28177700100','queue-youarenext','silence/1',0),('28177700100','queue-thereare','silence/1',0),('28177700100','queue-callswaiting','silence/1',0),('18177700384','member','Agent/2005,0',5),('18177700384','member','Agent/2006,0',6),('18177700384','timeoutrestart','no',0),('18147370224','answered_elsewhere','0',0),('18147370224','member','Agent/2000,0',0),('18147370224','queue-youarenext','silence/1',0),('18147370224','queue-thereare','silence/1',0),('18147370224','queue-callswaiting','silence/1',0),('18147370224','queue-thankyou','',0),('18147370224','periodic-announce-frequency','0',0),('18147370224','monitor-format','',0),('18147370224','monitor-join','yes',0),('18147370224','eventwhencalled','no',0),('18147370224','eventmemberstatus','no',0),('18147370224','weight','0',0),('18147370224','autofill','no',0),('18147370224','ringinuse','yes',0),('18147370224','reportholdtime','no',0),('18147370224','autopause','no',0),('18147370224','autopausedelay','0',0),('18147370224','servicelevel','60',0),('18147370224','memberdelay','0',0),('18147370224','timeoutrestart','no',0),('18147370224','skip_joinannounce','',0),('18147370224','cron_schedule','never',0),('18147370224','autopausebusy','no',0),('18147370224','autopauseunavail','no',0),('18147370224','timeoutpriority','app',0),('18147370224','penaltymemberslimit','0',0),('18147370224','maxlen','0',0),('18147370224','joinempty','yes',0),('18147370224','leavewhenempty','no',0),('18147370224','strategy','random',0),('18147370226','answered_elsewhere','0',0),('18147370226','member','Agent/2000,0',0),('18147370226','queue-youarenext','silence/1',0),('18147370226','queue-thereare','silence/1',0),('18147370226','queue-callswaiting','silence/1',0),('18147370226','queue-thankyou','',0),('18147370226','periodic-announce-frequency','0',0),('18147370226','monitor-format','',0),('18147370226','monitor-join','yes',0),('18147370226','eventwhencalled','no',0),('18147370226','eventmemberstatus','no',0),('18147370226','weight','0',0),('18147370226','autofill','no',0),('18147370226','ringinuse','yes',0),('18147370226','reportholdtime','no',0),('18147370226','autopause','no',0),('18147370226','autopausedelay','0',0),('18147370226','servicelevel','60',0),('18147370226','memberdelay','0',0),('18147370226','timeoutrestart','no',0),('18147370226','skip_joinannounce','',0),('18147370226','cron_schedule','never',0),('18147370226','autopausebusy','no',0),('18147370226','autopauseunavail','no',0),('18147370226','timeoutpriority','app',0),('18147370226','penaltymemberslimit','0',0),('18147370226','maxlen','0',0),('18147370226','joinempty','yes',0),('18147370226','leavewhenempty','no',0),('18147370226','strategy','random',0),('18147370227','answered_elsewhere','0',0),('18147370227','member','Agent/2000,0',0),('18147370227','queue-youarenext','silence/1',0),('18147370227','queue-thereare','silence/1',0),('18147370227','queue-callswaiting','silence/1',0),('18147370227','queue-thankyou','',0),('18147370227','periodic-announce-frequency','0',0),('18147370227','monitor-format','',0),('18147370227','monitor-join','yes',0),('18147370227','eventwhencalled','no',0),('18147370227','eventmemberstatus','no',0),('18147370227','weight','0',0),('18147370227','autofill','no',0),('18147370227','ringinuse','yes',0),('18147370227','reportholdtime','no',0),('18147370227','autopause','no',0),('18147370227','autopausedelay','0',0),('18147370227','servicelevel','60',0),('18147370227','memberdelay','0',0),('18147370227','timeoutrestart','no',0),('18147370227','skip_joinannounce','',0),('18147370227','cron_schedule','never',0),('18147370227','autopausebusy','no',0),('18147370227','autopauseunavail','no',0),('18147370227','timeoutpriority','app',0),('18147370227','penaltymemberslimit','0',0),('18147370227','maxlen','0',0),('18147370227','joinempty','yes',0),('18147370227','leavewhenempty','no',0),('18147370227','strategy','random',0),('18147370215','autopausedelay','0',0),('18147370215','servicelevel','60',0),('18177700385','member','Agent/2004,0',4),('18177700385','autopausebusy','no',0),('18177702604','maxlen','0',0),('28177700100','member','Agent/2011,0',11),('28177700100','autopausedelay','0',0),('28177700100','servicelevel','60',0),('28177700100','monitor-join','yes',0),('28177700100','eventwhencalled','no',0),('28177700100','queue-thankyou','',0),('28177700100','periodic-announce-frequency','0',0),('28177700100','monitor-format','',0),('18147370224','member','Agent/2007,0',7),('18147370224','member','Agent/2008,0',8),('18147370224','timeout','0',0),('18147370224','retry','5',0),('18147370224','wrapuptime','0',0),('18147370224','announce-frequency','0',0),('18147370224','announce-holdtime','no',0),('18147370224','announce-position','no',0),('18147370226','member','Agent/2007,0',7),('18147370226','member','Agent/2008,0',8),('18147370226','timeout','0',0),('18147370226','retry','5',0),('18147370226','wrapuptime','0',0),('18147370226','announce-frequency','0',0),('18147370226','announce-holdtime','no',0),('18147370226','announce-position','no',0),('18147370227','member','Agent/2007,0',7),('18147370227','member','Agent/2008,0',8),('18147370227','timeout','0',0),('18147370227','retry','5',0),('18147370227','wrapuptime','0',0),('18147370227','announce-frequency','0',0),('18147370227','announce-holdtime','no',0),('18147370227','announce-position','no',0),('18147370239','member','Agent/2006,0',6),('18147370239','member','Agent/2007,0',7),('18147370239','timeout','0',0),('18147370239','retry','5',0),('18147370239','wrapuptime','0',0),('18147370239','announce-frequency','0',0),('18147370239','announce-holdtime','no',0),('18147370239','announce-position','no',0),('18147370240','member','Agent/2004,0',4),('18147370240','member','Agent/2003,0',3),('18147370240','reportholdtime','no',0),('18147370240','autopause','no',0),('18147370240','maxlen','0',0),('18147370240','joinempty','yes',0),('18147370240','leavewhenempty','no',0),('18147370240','strategy','random',0),('18147370241','member','Agent/2007,0',7),('18147370241','member','Agent/2008,0',8),('18147370241','timeout','0',0),('18147370241','retry','5',0),('18147370241','wrapuptime','0',0),('18147370241','announce-frequency','0',0),('18147370241','announce-holdtime','no',0),('18147370241','announce-position','no',0),('18147370242','member','Agent/2007,0',7),('18147370242','member','Agent/2008,0',8),('18147370242','timeout','0',0),('18147370242','retry','5',0),('18147370242','wrapuptime','0',0),('18147370242','announce-frequency','0',0),('18147370242','announce-holdtime','no',0),('18147370242','announce-position','no',0),('18177700384','member','Agent/2004,0',4),('18177700384','member','Agent/2003,0',3),('18177700384','member','Agent/2002,0',2),('18177700384','penaltymemberslimit','0',0),('18177700384','answered_elsewhere','0',0),('18177700384','member','Agent/2000,0',0),('18177700384','member','Agent/2001,0',1),('18177700384','monitor-join','yes',0),('18147370245','member','Agent/2004,0',4),('18147370245','member','Agent/2003,0',3),('18147370245','reportholdtime','no',0),('18147370245','autopause','no',0),('18147370245','maxlen','0',0),('18147370245','joinempty','yes',0),('18147370245','leavewhenempty','no',0),('18147370245','strategy','random',0),('18147370246','member','Agent/2007,0',7),('18147370246','member','Agent/2008,0',8),('18147370246','timeout','0',0),('18147370246','retry','5',0),('18147370246','wrapuptime','0',0),('18147370246','announce-frequency','0',0),('18147370246','announce-holdtime','no',0),('18147370246','announce-position','no',0),('18147370247','member','Agent/2007,0',7),('18147370247','member','Agent/2008,0',8),('18147370247','timeout','0',0),('18147370247','retry','5',0),('18147370247','wrapuptime','0',0),('18147370247','announce-frequency','0',0),('18147370247','announce-holdtime','no',0),('18147370247','announce-position','no',0),('18177700692','autopausebusy','no',0),('18177700101','member','Agent/2007,0',7),('18177700101','monitor-join','yes',0),('18177700101','eventwhencalled','no',0),('18177700101','eventmemberstatus','no',0),('18177700101','weight','0',0),('18177700101','monitor-format','',0),('18177700102','member','Agent/2003,0',3),('18177700102','member','Agent/2002,0',2),('18177700102','reportholdtime','no',0),('18177700102','autopause','no',0),('18177700102','maxlen','0',0),('18177700102','joinempty','yes',0),('18177700102','leavewhenempty','no',0),('18177700102','strategy','random',0),('18177700103','member','Agent/2007,0',7),('18177700103','member','Agent/2008,0',8),('18177700103','timeout','0',0),('18177700103','retry','5',0),('18177700103','wrapuptime','0',0),('18177700103','announce-frequency','0',0),('18177700103','announce-holdtime','no',0),('18177700103','announce-position','no',0),('18177700104','member','Agent/2007,0',7),('18177700104','member','Agent/2008,0',8),('18177700104','timeout','0',0),('18177700104','retry','5',0),('18177700104','wrapuptime','0',0),('18177700104','announce-frequency','0',0),('18177700104','announce-holdtime','no',0),('18177700104','announce-position','no',0),('18177700105','member','Agent/2007,0',7),('18177700105','member','Agent/2008,0',8),('18177700105','timeout','0',0),('18177700105','retry','5',0),('18177700105','wrapuptime','0',0),('18177700105','announce-frequency','0',0),('18177700105','announce-holdtime','no',0),('18177700105','announce-position','no',0),('18177700106','member','Agent/2004,0',4),('18177700106','member','Agent/2003,0',3),('18177700106','reportholdtime','no',0),('18177700106','autopause','no',0),('18177700106','maxlen','0',0),('18177700106','joinempty','yes',0),('18177700106','leavewhenempty','no',0),('18177700106','strategy','random',0),('18177700387','member','Agent/2004,0',4),('18177700387','member','Agent/2003,0',3),('18177700387','reportholdtime','no',0),('18177700387','autopause','no',0),('18177700387','maxlen','0',0),('18177700387','joinempty','yes',0),('18177700387','leavewhenempty','no',0),('18177700387','strategy','random',0),('19847770191','member','Agent/2009,0',9),('19847770191','memberdelay','0',0),('19847770191','timeoutrestart','no',0),('19847770191','weight','0',0),('19847770191','autofill','no',0),('19847770191','ringinuse','yes',0),('98147370215','member','Agent/2007,0',7),('98147370215','member','Agent/2008,0',8),('98147370215','timeout','0',0),('98147370215','retry','5',0),('98147370215','wrapuptime','0',0),('98147370215','announce-frequency','0',0),('98147370215','announce-holdtime','no',0),('98147370215','announce-position','no',0),('18147370229','autopausedelay','0',0),('18147370229','servicelevel','60',0),('18147370229','memberdelay','0',0),('18147370229','timeoutrestart','no',0),('18147370229','skip_joinannounce','',0),('18147370229','cron_schedule','never',0),('18147370229','autopausebusy','no',0),('18147370229','autopauseunavail','no',0),('18147370229','timeoutpriority','app',0),('18147370229','penaltymemberslimit','0',0),('18147370229','answered_elsewhere','0',0),('18147370229','member','Agent/2000,0',0),('18147370229','member','Agent/2001,0',1),('18147370229','queue-thankyou','',0),('18147370229','periodic-announce-frequency','0',0),('18147370229','monitor-format','',0),('18147370229','monitor-join','yes',0),('18147370229','queue-youarenext','silence/1',0),('18147370229','queue-thereare','silence/1',0),('18147370229','queue-callswaiting','silence/1',0),('18147370229','maxlen','0',0),('18147370229','joinempty','yes',0),('18147370229','leavewhenempty','no',0),('18147370229','strategy','random',0),('18147370229','timeout','0',0),('18147370229','retry','5',0),('18147370229','wrapuptime','0',0),('18147370229','announce-frequency','0',0),('18147370229','announce-holdtime','no',0),('18147370229','announce-position','no',0),('18147370233','answered_elsewhere','0',0),('18147370233','member','Agent/2000,0',0),('18147370233','queue-youarenext','silence/1',0),('18147370233','queue-thereare','silence/1',0),('18147370233','queue-callswaiting','silence/1',0),('18147370233','queue-thankyou','',0),('18147370233','periodic-announce-frequency','0',0),('18147370233','monitor-format','',0),('18147370233','monitor-join','yes',0),('18147370233','eventwhencalled','no',0),('18147370233','eventmemberstatus','no',0),('18147370233','weight','0',0),('18147370233','autofill','no',0),('18147370233','ringinuse','yes',0),('18147370233','reportholdtime','no',0),('18147370233','autopause','no',0),('18147370233','autopausedelay','0',0),('18147370233','servicelevel','60',0),('18147370233','memberdelay','0',0),('18147370233','timeoutrestart','no',0),('18147370233','skip_joinannounce','',0),('18147370233','cron_schedule','never',0),('18147370233','autopausebusy','no',0),('18147370233','autopauseunavail','no',0),('18147370233','timeoutpriority','app',0),('18147370233','penaltymemberslimit','0',0),('18147370233','maxlen','0',0),('18147370233','joinempty','yes',0),('18147370233','leavewhenempty','no',0),('18147370233','strategy','random',0),('18147370234','autopausedelay','0',0),('18147370234','servicelevel','60',0),('18147370234','memberdelay','0',0),('18147370234','timeoutrestart','no',0),('18147370234','skip_joinannounce','',0),('18147370234','cron_schedule','never',0),('18147370234','autopausebusy','no',0),('18147370234','autopauseunavail','no',0),('18147370234','timeoutpriority','app',0),('18147370234','penaltymemberslimit','0',0),('18147370234','answered_elsewhere','0',0),('18147370234','member','Agent/2000,0',0),('18147370234','member','Agent/2001,0',1),('18147370234','queue-thankyou','',0),('18147370234','periodic-announce-frequency','0',0),('18147370234','monitor-format','',0),('18147370234','monitor-join','yes',0),('18147370234','queue-youarenext','silence/1',0),('18147370234','queue-thereare','silence/1',0),('18147370234','queue-callswaiting','silence/1',0),('18147370234','maxlen','0',0),('18147370234','joinempty','yes',0),('18147370234','leavewhenempty','no',0),('18147370234','strategy','random',0),('18147370234','timeout','0',0),('18147370234','retry','5',0),('18147370234','wrapuptime','0',0),('18147370234','announce-frequency','0',0),('18147370234','announce-holdtime','no',0),('18147370234','announce-position','no',0),('18177700113','autopausedelay','0',0),('18177700113','servicelevel','60',0),('18177700113','memberdelay','0',0),('18177700113','timeoutrestart','no',0),('18177700113','skip_joinannounce','',0),('18177700113','cron_schedule','never',0),('18177700113','autopausebusy','no',0),('18177700113','autopauseunavail','no',0),('18177700113','timeoutpriority','app',0),('18177700113','penaltymemberslimit','0',0),('18177700113','answered_elsewhere','0',0),('18177700113','member','Agent/2000,0',0),('18177700113','member','Agent/2001,0',1),('18177700113','queue-thankyou','',0),('18177700113','periodic-announce-frequency','0',0),('18177700113','monitor-format','',0),('18177700113','monitor-join','yes',0),('18177700113','queue-youarenext','silence/1',0),('18177700113','queue-thereare','silence/1',0),('18177700113','queue-callswaiting','silence/1',0),('18177700113','maxlen','0',0),('18177700113','joinempty','yes',0),('18177700113','leavewhenempty','no',0),('18177700113','strategy','random',0),('18177700113','timeout','0',0),('18177700113','retry','5',0),('18177700113','wrapuptime','0',0),('18177700113','announce-frequency','0',0),('18177700113','announce-holdtime','no',0),('18177700113','announce-position','no',0),('18177700114','autopausedelay','0',0),('18177700114','servicelevel','60',0),('18177700114','memberdelay','0',0),('18177700114','timeoutrestart','no',0),('18177700114','skip_joinannounce','',0),('18177700114','cron_schedule','never',0),('18177700114','autopausebusy','no',0),('18177700114','autopauseunavail','no',0),('18177700114','timeoutpriority','app',0),('18177700114','penaltymemberslimit','0',0),('18177700114','answered_elsewhere','0',0),('18177700114','member','Agent/2000,0',0),('18177700114','member','Agent/2001,0',1),('18177700114','queue-thankyou','',0),('18177700114','periodic-announce-frequency','0',0),('18177700114','monitor-format','',0),('18177700114','monitor-join','yes',0),('18177700114','queue-youarenext','silence/1',0),('18177700114','queue-thereare','silence/1',0),('18177700114','queue-callswaiting','silence/1',0),('18177700114','maxlen','0',0),('18177700114','joinempty','yes',0),('18177700114','leavewhenempty','no',0),('18177700114','strategy','random',0),('18177700114','timeout','0',0),('18177700114','retry','5',0),('18177700114','wrapuptime','0',0),('18177700114','announce-frequency','0',0),('18177700114','announce-holdtime','no',0),('18177700114','announce-position','no',0),('18177700115','autopausedelay','0',0),('18177700115','servicelevel','60',0),('18177700115','memberdelay','0',0),('18177700115','timeoutrestart','no',0),('18177700115','skip_joinannounce','',0),('18177700115','cron_schedule','never',0),('18177700115','autopausebusy','no',0),('18177700115','autopauseunavail','no',0),('18177700115','timeoutpriority','app',0),('18177700115','penaltymemberslimit','0',0),('18177700115','answered_elsewhere','0',0),('18177700115','member','Agent/2000,0',0),('18177700115','member','Agent/2001,0',1),('18177700115','queue-thankyou','',0),('18177700115','periodic-announce-frequency','0',0),('18177700115','monitor-format','',0),('18177700115','monitor-join','yes',0),('18177700115','queue-youarenext','silence/1',0),('18177700115','queue-thereare','silence/1',0),('18177700115','queue-callswaiting','silence/1',0),('18177700115','maxlen','0',0),('18177700115','joinempty','yes',0),('18177700115','leavewhenempty','no',0),('18177700115','strategy','random',0),('18177700115','timeout','0',0),('18177700115','retry','5',0),('18177700115','wrapuptime','0',0),('18177700115','announce-frequency','0',0),('18177700115','announce-holdtime','no',0),('18177700115','announce-position','no',0),('18177700112','member','Agent/2001,0',1),('18177700112','member','Agent/2002,0',2),('18177700112','timeoutrestart','no',0),('18177700112','skip_joinannounce','',0),('18177700112','cron_schedule','never',0),('18177700112','autopausebusy','no',0),('18177700112','autopauseunavail','no',0),('18177700112','timeoutpriority','app',0),('18177700112','penaltymemberslimit','0',0),('18177700112','answered_elsewhere','0',0),('18177700112','wrapuptime','0',0),('18177700112','announce-frequency','0',0),('18177700112','announce-holdtime','no',0),('18177700112','announce-position','no',0),('18177700112','queue-youarenext','silence/1',0),('18177700112','queue-thereare','silence/1',0),('18177700112','queue-callswaiting','silence/1',0),('18177700112','queue-thankyou','',0),('18177700112','periodic-announce-frequency','0',0),('18177700112','monitor-format','',0),('18177700112','monitor-join','yes',0),('18177700112','eventwhencalled','no',0),('18177700112','eventmemberstatus','no',0),('18177700112','weight','0',0),('18177700112','autofill','no',0),('18177700112','ringinuse','yes',0),('18177700112','reportholdtime','no',0),('18177700112','autopause','no',0),('18177700112','autopausedelay','0',0),('18147370230','autopausedelay','0',0),('18147370215','member','Agent/2002,0',2),('18147370230','member','Agent/2004,0',4),('18147370230','member','Agent/2003,0',3),('18147370230','member','Agent/2000,0',0),('18147370230','autopauseunavail','no',0),('18147370230','timeoutpriority','app',0),('18147370230','penaltymemberslimit','0',0),('18147370230','answered_elsewhere','0',0),('18147370230','timeoutrestart','no',0),('18147370230','skip_joinannounce','',0),('18147370230','cron_schedule','never',0),('18147370230','autopausebusy','no',0),('18147370230','servicelevel','60',0),('18147370230','memberdelay','0',0),('18147370230','queue-thankyou','',0),('18147370230','periodic-announce-frequency','0',0),('18147370230','monitor-format','',0),('18147370230','monitor-join','yes',0),('18147370230','queue-youarenext','silence/1',0),('18147370230','queue-thereare','silence/1',0),('18147370230','queue-callswaiting','silence/1',0),('18147370230','maxlen','0',0),('18147370230','joinempty','yes',0),('18147370230','leavewhenempty','no',0),('18147370230','strategy','random',0),('18147370230','timeout','0',0),('18147370230','retry','5',0),('18147370230','wrapuptime','0',0),('18147370230','announce-frequency','0',0),('18147370230','announce-holdtime','no',0),('18147370230','announce-position','no',0),('18177700101','penaltymemberslimit','0',0),('18177700101','answered_elsewhere','0',0),('18177700101','periodic-announce-frequency','0',0),('15589958531','autopausedelay','0',0),('15589958531','servicelevel','60',0),('15589958531','memberdelay','0',0),('15589958531','timeoutrestart','no',0),('15589958531','skip_joinannounce','',0),('15589958531','cron_schedule','never',0),('15589958531','autopausebusy','no',0),('15589958531','autopauseunavail','no',0),('15589958531','timeoutpriority','app',0),('15589958531','penaltymemberslimit','0',0),('15589958531','answered_elsewhere','0',0),('15589958531','member','Agent/2000,0',0),('15589958531','member','Agent/2001,0',1),('15589958531','queue-thankyou','',0),('15589958531','periodic-announce-frequency','0',0),('15589958531','monitor-format','',0),('15589958531','monitor-join','yes',0),('15589958531','queue-youarenext','silence/1',0),('15589958531','queue-thereare','silence/1',0),('15589958531','queue-callswaiting','silence/1',0),('15589958531','maxlen','0',0),('15589958531','joinempty','yes',0),('15589958531','leavewhenempty','no',0),('15589958531','strategy','random',0),('15589958531','timeout','0',0),('15589958531','retry','5',0),('15589958531','wrapuptime','0',0),('15589958531','announce-frequency','0',0),('15589958531','announce-holdtime','no',0),('15589958531','announce-position','no',0),('15589958532','autopausedelay','0',0),('15589958532','servicelevel','60',0),('15589958532','memberdelay','0',0),('15589958532','timeoutrestart','no',0),('15589958532','skip_joinannounce','',0),('15589958532','cron_schedule','never',0),('15589958532','autopausebusy','no',0),('15589958532','autopauseunavail','no',0),('15589958532','timeoutpriority','app',0),('15589958532','penaltymemberslimit','0',0),('15589958532','answered_elsewhere','0',0),('15589958532','member','Agent/2000,0',0),('15589958532','member','Agent/2001,0',1),('15589958532','queue-thankyou','',0),('15589958532','periodic-announce-frequency','0',0),('15589958532','monitor-format','',0),('15589958532','monitor-join','yes',0),('15589958532','queue-youarenext','silence/1',0),('15589958532','queue-thereare','silence/1',0),('15589958532','queue-callswaiting','silence/1',0),('15589958532','maxlen','0',0),('15589958532','joinempty','yes',0),('15589958532','leavewhenempty','no',0),('15589958532','strategy','random',0),('15589958532','timeout','0',0),('15589958532','retry','5',0),('15589958532','wrapuptime','0',0),('15589958532','announce-frequency','0',0),('15589958532','announce-holdtime','no',0),('15589958532','announce-position','no',0),('15589958533','autopausedelay','0',0),('15589958533','servicelevel','60',0),('15589958533','memberdelay','0',0),('15589958533','timeoutrestart','no',0),('15589958533','skip_joinannounce','',0),('15589958533','cron_schedule','never',0),('15589958533','autopausebusy','no',0),('15589958533','autopauseunavail','no',0),('15589958533','timeoutpriority','app',0),('15589958533','penaltymemberslimit','0',0),('15589958533','answered_elsewhere','0',0),('15589958533','member','Agent/2000,0',0),('15589958533','member','Agent/2001,0',1),('15589958533','queue-thankyou','',0),('15589958533','periodic-announce-frequency','0',0),('15589958533','monitor-format','',0),('15589958533','monitor-join','yes',0),('15589958533','queue-youarenext','silence/1',0),('15589958533','queue-thereare','silence/1',0),('15589958533','queue-callswaiting','silence/1',0),('15589958533','maxlen','0',0),('15589958533','joinempty','yes',0),('15589958533','leavewhenempty','no',0),('15589958533','strategy','random',0),('15589958533','timeout','0',0),('15589958533','retry','5',0),('15589958533','wrapuptime','0',0),('15589958533','announce-frequency','0',0),('15589958533','announce-holdtime','no',0),('15589958533','announce-position','no',0),('18147370237','member','Agent/2007,0',7),('18147370237','member','Agent/2003,0',3),('18147370237','member','Agent/2004,0',4),('18147370237','periodic-announce-frequency','0',0),('18147370237','monitor-format','',0),('18147370237','monitor-join','yes',0),('18147370237','eventwhencalled','no',0),('18147370237','eventmemberstatus','no',0),('18147370237','weight','0',0),('18147370237','autofill','no',0),('18147370237','ringinuse','yes',0),('18147370237','reportholdtime','no',0),('18147370237','autopause','no',0),('18147370237','autopausedelay','0',0),('18147370237','servicelevel','60',0),('18147370237','memberdelay','0',0),('18147370237','timeoutrestart','no',0),('18147370237','skip_joinannounce','',0),('18147370237','cron_schedule','never',0),('18147370237','autopausebusy','no',0),('18147370237','autopauseunavail','no',0),('18147370237','timeoutpriority','app',0),('18147370237','penaltymemberslimit','0',0),('18147370237','answered_elsewhere','0',0),('18147370237','member','Agent/2000,0',0),('18147370237','member','Agent/2001,0',1),('18147370237','member','Agent/2002,0',2),('18147370237','maxlen','0',0),('18147370237','joinempty','yes',0),('18147370237','leavewhenempty','no',0),('18147370237','strategy','random',0),('18147370238','member','Agent/2007,0',7),('18147370238','member','Agent/2003,0',3),('18147370238','member','Agent/2004,0',4),('18147370238','periodic-announce-frequency','0',0),('18147370238','monitor-format','',0),('18147370238','monitor-join','yes',0),('18147370238','eventwhencalled','no',0),('18147370238','eventmemberstatus','no',0),('18147370238','weight','0',0),('18147370238','autofill','no',0),('18147370238','ringinuse','yes',0),('18147370238','reportholdtime','no',0),('18147370238','autopause','no',0),('18147370238','autopausedelay','0',0),('18147370238','servicelevel','60',0),('18147370238','memberdelay','0',0),('18147370238','timeoutrestart','no',0),('18147370238','skip_joinannounce','',0),('18147370238','cron_schedule','never',0),('18147370238','autopausebusy','no',0),('18147370238','autopauseunavail','no',0),('18147370238','timeoutpriority','app',0),('18147370238','penaltymemberslimit','0',0),('18147370238','answered_elsewhere','0',0),('18147370238','member','Agent/2000,0',0),('18147370238','member','Agent/2001,0',1),('18147370238','member','Agent/2002,0',2),('18147370238','maxlen','0',0),('18147370238','joinempty','yes',0),('18147370238','leavewhenempty','no',0),('18147370238','strategy','random',0),('12226443774','member','Agent/2005,0',5),('18147370231','member','Agent/2007,0',7),('18147370231','member','Agent/2006,0',6),('18147370231','timeoutrestart','no',0),('18147370231','skip_joinannounce','',0),('18147370231','cron_schedule','never',0),('18147370231','autopausebusy','no',0),('18147370231','autopauseunavail','no',0),('18147370231','timeoutpriority','app',0),('18147370231','penaltymemberslimit','0',0),('18147370231','answered_elsewhere','0',0),('18147370231','wrapuptime','0',0),('18147370231','announce-frequency','0',0),('18147370231','announce-holdtime','no',0),('18147370231','announce-position','no',0),('18147370231','queue-youarenext','silence/1',0),('18147370231','queue-thereare','silence/1',0),('18147370231','queue-callswaiting','silence/1',0),('18147370231','queue-thankyou','',0),('18147370231','periodic-announce-frequency','0',0),('18147370231','monitor-format','',0),('18147370231','monitor-join','yes',0),('18147370231','eventwhencalled','no',0),('18147370231','eventmemberstatus','no',0),('18147370231','weight','0',0),('18147370231','autofill','no',0),('18147370231','ringinuse','yes',0),('18147370231','reportholdtime','no',0),('18147370231','autopause','no',0),('18147370231','autopausedelay','0',0),('18147370232','autopausedelay','0',0),('18147370232','servicelevel','60',0),('18147370232','memberdelay','0',0),('18147370232','timeoutrestart','no',0),('18147370232','skip_joinannounce','',0),('18147370232','cron_schedule','never',0),('18147370232','autopausebusy','no',0),('18147370232','autopauseunavail','no',0),('18147370232','timeoutpriority','app',0),('18147370232','penaltymemberslimit','0',0),('18147370232','answered_elsewhere','0',0),('18147370232','member','Agent/2000,0',0),('18147370232','member','Agent/2001,0',1),('18147370232','queue-thankyou','',0),('18147370232','periodic-announce-frequency','0',0),('18147370232','monitor-format','',0),('18147370232','monitor-join','yes',0),('18147370232','queue-youarenext','silence/1',0),('18147370232','queue-thereare','silence/1',0),('18147370232','queue-callswaiting','silence/1',0),('18147370232','maxlen','0',0),('18147370232','joinempty','yes',0),('18147370232','leavewhenempty','no',0),('18147370232','strategy','random',0),('18147370232','timeout','0',0),('18147370232','retry','5',0),('18147370232','wrapuptime','0',0),('18147370232','announce-frequency','0',0),('18147370232','announce-holdtime','no',0),('18147370232','announce-position','no',0),('18147370217','autopausedelay','0',0),('18147370217','servicelevel','60',0),('18147370217','memberdelay','0',0),('18147370217','timeoutrestart','no',0),('18147370217','skip_joinannounce','',0),('18147370217','cron_schedule','never',0),('18147370217','autopausebusy','no',0),('18147370217','autopauseunavail','no',0),('18147370217','timeoutpriority','app',0),('18147370217','penaltymemberslimit','0',0),('18147370217','answered_elsewhere','0',0),('18147370217','member','Agent/2000,0',0),('18147370217','member','Agent/2001,0',1),('18147370217','queue-thankyou','',0),('18147370217','periodic-announce-frequency','0',0),('18147370217','monitor-format','',0),('18147370217','monitor-join','yes',0),('18147370217','queue-youarenext','silence/1',0),('18147370217','queue-thereare','silence/1',0),('18147370217','queue-callswaiting','silence/1',0),('18147370217','maxlen','0',0),('18147370217','joinempty','yes',0),('18147370217','leavewhenempty','no',0),('18147370217','strategy','random',0),('18147370217','timeout','0',0),('18147370217','retry','5',0),('18147370217','wrapuptime','0',0),('18147370217','announce-frequency','0',0),('18147370217','announce-holdtime','no',0),('18147370217','announce-position','no',0),('18147370218','member','Agent/2006,0',6),('18147370218','member','Agent/2007,0',7),('18147370218','timeoutrestart','no',0),('18147370218','skip_joinannounce','',0),('18147370218','cron_schedule','never',0),('18147370218','autopausebusy','no',0),('18147370218','autopauseunavail','no',0),('18147370218','timeoutpriority','app',0),('18147370218','penaltymemberslimit','0',0),('18147370218','answered_elsewhere','0',0),('18147370218','wrapuptime','0',0),('18147370218','announce-frequency','0',0),('18147370218','announce-holdtime','no',0),('18147370218','announce-position','no',0),('18147370218','queue-youarenext','silence/1',0),('18147370218','queue-thereare','silence/1',0),('18147370218','queue-callswaiting','silence/1',0),('18147370218','queue-thankyou','',0),('18147370218','periodic-announce-frequency','0',0),('18147370218','monitor-format','',0),('18147370218','monitor-join','yes',0),('18147370218','eventwhencalled','no',0),('18147370218','eventmemberstatus','no',0),('18147370218','weight','0',0),('18147370218','autofill','no',0),('18147370218','ringinuse','yes',0),('18147370218','reportholdtime','no',0),('18147370218','autopause','no',0),('18147370218','autopausedelay','0',0),('18147370216','member','Agent/2005,0',5),('18147370216','member','Agent/2006,0',6),('18147370216','member','Agent/2007,0',7),('18147370216','member','Agent/2008,0',8),('18147370216','member','Agent/2009,0',9),('18147370216','member','Agent/2003,0',3),('18147370216','queue-callswaiting','silence/1',0),('18147370216','queue-thankyou','',0),('18147370216','periodic-announce-frequency','0',0),('18147370216','monitor-format','',0),('18147370216','monitor-join','yes',0),('18147370216','eventwhencalled','no',0),('18147370216','eventmemberstatus','no',0),('18147370216','weight','0',0),('18147370216','autofill','no',0),('18147370216','ringinuse','yes',0),('18147370216','reportholdtime','no',0),('18147370216','autopause','no',0),('18147370216','autopausedelay','0',0),('18147370216','servicelevel','60',0),('18147370216','memberdelay','0',0),('18147370216','timeoutrestart','no',0),('18147370216','skip_joinannounce','',0),('18147370216','cron_schedule','never',0),('18147370216','autopausebusy','no',0),('18147370216','autopauseunavail','no',0),('18147370216','timeoutpriority','app',0),('18147370216','penaltymemberslimit','0',0),('18147370216','maxlen','0',0),('18147370216','joinempty','yes',0),('18177700108','member','Agent/2004,0',4),('18177700111','penaltymemberslimit','0',0),('18177700116','autopausedelay','0',0),('18177700116','servicelevel','60',0),('18177700116','memberdelay','0',0),('18177700116','timeoutrestart','no',0),('18177700116','skip_joinannounce','',0),('18177700116','cron_schedule','never',0),('18177700116','autopausebusy','no',0),('18177700116','autopauseunavail','no',0),('18177700116','timeoutpriority','app',0),('18177700116','penaltymemberslimit','0',0),('18177700116','answered_elsewhere','0',0),('18177700116','member','Agent/2000,0',0),('18177700116','member','Agent/2001,0',1),('18177700116','queue-thankyou','',0),('18177700116','periodic-announce-frequency','0',0),('18177700116','monitor-format','',0),('18177700116','monitor-join','yes',0),('18177700116','queue-youarenext','silence/1',0),('18177700116','queue-thereare','silence/1',0),('18177700116','queue-callswaiting','silence/1',0),('18177700116','maxlen','0',0),('18177700116','joinempty','yes',0),('18177700116','leavewhenempty','no',0),('18177700116','strategy','random',0),('18177700116','timeout','0',0),('18177700116','retry','5',0),('18177700116','wrapuptime','0',0),('18177700116','announce-frequency','0',0),('18177700116','announce-holdtime','no',0),('18177700116','announce-position','no',0),('18177700117','member','Agent/2007,0',7),('18177700117','member','Agent/2003,0',3),('18177700117','member','Agent/2004,0',4),('18177700117','periodic-announce-frequency','0',0),('18177700117','monitor-format','',0),('18177700117','monitor-join','yes',0),('18177700117','eventwhencalled','no',0),('18177700117','eventmemberstatus','no',0),('18177700117','weight','0',0),('18177700117','autofill','no',0),('18177700117','ringinuse','yes',0),('18177700117','reportholdtime','no',0),('18177700117','autopause','no',0),('18177700117','autopausedelay','0',0),('18177700117','servicelevel','60',0),('18177700117','memberdelay','0',0),('18177700117','timeoutrestart','no',0),('18177700117','skip_joinannounce','',0),('18177700117','cron_schedule','never',0),('18177700117','autopausebusy','no',0),('18177700117','autopauseunavail','no',0),('18177700117','timeoutpriority','app',0),('18177700117','penaltymemberslimit','0',0),('18177700117','answered_elsewhere','0',0),('18177700117','member','Agent/2000,0',0),('18177700117','member','Agent/2001,0',1),('18177700117','member','Agent/2002,0',2),('18177700117','maxlen','0',0),('18177700117','joinempty','yes',0),('18177700117','leavewhenempty','no',0),('18177700117','strategy','random',0),('18177700118','autopausedelay','0',0),('18177700118','servicelevel','60',0),('18177700118','memberdelay','0',0),('18177700118','timeoutrestart','no',0),('18177700118','skip_joinannounce','',0),('18177700118','cron_schedule','never',0),('18177700118','autopausebusy','no',0),('18177700118','autopauseunavail','no',0),('18177700118','timeoutpriority','app',0),('18177700118','penaltymemberslimit','0',0),('18177700118','answered_elsewhere','0',0),('18177700118','member','Agent/2000,0',0),('18177700118','member','Agent/2001,0',1),('18177700118','queue-thankyou','',0),('18177700118','periodic-announce-frequency','0',0),('18177700118','monitor-format','',0),('18177700118','monitor-join','yes',0),('18177700118','queue-youarenext','silence/1',0),('18177700118','queue-thereare','silence/1',0),('18177700118','queue-callswaiting','silence/1',0),('18177700118','maxlen','0',0),('18177700118','joinempty','yes',0),('18177700118','leavewhenempty','no',0),('18177700118','strategy','random',0),('18177700118','timeout','0',0),('18177700118','retry','5',0),('18177700118','wrapuptime','0',0),('18177700118','announce-frequency','0',0),('18177700118','announce-holdtime','no',0),('18177700118','announce-position','no',0),('18177700119','servicelevel','60',0),('18177700119','memberdelay','0',0),('18177700119','timeoutrestart','no',0),('18177700119','skip_joinannounce','',0),('18177700119','cron_schedule','never',0),('18177700119','autopausebusy','no',0),('18177700119','autopauseunavail','no',0),('18177700119','timeoutpriority','app',0),('18177700119','penaltymemberslimit','0',0),('18177700119','answered_elsewhere','0',0),('18177700119','member','Agent/2000,0',0),('18177700119','member','Agent/2001,0',1),('18177700119','member','Agent/2002,0',2),('18177700119','queue-callswaiting','silence/1',0),('18177700119','queue-thankyou','',0),('18177700119','periodic-announce-frequency','0',0),('18177700119','monitor-format','',0),('18177700119','queue-youarenext','silence/1',0),('18177700119','queue-thereare','silence/1',0),('18177700119','autopause','no',0),('18177700119','autopausedelay','0',0),('18177700119','maxlen','0',0),('18177700119','joinempty','yes',0),('18177700119','leavewhenempty','no',0),('18177700119','strategy','random',0),('18177700119','timeout','0',0),('18177700119','retry','5',0),('18177700119','wrapuptime','0',0),('18177700119','announce-frequency','0',0),('18177700119','announce-holdtime','no',0),('18177700119','announce-position','no',0),('18147773894','joinempty','yes',0),('18177700120','member','Agent/2000,0',0),('18177700120','member','Agent/2001,0',1),('18177700120','queue-thereare','silence/1',0),('18177700120','queue-callswaiting','silence/1',0),('18177700120','queue-thankyou','',0),('18177700120','periodic-announce-frequency','0',0),('18177700120','monitor-format','',0),('18177700120','monitor-join','yes',0),('18177700120','eventwhencalled','no',0),('18177700120','eventmemberstatus','no',0),('18177700120','weight','0',0),('18177700120','autofill','no',0),('18177700120','ringinuse','yes',0),('18177700120','reportholdtime','no',0),('18177700120','autopause','no',0),('18177700120','autopausedelay','0',0),('18177700120','servicelevel','60',0),('18177700120','memberdelay','0',0),('18177700120','timeoutrestart','no',0),('18177700120','skip_joinannounce','',0),('18177700120','cron_schedule','never',0),('18177700120','autopausebusy','no',0),('18177700120','autopauseunavail','no',0),('18177700120','timeoutpriority','app',0),('18177700120','penaltymemberslimit','0',0),('18177700120','answered_elsewhere','0',0),('18177700120','maxlen','0',0),('18177700120','joinempty','yes',0),('18177700120','leavewhenempty','no',0),('18177700120','strategy','random',0),('18177700121','member','Agent/2007,0',7),('18177700121','member','Agent/2003,0',3),('18177700121','member','Agent/2004,0',4),('18177700121','periodic-announce-frequency','0',0),('18177700121','monitor-format','',0),('18177700121','monitor-join','yes',0),('18177700121','eventwhencalled','no',0),('18177700121','eventmemberstatus','no',0),('18177700121','weight','0',0),('18177700121','autofill','no',0),('18177700121','ringinuse','yes',0),('18177700121','reportholdtime','no',0),('18177700121','autopause','no',0),('18177700121','autopausedelay','0',0),('18177700121','servicelevel','60',0),('18177700121','memberdelay','0',0),('18177700121','timeoutrestart','no',0),('18177700121','skip_joinannounce','',0),('18177700121','cron_schedule','never',0),('18177700121','autopausebusy','no',0),('18177700121','autopauseunavail','no',0),('18177700121','timeoutpriority','app',0),('18177700121','penaltymemberslimit','0',0),('18177700121','answered_elsewhere','0',0),('18177700121','member','Agent/2000,0',0),('18177700121','member','Agent/2001,0',1),('18177700121','member','Agent/2002,0',2),('18177700121','maxlen','0',0),('18177700121','joinempty','yes',0),('18177700121','leavewhenempty','no',0),('18177700121','strategy','random',0),('18177700122','autopausedelay','0',0),('18177700122','servicelevel','60',0),('18177700122','memberdelay','0',0),('18177700122','timeoutrestart','no',0),('18177700122','skip_joinannounce','',0),('18177700122','cron_schedule','never',0),('18177700122','autopausebusy','no',0),('18177700122','autopauseunavail','no',0),('18177700122','timeoutpriority','app',0),('18177700122','penaltymemberslimit','0',0),('18177700122','answered_elsewhere','0',0),('18177700122','member','Agent/2000,0',0),('18177700122','member','Agent/2001,0',1),('18177700122','queue-thankyou','',0),('18177700122','periodic-announce-frequency','0',0),('18177700122','monitor-format','',0),('18177700122','monitor-join','yes',0),('18177700122','queue-youarenext','silence/1',0),('18177700122','queue-thereare','silence/1',0),('18177700122','queue-callswaiting','silence/1',0),('18177700122','maxlen','0',0),('18177700122','joinempty','yes',0),('18177700122','leavewhenempty','no',0),('18177700122','strategy','random',0),('18177700122','timeout','0',0),('18177700122','retry','5',0),('18177700122','wrapuptime','0',0),('18177700122','announce-frequency','0',0),('18177700122','announce-holdtime','no',0),('18177700122','announce-position','no',0),('18177700123','autopausedelay','0',0),('18177700123','servicelevel','60',0),('18177700123','memberdelay','0',0),('18177700123','timeoutrestart','no',0),('18177700123','skip_joinannounce','',0),('18177700123','cron_schedule','never',0),('18177700123','autopausebusy','no',0),('18177700123','autopauseunavail','no',0),('18177700123','timeoutpriority','app',0),('18177700123','penaltymemberslimit','0',0),('18177700123','answered_elsewhere','0',0),('18177700123','member','Agent/2000,0',0),('18177700123','member','Agent/2001,0',1),('18177700123','queue-thankyou','',0),('18177700123','periodic-announce-frequency','0',0),('18177700123','monitor-format','',0),('18177700123','monitor-join','yes',0),('18177700123','queue-youarenext','silence/1',0),('18177700123','queue-thereare','silence/1',0),('18177700123','queue-callswaiting','silence/1',0),('18177700123','maxlen','0',0),('18177700123','joinempty','yes',0),('18177700123','leavewhenempty','no',0),('18177700123','strategy','random',0),('18177700123','timeout','0',0),('18177700123','retry','5',0),('18177700123','wrapuptime','0',0),('18177700123','announce-frequency','0',0),('18177700123','announce-holdtime','no',0),('18177700123','announce-position','no',0),('19847770192','member','Agent/2005,0',5),('19847770192','queue-callswaiting','silence/1',0),('19847770191','member','Agent/2008,0',8),('19847770191','skip_joinannounce','',0),('19847770191','reportholdtime','no',0),('19847770192','monitor-format','',0),('19847770192','monitor-join','yes',0),('19847770192','eventwhencalled','no',0),('19847770192','eventmemberstatus','no',0),('19847770192','weight','0',0),('19847770192','autofill','no',0),('19847770192','ringinuse','yes',0),('19847770192','reportholdtime','no',0),('19847770192','autopause','no',0),('19847770192','autopausedelay','0',0),('19847770192','servicelevel','60',0),('19847770192','maxlen','0',0),('19847770192','joinempty','yes',0),('19847770192','leavewhenempty','no',0),('19847770192','strategy','random',0),('19847770192','timeout','0',0),('19847770192','retry','5',0),('19847770192','wrapuptime','0',0),('19847770192','announce-frequency','0',0),('19847770192','announce-holdtime','no',0),('19847770192','announce-position','no',0),('19847770192','queue-youarenext','silence/1',0),('19847770192','queue-thereare','silence/1',0),('19847770191','penaltymemberslimit','0',0),('19847770192','member','Agent/2007,0',7),('19847770192','member','Agent/2004,0',4),('19847770192','skip_joinannounce','',0),('19847770192','cron_schedule','never',0),('19847770192','autopausebusy','no',0),('19847770192','autopauseunavail','no',0),('19847770192','memberdelay','0',0),('19847770192','timeoutrestart','no',0),('19847770192','queue-thankyou','',0),('19847770192','periodic-announce-frequency','0',0),('18177700124','autopausedelay','0',0),('18177700124','servicelevel','60',0),('18177700124','memberdelay','0',0),('18177700124','timeoutrestart','no',0),('18177700124','skip_joinannounce','',0),('18177700124','cron_schedule','never',0),('18177700124','autopausebusy','no',0),('18177700124','autopauseunavail','no',0),('18177700124','timeoutpriority','app',0),('18177700124','penaltymemberslimit','0',0),('18177700124','answered_elsewhere','0',0),('18177700124','member','Agent/2000,0',0),('18177700124','member','Agent/2001,0',1),('18177700124','queue-thankyou','',0),('18177700124','periodic-announce-frequency','0',0),('18177700124','monitor-format','',0),('18177700124','monitor-join','yes',0),('18177700124','queue-youarenext','silence/1',0),('18177700124','queue-thereare','silence/1',0),('18177700124','queue-callswaiting','silence/1',0),('18177700124','maxlen','0',0),('18177700124','joinempty','yes',0),('18177700124','leavewhenempty','no',0),('18177700124','strategy','random',0),('18177700124','timeout','0',0),('18177700124','retry','5',0),('18177700124','wrapuptime','0',0),('18177700124','announce-frequency','0',0),('18177700124','announce-holdtime','no',0),('18177700124','announce-position','no',0),('18147370235','member','Agent/2000,0',0),('18147370235','member','Agent/2001,0',1),('18147370235','queue-thereare','silence/1',0),('18147370235','queue-callswaiting','silence/1',0),('18147370235','queue-thankyou','',0),('18147370235','periodic-announce-frequency','0',0),('18147370235','monitor-format','',0),('18147370235','monitor-join','yes',0),('18147370235','eventwhencalled','no',0),('18147370235','eventmemberstatus','no',0),('18147370235','weight','0',0),('18147370235','autofill','no',0),('18147370235','ringinuse','yes',0),('18147370235','reportholdtime','no',0),('18147370235','autopause','no',0),('18147370235','autopausedelay','0',0),('18147370235','servicelevel','60',0),('18147370235','memberdelay','0',0),('18147370235','timeoutrestart','no',0),('18147370235','skip_joinannounce','',0),('18147370235','cron_schedule','never',0),('18147370235','autopausebusy','no',0),('18147370235','autopauseunavail','no',0),('18147370235','timeoutpriority','app',0),('18147370235','penaltymemberslimit','0',0),('18147370235','answered_elsewhere','0',0),('18147370235','maxlen','0',0),('18147370235','joinempty','yes',0),('18147370235','leavewhenempty','no',0),('18147370235','strategy','random',0),('18177700699','member','Agent/2006,0',5),('12226443774','member','Agent/2000,0',0),('12226443774','member','Agent/2001,0',1),('12226443774','queue-thereare','silence/1',0),('12226443774','queue-callswaiting','silence/1',0),('12226443774','queue-thankyou','',0),('12226443774','periodic-announce-frequency','0',0),('12226443774','monitor-format','',0),('12226443774','monitor-join','yes',0),('12226443774','eventwhencalled','no',0),('12226443774','eventmemberstatus','no',0),('12226443774','weight','0',0),('12226443774','autofill','no',0),('12226443774','ringinuse','yes',0),('12226443774','reportholdtime','no',0),('12226443774','autopause','no',0),('12226443774','autopausedelay','0',0),('12226443774','servicelevel','60',0),('12226443774','memberdelay','0',0),('12226443774','timeoutrestart','no',0),('12226443774','skip_joinannounce','',0),('12226443774','cron_schedule','never',0),('12226443774','autopausebusy','no',0),('12226443774','autopauseunavail','no',0),('12226443774','timeoutpriority','app',0),('12226443774','penaltymemberslimit','0',0),('12226443774','answered_elsewhere','0',0),('12226443774','maxlen','0',0),('12226443774','joinempty','yes',0),('12226443774','leavewhenempty','no',0),('12226443774','strategy','random',0),('18177700360','autopausedelay','0',0),('18177700360','servicelevel','60',0),('18177700360','memberdelay','0',0),('18177700360','timeoutrestart','no',0),('18177700360','skip_joinannounce','',0),('18177700360','cron_schedule','never',0),('18177700360','autopausebusy','no',0),('18177700360','autopauseunavail','no',0),('18177700360','timeoutpriority','app',0),('18177700360','penaltymemberslimit','0',0),('18177700360','answered_elsewhere','0',0),('18177700360','member','Agent/2000,0',0),('18177700360','member','Agent/2001,0',1),('18177700360','queue-thankyou','',0),('18177700360','periodic-announce-frequency','0',0),('18177700360','monitor-format','',0),('18177700360','monitor-join','yes',0),('18177700360','queue-youarenext','silence/1',0),('18177700360','queue-thereare','silence/1',0),('18177700360','queue-callswaiting','silence/1',0),('18177700360','maxlen','0',0),('18177700360','joinempty','yes',0),('18177700360','leavewhenempty','no',0),('18177700360','strategy','random',0),('18177700360','timeout','0',0),('18177700360','retry','5',0),('18177700360','wrapuptime','0',0),('18177700360','announce-frequency','0',0),('18177700360','announce-holdtime','no',0),('18177700360','announce-position','no',0),('18177700361','autopausedelay','0',0),('18177700361','servicelevel','60',0),('18177700361','memberdelay','0',0),('18177700361','timeoutrestart','no',0),('18177700361','skip_joinannounce','',0),('18177700361','cron_schedule','never',0),('18177700361','autopausebusy','no',0),('18177700361','autopauseunavail','no',0),('18177700361','timeoutpriority','app',0),('18177700361','penaltymemberslimit','0',0),('18177700361','answered_elsewhere','0',0),('18177700361','member','Agent/2000,0',0),('18177700361','member','Agent/2001,0',1),('18177700361','queue-thankyou','',0),('18177700361','periodic-announce-frequency','0',0),('18177700361','monitor-format','',0),('18177700361','monitor-join','yes',0),('18177700361','queue-youarenext','silence/1',0),('18177700361','queue-thereare','silence/1',0),('18177700361','queue-callswaiting','silence/1',0),('18177700361','maxlen','0',0),('18177700361','joinempty','yes',0),('18177700361','leavewhenempty','no',0),('18177700361','strategy','random',0),('18177700361','timeout','0',0),('18177700361','retry','5',0),('18177700361','wrapuptime','0',0),('18177700361','announce-frequency','0',0),('18177700361','announce-holdtime','no',0),('18177700361','announce-position','no',0),('18177700362','member','Agent/2004,0',4),('18177700362','member','Agent/2000,0',0),('18177700362','member','Agent/2001,0',1),('18177700362','member','Agent/2002,0',2),('18177700362','member','Agent/2003,0',3),('18177700362','queue-thereare','silence/1',0),('18177700362','queue-callswaiting','silence/1',0),('18177700362','queue-thankyou','',0),('18177700362','periodic-announce-frequency','0',0),('18177700362','monitor-format','',0),('18177700362','monitor-join','yes',0),('18177700362','eventwhencalled','no',0),('18177700362','eventmemberstatus','no',0),('18177700362','weight','0',0),('18177700362','autofill','no',0),('18177700362','ringinuse','yes',0),('18177700362','reportholdtime','no',0),('18177700362','autopause','no',0),('18177700362','autopausedelay','0',0),('18177700362','servicelevel','60',0),('18177700362','memberdelay','0',0),('18177700362','leavewhenempty','no',0),('18177700362','strategy','random',0),('18177700362','timeout','0',0),('18177700362','retry','5',0),('18177700362','wrapuptime','0',0),('18177700362','announce-frequency','0',0),('18177700362','announce-holdtime','no',0),('18177700362','announce-position','no',0),('18177700362','queue-youarenext','silence/1',0),('18177700363','autopausedelay','0',0),('18177700363','servicelevel','60',0),('18177700363','memberdelay','0',0),('18177700363','timeoutrestart','no',0),('18177700363','skip_joinannounce','',0),('18177700363','cron_schedule','never',0),('18177700363','autopausebusy','no',0),('18177700363','autopauseunavail','no',0),('18177700363','timeoutpriority','app',0),('18177700363','penaltymemberslimit','0',0),('18177700363','answered_elsewhere','0',0),('18177700363','member','Agent/2000,0',0),('18177700363','member','Agent/2001,0',1),('18177700363','queue-thankyou','',0),('18177700363','periodic-announce-frequency','0',0),('18177700363','monitor-format','',0),('18177700363','monitor-join','yes',0),('18177700363','queue-youarenext','silence/1',0),('18177700363','queue-thereare','silence/1',0),('18177700363','queue-callswaiting','silence/1',0),('18177700363','maxlen','0',0),('18177700363','joinempty','yes',0),('18177700363','leavewhenempty','no',0),('18177700363','strategy','random',0),('18177700363','timeout','0',0),('18177700363','retry','5',0),('18177700363','wrapuptime','0',0),('18177700363','announce-frequency','0',0),('18177700363','announce-holdtime','no',0),('18177700363','announce-position','no',0),('18177700376','member','Agent/2001,0',1),('18177700376','member','Agent/2002,0',2),('18177700376','autopausedelay','0',0),('18177700376','servicelevel','60',0),('18177700376','memberdelay','0',0),('18177700376','timeoutrestart','no',0),('18177700376','skip_joinannounce','',0),('18177700376','cron_schedule','never',0),('18177700376','autopausebusy','no',0),('18177700376','autopauseunavail','no',0),('18177700376','timeoutpriority','app',0),('18177700376','penaltymemberslimit','0',0),('18177700376','timeout','0',0),('18177700376','retry','5',0),('18177700376','wrapuptime','0',0),('18177700376','announce-frequency','0',0),('18177700376','announce-holdtime','no',0),('18177700376','announce-position','no',0),('18177700376','queue-youarenext','silence/1',0),('18177700376','queue-thereare','silence/1',0),('18177700376','queue-callswaiting','silence/1',0),('18177700376','queue-thankyou','',0),('18177700376','periodic-announce-frequency','0',0),('18177700376','monitor-format','',0),('18177700376','monitor-join','yes',0),('18177700376','eventwhencalled','no',0),('18177700376','eventmemberstatus','no',0),('18177700376','weight','0',0),('18177700376','autofill','no',0),('18177700376','ringinuse','yes',0),('18177700365','member','Agent/2006,0',6),('18177700365','ringinuse','yes',0),('18177700365','reportholdtime','no',0),('18177700365','autopause','no',0),('18177700365','autopausedelay','0',0),('18177700365','servicelevel','60',0),('18177700365','memberdelay','0',0),('18177700365','timeoutrestart','no',0),('18177700365','skip_joinannounce','',0),('18177700365','cron_schedule','never',0),('18177700365','autopausebusy','no',0),('18177700365','autopauseunavail','no',0),('18177700365','timeoutpriority','app',0),('18177700365','penaltymemberslimit','0',0),('18177700365','answered_elsewhere','0',0),('18177700365','member','Agent/2000,0',0),('18177700365','announce-frequency','0',0),('18177700365','announce-holdtime','no',0),('18177700365','announce-position','no',0),('18177700365','queue-youarenext','silence/1',0),('18177700365','queue-thereare','silence/1',0),('18177700365','queue-callswaiting','silence/1',0),('18177700365','queue-thankyou','',0),('18177700365','periodic-announce-frequency','0',0),('18177700365','monitor-format','',0),('18177700365','monitor-join','yes',0),('18177700365','eventwhencalled','no',0),('18177700365','eventmemberstatus','no',0),('18177700365','weight','0',0),('18177700365','autofill','no',0),('18177700366','autopausedelay','0',0),('18177700366','servicelevel','60',0),('18177700366','memberdelay','0',0),('18177700366','timeoutrestart','no',0),('18177700366','skip_joinannounce','',0),('18177700366','cron_schedule','never',0),('18177700366','autopausebusy','no',0),('18177700366','autopauseunavail','no',0),('18177700366','timeoutpriority','app',0),('18177700366','penaltymemberslimit','0',0),('18177700366','answered_elsewhere','0',0),('18177700366','member','Agent/2000,0',0),('18177700366','member','Agent/2001,0',1),('18177700366','queue-thankyou','',0),('18177700366','periodic-announce-frequency','0',0),('18177700366','monitor-format','',0),('18177700366','monitor-join','yes',0),('18177700366','queue-youarenext','silence/1',0),('18177700366','queue-thereare','silence/1',0),('18177700366','queue-callswaiting','silence/1',0),('18177700366','maxlen','0',0),('18177700366','joinempty','yes',0),('18177700366','leavewhenempty','no',0),('18177700366','strategy','random',0),('18177700366','timeout','0',0),('18177700366','retry','5',0),('18177700366','wrapuptime','0',0),('18177700366','announce-frequency','0',0),('18177700366','announce-holdtime','no',0),('18177700366','announce-position','no',0),('18177700367','autopausedelay','0',0),('18177700367','servicelevel','60',0),('18177700367','memberdelay','0',0),('18177700367','timeoutrestart','no',0),('18177700367','skip_joinannounce','',0),('18177700367','cron_schedule','never',0),('18177700367','autopausebusy','no',0),('18177700367','autopauseunavail','no',0),('18177700367','timeoutpriority','app',0),('18177700367','penaltymemberslimit','0',0),('18177700367','answered_elsewhere','0',0),('18177700367','member','Agent/2000,0',0),('18177700367','member','Agent/2001,0',1),('18177700367','queue-thankyou','',0),('18177700367','periodic-announce-frequency','0',0),('18177700367','monitor-format','',0),('18177700367','monitor-join','yes',0),('18177700367','queue-youarenext','silence/1',0),('18177700367','queue-thereare','silence/1',0),('18177700367','queue-callswaiting','silence/1',0),('18177700367','maxlen','0',0),('18177700367','joinempty','yes',0),('18177700367','leavewhenempty','no',0),('18177700367','strategy','random',0),('18177700367','timeout','0',0),('18177700367','retry','5',0),('18177700367','wrapuptime','0',0),('18177700367','announce-frequency','0',0),('18177700367','announce-holdtime','no',0),('18177700367','announce-position','no',0),('18177700368','autopausedelay','0',0),('18177700368','servicelevel','60',0),('18177700368','memberdelay','0',0),('18177700368','timeoutrestart','no',0),('18177700368','skip_joinannounce','',0),('18177700368','cron_schedule','never',0),('18177700368','autopausebusy','no',0),('18177700368','autopauseunavail','no',0),('18177700368','timeoutpriority','app',0),('18177700368','penaltymemberslimit','0',0),('18177700368','answered_elsewhere','0',0),('18177700368','member','Agent/2000,0',0),('18177700368','member','Agent/2001,0',1),('18177700368','queue-thankyou','',0),('18177700368','periodic-announce-frequency','0',0),('18177700368','monitor-format','',0),('18177700368','monitor-join','yes',0),('18177700368','queue-youarenext','silence/1',0),('18177700368','queue-thereare','silence/1',0),('18177700368','queue-callswaiting','silence/1',0),('18177700368','maxlen','0',0),('18177700368','joinempty','yes',0),('18177700368','leavewhenempty','no',0),('18177700368','strategy','random',0),('18177700368','timeout','0',0),('18177700368','retry','5',0),('18177700368','wrapuptime','0',0),('18177700368','announce-frequency','0',0),('18177700368','announce-holdtime','no',0),('18177700368','announce-position','no',0),('18177700369','member','Agent/2001,0',1),('18177700369','member','Agent/2002,0',2),('18177700369','member','Agent/2003,0',3),('18177700369','member','Agent/2004,0',4),('18177700369','member','Agent/2005,0',5),('18177700369','member','Agent/2006,0',6),('18177700369','member','Agent/2007,0',7),('18177700369','skip_joinannounce','',0),('18177700369','cron_schedule','never',0),('18177700369','autopausebusy','no',0),('18177700369','autopauseunavail','no',0),('18177700369','servicelevel','60',0),('18177700369','memberdelay','0',0),('18177700369','timeoutrestart','no',0),('18177700369','autopausedelay','0',0),('18177700369','reportholdtime','no',0),('18177700369','autopause','no',0),('18177700369','maxlen','0',0),('18177700369','joinempty','yes',0),('18177700369','leavewhenempty','no',0),('18177700369','strategy','random',0),('18177700369','timeout','0',0),('18177700369','retry','5',0),('18177700369','wrapuptime','0',0),('18177700369','announce-frequency','0',0),('18177700369','announce-holdtime','no',0),('18177700369','announce-position','no',0),('18177700369','queue-youarenext','silence/1',0),('18177700369','queue-thereare','silence/1',0),('18177700369','queue-callswaiting','silence/1',0),('18177700369','queue-thankyou','',0),('18177700369','periodic-announce-frequency','0',0),('18177700371','autopausedelay','0',0),('18177700371','servicelevel','60',0),('18177700371','memberdelay','0',0),('18177700371','timeoutrestart','no',0),('18177700371','skip_joinannounce','',0),('18177700371','cron_schedule','never',0),('18177700371','autopausebusy','no',0),('18177700371','autopauseunavail','no',0),('18177700371','timeoutpriority','app',0),('18177700371','penaltymemberslimit','0',0),('18177700371','answered_elsewhere','0',0),('18177700371','member','Agent/2000,0',0),('18177700371','member','Agent/2001,0',1),('18177700371','queue-thankyou','',0),('18177700371','periodic-announce-frequency','0',0),('18177700371','monitor-format','',0),('18177700371','monitor-join','yes',0),('18177700371','queue-youarenext','silence/1',0),('18177700371','queue-thereare','silence/1',0),('18177700371','queue-callswaiting','silence/1',0),('18177700371','maxlen','0',0),('18177700371','joinempty','yes',0),('18177700371','leavewhenempty','no',0),('18177700371','strategy','random',0),('18177700371','timeout','0',0),('18177700371','retry','5',0),('18177700371','wrapuptime','0',0),('18177700371','announce-frequency','0',0),('18177700371','announce-holdtime','no',0),('18177700371','announce-position','no',0),('18177700372','member','Agent/2001,0',1),('18177700372','member','Agent/2002,0',2),('18177700372','member','Agent/2003,0',3),('18177700372','autopauseunavail','no',0),('18177700372','servicelevel','60',0),('18177700372','memberdelay','0',0),('18177700372','timeoutrestart','no',0),('18177700372','skip_joinannounce','',0),('18177700372','cron_schedule','never',0),('18177700372','autopausebusy','no',0),('18177700372','wrapuptime','0',0),('18177700372','announce-frequency','0',0),('18177700372','announce-holdtime','no',0),('18177700372','announce-position','no',0),('18177700372','queue-youarenext','silence/1',0),('18177700372','queue-thereare','silence/1',0),('18177700372','queue-callswaiting','silence/1',0),('18177700372','queue-thankyou','',0),('18177700372','periodic-announce-frequency','0',0),('18177700372','maxlen','0',0),('18177700372','joinempty','yes',0),('18177700372','leavewhenempty','no',0),('18177700372','strategy','random',0),('18177700372','timeout','0',0),('18177700372','retry','5',0),('18177700373','autopausedelay','0',0),('18177700373','servicelevel','60',0),('18177700373','memberdelay','0',0),('18177700373','timeoutrestart','no',0),('18177700373','skip_joinannounce','',0),('18177700373','cron_schedule','never',0),('18177700373','autopausebusy','no',0),('18177700373','autopauseunavail','no',0),('18177700373','timeoutpriority','app',0),('18177700373','penaltymemberslimit','0',0),('18177700373','answered_elsewhere','0',0),('18177700373','member','Agent/2000,0',0),('18177700373','member','Agent/2001,0',1),('18177700373','queue-thankyou','',0),('18177700373','periodic-announce-frequency','0',0),('18177700373','monitor-format','',0),('18177700373','monitor-join','yes',0),('18177700373','queue-youarenext','silence/1',0),('18177700373','queue-thereare','silence/1',0),('18177700373','queue-callswaiting','silence/1',0),('18177700373','maxlen','0',0),('18177700373','joinempty','yes',0),('18177700373','leavewhenempty','no',0),('18177700373','strategy','random',0),('18177700373','timeout','0',0),('18177700373','retry','5',0),('18177700373','wrapuptime','0',0),('18177700373','announce-frequency','0',0),('18177700373','announce-holdtime','no',0),('18177700373','announce-position','no',0),('18177700374','autopausedelay','0',0),('18177700374','servicelevel','60',0),('18177700374','memberdelay','0',0),('18177700374','timeoutrestart','no',0),('18177700374','skip_joinannounce','',0),('18177700374','cron_schedule','never',0),('18177700374','autopausebusy','no',0),('18177700374','autopauseunavail','no',0),('18177700374','timeoutpriority','app',0),('18177700374','penaltymemberslimit','0',0),('18177700374','answered_elsewhere','0',0),('18177700374','member','Agent/2000,0',0),('18177700374','member','Agent/2001,0',1),('18177700374','queue-thankyou','',0),('18177700374','periodic-announce-frequency','0',0),('18177700374','monitor-format','',0),('18177700374','monitor-join','yes',0),('18177700374','queue-youarenext','silence/1',0),('18177700374','queue-thereare','silence/1',0),('18177700374','queue-callswaiting','silence/1',0),('18177700374','maxlen','0',0),('18177700374','joinempty','yes',0),('18177700374','leavewhenempty','no',0),('18177700374','strategy','random',0),('18177700374','timeout','0',0),('18177700374','retry','5',0),('18177700374','wrapuptime','0',0),('18177700374','announce-frequency','0',0),('18177700374','announce-holdtime','no',0),('18177700374','announce-position','no',0),('18177700375','autopausedelay','0',0),('18177700375','servicelevel','60',0),('18177700375','memberdelay','0',0),('18177700375','timeoutrestart','no',0),('18177700375','skip_joinannounce','',0),('18177700375','cron_schedule','never',0),('18177700375','autopausebusy','no',0),('18177700375','autopauseunavail','no',0),('18177700375','timeoutpriority','app',0),('18177700375','penaltymemberslimit','0',0),('18177700375','answered_elsewhere','0',0),('18177700375','member','Agent/2000,0',0),('18177700375','member','Agent/2001,0',1),('18177700375','queue-thankyou','',0),('18177700375','periodic-announce-frequency','0',0),('18177700375','monitor-format','',0),('18177700375','monitor-join','yes',0),('18177700375','queue-youarenext','silence/1',0),('18177700375','queue-thereare','silence/1',0),('18177700375','queue-callswaiting','silence/1',0),('18177700375','maxlen','0',0),('18177700375','joinempty','yes',0),('18177700375','leavewhenempty','no',0),('18177700375','strategy','random',0),('18177700375','timeout','0',0),('18177700375','retry','5',0),('18177700375','wrapuptime','0',0),('18177700375','announce-frequency','0',0),('18177700375','announce-holdtime','no',0),('18177700375','announce-position','no',0),('18177700370','member','Agent/2007,0',7),('18177700370','member','Agent/2008,0',8),('18177700370','timeoutpriority','app',0),('18177700370','penaltymemberslimit','0',0),('18177700370','answered_elsewhere','0',0),('18177700370','member','Agent/2000,0',0),('18177700370','member','Agent/2001,0',1),('18177700370','autofill','no',0),('18177700370','ringinuse','yes',0),('18177700370','reportholdtime','no',0),('18177700370','autopause','no',0),('18177700370','autopausedelay','0',0),('18177700370','servicelevel','60',0),('18177700370','announce-frequency','0',0),('18177700370','announce-holdtime','no',0),('18177700370','announce-position','no',0),('18177700370','queue-youarenext','silence/1',0),('18177700370','queue-thereare','silence/1',0),('18177700370','queue-callswaiting','silence/1',0),('18177700370','queue-thankyou','',0),('18177700370','periodic-announce-frequency','0',0),('18177700370','monitor-format','',0),('18177700370','monitor-join','yes',0),('18177700370','eventwhencalled','no',0),('18177700370','eventmemberstatus','no',0),('18177700370','maxlen','0',0),('18177700370','joinempty','yes',0),('18177700370','leavewhenempty','no',0),('18177700370','strategy','random',0),('18177700370','timeout','0',0),('18177700370','retry','5',0),('18177700370','wrapuptime','0',0),('18147370216','answered_elsewhere','0',0),('18147370216','member','Agent/2000,0',0),('18147370216','leavewhenempty','no',0),('18147370216','strategy','random',0),('18147370216','timeout','0',0),('18147370216','retry','5',0),('18147370216','wrapuptime','0',0),('18147370216','announce-frequency','0',0),('18147370216','announce-holdtime','no',0),('18147370216','announce-position','no',0),('18147370216','queue-youarenext','silence/1',0),('18147370216','queue-thereare','silence/1',0),('18177700362','cron_schedule','never',0),('18177700362','autopausebusy','no',0),('18177700362','autopauseunavail','no',0),('18177700362','timeoutpriority','app',0),('18177700362','penaltymemberslimit','0',0),('18177700362','answered_elsewhere','0',0),('18177700362','timeoutrestart','no',0),('18177700362','skip_joinannounce','',0),('18177700362','maxlen','0',0),('18177700362','joinempty','yes',0),('18177700372','member','Agent/2000,0',0),('18177700372','penaltymemberslimit','0',0),('18177700372','answered_elsewhere','0',0),('18177700372','ringinuse','yes',0),('18177700372','reportholdtime','no',0),('18177700372','autopause','no',0),('18177700372','autopausedelay','0',0),('18177700372','monitor-format','',0),('18177700372','monitor-join','yes',0),('18177700372','eventwhencalled','no',0),('18177700372','eventmemberstatus','no',0),('18177700372','weight','0',0),('18177700372','autofill','no',0),('18177700376','member','Agent/2004,0',4),('18177700376','member','Agent/2003,0',3),('18177700376','reportholdtime','no',0),('18177700376','autopause','no',0),('18177700376','maxlen','0',0),('18177700376','joinempty','yes',0),('18177700376','leavewhenempty','no',0),('18177700376','strategy','random',0),('58177700100','member','Agent/2008,0',8),('58177700100','member','Agent/2005,0',5),('48177700100','member','Agent/2001,0',1),('18177702604','joinempty','yes',0),('58177700100','timeoutpriority','app',0),('48177700100','member','Agent/2006,0',6),('48177700100','member','Agent/2007,0',7),('58177700100','member','Agent/2002,0',2),('58177700100','member','Agent/2003,0',3),('58177700100','member','Agent/2004,0',4),('28177700100','member','Agent/2002,0',2),('48177700100','member','Agent/2002,0',2),('48177700100','member','Agent/2003,0',3),('48177700100','member','Agent/2004,0',4),('48177700100','member','Agent/2005,0',5),('28177700100','member','Agent/2006,0',6),('28177700100','member','Agent/2005,0',5),('28177700100','member','Agent/2004,0',4),('38177700100','penaltymemberslimit','0',0),('38177700100','answered_elsewhere','0',0),('38177700100','member','Agent/2000,0',0),('38177700100','member','Agent/2001,0',1),('38177700100','member','Agent/2002,0',2),('38177700100','member','Agent/2003,0',3),('38177700100','member','Agent/2004,0',4),('18177700369','monitor-format','',0),('18177700369','monitor-join','yes',0),('18177700369','eventwhencalled','no',0),('18177700369','eventmemberstatus','no',0),('18177700369','weight','0',0),('18177700369','autofill','no',0),('18177700369','ringinuse','yes',0),('18177700370','member','Agent/2009,0',9),('18177700370','skip_joinannounce','',0),('18177700370','cron_schedule','never',0),('18177700370','autopausebusy','no',0),('18177700370','autopauseunavail','no',0),('18177700370','memberdelay','0',0),('18177700370','timeoutrestart','no',0),('18177700370','weight','0',0),('18177700376','member','Agent/2005,0',5),('18177700376','member','Agent/2006,0',6),('18177700364','autopausedelay','0',0),('18177700364','servicelevel','60',0),('18177700364','memberdelay','0',0),('18177700364','timeoutrestart','no',0),('18177700364','skip_joinannounce','',0),('18177700364','cron_schedule','never',0),('18177700364','autopausebusy','no',0),('18177700364','autopauseunavail','no',0),('18177700364','timeoutpriority','app',0),('18177700364','penaltymemberslimit','0',0),('18177700364','answered_elsewhere','0',0),('18177700364','member','Agent/2000,0',0),('18177700364','member','Agent/2001,0',1),('18177700364','queue-thankyou','',0),('18177700364','periodic-announce-frequency','0',0),('18177700364','monitor-format','',0),('18177700364','monitor-join','yes',0),('18177700364','queue-youarenext','silence/1',0),('18177700364','queue-thereare','silence/1',0),('18177700364','queue-callswaiting','silence/1',0),('18177700364','maxlen','0',0),('18177700364','joinempty','yes',0),('18177700364','leavewhenempty','no',0),('18177700364','strategy','random',0),('18177700364','timeout','0',0),('18177700364','retry','5',0),('18177700364','wrapuptime','0',0),('18177700364','announce-frequency','0',0),('18177700364','announce-holdtime','no',0),('18177700364','announce-position','no',0),('18177700378','member','Agent/2000,0',0),('18177700378','member','Agent/2001,0',1),('18177700378','queue-thereare','silence/1',0),('18177700378','queue-callswaiting','silence/1',0),('18177700378','queue-thankyou','',0),('18177700378','periodic-announce-frequency','0',0),('18177700378','monitor-format','',0),('18177700378','monitor-join','yes',0),('18177700378','eventwhencalled','no',0),('18177700378','eventmemberstatus','no',0),('18177700378','weight','0',0),('18177700378','autofill','no',0),('18177700378','ringinuse','yes',0),('18177700378','reportholdtime','no',0),('18177700378','autopause','no',0),('18177700378','autopausedelay','0',0),('18177700378','servicelevel','60',0),('18177700378','memberdelay','0',0),('18177700378','timeoutrestart','no',0),('18177700378','skip_joinannounce','',0),('18177700378','cron_schedule','never',0),('18177700378','autopausebusy','no',0),('18177700378','autopauseunavail','no',0),('18177700378','timeoutpriority','app',0),('18177700378','penaltymemberslimit','0',0),('18177700378','answered_elsewhere','0',0),('18177700378','maxlen','0',0),('18177700378','joinempty','yes',0),('18177700378','leavewhenempty','no',0),('18177700378','strategy','random',0),('18147370221','reportholdtime','no',0),('18147370221','autopause','no',0),('18177700100','member','Agent/2007,0',7),('18177700380','member','Agent/2007,0',7),('18147370221','queue-thankyou','',0),('18147370221','periodic-announce-frequency','0',0),('18147370221','monitor-format','',0),('18147370221','monitor-join','yes',0),('18147370221','eventwhencalled','no',0),('18147370221','eventmemberstatus','no',0),('18147370221','weight','0',0),('18147370221','autofill','no',0),('18147370221','ringinuse','yes',0),('18177700380','timeoutpriority','app',0),('18177700101','member','Agent/2009,0',9),('18177700100','member','Agent/2008,0',8),('18177700100','member','Agent/2009,0',9),('15588804685','maxlen','0',0),('18177700380','member','Agent/2003,0',3),('18177700380','member','Agent/2004,0',4),('18177700380','member','Agent/2005,0',5),('18177700380','member','Agent/2006,0',6),('18177700380','autopausebusy','no',0),('18177700380','queue-thankyou','',0),('18177700100','skip_joinannounce','',0),('18177700100','cron_schedule','never',0),('18177700100','autopausebusy','no',0),('18177700380','penaltymemberslimit','0',0),('18177700380','eventmemberstatus','no',0),('18177700380','weight','0',0),('18177700380','autofill','no',0),('18177700380','ringinuse','yes',0),('18177700380','reportholdtime','no',0),('18177700380','autopause','no',0),('18177700380','autopausedelay','0',0),('18177700380','servicelevel','60',0),('18177700380','memberdelay','0',0),('18177700380','timeoutrestart','no',0),('18177700380','skip_joinannounce','',0),('18177700380','cron_schedule','never',0),('18177700380','monitor-format','',0),('18177700380','monitor-join','yes',0),('18177700100','timeoutpriority','app',0),('18177700100','penaltymemberslimit','0',0),('18177700100','timeout','0',0),('18177700100','retry','5',0),('18177700100','wrapuptime','0',0),('18177700100','announce-frequency','0',0),('18177700100','announce-holdtime','no',0),('18177700100','announce-position','no',0),('18177700100','queue-youarenext','silence/1',0),('18177700100','queue-thereare','silence/1',0),('18177700100','queue-callswaiting','silence/1',0),('18177700100','queue-thankyou','',0),('18177700100','maxlen','0',0),('18177700100','joinempty','yes',0),('18177700100','leavewhenempty','no',0),('18177700100','strategy','random',0),('18177700381','autopausedelay','0',0),('18177700381','servicelevel','60',0),('18177700381','memberdelay','0',0),('18177700381','timeoutrestart','no',0),('18177700381','skip_joinannounce','',0),('18177700381','cron_schedule','never',0),('18177700381','autopausebusy','no',0),('18177700381','autopauseunavail','no',0),('18177700381','timeoutpriority','app',0),('18177700381','penaltymemberslimit','0',0),('18177700381','answered_elsewhere','0',0),('18177700381','member','Agent/2000,0',0),('18177700381','member','Agent/2001,0',1),('18177700381','queue-thankyou','',0),('18177700381','periodic-announce-frequency','0',0),('18177700381','monitor-format','',0),('18177700381','monitor-join','yes',0),('18177700381','queue-youarenext','silence/1',0),('18177700381','queue-thereare','silence/1',0),('18177700381','queue-callswaiting','silence/1',0),('18177700381','maxlen','0',0),('18177700381','joinempty','yes',0),('18177700381','leavewhenempty','no',0),('18177700381','strategy','random',0),('18177700381','timeout','0',0),('18177700381','retry','5',0),('18177700381','wrapuptime','0',0),('18177700381','announce-frequency','0',0),('18177700381','announce-holdtime','no',0),('18177700381','announce-position','no',0),('18177700382','autopausedelay','0',0),('18177700382','servicelevel','60',0),('18177700382','memberdelay','0',0),('18177700382','timeoutrestart','no',0),('18177700382','skip_joinannounce','',0),('18177700382','cron_schedule','never',0),('18177700382','autopausebusy','no',0),('18177700382','autopauseunavail','no',0),('18177700382','timeoutpriority','app',0),('18177700382','penaltymemberslimit','0',0),('18177700382','answered_elsewhere','0',0),('18177700382','member','Agent/2000,0',0),('18177700382','member','Agent/2001,0',1),('18177700382','queue-thankyou','',0),('18177700382','periodic-announce-frequency','0',0),('18177700382','monitor-format','',0),('18177700382','monitor-join','yes',0),('18177700382','queue-youarenext','silence/1',0),('18177700382','queue-thereare','silence/1',0),('18177700382','queue-callswaiting','silence/1',0),('18177700382','maxlen','0',0),('18177700382','joinempty','yes',0),('18177700382','leavewhenempty','no',0),('18177700382','strategy','random',0),('18177700382','timeout','0',0),('18177700382','retry','5',0),('18177700382','wrapuptime','0',0),('18177700382','announce-frequency','0',0),('18177700382','announce-holdtime','no',0),('18177700382','announce-position','no',0),('18177700383','member','Agent/2007,0',7),('18177700383','member','Agent/2003,0',3),('18177700383','member','Agent/2004,0',4),('18177700383','periodic-announce-frequency','0',0),('18177700383','monitor-format','',0),('18177700383','monitor-join','yes',0),('18177700383','eventwhencalled','no',0),('18177700383','eventmemberstatus','no',0),('18177700383','weight','0',0),('18177700383','autofill','no',0),('18177700383','ringinuse','yes',0),('18177700383','reportholdtime','no',0),('18177700383','autopause','no',0),('18177700383','autopausedelay','0',0),('18177700383','servicelevel','60',0),('18177700383','memberdelay','0',0),('18177700383','timeoutrestart','no',0),('18177700383','skip_joinannounce','',0),('18177700383','cron_schedule','never',0),('18177700383','autopausebusy','no',0),('18177700383','autopauseunavail','no',0),('18177700383','timeoutpriority','app',0),('18177700383','penaltymemberslimit','0',0),('18177700383','answered_elsewhere','0',0),('18177700383','member','Agent/2000,0',0),('18177700383','member','Agent/2001,0',1),('18177700383','member','Agent/2002,0',2),('18177700383','maxlen','0',0),('18177700383','joinempty','yes',0),('18177700383','leavewhenempty','no',0),('18177700383','strategy','random',0),('18177700365','member','Agent/2008,0',8),('18177700365','member','Agent/2007,0',7),('18177700365','member','Agent/2001,0',1),('18177700365','maxlen','0',0),('18177700365','joinempty','yes',0),('18177700365','leavewhenempty','no',0),('18177700365','strategy','random',0),('18177700365','timeout','0',0),('18177700365','retry','5',0),('18177700365','wrapuptime','0',0),('10011','maxlen','0',0),('10011','joinempty','yes',0),('10011','leavewhenempty','no',0),('10011','strategy','ringall',0),('10011','timeout','15',0),('10011','retry','5',0),('10011','wrapuptime','0',0),('10011','announce-frequency','0',0),('10011','announce-holdtime','no',0),('10011','announce-position','no',0),('10011','queue-youarenext','silence/1',0),('10011','queue-thereare','silence/1',0),('10011','queue-callswaiting','silence/1',0),('10011','queue-thankyou','',0),('10011','periodic-announce-frequency','0',0),('10011','monitor-format','',0),('10011','monitor-join','yes',0),('10011','eventwhencalled','no',0),('10011','eventmemberstatus','no',0),('10011','weight','0',0),('10011','autofill','no',0),('10011','ringinuse','yes',0),('10011','reportholdtime','no',0),('10011','autopause','no',0),('10011','autopausedelay','0',0),('10011','servicelevel','60',0),('10011','memberdelay','0',0),('10011','timeoutrestart','no',0),('10011','skip_joinannounce','',0),('10011','cron_schedule','never',0),('10011','autopausebusy','no',0),('10011','autopauseunavail','no',0),('10011','timeoutpriority','app',0),('10011','penaltymemberslimit','0',0),('10011','answered_elsewhere','0',0),('18147370226','member','Agent/2011,0',11),('18177700380','announce-position','no',0),('18177700380','queue-youarenext','silence/1',0),('18177700380','queue-thereare','silence/1',0),('18177700380','queue-callswaiting','silence/1',0),('18177700380','timeout','0',0),('18177700380','retry','5',0),('18177700380','wrapuptime','0',0),('18177700380','announce-frequency','0',0),('18177700380','announce-holdtime','no',0),('18177700100','autopauseunavail','no',0),('18177700100','periodic-announce-frequency','0',0),('18177700100','monitor-format','',0),('18177700100','monitor-join','yes',0),('18177700100','eventwhencalled','no',0),('18177700100','eventmemberstatus','no',0),('18177700100','weight','0',0),('18177700380','member','Agent/2002,0',2),('18177700100','member','Agent/2006,0',6),('18177700100','member','Agent/2005,0',5),('18177700100','member','Agent/2004,0',4),('18177700100','answered_elsewhere','0',0),('18177700100','member','Agent/2000,0',0),('18177700100','member','Agent/2001,0',1),('18177700100','member','Agent/2002,0',2),('18177700100','ringinuse','yes',0),('18177700100','reportholdtime','no',0),('18177700100','autopause','no',0),('18177700100','autopausedelay','0',0),('18177700100','servicelevel','60',0),('18177700100','memberdelay','0',0),('18177700100','timeoutrestart','no',0),('98177700100','answered_elsewhere','0',0),('98177700100','autopausebusy','no',0),('98177700100','autopauseunavail','no',0),('98177700100','maxlen','0',0),('98177700100','joinempty','yes',0),('98177700100','leavewhenempty','no',0),('98177700100','strategy','random',0),('98177700100','timeout','0',0),('98177700100','retry','5',0),('98177700100','wrapuptime','0',0),('98177700100','announce-frequency','0',0),('98177700100','announce-holdtime','no',0),('98177700100','announce-position','no',0),('98177700100','queue-youarenext','silence/1',0),('98177700100','queue-thereare','silence/1',0),('98177700100','queue-callswaiting','silence/1',0),('98177700100','queue-thankyou','',0),('98177700100','periodic-announce-frequency','0',0),('98177700100','monitor-format','',0),('98177700100','monitor-join','yes',0),('98177700100','eventwhencalled','no',0),('98177700100','eventmemberstatus','no',0),('98177700100','weight','0',0),('98177700100','autofill','no',0),('98177700100','ringinuse','yes',0),('98177700100','reportholdtime','no',0),('98177700100','autopause','no',0),('98177700100','autopausedelay','0',0),('98177700100','servicelevel','60',0),('98177700100','memberdelay','0',0),('98177700100','timeoutrestart','no',0),('98177700100','skip_joinannounce','',0),('18177700384','skip_joinannounce','',0),('18177700384','announce-position','no',0),('18177700384','queue-youarenext','silence/1',0),('18177700384','queue-thereare','silence/1',0),('18177700384','queue-callswaiting','silence/1',0),('18177700384','queue-thankyou','',0),('18177700384','periodic-announce-frequency','0',0),('18177700385','member','Agent/2008,0',8),('18177700385','member','Agent/2009,0',9),('18177700385','autopauseunavail','no',0),('18177700385','timeoutpriority','app',0),('18177700385','penaltymemberslimit','0',0),('18177700385','queue-callswaiting','silence/1',0),('18177700385','queue-thankyou','',0),('18177700385','periodic-announce-frequency','0',0),('18177700385','monitor-format','',0),('18177700385','monitor-join','yes',0),('18177700385','eventwhencalled','no',0),('18177700385','eventmemberstatus','no',0),('18177700385','weight','0',0),('18177700385','autofill','no',0),('18177700385','ringinuse','yes',0),('18177700385','reportholdtime','no',0),('18177700385','autopause','no',0),('18177700385','maxlen','0',0),('18177700385','joinempty','yes',0),('18177700385','leavewhenempty','no',0),('18177700385','strategy','random',0),('18177700385','timeout','0',0),('18177700385','retry','5',0),('18177700385','wrapuptime','0',0),('18177700385','announce-frequency','0',0),('18177700385','announce-holdtime','no',0),('18177700385','announce-position','no',0),('18177700385','queue-youarenext','silence/1',0),('18177700385','queue-thereare','silence/1',0),('18177700386','autopausedelay','0',0),('98177700100','member','Agent/2006,0',6),('98177700100','cron_schedule','never',0),('28177700100','autopausebusy','no',0),('28177700100','cron_schedule','never',0),('18177700386','member','Agent/2004,0',4),('18177700385','memberdelay','0',0),('18177700385','timeoutrestart','no',0),('18177700385','skip_joinannounce','',0),('18177700385','cron_schedule','never',0),('18177700385','autopausedelay','0',0),('18177700385','servicelevel','60',0),('19847770193','member','Agent/2003,0',3),('19847770193','autofill','no',0),('19847770193','ringinuse','yes',0),('19847770193','reportholdtime','no',0),('19847770193','autopause','no',0),('19847770193','autopausedelay','0',0),('19847770193','servicelevel','60',0),('19847770193','memberdelay','0',0),('19847770193','timeoutrestart','no',0),('19847770193','skip_joinannounce','',0),('19847770193','cron_schedule','never',0),('19847770193','autopausebusy','no',0),('19847770193','autopauseunavail','no',0),('19847770193','timeoutpriority','app',0),('19847770193','penaltymemberslimit','0',0),('19847770193','answered_elsewhere','0',0),('19847770193','member','Agent/2000,0',0),('19847770193','member','Agent/2001,0',1),('19847770193','member','Agent/2002,0',2),('19847770193','queue-thankyou','',0),('19847770193','periodic-announce-frequency','0',0),('19847770193','monitor-format','',0),('19847770193','monitor-join','yes',0),('19847770193','eventwhencalled','no',0),('19847770193','eventmemberstatus','no',0),('19847770193','weight','0',0),('19847770193','maxlen','0',0),('19847770193','joinempty','yes',0),('19847770193','leavewhenempty','no',0),('19847770193','strategy','random',0),('19847770193','timeout','0',0),('19847770193','retry','5',0),('19847770193','wrapuptime','0',0),('19847770193','announce-frequency','0',0),('19847770193','announce-holdtime','no',0),('19847770193','announce-position','no',0),('19847770193','queue-youarenext','silence/1',0),('19847770193','queue-thereare','silence/1',0),('19847770193','queue-callswaiting','silence/1',0),('48177700100','answered_elsewhere','0',0),('38177700100','servicelevel','60',0),('38177700100','memberdelay','0',0),('38177700100','maxlen','0',0),('38177700100','joinempty','yes',0),('38177700100','leavewhenempty','no',0),('38177700100','strategy','random',0),('38177700100','timeout','0',0),('38177700100','retry','5',0),('38177700100','wrapuptime','0',0),('38177700100','announce-frequency','0',0),('38177700100','announce-holdtime','no',0),('38177700100','announce-position','no',0),('58177700100','member','Agent/2001,0',1),('38177700100','queue-thereare','silence/1',0),('38177700100','queue-callswaiting','silence/1',0),('38177700100','queue-thankyou','',0),('38177700100','periodic-announce-frequency','0',0),('38177700100','monitor-format','',0),('38177700100','monitor-join','yes',0),('38177700100','eventwhencalled','no',0),('38177700100','eventmemberstatus','no',0),('38177700100','weight','0',0),('38177700100','autofill','no',0),('38177700100','ringinuse','yes',0),('38177700100','reportholdtime','no',0),('38177700100','autopause','no',0),('38177700100','autopausedelay','0',0),('38177700100','queue-youarenext','silence/1',0),('38177700100','timeoutpriority','app',0),('48177700100','skip_joinannounce','',0),('48177700100','memberdelay','0',0),('48177700100','timeoutrestart','no',0),('48177700100','maxlen','0',0),('48177700100','joinempty','yes',0),('48177700100','leavewhenempty','no',0),('48177700100','strategy','random',0),('48177700100','timeout','0',0),('48177700100','retry','5',0),('48177700100','wrapuptime','0',0),('48177700100','announce-frequency','0',0),('48177700100','announce-holdtime','no',0),('58177700100','member','Agent/2000,0',0),('48177700100','member','Agent/2000,0',0),('48177700100','queue-callswaiting','silence/1',0),('48177700100','queue-thankyou','',0),('48177700100','periodic-announce-frequency','0',0),('48177700100','monitor-format','',0),('48177700100','monitor-join','yes',0),('48177700100','eventwhencalled','no',0),('48177700100','eventmemberstatus','no',0),('48177700100','weight','0',0),('48177700100','autofill','no',0),('48177700100','ringinuse','yes',0),('48177700100','reportholdtime','no',0),('48177700100','autopause','no',0),('48177700100','autopausedelay','0',0),('48177700100','servicelevel','60',0),('48177700100','announce-position','no',0),('48177700100','queue-youarenext','silence/1',0),('48177700100','queue-thereare','silence/1',0),('38177700100','member','Agent/2006,0',6),('38177700100','member','Agent/2005,0',5),('38177700100','skip_joinannounce','',0),('38177700100','cron_schedule','never',0),('38177700100','autopausebusy','no',0),('38177700100','autopauseunavail','no',0),('38177700100','timeoutrestart','no',0),('58177700100','cron_schedule','never',0),('48177700100','member','Agent/2009,0',9),('48177700100','member','Agent/2008,0',8),('48177700100','cron_schedule','never',0),('48177700100','autopausebusy','no',0),('48177700100','autopauseunavail','no',0),('48177700100','timeoutpriority','app',0),('48177700100','penaltymemberslimit','0',0),('58177700100','member','Agent/2007,0',7),('58177700100','member','Agent/2006,0',6),('58177700100','autopausebusy','no',0),('58177700100','autopauseunavail','no',0),('58177700100','maxlen','0',0),('58177700100','joinempty','yes',0),('58177700100','leavewhenempty','no',0),('58177700100','strategy','random',0),('58177700100','timeout','0',0),('58177700100','retry','5',0),('58177700100','wrapuptime','0',0),('58177700100','announce-frequency','0',0),('58177700100','announce-holdtime','no',0),('58177700100','announce-position','no',0),('58177700100','queue-youarenext','silence/1',0),('58177700100','queue-thereare','silence/1',0),('58177700100','queue-callswaiting','silence/1',0),('58177700100','queue-thankyou','',0),('58177700100','periodic-announce-frequency','0',0),('58177700100','monitor-format','',0),('58177700100','monitor-join','yes',0),('58177700100','eventwhencalled','no',0),('58177700100','eventmemberstatus','no',0),('58177700100','weight','0',0),('58177700100','autofill','no',0),('58177700100','ringinuse','yes',0),('58177700100','reportholdtime','no',0),('58177700100','autopause','no',0),('58177700100','autopausedelay','0',0),('58177700100','servicelevel','60',0),('58177700100','memberdelay','0',0),('58177700100','timeoutrestart','no',0),('58177700100','skip_joinannounce','',0),('18177700386','member','Agent/2003,0',3),('18177700386','member','Agent/2000,0',0),('18177700386','autopauseunavail','no',0),('18177700386','timeoutpriority','app',0),('18177700386','penaltymemberslimit','0',0),('18177700386','answered_elsewhere','0',0),('18177700386','timeoutrestart','no',0),('18177700386','skip_joinannounce','',0),('18177700386','cron_schedule','never',0),('18177700386','autopausebusy','no',0),('18177700386','servicelevel','60',0),('18177700386','memberdelay','0',0),('18177700386','queue-thankyou','',0),('18177700386','periodic-announce-frequency','0',0),('18177700386','monitor-format','',0),('18177700386','monitor-join','yes',0),('18177700386','queue-youarenext','silence/1',0),('18177700386','queue-thereare','silence/1',0),('18177700386','queue-callswaiting','silence/1',0),('18177700386','maxlen','0',0),('18177700386','joinempty','yes',0),('18177700386','leavewhenempty','no',0),('18177700386','strategy','random',0),('18177700386','timeout','0',0),('18177700386','retry','5',0),('18177700386','wrapuptime','0',0),('18177700386','announce-frequency','0',0),('18177700386','announce-holdtime','no',0),('18177700386','announce-position','no',0),('18177700380','member','Agent/2001,0',1),('18177700380','answered_elsewhere','0',0),('18177700380','member','Agent/2000,0',0),('18177700380','eventwhencalled','no',0),('18177700380','periodic-announce-frequency','0',0),('18177700380','maxlen','0',0),('18177700380','joinempty','yes',0),('18177700380','leavewhenempty','no',0),('18177700380','strategy','random',0),('18147370221','member','Agent/2007,0',7),('18147370221','cron_schedule','never',0),('18147370221','autopausebusy','no',0),('18147370221','autopauseunavail','no',0),('18147370221','timeoutpriority','app',0),('18147370221','autopausedelay','0',0),('18147370221','servicelevel','60',0),('18147370221','memberdelay','0',0),('18147370221','timeoutrestart','no',0),('18147370221','skip_joinannounce','',0),('18147370221','queue-youarenext','silence/1',0),('18147370221','queue-thereare','silence/1',0),('18147370221','queue-callswaiting','silence/1',0),('18147370221','maxlen','0',0),('18147370221','joinempty','yes',0),('18147370221','leavewhenempty','no',0),('18147370221','strategy','random',0),('18147370221','timeout','0',0),('18147370221','retry','5',0),('18147370221','wrapuptime','0',0),('18147370221','announce-frequency','0',0),('18147370221','announce-holdtime','no',0),('18147370221','announce-position','no',0),('18177700675','timeoutrestart','no',0),('18177700675','skip_joinannounce','',0),('108177700100','member','Agent/2005,0',5),('108177700100','member','Agent/2006,0',6),('108177700100','member','Agent/2007,0',7),('108177700100','member','Agent/2008,0',8),('108177700100','member','Agent/2009,0',9),('108177700100','cron_schedule','never',0),('108177700100','autopausebusy','no',0),('108177700100','autopauseunavail','no',0),('108177700100','timeoutpriority','app',0),('108177700100','reportholdtime','no',0),('108177700100','maxlen','0',0),('108177700100','joinempty','yes',0),('108177700100','leavewhenempty','no',0),('108177700100','strategy','random',0),('108177700100','timeout','0',0),('108177700100','retry','5',0),('108177700100','wrapuptime','0',0),('108177700100','announce-frequency','0',0),('108177700100','announce-holdtime','no',0),('108177700100','announce-position','no',0),('108177700100','queue-youarenext','silence/1',0),('108177700100','queue-thereare','silence/1',0),('108177700100','queue-callswaiting','silence/1',0),('108177700100','queue-thankyou','',0),('108177700100','periodic-announce-frequency','0',0),('108177700100','monitor-format','',0),('108177700100','monitor-join','yes',0),('108177700100','eventwhencalled','no',0),('108177700100','eventmemberstatus','no',0),('108177700100','weight','0',0),('108177700100','autofill','no',0),('108177700100','ringinuse','yes',0),('118177700100','autofill','no',0),('118177700100','ringinuse','yes',0),('118177700100','reportholdtime','no',0),('118177700100','autopause','no',0),('118177700100','autopausedelay','0',0),('118177700100','servicelevel','60',0),('118177700100','memberdelay','0',0),('118177700100','timeoutrestart','no',0),('118177700100','skip_joinannounce','',0),('118177700100','cron_schedule','never',0),('118177700100','autopausebusy','no',0),('118177700100','autopauseunavail','no',0),('118177700100','timeoutpriority','app',0),('118177700100','maxlen','0',0),('118177700100','joinempty','yes',0),('118177700100','leavewhenempty','no',0),('118177700100','strategy','random',0),('118177700100','timeout','0',0),('118177700100','retry','5',0),('118177700100','wrapuptime','0',0),('118177700100','announce-frequency','0',0),('118177700100','announce-holdtime','no',0),('118177700100','announce-position','no',0),('118177700100','queue-youarenext','silence/1',0),('118177700100','queue-thereare','silence/1',0),('118177700100','queue-callswaiting','silence/1',0),('128177700100','member','Agent/2006,0',6),('128177700100','ringinuse','yes',0),('128177700100','reportholdtime','no',0),('128177700100','autopause','no',0),('128177700100','autopausedelay','0',0),('128177700100','weight','0',0),('128177700100','autofill','no',0),('128177700100','announce-position','no',0),('128177700100','queue-youarenext','silence/1',0),('128177700100','queue-thereare','silence/1',0),('128177700100','queue-callswaiting','silence/1',0),('128177700100','queue-thankyou','',0),('128177700100','periodic-announce-frequency','0',0),('128177700100','monitor-format','',0),('128177700100','monitor-join','yes',0),('128177700100','eventwhencalled','no',0),('128177700100','eventmemberstatus','no',0),('128177700100','maxlen','0',0),('128177700100','joinempty','yes',0),('128177700100','leavewhenempty','no',0),('128177700100','strategy','random',0),('128177700100','timeout','0',0),('128177700100','retry','5',0),('128177700100','wrapuptime','0',0),('128177700100','announce-frequency','0',0),('138177700100','autofill','no',0),('138177700100','ringinuse','yes',0),('138177700100','reportholdtime','no',0),('138177700100','autopause','no',0),('138177700100','autopausedelay','0',0),('138177700100','servicelevel','60',0),('138177700100','memberdelay','0',0),('138177700100','timeoutrestart','no',0),('138177700100','skip_joinannounce','',0),('138177700100','cron_schedule','never',0),('138177700100','autopausebusy','no',0),('138177700100','autopauseunavail','no',0),('138177700100','timeoutpriority','app',0),('138177700100','maxlen','0',0),('138177700100','joinempty','yes',0),('138177700100','leavewhenempty','no',0),('138177700100','strategy','random',0),('138177700100','timeout','0',0),('138177700100','retry','5',0),('138177700100','wrapuptime','0',0),('138177700100','announce-frequency','0',0),('138177700100','announce-holdtime','no',0),('138177700100','announce-position','no',0),('138177700100','queue-youarenext','silence/1',0),('138177700100','queue-thereare','silence/1',0),('138177700100','queue-callswaiting','silence/1',0),('198177700100','autofill','no',0),('198177700100','ringinuse','yes',0),('198177700100','reportholdtime','no',0),('198177700100','autopause','no',0),('198177700100','autopausedelay','0',0),('198177700100','servicelevel','60',0),('198177700100','memberdelay','0',0),('198177700100','timeoutrestart','no',0),('198177700100','skip_joinannounce','',0),('198177700100','cron_schedule','never',0),('198177700100','autopausebusy','no',0),('198177700100','autopauseunavail','no',0),('198177700100','timeoutpriority','app',0),('198177700100','maxlen','0',0),('198177700100','joinempty','yes',0),('198177700100','leavewhenempty','no',0),('198177700100','strategy','random',0),('198177700100','timeout','0',0),('198177700100','retry','5',0),('198177700100','wrapuptime','0',0),('198177700100','announce-frequency','0',0),('198177700100','announce-holdtime','no',0),('198177700100','announce-position','no',0),('198177700100','queue-youarenext','silence/1',0),('198177700100','queue-thereare','silence/1',0),('198177700100','queue-callswaiting','silence/1',0),('188177700100','autofill','no',0),('188177700100','ringinuse','yes',0),('188177700100','reportholdtime','no',0),('188177700100','autopause','no',0),('188177700100','autopausedelay','0',0),('188177700100','servicelevel','60',0),('188177700100','memberdelay','0',0),('188177700100','timeoutrestart','no',0),('188177700100','skip_joinannounce','',0),('188177700100','cron_schedule','never',0),('188177700100','autopausebusy','no',0),('188177700100','autopauseunavail','no',0),('188177700100','timeoutpriority','app',0),('188177700100','maxlen','0',0),('188177700100','joinempty','yes',0),('188177700100','leavewhenempty','no',0),('188177700100','strategy','ringall',0),('188177700100','timeout','0',0),('188177700100','retry','5',0),('188177700100','wrapuptime','0',0),('188177700100','announce-frequency','0',0),('188177700100','announce-holdtime','no',0),('188177700100','announce-position','no',0),('188177700100','queue-youarenext','silence/1',0),('188177700100','queue-thereare','silence/1',0),('188177700100','queue-callswaiting','silence/1',0),('18177700675','member','Agent/2004,0',4),('18177700675','member','Agent/2005,0',5),('18177700675','autopausedelay','0',0),('18177700675','autopause','no',0),('108177700100','skip_joinannounce','',0),('108177700100','memberdelay','0',0),('108177700100','timeoutrestart','no',0),('118177700100','member','Agent/2003,0',3),('118177700100','penaltymemberslimit','0',0),('118177700100','answered_elsewhere','0',0),('118177700100','member','Agent/2000,0',0),('118177700100','member','Agent/2001,0',1),('118177700100','member','Agent/2002,0',2),('118177700100','queue-thankyou','',0),('118177700100','periodic-announce-frequency','0',0),('118177700100','monitor-format','',0),('118177700100','monitor-join','yes',0),('118177700100','eventwhencalled','no',0),('118177700100','eventmemberstatus','no',0),('118177700100','weight','0',0),('128177700100','member','Agent/2005,0',5),('128177700100','autopauseunavail','no',0),('128177700100','timeoutpriority','app',0),('128177700100','penaltymemberslimit','0',0),('128177700100','answered_elsewhere','0',0),('128177700100','member','Agent/2000,0',0),('128177700100','servicelevel','60',0),('128177700100','memberdelay','0',0),('128177700100','timeoutrestart','no',0),('128177700100','skip_joinannounce','',0),('128177700100','cron_schedule','never',0),('128177700100','autopausebusy','no',0),('128177700100','announce-holdtime','no',0),('138177700100','member','Agent/2003,0',3),('138177700100','penaltymemberslimit','0',0),('138177700100','answered_elsewhere','0',0),('138177700100','member','Agent/2000,0',0),('138177700100','member','Agent/2001,0',1),('138177700100','member','Agent/2002,0',2),('138177700100','queue-thankyou','',0),('138177700100','periodic-announce-frequency','0',0),('138177700100','monitor-format','',0),('138177700100','monitor-join','yes',0),('138177700100','eventwhencalled','no',0),('138177700100','eventmemberstatus','no',0),('138177700100','weight','0',0),('188177700100','member','Agent/2003,0',3),('188177700100','penaltymemberslimit','0',0),('188177700100','answered_elsewhere','0',0),('188177700100','member','Agent/2000,0',0),('188177700100','member','Agent/2001,0',1),('188177700100','member','Agent/2002,0',2),('188177700100','queue-thankyou','',0),('188177700100','periodic-announce-frequency','0',0),('188177700100','monitor-format','',0),('188177700100','monitor-join','yes',0),('188177700100','eventwhencalled','no',0),('188177700100','eventmemberstatus','no',0),('188177700100','weight','0',0),('198177700100','member','Agent/2003,0',3),('198177700100','penaltymemberslimit','0',0),('198177700100','answered_elsewhere','0',0),('198177700100','member','Agent/2000,0',0),('198177700100','member','Agent/2001,0',1),('198177700100','member','Agent/2002,0',2),('198177700100','queue-thankyou','',0),('198177700100','periodic-announce-frequency','0',0),('198177700100','monitor-format','',0),('198177700100','monitor-join','yes',0),('198177700100','eventwhencalled','no',0),('198177700100','eventmemberstatus','no',0),('198177700100','weight','0',0),('98177700100','member','Agent/2002,0',2),('98177700100','member','Agent/2003,0',3),('98177700100','member','Agent/2004,0',4),('98177700100','member','Agent/2005,0',5),('105588804680','member','Agent/2008,0',8),('105588804680','timeoutpriority','app',0),('105588804680','penaltymemberslimit','0',0),('105588804680','answered_elsewhere','0',0),('105588804680','member','Agent/2000,0',0),('105588804680','strategy','random',0),('105588804680','timeout','0',0),('105588804680','retry','5',0),('105588804680','wrapuptime','0',0),('105588804680','announce-frequency','0',0),('105588804680','announce-holdtime','no',0),('105588804680','announce-position','no',0),('105588804680','queue-youarenext','silence/1',0),('105588804680','queue-thereare','silence/1',0),('105588804680','queue-callswaiting','silence/1',0),('105588804680','queue-thankyou','',0),('105588804680','periodic-announce-frequency','0',0),('105588804680','monitor-format','',0),('105588804680','monitor-join','yes',0),('105588804680','eventwhencalled','no',0),('105588804680','eventmemberstatus','no',0),('105588804680','weight','0',0),('105588804680','autofill','no',0),('105588804680','maxlen','0',0),('105588804680','joinempty','yes',0),('105588804680','leavewhenempty','no',0),('115588804680','autofill','no',0),('115588804680','ringinuse','yes',0),('115588804680','reportholdtime','no',0),('115588804680','autopause','no',0),('115588804680','autopausedelay','0',0),('115588804680','servicelevel','60',0),('115588804680','memberdelay','0',0),('115588804680','timeoutrestart','no',0),('115588804680','skip_joinannounce','',0),('115588804680','cron_schedule','never',0),('115588804680','autopausebusy','no',0),('115588804680','autopauseunavail','no',0),('115588804680','timeoutpriority','app',0),('115588804680','maxlen','0',0),('115588804680','joinempty','yes',0),('115588804680','leavewhenempty','no',0),('115588804680','strategy','random',0),('115588804680','timeout','0',0),('115588804680','retry','5',0),('115588804680','wrapuptime','0',0),('115588804680','announce-frequency','0',0),('115588804680','announce-holdtime','no',0),('115588804680','announce-position','no',0),('115588804680','queue-youarenext','silence/1',0),('115588804680','queue-thereare','silence/1',0),('115588804680','queue-callswaiting','silence/1',0),('125588804680','autofill','no',0),('125588804680','ringinuse','yes',0),('125588804680','reportholdtime','no',0),('125588804680','autopause','no',0),('125588804680','autopausedelay','0',0),('125588804680','servicelevel','60',0),('125588804680','memberdelay','0',0),('125588804680','timeoutrestart','no',0),('125588804680','skip_joinannounce','',0),('125588804680','cron_schedule','never',0),('125588804680','autopausebusy','no',0),('125588804680','autopauseunavail','no',0),('125588804680','timeoutpriority','app',0),('125588804680','maxlen','0',0),('125588804680','joinempty','yes',0),('125588804680','leavewhenempty','no',0),('125588804680','strategy','random',0),('125588804680','timeout','0',0),('125588804680','retry','5',0),('125588804680','wrapuptime','0',0),('125588804680','announce-frequency','0',0),('125588804680','announce-holdtime','no',0),('125588804680','announce-position','no',0),('125588804680','queue-youarenext','silence/1',0),('125588804680','queue-thereare','silence/1',0),('125588804680','queue-callswaiting','silence/1',0),('135588804680','member','Agent/2006,0',6),('135588804680','ringinuse','yes',0),('135588804680','reportholdtime','no',0),('135588804680','autopause','no',0),('135588804680','autopausedelay','0',0),('135588804680','weight','0',0),('135588804680','autofill','no',0),('135588804680','announce-position','no',0),('135588804680','queue-youarenext','silence/1',0),('135588804680','queue-thereare','silence/1',0),('135588804680','queue-callswaiting','silence/1',0),('135588804680','queue-thankyou','',0),('135588804680','periodic-announce-frequency','0',0),('135588804680','monitor-format','',0),('135588804680','monitor-join','yes',0),('135588804680','eventwhencalled','no',0),('135588804680','eventmemberstatus','no',0),('135588804680','maxlen','0',0),('135588804680','joinempty','yes',0),('135588804680','leavewhenempty','no',0),('135588804680','strategy','random',0),('135588804680','timeout','0',0),('135588804680','retry','5',0),('135588804680','wrapuptime','0',0),('135588804680','announce-frequency','0',0),('185588804680','autofill','no',0),('185588804680','ringinuse','yes',0),('185588804680','reportholdtime','no',0),('185588804680','autopause','no',0),('185588804680','autopausedelay','0',0),('185588804680','servicelevel','60',0),('185588804680','memberdelay','0',0),('185588804680','timeoutrestart','no',0),('185588804680','skip_joinannounce','',0),('185588804680','cron_schedule','never',0),('185588804680','autopausebusy','no',0),('185588804680','autopauseunavail','no',0),('185588804680','timeoutpriority','app',0),('185588804680','maxlen','0',0),('185588804680','joinempty','yes',0),('185588804680','leavewhenempty','no',0),('185588804680','strategy','random',0),('185588804680','timeout','0',0),('185588804680','retry','5',0),('185588804680','wrapuptime','0',0),('185588804680','announce-frequency','0',0),('185588804680','announce-holdtime','no',0),('185588804680','announce-position','no',0),('185588804680','queue-youarenext','silence/1',0),('185588804680','queue-thereare','silence/1',0),('185588804680','queue-callswaiting','silence/1',0),('195588804680','autofill','no',0),('195588804680','ringinuse','yes',0),('195588804680','reportholdtime','no',0),('195588804680','autopause','no',0),('195588804680','autopausedelay','0',0),('195588804680','servicelevel','60',0),('195588804680','memberdelay','0',0),('195588804680','timeoutrestart','no',0),('195588804680','skip_joinannounce','',0),('195588804680','cron_schedule','never',0),('195588804680','autopausebusy','no',0),('195588804680','autopauseunavail','no',0),('195588804680','timeoutpriority','app',0),('195588804680','maxlen','0',0),('195588804680','joinempty','yes',0),('195588804680','leavewhenempty','no',0),('195588804680','strategy','random',0),('195588804680','timeout','0',0),('195588804680','retry','5',0),('195588804680','wrapuptime','0',0),('195588804680','announce-frequency','0',0),('195588804680','announce-holdtime','no',0),('195588804680','announce-position','no',0),('195588804680','queue-youarenext','silence/1',0),('195588804680','queue-thereare','silence/1',0),('195588804680','queue-callswaiting','silence/1',0),('108177700100','answered_elsewhere','0',0),('105588804680','member','Agent/2009,0',9),('105588804680','memberdelay','0',0),('105588804680','timeoutrestart','no',0),('105588804680','skip_joinannounce','',0),('105588804680','cron_schedule','never',0),('105588804680','autopausebusy','no',0),('105588804680','autopauseunavail','no',0),('105588804680','ringinuse','yes',0),('105588804680','reportholdtime','no',0),('105588804680','autopause','no',0),('105588804680','autopausedelay','0',0),('105588804680','servicelevel','60',0),('115588804680','member','Agent/2003,0',3),('115588804680','penaltymemberslimit','0',0),('115588804680','answered_elsewhere','0',0),('115588804680','member','Agent/2000,0',0),('115588804680','member','Agent/2001,0',1),('115588804680','member','Agent/2002,0',2),('115588804680','queue-thankyou','',0),('115588804680','periodic-announce-frequency','0',0),('115588804680','monitor-format','',0),('115588804680','monitor-join','yes',0),('115588804680','eventwhencalled','no',0),('115588804680','eventmemberstatus','no',0),('115588804680','weight','0',0),('125588804680','member','Agent/2003,0',3),('125588804680','penaltymemberslimit','0',0),('125588804680','answered_elsewhere','0',0),('125588804680','member','Agent/2000,0',0),('125588804680','member','Agent/2001,0',1),('125588804680','member','Agent/2002,0',2),('125588804680','queue-thankyou','',0),('125588804680','periodic-announce-frequency','0',0),('125588804680','monitor-format','',0),('125588804680','monitor-join','yes',0),('125588804680','eventwhencalled','no',0),('125588804680','eventmemberstatus','no',0),('125588804680','weight','0',0),('135588804680','member','Agent/2005,0',5),('135588804680','autopauseunavail','no',0),('135588804680','timeoutpriority','app',0),('135588804680','penaltymemberslimit','0',0),('135588804680','answered_elsewhere','0',0),('135588804680','member','Agent/2000,0',0),('135588804680','servicelevel','60',0),('135588804680','memberdelay','0',0),('135588804680','timeoutrestart','no',0),('135588804680','skip_joinannounce','',0),('135588804680','cron_schedule','never',0),('135588804680','autopausebusy','no',0),('135588804680','announce-holdtime','no',0),('185588804680','member','Agent/2003,0',3),('185588804680','penaltymemberslimit','0',0),('185588804680','answered_elsewhere','0',0),('185588804680','member','Agent/2000,0',0),('185588804680','member','Agent/2001,0',1),('185588804680','member','Agent/2002,0',2),('185588804680','queue-thankyou','',0),('185588804680','periodic-announce-frequency','0',0),('185588804680','monitor-format','',0),('185588804680','monitor-join','yes',0),('185588804680','eventwhencalled','no',0),('185588804680','eventmemberstatus','no',0),('185588804680','weight','0',0),('195588804680','member','Agent/2003,0',3),('195588804680','penaltymemberslimit','0',0),('195588804680','answered_elsewhere','0',0),('195588804680','member','Agent/2000,0',0),('195588804680','member','Agent/2001,0',1),('195588804680','member','Agent/2002,0',2),('195588804680','queue-thankyou','',0),('195588804680','periodic-announce-frequency','0',0),('195588804680','monitor-format','',0),('195588804680','monitor-join','yes',0),('195588804680','eventwhencalled','no',0),('195588804680','eventmemberstatus','no',0),('195588804680','weight','0',0),('103335605355','member','Agent/2004,0',4),('103335605355','cron_schedule','never',0),('103335605355','autopausebusy','no',0),('103335605355','autopauseunavail','no',0),('103335605355','timeoutpriority','app',0),('103335605355','penaltymemberslimit','0',0),('103335605355','answered_elsewhere','0',0),('103335605355','member','Agent/2000,0',0),('103335605355','maxlen','0',0),('103335605355','joinempty','yes',0),('103335605355','leavewhenempty','no',0),('103335605355','strategy','random',0),('103335605355','timeout','0',0),('103335605355','retry','5',0),('103335605355','wrapuptime','0',0),('103335605355','announce-frequency','0',0),('103335605355','announce-holdtime','no',0),('103335605355','announce-position','no',0),('103335605355','queue-youarenext','silence/1',0),('103335605355','queue-thereare','silence/1',0),('103335605355','queue-callswaiting','silence/1',0),('103335605355','queue-thankyou','',0),('103335605355','periodic-announce-frequency','0',0),('103335605355','monitor-format','',0),('103335605355','monitor-join','yes',0),('103335605355','eventwhencalled','no',0),('113335605355','autofill','no',0),('113335605355','ringinuse','yes',0),('113335605355','reportholdtime','no',0),('113335605355','autopause','no',0),('113335605355','autopausedelay','0',0),('113335605355','servicelevel','60',0),('113335605355','memberdelay','0',0),('113335605355','timeoutrestart','no',0),('113335605355','skip_joinannounce','',0),('113335605355','cron_schedule','never',0),('113335605355','autopausebusy','no',0),('113335605355','autopauseunavail','no',0),('113335605355','timeoutpriority','app',0),('113335605355','maxlen','0',0),('113335605355','joinempty','yes',0),('113335605355','leavewhenempty','no',0),('113335605355','strategy','random',0),('113335605355','timeout','0',0),('113335605355','retry','5',0),('113335605355','wrapuptime','0',0),('113335605355','announce-frequency','0',0),('113335605355','announce-holdtime','no',0),('113335605355','announce-position','no',0),('113335605355','queue-youarenext','silence/1',0),('113335605355','queue-thereare','silence/1',0),('113335605355','queue-callswaiting','silence/1',0),('123335605355','autofill','no',0),('123335605355','ringinuse','yes',0),('123335605355','reportholdtime','no',0),('123335605355','autopause','no',0),('123335605355','autopausedelay','0',0),('123335605355','servicelevel','60',0),('123335605355','memberdelay','0',0),('123335605355','timeoutrestart','no',0),('123335605355','skip_joinannounce','',0),('123335605355','cron_schedule','never',0),('123335605355','autopausebusy','no',0),('123335605355','autopauseunavail','no',0),('123335605355','timeoutpriority','app',0),('123335605355','maxlen','0',0),('123335605355','joinempty','yes',0),('123335605355','leavewhenempty','no',0),('123335605355','strategy','random',0),('123335605355','timeout','0',0),('123335605355','retry','5',0),('123335605355','wrapuptime','0',0),('123335605355','announce-frequency','0',0),('123335605355','announce-holdtime','no',0),('123335605355','announce-position','no',0),('123335605355','queue-youarenext','silence/1',0),('123335605355','queue-thereare','silence/1',0),('123335605355','queue-callswaiting','silence/1',0),('133335605355','member','Agent/2006,0',6),('133335605355','ringinuse','yes',0),('133335605355','reportholdtime','no',0),('133335605355','autopause','no',0),('133335605355','autopausedelay','0',0),('133335605355','weight','0',0),('133335605355','autofill','no',0),('133335605355','announce-position','no',0),('133335605355','queue-youarenext','silence/1',0),('133335605355','queue-thereare','silence/1',0),('133335605355','queue-callswaiting','silence/1',0),('133335605355','queue-thankyou','',0),('133335605355','periodic-announce-frequency','0',0),('133335605355','monitor-format','',0),('133335605355','monitor-join','yes',0),('133335605355','eventwhencalled','no',0),('133335605355','eventmemberstatus','no',0),('133335605355','maxlen','0',0),('133335605355','joinempty','yes',0),('133335605355','leavewhenempty','no',0),('133335605355','strategy','random',0),('133335605355','timeout','0',0),('133335605355','retry','5',0),('133335605355','wrapuptime','0',0),('133335605355','announce-frequency','0',0),('183335605355','autofill','no',0),('183335605355','ringinuse','yes',0),('183335605355','reportholdtime','no',0),('183335605355','autopause','no',0),('183335605355','autopausedelay','0',0),('183335605355','servicelevel','60',0),('183335605355','memberdelay','0',0),('183335605355','timeoutrestart','no',0),('183335605355','skip_joinannounce','',0),('183335605355','cron_schedule','never',0),('183335605355','autopausebusy','no',0),('183335605355','autopauseunavail','no',0),('183335605355','timeoutpriority','app',0),('183335605355','maxlen','0',0),('183335605355','joinempty','yes',0),('183335605355','leavewhenempty','no',0),('183335605355','strategy','random',0),('183335605355','timeout','0',0),('183335605355','retry','5',0),('183335605355','wrapuptime','0',0),('183335605355','announce-frequency','0',0),('183335605355','announce-holdtime','no',0),('183335605355','announce-position','no',0),('183335605355','queue-youarenext','silence/1',0),('183335605355','queue-thereare','silence/1',0),('183335605355','queue-callswaiting','silence/1',0),('193335605355','member','Agent/2006,0',6),('193335605355','member','Agent/2007,0',7),('193335605355','skip_joinannounce','',0),('193335605355','cron_schedule','never',0),('193335605355','autopausebusy','no',0),('193335605355','autopauseunavail','no',0),('193335605355','leavewhenempty','no',0),('193335605355','strategy','random',0),('193335605355','timeout','0',0),('193335605355','retry','5',0),('193335605355','wrapuptime','0',0),('193335605355','announce-frequency','0',0),('193335605355','announce-holdtime','no',0),('193335605355','announce-position','no',0),('193335605355','queue-youarenext','silence/1',0),('193335605355','queue-thereare','silence/1',0),('193335605355','queue-callswaiting','silence/1',0),('193335605355','queue-thankyou','',0),('193335605355','periodic-announce-frequency','0',0),('193335605355','monitor-format','',0),('193335605355','monitor-join','yes',0),('193335605355','eventwhencalled','no',0),('193335605355','eventmemberstatus','no',0),('193335605355','weight','0',0),('193335605355','autofill','no',0),('193335605355','ringinuse','yes',0),('193335605355','reportholdtime','no',0),('193335605355','autopause','no',0),('193335605355','autopausedelay','0',0),('193335605355','servicelevel','60',0),('193335605355','memberdelay','0',0),('193335605355','timeoutrestart','no',0),('193335605355','maxlen','0',0),('193335605355','joinempty','yes',0),('103335605355','member','Agent/2003,0',3),('103335605355','member','Agent/2002,0',2),('103335605355','member','Agent/2001,0',1),('103335605355','eventmemberstatus','no',0),('103335605355','weight','0',0),('103335605355','autofill','no',0),('103335605355','ringinuse','yes',0),('103335605355','reportholdtime','no',0),('103335605355','autopause','no',0),('103335605355','autopausedelay','0',0),('103335605355','servicelevel','60',0),('103335605355','memberdelay','0',0),('103335605355','timeoutrestart','no',0),('103335605355','skip_joinannounce','',0),('113335605355','member','Agent/2003,0',3),('113335605355','penaltymemberslimit','0',0),('113335605355','answered_elsewhere','0',0),('113335605355','member','Agent/2000,0',0),('113335605355','member','Agent/2001,0',1),('113335605355','member','Agent/2002,0',2),('113335605355','queue-thankyou','',0),('113335605355','periodic-announce-frequency','0',0),('113335605355','monitor-format','',0),('113335605355','monitor-join','yes',0),('113335605355','eventwhencalled','no',0),('113335605355','eventmemberstatus','no',0),('113335605355','weight','0',0),('123335605355','member','Agent/2003,0',3),('123335605355','penaltymemberslimit','0',0),('123335605355','answered_elsewhere','0',0),('123335605355','member','Agent/2000,0',0),('123335605355','member','Agent/2001,0',1),('123335605355','member','Agent/2002,0',2),('123335605355','queue-thankyou','',0),('123335605355','periodic-announce-frequency','0',0),('123335605355','monitor-format','',0),('123335605355','monitor-join','yes',0),('123335605355','eventwhencalled','no',0),('123335605355','eventmemberstatus','no',0),('123335605355','weight','0',0),('133335605355','member','Agent/2005,0',5),('133335605355','autopauseunavail','no',0),('133335605355','timeoutpriority','app',0),('133335605355','penaltymemberslimit','0',0),('133335605355','answered_elsewhere','0',0),('133335605355','member','Agent/2000,0',0),('133335605355','servicelevel','60',0),('133335605355','memberdelay','0',0),('133335605355','timeoutrestart','no',0),('133335605355','skip_joinannounce','',0),('133335605355','cron_schedule','never',0),('133335605355','autopausebusy','no',0),('133335605355','announce-holdtime','no',0),('183335605355','member','Agent/2003,0',3),('183335605355','penaltymemberslimit','0',0),('183335605355','answered_elsewhere','0',0),('183335605355','member','Agent/2000,0',0),('183335605355','member','Agent/2001,0',1),('183335605355','member','Agent/2002,0',2),('183335605355','queue-thankyou','',0),('183335605355','periodic-announce-frequency','0',0),('183335605355','monitor-format','',0),('183335605355','monitor-join','yes',0),('183335605355','eventwhencalled','no',0),('183335605355','eventmemberstatus','no',0),('183335605355','weight','0',0),('193335605355','member','Agent/2001,0',1),('193335605355','member','Agent/2002,0',2),('193335605355','member','Agent/2003,0',3),('193335605355','member','Agent/2004,0',4),('193335605355','member','Agent/2005,0',5),('193335605355','timeoutpriority','app',0),('18177700387','member','Agent/2005,0',5),('18177700387','member','Agent/2006,0',6),('18177700389','member','Agent/2003,0',3),('18177700389','member','Agent/2004,0',4),('18177700389','answered_elsewhere','0',0),('18177700389','member','Agent/2000,0',0),('18177700389','member','Agent/2001,0',1),('18177700389','member','Agent/2002,0',2),('18177700389','queue-youarenext','silence/1',0),('18177700389','autopausebusy','no',0),('18177700389','autopauseunavail','no',0),('18177700389','timeoutpriority','app',0),('18177700389','penaltymemberslimit','0',0),('18177700389','skip_joinannounce','',0),('18177700389','cron_schedule','never',0),('18177700389','queue-thereare','silence/1',0),('18177700389','queue-callswaiting','silence/1',0),('18177700389','queue-thankyou','',0),('18177700389','periodic-announce-frequency','0',0),('18177700389','monitor-format','',0),('18177700389','monitor-join','yes',0),('18177700389','eventwhencalled','no',0),('18177700389','eventmemberstatus','no',0),('18177700389','weight','0',0),('18177700389','autofill','no',0),('18177700389','ringinuse','yes',0),('18177700389','reportholdtime','no',0),('18177700389','autopause','no',0),('18177700389','autopausedelay','0',0),('18177700389','servicelevel','60',0),('18177700671','autopausedelay','0',0),('18177700671','servicelevel','60',0),('18177700671','memberdelay','0',0),('18177700671','timeoutrestart','no',0),('18177700671','skip_joinannounce','',0),('18177700671','cron_schedule','never',0),('18177700671','autopausebusy','no',0),('18177700671','autopauseunavail','no',0),('18177700671','timeoutpriority','app',0),('18177700671','penaltymemberslimit','0',0),('18177700671','answered_elsewhere','0',0),('18177700671','member','Agent/2000,0',0),('18177700671','member','Agent/2001,0',1),('18177700671','queue-thankyou','',0),('18177700671','periodic-announce-frequency','0',0),('18177700671','monitor-format','',0),('18177700671','monitor-join','yes',0),('18177700671','queue-youarenext','silence/1',0),('18177700671','queue-thereare','silence/1',0),('18177700671','queue-callswaiting','silence/1',0),('18177700671','maxlen','0',0),('18177700671','joinempty','yes',0),('18177700671','leavewhenempty','no',0),('18177700671','strategy','random',0),('18177700671','timeout','0',0),('18177700671','retry','5',0),('18177700671','wrapuptime','0',0),('18177700671','announce-frequency','0',0),('18177700671','announce-holdtime','no',0),('18177700671','announce-position','no',0),('18177700379','member','Agent/2000,0',0),('18177700379','member','Agent/2001,0',1),('18177700379','queue-thereare','silence/1',0),('18177700379','queue-callswaiting','silence/1',0),('18177700379','queue-thankyou','',0),('18177700379','periodic-announce-frequency','0',0),('18177700379','monitor-format','',0),('18177700379','monitor-join','yes',0),('18177700379','eventwhencalled','no',0),('18177700379','eventmemberstatus','no',0),('18177700379','weight','0',0),('18177700379','autofill','no',0),('18177700379','ringinuse','yes',0),('18177700379','reportholdtime','no',0),('18177700379','autopause','no',0),('18177700379','autopausedelay','0',0),('18177700379','servicelevel','60',0),('18177700379','memberdelay','0',0),('18177700379','timeoutrestart','no',0),('18177700379','skip_joinannounce','',0),('18177700379','cron_schedule','never',0),('18177700379','autopausebusy','no',0),('18177700379','autopauseunavail','no',0),('18177700379','timeoutpriority','app',0),('18177700379','penaltymemberslimit','0',0),('18177700379','answered_elsewhere','0',0),('18177700379','maxlen','0',0),('18177700379','joinempty','yes',0),('18177700379','leavewhenempty','no',0),('18177700379','strategy','random',0),('18177700673','member','Agent/2008,0',8),('18177700673','member','Agent/2007,0',7),('18177700673','monitor-format','',0),('18177700673','monitor-join','yes',0),('18177700673','eventwhencalled','no',0),('18177700673','eventmemberstatus','no',0),('18177700673','weight','0',0),('18177700673','autofill','no',0),('18177700673','ringinuse','yes',0),('18177700673','reportholdtime','no',0),('18177700673','autopause','no',0),('18177700673','autopausedelay','0',0),('18177700673','servicelevel','60',0),('18177700673','memberdelay','0',0),('18177700673','timeoutrestart','no',0),('18177700673','skip_joinannounce','',0),('18177700673','cron_schedule','never',0),('18177700673','autopausebusy','no',0),('18177700673','autopauseunavail','no',0),('18177700673','timeout','0',0),('18177700673','retry','5',0),('18177700673','wrapuptime','0',0),('18177700673','announce-frequency','0',0),('18177700673','announce-holdtime','no',0),('18177700673','announce-position','no',0),('18177700673','queue-youarenext','silence/1',0),('18177700673','queue-thereare','silence/1',0),('18177700673','queue-callswaiting','silence/1',0),('18177700673','queue-thankyou','',0),('18177700673','periodic-announce-frequency','0',0),('18147773872','maxlen','0',0),('18177700674','member','Agent/2002,0',2),('18177700674','member','Agent/2001,0',1),('18177700674','timeoutrestart','no',0),('18177700674','skip_joinannounce','',0),('18177700674','cron_schedule','never',0),('18177700674','autopausebusy','no',0),('18177700674','autopauseunavail','no',0),('18177700674','timeoutpriority','app',0),('18177700674','penaltymemberslimit','0',0),('18177700674','answered_elsewhere','0',0),('18177700674','wrapuptime','0',0),('18177700674','announce-frequency','0',0),('18177700674','announce-holdtime','no',0),('18177700674','announce-position','no',0),('18177700674','queue-youarenext','silence/1',0),('18177700674','queue-thereare','silence/1',0),('18177700674','queue-callswaiting','silence/1',0),('18177700674','queue-thankyou','',0),('18177700674','periodic-announce-frequency','0',0),('18177700674','monitor-format','',0),('18177700674','monitor-join','yes',0),('18177700674','eventwhencalled','no',0),('18177700674','eventmemberstatus','no',0),('18177700674','weight','0',0),('18177700674','autofill','no',0),('18177700674','ringinuse','yes',0),('18177700674','reportholdtime','no',0),('18177700674','autopause','no',0),('18177700674','autopausedelay','0',0),('18177700672','member','Agent/2009,0',9),('18177700672','member','Agent/2008,0',8),('18177700672','member','Agent/2007,0',7),('18177700672','member','Agent/2006,0',6),('18177700672','member','Agent/2005,0',5),('18177700672','member','Agent/2003,0',3),('18177700672','member','Agent/2004,0',4),('18177700672','timeoutpriority','app',0),('18177700672','penaltymemberslimit','0',0),('18177700672','answered_elsewhere','0',0),('18177700672','autopausebusy','no',0),('18177700672','autopauseunavail','no',0),('18177700672','autofill','no',0),('18177700672','ringinuse','yes',0),('18177700672','reportholdtime','no',0),('18177700672','autopause','no',0),('18177700672','autopausedelay','0',0),('18177700672','servicelevel','60',0),('18177700672','memberdelay','0',0),('18177700672','timeoutrestart','no',0),('18177700672','skip_joinannounce','',0),('18177700672','cron_schedule','never',0),('18177700672','wrapuptime','0',0),('18177700672','announce-frequency','0',0),('18177700672','announce-holdtime','no',0),('18177700672','announce-position','no',0),('18177700672','queue-youarenext','silence/1',0),('18177700672','queue-thereare','silence/1',0),('18177700672','queue-callswaiting','silence/1',0),('18177700672','queue-thankyou','',0),('18177700672','periodic-announce-frequency','0',0),('18177700672','monitor-format','',0),('18177700672','monitor-join','yes',0),('18177700672','eventwhencalled','no',0),('18177700672','eventmemberstatus','no',0),('18177700672','weight','0',0),('18177700672','maxlen','0',0),('18177700672','joinempty','yes',0),('18177700672','leavewhenempty','no',0),('18177700672','strategy','random',0),('18177700672','timeout','0',0),('18177700672','retry','5',0),('18177700670','member','Agent/2000,0',0),('18147370231','member','Agent/2004,0',4),('18147370231','member','Agent/2005,0',5),('18177700670','weight','0',0),('18177700670','autofill','no',0),('18177700670','ringinuse','yes',0),('18177700670','reportholdtime','no',0),('18177700670','autopause','no',0),('18177700670','autopausedelay','0',0),('18177700670','servicelevel','60',0),('18177700670','memberdelay','0',0),('18177700670','timeoutrestart','no',0),('18177700670','skip_joinannounce','',0),('18177700670','cron_schedule','never',0),('18177700670','autopausebusy','no',0),('18177700670','autopauseunavail','no',0),('18177700670','timeoutpriority','app',0),('18177700670','penaltymemberslimit','0',0),('18177700670','answered_elsewhere','0',0),('18177700670','announce-holdtime','no',0),('18177700670','announce-position','no',0),('18177700670','queue-youarenext','silence/1',0),('18177700670','queue-thereare','silence/1',0),('18177700670','queue-callswaiting','silence/1',0),('18177700670','queue-thankyou','',0),('18177700670','periodic-announce-frequency','0',0),('18177700670','monitor-format','',0),('18177700670','monitor-join','yes',0),('18177700670','eventwhencalled','no',0),('18177700670','eventmemberstatus','no',0),('18177700670','maxlen','0',0),('18177700670','joinempty','yes',0),('18177700670','leavewhenempty','no',0),('18177700670','strategy','random',0),('18177700670','timeout','0',0),('18177700670','retry','5',0),('18177700670','wrapuptime','0',0),('18177700670','announce-frequency','0',0),('18177700100','member','Agent/2003,0',3),('18177700675','eventwhencalled','no',0),('18177700675','eventmemberstatus','no',0),('18177700675','weight','0',0),('18177700675','autofill','no',0),('18177700675','ringinuse','yes',0),('18177700675','reportholdtime','no',0),('18177700675','queue-thankyou','',0),('18177700675','periodic-announce-frequency','0',0),('18177700675','monitor-format','',0),('18177700675','monitor-join','yes',0),('18177700675','queue-callswaiting','silence/1',0),('18177700675','servicelevel','60',0),('18177700675','memberdelay','0',0),('18177700675','maxlen','0',0),('18177700675','joinempty','yes',0),('18177700675','leavewhenempty','no',0),('18177700675','strategy','random',0),('18177700675','timeout','0',0),('18177700675','retry','5',0),('18177700675','wrapuptime','0',0),('18177700675','announce-frequency','0',0),('18177700675','announce-holdtime','no',0),('18177700675','announce-position','no',0),('18177700675','queue-youarenext','silence/1',0),('18177700675','queue-thereare','silence/1',0),('108177700100','member','Agent/2004,0',4),('108177700100','member','Agent/2003,0',3),('108177700100','member','Agent/2002,0',2),('108177700100','member','Agent/2001,0',1),('108177700100','member','Agent/2000,0',0),('18177700676','autopausedelay','0',0),('18177700676','servicelevel','60',0),('18177700676','memberdelay','0',0),('18177700676','timeoutrestart','no',0),('18177700676','skip_joinannounce','',0),('18177700676','cron_schedule','never',0),('18177700676','autopausebusy','no',0),('18177700676','autopauseunavail','no',0),('18177700676','timeoutpriority','app',0),('18177700676','penaltymemberslimit','0',0),('18177700676','answered_elsewhere','0',0),('18177700676','member','Agent/2000,0',0),('18177700676','member','Agent/2001,0',1),('18177700676','queue-thankyou','',0),('18177700676','periodic-announce-frequency','0',0),('18177700676','monitor-format','',0),('18177700676','monitor-join','yes',0),('18177700676','queue-youarenext','silence/1',0),('18177700676','queue-thereare','silence/1',0),('18177700676','queue-callswaiting','silence/1',0),('18177700676','maxlen','0',0),('18177700676','joinempty','yes',0),('18177700676','leavewhenempty','no',0),('18177700676','strategy','random',0),('18177700676','timeout','0',0),('18177700676','retry','5',0),('18177700676','wrapuptime','0',0),('18177700676','announce-frequency','0',0),('18177700676','announce-holdtime','no',0),('18177700676','announce-position','no',0),('18177700377','member','Agent/2000,0',0),('18177700377','member','Agent/2001,0',1),('18177700377','queue-thereare','silence/1',0),('18177700377','queue-callswaiting','silence/1',0),('18177700377','queue-thankyou','',0),('18177700377','periodic-announce-frequency','0',0),('18177700377','monitor-format','',0),('18177700377','monitor-join','yes',0),('18177700377','eventwhencalled','no',0),('18177700377','eventmemberstatus','no',0),('18177700377','weight','0',0),('18177700377','autofill','no',0),('18177700377','ringinuse','yes',0),('18177700377','reportholdtime','no',0),('18177700377','autopause','no',0),('18177700377','autopausedelay','0',0),('18177700377','servicelevel','60',0),('18177700377','memberdelay','0',0),('18177700377','timeoutrestart','no',0),('18177700377','skip_joinannounce','',0),('18177700377','cron_schedule','never',0),('18177700377','autopausebusy','no',0),('18177700377','autopauseunavail','no',0),('18177700377','timeoutpriority','app',0),('18177700377','penaltymemberslimit','0',0),('18177700377','answered_elsewhere','0',0),('18177700377','maxlen','0',0),('18177700377','joinempty','yes',0),('18177700377','leavewhenempty','no',0),('18177700377','strategy','random',0),('18177700107','autopausedelay','0',0),('18177700107','servicelevel','60',0),('18177700107','memberdelay','0',0),('18177700107','timeoutrestart','no',0),('18177700107','skip_joinannounce','',0),('18177700107','cron_schedule','never',0),('18177700107','autopausebusy','no',0),('18177700107','autopauseunavail','no',0),('18177700107','timeoutpriority','app',0),('18177700107','penaltymemberslimit','0',0),('18177700107','answered_elsewhere','0',0),('18177700107','member','Agent/2000,0',0),('18177700107','member','Agent/2001,0',1),('18177700107','queue-thankyou','',0),('18177700107','periodic-announce-frequency','0',0),('18177700107','monitor-format','',0),('18177700107','monitor-join','yes',0),('18177700107','queue-youarenext','silence/1',0),('18177700107','queue-thereare','silence/1',0),('18177700107','queue-callswaiting','silence/1',0),('18177700107','maxlen','0',0),('18177700107','joinempty','yes',0),('18177700107','leavewhenempty','no',0),('18177700107','strategy','random',0),('18177700107','timeout','0',0),('18177700107','retry','5',0),('18177700107','wrapuptime','0',0),('18177700107','announce-frequency','0',0),('18177700107','announce-holdtime','no',0),('18177700107','announce-position','no',0),('18147370233','member','Agent/2007,0',7),('18147370233','member','Agent/2008,0',8),('18147370233','timeout','0',0),('18147370233','retry','5',0),('18147370233','wrapuptime','0',0),('18147370233','announce-frequency','0',0),('18147370233','announce-holdtime','no',0),('18147370233','announce-position','no',0),('18147370244','member','Agent/2000,0',0),('18147370244','member','Agent/2001,0',1),('18147370244','queue-thereare','silence/1',0),('18147370244','queue-callswaiting','silence/1',0),('18147370244','queue-thankyou','',0),('18147370244','periodic-announce-frequency','0',0),('18147370244','monitor-format','',0),('18147370244','monitor-join','yes',0),('18147370244','eventwhencalled','no',0),('18147370244','eventmemberstatus','no',0),('18147370244','weight','0',0),('18147370244','autofill','no',0),('18147370244','ringinuse','yes',0),('18147370244','reportholdtime','no',0),('18147370244','autopause','no',0),('18147370244','autopausedelay','0',0),('18147370244','servicelevel','60',0),('18147370244','memberdelay','0',0),('18147370244','timeoutrestart','no',0),('18147370244','skip_joinannounce','',0),('18147370244','cron_schedule','never',0),('18147370244','autopausebusy','no',0),('18147370244','autopauseunavail','no',0),('18147370244','timeoutpriority','app',0),('18147370244','penaltymemberslimit','0',0),('18147370244','answered_elsewhere','0',0),('18147370244','maxlen','0',0),('18147370244','joinempty','yes',0),('18147370244','leavewhenempty','no',0),('18147370244','strategy','random',0),('18177700677','autopausedelay','0',0),('18177700677','servicelevel','60',0),('18177700677','memberdelay','0',0),('18177700677','timeoutrestart','no',0),('18177700677','skip_joinannounce','',0),('18177700677','cron_schedule','never',0),('18177700677','autopausebusy','no',0),('18177700677','autopauseunavail','no',0),('18177700677','timeoutpriority','app',0),('18177700677','penaltymemberslimit','0',0),('18177700677','answered_elsewhere','0',0),('18177700677','member','Agent/2000,0',0),('18177700677','member','Agent/2001,0',1),('18177700677','queue-thankyou','',0),('18177700677','periodic-announce-frequency','0',0),('18177700677','monitor-format','',0),('18177700677','monitor-join','yes',0),('18177700677','queue-youarenext','silence/1',0),('18177700677','queue-thereare','silence/1',0),('18177700677','queue-callswaiting','silence/1',0),('18177700677','maxlen','0',0),('18177700677','joinempty','yes',0),('18177700677','leavewhenempty','no',0),('18177700677','strategy','random',0),('18177700677','timeout','0',0),('18177700677','retry','5',0),('18177700677','wrapuptime','0',0),('18177700677','announce-frequency','0',0),('18177700677','announce-holdtime','no',0),('18177700677','announce-position','no',0),('18177700678','autopausedelay','0',0),('18177700678','servicelevel','60',0),('18177700678','memberdelay','0',0),('18177700678','timeoutrestart','no',0),('18177700678','skip_joinannounce','',0),('18177700678','cron_schedule','never',0),('18177700678','autopausebusy','no',0),('18177700678','autopauseunavail','no',0),('18177700678','timeoutpriority','app',0),('18177700678','penaltymemberslimit','0',0),('18177700678','answered_elsewhere','0',0),('18177700678','member','Agent/2000,0',0),('18177700678','member','Agent/2001,0',1),('18177700678','queue-thankyou','',0),('18177700678','periodic-announce-frequency','0',0),('18177700678','monitor-format','',0),('18177700678','monitor-join','yes',0),('18177700678','queue-youarenext','silence/1',0),('18177700678','queue-thereare','silence/1',0),('18177700678','queue-callswaiting','silence/1',0),('18177700678','maxlen','0',0),('18177700678','joinempty','yes',0),('18177700678','leavewhenempty','no',0),('18177700678','strategy','random',0),('18177700678','timeout','0',0),('18177700678','retry','5',0),('18177700678','wrapuptime','0',0),('18177700678','announce-frequency','0',0),('18177700678','announce-holdtime','no',0),('18177700678','announce-position','no',0),('18177700679','autopausedelay','0',0),('18177700679','servicelevel','60',0),('18177700679','memberdelay','0',0),('18177700679','timeoutrestart','no',0),('18177700679','skip_joinannounce','',0),('18177700679','cron_schedule','never',0),('18177700679','autopausebusy','no',0),('18177700679','autopauseunavail','no',0),('18177700679','timeoutpriority','app',0),('18177700679','penaltymemberslimit','0',0),('18177700679','answered_elsewhere','0',0),('18177700679','member','Agent/2000,0',0),('18177700679','member','Agent/2001,0',1),('18177700679','queue-thankyou','',0),('18177700679','periodic-announce-frequency','0',0),('18177700679','monitor-format','',0),('18177700679','monitor-join','yes',0),('18177700679','queue-youarenext','silence/1',0),('18177700679','queue-thereare','silence/1',0),('18177700679','queue-callswaiting','silence/1',0),('18177700679','maxlen','0',0),('18177700679','joinempty','yes',0),('18177700679','leavewhenempty','no',0),('18177700679','strategy','random',0),('18177700679','timeout','0',0),('18177700679','retry','5',0),('18177700679','wrapuptime','0',0),('18177700679','announce-frequency','0',0),('18177700679','announce-holdtime','no',0),('18177700679','announce-position','no',0),('18177700680','autopausedelay','0',0),('18177700680','servicelevel','60',0),('18177700680','memberdelay','0',0),('18177700680','timeoutrestart','no',0),('18177700680','skip_joinannounce','',0),('18177700680','cron_schedule','never',0),('18177700680','autopausebusy','no',0),('18177700680','autopauseunavail','no',0),('18177700680','timeoutpriority','app',0),('18177700680','penaltymemberslimit','0',0),('18177700680','answered_elsewhere','0',0),('18177700680','member','Agent/2000,0',0),('18177700680','member','Agent/2001,0',1),('18177700680','queue-thankyou','',0),('18177700680','periodic-announce-frequency','0',0),('18177700680','monitor-format','',0),('18177700680','monitor-join','yes',0),('18177700680','queue-youarenext','silence/1',0),('18177700680','queue-thereare','silence/1',0),('18177700680','queue-callswaiting','silence/1',0),('18177700680','maxlen','0',0),('18177700680','joinempty','yes',0),('18177700680','leavewhenempty','no',0),('18177700680','strategy','random',0),('18177700680','timeout','0',0),('18177700680','retry','5',0),('18177700680','wrapuptime','0',0),('18177700680','announce-frequency','0',0),('18177700680','announce-holdtime','no',0),('18177700680','announce-position','no',0),('18177700681','autopausedelay','0',0),('18177700681','servicelevel','60',0),('18177700681','memberdelay','0',0),('18177700681','timeoutrestart','no',0),('18177700681','skip_joinannounce','',0),('18177700681','cron_schedule','never',0),('18177700681','autopausebusy','no',0),('18177700681','autopauseunavail','no',0),('18177700681','timeoutpriority','app',0),('18177700681','penaltymemberslimit','0',0),('18177700681','answered_elsewhere','0',0),('18177700681','member','Agent/2000,0',0),('18177700681','member','Agent/2001,0',1),('18177700681','queue-thankyou','',0),('18177700681','periodic-announce-frequency','0',0),('18177700681','monitor-format','',0),('18177700681','monitor-join','yes',0),('18177700681','queue-youarenext','silence/1',0),('18177700681','queue-thereare','silence/1',0),('18177700681','queue-callswaiting','silence/1',0),('18177700681','maxlen','0',0),('18177700681','joinempty','yes',0),('18177700681','leavewhenempty','no',0),('18177700681','strategy','random',0),('18177700681','timeout','0',0),('18177700681','retry','5',0),('18177700681','wrapuptime','0',0),('18177700681','announce-frequency','0',0),('18177700681','announce-holdtime','no',0),('18177700681','announce-position','no',0),('18177700682','member','Agent/2007,0',7),('18177700682','member','Agent/2003,0',3),('18177700682','member','Agent/2004,0',4),('18177700682','periodic-announce-frequency','0',0),('18177700682','monitor-format','',0),('18177700682','monitor-join','yes',0),('18177700682','eventwhencalled','no',0),('18177700682','eventmemberstatus','no',0),('18177700682','weight','0',0),('18177700682','autofill','no',0),('18177700682','ringinuse','yes',0),('18177700682','reportholdtime','no',0),('18177700682','autopause','no',0),('18177700682','autopausedelay','0',0),('18177700682','servicelevel','60',0),('18177700682','memberdelay','0',0),('18177700682','timeoutrestart','no',0),('18177700682','skip_joinannounce','',0),('18177700682','cron_schedule','never',0),('18177700682','autopausebusy','no',0),('18177700682','autopauseunavail','no',0),('18177700682','timeoutpriority','app',0),('18177700682','penaltymemberslimit','0',0),('18177700682','answered_elsewhere','0',0),('18177700682','member','Agent/2000,0',0),('18177700682','member','Agent/2001,0',1),('18177700682','member','Agent/2002,0',2),('18177700682','maxlen','0',0),('18177700682','joinempty','yes',0),('18177700682','leavewhenempty','no',0),('18177700682','strategy','random',0),('18177700683','member','Agent/2000,0',0),('18177700683','member','Agent/2001,0',1),('18177700683','queue-thereare','silence/1',0),('18177700683','queue-callswaiting','silence/1',0),('18177700683','queue-thankyou','',0),('18177700683','periodic-announce-frequency','0',0),('18177700683','monitor-format','',0),('18177700683','monitor-join','yes',0),('18177700683','eventwhencalled','no',0),('18177700683','eventmemberstatus','no',0),('18177700683','weight','0',0),('18177700683','autofill','no',0),('18177700683','ringinuse','yes',0),('18177700683','reportholdtime','no',0),('18177700683','autopause','no',0),('18177700683','autopausedelay','0',0),('18177700683','servicelevel','60',0),('18177700683','memberdelay','0',0),('18177700683','timeoutrestart','no',0),('18177700683','skip_joinannounce','',0),('18177700683','cron_schedule','never',0),('18177700683','autopausebusy','no',0),('18177700683','autopauseunavail','no',0),('18177700683','timeoutpriority','app',0),('18177700683','penaltymemberslimit','0',0),('18177700683','answered_elsewhere','0',0),('18177700683','maxlen','0',0),('18177700683','joinempty','yes',0),('18177700683','leavewhenempty','no',0),('18177700683','strategy','random',0),('18177700684','autopausedelay','0',0),('18177700684','servicelevel','60',0),('18177700684','memberdelay','0',0),('18177700684','timeoutrestart','no',0),('18177700684','skip_joinannounce','',0),('18177700684','cron_schedule','never',0),('18177700684','autopausebusy','no',0),('18177700684','autopauseunavail','no',0),('18177700684','timeoutpriority','app',0),('18177700684','penaltymemberslimit','0',0),('18177700684','answered_elsewhere','0',0),('18177700684','member','Agent/2000,0',0),('18177700684','member','Agent/2001,0',1),('18177700684','queue-thankyou','',0),('18177700684','periodic-announce-frequency','0',0),('18177700684','monitor-format','',0),('18177700684','monitor-join','yes',0),('18177700684','queue-youarenext','silence/1',0),('18177700684','queue-thereare','silence/1',0),('18177700684','queue-callswaiting','silence/1',0),('18177700684','maxlen','0',0),('18177700684','joinempty','yes',0),('18177700684','leavewhenempty','no',0),('18177700684','strategy','random',0),('18177700684','timeout','0',0),('18177700684','retry','5',0),('18177700684','wrapuptime','0',0),('18177700684','announce-frequency','0',0),('18177700684','announce-holdtime','no',0),('18177700684','announce-position','no',0),('18177700685','autopausedelay','0',0),('18177700685','servicelevel','60',0),('18177700685','memberdelay','0',0),('18177700685','timeoutrestart','no',0),('18177700685','skip_joinannounce','',0),('18177700685','cron_schedule','never',0),('18177700685','autopausebusy','no',0),('18177700685','autopauseunavail','no',0),('18177700685','timeoutpriority','app',0),('18177700685','penaltymemberslimit','0',0),('18177700685','answered_elsewhere','0',0),('18177700685','member','Agent/2000,0',0),('18177700685','member','Agent/2001,0',1),('18177700685','queue-thankyou','',0),('18177700685','periodic-announce-frequency','0',0),('18177700685','monitor-format','',0),('18177700685','monitor-join','yes',0),('18177700685','queue-youarenext','silence/1',0),('18177700685','queue-thereare','silence/1',0),('18177700685','queue-callswaiting','silence/1',0),('18177700685','maxlen','0',0),('18177700685','joinempty','yes',0),('18177700685','leavewhenempty','no',0),('18177700685','strategy','random',0),('18177700685','timeout','0',0),('18177700685','retry','5',0),('18177700685','wrapuptime','0',0),('18177700685','announce-frequency','0',0),('18177700685','announce-holdtime','no',0),('18177700685','announce-position','no',0),('18177700686','member','Agent/2007,0',7),('18177700686','member','Agent/2003,0',3),('18177700686','member','Agent/2004,0',4),('18177700686','periodic-announce-frequency','0',0),('18177700686','monitor-format','',0),('18177700686','monitor-join','yes',0),('18177700686','eventwhencalled','no',0),('18177700686','eventmemberstatus','no',0),('18177700686','weight','0',0),('18177700686','autofill','no',0),('18177700686','ringinuse','yes',0),('18177700686','reportholdtime','no',0),('18177700686','autopause','no',0),('18177700686','autopausedelay','0',0),('18177700686','servicelevel','60',0),('18177700686','memberdelay','0',0),('18177700686','timeoutrestart','no',0),('18177700686','skip_joinannounce','',0),('18177700686','cron_schedule','never',0),('18177700686','autopausebusy','no',0),('18177700686','autopauseunavail','no',0),('18177700686','timeoutpriority','app',0),('18177700686','penaltymemberslimit','0',0),('18177700686','answered_elsewhere','0',0),('18177700686','member','Agent/2000,0',0),('18177700686','member','Agent/2001,0',1),('18177700686','member','Agent/2002,0',2),('18177700686','maxlen','0',0),('18177700686','joinempty','yes',0),('18177700686','leavewhenempty','no',0),('18177700686','strategy','random',0),('18177700687','member','Agent/2007,0',7),('18177700687','member','Agent/2000,0',0),('18177700687','member','Agent/2001,0',1),('18177700687','member','Agent/2002,0',2),('18177700687','penaltymemberslimit','0',0),('18177700687','answered_elsewhere','0',0),('18177700687','periodic-announce-frequency','0',0),('18177700687','monitor-format','',0),('18177700687','monitor-join','yes',0),('18177700687','eventwhencalled','no',0),('18177700687','eventmemberstatus','no',0),('18177700687','weight','0',0),('18177700687','autofill','no',0),('18177700687','ringinuse','yes',0),('18177700687','reportholdtime','no',0),('18177700687','autopause','no',0),('18177700687','autopausedelay','0',0),('18177700687','servicelevel','60',0),('18177700687','memberdelay','0',0),('18177700687','timeoutrestart','no',0),('18177700687','skip_joinannounce','',0),('18177700687','cron_schedule','never',0),('18177700687','autopausebusy','no',0),('18177700687','autopauseunavail','no',0),('18177700687','timeoutpriority','app',0),('18177700687','announce-holdtime','no',0),('18177700687','announce-position','no',0),('18177700687','queue-youarenext','silence/1',0),('18177700687','queue-thereare','silence/1',0),('18177700687','queue-callswaiting','silence/1',0),('18177700687','queue-thankyou','',0),('18177700687','maxlen','0',0),('18177700687','joinempty','yes',0),('18177700687','leavewhenempty','no',0),('18177700687','strategy','random',0),('18177700687','timeout','0',0),('18177700687','retry','5',0),('18177700687','wrapuptime','0',0),('18177700687','announce-frequency','0',0),('18177700688','autopausedelay','0',0),('18177700688','servicelevel','60',0),('18177700688','memberdelay','0',0),('18177700688','timeoutrestart','no',0),('18177700688','skip_joinannounce','',0),('18177700688','cron_schedule','never',0),('18177700688','autopausebusy','no',0),('18177700688','autopauseunavail','no',0),('18177700688','timeoutpriority','app',0),('18177700688','penaltymemberslimit','0',0),('18177700688','answered_elsewhere','0',0),('18177700688','member','Agent/2000,0',0),('18177700688','member','Agent/2001,0',1),('18177700688','queue-thankyou','',0),('18177700688','periodic-announce-frequency','0',0),('18177700688','monitor-format','',0),('18177700688','monitor-join','yes',0),('18177700688','queue-youarenext','silence/1',0),('18177700688','queue-thereare','silence/1',0),('18177700688','queue-callswaiting','silence/1',0),('18177700688','maxlen','0',0),('18177700688','joinempty','yes',0),('18177700688','leavewhenempty','no',0),('18177700688','strategy','random',0),('18177700688','timeout','0',0),('18177700688','retry','5',0),('18177700688','wrapuptime','0',0),('18177700688','announce-frequency','0',0),('18177700688','announce-holdtime','no',0),('18177700688','announce-position','no',0),('105588804680','member','Agent/2002,0',2),('103335605355','member','Agent/2009,0',9),('103335605355','member','Agent/2008,0',8),('103335605355','member','Agent/2007,0',7),('103335605355','member','Agent/2006,0',6),('103335605355','member','Agent/2005,0',5),('105588804680','member','Agent/2003,0',3),('105588804680','member','Agent/2004,0',4),('105588804680','member','Agent/2005,0',5),('105588804680','member','Agent/2006,0',6),('105588804680','member','Agent/2007,0',7),('108177700100','autopause','no',0),('108177700100','autopausedelay','0',0),('108177700100','servicelevel','60',0),('12226443774','member','Agent/2006,0',6),('113335605355','member','Agent/2009,0',9),('113335605355','member','Agent/2008,0',8),('113335605355','member','Agent/2007,0',7),('113335605355','member','Agent/2006,0',6),('113335605355','member','Agent/2005,0',5),('113335605355','member','Agent/2004,0',4),('12226443774','member','Agent/2007,0',7),('115588804680','member','Agent/2009,0',9),('115588804680','member','Agent/2008,0',8),('115588804680','member','Agent/2007,0',7),('115588804680','member','Agent/2006,0',6),('115588804680','member','Agent/2005,0',5),('115588804680','member','Agent/2004,0',4),('12226443774','member','Agent/2008,0',8),('118177700100','member','Agent/2009,0',9),('118177700100','member','Agent/2008,0',8),('118177700100','member','Agent/2007,0',7),('118177700100','member','Agent/2006,0',6),('118177700100','member','Agent/2005,0',5),('118177700100','member','Agent/2004,0',4),('12226443774','member','Agent/2009,0',9),('18177700699','member','Agent/2005,0',4),('12226443774','timeout','0',0),('12226443774','retry','5',0),('12226443774','wrapuptime','0',0),('12226443774','announce-frequency','0',0),('12226443774','announce-holdtime','no',0),('12226443774','announce-position','no',0),('12226443774','queue-youarenext','silence/1',0),('128177700100','member','Agent/2008,0',8),('123335605355','member','Agent/2009,0',9),('123335605355','member','Agent/2008,0',8),('123335605355','member','Agent/2007,0',7),('123335605355','member','Agent/2006,0',6),('123335605355','member','Agent/2005,0',5),('123335605355','member','Agent/2004,0',4),('128177700100','member','Agent/2007,0',7),('125588804680','member','Agent/2009,0',9),('125588804680','member','Agent/2008,0',8),('125588804680','member','Agent/2007,0',7),('125588804680','member','Agent/2006,0',6),('125588804680','member','Agent/2005,0',5),('125588804680','member','Agent/2004,0',4),('105588804680','member','Agent/2001,0',1),('128177700100','member','Agent/2001,0',1),('128177700100','member','Agent/2002,0',2),('128177700100','member','Agent/2003,0',3),('128177700100','member','Agent/2004,0',4),('98147370215','member','Agent/2005,0',5),('98147370215','member','Agent/2006,0',6),('133335605355','member','Agent/2001,0',1),('133335605355','member','Agent/2002,0',2),('133335605355','member','Agent/2003,0',3),('133335605355','member','Agent/2004,0',4),('58177700100','penaltymemberslimit','0',0),('58177700100','answered_elsewhere','0',0),('135588804680','member','Agent/2001,0',1),('135588804680','member','Agent/2002,0',2),('135588804680','member','Agent/2003,0',3),('135588804680','member','Agent/2004,0',4),('138177700100','member','Agent/2009,0',9),('138177700100','member','Agent/2008,0',8),('138177700100','member','Agent/2007,0',7),('138177700100','member','Agent/2006,0',6),('138177700100','member','Agent/2005,0',5),('138177700100','member','Agent/2004,0',4),('15589958531','member','Agent/2005,0',5),('15589958531','eventwhencalled','no',0),('15589958531','eventmemberstatus','no',0),('15589958531','weight','0',0),('15589958531','autofill','no',0),('15589958531','ringinuse','yes',0),('15589958531','reportholdtime','no',0),('15589958531','autopause','no',0),('15589958531','member','Agent/2004,0',4),('15589958531','member','Agent/2003,0',3),('15589958531','member','Agent/2002,0',2),('15589958532','member','Agent/2005,0',5),('15589958532','eventwhencalled','no',0),('15589958532','eventmemberstatus','no',0),('15589958532','weight','0',0),('15589958532','autofill','no',0),('15589958532','ringinuse','yes',0),('15589958532','reportholdtime','no',0),('15589958532','autopause','no',0),('15589958532','member','Agent/2004,0',4),('15589958532','member','Agent/2003,0',3),('15589958532','member','Agent/2002,0',2),('15589958533','member','Agent/2005,0',5),('15589958533','eventwhencalled','no',0),('15589958533','eventmemberstatus','no',0),('15589958533','weight','0',0),('15589958533','autofill','no',0),('15589958533','ringinuse','yes',0),('15589958533','reportholdtime','no',0),('15589958533','autopause','no',0),('15589958533','member','Agent/2004,0',4),('15589958533','member','Agent/2003,0',3),('15589958533','member','Agent/2002,0',2),('18147370215','member','Agent/2009,0',9),('18147370216','member','Agent/2002,0',2),('18147370216','member','Agent/2001,0',1),('18147370217','member','Agent/2005,0',5),('18147370217','eventwhencalled','no',0),('18147370217','eventmemberstatus','no',0),('18147370217','weight','0',0),('18147370217','autofill','no',0),('18147370217','ringinuse','yes',0),('18147370217','reportholdtime','no',0),('18147370217','autopause','no',0),('18147370217','member','Agent/2004,0',4),('18147370217','member','Agent/2003,0',3),('18147370217','member','Agent/2002,0',2),('18147370218','member','Agent/2004,0',4),('18147370218','member','Agent/2005,0',5),('18147370218','servicelevel','60',0),('18147370218','memberdelay','0',0),('18147370218','maxlen','0',0),('18147370218','joinempty','yes',0),('18147370218','leavewhenempty','no',0),('18147370218','strategy','random',0),('18147370218','timeout','0',0),('18147370218','retry','5',0),('18147370221','penaltymemberslimit','0',0),('18147370221','answered_elsewhere','0',0),('18147370221','member','Agent/2006,0',6),('18147370221','member','Agent/2005,0',5),('18147370221','member','Agent/2004,0',4),('18147370221','member','Agent/2003,0',3),('18147370221','member','Agent/2002,0',2),('18147370221','member','Agent/2001,0',1),('18147370221','member','Agent/2000,0',0),('18147370224','member','Agent/2006,0',6),('18147370224','member','Agent/2005,0',5),('18147370224','member','Agent/2004,0',4),('18147370224','member','Agent/2003,0',3),('18147370224','member','Agent/2002,0',2),('18147370224','member','Agent/2001,0',1),('18147370226','member','Agent/2006,0',6),('18147370226','member','Agent/2005,0',5),('18147370226','member','Agent/2004,0',4),('18147370226','member','Agent/2003,0',3),('18147370226','member','Agent/2002,0',2),('18147370226','member','Agent/2001,0',1),('18147370227','member','Agent/2006,0',6),('18147370227','member','Agent/2005,0',5),('18147370227','member','Agent/2004,0',4),('18147370227','member','Agent/2003,0',3),('18147370227','member','Agent/2002,0',2),('18147370227','member','Agent/2001,0',1),('18147370229','member','Agent/2005,0',5),('18147370229','eventwhencalled','no',0),('18147370229','eventmemberstatus','no',0),('18147370229','weight','0',0),('18147370229','autofill','no',0),('18147370229','ringinuse','yes',0),('18147370229','reportholdtime','no',0),('18147370229','autopause','no',0),('18147370229','member','Agent/2004,0',4),('18147370229','member','Agent/2003,0',3),('18147370229','member','Agent/2002,0',2),('18147370230','eventwhencalled','no',0),('18147370230','eventmemberstatus','no',0),('18147370230','weight','0',0),('18147370230','autofill','no',0),('18147370230','ringinuse','yes',0),('18147370230','reportholdtime','no',0),('18147370230','autopause','no',0),('18147370230','member','Agent/2002,0',2),('18147370230','member','Agent/2001,0',1),('18147370231','member','Agent/2003,0',3),('18147370231','member','Agent/2002,0',2),('18147370231','member','Agent/2001,0',1),('18147370231','servicelevel','60',0),('18147370231','memberdelay','0',0),('18147370231','maxlen','0',0),('18147370231','joinempty','yes',0),('18147370231','leavewhenempty','no',0),('18147370231','strategy','random',0),('18147370231','timeout','0',0),('18147370231','retry','5',0),('18147370232','member','Agent/2005,0',5),('18147370232','eventwhencalled','no',0),('18147370232','eventmemberstatus','no',0),('18147370232','weight','0',0),('18147370232','autofill','no',0),('18147370232','ringinuse','yes',0),('18147370232','reportholdtime','no',0),('18147370232','autopause','no',0),('18147370232','member','Agent/2004,0',4),('18147370232','member','Agent/2003,0',3),('18147370232','member','Agent/2002,0',2),('18147370233','member','Agent/2006,0',6),('18147370233','member','Agent/2005,0',5),('18147370233','member','Agent/2004,0',4),('18147370233','member','Agent/2003,0',3),('18147370233','member','Agent/2002,0',2),('18147370233','member','Agent/2001,0',1),('18147370234','member','Agent/2005,0',5),('18147370234','eventwhencalled','no',0),('18147370234','eventmemberstatus','no',0),('18147370234','weight','0',0),('18147370234','autofill','no',0),('18147370234','ringinuse','yes',0),('18147370234','reportholdtime','no',0),('18147370234','autopause','no',0),('18147370234','member','Agent/2004,0',4),('18147370234','member','Agent/2003,0',3),('18147370234','member','Agent/2002,0',2),('18147370235','member','Agent/2007,0',7),('18147370235','member','Agent/2008,0',8),('18147370235','timeout','0',0),('18147370235','retry','5',0),('18147370235','wrapuptime','0',0),('18147370235','announce-frequency','0',0),('18147370235','announce-holdtime','no',0),('18147370235','announce-position','no',0),('18147370235','queue-youarenext','silence/1',0),('18147370237','member','Agent/2005,0',5),('18147370237','member','Agent/2006,0',6),('18147370237','timeout','0',0),('18147370237','retry','5',0),('18147370237','wrapuptime','0',0),('18147370237','announce-frequency','0',0),('18147370237','announce-holdtime','no',0),('18147370237','announce-position','no',0),('18147370237','queue-youarenext','silence/1',0),('18147370237','queue-thereare','silence/1',0),('18147370237','queue-callswaiting','silence/1',0),('18147370237','queue-thankyou','',0),('18147370238','member','Agent/2005,0',5),('18147370238','member','Agent/2006,0',6),('18147370238','timeout','0',0),('18147370238','retry','5',0),('18147370238','wrapuptime','0',0),('18147370238','announce-frequency','0',0),('18147370238','announce-holdtime','no',0),('18147370238','announce-position','no',0),('18147370238','queue-youarenext','silence/1',0),('18147370238','queue-thereare','silence/1',0),('18147370238','queue-callswaiting','silence/1',0),('18147370238','queue-thankyou','',0),('18147370239','member','Agent/2001,0',1),('18147370239','member','Agent/2000,0',0),('18147370239','answered_elsewhere','0',0),('18147370239','penaltymemberslimit','0',0),('18147370239','timeoutpriority','app',0),('18147370240','member','Agent/2005,0',5),('18147370240','member','Agent/2006,0',6),('18147370240','member','Agent/2007,0',7),('18147370240','member','Agent/2008,0',8),('18147370241','member','Agent/2006,0',6),('18147370241','member','Agent/2005,0',5),('18147370241','member','Agent/2004,0',4),('18147370241','member','Agent/2003,0',3),('18147370241','member','Agent/2002,0',2),('18147370241','member','Agent/2001,0',1),('18147370242','member','Agent/2006,0',6),('18147370242','member','Agent/2005,0',5),('18147370242','member','Agent/2004,0',4),('18147370242','member','Agent/2003,0',3),('18147370242','member','Agent/2002,0',2),('18147370242','member','Agent/2001,0',1),('18147370244','member','Agent/2007,0',7),('18147370244','member','Agent/2008,0',8),('18147370244','timeout','0',0),('18147370244','retry','5',0),('18147370244','wrapuptime','0',0),('18147370244','announce-frequency','0',0),('18147370244','announce-holdtime','no',0),('18147370244','announce-position','no',0),('18147370244','queue-youarenext','silence/1',0),('18147370245','member','Agent/2005,0',5),('18147370245','member','Agent/2006,0',6),('18147370245','member','Agent/2007,0',7),('18147370245','member','Agent/2008,0',8),('18147370246','member','Agent/2006,0',6),('18147370246','member','Agent/2005,0',5),('18147370246','member','Agent/2004,0',4),('18147370246','member','Agent/2003,0',3),('18147370246','member','Agent/2002,0',2),('18147370246','member','Agent/2001,0',1),('18147370247','member','Agent/2006,0',6),('18147370247','member','Agent/2005,0',5),('18147370247','member','Agent/2004,0',4),('18147370247','member','Agent/2003,0',3),('18147370247','member','Agent/2002,0',2),('18147370247','member','Agent/2001,0',1),('18177700692','skip_joinannounce','',0),('18177700101','member','Agent/2008,0',8),('18177700102','member','Agent/2004,0',4),('18177700102','member','Agent/2005,0',5),('18177700102','member','Agent/2006,0',6),('18177700102','member','Agent/2007,0',7),('18177700103','member','Agent/2006,0',6),('18177700103','member','Agent/2005,0',5),('18177700103','member','Agent/2004,0',4),('18177700103','member','Agent/2003,0',3),('18177700103','member','Agent/2002,0',2),('18177700103','member','Agent/2001,0',1),('18177700104','member','Agent/2006,0',6),('18177700104','member','Agent/2005,0',5),('18177700104','member','Agent/2004,0',4),('18177700104','member','Agent/2003,0',3),('18177700104','member','Agent/2002,0',2),('18177700104','member','Agent/2001,0',1),('18177700105','member','Agent/2006,0',6),('18177700105','member','Agent/2005,0',5),('18177700105','member','Agent/2004,0',4),('18177700105','member','Agent/2003,0',3),('18177700105','member','Agent/2002,0',2),('18177700105','member','Agent/2001,0',1),('18177700106','member','Agent/2005,0',5),('18177700106','member','Agent/2006,0',6),('18177700106','member','Agent/2007,0',7),('18177700106','member','Agent/2008,0',8),('18177700107','member','Agent/2005,0',5),('18177700107','eventwhencalled','no',0),('18177700107','eventmemberstatus','no',0),('18177700107','weight','0',0),('18177700107','autofill','no',0),('18177700107','ringinuse','yes',0),('18177700107','reportholdtime','no',0),('18177700107','autopause','no',0),('18177700107','member','Agent/2004,0',4),('18177700107','member','Agent/2003,0',3),('18177700107','member','Agent/2002,0',2),('14428880133','leavewhenempty','no',0),('14428880133','strategy','random',0),('18177700109','member','Agent/2005,0',5),('18177700109','member','Agent/2006,0',6),('18177700112','member','Agent/2004,0',4),('18177700112','member','Agent/2003,0',3),('18177700112','servicelevel','60',0),('18177700112','memberdelay','0',0),('18177700112','maxlen','0',0),('18177700112','joinempty','yes',0),('18177700112','leavewhenempty','no',0),('18177700112','strategy','random',0),('18177700112','timeout','0',0),('18177700112','retry','5',0),('18177700113','member','Agent/2005,0',5),('18177700113','eventwhencalled','no',0),('18177700113','eventmemberstatus','no',0),('18177700113','weight','0',0),('18177700113','autofill','no',0),('18177700113','ringinuse','yes',0),('18177700113','reportholdtime','no',0),('18177700113','autopause','no',0),('18177700113','member','Agent/2004,0',4),('18177700113','member','Agent/2003,0',3),('18177700113','member','Agent/2002,0',2),('18177700114','member','Agent/2005,0',5),('18177700114','eventwhencalled','no',0),('18177700114','eventmemberstatus','no',0),('18177700114','weight','0',0),('18177700114','autofill','no',0),('18177700114','ringinuse','yes',0),('18177700114','reportholdtime','no',0),('18177700114','autopause','no',0),('18177700114','member','Agent/2004,0',4),('18177700114','member','Agent/2003,0',3),('18177700114','member','Agent/2002,0',2),('18177700115','member','Agent/2005,0',5),('18177700115','eventwhencalled','no',0),('18177700115','eventmemberstatus','no',0),('18177700115','weight','0',0),('18177700115','autofill','no',0),('18177700115','ringinuse','yes',0),('18177700115','reportholdtime','no',0),('18177700115','autopause','no',0),('18177700115','member','Agent/2004,0',4),('18177700115','member','Agent/2003,0',3),('18177700115','member','Agent/2002,0',2),('18177700116','member','Agent/2005,0',5),('18177700116','eventwhencalled','no',0),('18177700116','eventmemberstatus','no',0),('18177700116','weight','0',0),('18177700116','autofill','no',0),('18177700116','ringinuse','yes',0),('18177700116','reportholdtime','no',0),('18177700116','autopause','no',0),('18177700116','member','Agent/2004,0',4),('18177700116','member','Agent/2003,0',3),('18177700116','member','Agent/2002,0',2),('18177700117','member','Agent/2005,0',5),('18177700117','member','Agent/2006,0',6),('18177700117','timeout','0',0),('18177700117','retry','5',0),('18177700117','wrapuptime','0',0),('18177700117','announce-frequency','0',0),('18177700117','announce-holdtime','no',0),('18177700117','announce-position','no',0),('18177700117','queue-youarenext','silence/1',0),('18177700117','queue-thereare','silence/1',0),('18177700117','queue-callswaiting','silence/1',0),('18177700117','queue-thankyou','',0),('18177700118','member','Agent/2005,0',5),('18177700118','eventwhencalled','no',0),('18177700118','eventmemberstatus','no',0),('18177700118','weight','0',0),('18177700118','autofill','no',0),('18177700118','ringinuse','yes',0),('18177700118','reportholdtime','no',0),('18177700118','autopause','no',0),('18177700118','member','Agent/2004,0',4),('18177700118','member','Agent/2003,0',3),('18177700118','member','Agent/2002,0',2),('18177700119','member','Agent/2006,0',6),('18177700119','monitor-join','yes',0),('18177700119','eventwhencalled','no',0),('18177700119','eventmemberstatus','no',0),('18177700119','weight','0',0),('18177700119','autofill','no',0),('18177700119','ringinuse','yes',0),('18177700119','reportholdtime','no',0),('18177700119','member','Agent/2005,0',5),('18177700119','member','Agent/2004,0',4),('18177700119','member','Agent/2003,0',3),('18177700120','member','Agent/2009,0',9),('18147773894','maxlen','0',0),('18177700120','timeout','0',0),('18177700120','retry','5',0),('18177700120','wrapuptime','0',0),('18177700120','announce-frequency','0',0),('18177700120','announce-holdtime','no',0),('18177700120','announce-position','no',0),('18177700120','queue-youarenext','silence/1',0),('18177700121','member','Agent/2005,0',5),('18177700121','member','Agent/2006,0',6),('18177700121','timeout','0',0),('18177700121','retry','5',0),('18177700121','wrapuptime','0',0),('18177700121','announce-frequency','0',0),('18177700121','announce-holdtime','no',0),('18177700121','announce-position','no',0),('18177700121','queue-youarenext','silence/1',0),('18177700121','queue-thereare','silence/1',0),('18177700121','queue-callswaiting','silence/1',0),('18177700121','queue-thankyou','',0),('18177700122','member','Agent/2005,0',5),('18177700122','eventwhencalled','no',0),('18177700122','eventmemberstatus','no',0),('18177700122','weight','0',0),('18177700122','autofill','no',0),('18177700122','ringinuse','yes',0),('18177700122','reportholdtime','no',0),('18177700122','autopause','no',0),('18177700122','member','Agent/2004,0',4),('18177700122','member','Agent/2003,0',3),('18177700122','member','Agent/2002,0',2),('18177700123','member','Agent/2005,0',5),('18177700123','eventwhencalled','no',0),('18177700123','eventmemberstatus','no',0),('18177700123','weight','0',0),('18177700123','autofill','no',0),('18177700123','ringinuse','yes',0),('18177700123','reportholdtime','no',0),('18177700123','autopause','no',0),('18177700123','member','Agent/2004,0',4),('18177700123','member','Agent/2003,0',3),('18177700123','member','Agent/2002,0',2),('18177700124','member','Agent/2005,0',5),('18177700124','eventwhencalled','no',0),('18177700124','eventmemberstatus','no',0),('18177700124','weight','0',0),('18177700124','autofill','no',0),('18177700124','ringinuse','yes',0),('18177700124','reportholdtime','no',0),('18177700124','autopause','no',0),('18177700124','member','Agent/2004,0',4),('18177700124','member','Agent/2003,0',3),('18177700124','member','Agent/2002,0',2),('18177700360','member','Agent/2005,0',5),('18177700360','eventwhencalled','no',0),('18177700360','eventmemberstatus','no',0),('18177700360','weight','0',0),('18177700360','autofill','no',0),('18177700360','ringinuse','yes',0),('18177700360','reportholdtime','no',0),('18177700360','autopause','no',0),('18177700360','member','Agent/2004,0',4),('18177700360','member','Agent/2003,0',3),('18177700360','member','Agent/2002,0',2),('18177700361','member','Agent/2005,0',5),('18177700361','eventwhencalled','no',0),('18177700361','eventmemberstatus','no',0),('18177700361','weight','0',0),('18177700361','autofill','no',0),('18177700361','ringinuse','yes',0),('18177700361','reportholdtime','no',0),('18177700361','autopause','no',0),('18177700361','member','Agent/2004,0',4),('18177700361','member','Agent/2003,0',3),('18177700361','member','Agent/2002,0',2),('18177700362','member','Agent/2005,0',5),('18177700362','member','Agent/2006,0',6),('18177700363','member','Agent/2005,0',5),('18177700363','eventwhencalled','no',0),('18177700363','eventmemberstatus','no',0),('18177700363','weight','0',0),('18177700363','autofill','no',0),('18177700363','ringinuse','yes',0),('18177700363','reportholdtime','no',0),('18177700363','autopause','no',0),('18177700363','member','Agent/2004,0',4),('18177700363','member','Agent/2003,0',3),('18177700363','member','Agent/2002,0',2),('18177700364','member','Agent/2005,0',5),('18177700364','eventwhencalled','no',0),('18177700364','eventmemberstatus','no',0),('18177700364','weight','0',0),('18177700364','autofill','no',0),('18177700364','ringinuse','yes',0),('18177700364','reportholdtime','no',0),('18177700364','autopause','no',0),('18177700364','member','Agent/2004,0',4),('18177700364','member','Agent/2003,0',3),('18177700364','member','Agent/2002,0',2),('18177700365','member','Agent/2005,0',5),('18177700365','member','Agent/2004,0',4),('18177700365','member','Agent/2003,0',3),('18177700365','member','Agent/2002,0',2),('18177700366','member','Agent/2005,0',5),('18177700366','eventwhencalled','no',0),('18177700366','eventmemberstatus','no',0),('18177700366','weight','0',0),('18177700366','autofill','no',0),('18177700366','ringinuse','yes',0),('18177700366','reportholdtime','no',0),('18177700366','autopause','no',0),('18177700366','member','Agent/2004,0',4),('18177700366','member','Agent/2003,0',3),('18177700366','member','Agent/2002,0',2),('18177700367','member','Agent/2005,0',5),('18177700367','eventwhencalled','no',0),('18177700367','eventmemberstatus','no',0),('18177700367','weight','0',0),('18177700367','autofill','no',0),('18177700367','ringinuse','yes',0),('18177700367','reportholdtime','no',0),('18177700367','autopause','no',0),('18177700367','member','Agent/2004,0',4),('18177700367','member','Agent/2003,0',3),('18177700367','member','Agent/2002,0',2),('18177700368','member','Agent/2005,0',5),('18177700368','eventwhencalled','no',0),('18177700368','eventmemberstatus','no',0),('18177700368','weight','0',0),('18177700368','autofill','no',0),('18177700368','ringinuse','yes',0),('18177700368','reportholdtime','no',0),('18177700368','autopause','no',0),('18177700368','member','Agent/2004,0',4),('18177700368','member','Agent/2003,0',3),('18177700368','member','Agent/2002,0',2),('18177700369','member','Agent/2000,0',0),('18177700369','answered_elsewhere','0',0),('18177700369','penaltymemberslimit','0',0),('18177700369','timeoutpriority','app',0),('18177700370','member','Agent/2006,0',6),('18177700370','member','Agent/2005,0',5),('18177700370','member','Agent/2004,0',4),('18177700370','member','Agent/2003,0',3),('18177700370','member','Agent/2002,0',2),('18177700371','member','Agent/2005,0',5),('18177700371','eventwhencalled','no',0),('18177700371','eventmemberstatus','no',0),('18177700371','weight','0',0),('18177700371','autofill','no',0),('18177700371','ringinuse','yes',0),('18177700371','reportholdtime','no',0),('18177700371','autopause','no',0),('18177700371','member','Agent/2004,0',4),('18177700371','member','Agent/2003,0',3),('18177700371','member','Agent/2002,0',2),('18177700372','member','Agent/2004,0',4),('18177700372','member','Agent/2005,0',5),('18177700372','member','Agent/2006,0',6),('18177700372','member','Agent/2007,0',7),('18177700372','timeoutpriority','app',0),('18177700373','member','Agent/2005,0',5),('18177700373','eventwhencalled','no',0),('18177700373','eventmemberstatus','no',0),('18177700373','weight','0',0),('18177700373','autofill','no',0),('18177700373','ringinuse','yes',0),('18177700373','reportholdtime','no',0),('18177700373','autopause','no',0),('18177700373','member','Agent/2004,0',4),('18177700373','member','Agent/2003,0',3),('18177700373','member','Agent/2002,0',2),('18177700374','member','Agent/2005,0',5),('18177700374','eventwhencalled','no',0),('18177700374','eventmemberstatus','no',0),('18177700374','weight','0',0),('18177700374','autofill','no',0),('18177700374','ringinuse','yes',0),('18177700374','reportholdtime','no',0),('18177700374','autopause','no',0),('18177700374','member','Agent/2004,0',4),('18177700374','member','Agent/2003,0',3),('18177700374','member','Agent/2002,0',2),('18177700375','member','Agent/2005,0',5),('18177700375','eventwhencalled','no',0),('18177700375','eventmemberstatus','no',0),('18177700375','weight','0',0),('18177700375','autofill','no',0),('18177700375','ringinuse','yes',0),('18177700375','reportholdtime','no',0),('18177700375','autopause','no',0),('18177700375','member','Agent/2004,0',4),('18177700375','member','Agent/2003,0',3),('18177700375','member','Agent/2002,0',2),('18177700376','member','Agent/2000,0',0),('18177700376','answered_elsewhere','0',0),('18177700377','member','Agent/2007,0',7),('18177700377','member','Agent/2008,0',8),('18177700377','timeout','0',0),('18177700377','retry','5',0),('18177700377','wrapuptime','0',0),('18177700377','announce-frequency','0',0),('18177700377','announce-holdtime','no',0),('18177700377','announce-position','no',0),('18177700377','queue-youarenext','silence/1',0),('18177700378','member','Agent/2007,0',7),('18177700378','member','Agent/2008,0',8),('18177700378','timeout','0',0),('18177700378','retry','5',0),('18177700378','wrapuptime','0',0),('18177700378','announce-frequency','0',0),('18177700378','announce-holdtime','no',0),('18177700378','announce-position','no',0),('18177700378','queue-youarenext','silence/1',0),('18177700379','member','Agent/2007,0',7),('18177700379','member','Agent/2008,0',8),('18177700379','timeout','0',0),('18177700379','retry','5',0),('18177700379','wrapuptime','0',0),('18177700379','announce-frequency','0',0),('18177700379','announce-holdtime','no',0),('18177700379','announce-position','no',0),('18177700379','queue-youarenext','silence/1',0),('18177700380','autopauseunavail','no',0),('18177700381','member','Agent/2005,0',5),('18177700381','eventwhencalled','no',0),('18177700381','eventmemberstatus','no',0),('18177700381','weight','0',0),('18177700381','autofill','no',0),('18177700381','ringinuse','yes',0),('18177700381','reportholdtime','no',0),('18177700381','autopause','no',0),('18177700381','member','Agent/2004,0',4),('18177700381','member','Agent/2003,0',3),('18177700381','member','Agent/2002,0',2),('18177700382','member','Agent/2005,0',5),('18177700382','eventwhencalled','no',0),('18177700382','eventmemberstatus','no',0),('18177700382','weight','0',0),('18177700382','autofill','no',0),('18177700382','ringinuse','yes',0),('18177700382','reportholdtime','no',0),('18177700382','autopause','no',0),('18177700382','member','Agent/2004,0',4),('18177700382','member','Agent/2003,0',3),('18177700382','member','Agent/2002,0',2),('18177700383','member','Agent/2005,0',5),('18177700383','member','Agent/2006,0',6),('18177700383','timeout','0',0),('18177700383','retry','5',0),('18177700383','wrapuptime','0',0),('18177700383','announce-frequency','0',0),('18177700383','announce-holdtime','no',0),('18177700383','announce-position','no',0),('18177700383','queue-youarenext','silence/1',0),('18177700383','queue-thereare','silence/1',0),('18177700383','queue-callswaiting','silence/1',0),('18177700383','queue-thankyou','',0),('18177700384','timeoutpriority','app',0),('18177700384','monitor-format','',0),('18177700385','member','Agent/2002,0',2),('18177700385','member','Agent/2001,0',1),('18177700385','member','Agent/2000,0',0),('18177700385','answered_elsewhere','0',0),('18177700386','eventwhencalled','no',0),('18177700386','eventmemberstatus','no',0),('18177700386','weight','0',0),('18177700386','autofill','no',0),('18177700386','ringinuse','yes',0),('18177700386','reportholdtime','no',0),('18177700386','autopause','no',0),('18177700386','member','Agent/2002,0',2),('18177700386','member','Agent/2001,0',1),('18177700387','member','Agent/2000,0',0),('18177700387','answered_elsewhere','0',0),('18177700389','member','Agent/2007,0',7),('18177700389','member','Agent/2006,0',6),('18177700389','member','Agent/2005,0',5),('18177700389','memberdelay','0',0),('18177700389','timeoutrestart','no',0),('18177700389','maxlen','0',0),('18177700389','joinempty','yes',0),('18177700389','leavewhenempty','no',0),('18177700389','strategy','random',0),('18177700389','timeout','0',0),('18177700389','retry','5',0),('18177700389','wrapuptime','0',0),('18177700389','announce-frequency','0',0),('18177700389','announce-holdtime','no',0),('18177700389','announce-position','no',0),('128177700100','member','Agent/2009,0',9),('12226443774','member','Agent/2004,0',4),('18147370231','member','Agent/2000,0',0),('18177700671','member','Agent/2005,0',5),('18177700671','eventwhencalled','no',0),('18177700671','eventmemberstatus','no',0),('18177700671','weight','0',0),('18177700671','autofill','no',0),('18177700671','ringinuse','yes',0),('18177700671','reportholdtime','no',0),('18177700671','autopause','no',0),('18177700671','member','Agent/2004,0',4),('18177700671','member','Agent/2003,0',3),('18177700671','member','Agent/2002,0',2),('18177700672','member','Agent/2002,0',2),('18177700672','member','Agent/2001,0',1),('18177700672','member','Agent/2000,0',0),('18177700673','member','Agent/2001,0',1),('18177700673','member','Agent/2002,0',2),('18177700673','member','Agent/2003,0',3),('18177700673','member','Agent/2004,0',4),('18177700673','member','Agent/2005,0',5),('18177700673','member','Agent/2006,0',6),('18177700673','penaltymemberslimit','0',0),('18177700673','timeoutpriority','app',0),('18177700673','maxlen','0',0),('18177700673','joinempty','yes',0),('18177700673','leavewhenempty','no',0),('18177700673','strategy','random',0),('18147773872','strategy','random',0),('18147773872','leavewhenempty','no',0),('18147773872','joinempty','yes',0),('18177700674','servicelevel','60',0),('18177700674','memberdelay','0',0),('18177700674','maxlen','0',0),('18177700674','joinempty','yes',0),('18177700674','leavewhenempty','no',0),('18177700674','strategy','random',0),('18177700674','timeout','0',0),('18177700674','retry','5',0),('18177700675','cron_schedule','never',0),('18177700675','member','Agent/2003,0',3),('18177700675','member','Agent/2002,0',2),('18177700675','member','Agent/2001,0',1),('18177700675','member','Agent/2000,0',0),('18177700675','answered_elsewhere','0',0),('18177700675','penaltymemberslimit','0',0),('18177700675','timeoutpriority','app',0),('18177700675','autopauseunavail','no',0),('18177700675','autopausebusy','no',0),('18177700676','member','Agent/2005,0',5),('18177700676','eventwhencalled','no',0),('18177700676','eventmemberstatus','no',0),('18177700676','weight','0',0),('18177700676','autofill','no',0),('18177700676','ringinuse','yes',0),('18177700676','reportholdtime','no',0),('18177700676','autopause','no',0),('18177700676','member','Agent/2004,0',4),('18177700676','member','Agent/2003,0',3),('18177700676','member','Agent/2002,0',2),('18177700677','member','Agent/2005,0',5),('18177700677','eventwhencalled','no',0),('18177700677','eventmemberstatus','no',0),('18177700677','weight','0',0),('18177700677','autofill','no',0),('18177700677','ringinuse','yes',0),('18177700677','reportholdtime','no',0),('18177700677','autopause','no',0),('18177700677','member','Agent/2004,0',4),('18177700677','member','Agent/2003,0',3),('18177700677','member','Agent/2002,0',2),('18177700678','member','Agent/2005,0',5),('18177700678','eventwhencalled','no',0),('18177700678','eventmemberstatus','no',0),('18177700678','weight','0',0),('18177700678','autofill','no',0),('18177700678','ringinuse','yes',0),('18177700678','reportholdtime','no',0),('18177700678','autopause','no',0),('18177700678','member','Agent/2004,0',4),('18177700678','member','Agent/2003,0',3),('18177700678','member','Agent/2002,0',2),('18177700679','member','Agent/2005,0',5),('18177700679','eventwhencalled','no',0),('18177700679','eventmemberstatus','no',0),('18177700679','weight','0',0),('18177700679','autofill','no',0),('18177700679','ringinuse','yes',0),('18177700679','reportholdtime','no',0),('18177700679','autopause','no',0),('18177700679','member','Agent/2004,0',4),('18177700679','member','Agent/2003,0',3),('18177700679','member','Agent/2002,0',2),('18177700680','member','Agent/2005,0',5),('18177700680','eventwhencalled','no',0),('18177700680','eventmemberstatus','no',0),('18177700680','weight','0',0),('18177700680','autofill','no',0),('18177700680','ringinuse','yes',0),('18177700680','reportholdtime','no',0),('18177700680','autopause','no',0),('18177700680','member','Agent/2004,0',4),('18177700680','member','Agent/2003,0',3),('18177700680','member','Agent/2002,0',2),('18177700681','member','Agent/2005,0',5),('18177700681','eventwhencalled','no',0),('18177700681','eventmemberstatus','no',0),('18177700681','weight','0',0),('18177700681','autofill','no',0),('18177700681','ringinuse','yes',0),('18177700681','reportholdtime','no',0),('18177700681','autopause','no',0),('18177700681','member','Agent/2004,0',4),('18177700681','member','Agent/2003,0',3),('18177700681','member','Agent/2002,0',2),('18177700682','member','Agent/2005,0',5),('18177700682','member','Agent/2006,0',6),('18177700682','timeout','0',0),('18177700682','retry','5',0),('18177700682','wrapuptime','0',0),('18177700682','announce-frequency','0',0),('18177700682','announce-holdtime','no',0),('18177700682','announce-position','no',0),('18177700682','queue-youarenext','silence/1',0),('18177700682','queue-thereare','silence/1',0),('18177700682','queue-callswaiting','silence/1',0),('18177700682','queue-thankyou','',0),('18177700683','member','Agent/2009,0',9),('18177700683','member','Agent/2010,0',10),('18177700683','timeout','0',0),('18177700683','retry','5',0),('18177700683','wrapuptime','0',0),('18177700683','announce-frequency','0',0),('18177700683','announce-holdtime','no',0),('18177700683','announce-position','no',0),('18177700683','queue-youarenext','silence/1',0),('18177700684','member','Agent/2005,0',5),('18177700684','eventwhencalled','no',0),('18177700684','eventmemberstatus','no',0),('18177700684','weight','0',0),('18177700684','autofill','no',0),('18177700684','ringinuse','yes',0),('18177700684','reportholdtime','no',0),('18177700684','autopause','no',0),('18177700684','member','Agent/2004,0',4),('18177700684','member','Agent/2003,0',3),('18177700684','member','Agent/2002,0',2),('18177700685','member','Agent/2005,0',5),('18177700685','eventwhencalled','no',0),('18177700685','eventmemberstatus','no',0),('18177700685','weight','0',0),('18177700685','autofill','no',0),('18177700685','ringinuse','yes',0),('18177700685','reportholdtime','no',0),('18177700685','autopause','no',0),('18177700685','member','Agent/2004,0',4),('18177700685','member','Agent/2003,0',3),('18177700685','member','Agent/2002,0',2),('18177700686','member','Agent/2005,0',5),('18177700686','member','Agent/2006,0',6),('18177700686','timeout','0',0),('18177700686','retry','5',0),('18177700686','wrapuptime','0',0),('18177700686','announce-frequency','0',0),('18177700686','announce-holdtime','no',0),('18177700686','announce-position','no',0),('18177700686','queue-youarenext','silence/1',0),('18177700686','queue-thereare','silence/1',0),('18177700686','queue-callswaiting','silence/1',0),('18177700686','queue-thankyou','',0),('18177700687','member','Agent/2003,0',3),('18177700687','member','Agent/2004,0',4),('18177700687','member','Agent/2005,0',5),('18177700687','member','Agent/2006,0',6),('18177700688','member','Agent/2005,0',5),('18177700688','eventwhencalled','no',0),('18177700688','eventmemberstatus','no',0),('18177700688','weight','0',0),('18177700688','autofill','no',0),('18177700688','ringinuse','yes',0),('18177700688','reportholdtime','no',0),('18177700688','autopause','no',0),('18177700688','member','Agent/2004,0',4),('18177700688','member','Agent/2003,0',3),('18177700688','member','Agent/2002,0',2),('183335605355','member','Agent/2009,0',9),('183335605355','member','Agent/2008,0',8),('183335605355','member','Agent/2007,0',7),('183335605355','member','Agent/2006,0',6),('183335605355','member','Agent/2005,0',5),('183335605355','member','Agent/2004,0',4),('193335605355','member','Agent/2009,0',9),('185588804680','member','Agent/2009,0',9),('185588804680','member','Agent/2008,0',8),('185588804680','member','Agent/2007,0',7),('185588804680','member','Agent/2006,0',6),('185588804680','member','Agent/2005,0',5),('185588804680','member','Agent/2004,0',4),('193335605355','member','Agent/2008,0',8),('188177700100','member','Agent/2009,0',9),('188177700100','member','Agent/2008,0',8),('188177700100','member','Agent/2007,0',7),('188177700100','member','Agent/2006,0',6),('188177700100','member','Agent/2005,0',5),('188177700100','member','Agent/2004,0',4),('193335605355','member','Agent/2000,0',0),('193335605355','answered_elsewhere','0',0),('193335605355','penaltymemberslimit','0',0),('19847770192','member','Agent/2009,0',9),('195588804680','member','Agent/2009,0',9),('195588804680','member','Agent/2008,0',8),('195588804680','member','Agent/2007,0',7),('195588804680','member','Agent/2006,0',6),('195588804680','member','Agent/2005,0',5),('195588804680','member','Agent/2004,0',4),('19847770192','member','Agent/2008,0',8),('198177700100','member','Agent/2009,0',9),('198177700100','member','Agent/2008,0',8),('198177700100','member','Agent/2007,0',7),('198177700100','member','Agent/2006,0',6),('198177700100','member','Agent/2005,0',5),('198177700100','member','Agent/2004,0',4),('19847770191','timeoutpriority','app',0),('19847770191','autopauseunavail','no',0),('19847770191','autopausebusy','no',0),('19847770191','cron_schedule','never',0),('19847770192','member','Agent/2001,0',1),('19847770192','member','Agent/2000,0',0),('19847770192','answered_elsewhere','0',0),('19847770192','penaltymemberslimit','0',0),('19847770192','timeoutpriority','app',0),('19847770193','member','Agent/2009,0',9),('19847770193','member','Agent/2008,0',8),('19847770193','member','Agent/2007,0',7),('19847770193','member','Agent/2006,0',6),('19847770193','member','Agent/2005,0',5),('19847770193','member','Agent/2004,0',4),('28177700100','member','Agent/2008,0',8),('98147370215','member','Agent/2004,0',4),('98147370215','member','Agent/2003,0',3),('98147370215','member','Agent/2002,0',2),('98147370215','member','Agent/2001,0',1),('98177700100','penaltymemberslimit','0',0),('98177700100','timeoutpriority','app',0),('18177700689','skip_joinannounce','',0),('18177700689','cron_schedule','never',0),('18177700689','monitor-format','',0),('18177700689','periodic-announce-frequency','0',0),('18177700689','maxlen','0',0),('18177700689','joinempty','yes',0),('18177700689','autopausebusy','no',0),('18177700689','autofill','no',0),('18177700689','ringinuse','yes',0),('18177700689','reportholdtime','no',0),('18177700689','autopause','no',0),('18177700689','autopausedelay','0',0),('18177700689','servicelevel','60',0),('18177700689','memberdelay','0',0),('18177700689','timeoutrestart','no',0),('18177700689','leavewhenempty','no',0),('18177700689','eventwhencalled','no',0),('18177700689','eventmemberstatus','no',0),('18177700689','weight','0',0),('18177700689','monitor-join','yes',0),('18177700689','strategy','random',0),('18177700689','timeout','0',0),('18177700689','retry','5',0),('18177700689','wrapuptime','0',0),('18177700689','announce-frequency','0',0),('18177700689','announce-holdtime','no',0),('18177700689','announce-position','no',0),('18177700689','queue-youarenext','silence/1',0),('18177700689','queue-thereare','silence/1',0),('18177700689','queue-callswaiting','silence/1',0),('18177700689','queue-thankyou','',0),('18147370218','member','Agent/2003,0',3),('18147370218','member','Agent/2002,0',2),('18147370218','member','Agent/2001,0',1),('18147370218','member','Agent/2000,0',0),('18147773881','autopausedelay','0',0),('108177700100','penaltymemberslimit','0',0),('133335605355','member','Agent/2007,0',7),('133335605355','member','Agent/2008,0',8),('133335605355','member','Agent/2009,0',9),('135588804680','member','Agent/2007,0',7),('135588804680','member','Agent/2008,0',8),('135588804680','member','Agent/2009,0',9),('15589958531','member','Agent/2006,0',6),('15589958531','member','Agent/2007,0',7),('15589958531','member','Agent/2008,0',8),('15589958531','member','Agent/2009,0',9),('15589958532','member','Agent/2006,0',6),('15589958532','member','Agent/2007,0',7),('15589958532','member','Agent/2008,0',8),('15589958532','member','Agent/2009,0',9),('15589958533','member','Agent/2006,0',6),('15589958533','member','Agent/2007,0',7),('15589958533','member','Agent/2008,0',8),('15589958533','member','Agent/2009,0',9),('18147370215','penaltymemberslimit','0',0),('18147370216','member','Agent/2004,0',4),('18147370217','member','Agent/2006,0',6),('18147370217','member','Agent/2007,0',7),('18147370217','member','Agent/2008,0',8),('18147370217','member','Agent/2009,0',9),('18147370218','member','Agent/2008,0',8),('18147370218','member','Agent/2009,0',9),('18147370221','member','Agent/2008,0',8),('18147370221','member','Agent/2009,0',9),('18147370224','member','Agent/2009,0',9),('18147370226','member','Agent/2009,0',9),('18147370227','member','Agent/2009,0',9),('18147370229','member','Agent/2006,0',6),('18147370229','member','Agent/2007,0',7),('18147370229','member','Agent/2008,0',8),('18147370229','member','Agent/2009,0',9),('18147370230','member','Agent/2005,0',5),('18147370230','member','Agent/2006,0',6),('18147370230','member','Agent/2007,0',7),('18147370230','member','Agent/2008,0',8),('18147370230','member','Agent/2009,0',9),('18147370231','member','Agent/2008,0',8),('18147370231','member','Agent/2009,0',9),('18147370232','member','Agent/2006,0',6),('18147370232','member','Agent/2007,0',7),('18147370232','member','Agent/2008,0',8),('18147370232','member','Agent/2009,0',9),('18147370233','member','Agent/2009,0',9),('18147370234','member','Agent/2006,0',6),('18147370234','member','Agent/2007,0',7),('18147370234','member','Agent/2008,0',8),('18147370234','member','Agent/2009,0',9),('18147370235','member','Agent/2006,0',6),('18147370235','member','Agent/2005,0',5),('18147370235','member','Agent/2004,0',4),('18147370235','member','Agent/2003,0',3),('18147370235','member','Agent/2002,0',2),('18147370237','member','Agent/2008,0',8),('18147370237','member','Agent/2009,0',9),('18147370238','member','Agent/2008,0',8),('18147370238','member','Agent/2009,0',9),('18147370239','member','Agent/2008,0',8),('18147370239','member','Agent/2009,0',9),('18147370240','answered_elsewhere','0',0),('18147370241','member','Agent/2009,0',9),('18147370242','member','Agent/2009,0',9),('18147370244','member','Agent/2006,0',6),('18147370244','member','Agent/2005,0',5),('18147370244','member','Agent/2004,0',4),('18147370244','member','Agent/2003,0',3),('18147370244','member','Agent/2002,0',2),('18147370245','answered_elsewhere','0',0),('18147370246','member','Agent/2009,0',9),('18147370247','member','Agent/2009,0',9),('18177700100','autofill','no',0),('18177700101','member','Agent/2003,0',3),('18177700101','member','Agent/2002,0',2),('18177700101','member','Agent/2000,0',0),('18177700102','member','Agent/2008,0',8),('18177700102','member','Agent/2009,0',9),('18177700103','member','Agent/2009,0',9),('18177700104','member','Agent/2009,0',9),('18177700105','member','Agent/2009,0',9),('18177700106','answered_elsewhere','0',0),('18177700107','member','Agent/2006,0',6),('18177700107','member','Agent/2007,0',7),('18177700107','member','Agent/2008,0',8),('18177700107','member','Agent/2009,0',9),('18177700108','member','Agent/2002,0',2),('18177700108','member','Agent/2001,0',1),('18177700109','member','Agent/2009,0',9),('18177700110','member','Agent/2008,0',8),('18177700110','member','Agent/2009,0',9),('18177700112','member','Agent/2005,0',5),('18177700112','member','Agent/2006,0',6),('18177700112','member','Agent/2007,0',7),('18177700113','member','Agent/2006,0',6),('18177700113','member','Agent/2007,0',7),('18177700113','member','Agent/2008,0',8),('18177700113','member','Agent/2009,0',9),('18177700114','member','Agent/2006,0',6),('18177700114','member','Agent/2007,0',7),('18177700114','member','Agent/2008,0',8),('18177700114','member','Agent/2009,0',9),('18177700115','member','Agent/2006,0',6),('18177700115','member','Agent/2007,0',7),('18177700115','member','Agent/2008,0',8),('18177700115','member','Agent/2009,0',9),('18177700116','member','Agent/2006,0',6),('18177700116','member','Agent/2007,0',7),('18177700116','member','Agent/2008,0',8),('18177700116','member','Agent/2009,0',9),('18177700117','member','Agent/2008,0',8),('18177700117','member','Agent/2009,0',9),('18177700118','member','Agent/2006,0',6),('18177700118','member','Agent/2007,0',7),('18177700118','member','Agent/2008,0',8),('18177700118','member','Agent/2009,0',9),('18177700119','member','Agent/2007,0',7),('18177700119','member','Agent/2008,0',8),('18177700119','member','Agent/2009,0',9),('18177700120','member','Agent/2008,0',8),('18177700120','member','Agent/2007,0',7),('18177700120','member','Agent/2006,0',6),('18177700120','member','Agent/2005,0',5),('18177700120','member','Agent/2004,0',4),('18177700121','member','Agent/2008,0',8),('18177700121','member','Agent/2009,0',9),('18177700122','member','Agent/2006,0',6),('18177700122','member','Agent/2007,0',7),('18177700122','member','Agent/2008,0',8),('18177700122','member','Agent/2009,0',9),('18177700123','member','Agent/2006,0',6),('18177700123','member','Agent/2007,0',7),('18177700123','member','Agent/2008,0',8),('18177700123','member','Agent/2009,0',9),('18177700124','member','Agent/2006,0',6),('18177700124','member','Agent/2007,0',7),('18177700124','member','Agent/2008,0',8),('18177700124','member','Agent/2009,0',9),('18177700360','member','Agent/2006,0',6),('18177700360','member','Agent/2007,0',7),('18177700360','member','Agent/2008,0',8),('18177700360','member','Agent/2009,0',9),('18177700361','member','Agent/2006,0',6),('18177700361','member','Agent/2007,0',7),('18177700361','member','Agent/2008,0',8),('18177700361','member','Agent/2009,0',9),('18177700362','member','Agent/2007,0',7),('18177700362','member','Agent/2008,0',8),('18177700362','member','Agent/2009,0',9),('18177700363','member','Agent/2006,0',6),('18177700363','member','Agent/2007,0',7),('18177700363','member','Agent/2008,0',8),('18177700363','member','Agent/2009,0',9),('18177700364','member','Agent/2006,0',6),('18177700364','member','Agent/2007,0',7),('18177700364','member','Agent/2008,0',8),('18177700364','member','Agent/2009,0',9),('18177700365','member','Agent/2009,0',9),('18177700366','member','Agent/2006,0',6),('18177700366','member','Agent/2007,0',7),('18177700366','member','Agent/2008,0',8),('18177700366','member','Agent/2009,0',9),('18177700367','member','Agent/2006,0',6),('18177700367','member','Agent/2007,0',7),('18177700367','member','Agent/2008,0',8),('18177700367','member','Agent/2009,0',9),('18177700368','member','Agent/2006,0',6),('18177700368','member','Agent/2007,0',7),('18177700368','member','Agent/2008,0',8),('18177700368','member','Agent/2009,0',9),('18177700369','member','Agent/2008,0',8),('18177700369','member','Agent/2009,0',9),('18177700371','member','Agent/2006,0',6),('18177700371','member','Agent/2007,0',7),('18177700371','member','Agent/2008,0',8),('18177700371','member','Agent/2009,0',9),('18177700372','member','Agent/2008,0',8),('18177700372','member','Agent/2009,0',9),('18177700373','member','Agent/2006,0',6),('18177700373','member','Agent/2007,0',7),('18177700373','member','Agent/2008,0',8),('18177700373','member','Agent/2009,0',9),('18177700374','member','Agent/2006,0',6),('18177700374','member','Agent/2007,0',7),('18177700374','member','Agent/2008,0',8),('18177700374','member','Agent/2009,0',9),('18177700375','member','Agent/2006,0',6),('18177700375','member','Agent/2007,0',7),('18177700375','member','Agent/2008,0',8),('18177700375','member','Agent/2009,0',9),('18177700376','member','Agent/2007,0',7),('18177700376','member','Agent/2008,0',8),('18177700376','member','Agent/2009,0',9),('18177700377','member','Agent/2006,0',6),('18177700377','member','Agent/2005,0',5),('18177700377','member','Agent/2004,0',4),('18177700377','member','Agent/2003,0',3),('18177700377','member','Agent/2002,0',2),('18177700378','member','Agent/2006,0',6),('18177700378','member','Agent/2005,0',5),('18177700378','member','Agent/2004,0',4),('18177700378','member','Agent/2003,0',3),('18177700378','member','Agent/2002,0',2),('18177700379','member','Agent/2006,0',6),('18177700379','member','Agent/2005,0',5),('18177700379','member','Agent/2004,0',4),('18177700379','member','Agent/2003,0',3),('18177700379','member','Agent/2002,0',2),('18177700380','member','Agent/2008,0',8),('18177700380','member','Agent/2009,0',9),('18177700381','member','Agent/2006,0',6),('18177700381','member','Agent/2007,0',7),('18177700381','member','Agent/2008,0',8),('18177700381','member','Agent/2009,0',9),('18177700382','member','Agent/2006,0',6),('18177700382','member','Agent/2007,0',7),('18177700382','member','Agent/2008,0',8),('18177700382','member','Agent/2009,0',9),('18177700383','member','Agent/2008,0',8),('18177700383','member','Agent/2009,0',9),('18177700384','member','Agent/2009,0',9),('18177700386','member','Agent/2005,0',5),('18177700386','member','Agent/2006,0',6),('18177700386','member','Agent/2007,0',7),('18177700386','member','Agent/2008,0',8),('18177700386','member','Agent/2009,0',9),('18177700387','member','Agent/2007,0',7),('18177700387','member','Agent/2008,0',8),('18177700387','member','Agent/2009,0',9),('18177700389','member','Agent/2008,0',8),('18177700389','member','Agent/2009,0',9),('18177700670','member','Agent/2001,0',1),('18177700670','member','Agent/2002,0',2),('18177700670','member','Agent/2003,0',3),('18177700670','member','Agent/2004,0',4),('18177700670','member','Agent/2005,0',5),('18177700670','member','Agent/2006,0',6),('18177700670','member','Agent/2007,0',7),('18177700670','member','Agent/2008,0',8),('18177700670','member','Agent/2009,0',9),('18177700671','member','Agent/2006,0',6),('18177700671','member','Agent/2007,0',7),('18177700671','member','Agent/2008,0',8),('18177700671','member','Agent/2009,0',9),('18177700673','member','Agent/2009,0',9),('18147773872','timeout','0',0),('18147773872','retry','5',0),('18177700699','reportholdtime','no',0),('18177700674','member','Agent/2000,0',0),('18177700675','member','Agent/2006,0',6),('18177700675','member','Agent/2007,0',7),('18177700675','member','Agent/2008,0',8),('18177700675','member','Agent/2009,0',9),('18177700676','member','Agent/2006,0',6),('18177700676','member','Agent/2007,0',7),('18177700676','member','Agent/2008,0',8),('18177700676','member','Agent/2009,0',9),('18177700677','member','Agent/2006,0',6),('18177700677','member','Agent/2007,0',7),('18177700677','member','Agent/2008,0',8),('18177700677','member','Agent/2009,0',9),('18177700678','member','Agent/2006,0',6),('18177700678','member','Agent/2007,0',7),('18177700678','member','Agent/2008,0',8),('18177700678','member','Agent/2009,0',9),('18177700679','member','Agent/2006,0',6),('18177700679','member','Agent/2007,0',7),('18177700679','member','Agent/2008,0',8),('18177700679','member','Agent/2009,0',9),('18177700680','member','Agent/2006,0',6),('18177700680','member','Agent/2007,0',7),('18177700680','member','Agent/2008,0',8),('18177700680','member','Agent/2009,0',9),('18177700681','member','Agent/2006,0',6),('18177700681','member','Agent/2007,0',7),('18177700681','member','Agent/2008,0',8),('18177700681','member','Agent/2009,0',9),('18177700682','member','Agent/2008,0',8),('18177700682','member','Agent/2009,0',9),('18177700683','member','Agent/2008,0',8),('18177700683','member','Agent/2007,0',7),('18177700683','member','Agent/2006,0',6),('18177700683','member','Agent/2005,0',5),('18177700683','member','Agent/2004,0',4),('18177700684','member','Agent/2006,0',6),('18177700684','member','Agent/2007,0',7),('18177700684','member','Agent/2008,0',8),('18177700684','member','Agent/2009,0',9),('18177700685','member','Agent/2006,0',6),('18177700685','member','Agent/2007,0',7),('18177700685','member','Agent/2008,0',8),('18177700685','member','Agent/2009,0',9),('18177700686','member','Agent/2008,0',8),('18177700686','member','Agent/2009,0',9),('18177700687','member','Agent/2008,0',8),('18177700687','member','Agent/2009,0',9),('18177700688','member','Agent/2006,0',6),('18177700688','member','Agent/2007,0',7),('18177700688','member','Agent/2008,0',8),('18177700688','member','Agent/2009,0',9),('18177700689','autopauseunavail','no',0),('18177700689','timeoutpriority','app',0),('18177700689','penaltymemberslimit','0',0),('18177700689','answered_elsewhere','0',0),('18177700689','member','Agent/2000,0',0),('18177700689','member','Agent/2001,0',1),('18177700689','member','Agent/2002,0',2),('18177700689','member','Agent/2003,0',3),('18177700689','member','Agent/2004,0',4),('18177700689','member','Agent/2005,0',5),('18177700689','member','Agent/2006,0',6),('18177700689','member','Agent/2007,0',7),('18177700689','member','Agent/2008,0',8),('18177700689','member','Agent/2009,0',9),('38177700100','member','Agent/2007,0',7),('38177700100','member','Agent/2008,0',8),('38177700100','member','Agent/2009,0',9),('58177700100','member','Agent/2009,0',9),('98177700100','member','Agent/2007,0',7),('98177700100','member','Agent/2008,0',8),('98177700100','member','Agent/2009,0',9),('18177700691','penaltymemberslimit','0',0),('18177700691','answered_elsewhere','0',0),('18177700691','ringinuse','yes',0),('18177700691','autofill','no',0),('18177700691','maxlen','0',0),('18177700691','joinempty','yes',0),('18177700691','memberdelay','0',0),('18177700691','timeoutrestart','no',0),('18177700691','skip_joinannounce','',0),('18177700691','cron_schedule','never',0),('18177700691','autopausebusy','no',0),('18177700691','autopauseunavail','no',0),('18177700691','timeoutpriority','app',0),('18177700691','leavewhenempty','no',0),('18177700691','autopause','no',0),('18177700691','autopausedelay','0',0),('18177700691','servicelevel','60',0),('18177700691','reportholdtime','no',0),('18177700691','strategy','random',0),('18177700691','timeout','0',0),('18177700691','retry','5',0),('18177700691','wrapuptime','0',0),('18177700691','announce-frequency','0',0),('18177700691','announce-holdtime','no',0),('18177700691','announce-position','no',0),('18177700691','queue-youarenext','silence/1',0),('18177700691','queue-thereare','silence/1',0),('18177700691','queue-callswaiting','silence/1',0),('18177700691','queue-thankyou','',0),('18177700691','periodic-announce-frequency','0',0),('18177700691','monitor-format','',0),('18177700691','monitor-join','yes',0),('18177700691','eventwhencalled','no',0),('18177700691','eventmemberstatus','no',0),('18177700691','weight','0',0),('18177700691','member','Agent/2000,0',0),('18177700691','member','Agent/2001,0',1),('18177700691','member','Agent/2002,0',2),('18177700691','member','Agent/2003,0',3),('18177700691','member','Agent/2004,0',4),('18177700691','member','Agent/2005,0',5),('18177700691','member','Agent/2006,0',6),('18177700691','member','Agent/2007,0',7),('18177700691','member','Agent/2008,0',8),('18177700691','member','Agent/2009,0',9),('18177700106','member','Agent/2009,0',9),('18177700692','cron_schedule','never',0),('18177700692','monitor-format','',0),('18177700692','periodic-announce-frequency','0',0),('18177700692','maxlen','0',0),('18177700692','joinempty','yes',0),('18177700692','autopauseunavail','no',0),('18177700692','autofill','no',0),('18177700692','ringinuse','yes',0),('18177700692','reportholdtime','no',0),('18177700692','autopause','no',0),('18177700692','autopausedelay','0',0),('18177700692','servicelevel','60',0),('18177700692','memberdelay','0',0),('18177700692','timeoutrestart','no',0),('18177700692','leavewhenempty','no',0),('18177700692','eventwhencalled','no',0),('18177700692','eventmemberstatus','no',0),('18177700692','weight','0',0),('18177700692','monitor-join','yes',0),('18177700692','strategy','random',0),('18177700692','timeout','0',0),('18177700692','retry','5',0),('18177700692','wrapuptime','0',0),('18177700692','announce-frequency','0',0),('18177700692','announce-holdtime','no',0),('18177700692','announce-position','no',0),('18177700692','queue-youarenext','silence/1',0),('18177700692','queue-thereare','silence/1',0),('18177700692','queue-callswaiting','silence/1',0),('18177700692','queue-thankyou','',0),('18177700692','timeoutpriority','app',0),('18177700692','penaltymemberslimit','0',0),('18177700692','answered_elsewhere','0',0),('18177700692','member','Agent/2000,0',0),('18177700692','member','Agent/2001,0',1),('18177700692','member','Agent/2002,0',2),('18177700692','member','Agent/2003,0',3),('18177700692','member','Agent/2004,0',4),('18177700692','member','Agent/2005,0',5),('18177700692','member','Agent/2006,0',6),('18177700692','member','Agent/2007,0',7),('18177700692','member','Agent/2008,0',8),('18177700692','member','Agent/2009,0',9),('18177700690','maxlen','0',0),('18177700690','joinempty','yes',0),('18177700690','leavewhenempty','no',0),('18177700690','strategy','random',0),('18177700690','timeout','0',0),('18177700690','retry','5',0),('18177700690','wrapuptime','0',0),('18177700690','announce-frequency','0',0),('18177700690','announce-holdtime','no',0),('18177700690','announce-position','no',0),('18177700690','queue-youarenext','silence/1',0),('18177700690','queue-thereare','silence/1',0),('18177700690','queue-callswaiting','silence/1',0),('18177700690','queue-thankyou','',0),('18177700690','periodic-announce-frequency','0',0),('18177700690','monitor-format','',0),('18177700690','monitor-join','yes',0),('18177700690','eventwhencalled','no',0),('18177700690','eventmemberstatus','no',0),('18177700690','weight','0',0),('18177700690','autofill','no',0),('18177700690','ringinuse','yes',0),('18177700690','reportholdtime','no',0),('18177700690','autopause','no',0),('18177700690','autopausedelay','0',0),('18177700690','servicelevel','60',0),('18177700690','memberdelay','0',0),('18177700690','timeoutrestart','no',0),('18177700690','skip_joinannounce','',0),('18177700690','cron_schedule','never',0),('18177700690','autopausebusy','no',0),('18177700690','autopauseunavail','no',0),('18177700690','timeoutpriority','app',0),('18177700690','penaltymemberslimit','0',0),('18177700690','answered_elsewhere','0',0),('18177700690','member','Agent/2000,0',0),('18177700690','member','Agent/2001,0',1),('18177700690','member','Agent/2002,0',2),('18177700690','member','Agent/2003,0',3),('18177700690','member','Agent/2004,0',4),('18177700690','member','Agent/2005,0',5),('18177700690','member','Agent/2006,0',6),('18177700690','member','Agent/2007,0',7),('18177700690','member','Agent/2008,0',8),('18177700690','member','Agent/2009,0',9),('28177700690','member','Agent/2000,0',0),('28177700690','penaltymemberslimit','0',0),('28177700690','answered_elsewhere','0',0),('28177700690','eventmemberstatus','no',0),('28177700690','weight','0',0),('28177700690','autofill','no',0),('28177700690','ringinuse','yes',0),('28177700690','reportholdtime','no',0),('28177700690','autopause','no',0),('28177700690','autopausedelay','0',0),('28177700690','servicelevel','60',0),('28177700690','memberdelay','0',0),('28177700690','timeoutrestart','no',0),('28177700690','skip_joinannounce','',0),('28177700690','cron_schedule','never',0),('28177700690','autopausebusy','no',0),('28177700690','autopauseunavail','no',0),('28177700690','timeoutpriority','app',0),('28177700690','announce-position','no',0),('28177700690','queue-youarenext','silence/1',0),('28177700690','queue-thereare','silence/1',0),('28177700690','queue-callswaiting','silence/1',0),('28177700690','queue-thankyou','',0),('28177700690','periodic-announce-frequency','0',0),('28177700690','monitor-format','',0),('28177700690','monitor-join','yes',0),('28177700690','eventwhencalled','no',0),('28177700690','maxlen','0',0),('28177700690','joinempty','yes',0),('28177700690','leavewhenempty','no',0),('28177700690','strategy','ringall',0),('28177700690','timeout','0',0),('28177700690','retry','5',0),('28177700690','wrapuptime','0',0),('28177700690','announce-frequency','0',0),('28177700690','announce-holdtime','no',0),('28177700690','member','Agent/2001,0',1),('28177700690','member','Agent/2002,0',2),('28177700690','member','Agent/2003,0',3),('28177700690','member','Agent/2004,0',4),('28177700690','member','Agent/2005,0',5),('28177700690','member','Agent/2006,0',6),('28177700690','member','Agent/2007,0',7),('28177700690','member','Agent/2008,0',8),('28177700690','member','Agent/2009,0',9),('18177700112','member','Agent/2000,0',0),('18177700112','member','Agent/2008,0',8),('18177700112','member','Agent/2009,0',9),('28147370215','maxlen','0',0),('28147370215','joinempty','yes',0),('28147370215','leavewhenempty','no',0),('28147370215','strategy','random',0),('28147370215','timeout','0',0),('28147370215','retry','5',0),('28147370215','wrapuptime','0',0),('28147370215','announce-frequency','0',0),('28147370215','announce-holdtime','no',0),('28147370215','announce-position','no',0),('28147370215','queue-youarenext','silence/1',0),('28147370215','queue-thereare','silence/1',0),('28147370215','queue-callswaiting','silence/1',0),('28147370215','queue-thankyou','',0),('28147370215','periodic-announce-frequency','0',0),('28147370215','monitor-format','',0),('28147370215','monitor-join','yes',0),('28147370215','eventwhencalled','no',0),('28147370215','eventmemberstatus','no',0),('28147370215','weight','0',0),('28147370215','autofill','no',0),('28147370215','ringinuse','yes',0),('28147370215','reportholdtime','no',0),('28147370215','autopause','no',0),('28147370215','autopausedelay','0',0),('28147370215','servicelevel','60',0),('28147370215','memberdelay','0',0),('28147370215','timeoutrestart','no',0),('28147370215','skip_joinannounce','',0),('28147370215','cron_schedule','never',0),('28147370215','autopausebusy','no',0),('28147370215','autopauseunavail','no',0),('28147370215','timeoutpriority','app',0),('28147370215','penaltymemberslimit','0',0),('28147370215','answered_elsewhere','0',0),('28147370215','member','Agent/2000,0',0),('28147370215','member','Agent/2001,0',1),('28147370215','member','Agent/2002,0',2),('28147370215','member','Agent/2003,0',3),('28147370215','member','Agent/2004,0',4),('28147370215','member','Agent/2005,0',5),('28147370215','member','Agent/2006,0',6),('28147370215','member','Agent/2007,0',7),('28147370215','member','Agent/2008,0',8),('28147370215','member','Agent/2009,0',9),('18177700693','maxlen','0',0),('18177700693','joinempty','yes',0),('18177700693','leavewhenempty','no',0),('18177700693','strategy','random',0),('18177700693','timeout','0',0),('18177700693','retry','5',0),('18177700693','wrapuptime','0',0),('18177700693','announce-frequency','0',0),('18177700693','announce-holdtime','no',0),('18177700693','announce-position','no',0),('18177700693','queue-youarenext','silence/1',0),('18177700693','queue-thereare','silence/1',0),('18177700693','queue-callswaiting','silence/1',0),('18177700693','queue-thankyou','',0),('18177700693','periodic-announce-frequency','0',0),('18177700693','monitor-format','',0),('18177700693','monitor-join','yes',0),('18177700693','eventwhencalled','no',0),('18177700693','eventmemberstatus','no',0),('18177700693','weight','0',0),('18177700693','autofill','no',0),('18177700693','ringinuse','yes',0),('18177700693','reportholdtime','no',0),('18177700693','autopause','no',0),('18177700693','autopausedelay','0',0),('18177700693','servicelevel','60',0),('18177700693','memberdelay','0',0),('18177700693','timeoutrestart','no',0),('18177700693','skip_joinannounce','',0),('18177700693','cron_schedule','never',0),('18177700693','autopausebusy','no',0),('18177700693','autopauseunavail','no',0),('18177700693','timeoutpriority','app',0),('18177700693','penaltymemberslimit','0',0),('18177700693','answered_elsewhere','0',0),('18177700693','member','Agent/2000,0',0),('18177700693','member','Agent/2001,0',1),('18177700693','member','Agent/2002,0',2),('18177700693','member','Agent/2003,0',3),('18177700693','member','Agent/2004,0',4),('18177700693','member','Agent/2005,0',5),('18177700693','member','Agent/2006,0',6),('18177700693','member','Agent/2007,0',7),('18177700693','member','Agent/2008,0',8),('18177700693','member','Agent/2009,0',9),('18177700695','maxlen','0',0),('18177700695','joinempty','yes',0),('18177700695','leavewhenempty','no',0),('18177700695','strategy','random',0),('18177700695','timeout','0',0),('18177700695','retry','5',0),('18177700695','wrapuptime','0',0),('18177700695','announce-frequency','0',0),('18177700695','announce-holdtime','no',0),('18177700695','announce-position','no',0),('18177700695','queue-youarenext','silence/1',0),('18177700695','queue-thereare','silence/1',0),('18177700695','queue-callswaiting','silence/1',0),('18177700695','queue-thankyou','',0),('18177700695','periodic-announce-frequency','0',0),('18177700695','monitor-format','',0),('18177700695','monitor-join','yes',0),('18177700695','eventwhencalled','no',0),('18177700695','eventmemberstatus','no',0),('18177700695','weight','0',0),('18177700695','autofill','no',0),('18177700695','ringinuse','yes',0),('18177700695','reportholdtime','no',0),('18177700695','autopause','no',0),('18177700695','autopausedelay','0',0),('18177700695','servicelevel','60',0),('18177700695','memberdelay','0',0),('18177700695','timeoutrestart','no',0),('18177700695','skip_joinannounce','',0),('18177700695','cron_schedule','never',0),('18177700695','autopausebusy','no',0),('18177700695','autopauseunavail','no',0),('18177700695','timeoutpriority','app',0),('18177700695','penaltymemberslimit','0',0),('18177700695','answered_elsewhere','0',0),('18177700695','member','Agent/2000,0',0),('18177700695','member','Agent/2001,0',1),('18177700695','member','Agent/2002,0',2),('18177700695','member','Agent/2003,0',3),('18177700695','member','Agent/2004,0',4),('18177700695','member','Agent/2005,0',5),('18177700695','member','Agent/2006,0',6),('18177700695','member','Agent/2007,0',7),('18177700695','member','Agent/2008,0',8),('18177700695','member','Agent/2009,0',9),('18177700694','maxlen','0',0),('18177700694','joinempty','yes',0),('18177700694','leavewhenempty','no',0),('18177700694','strategy','random',0),('18177700694','timeout','0',0),('18177700694','retry','5',0),('18177700694','wrapuptime','0',0),('18177700694','announce-frequency','0',0),('18177700694','announce-holdtime','no',0),('18177700694','announce-position','no',0),('18177700694','queue-youarenext','silence/1',0),('18177700694','queue-thereare','silence/1',0),('18177700694','queue-callswaiting','silence/1',0),('18177700694','queue-thankyou','',0),('18177700694','periodic-announce-frequency','0',0),('18177700694','monitor-format','',0),('18177700694','monitor-join','yes',0),('18177700694','eventwhencalled','no',0),('18177700694','eventmemberstatus','no',0),('18177700694','weight','0',0),('18177700694','autofill','no',0),('18177700694','ringinuse','yes',0),('18177700694','reportholdtime','no',0),('18177700694','autopause','no',0),('18177700694','autopausedelay','0',0),('18177700694','servicelevel','60',0),('18177700694','memberdelay','0',0),('18177700694','timeoutrestart','no',0),('18177700694','skip_joinannounce','',0),('18177700694','cron_schedule','never',0),('18177700694','autopausebusy','no',0),('18177700694','autopauseunavail','no',0),('18177700694','timeoutpriority','app',0),('18177700694','penaltymemberslimit','0',0),('18177700694','answered_elsewhere','0',0),('18177700694','member','Agent/2000,0',0),('18177700694','member','Agent/2001,0',1),('18177700694','member','Agent/2002,0',2),('18177700694','member','Agent/2003,0',3),('18177700694','member','Agent/2004,0',4),('18177700694','member','Agent/2005,0',5),('18177700694','member','Agent/2006,0',6),('18177700694','member','Agent/2007,0',7),('18177700694','member','Agent/2008,0',8),('18177700694','member','Agent/2009,0',9),('18147370235','member','Agent/2009,0',9),('208177700100','member','Agent/2003,0',3),('208177700100','member','Agent/2004,0',4),('208177700100','member','Agent/2005,0',5),('208177700100','member','Agent/2006,0',6),('208177700100','member','Agent/2007,0',7),('208177700100','member','Agent/2001,0',1),('208177700100','member','Agent/2002,0',2),('208177700100','penaltymemberslimit','0',0),('208177700100','answered_elsewhere','0',0),('208177700100','member','Agent/2000,0',0),('208177700100','eventwhencalled','no',0),('208177700100','eventmemberstatus','no',0),('208177700100','weight','0',0),('208177700100','autofill','no',0),('208177700100','ringinuse','yes',0),('208177700100','reportholdtime','no',0),('208177700100','autopause','no',0),('208177700100','autopausedelay','0',0),('208177700100','servicelevel','60',0),('208177700100','memberdelay','0',0),('208177700100','timeoutrestart','no',0),('208177700100','skip_joinannounce','',0),('208177700100','cron_schedule','never',0),('208177700100','autopausebusy','no',0),('208177700100','autopauseunavail','no',0),('208177700100','timeoutpriority','app',0),('208177700100','maxlen','0',0),('208177700100','joinempty','yes',0),('208177700100','leavewhenempty','no',0),('208177700100','strategy','random',0),('208177700100','timeout','0',0),('208177700100','retry','5',0),('208177700100','wrapuptime','0',0),('208177700100','announce-frequency','0',0),('208177700100','announce-holdtime','no',0),('208177700100','announce-position','no',0),('208177700100','queue-youarenext','silence/1',0),('208177700100','queue-thereare','silence/1',0),('208177700100','queue-callswaiting','silence/1',0),('208177700100','queue-thankyou','',0),('208177700100','periodic-announce-frequency','0',0),('208177700100','monitor-format','',0),('208177700100','monitor-join','yes',0),('208177700100','member','Agent/2008,0',8),('208177700100','member','Agent/2009,0',9),('18147370244','member','Agent/2009,0',9),('18147370240','member','Agent/2009,0',9),('18177700696','cron_schedule','never',0),('18177700696','autopausebusy','no',0),('18177700696','eventwhencalled','no',0),('18177700696','maxlen','0',0),('18177700696','joinempty','yes',0),('18177700696','autopauseunavail','no',0),('18177700696','ringinuse','yes',0),('18177700696','reportholdtime','no',0),('18177700696','autopause','no',0),('18177700696','autopausedelay','0',0),('18177700696','servicelevel','60',0),('18177700696','memberdelay','0',0),('18177700696','timeoutrestart','no',0),('18177700696','skip_joinannounce','',0),('18177700696','leavewhenempty','no',0),('18177700696','weight','0',0),('18177700696','autofill','no',0),('18177700696','eventmemberstatus','no',0),('18177700696','strategy','random',0),('18177700696','timeout','0',0),('18177700696','retry','5',0),('18177700696','wrapuptime','0',0),('18177700696','announce-frequency','0',0),('18177700696','announce-holdtime','no',0),('18177700696','announce-position','no',0),('18177700696','queue-youarenext','silence/1',0),('18177700696','queue-thereare','silence/1',0),('18177700696','queue-callswaiting','silence/1',0),('18177700696','queue-thankyou','',0),('18177700696','periodic-announce-frequency','0',0),('18177700696','monitor-format','',0),('18177700696','monitor-join','yes',0),('18177700696','timeoutpriority','app',0),('18177700696','penaltymemberslimit','0',0),('18177700696','answered_elsewhere','0',0),('18177700696','member','Agent/2000,0',0),('18177700696','member','Agent/2001,0',1),('18177700696','member','Agent/2002,0',2),('18177700696','member','Agent/2003,0',3),('18177700696','member','Agent/2004,0',4),('18177700696','member','Agent/2005,0',5),('18177700696','member','Agent/2006,0',6),('18177700696','member','Agent/2007,0',7),('18177700696','member','Agent/2008,0',8),('18177700696','member','Agent/2009,0',9),('19847770194','maxlen','0',0),('19847770194','joinempty','yes',0),('19847770194','leavewhenempty','no',0),('19847770194','strategy','random',0),('19847770194','timeout','0',0),('19847770194','retry','5',0),('19847770194','wrapuptime','0',0),('19847770194','announce-frequency','0',0),('19847770194','announce-holdtime','no',0),('19847770194','announce-position','no',0),('19847770194','queue-youarenext','silence/1',0),('19847770194','queue-thereare','silence/1',0),('19847770194','queue-callswaiting','silence/1',0),('19847770194','queue-thankyou','',0),('19847770194','periodic-announce-frequency','0',0),('19847770194','monitor-format','',0),('19847770194','monitor-join','yes',0),('19847770194','eventwhencalled','no',0),('19847770194','eventmemberstatus','no',0),('19847770194','weight','0',0),('19847770194','autofill','no',0),('19847770194','ringinuse','yes',0),('19847770194','reportholdtime','no',0),('19847770194','autopause','no',0),('19847770194','autopausedelay','0',0),('19847770194','servicelevel','60',0),('19847770194','memberdelay','0',0),('19847770194','timeoutrestart','no',0),('19847770194','skip_joinannounce','',0),('19847770194','cron_schedule','never',0),('19847770194','autopausebusy','no',0),('19847770194','autopauseunavail','no',0),('19847770194','timeoutpriority','app',0),('19847770194','penaltymemberslimit','0',0),('19847770194','answered_elsewhere','0',0),('19847770194','member','Agent/2000,0',0),('19847770194','member','Agent/2001,0',1),('19847770194','member','Agent/2002,0',2),('19847770194','member','Agent/2003,0',3),('19847770194','member','Agent/2004,0',4),('19847770194','member','Agent/2005,0',5),('19847770194','member','Agent/2006,0',6),('19847770194','member','Agent/2007,0',7),('19847770194','member','Agent/2008,0',8),('19847770194','member','Agent/2009,0',9),('18177700697','maxlen','0',0),('18177700697','joinempty','yes',0),('18177700697','leavewhenempty','no',0),('18177700697','strategy','random',0),('18177700697','timeout','0',0),('18177700697','retry','5',0),('18177700697','wrapuptime','0',0),('18177700697','announce-frequency','0',0),('18177700697','announce-holdtime','no',0),('18177700697','announce-position','no',0),('18177700697','queue-youarenext','silence/1',0),('18177700697','queue-thereare','silence/1',0),('18177700697','queue-callswaiting','silence/1',0),('18177700697','queue-thankyou','',0),('18177700697','periodic-announce-frequency','0',0),('18177700697','monitor-format','',0),('18177700697','monitor-join','yes',0),('18177700697','eventwhencalled','no',0),('18177700697','eventmemberstatus','no',0),('18177700697','weight','0',0),('18177700697','autofill','no',0),('18177700697','ringinuse','yes',0),('18177700697','reportholdtime','no',0),('18177700697','autopause','no',0),('18177700697','autopausedelay','0',0),('18177700697','servicelevel','60',0),('18177700697','memberdelay','0',0),('18177700697','timeoutrestart','no',0),('18177700697','skip_joinannounce','',0),('18177700697','cron_schedule','never',0),('18177700697','autopausebusy','no',0),('18177700697','autopauseunavail','no',0),('18177700697','timeoutpriority','app',0),('18177700697','penaltymemberslimit','0',0),('18177700697','answered_elsewhere','0',0),('18177700697','member','Agent/2000,0',0),('18177700697','member','Agent/2001,0',1),('18177700697','member','Agent/2002,0',2),('18177700697','member','Agent/2003,0',3),('18177700697','member','Agent/2004,0',4),('18177700697','member','Agent/2005,0',5),('18177700697','member','Agent/2006,0',6),('18177700697','member','Agent/2007,0',7),('18177700697','member','Agent/2008,0',8),('18177700697','member','Agent/2009,0',9),('15588804685','joinempty','yes',0),('15588804685','leavewhenempty','no',0),('15588804685','strategy','random',0),('15588804685','timeout','0',0),('15588804685','retry','5',0),('15588804685','wrapuptime','0',0),('15588804685','announce-frequency','0',0),('15588804685','announce-holdtime','no',0),('15588804685','announce-position','no',0),('15588804685','queue-youarenext','silence/1',0),('15588804685','queue-thereare','silence/1',0),('15588804685','queue-callswaiting','silence/1',0),('15588804685','queue-thankyou','',0),('15588804685','periodic-announce-frequency','0',0),('15588804685','monitor-format','',0),('15588804685','monitor-join','yes',0),('15588804685','eventwhencalled','no',0),('15588804685','eventmemberstatus','no',0),('15588804685','weight','0',0),('15588804685','autofill','no',0),('15588804685','ringinuse','yes',0),('15588804685','reportholdtime','no',0),('15588804685','autopause','no',0),('15588804685','autopausedelay','0',0),('15588804685','servicelevel','60',0),('15588804685','memberdelay','0',0),('15588804685','timeoutrestart','no',0),('15588804685','skip_joinannounce','',0),('15588804685','cron_schedule','never',0),('15588804685','autopausebusy','no',0),('15588804685','autopauseunavail','no',0),('15588804685','timeoutpriority','app',0),('15588804685','penaltymemberslimit','0',0),('15588804685','answered_elsewhere','0',0),('15588804685','member','Agent/2000,0',0),('15588804685','member','Agent/2001,0',1),('15588804685','member','Agent/2002,0',2),('15588804685','member','Agent/2003,0',3),('15588804685','member','Agent/2004,0',4),('15588804685','member','Agent/2005,0',5),('15588804685','member','Agent/2006,0',6),('15588804685','member','Agent/2007,0',7),('15588804685','member','Agent/2008,0',8),('15588804685','member','Agent/2009,0',9),('13388800130','maxlen','0',0),('13388800130','joinempty','yes',0),('13388800130','leavewhenempty','no',0),('13388800130','strategy','random',0),('13388800130','timeout','0',0),('13388800130','retry','5',0),('13388800130','wrapuptime','0',0),('13388800130','announce-frequency','0',0),('13388800130','announce-holdtime','no',0),('13388800130','announce-position','no',0),('13388800130','queue-youarenext','silence/1',0),('13388800130','queue-thereare','silence/1',0),('13388800130','queue-callswaiting','silence/1',0),('13388800130','queue-thankyou','',0),('13388800130','periodic-announce-frequency','0',0),('13388800130','monitor-format','',0),('13388800130','monitor-join','yes',0),('13388800130','eventwhencalled','no',0),('13388800130','eventmemberstatus','no',0),('13388800130','weight','0',0),('13388800130','autofill','no',0),('13388800130','ringinuse','yes',0),('13388800130','reportholdtime','no',0),('13388800130','autopause','no',0),('13388800130','autopausedelay','0',0),('13388800130','servicelevel','60',0),('13388800130','memberdelay','0',0),('13388800130','timeoutrestart','no',0),('13388800130','skip_joinannounce','',0),('13388800130','cron_schedule','never',0),('13388800130','autopausebusy','no',0),('13388800130','autopauseunavail','no',0),('13388800130','timeoutpriority','app',0),('13388800130','penaltymemberslimit','0',0),('13388800130','answered_elsewhere','0',0),('13388800130','member','Agent/2000,0',0),('13388800130','member','Agent/2001,0',1),('13388800130','member','Agent/2003,0',2),('13388800130','member','Agent/2002,0',3),('13388800130','member','Agent/2004,0',4),('13388800130','member','Agent/2005,0',5),('13388800130','member','Agent/2006,0',6),('13388800130','member','Agent/2007,0',7),('13388800130','member','Agent/2008,0',8),('13388800130','member','Agent/2009,0',9),('18177700698','cron_schedule','never',0),('18177700698','autopausebusy','no',0),('18177700698','eventwhencalled','no',0),('18177700698','maxlen','0',0),('18177700698','joinempty','yes',0),('18177700698','autopauseunavail','no',0),('18177700698','ringinuse','yes',0),('18177700698','reportholdtime','no',0),('18177700698','autopause','no',0),('18177700698','autopausedelay','0',0),('18177700698','servicelevel','60',0),('18177700698','memberdelay','0',0),('18177700698','timeoutrestart','no',0),('18177700698','skip_joinannounce','',0),('18177700698','leavewhenempty','no',0),('18177700698','weight','0',0),('18177700698','autofill','no',0),('18177700698','eventmemberstatus','no',0),('18177700698','strategy','random',0),('18177700698','timeout','0',0),('18177700698','retry','5',0),('18177700698','wrapuptime','0',0),('18177700698','announce-frequency','0',0),('18177700698','announce-holdtime','no',0),('18177700698','announce-position','no',0),('18177700698','queue-youarenext','silence/1',0),('18177700698','queue-thereare','silence/1',0),('18177700698','queue-callswaiting','silence/1',0),('18177700698','queue-thankyou','',0),('18177700698','periodic-announce-frequency','0',0),('18177700698','monitor-format','',0),('18177700698','monitor-join','yes',0),('18177700698','timeoutpriority','app',0),('18177700698','penaltymemberslimit','0',0),('18177700698','answered_elsewhere','0',0),('18177700698','member','Agent/2000,0',0),('18177700698','member','Agent/2001,0',1),('18177700698','member','Agent/2002,0',2),('18177700698','member','Agent/2003,0',3),('18177700698','member','Agent/2004,0',4),('18177700698','member','Agent/2005,0',5),('18177700698','member','Agent/2006,0',6),('18177700698','member','Agent/2007,0',7),('18177700698','member','Agent/2008,0',8),('18177700698','member','Agent/2009,0',9),('108147370215','reportholdtime','no',0),('108147370215','autopause','no',0),('108147370215','queue-thereare','silence/1',0),('108147370215','queue-youarenext','silence/1',0),('108147370215','maxlen','0',0),('108147370215','joinempty','yes',0),('108147370215','autopausedelay','0',0),('108147370215','monitor-format','',0),('108147370215','monitor-join','yes',0),('108147370215','eventwhencalled','no',0),('108147370215','eventmemberstatus','no',0),('108147370215','weight','0',0),('108147370215','autofill','no',0),('108147370215','ringinuse','yes',0),('108147370215','leavewhenempty','no',0),('108147370215','queue-thankyou','',0),('108147370215','periodic-announce-frequency','0',0),('108147370215','queue-callswaiting','silence/1',0),('108147370215','strategy','random',0),('108147370215','timeout','0',0),('108147370215','retry','5',0),('108147370215','wrapuptime','0',0),('108147370215','announce-frequency','0',0),('108147370215','announce-holdtime','no',0),('108147370215','announce-position','no',0),('108147370215','servicelevel','60',0),('108147370215','memberdelay','0',0),('108147370215','timeoutrestart','no',0),('108147370215','skip_joinannounce','',0),('108147370215','cron_schedule','never',0),('108147370215','autopausebusy','no',0),('108147370215','autopauseunavail','no',0),('108147370215','timeoutpriority','app',0),('108147370215','penaltymemberslimit','0',0),('108147370215','answered_elsewhere','0',0),('108147370215','member','Agent/2000,0',0),('108147370215','member','Agent/2001,0',1),('108147370215','member','Agent/2002,0',2),('108147370215','member','Agent/2003,0',3),('108147370215','member','Agent/2004,0',4),('108147370215','member','Agent/2005,0',5),('108147370215','member','Agent/2006,0',6),('108147370215','member','Agent/2007,0',7),('108147370215','member','Agent/2008,0',8),('108147370215','member','Agent/2009,0',9),('18177701550','cron_schedule','never',0),('18177701550','autopausebusy','no',0),('18177701550','eventwhencalled','no',0),('18177701550','maxlen','0',0),('18177701550','joinempty','yes',0),('18177701550','autopauseunavail','no',0),('18177701550','ringinuse','yes',0),('18177701550','reportholdtime','no',0),('18177701550','autopause','no',0),('18177701550','autopausedelay','0',0),('18177701550','servicelevel','60',0),('18177701550','memberdelay','0',0),('18177701550','timeoutrestart','no',0),('18177701550','skip_joinannounce','',0),('18177701550','leavewhenempty','no',0),('18177701550','weight','0',0),('18177701550','autofill','no',0),('18177701550','eventmemberstatus','no',0),('18177701550','strategy','random',0),('18177701550','timeout','0',0),('18177701550','retry','5',0),('18177701550','wrapuptime','0',0),('18177701550','announce-frequency','0',0),('18177701550','announce-holdtime','no',0),('18177701550','announce-position','no',0),('18177701550','queue-youarenext','silence/1',0),('18177701550','queue-thereare','silence/1',0),('18177701550','queue-callswaiting','silence/1',0),('18177701550','queue-thankyou','',0),('18177701550','periodic-announce-frequency','0',0),('18177701550','monitor-format','',0),('18177701550','monitor-join','yes',0),('15589958540','member','Agent/2007,0',7),('15589958540','member','Agent/2006,0',6),('15589958540','answered_elsewhere','0',0),('15589958540','member','Agent/2000,0',0),('15589958540','member','Agent/2001,0',1),('15589958540','autopausebusy','no',0),('15589958540','autopauseunavail','no',0),('15589958540','timeoutpriority','app',0),('15589958540','penaltymemberslimit','0',0),('15589958540','skip_joinannounce','',0),('15589958540','cron_schedule','never',0),('15589958540','eventmemberstatus','no',0),('15589958540','weight','0',0),('15589958540','autofill','no',0),('15589958540','queue-callswaiting','silence/1',0),('15589958540','queue-thankyou','',0),('15589958540','periodic-announce-frequency','0',0),('15589958540','monitor-format','',0),('15589958540','monitor-join','yes',0),('15589958540','eventwhencalled','no',0),('15589958540','maxlen','0',0),('15589958540','joinempty','yes',0),('15589958540','leavewhenempty','no',0),('15589958540','strategy','random',0),('15589958540','timeout','0',0),('15589958540','retry','5',0),('15589958540','wrapuptime','0',0),('15589958540','announce-frequency','0',0),('15589958540','announce-holdtime','no',0),('15589958540','announce-position','no',0),('15589958540','queue-youarenext','silence/1',0),('15589958540','queue-thereare','silence/1',0),('13388800133','maxlen','0',0),('13388800133','joinempty','yes',0),('13388800133','leavewhenempty','no',0),('13388800133','strategy','random',0),('13388800133','timeout','0',0),('13388800133','retry','5',0),('13388800133','wrapuptime','0',0),('13388800133','announce-frequency','0',0),('13388800133','announce-holdtime','no',0),('13388800133','announce-position','no',0),('13388800133','queue-youarenext','silence/1',0),('13388800133','queue-thereare','silence/1',0),('13388800133','queue-callswaiting','silence/1',0),('13388800133','queue-thankyou','',0),('13388800133','periodic-announce-frequency','0',0),('13388800133','monitor-format','',0),('13388800133','monitor-join','yes',0),('13388800133','eventwhencalled','no',0),('13388800133','eventmemberstatus','no',0),('13388800133','weight','0',0),('13388800133','autofill','no',0),('13388800133','ringinuse','yes',0),('13388800133','reportholdtime','no',0),('13388800133','autopause','no',0),('13388800133','autopausedelay','0',0),('13388800133','servicelevel','60',0),('13388800133','memberdelay','0',0),('13388800133','timeoutrestart','no',0),('13388800133','skip_joinannounce','',0),('13388800133','cron_schedule','never',0),('13388800133','autopausebusy','no',0),('13388800133','autopauseunavail','no',0),('13388800133','timeoutpriority','app',0),('13388800133','penaltymemberslimit','0',0),('13388800133','answered_elsewhere','0',0),('13388800133','member','Agent/2000,0',0),('13388800133','member','Agent/2001,0',1),('13388800133','member','Agent/2002,0',2),('13388800133','member','Agent/2003,0',3),('13388800133','member','Agent/2004,0',4),('13388800133','member','Agent/2005,0',5),('13388800133','member','Agent/2006,0',6),('13388800133','member','Agent/2007,0',7),('13388800133','member','Agent/2008,0',8),('13388800133','member','Agent/2009,0',9),('15589958540','ringinuse','yes',0),('15589958540','reportholdtime','no',0),('15589958540','autopause','no',0),('15589958540','autopausedelay','0',0),('15589958540','servicelevel','60',0),('15589958540','memberdelay','0',0),('15589958540','timeoutrestart','no',0),('15589958540','member','Agent/2005,0',5),('15589958540','member','Agent/2004,0',4),('15589958540','member','Agent/2003,0',3),('15589958540','member','Agent/2002,0',2),('18177701550','timeoutpriority','app',0),('18177701550','penaltymemberslimit','0',0),('18177701550','answered_elsewhere','0',0),('18177701550','member','Agent/2000,0',0),('18177701550','member','Agent/2001,0',1),('18177701550','member','Agent/2002,0',2),('18177701550','member','Agent/2003,0',3),('18177701550','member','Agent/2004,0',4),('18177701550','member','Agent/2005,0',5),('18177701550','member','Agent/2006,0',6),('18177701550','member','Agent/2007,0',7),('18177701550','member','Agent/2008,0',8),('18177701550','member','Agent/2009,0',9),('18177701551','maxlen','0',0),('18177701551','joinempty','yes',0),('18177701551','leavewhenempty','no',0),('18177701551','strategy','random',0),('18177701551','timeout','0',0),('18177701551','retry','5',0),('18177701551','wrapuptime','0',0),('18177701551','announce-frequency','0',0),('18177701551','announce-holdtime','no',0),('18177701551','announce-position','no',0),('18177701551','queue-youarenext','silence/1',0),('18177701551','queue-thereare','silence/1',0),('18177701551','queue-callswaiting','silence/1',0),('18177701551','queue-thankyou','',0),('18177701551','periodic-announce-frequency','0',0),('18177701551','monitor-format','',0),('18177701551','monitor-join','yes',0),('18177701551','eventwhencalled','no',0),('18177701551','eventmemberstatus','no',0),('18177701551','weight','0',0),('18177701551','autofill','no',0),('18177701551','ringinuse','yes',0),('18177701551','reportholdtime','no',0),('18177701551','autopause','no',0),('18177701551','autopausedelay','0',0),('18177701551','servicelevel','60',0),('18177701551','memberdelay','0',0),('18177701551','timeoutrestart','no',0),('18177701551','skip_joinannounce','',0),('18177701551','cron_schedule','never',0),('18177701551','autopausebusy','no',0),('18177701551','autopauseunavail','no',0),('18177701551','timeoutpriority','app',0),('18177701551','penaltymemberslimit','0',0),('18177701551','answered_elsewhere','0',0),('18177701551','member','Agent/2000,0',0),('18177701551','member','Agent/2001,0',1),('18177701551','member','Agent/2002,0',2),('18177701551','member','Agent/2003,0',3),('18177701551','member','Agent/2004,0',4),('18177701551','member','Agent/2006,0',5),('18177701551','member','Agent/2007,0',6),('18177701551','member','Agent/2008,0',7),('18177701551','member','Agent/2009,0',8),('15589958534','member','Agent/2009,0',9),('15589958534','member','Agent/2004,0',4),('15589958534','member','Agent/2005,0',5),('15589958534','member','Agent/2006,0',6),('15589958534','member','Agent/2007,0',7),('15589958534','member','Agent/2008,0',8),('15589958534','timeoutpriority','app',0),('15589958534','penaltymemberslimit','0',0),('15589958534','answered_elsewhere','0',0),('15589958534','member','Agent/2000,0',0),('15589958534','autopause','no',0),('15589958534','autopausedelay','0',0),('15589958534','servicelevel','60',0),('15589958534','memberdelay','0',0),('15589958534','timeoutrestart','no',0),('15589958534','skip_joinannounce','',0),('15589958534','cron_schedule','never',0),('15589958534','autopausebusy','no',0),('15589958534','autopauseunavail','no',0),('15589958534','monitor-join','yes',0),('15589958534','eventwhencalled','no',0),('15589958534','eventmemberstatus','no',0),('15589958534','weight','0',0),('15589958534','autofill','no',0),('15589958534','ringinuse','yes',0),('15589958534','reportholdtime','no',0),('15589958534','maxlen','0',0),('15589958534','joinempty','yes',0),('15589958534','leavewhenempty','no',0),('15589958534','strategy','random',0),('15589958534','timeout','0',0),('15589958534','retry','5',0),('15589958534','wrapuptime','0',0),('15589958534','announce-frequency','0',0),('15589958534','announce-holdtime','no',0),('15589958534','announce-position','no',0),('15589958534','queue-youarenext','silence/1',0),('15589958534','queue-thereare','silence/1',0),('15589958534','queue-callswaiting','silence/1',0),('15589958534','queue-thankyou','',0),('15589958534','periodic-announce-frequency','0',0),('15589958534','monitor-format','',0),('18147370245','member','Agent/2009,0',9),('15589958535','cron_schedule','never',0),('15589958535','autopausebusy','no',0),('15589958535','eventwhencalled','no',0),('15589958535','maxlen','0',0),('15589958535','joinempty','yes',0),('15589958535','autopauseunavail','no',0),('15589958535','ringinuse','yes',0),('15589958535','reportholdtime','no',0),('15589958535','autopause','no',0),('15589958535','autopausedelay','0',0),('15589958535','servicelevel','60',0),('15589958535','memberdelay','0',0),('15589958535','timeoutrestart','no',0),('15589958535','skip_joinannounce','',0),('15589958535','leavewhenempty','no',0),('15589958535','weight','0',0),('15589958535','autofill','no',0),('15589958535','eventmemberstatus','no',0),('15589958535','strategy','random',0),('15589958535','timeout','0',0),('15589958535','retry','5',0),('15589958535','wrapuptime','0',0),('15589958535','announce-frequency','0',0),('15589958535','announce-holdtime','no',0),('15589958535','announce-position','no',0),('15589958535','queue-youarenext','silence/1',0),('15589958535','queue-thereare','silence/1',0),('15589958535','queue-callswaiting','silence/1',0),('15589958535','queue-thankyou','',0),('15589958535','periodic-announce-frequency','0',0),('15589958535','monitor-format','',0),('15589958535','monitor-join','yes',0),('15589958535','timeoutpriority','app',0),('15589958535','penaltymemberslimit','0',0),('15589958535','answered_elsewhere','0',0),('15589958535','member','Agent/2000,0',0),('15589958535','member','Agent/2001,0',1),('15589958535','member','Agent/2002,0',2),('15589958535','member','Agent/2003,0',3),('15589958535','member','Agent/2004,0',4),('15589958535','member','Agent/2005,0',5),('15589958535','member','Agent/2006,0',6),('15589958535','member','Agent/2007,0',7),('15589958535','member','Agent/2008,0',8),('15589958535','member','Agent/2009,0',9),('15588804682','member','Agent/2008,0',8),('18177702600','retry','5',0),('15588804681','cron_schedule','never',0),('15588804681','autopausebusy','no',0),('15588804681','monitor-join','yes',0),('15588804681','eventwhencalled','no',0),('15588804681','eventmemberstatus','no',0),('15588804681','weight','0',0),('15588804681','autofill','no',0),('15588804681','ringinuse','yes',0),('15588804681','reportholdtime','no',0),('15588804681','queue-thereare','silence/1',0),('15588804681','servicelevel','60',0),('15588804681','memberdelay','0',0),('15588804681','timeoutrestart','no',0),('15588804681','skip_joinannounce','',0),('15588804681','autopause','no',0),('15588804681','autopausedelay','0',0),('15588804681','queue-callswaiting','silence/1',0),('15588804681','queue-thankyou','',0),('15588804681','periodic-announce-frequency','0',0),('15588804681','monitor-format','wav',0),('15588804681','maxlen','0',0),('15588804681','joinempty','yes',0),('15588804681','leavewhenempty','no',0),('15588804681','strategy','random',0),('15588804681','timeout','0',0),('15588804681','retry','5',0),('15588804681','wrapuptime','0',0),('15588804681','announce-frequency','0',0),('15588804681','announce-holdtime','no',0),('15588804681','announce-position','no',0),('15588804681','queue-youarenext','silence/1',0),('15589958540','member','Agent/2008,0',8),('15589958540','member','Agent/2009,0',9),('18177700699','member','Agent/2003,0',2),('15588804681','member','Agent/2004,0',4),('15588804681','member','Agent/2005,0',5),('15588804681','member','Agent/2006,0',6),('15588804682','member','Agent/2006,0',6),('15588804682','member','Agent/2007,0',7),('15588804682','member','Agent/2002,0',2),('15588804682','member','Agent/2003,0',3),('15588804682','servicelevel','60',0),('15588804682','memberdelay','0',0),('15588804682','timeoutrestart','no',0),('15588804682','skip_joinannounce','',0),('15588804682','cron_schedule','never',0),('15588804682','autopausebusy','no',0),('15588804682','autopauseunavail','no',0),('15588804682','timeoutpriority','app',0),('15588804682','penaltymemberslimit','0',0),('15588804682','answered_elsewhere','0',0),('15588804682','member','Agent/2000,0',0),('15588804682','member','Agent/2001,0',1),('15588804682','eventwhencalled','no',0),('15588804682','eventmemberstatus','no',0),('15588804682','weight','0',0),('15588804682','autofill','no',0),('15588804682','ringinuse','yes',0),('15588804682','reportholdtime','no',0),('15588804682','autopause','no',0),('15588804682','autopausedelay','0',0),('15588804682','maxlen','0',0),('15588804682','joinempty','yes',0),('15588804682','leavewhenempty','no',0),('15588804682','strategy','random',0),('15588804682','timeout','0',0),('15588804682','retry','5',0),('15588804682','wrapuptime','0',0),('15588804682','announce-frequency','0',0),('15588804682','announce-holdtime','no',0),('15588804682','announce-position','no',0),('15588804682','queue-youarenext','silence/1',0),('15588804682','queue-thereare','silence/1',0),('15588804682','queue-callswaiting','silence/1',0),('15588804682','queue-thankyou','',0),('15588804682','periodic-announce-frequency','0',0),('15588804682','monitor-format','',0),('15588804682','monitor-join','yes',0),('18177702600','strategy','random',0),('18177701552','maxlen','0',0),('18177701552','joinempty','yes',0),('18177701552','leavewhenempty','no',0),('18177701552','strategy','random',0),('18177701552','timeout','0',0),('18177701552','retry','5',0),('18177701552','wrapuptime','0',0),('18177701552','announce-frequency','0',0),('18177701552','announce-holdtime','no',0),('18177701552','announce-position','no',0),('18177701552','queue-youarenext','silence/1',0),('18177701552','queue-thereare','silence/1',0),('18177701552','queue-callswaiting','silence/1',0),('18177701552','queue-thankyou','',0),('18177701552','periodic-announce-frequency','0',0),('18177701552','monitor-format','',0),('18177701552','monitor-join','yes',0),('18177701552','eventwhencalled','no',0),('18177701552','eventmemberstatus','no',0),('18177701552','weight','0',0),('18177701552','autofill','no',0),('18177701552','ringinuse','yes',0),('18177701552','reportholdtime','no',0),('18177701552','autopause','no',0),('18177701552','autopausedelay','0',0),('18177701552','servicelevel','60',0),('18177701552','memberdelay','0',0),('18177701552','timeoutrestart','no',0),('18177701552','skip_joinannounce','',0),('18177701552','cron_schedule','never',0),('18177701552','autopausebusy','no',0),('18177701552','autopauseunavail','no',0),('18177701552','timeoutpriority','app',0),('18177701552','penaltymemberslimit','0',0),('18177701552','answered_elsewhere','0',0),('18177701552','member','Agent/2000,0',0),('18177701552','member','Agent/2001,0',1),('18177701552','member','Agent/2002,0',2),('18177701552','member','Agent/2003,0',3),('18177701552','member','Agent/2004,0',4),('18177701552','member','Agent/2005,0',5),('18177701552','member','Agent/2006,0',6),('18177701552','member','Agent/2007,0',7),('18177701552','member','Agent/2008,0',8),('18177701552','member','Agent/2009,0',9),('15588804686','member','Agent/2003,0',3),('15588804686','member','Agent/2004,0',4),('15588804686','member','Agent/2001,0',1),('15588804686','member','Agent/2002,0',2),('15588804686','member','Agent/2005,0',5),('15588804686','member','Agent/2006,0',6),('15588804686','member','Agent/2007,0',7),('15588804686','servicelevel','60',0),('15588804686','memberdelay','0',0),('15588804686','timeoutrestart','no',0),('15588804686','skip_joinannounce','',0),('15588804686','cron_schedule','never',0),('15588804686','autopausebusy','no',0),('15588804686','announce-frequency','0',0),('15588804686','announce-holdtime','no',0),('15588804686','announce-position','no',0),('15588804686','queue-youarenext','silence/1',0),('15588804686','queue-thereare','silence/1',0),('15588804686','queue-callswaiting','silence/1',0),('15588804686','queue-thankyou','',0),('15588804686','periodic-announce-frequency','0',0),('15588804686','monitor-format','wav',0),('15588804686','monitor-join','yes',0),('15588804686','eventwhencalled','no',0),('15588804686','eventmemberstatus','no',0),('15588804686','maxlen','0',0),('15588804686','joinempty','yes',0),('15588804686','leavewhenempty','no',0),('15588804686','strategy','random',0),('15588804686','timeout','0',0),('15588804686','retry','5',0),('15588804686','wrapuptime','0',0),('18177701553','maxlen','0',0),('18177701553','joinempty','yes',0),('18177701553','leavewhenempty','no',0),('18177701553','strategy','random',0),('18177701553','timeout','0',0),('18177701553','retry','5',0),('18177701553','wrapuptime','0',0),('18177701553','announce-frequency','0',0),('18177701553','announce-holdtime','no',0),('18177701553','announce-position','no',0),('18177701553','queue-youarenext','silence/1',0),('18177701553','queue-thereare','silence/1',0),('18177701553','queue-callswaiting','silence/1',0),('18177701553','queue-thankyou','',0),('18177701553','periodic-announce-frequency','0',0),('18177701553','monitor-format','',0),('18177701553','monitor-join','yes',0),('18177701553','eventwhencalled','no',0),('18177701553','eventmemberstatus','no',0),('18177701553','weight','0',0),('18177701553','autofill','no',0),('18177701553','ringinuse','yes',0),('18177701553','reportholdtime','no',0),('18177701553','autopause','no',0),('18177701553','autopausedelay','0',0),('18177701553','servicelevel','60',0),('18177701553','memberdelay','0',0),('18177701553','timeoutrestart','no',0),('18177701553','skip_joinannounce','',0),('18177701553','cron_schedule','never',0),('18177701553','autopausebusy','no',0),('18177701553','autopauseunavail','no',0),('18177701553','timeoutpriority','app',0),('18177701553','penaltymemberslimit','0',0),('18177701553','answered_elsewhere','0',0),('18177701553','member','Agent/2000,0',0),('18177701553','member','Agent/2001,0',1),('18177701553','member','Agent/2002,0',2),('18177701553','member','Agent/2003,0',3),('18177701553','member','Agent/2004,0',4),('18177701553','member','Agent/2005,0',5),('18177701553','member','Agent/2006,0',6),('18177701553','member','Agent/2007,0',7),('18177701553','member','Agent/2008,0',8),('18177701553','member','Agent/2009,0',9),('15588804683','member','Agent/2004,0',4),('15588804683','member','Agent/2003,0',3),('15588804683','penaltymemberslimit','0',0),('15588804683','answered_elsewhere','0',0),('15588804683','member','Agent/2000,0',0),('15588804683','cron_schedule','never',0),('15588804683','autopausebusy','no',0),('15588804683','autopauseunavail','no',0),('15588804683','timeoutpriority','app',0),('15588804683','timeoutrestart','no',0),('15588804683','skip_joinannounce','',0),('15588804683','eventmemberstatus','no',0),('15588804683','weight','0',0),('15588804683','autofill','no',0),('15588804683','queue-callswaiting','silence/1',0),('15588804683','queue-thankyou','',0),('15588804683','periodic-announce-frequency','0',0),('15588804683','monitor-format','',0),('15588804683','monitor-join','yes',0),('15588804683','eventwhencalled','no',0),('15588804683','maxlen','0',0),('15588804683','joinempty','yes',0),('15588804683','leavewhenempty','no',0),('15588804683','strategy','random',0),('15588804683','timeout','0',0),('15588804683','retry','5',0),('15588804683','wrapuptime','0',0),('15588804683','announce-frequency','0',0),('15588804683','announce-holdtime','no',0),('15588804683','announce-position','no',0),('15588804683','queue-youarenext','silence/1',0),('15588804683','queue-thereare','silence/1',0),('18177701554','maxlen','0',0),('18177701554','joinempty','yes',0),('18177701554','leavewhenempty','no',0),('18177701554','strategy','random',0),('18177701554','timeout','0',0),('18177701554','retry','5',0),('18177701554','wrapuptime','0',0),('18177701554','announce-frequency','0',0),('18177701554','announce-holdtime','no',0),('18177701554','announce-position','no',0),('18177701554','queue-youarenext','silence/1',0),('18177701554','queue-thereare','silence/1',0),('18177701554','queue-callswaiting','silence/1',0),('18177701554','queue-thankyou','',0),('18177701554','periodic-announce-frequency','0',0),('18177701554','monitor-format','',0),('18177701554','monitor-join','yes',0),('18177701554','eventwhencalled','no',0),('18177701554','eventmemberstatus','no',0),('18177701554','weight','0',0),('18177701554','autofill','no',0),('18177701554','ringinuse','yes',0),('18177701554','reportholdtime','no',0),('18177701554','autopause','no',0),('18177701554','autopausedelay','0',0),('18177701554','servicelevel','60',0),('18177701554','memberdelay','0',0),('18177701554','timeoutrestart','no',0),('18177701554','skip_joinannounce','',0),('18177701554','cron_schedule','never',0),('18177701554','autopausebusy','no',0),('18177701554','autopauseunavail','no',0),('18177701554','timeoutpriority','app',0),('18177701554','penaltymemberslimit','0',0),('18177701554','answered_elsewhere','0',0),('18177701554','member','Agent/2000,0',0),('18177701554','member','Agent/2001,0',1),('18177701554','member','Agent/2002,0',2),('18177701554','member','Agent/2003,0',3),('18177701554','member','Agent/2004,0',4),('18177701554','member','Agent/2005,0',5),('18177701554','member','Agent/2006,0',6),('18177701554','member','Agent/2007,0',7),('18177701554','member','Agent/2008,0',8),('18177701554','member','Agent/2009,0',9),('13388800131','cron_schedule','never',0),('13388800131','autopausebusy','no',0),('13388800131','eventwhencalled','no',0),('13388800131','maxlen','0',0),('13388800131','joinempty','yes',0),('13388800131','autopauseunavail','no',0),('13388800131','ringinuse','yes',0),('13388800131','reportholdtime','no',0),('13388800131','autopause','no',0),('13388800131','autopausedelay','0',0),('13388800131','servicelevel','60',0),('13388800131','memberdelay','0',0),('13388800131','timeoutrestart','no',0),('13388800131','skip_joinannounce','',0),('13388800131','leavewhenempty','no',0),('13388800131','weight','0',0),('13388800131','autofill','no',0),('13388800131','eventmemberstatus','no',0),('13388800131','strategy','random',0),('13388800131','timeout','0',0),('13388800131','retry','5',0),('13388800131','wrapuptime','0',0),('13388800131','announce-frequency','0',0),('13388800131','announce-holdtime','no',0),('13388800131','announce-position','no',0),('13388800131','queue-youarenext','silence/1',0),('13388800131','queue-thereare','silence/1',0),('13388800131','queue-callswaiting','silence/1',0),('13388800131','queue-thankyou','',0),('13388800131','periodic-announce-frequency','0',0),('13388800131','monitor-format','',0),('13388800131','monitor-join','yes',0),('19847770196','maxlen','0',0),('19847770196','joinempty','yes',0),('19847770196','leavewhenempty','no',0),('19847770196','strategy','random',0),('19847770196','timeout','0',0),('19847770196','retry','5',0),('19847770196','wrapuptime','0',0),('19847770196','announce-frequency','0',0),('19847770196','announce-holdtime','no',0),('19847770196','announce-position','no',0),('19847770196','queue-youarenext','silence/1',0),('19847770196','queue-thereare','silence/1',0),('19847770196','queue-callswaiting','silence/1',0),('19847770196','queue-thankyou','',0),('19847770196','periodic-announce-frequency','0',0),('19847770196','monitor-format','',0),('19847770196','monitor-join','yes',0),('19847770196','eventwhencalled','no',0),('19847770196','eventmemberstatus','no',0),('19847770196','weight','0',0),('19847770196','autofill','no',0),('19847770196','ringinuse','yes',0),('19847770196','reportholdtime','no',0),('19847770196','autopause','no',0),('19847770196','autopausedelay','0',0),('19847770196','servicelevel','60',0),('19847770196','memberdelay','0',0),('19847770196','timeoutrestart','no',0),('19847770196','skip_joinannounce','',0),('19847770196','cron_schedule','never',0),('19847770196','autopausebusy','no',0),('19847770196','autopauseunavail','no',0),('19847770196','timeoutpriority','app',0),('19847770196','penaltymemberslimit','0',0),('19847770196','answered_elsewhere','0',0),('19847770196','member','Agent/2000,0',0),('19847770196','member','Agent/2001,0',1),('19847770196','member','Agent/2002,0',2),('19847770196','member','Agent/2003,0',3),('19847770196','member','Agent/2004,0',4),('19847770196','member','Agent/2005,0',5),('19847770196','member','Agent/2006,0',6),('19847770196','member','Agent/2007,0',7),('19847770196','member','Agent/2008,0',8),('19847770196','member','Agent/2009,0',9),('18718800156','maxlen','0',0),('18718800156','joinempty','yes',0),('18718800156','leavewhenempty','no',0),('18718800156','strategy','random',0),('18718800156','timeout','0',0),('18718800156','retry','5',0),('18718800156','wrapuptime','0',0),('18718800156','announce-frequency','0',0),('18718800156','announce-holdtime','no',0),('18718800156','announce-position','no',0),('18718800156','queue-youarenext','silence/1',0),('18718800156','queue-thereare','silence/1',0),('18718800156','queue-callswaiting','silence/1',0),('18718800156','queue-thankyou','',0),('18718800156','periodic-announce-frequency','0',0),('18718800156','monitor-format','',0),('18718800156','monitor-join','yes',0),('18718800156','eventwhencalled','no',0),('18718800156','eventmemberstatus','no',0),('18718800156','weight','0',0),('18718800156','autofill','no',0),('18718800156','ringinuse','yes',0),('18718800156','reportholdtime','no',0),('18718800156','autopause','no',0),('18718800156','autopausedelay','0',0),('18718800156','servicelevel','60',0),('18718800156','memberdelay','0',0),('18718800156','timeoutrestart','no',0),('18718800156','skip_joinannounce','',0),('18718800156','cron_schedule','never',0),('18718800156','autopausebusy','no',0),('18718800156','autopauseunavail','no',0),('18718800156','timeoutpriority','app',0),('18718800156','penaltymemberslimit','0',0),('18718800156','answered_elsewhere','0',0),('18718800156','member','Agent/2000,0',0),('18718800156','member','Agent/2001,0',1),('18718800156','member','Agent/2002,0',2),('18718800156','member','Agent/2003,0',3),('18718800156','member','Agent/2004,0',4),('18718800156','member','Agent/2005,0',5),('18718800156','member','Agent/2006,0',6),('18718800156','member','Agent/2007,0',7),('18718800156','member','Agent/2008,0',8),('18718800156','member','Agent/2009,0',9),('18718800151','maxlen','0',0),('18718800151','joinempty','yes',0),('18718800151','leavewhenempty','no',0),('18718800151','strategy','random',0),('18718800151','timeout','0',0),('18718800151','retry','5',0),('18718800151','wrapuptime','0',0),('18718800151','announce-frequency','0',0),('18718800151','announce-holdtime','no',0),('18718800151','announce-position','no',0),('18718800151','queue-youarenext','silence/1',0),('18718800151','queue-thereare','silence/1',0),('18718800151','queue-callswaiting','silence/1',0),('18718800151','queue-thankyou','',0),('18718800151','periodic-announce-frequency','0',0),('18718800151','monitor-format','',0),('18718800151','monitor-join','yes',0),('18718800151','eventwhencalled','no',0),('18718800151','eventmemberstatus','no',0),('18718800151','weight','0',0),('18718800151','autofill','no',0),('18718800151','ringinuse','yes',0),('18718800151','reportholdtime','no',0),('18718800151','autopause','no',0),('18718800151','autopausedelay','0',0),('18718800151','servicelevel','60',0),('18718800151','memberdelay','0',0),('18718800151','timeoutrestart','no',0),('18718800151','skip_joinannounce','',0),('18718800151','cron_schedule','never',0),('18718800151','autopausebusy','no',0),('18718800151','autopauseunavail','no',0),('18718800151','timeoutpriority','app',0),('18718800151','penaltymemberslimit','0',0),('18718800151','answered_elsewhere','0',0),('18718800151','member','Agent/2000,0',0),('18718800151','member','Agent/2001,0',1),('18718800151','member','Agent/2002,0',2),('18718800151','member','Agent/2003,0',3),('18718800151','member','Agent/2004,0',4),('18718800151','member','Agent/2005,0',5),('18718800151','member','Agent/2006,0',6),('18718800151','member','Agent/2007,0',7),('18718800151','member','Agent/2008,0',8),('18718800151','member','Agent/2009,0',9),('18718800152','maxlen','0',0),('18718800152','joinempty','yes',0),('18718800152','leavewhenempty','no',0),('18718800152','strategy','random',0),('18718800152','timeout','0',0),('18718800152','retry','5',0),('18718800152','wrapuptime','0',0),('18718800152','announce-frequency','0',0),('18718800152','announce-holdtime','no',0),('18718800152','announce-position','no',0),('18718800152','queue-youarenext','silence/1',0),('18718800152','queue-thereare','silence/1',0),('18718800152','queue-callswaiting','silence/1',0),('18718800152','queue-thankyou','',0),('18718800152','periodic-announce-frequency','0',0),('18718800152','monitor-format','',0),('18718800152','monitor-join','yes',0),('18718800152','eventwhencalled','no',0),('18718800152','eventmemberstatus','no',0),('18718800152','weight','0',0),('18718800152','autofill','no',0),('18718800152','ringinuse','yes',0),('18718800152','reportholdtime','no',0),('18718800152','autopause','no',0),('18718800152','autopausedelay','0',0),('18718800152','servicelevel','60',0),('18718800152','memberdelay','0',0),('18718800152','timeoutrestart','no',0),('18718800152','skip_joinannounce','',0),('18718800152','cron_schedule','never',0),('18718800152','autopausebusy','no',0),('18718800152','autopauseunavail','no',0),('18718800152','timeoutpriority','app',0),('18718800152','penaltymemberslimit','0',0),('18718800152','answered_elsewhere','0',0),('18718800152','member','Agent/2000,0',0),('18718800152','member','Agent/2001,0',1),('18718800152','member','Agent/2002,0',2),('18718800152','member','Agent/2003,0',3),('18718800152','member','Agent/2004,0',4),('18718800152','member','Agent/2005,0',5),('18718800152','member','Agent/2006,0',6),('18718800152','member','Agent/2007,0',7),('18718800152','member','Agent/2008,0',8),('18718800152','member','Agent/2009,0',9),('18177700379','member','Agent/2009,0',9),('18177701556','maxlen','0',0),('18177701556','joinempty','yes',0),('18177701556','leavewhenempty','no',0),('18177701556','strategy','random',0),('18177701556','timeout','0',0),('18177701556','retry','5',0),('18177701556','wrapuptime','0',0),('18177701556','announce-frequency','0',0),('18177701556','announce-holdtime','no',0),('18177701556','announce-position','no',0),('18177701556','queue-youarenext','silence/1',0),('18177701556','queue-thereare','silence/1',0),('18177701556','queue-callswaiting','silence/1',0),('18177701556','queue-thankyou','',0),('18177701556','periodic-announce-frequency','0',0),('18177701556','monitor-format','',0),('18177701556','monitor-join','yes',0),('18177701556','eventwhencalled','no',0),('18177701556','eventmemberstatus','no',0),('18177701556','weight','0',0),('18177701556','autofill','no',0),('18177701556','ringinuse','yes',0),('18177701556','reportholdtime','no',0),('18177701556','autopause','no',0),('18177701556','autopausedelay','0',0),('18177701556','servicelevel','60',0),('18177701556','memberdelay','0',0),('18177701556','timeoutrestart','no',0),('18177701556','skip_joinannounce','',0),('18177701556','cron_schedule','never',0),('18177701556','autopausebusy','no',0),('18177701556','autopauseunavail','no',0),('18177701556','timeoutpriority','app',0),('18177701556','penaltymemberslimit','0',0),('18177701556','answered_elsewhere','0',0),('18177701556','member','Agent/2000,0',0),('18177701556','member','Agent/2001,0',1),('18177701556','member','Agent/2002,0',2),('18177701556','member','Agent/2003,0',3),('18177701556','member','Agent/2004,0',4),('18177701556','member','Agent/2005,0',5),('18177701556','member','Agent/2006,0',6),('18177701556','member','Agent/2007,0',7),('18177701556','member','Agent/2008,0',8),('18177701556','member','Agent/2009,0',9),('18177701555','maxlen','0',0),('18177701555','joinempty','yes',0),('18177701555','leavewhenempty','no',0),('18177701555','strategy','random',0),('18177701555','timeout','0',0),('18177701555','retry','5',0),('18177701555','wrapuptime','0',0),('18177701555','announce-frequency','0',0),('18177701555','announce-holdtime','no',0),('18177701555','announce-position','no',0),('18177701555','queue-youarenext','silence/1',0),('18177701555','queue-thereare','silence/1',0),('18177701555','queue-callswaiting','silence/1',0),('18177701555','queue-thankyou','',0),('18177701555','periodic-announce-frequency','0',0),('18177701555','monitor-format','',0),('18177701555','monitor-join','yes',0),('18177701555','eventwhencalled','no',0),('18177701555','eventmemberstatus','no',0),('18177701555','weight','0',0),('18177701555','autofill','no',0),('18177701555','ringinuse','yes',0),('18177701555','reportholdtime','no',0),('18177701555','autopause','no',0),('18177701555','autopausedelay','0',0),('18177701555','servicelevel','60',0),('18177701555','memberdelay','0',0),('18177701555','timeoutrestart','no',0),('18177701555','skip_joinannounce','',0),('18177701555','cron_schedule','never',0),('18177701555','autopausebusy','no',0),('18177701555','autopauseunavail','no',0),('18177701555','timeoutpriority','app',0),('18177701555','penaltymemberslimit','0',0),('18177701555','answered_elsewhere','0',0),('18177701555','member','Agent/2000,0',0),('18177701555','member','Agent/2001,0',1),('18177701555','member','Agent/2002,0',2),('18177701555','member','Agent/2003,0',3),('18177701555','member','Agent/2004,0',4),('18177701555','member','Agent/2005,0',5),('18177701555','member','Agent/2006,0',6),('18177701555','member','Agent/2007,0',7),('18177701555','member','Agent/2008,0',8),('18177701555','member','Agent/2009,0',9),('18177701558','maxlen','0',0),('18177701558','joinempty','yes',0),('18177701558','leavewhenempty','no',0),('18177701558','strategy','random',0),('18177701558','timeout','0',0),('18177701558','retry','5',0),('18177701558','wrapuptime','0',0),('18177701558','announce-frequency','0',0),('18177701558','announce-holdtime','no',0),('18177701558','announce-position','no',0),('18177701558','queue-youarenext','silence/1',0),('18177701558','queue-thereare','silence/1',0),('18177701558','queue-callswaiting','silence/1',0),('18177701558','queue-thankyou','',0),('18177701558','periodic-announce-frequency','0',0),('18177701558','monitor-format','',0),('18177701558','monitor-join','yes',0),('18177701558','eventwhencalled','no',0),('18177701558','eventmemberstatus','no',0),('18177701558','weight','0',0),('18177701558','autofill','no',0),('18177701558','ringinuse','yes',0),('18177701558','reportholdtime','no',0),('18177701558','autopause','no',0),('18177701558','autopausedelay','0',0),('18177701558','servicelevel','60',0),('18177701558','memberdelay','0',0),('18177701558','timeoutrestart','no',0),('18177701558','skip_joinannounce','',0),('18177701558','cron_schedule','never',0),('18177701558','autopausebusy','no',0),('18177701558','autopauseunavail','no',0),('18177701558','timeoutpriority','app',0),('18177701558','penaltymemberslimit','0',0),('18177701558','answered_elsewhere','0',0),('18177701558','member','Agent/2000,0',0),('18177701558','member','Agent/2001,0',1),('18177701558','member','Agent/2002,0',2),('18177701558','member','Agent/2003,0',3),('18177701558','member','Agent/2004,0',4),('18177701558','member','Agent/2005,0',5),('18177701558','member','Agent/2006,0',6),('18177701558','member','Agent/2007,0',7),('18177701558','member','Agent/2008,0',8),('18177701558','member','Agent/2009,0',9),('18177701557','maxlen','0',0),('18177701557','joinempty','yes',0),('18177701557','leavewhenempty','no',0),('18177701557','strategy','random',0),('18177701557','timeout','0',0),('18177701557','retry','5',0),('18177701557','wrapuptime','0',0),('18177701557','announce-frequency','0',0),('18177701557','announce-holdtime','no',0),('18177701557','announce-position','no',0),('18177701557','queue-youarenext','silence/1',0),('18177701557','queue-thereare','silence/1',0),('18177701557','queue-callswaiting','silence/1',0),('18177701557','queue-thankyou','',0),('18177701557','periodic-announce-frequency','0',0),('18177701557','monitor-format','',0),('18177701557','monitor-join','yes',0),('18177701557','eventwhencalled','no',0),('18177701557','eventmemberstatus','no',0),('18177701557','weight','0',0),('18177701557','autofill','no',0),('18177701557','ringinuse','yes',0),('18177701557','reportholdtime','no',0),('18177701557','autopause','no',0),('18177701557','autopausedelay','0',0),('18177701557','servicelevel','60',0),('18177701557','memberdelay','0',0),('18177701557','timeoutrestart','no',0),('18177701557','skip_joinannounce','',0),('18177701557','cron_schedule','never',0),('18177701557','autopausebusy','no',0),('18177701557','autopauseunavail','no',0),('18177701557','timeoutpriority','app',0),('18177701557','penaltymemberslimit','0',0),('18177701557','answered_elsewhere','0',0),('18177701557','member','Agent/2000,0',0),('18177701557','member','Agent/2001,0',1),('18177701557','member','Agent/2002,0',2),('18177701557','member','Agent/2003,0',3),('18177701557','member','Agent/2004,0',4),('18177701557','member','Agent/2005,0',5),('18177701557','member','Agent/2006,0',6),('18177701557','member','Agent/2007,0',7),('18177701557','member','Agent/2008,0',8),('18177701557','member','Agent/2009,0',9),('18177701559','maxlen','0',0),('18177701559','joinempty','yes',0),('18177701559','leavewhenempty','no',0),('18177701559','strategy','random',0),('18177701559','timeout','0',0),('18177701559','retry','5',0),('18177701559','wrapuptime','0',0),('18177701559','announce-frequency','0',0),('18177701559','announce-holdtime','no',0),('18177701559','announce-position','no',0),('18177701559','queue-youarenext','silence/1',0),('18177701559','queue-thereare','silence/1',0),('18177701559','queue-callswaiting','silence/1',0),('18177701559','queue-thankyou','',0),('18177701559','periodic-announce-frequency','0',0),('18177701559','monitor-format','',0),('18177701559','monitor-join','yes',0),('18177701559','eventwhencalled','no',0),('18177701559','eventmemberstatus','no',0),('18177701559','weight','0',0),('18177701559','autofill','no',0),('18177701559','ringinuse','yes',0),('18177701559','reportholdtime','no',0),('18177701559','autopause','no',0),('18177701559','autopausedelay','0',0),('18177701559','servicelevel','60',0),('18177701559','memberdelay','0',0),('18177701559','timeoutrestart','no',0),('18177701559','skip_joinannounce','',0),('18177701559','cron_schedule','never',0),('18177701559','autopausebusy','no',0),('18177701559','autopauseunavail','no',0),('18177701559','timeoutpriority','app',0),('18177701559','penaltymemberslimit','0',0),('18177701559','answered_elsewhere','0',0),('18177701559','member','Agent/2000,0',0),('18177701559','member','Agent/2001,0',1),('18177701559','member','Agent/2002,0',2),('18177701559','member','Agent/2003,0',3),('18177701559','member','Agent/2004,0',4),('18177701559','member','Agent/2005,0',5),('18177701559','member','Agent/2006,0',6),('18177701559','member','Agent/2007,0',7),('18177701559','member','Agent/2008,0',8),('18177701559','member','Agent/2009,0',9),('18177701560','maxlen','0',0),('18177701560','joinempty','yes',0),('18177701560','leavewhenempty','no',0),('18177701560','strategy','random',0),('18177701560','timeout','0',0),('18177701560','retry','5',0),('18177701560','wrapuptime','0',0),('18177701560','announce-frequency','0',0),('18177701560','announce-holdtime','no',0),('18177701560','announce-position','no',0),('18177701560','queue-youarenext','silence/1',0),('18177701560','queue-thereare','silence/1',0),('18177701560','queue-callswaiting','silence/1',0),('18177701560','queue-thankyou','',0),('18177701560','periodic-announce-frequency','0',0),('18177701560','monitor-format','',0),('18177701560','monitor-join','yes',0),('18177701560','eventwhencalled','no',0),('18177701560','eventmemberstatus','no',0),('18177701560','weight','0',0),('18177701560','autofill','no',0),('18177701560','ringinuse','yes',0),('18177701560','reportholdtime','no',0),('18177701560','autopause','no',0),('18177701560','autopausedelay','0',0),('18177701560','servicelevel','60',0),('18177701560','memberdelay','0',0),('18177701560','timeoutrestart','no',0),('18177701560','skip_joinannounce','',0),('18177701560','cron_schedule','never',0),('18177701560','autopausebusy','no',0),('18177701560','autopauseunavail','no',0),('18177701560','timeoutpriority','app',0),('18177701560','penaltymemberslimit','0',0),('18177701560','answered_elsewhere','0',0),('18177701560','member','Agent/2000,0',0),('18177701560','member','Agent/2001,0',1),('18177701560','member','Agent/2002,0',2),('18177701560','member','Agent/2003,0',3),('18177701560','member','Agent/2004,0',4),('18177701560','member','Agent/2005,0',5),('18177701560','member','Agent/2006,0',6),('18177701560','member','Agent/2007,0',7),('18177701560','member','Agent/2008,0',8),('18177701560','member','Agent/2009,0',9),('18177701561','maxlen','0',0),('18177701561','joinempty','yes',0),('18177701561','leavewhenempty','no',0),('18177701561','strategy','random',0),('18177701561','timeout','0',0),('18177701561','retry','5',0),('18177701561','wrapuptime','0',0),('18177701561','announce-frequency','0',0),('18177701561','announce-holdtime','no',0),('18177701561','announce-position','no',0),('18177701561','queue-youarenext','silence/1',0),('18177701561','queue-thereare','silence/1',0),('18177701561','queue-callswaiting','silence/1',0),('18177701561','queue-thankyou','',0),('18177701561','periodic-announce-frequency','0',0),('18177701561','monitor-format','',0),('18177701561','monitor-join','yes',0),('18177701561','eventwhencalled','no',0),('18177701561','eventmemberstatus','no',0),('18177701561','weight','0',0),('18177701561','autofill','no',0),('18177701561','ringinuse','yes',0),('18177701561','reportholdtime','no',0),('18177701561','autopause','no',0),('18177701561','autopausedelay','0',0),('18177701561','servicelevel','60',0),('18177701561','memberdelay','0',0),('18177701561','timeoutrestart','no',0),('18177701561','skip_joinannounce','',0),('18177701561','cron_schedule','never',0),('18177701561','autopausebusy','no',0),('18177701561','autopauseunavail','no',0),('18177701561','timeoutpriority','app',0),('18177701561','penaltymemberslimit','0',0),('18177701561','answered_elsewhere','0',0),('18177701561','member','Agent/2000,0',0),('18177701561','member','Agent/2001,0',1),('18177701561','member','Agent/2002,0',2),('18177701561','member','Agent/2003,0',3),('18177701561','member','Agent/2004,0',4),('18177701561','member','Agent/2005,0',5),('18177701561','member','Agent/2006,0',6),('18177701561','member','Agent/2007,0',7),('18177701561','member','Agent/2008,0',8),('18177701561','member','Agent/2009,0',9),('15589958534','member','Agent/2003,0',3),('15589958534','member','Agent/2002,0',2),('15589958534','member','Agent/2001,0',1),('18177700699','timeoutpriority','app',0),('18177700699','penaltymemberslimit','0',0),('18177700699','answered_elsewhere','0',0),('18177700699','servicelevel','60',0),('18177700699','memberdelay','0',0),('18177700699','timeoutrestart','no',0),('18177700699','skip_joinannounce','',0),('18177700699','cron_schedule','never',0),('18177700699','autopausebusy','no',0),('18177700699','autopauseunavail','no',0),('18177700699','announce-holdtime','no',0),('18177700699','announce-position','no',0),('18177700699','queue-youarenext','silence/1',0),('18177700699','queue-thereare','silence/1',0),('18177700699','queue-callswaiting','silence/1',0),('18177700699','queue-thankyou','',0),('18177700699','periodic-announce-frequency','0',0),('18177700699','maxlen','0',0),('18177700699','joinempty','yes',0),('18177700699','leavewhenempty','no',0),('18177700699','strategy','random',0),('18177700699','timeout','0',0),('18177700699','retry','5',0),('18177700699','wrapuptime','0',0),('18177700699','announce-frequency','0',0),('18177701563','maxlen','0',0),('18177701563','joinempty','yes',0),('18177701563','leavewhenempty','no',0),('18177701563','strategy','random',0),('18177701563','timeout','0',0),('18177701563','retry','5',0),('18177701563','wrapuptime','0',0),('18177701563','announce-frequency','0',0),('18177701563','announce-holdtime','no',0),('18177701563','announce-position','no',0),('18177701563','queue-youarenext','silence/1',0),('18177701563','queue-thereare','silence/1',0),('18177701563','queue-callswaiting','silence/1',0),('18177701563','queue-thankyou','',0),('18177701563','periodic-announce-frequency','0',0),('18177701563','monitor-format','',0),('18177701563','monitor-join','yes',0),('18177701563','eventwhencalled','no',0),('18177701563','eventmemberstatus','no',0),('18177701563','weight','0',0),('18177701563','autofill','no',0),('18177701563','ringinuse','yes',0),('18177701563','reportholdtime','no',0),('18177701563','autopause','no',0),('18177701563','autopausedelay','0',0),('18177701563','servicelevel','60',0),('18177701563','memberdelay','0',0),('18177701563','timeoutrestart','no',0),('18177701563','skip_joinannounce','',0),('18177701563','cron_schedule','never',0),('18177701563','autopausebusy','no',0),('18177701563','autopauseunavail','no',0),('18177701563','timeoutpriority','app',0),('18177701563','penaltymemberslimit','0',0),('18177701563','answered_elsewhere','0',0),('18177701563','member','Agent/2000,0',0),('18177701563','member','Agent/2001,0',1),('18177701563','member','Agent/2002,0',2),('18177701563','member','Agent/2003,0',3),('18177701563','member','Agent/2004,0',4),('18177701563','member','Agent/2005,0',5),('18177701563','member','Agent/2006,0',6),('18177701563','member','Agent/2007,0',7),('18177701563','member','Agent/2008,0',8),('18177701563','member','Agent/2009,0',9),('18177701562','maxlen','0',0),('18177701562','joinempty','yes',0),('18177701562','leavewhenempty','no',0),('18177701562','strategy','random',0),('18177701562','timeout','0',0),('18177701562','retry','5',0),('18177701562','wrapuptime','0',0),('18177701562','announce-frequency','0',0),('18177701562','announce-holdtime','no',0),('18177701562','announce-position','no',0),('18177701562','queue-youarenext','silence/1',0),('18177701562','queue-thereare','silence/1',0),('18177701562','queue-callswaiting','silence/1',0),('18177701562','queue-thankyou','',0),('18177701562','periodic-announce-frequency','0',0),('18177701562','monitor-format','',0),('18177701562','monitor-join','yes',0),('18177701562','eventwhencalled','no',0),('18177701562','eventmemberstatus','no',0),('18177701562','weight','0',0),('18177701562','autofill','no',0),('18177701562','ringinuse','yes',0),('18177701562','reportholdtime','no',0),('18177701562','autopause','no',0),('18177701562','autopausedelay','0',0),('18177701562','servicelevel','60',0),('18177701562','memberdelay','0',0),('18177701562','timeoutrestart','no',0),('18177701562','skip_joinannounce','',0),('18177701562','cron_schedule','never',0),('18177701562','autopausebusy','no',0),('18177701562','autopauseunavail','no',0),('18177701562','timeoutpriority','app',0),('18177701562','penaltymemberslimit','0',0),('18177701562','answered_elsewhere','0',0),('18177701562','member','Agent/2000,0',0),('18177701562','member','Agent/2001,0',1),('18177701562','member','Agent/2002,0',2),('18177701562','member','Agent/2003,0',3),('18177701562','member','Agent/2004,0',4),('18177701562','member','Agent/2005,0',5),('18177701562','member','Agent/2006,0',6),('18177701562','member','Agent/2007,0',7),('18177701562','member','Agent/2008,0',8),('18177701562','member','Agent/2009,0',9),('18177701564','maxlen','0',0),('18177701564','joinempty','yes',0),('18177701564','leavewhenempty','no',0),('18177701564','strategy','random',0),('18177701564','timeout','0',0),('18177701564','retry','5',0),('18177701564','wrapuptime','0',0),('18177701564','announce-frequency','0',0),('18177701564','announce-holdtime','no',0),('18177701564','announce-position','no',0),('18177701564','queue-youarenext','silence/1',0),('18177701564','queue-thereare','silence/1',0),('18177701564','queue-callswaiting','silence/1',0),('18177701564','queue-thankyou','',0),('18177701564','periodic-announce-frequency','0',0),('18177701564','monitor-format','',0),('18177701564','monitor-join','yes',0),('18177701564','eventwhencalled','no',0),('18177701564','eventmemberstatus','no',0),('18177701564','weight','0',0),('18177701564','autofill','no',0),('18177701564','ringinuse','yes',0),('18177701564','reportholdtime','no',0),('18177701564','autopause','no',0),('18177701564','autopausedelay','0',0),('18177701564','servicelevel','60',0),('18177701564','memberdelay','0',0),('18177701564','timeoutrestart','no',0),('18177701564','skip_joinannounce','',0),('18177701564','cron_schedule','never',0),('18177701564','autopausebusy','no',0),('18177701564','autopauseunavail','no',0),('18177701564','timeoutpriority','app',0),('18177701564','penaltymemberslimit','0',0),('18177701564','answered_elsewhere','0',0),('18177701564','member','Agent/2000,0',0),('18177701564','member','Agent/2001,0',1),('18177701564','member','Agent/2002,0',2),('18177701564','member','Agent/2003,0',3),('18177701564','member','Agent/2004,0',4),('18177701564','member','Agent/2005,0',5),('18177701564','member','Agent/2006,0',6),('18177701564','member','Agent/2007,0',7),('18177701564','member','Agent/2008,0',8),('18177701564','member','Agent/2009,0',9),('18177701565','maxlen','0',0),('18177701565','joinempty','yes',0),('18177701565','leavewhenempty','no',0),('18177701565','strategy','random',0),('18177701565','timeout','0',0),('18177701565','retry','5',0),('18177701565','wrapuptime','0',0),('18177701565','announce-frequency','0',0),('18177701565','announce-holdtime','no',0),('18177701565','announce-position','no',0),('18177701565','queue-youarenext','silence/1',0),('18177701565','queue-thereare','silence/1',0),('18177701565','queue-callswaiting','silence/1',0),('18177701565','queue-thankyou','',0),('18177701565','periodic-announce-frequency','0',0),('18177701565','monitor-format','',0),('18177701565','monitor-join','yes',0),('18177701565','eventwhencalled','no',0),('18177701565','eventmemberstatus','no',0),('18177701565','weight','0',0),('18177701565','autofill','no',0),('18177701565','ringinuse','yes',0),('18177701565','reportholdtime','no',0),('18177701565','autopause','no',0),('18177701565','autopausedelay','0',0),('18177701565','servicelevel','60',0),('18177701565','memberdelay','0',0),('18177701565','timeoutrestart','no',0),('18177701565','skip_joinannounce','',0),('18177701565','cron_schedule','never',0),('18177701565','autopausebusy','no',0),('18177701565','autopauseunavail','no',0),('18177701565','timeoutpriority','app',0),('18177701565','penaltymemberslimit','0',0),('18177701565','answered_elsewhere','0',0),('18177701565','member','Agent/2000,0',0),('18177701565','member','Agent/2001,0',1),('18177701565','member','Agent/2002,0',2),('18177701565','member','Agent/2003,0',3),('18177701565','member','Agent/2004,0',4),('18177701565','member','Agent/2005,0',5),('18177701565','member','Agent/2006,0',6),('18177701565','member','Agent/2007,0',7),('18177701565','member','Agent/2008,0',8),('18177701565','member','Agent/2009,0',9),('15588804680','maxlen','0',0),('15588804680','joinempty','yes',0),('15588804680','leavewhenempty','no',0),('15588804680','strategy','random',0),('15588804680','timeout','0',0),('15588804680','retry','5',0),('15588804680','wrapuptime','0',0),('15588804680','announce-frequency','0',0),('15588804680','announce-holdtime','no',0),('15588804680','announce-position','no',0),('15588804680','queue-youarenext','silence/1',0),('15588804680','queue-thereare','silence/1',0),('15588804680','queue-callswaiting','silence/1',0),('15588804680','queue-thankyou','',0),('15588804680','periodic-announce-frequency','0',0),('15588804680','monitor-format','',0),('15588804680','monitor-join','yes',0),('15588804680','eventwhencalled','no',0),('15588804680','eventmemberstatus','no',0),('15588804680','weight','0',0),('15588804680','autofill','no',0),('15588804680','ringinuse','yes',0),('15588804680','reportholdtime','no',0),('15588804680','autopause','no',0),('15588804680','autopausedelay','0',0),('15588804680','servicelevel','60',0),('15588804680','memberdelay','0',0),('15588804680','timeoutrestart','no',0),('15588804680','skip_joinannounce','',0),('15588804680','cron_schedule','never',0),('15588804680','autopausebusy','no',0),('15588804680','autopauseunavail','no',0),('15588804680','timeoutpriority','app',0),('15588804680','penaltymemberslimit','0',0),('15588804680','answered_elsewhere','0',0),('15588804680','member','Agent/2000,0',0),('15588804680','member','Agent/2001,0',1),('15588804680','member','Agent/2002,0',2),('15588804680','member','Agent/2003,0',3),('15588804680','member','Agent/2004,0',4),('15588804680','member','Agent/2005,0',5),('15588804680','member','Agent/2006,0',6),('15588804680','member','Agent/2007,0',7),('15588804680','member','Agent/2008,0',8),('15588804680','member','Agent/2009,0',9),('19988001966','maxlen','0',0),('19988001966','joinempty','yes',0),('19988001966','leavewhenempty','no',0),('19988001966','strategy','random',0),('19988001966','timeout','0',0),('19988001966','retry','5',0),('19988001966','wrapuptime','0',0),('19988001966','announce-frequency','0',0),('19988001966','announce-holdtime','no',0),('19988001966','announce-position','no',0),('19988001966','queue-youarenext','silence/1',0),('19988001966','queue-thereare','silence/1',0),('19988001966','queue-callswaiting','silence/1',0),('19988001966','queue-thankyou','',0),('19988001966','periodic-announce-frequency','0',0),('19988001966','monitor-format','',0),('19988001966','monitor-join','yes',0),('19988001966','eventwhencalled','no',0),('19988001966','eventmemberstatus','no',0),('19988001966','weight','0',0),('19988001966','autofill','no',0),('19988001966','ringinuse','yes',0),('19988001966','reportholdtime','no',0),('19988001966','autopause','no',0),('19988001966','autopausedelay','0',0),('19988001966','servicelevel','60',0),('19988001966','memberdelay','0',0),('19988001966','timeoutrestart','no',0),('19988001966','skip_joinannounce','',0),('19988001966','cron_schedule','never',0),('19988001966','autopausebusy','no',0),('19988001966','autopauseunavail','no',0),('19988001966','timeoutpriority','app',0),('19988001966','penaltymemberslimit','0',0),('19988001966','answered_elsewhere','0',0),('19988001966','member','Agent/2000,0',0),('19988001966','member','Agent/2001,0',1),('19988001966','member','Agent/2002,0',2),('19988001966','member','Agent/2003,0',3),('19988001966','member','Agent/2004,0',4),('19988001966','member','Agent/2005,0',5),('19988001966','member','Agent/2006,0',6),('19988001966','member','Agent/2007,0',7),('19988001966','member','Agent/2008,0',8),('19988001966','member','Agent/2009,0',9),('18177701566','maxlen','0',0),('18177701566','joinempty','yes',0),('18177701566','leavewhenempty','no',0),('18177701566','strategy','random',0),('18177701566','timeout','0',0),('18177701566','retry','5',0),('18177701566','wrapuptime','0',0),('18177701566','announce-frequency','0',0),('18177701566','announce-holdtime','no',0),('18177701566','announce-position','no',0),('18177701566','queue-youarenext','silence/1',0),('18177701566','queue-thereare','silence/1',0),('18177701566','queue-callswaiting','silence/1',0),('18177701566','queue-thankyou','',0),('18177701566','periodic-announce-frequency','0',0),('18177701566','monitor-format','',0),('18177701566','monitor-join','yes',0),('18177701566','eventwhencalled','no',0),('18177701566','eventmemberstatus','no',0),('18177701566','weight','0',0),('18177701566','autofill','no',0),('18177701566','ringinuse','yes',0),('18177701566','reportholdtime','no',0),('18177701566','autopause','no',0),('18177701566','autopausedelay','0',0),('18177701566','servicelevel','60',0),('18177701566','memberdelay','0',0),('18177701566','timeoutrestart','no',0),('18177701566','skip_joinannounce','',0),('18177701566','cron_schedule','never',0),('18177701566','autopausebusy','no',0),('18177701566','autopauseunavail','no',0),('18177701566','timeoutpriority','app',0),('18177701566','penaltymemberslimit','0',0),('18177701566','answered_elsewhere','0',0),('18177701566','member','Agent/2000,0',0),('18177701566','member','Agent/2001,0',1),('18177701566','member','Agent/2002,0',2),('18177701566','member','Agent/2003,0',3),('18177701566','member','Agent/2004,0',4),('18177701566','member','Agent/2005,0',5),('18177701566','member','Agent/2006,0',6),('18177701566','member','Agent/2007,0',7),('18177701566','member','Agent/2008,0',8),('18177701566','member','Agent/2009,0',9),('18177701567','maxlen','0',0),('18177701567','joinempty','yes',0),('18177701567','leavewhenempty','no',0),('18177701567','strategy','random',0),('18177701567','timeout','0',0),('18177701567','retry','5',0),('18177701567','wrapuptime','0',0),('18177701567','announce-frequency','0',0),('18177701567','announce-holdtime','no',0),('18177701567','announce-position','no',0),('18177701567','queue-youarenext','silence/1',0),('18177701567','queue-thereare','silence/1',0),('18177701567','queue-callswaiting','silence/1',0),('18177701567','queue-thankyou','',0),('18177701567','periodic-announce-frequency','0',0),('18177701567','monitor-format','',0),('18177701567','monitor-join','yes',0),('18177701567','eventwhencalled','no',0),('18177701567','eventmemberstatus','no',0),('18177701567','weight','0',0),('18177701567','autofill','no',0),('18177701567','ringinuse','yes',0),('18177701567','reportholdtime','no',0),('18177701567','autopause','no',0),('18177701567','autopausedelay','0',0),('18177701567','servicelevel','60',0),('18177701567','memberdelay','0',0),('18177701567','timeoutrestart','no',0),('18177701567','skip_joinannounce','',0),('18177701567','cron_schedule','never',0),('18177701567','autopausebusy','no',0),('18177701567','autopauseunavail','no',0),('18177701567','timeoutpriority','app',0),('18177701567','penaltymemberslimit','0',0),('18177701567','answered_elsewhere','0',0),('18177701567','member','Agent/2000,0',0),('18177701567','member','Agent/2001,0',1),('18177701567','member','Agent/2002,0',2),('18177701567','member','Agent/2003,0',3),('18177701567','member','Agent/2004,0',4),('18177701567','member','Agent/2005,0',5),('18177701567','member','Agent/2006,0',6),('18177701567','member','Agent/2007,0',7),('18177701567','member','Agent/2008,0',8),('18177701567','member','Agent/2009,0',9),('18177701568','maxlen','0',0),('18177701568','joinempty','yes',0),('18177701568','leavewhenempty','no',0),('18177701568','strategy','random',0),('18177701568','timeout','0',0),('18177701568','retry','5',0),('18177701568','wrapuptime','0',0),('18177701568','announce-frequency','0',0),('18177701568','announce-holdtime','no',0),('18177701568','announce-position','no',0),('18177701568','queue-youarenext','silence/1',0),('18177701568','queue-thereare','silence/1',0),('18177701568','queue-callswaiting','silence/1',0),('18177701568','queue-thankyou','',0),('18177701568','periodic-announce-frequency','0',0),('18177701568','monitor-format','',0),('18177701568','monitor-join','yes',0),('18177701568','eventwhencalled','no',0),('18177701568','eventmemberstatus','no',0),('18177701568','weight','0',0),('18177701568','autofill','no',0),('18177701568','ringinuse','yes',0),('18177701568','reportholdtime','no',0),('18177701568','autopause','no',0),('18177701568','autopausedelay','0',0),('18177701568','servicelevel','60',0),('18177701568','memberdelay','0',0),('18177701568','timeoutrestart','no',0),('18177701568','skip_joinannounce','',0),('18177701568','cron_schedule','never',0),('18177701568','autopausebusy','no',0),('18177701568','autopauseunavail','no',0),('18177701568','timeoutpriority','app',0),('18177701568','penaltymemberslimit','0',0),('18177701568','answered_elsewhere','0',0),('18177701568','member','Agent/2000,0',0),('18177701568','member','Agent/2001,0',1),('18177701568','member','Agent/2002,0',2),('18177701568','member','Agent/2003,0',3),('18177701568','member','Agent/2004,0',4),('18177701568','member','Agent/2005,0',5),('18177701568','member','Agent/2006,0',6),('18177701568','member','Agent/2007,0',7),('18177701568','member','Agent/2008,0',8),('18177701568','member','Agent/2009,0',9),('18177701569','maxlen','0',0),('18177701569','joinempty','yes',0),('18177701569','leavewhenempty','no',0),('18177701569','strategy','random',0),('18177701569','timeout','0',0),('18177701569','retry','5',0),('18177701569','wrapuptime','0',0),('18177701569','announce-frequency','0',0),('18177701569','announce-holdtime','no',0),('18177701569','announce-position','no',0),('18177701569','queue-youarenext','silence/1',0),('18177701569','queue-thereare','silence/1',0),('18177701569','queue-callswaiting','silence/1',0),('18177701569','queue-thankyou','',0),('18177701569','periodic-announce-frequency','0',0),('18177701569','monitor-format','',0),('18177701569','monitor-join','yes',0),('18177701569','eventwhencalled','no',0),('18177701569','eventmemberstatus','no',0),('18177701569','weight','0',0),('18177701569','autofill','no',0),('18177701569','ringinuse','yes',0),('18177701569','reportholdtime','no',0),('18177701569','autopause','no',0),('18177701569','autopausedelay','0',0),('18177701569','servicelevel','60',0),('18177701569','memberdelay','0',0),('18177701569','timeoutrestart','no',0),('18177701569','skip_joinannounce','',0),('18177701569','cron_schedule','never',0),('18177701569','autopausebusy','no',0),('18177701569','autopauseunavail','no',0),('18177701569','timeoutpriority','app',0),('18177701569','penaltymemberslimit','0',0),('18177701569','answered_elsewhere','0',0),('18177701569','member','Agent/2000,0',0),('18177701569','member','Agent/2001,0',1),('18177701569','member','Agent/2002,0',2),('18177701569','member','Agent/2003,0',3),('18177701569','member','Agent/2004,0',4),('18177701569','member','Agent/2005,0',5),('18177701569','member','Agent/2006,0',6),('18177701569','member','Agent/2007,0',7),('18177701569','member','Agent/2008,0',8),('18177701569','member','Agent/2009,0',9),('18718800153','maxlen','0',0),('18718800153','joinempty','yes',0),('18718800153','leavewhenempty','no',0),('18718800153','strategy','random',0),('18718800153','timeout','0',0),('18718800153','retry','5',0),('18718800153','wrapuptime','0',0),('18718800153','announce-frequency','0',0),('18718800153','announce-holdtime','no',0),('18718800153','announce-position','no',0),('18718800153','queue-youarenext','silence/1',0),('18718800153','queue-thereare','silence/1',0),('18718800153','queue-callswaiting','silence/1',0),('18718800153','queue-thankyou','',0),('18718800153','periodic-announce-frequency','0',0),('18718800153','monitor-format','',0),('18718800153','monitor-join','yes',0),('18718800153','eventwhencalled','no',0),('18718800153','eventmemberstatus','no',0),('18718800153','weight','0',0),('18718800153','autofill','no',0),('18718800153','ringinuse','yes',0),('18718800153','reportholdtime','no',0),('18718800153','autopause','no',0),('18718800153','autopausedelay','0',0),('18718800153','servicelevel','60',0),('18718800153','memberdelay','0',0),('18718800153','timeoutrestart','no',0),('18718800153','skip_joinannounce','',0),('18718800153','cron_schedule','never',0),('18718800153','autopausebusy','no',0),('18718800153','autopauseunavail','no',0),('18718800153','timeoutpriority','app',0),('18718800153','penaltymemberslimit','0',0),('18718800153','answered_elsewhere','0',0),('18718800153','member','Agent/2000,0',0),('18718800153','member','Agent/2001,0',1),('18718800153','member','Agent/2002,0',2),('18718800153','member','Agent/2003,0',3),('18718800153','member','Agent/2004,0',4),('18718800153','member','Agent/2005,0',5),('18718800153','member','Agent/2006,0',6),('18718800153','member','Agent/2007,0',7),('18718800153','member','Agent/2008,0',8),('18718800153','member','Agent/2009,0',9),('18177700673','member','Agent/2000,0',0),('18177700673','answered_elsewhere','0',0),('18177701570','maxlen','0',0),('18177701570','joinempty','yes',0),('18177701570','leavewhenempty','no',0),('18177701570','strategy','random',0),('18177701570','timeout','0',0),('18177701570','retry','5',0),('18177701570','wrapuptime','0',0),('18177701570','announce-frequency','0',0),('18177701570','announce-holdtime','no',0),('18177701570','announce-position','no',0),('18177701570','queue-youarenext','silence/1',0),('18177701570','queue-thereare','silence/1',0),('18177701570','queue-callswaiting','silence/1',0),('18177701570','queue-thankyou','',0),('18177701570','periodic-announce-frequency','0',0),('18177701570','monitor-format','',0),('18177701570','monitor-join','yes',0),('18177701570','eventwhencalled','no',0),('18177701570','eventmemberstatus','no',0),('18177701570','weight','0',0),('18177701570','autofill','no',0),('18177701570','ringinuse','yes',0),('18177701570','reportholdtime','no',0),('18177701570','autopause','no',0),('18177701570','autopausedelay','0',0),('18177701570','servicelevel','60',0),('18177701570','memberdelay','0',0),('18177701570','timeoutrestart','no',0),('18177701570','skip_joinannounce','',0),('18177701570','cron_schedule','never',0),('18177701570','autopausebusy','no',0),('18177701570','autopauseunavail','no',0),('18177701570','timeoutpriority','app',0),('18177701570','penaltymemberslimit','0',0),('18177701570','answered_elsewhere','0',0),('18177701570','member','Agent/2000,0',0),('18177701570','member','Agent/2001,0',1),('18177701570','member','Agent/2002,0',2),('18177701570','member','Agent/2003,0',3),('18177701570','member','Agent/2004,0',4),('18177701570','member','Agent/2005,0',5),('18177701570','member','Agent/2006,0',6),('18177701570','member','Agent/2007,0',7),('18177701570','member','Agent/2008,0',8),('18177701570','member','Agent/2009,0',9),('18177701571','maxlen','0',0),('18177701571','joinempty','yes',0),('18177701571','leavewhenempty','no',0),('18177701571','strategy','random',0),('18177701571','timeout','0',0),('18177701571','retry','5',0),('18177701571','wrapuptime','0',0),('18177701571','announce-frequency','0',0),('18177701571','announce-holdtime','no',0),('18177701571','announce-position','no',0),('18177701571','queue-youarenext','silence/1',0),('18177701571','queue-thereare','silence/1',0),('18177701571','queue-callswaiting','silence/1',0),('18177701571','queue-thankyou','',0),('18177701571','periodic-announce-frequency','0',0),('18177701571','monitor-format','',0),('18177701571','monitor-join','yes',0),('18177701571','eventwhencalled','no',0),('18177701571','eventmemberstatus','no',0),('18177701571','weight','0',0),('18177701571','autofill','no',0),('18177701571','ringinuse','yes',0),('18177701571','reportholdtime','no',0),('18177701571','autopause','no',0),('18177701571','autopausedelay','0',0),('18177701571','servicelevel','60',0),('18177701571','memberdelay','0',0),('18177701571','timeoutrestart','no',0),('18177701571','skip_joinannounce','',0),('18177701571','cron_schedule','never',0),('18177701571','autopausebusy','no',0),('18177701571','autopauseunavail','no',0),('18177701571','timeoutpriority','app',0),('18177701571','penaltymemberslimit','0',0),('18177701571','answered_elsewhere','0',0),('18177701571','member','Agent/2000,0',0),('18177701571','member','Agent/2001,0',1),('18177701571','member','Agent/2002,0',2),('18177701571','member','Agent/2003,0',3),('18177701571','member','Agent/2004,0',4),('18177701571','member','Agent/2005,0',5),('18177701571','member','Agent/2006,0',6),('18177701571','member','Agent/2007,0',7),('18177701571','member','Agent/2008,0',8),('18177701571','member','Agent/2009,0',9),('18177700378','member','Agent/2009,0',9),('18177701572','maxlen','0',0),('18177701572','joinempty','yes',0),('18177701572','leavewhenempty','no',0),('18177701572','strategy','random',0),('18177701572','timeout','0',0),('18177701572','retry','5',0),('18177701572','wrapuptime','0',0),('18177701572','announce-frequency','0',0),('18177701572','announce-holdtime','no',0),('18177701572','announce-position','no',0),('18177701572','queue-youarenext','silence/1',0),('18177701572','queue-thereare','silence/1',0),('18177701572','queue-callswaiting','silence/1',0),('18177701572','queue-thankyou','',0),('18177701572','periodic-announce-frequency','0',0),('18177701572','monitor-format','',0),('18177701572','monitor-join','yes',0),('18177701572','eventwhencalled','no',0),('18177701572','eventmemberstatus','no',0),('18177701572','weight','0',0),('18177701572','autofill','no',0),('18177701572','ringinuse','yes',0),('18177701572','reportholdtime','no',0),('18177701572','autopause','no',0),('18177701572','autopausedelay','0',0),('18177701572','servicelevel','60',0),('18177701572','memberdelay','0',0),('18177701572','timeoutrestart','no',0),('18177701572','skip_joinannounce','',0),('18177701572','cron_schedule','never',0),('18177701572','autopausebusy','no',0),('18177701572','autopauseunavail','no',0),('18177701572','timeoutpriority','app',0),('18177701572','penaltymemberslimit','0',0),('18177701572','answered_elsewhere','0',0),('18177701572','member','Agent/2000,0',0),('18177701572','member','Agent/2001,0',1),('18177701572','member','Agent/2002,0',2),('18177701572','member','Agent/2003,0',3),('18177701572','member','Agent/2004,0',4),('18177701572','member','Agent/2005,0',5),('18177701572','member','Agent/2006,0',6),('18177701572','member','Agent/2007,0',7),('18177701572','member','Agent/2008,0',8),('18177701572','member','Agent/2009,0',9),('18177701573','maxlen','0',0),('18177701573','joinempty','yes',0),('18177701573','leavewhenempty','no',0),('18177701573','strategy','random',0),('18177701573','timeout','0',0),('18177701573','retry','5',0),('18177701573','wrapuptime','0',0),('18177701573','announce-frequency','0',0),('18177701573','announce-holdtime','no',0),('18177701573','announce-position','no',0),('18177701573','queue-youarenext','silence/1',0),('18177701573','queue-thereare','silence/1',0),('18177701573','queue-callswaiting','silence/1',0),('18177701573','queue-thankyou','',0),('18177701573','periodic-announce-frequency','0',0),('18177701573','monitor-format','',0),('18177701573','monitor-join','yes',0),('18177701573','eventwhencalled','no',0),('18177701573','eventmemberstatus','no',0),('18177701573','weight','0',0),('18177701573','autofill','no',0),('18177701573','ringinuse','yes',0),('18177701573','reportholdtime','no',0),('18177701573','autopause','no',0),('18177701573','autopausedelay','0',0),('18177701573','servicelevel','60',0),('18177701573','memberdelay','0',0),('18177701573','timeoutrestart','no',0),('18177701573','skip_joinannounce','',0),('18177701573','cron_schedule','never',0),('18177701573','autopausebusy','no',0),('18177701573','autopauseunavail','no',0),('18177701573','timeoutpriority','app',0),('18177701573','penaltymemberslimit','0',0),('18177701573','answered_elsewhere','0',0),('18177701573','member','Agent/2000,0',0),('18177701573','member','Agent/2001,0',1),('18177701573','member','Agent/2002,0',2),('18177701573','member','Agent/2003,0',3),('18177701573','member','Agent/2004,0',4),('18177701573','member','Agent/2005,0',5),('18177701573','member','Agent/2006,0',6),('18177701573','member','Agent/2007,0',7),('18177701573','member','Agent/2008,0',8),('18177701573','member','Agent/2009,0',9),('18177701574','cron_schedule','never',0),('18177701574','autopausebusy','no',0),('18177701574','eventwhencalled','no',0),('18177701574','maxlen','0',0),('18177701574','joinempty','yes',0),('18177701574','autopauseunavail','no',0),('18177701574','ringinuse','yes',0),('18177701574','reportholdtime','no',0),('18177701574','autopause','no',0),('18177701574','autopausedelay','0',0),('18177701574','servicelevel','60',0),('18177701574','memberdelay','0',0),('18177701574','timeoutrestart','no',0),('18177701574','skip_joinannounce','',0),('18177701574','leavewhenempty','no',0),('18177701574','weight','0',0),('18177701574','autofill','no',0),('18177701574','eventmemberstatus','no',0),('18177701574','strategy','random',0),('18177701574','timeout','0',0),('18177701574','retry','5',0),('18177701574','wrapuptime','0',0),('18177701574','announce-frequency','0',0),('18177701574','announce-holdtime','no',0),('18177701574','announce-position','no',0),('18177701574','queue-youarenext','silence/1',0),('18177701574','queue-thereare','silence/1',0),('18177701574','queue-callswaiting','silence/1',0),('18177701574','queue-thankyou','',0),('18177701574','periodic-announce-frequency','0',0),('18177701574','monitor-format','',0),('18177701574','monitor-join','yes',0),('18177701574','timeoutpriority','app',0),('18177701574','penaltymemberslimit','0',0),('18177701574','answered_elsewhere','0',0),('18177701574','member','Agent/2000,0',0),('18177701574','member','Agent/2001,0',1),('18177701574','member','Agent/2002,0',2),('18177701574','member','Agent/2003,0',3),('18177701574','member','Agent/2004,0',4),('18177701574','member','Agent/2005,0',5),('18177701574','member','Agent/2006,0',6),('18177701574','member','Agent/2007,0',7),('18177701574','member','Agent/2008,0',8),('18177701574','member','Agent/2009,0',9),('13388800131','timeoutpriority','app',0),('13388800131','penaltymemberslimit','0',0),('13388800131','answered_elsewhere','0',0),('13388800131','member','Agent/2000,0',0),('13388800131','member','Agent/2001,0',1),('13388800131','member','Agent/2002,0',2),('13388800131','member','Agent/2003,0',3),('13388800131','member','Agent/2004,0',4),('13388800131','member','Agent/2005,0',5),('13388800131','member','Agent/2006,0',6),('13388800131','member','Agent/2007,0',7),('13388800131','member','Agent/2008,0',8),('13388800131','member','Agent/2009,0',9),('13335605354','maxlen','0',0),('13335605354','joinempty','yes',0),('13335605354','leavewhenempty','no',0),('13335605354','strategy','random',0),('13335605354','timeout','0',0),('13335605354','retry','5',0),('13335605354','wrapuptime','0',0),('13335605354','announce-frequency','0',0),('13335605354','announce-holdtime','no',0),('13335605354','announce-position','no',0),('13335605354','queue-youarenext','silence/1',0),('13335605354','queue-thereare','silence/1',0),('13335605354','queue-callswaiting','silence/1',0),('13335605354','queue-thankyou','',0),('13335605354','periodic-announce-frequency','0',0),('13335605354','monitor-format','',0),('13335605354','monitor-join','yes',0),('13335605354','eventwhencalled','no',0),('13335605354','eventmemberstatus','no',0),('13335605354','weight','0',0),('13335605354','autofill','no',0),('13335605354','ringinuse','yes',0),('13335605354','reportholdtime','no',0),('13335605354','autopause','no',0),('13335605354','autopausedelay','0',0),('13335605354','servicelevel','60',0),('13335605354','memberdelay','0',0),('13335605354','timeoutrestart','no',0),('13335605354','skip_joinannounce','',0),('13335605354','cron_schedule','never',0),('13335605354','autopausebusy','no',0),('13335605354','autopauseunavail','no',0),('13335605354','timeoutpriority','app',0),('13335605354','penaltymemberslimit','0',0),('13335605354','answered_elsewhere','0',0),('13335605354','member','Agent/2000,0',0),('13335605354','member','Agent/2001,0',1),('13335605354','member','Agent/2002,0',2),('13335605354','member','Agent/2003,0',3),('13335605354','member','Agent/2004,0',4),('13335605354','member','Agent/2005,0',5),('13335605354','member','Agent/2006,0',6),('13335605354','member','Agent/2007,0',7),('13335605354','member','Agent/2008,0',8),('13335605354','member','Agent/2009,0',9),('19847770197','maxlen','0',0),('19847770197','joinempty','yes',0),('19847770197','leavewhenempty','no',0),('19847770197','strategy','random',0),('19847770197','timeout','0',0),('19847770197','retry','5',0),('19847770197','wrapuptime','0',0),('19847770197','announce-frequency','0',0),('19847770197','announce-holdtime','no',0),('19847770197','announce-position','no',0),('19847770197','queue-youarenext','silence/1',0),('19847770197','queue-thereare','silence/1',0),('19847770197','queue-callswaiting','silence/1',0),('19847770197','queue-thankyou','',0),('19847770197','periodic-announce-frequency','0',0),('19847770197','monitor-format','',0),('19847770197','monitor-join','yes',0),('19847770197','eventwhencalled','no',0),('19847770197','eventmemberstatus','no',0),('19847770197','weight','0',0),('19847770197','autofill','no',0),('19847770197','ringinuse','yes',0),('19847770197','reportholdtime','no',0),('19847770197','autopause','no',0),('19847770197','autopausedelay','0',0),('19847770197','servicelevel','60',0),('19847770197','memberdelay','0',0),('19847770197','timeoutrestart','no',0),('19847770197','skip_joinannounce','',0),('19847770197','cron_schedule','never',0),('19847770197','autopausebusy','no',0),('19847770197','autopauseunavail','no',0),('19847770197','timeoutpriority','app',0),('19847770197','penaltymemberslimit','0',0),('19847770197','answered_elsewhere','0',0),('19847770197','member','Agent/2000,0',0),('19847770197','member','Agent/2001,0',1),('19847770197','member','Agent/2002,0',2),('19847770197','member','Agent/2003,0',3),('19847770197','member','Agent/2004,0',4),('19847770197','member','Agent/2005,0',5),('19847770197','member','Agent/2006,0',6),('19847770197','member','Agent/2007,0',7),('19847770197','member','Agent/2008,0',8),('19847770197','member','Agent/2009,0',9),('18177700699','member','Agent/2004,0',3),('18177700699','autopause','no',0),('18177700699','autopausedelay','0',0),('18177700699','monitor-format','',0),('18177700699','monitor-join','yes',0),('18177700699','eventwhencalled','no',0),('18177700699','eventmemberstatus','no',0),('18177700699','weight','0',0),('18177700699','autofill','no',0),('18177700699','ringinuse','yes',0),('15588804683','ringinuse','yes',0),('15588804683','reportholdtime','no',0),('15588804683','autopause','no',0),('15588804683','autopausedelay','0',0),('15588804683','servicelevel','60',0),('15588804683','memberdelay','0',0),('19988001967','maxlen','0',0),('19988001967','joinempty','yes',0),('19988001967','leavewhenempty','no',0),('19988001967','strategy','random',0),('19988001967','timeout','0',0),('19988001967','retry','5',0),('19988001967','wrapuptime','0',0),('19988001967','announce-frequency','0',0),('19988001967','announce-holdtime','no',0),('19988001967','announce-position','no',0),('19988001967','queue-youarenext','silence/1',0),('19988001967','queue-thereare','silence/1',0),('19988001967','queue-callswaiting','silence/1',0),('19988001967','queue-thankyou','',0),('19988001967','periodic-announce-frequency','0',0),('19988001967','monitor-format','',0),('19988001967','monitor-join','yes',0),('19988001967','eventwhencalled','no',0),('19988001967','eventmemberstatus','no',0),('19988001967','weight','0',0),('19988001967','autofill','no',0),('19988001967','ringinuse','yes',0),('19988001967','reportholdtime','no',0),('19988001967','autopause','no',0),('19988001967','autopausedelay','0',0),('19988001967','servicelevel','60',0),('19988001967','memberdelay','0',0),('19988001967','timeoutrestart','no',0),('19988001967','skip_joinannounce','',0),('19988001967','cron_schedule','never',0),('19988001967','autopausebusy','no',0),('19988001967','autopauseunavail','no',0),('19988001967','timeoutpriority','app',0),('19988001967','penaltymemberslimit','0',0),('19988001967','answered_elsewhere','0',0),('19988001967','member','Agent/2000,0',0),('19988001967','member','Agent/2001,0',1),('19988001967','member','Agent/2002,0',2),('19988001967','member','Agent/2003,0',3),('19988001967','member','Agent/2004,0',4),('19988001967','member','Agent/2005,0',5),('19988001967','member','Agent/2006,0',6),('19988001967','member','Agent/2007,0',7),('19988001967','member','Agent/2008,0',8),('19988001967','member','Agent/2009,0',9),('19847770190','member','Agent/2005,0',5),('19847770190','member','Agent/2006,0',6),('19847770190','member','Agent/2001,0',1),('19847770190','member','Agent/2002,0',2),('19847770190','member','Agent/2003,0',3),('19847770190','member','Agent/2004,0',4),('19847770190','penaltymemberslimit','0',0),('19847770190','answered_elsewhere','0',0),('19847770190','member','Agent/2000,0',0),('19847770190','autopauseunavail','no',0),('19847770190','timeoutpriority','app',0),('19847770190','skip_joinannounce','',0),('19847770190','cron_schedule','never',0),('19847770190','autopausebusy','no',0),('19847770190','reportholdtime','no',0),('19847770190','autopause','no',0),('19847770190','autopausedelay','0',0),('19847770190','servicelevel','60',0),('19847770190','memberdelay','0',0),('19847770190','timeoutrestart','no',0),('19847770190','maxlen','0',0),('19847770190','joinempty','yes',0),('19847770190','leavewhenempty','no',0),('19847770190','strategy','random',0),('19847770190','timeout','0',0),('19847770190','retry','5',0),('19847770190','wrapuptime','0',0),('19847770190','announce-frequency','0',0),('19847770190','announce-holdtime','no',0),('19847770190','announce-position','no',0),('19847770190','queue-youarenext','silence/1',0),('19847770190','queue-thereare','silence/1',0),('19847770190','queue-callswaiting','silence/1',0),('19847770190','queue-thankyou','',0),('19847770190','periodic-announce-frequency','0',0),('19847770190','monitor-format','',0),('19847770190','monitor-join','yes',0),('19847770190','eventwhencalled','no',0),('19847770190','eventmemberstatus','no',0),('19847770190','weight','0',0),('19847770190','autofill','no',0),('19847770190','ringinuse','yes',0),('18177701575','maxlen','0',0),('18177701575','joinempty','yes',0),('18177701575','leavewhenempty','no',0),('18177701575','strategy','random',0),('18177701575','timeout','0',0),('18177701575','retry','5',0),('18177701575','wrapuptime','0',0),('18177701575','announce-frequency','0',0),('18177701575','announce-holdtime','no',0),('18177701575','announce-position','no',0),('18177701575','queue-youarenext','silence/1',0),('18177701575','queue-thereare','silence/1',0),('18177701575','queue-callswaiting','silence/1',0),('18177701575','queue-thankyou','',0),('18177701575','periodic-announce-frequency','0',0),('18177701575','monitor-format','',0),('18177701575','monitor-join','yes',0),('18177701575','eventwhencalled','no',0),('18177701575','eventmemberstatus','no',0),('18177701575','weight','0',0),('18177701575','autofill','no',0),('18177701575','ringinuse','yes',0),('18177701575','reportholdtime','no',0),('18177701575','autopause','no',0),('18177701575','autopausedelay','0',0),('18177701575','servicelevel','60',0),('18177701575','memberdelay','0',0),('18177701575','timeoutrestart','no',0),('18177701575','skip_joinannounce','',0),('18177701575','cron_schedule','never',0),('18177701575','autopausebusy','no',0),('18177701575','autopauseunavail','no',0),('18177701575','timeoutpriority','app',0),('18177701575','penaltymemberslimit','0',0),('18177701575','answered_elsewhere','0',0),('18177701575','member','Agent/2000,0',0),('18177701575','member','Agent/2001,0',1),('18177701575','member','Agent/2002,0',2),('18177701575','member','Agent/2003,0',3),('18177701575','member','Agent/2004,0',4),('18177701575','member','Agent/2005,0',5),('18177701575','member','Agent/2006,0',6),('18177701575','member','Agent/2007,0',7),('18177701575','member','Agent/2008,0',8),('18177701575','member','Agent/2009,0',9),('14428880133','maxlen','0',0),('18177701576','member','Agent/2008,0',0),('18177701576','cron_schedule','never',0),('18177701576','autopausebusy','no',0),('18177701576','autopauseunavail','no',0),('18177701576','timeoutpriority','app',0),('18177701576','servicelevel','60',0),('18177701576','memberdelay','0',0),('18177701576','timeoutrestart','no',0),('18177701576','skip_joinannounce','',0),('18177701576','autopause','no',0),('18177701576','autopausedelay','0',0),('18177701576','eventmemberstatus','no',0),('18177701576','weight','0',0),('18177701576','autofill','no',0),('18177701576','queue-callswaiting','silence/1',0),('18177701576','queue-thankyou','',0),('18177701576','periodic-announce-frequency','0',0),('18177701576','monitor-format','',0),('18177701576','monitor-join','yes',0),('18177701576','eventwhencalled','no',0),('18177701576','maxlen','0',0),('18177701576','joinempty','yes',0),('18177701576','leavewhenempty','no',0),('18177701576','strategy','random',0),('18177701576','timeout','0',0),('18177701576','retry','5',0),('18177701576','wrapuptime','0',0),('18177701576','announce-frequency','0',0),('18177701576','announce-holdtime','no',0),('18177701576','announce-position','no',0),('18177701576','queue-youarenext','silence/1',0),('18177701576','queue-thereare','silence/1',0),('18177701577','maxlen','0',0),('18177701577','joinempty','yes',0),('18177701577','leavewhenempty','no',0),('18177701577','strategy','random',0),('18177701577','timeout','0',0),('18177701577','retry','5',0),('18177701577','wrapuptime','0',0),('18177701577','announce-frequency','0',0),('18177701577','announce-holdtime','no',0),('18177701577','announce-position','no',0),('18177701577','queue-youarenext','silence/1',0),('18177701577','queue-thereare','silence/1',0),('18177701577','queue-callswaiting','silence/1',0),('18177701577','queue-thankyou','',0),('18177701577','periodic-announce-frequency','0',0),('18177701577','monitor-format','',0),('18177701577','monitor-join','yes',0),('18177701577','eventwhencalled','no',0),('18177701577','eventmemberstatus','no',0),('18177701577','weight','0',0),('18177701577','autofill','no',0),('18177701577','ringinuse','yes',0),('18177701577','reportholdtime','no',0),('18177701577','autopause','no',0),('18177701577','autopausedelay','0',0),('18177701577','servicelevel','60',0),('18177701577','memberdelay','0',0),('18177701577','timeoutrestart','no',0),('18177701577','skip_joinannounce','',0),('18177701577','cron_schedule','never',0),('18177701577','autopausebusy','no',0),('18177701577','autopauseunavail','no',0),('18177701577','timeoutpriority','app',0),('18177701577','penaltymemberslimit','0',0),('18177701577','answered_elsewhere','0',0),('18177701577','member','Agent/2000,0',0),('18177701577','member','Agent/2001,0',1),('18177701577','member','Agent/2002,0',2),('18177701577','member','Agent/2003,0',3),('18177701577','member','Agent/2004,0',4),('18177701577','member','Agent/2005,0',5),('18177701577','member','Agent/2006,0',6),('18177701577','member','Agent/2007,0',7),('18177701577','member','Agent/2008,0',8),('18177701577','member','Agent/2009,0',9),('18177701578','maxlen','0',0),('18177701578','joinempty','yes',0),('18177701578','leavewhenempty','no',0),('18177701578','strategy','random',0),('18177701578','timeout','0',0),('18177701578','retry','5',0),('18177701578','wrapuptime','0',0),('18177701578','announce-frequency','0',0),('18177701578','announce-holdtime','no',0),('18177701578','announce-position','no',0),('18177701578','queue-youarenext','silence/1',0),('18177701578','queue-thereare','silence/1',0),('18177701578','queue-callswaiting','silence/1',0),('18177701578','queue-thankyou','',0),('18177701578','periodic-announce-frequency','0',0),('18177701578','monitor-format','',0),('18177701578','monitor-join','yes',0),('18177701578','eventwhencalled','no',0),('18177701578','eventmemberstatus','no',0),('18177701578','weight','0',0),('18177701578','autofill','no',0),('18177701578','ringinuse','yes',0),('18177701578','reportholdtime','no',0),('18177701578','autopause','no',0),('18177701578','autopausedelay','0',0),('18177701578','servicelevel','60',0),('18177701578','memberdelay','0',0),('18177701578','timeoutrestart','no',0),('18177701578','skip_joinannounce','',0),('18177701578','cron_schedule','never',0),('18177701578','autopausebusy','no',0),('18177701578','autopauseunavail','no',0),('18177701578','timeoutpriority','app',0),('18177701578','penaltymemberslimit','0',0),('18177701578','answered_elsewhere','0',0),('18177701578','member','Agent/2000,0',0),('18177701578','member','Agent/2001,0',1),('18177701578','member','Agent/2002,0',2),('18177701578','member','Agent/2003,0',3),('18177701578','member','Agent/2004,0',4),('18177701578','member','Agent/2005,0',5),('18177701578','member','Agent/2006,0',6),('18177701578','member','Agent/2007,0',7),('18177701578','member','Agent/2008,0',8),('18177701578','member','Agent/2009,0',9),('19847770190','member','Agent/2007,0',7),('19847770190','member','Agent/2008,0',8),('19847770190','member','Agent/2009,0',9),('18177701579','maxlen','0',0),('18177701579','joinempty','yes',0),('18177701579','leavewhenempty','no',0),('18177701579','strategy','random',0),('18177701579','timeout','0',0),('18177701579','retry','5',0),('18177701579','wrapuptime','0',0),('18177701579','announce-frequency','0',0),('18177701579','announce-holdtime','no',0),('18177701579','announce-position','no',0),('18177701579','queue-youarenext','silence/1',0),('18177701579','queue-thereare','silence/1',0),('18177701579','queue-callswaiting','silence/1',0),('18177701579','queue-thankyou','',0),('18177701579','periodic-announce-frequency','0',0),('18177701579','monitor-format','',0),('18177701579','monitor-join','yes',0),('18177701579','eventwhencalled','no',0),('18177701579','eventmemberstatus','no',0),('18177701579','weight','0',0),('18177701579','autofill','no',0),('18177701579','ringinuse','yes',0),('18177701579','reportholdtime','no',0),('18177701579','autopause','no',0),('18177701579','autopausedelay','0',0),('18177701579','servicelevel','60',0),('18177701579','memberdelay','0',0),('18177701579','timeoutrestart','no',0),('18177701579','skip_joinannounce','',0),('18177701579','cron_schedule','never',0),('18177701579','autopausebusy','no',0),('18177701579','autopauseunavail','no',0),('18177701579','timeoutpriority','app',0),('18177701579','penaltymemberslimit','0',0),('18177701579','answered_elsewhere','0',0),('18177701579','member','Agent/2000,0',0),('18177701579','member','Agent/2001,0',1),('18177701579','member','Agent/2002,0',2),('18177701579','member','Agent/2003,0',3),('18177701579','member','Agent/2004,0',4),('18177701579','member','Agent/2005,0',5),('18177701579','member','Agent/2006,0',6),('18177701579','member','Agent/2007,0',7),('18177701579','member','Agent/2008,0',8),('18177701579','member','Agent/2009,0',9),('18177700674','member','Agent/2003,0',3),('18177700674','member','Agent/2004,0',4),('18177700674','member','Agent/2005,0',5),('18177700674','member','Agent/2006,0',6),('18177700674','member','Agent/2007,0',7),('18177700674','member','Agent/2008,0',8),('18177700674','member','Agent/2009,0',9),('18147773870','maxlen','0',0),('18147773870','joinempty','yes',0),('18147773870','leavewhenempty','no',0),('18147773870','strategy','random',0),('18147773870','timeout','0',0),('18147773870','retry','5',0),('18147773870','wrapuptime','0',0),('18147773870','announce-frequency','0',0),('18147773870','announce-holdtime','no',0),('18147773870','announce-position','no',0),('18147773870','queue-youarenext','silence/1',0),('18147773870','queue-thereare','silence/1',0),('18147773870','queue-callswaiting','silence/1',0),('18147773870','queue-thankyou','',0),('18147773870','periodic-announce-frequency','0',0),('18147773870','monitor-format','',0),('18147773870','monitor-join','yes',0),('18147773870','eventwhencalled','no',0),('18147773870','eventmemberstatus','no',0),('18147773870','weight','0',0),('18147773870','autofill','no',0),('18147773870','ringinuse','yes',0),('18147773870','reportholdtime','no',0),('18147773870','autopause','no',0),('18147773870','autopausedelay','0',0),('18147773870','servicelevel','60',0),('18147773870','memberdelay','0',0),('18147773870','timeoutrestart','no',0),('18147773870','skip_joinannounce','',0),('18147773870','cron_schedule','never',0),('18147773870','autopausebusy','no',0),('18147773870','autopauseunavail','no',0),('18147773870','timeoutpriority','app',0),('18147773870','penaltymemberslimit','0',0),('18147773870','answered_elsewhere','0',0),('18147773870','member','Agent/2000,0',0),('18147773870','member','Agent/2001,0',1),('18147773870','member','Agent/2002,0',2),('18147773870','member','Agent/2003,0',3),('18147773870','member','Agent/2004,0',4),('18147773870','member','Agent/2005,0',5),('18147773870','member','Agent/2006,0',6),('18147773870','member','Agent/2007,0',7),('18147773870','member','Agent/2008,0',8),('18147773870','member','Agent/2009,0',9),('18147773871','maxlen','0',0),('18147773871','joinempty','yes',0),('18147773871','leavewhenempty','no',0),('18147773871','strategy','random',0),('18147773871','timeout','0',0),('18147773871','retry','5',0),('18147773871','wrapuptime','0',0),('18147773871','announce-frequency','0',0),('18147773871','announce-holdtime','no',0),('18147773871','announce-position','no',0),('18147773871','queue-youarenext','silence/1',0),('18147773871','queue-thereare','silence/1',0),('18147773871','queue-callswaiting','silence/1',0),('18147773871','queue-thankyou','',0),('18147773871','periodic-announce-frequency','0',0),('18147773871','monitor-format','',0),('18147773871','monitor-join','yes',0),('18147773871','eventwhencalled','no',0),('18147773871','eventmemberstatus','no',0),('18147773871','weight','0',0),('18147773871','autofill','no',0),('18147773871','ringinuse','yes',0),('18147773871','reportholdtime','no',0),('18147773871','autopause','no',0),('18147773871','autopausedelay','0',0),('18147773871','servicelevel','60',0),('18147773871','memberdelay','0',0),('18147773871','timeoutrestart','no',0),('18147773871','skip_joinannounce','',0),('18147773871','cron_schedule','never',0),('18147773871','autopausebusy','no',0),('18147773871','autopauseunavail','no',0),('18147773871','timeoutpriority','app',0),('18147773871','penaltymemberslimit','0',0),('18147773871','answered_elsewhere','0',0),('18147773871','member','Agent/2000,0',0),('18147773871','member','Agent/2001,0',1),('18147773871','member','Agent/2002,0',2),('18147773871','member','Agent/2003,0',3),('18147773871','member','Agent/2004,0',4),('18147773871','member','Agent/2005,0',5),('18147773871','member','Agent/2006,0',6),('18147773871','member','Agent/2007,0',7),('18147773871','member','Agent/2008,0',8),('18147773871','member','Agent/2009,0',9),('18177700377','member','Agent/2009,0',9),('18147773872','wrapuptime','0',0),('18147773872','announce-frequency','0',0),('18147773872','announce-holdtime','no',0),('18147773872','announce-position','no',0),('18147773872','queue-youarenext','silence/1',0),('18147773872','queue-thereare','silence/1',0),('18147773872','queue-callswaiting','silence/1',0),('18147773872','queue-thankyou','',0),('18147773872','periodic-announce-frequency','0',0),('18147773872','monitor-format','',0),('18147773872','monitor-join','yes',0),('18147773872','eventwhencalled','no',0),('18147773872','eventmemberstatus','no',0),('18147773872','weight','0',0),('18147773872','autofill','no',0),('18147773872','ringinuse','yes',0),('18147773872','reportholdtime','no',0),('18147773872','autopause','no',0),('18147773872','autopausedelay','0',0),('18147773872','servicelevel','60',0),('18147773872','memberdelay','0',0),('18147773872','timeoutrestart','no',0),('18147773872','skip_joinannounce','',0),('18147773872','cron_schedule','never',0),('18147773872','autopausebusy','no',0),('18147773872','autopauseunavail','no',0),('18147773872','timeoutpriority','app',0),('18147773872','penaltymemberslimit','0',0),('18147773872','answered_elsewhere','0',0),('18147773872','member','Agent/2000,0',0),('18147773872','member','Agent/2001,0',1),('18147773872','member','Agent/2002,0',2),('18147773872','member','Agent/2003,0',3),('18147773872','member','Agent/2004,0',4),('18147773872','member','Agent/2005,0',5),('18147773872','member','Agent/2006,0',6),('18147773872','member','Agent/2007,0',7),('18147773872','member','Agent/2008,0',8),('18147773872','member','Agent/2009,0',9),('18147773873','maxlen','0',0),('18147773873','joinempty','yes',0),('18147773873','leavewhenempty','no',0),('18147773873','strategy','random',0),('18147773873','timeout','0',0),('18147773873','retry','5',0),('18147773873','wrapuptime','0',0),('18147773873','announce-frequency','0',0),('18147773873','announce-holdtime','no',0),('18147773873','announce-position','no',0),('18147773873','queue-youarenext','silence/1',0),('18147773873','queue-thereare','silence/1',0),('18147773873','queue-callswaiting','silence/1',0),('18147773873','queue-thankyou','',0),('18147773873','periodic-announce-frequency','0',0),('18147773873','monitor-format','',0),('18147773873','monitor-join','yes',0),('18147773873','eventwhencalled','no',0),('18147773873','eventmemberstatus','no',0),('18147773873','weight','0',0),('18147773873','autofill','no',0),('18147773873','ringinuse','yes',0),('18147773873','reportholdtime','no',0),('18147773873','autopause','no',0),('18147773873','autopausedelay','0',0),('18147773873','servicelevel','60',0),('18147773873','memberdelay','0',0),('18147773873','timeoutrestart','no',0),('18147773873','skip_joinannounce','',0),('18147773873','cron_schedule','never',0),('18147773873','autopausebusy','no',0),('18147773873','autopauseunavail','no',0),('18147773873','timeoutpriority','app',0),('18147773873','penaltymemberslimit','0',0),('18147773873','answered_elsewhere','0',0),('18147773873','member','Agent/2000,0',0),('18147773873','member','Agent/2001,0',1),('18147773873','member','Agent/2002,0',2),('18147773873','member','Agent/2003,0',3),('18147773873','member','Agent/2004,0',4),('18147773873','member','Agent/2005,0',5),('18147773873','member','Agent/2006,0',6),('18147773873','member','Agent/2007,0',7),('18147773873','member','Agent/2008,0',8),('18147773873','member','Agent/2009,0',9),('15588804684','member','Agent/2003,0',3),('15588804684','member','Agent/2004,0',4),('15588804684','member','Agent/2005,0',5),('15588804684','member','Agent/2006,0',6),('15588804684','member','Agent/2008,0',7),('15588804684','member','Agent/2009,0',8),('15588804684','member','Agent/2010,0',9),('15588804684','member','Agent/2011,0',10),('18147773877','maxlen','0',0),('18147773877','joinempty','yes',0),('15588804684','penaltymemberslimit','0',0),('15588804684','cron_schedule','never',0),('15588804684','autopausebusy','no',0),('15588804684','autopauseunavail','no',0),('15588804684','timeoutpriority','app',0),('15588804684','timeoutrestart','no',0),('15588804684','skip_joinannounce','',0),('15588804684','monitor-format','wav',0),('15588804684','monitor-join','yes',0),('15588804684','eventwhencalled','no',0),('15588804684','eventmemberstatus','no',0),('15588804684','weight','0',0),('15588804684','autofill','no',0),('15588804684','ringinuse','yes',0),('15588804684','reportholdtime','no',0),('15588804684','autopause','no',0),('15588804684','autopausedelay','0',0),('15588804684','servicelevel','60',0),('15588804684','maxlen','0',0),('15588804684','joinempty','yes',0),('15588804684','leavewhenempty','no',0),('15588804684','strategy','random',0),('15588804684','timeout','0',0),('15588804684','retry','5',0),('15588804684','wrapuptime','0',0),('15588804684','announce-frequency','0',0),('15588804684','announce-holdtime','no',0),('15588804684','announce-position','no',0),('15588804684','queue-youarenext','silence/1',0),('15588804684','queue-thereare','silence/1',0),('15588804684','queue-callswaiting','silence/1',0),('15588804684','queue-thankyou','',0),('15588804684','periodic-announce-frequency','0',0),('18147773874','maxlen','0',0),('18147773874','joinempty','yes',0),('18147773874','leavewhenempty','no',0),('18147773874','strategy','random',0),('18147773874','timeout','0',0),('18147773874','retry','5',0),('18147773874','wrapuptime','0',0),('18147773874','announce-frequency','0',0),('18147773874','announce-holdtime','no',0),('18147773874','announce-position','no',0),('18147773874','queue-youarenext','silence/1',0),('18147773874','queue-thereare','silence/1',0),('18147773874','queue-callswaiting','silence/1',0),('18147773874','queue-thankyou','',0),('18147773874','periodic-announce-frequency','0',0),('18147773874','monitor-format','',0),('18147773874','monitor-join','yes',0),('18147773874','eventwhencalled','no',0),('18147773874','eventmemberstatus','no',0),('18147773874','weight','0',0),('18147773874','autofill','no',0),('18147773874','ringinuse','yes',0),('18147773874','reportholdtime','no',0),('18147773874','autopause','no',0),('18147773874','autopausedelay','0',0),('18147773874','servicelevel','60',0),('18147773874','memberdelay','0',0),('18147773874','timeoutrestart','no',0),('18147773874','skip_joinannounce','',0),('18147773874','cron_schedule','never',0),('18147773874','autopausebusy','no',0),('18147773874','autopauseunavail','no',0),('18147773874','timeoutpriority','app',0),('18147773874','penaltymemberslimit','0',0),('18147773874','answered_elsewhere','0',0),('18147773874','member','Agent/2000,0',0),('18147773874','member','Agent/2001,0',1),('18147773874','member','Agent/2002,0',2),('18147773874','member','Agent/2003,0',3),('18147773874','member','Agent/2004,0',4),('18147773874','member','Agent/2005,0',5),('18147773874','member','Agent/2006,0',6),('18147773874','member','Agent/2007,0',7),('18147773874','member','Agent/2008,0',8),('18147773874','member','Agent/2009,0',9),('18147773875','maxlen','0',0),('18147773875','joinempty','yes',0),('18147773875','leavewhenempty','no',0),('18147773875','strategy','random',0),('18147773875','timeout','0',0),('18147773875','retry','5',0),('18147773875','wrapuptime','0',0),('18147773875','announce-frequency','0',0),('18147773875','announce-holdtime','no',0),('18147773875','announce-position','no',0),('18147773875','queue-youarenext','silence/1',0),('18147773875','queue-thereare','silence/1',0),('18147773875','queue-callswaiting','silence/1',0),('18147773875','queue-thankyou','',0),('18147773875','periodic-announce-frequency','0',0),('18147773875','monitor-format','',0),('18147773875','monitor-join','yes',0),('18147773875','eventwhencalled','no',0),('18147773875','eventmemberstatus','no',0),('18147773875','weight','0',0),('18147773875','autofill','no',0),('18147773875','ringinuse','yes',0),('18147773875','reportholdtime','no',0),('18147773875','autopause','no',0),('18147773875','autopausedelay','0',0),('18147773875','servicelevel','60',0),('18147773875','memberdelay','0',0),('18147773875','timeoutrestart','no',0),('18147773875','skip_joinannounce','',0),('18147773875','cron_schedule','never',0),('18147773875','autopausebusy','no',0),('18147773875','autopauseunavail','no',0),('18147773875','timeoutpriority','app',0),('18147773875','penaltymemberslimit','0',0),('18147773875','answered_elsewhere','0',0),('18147773875','member','Agent/2000,0',0),('18147773875','member','Agent/2001,0',1),('18147773875','member','Agent/2002,0',2),('18147773875','member','Agent/2003,0',3),('18147773875','member','Agent/2004,0',4),('18147773875','member','Agent/2005,0',5),('18147773875','member','Agent/2006,0',6),('18147773875','member','Agent/2007,0',7),('18147773875','member','Agent/2008,0',8),('18147773875','member','Agent/2009,0',9),('15588804684','member','Agent/2002,0',2),('15588804684','member','Agent/2001,0',1),('15588804684','memberdelay','0',0),('18147773877','leavewhenempty','no',0),('18147773877','strategy','random',0),('18147773877','timeout','0',0),('18147773877','retry','5',0),('18147773877','wrapuptime','0',0),('18147773877','announce-frequency','0',0),('18147773877','announce-holdtime','no',0),('18147773877','announce-position','no',0),('18147773877','queue-youarenext','silence/1',0),('18147773877','queue-thereare','silence/1',0),('18147773877','queue-callswaiting','silence/1',0),('18147773877','queue-thankyou','',0),('18147773877','periodic-announce-frequency','0',0),('18147773877','monitor-format','',0),('18147773877','monitor-join','yes',0),('18147773877','eventwhencalled','no',0),('18147773877','eventmemberstatus','no',0),('18147773877','weight','0',0),('18147773877','autofill','no',0),('18147773877','ringinuse','yes',0),('18147773877','reportholdtime','no',0),('18147773877','autopause','no',0),('18147773877','autopausedelay','0',0),('18147773877','servicelevel','60',0),('18147773877','memberdelay','0',0),('18147773877','timeoutrestart','no',0),('18147773877','skip_joinannounce','',0),('18147773877','cron_schedule','never',0),('18147773877','autopausebusy','no',0),('18147773877','autopauseunavail','no',0),('18147773877','timeoutpriority','app',0),('18147773877','penaltymemberslimit','0',0),('18147773877','answered_elsewhere','0',0),('18147773877','member','Agent/2000,0',0),('18147773877','member','Agent/2001,0',1),('18147773877','member','Agent/2002,0',2),('18147773877','member','Agent/2003,0',3),('18147773877','member','Agent/2004,0',4),('18147773877','member','Agent/2005,0',5),('18147773877','member','Agent/2006,0',6),('18147773877','member','Agent/2007,0',7),('18147773877','member','Agent/2008,0',8),('18147773877','member','Agent/2009,0',9),('18147773876','maxlen','0',0),('18147773876','joinempty','yes',0),('18147773876','leavewhenempty','no',0),('18147773876','strategy','random',0),('18147773876','timeout','0',0),('18147773876','retry','5',0),('18147773876','wrapuptime','0',0),('18147773876','announce-frequency','0',0),('18147773876','announce-holdtime','no',0),('18147773876','announce-position','no',0),('18147773876','queue-youarenext','silence/1',0),('18147773876','queue-thereare','silence/1',0),('18147773876','queue-callswaiting','silence/1',0),('18147773876','queue-thankyou','',0),('18147773876','periodic-announce-frequency','0',0),('18147773876','monitor-format','',0),('18147773876','monitor-join','yes',0),('18147773876','eventwhencalled','no',0),('18147773876','eventmemberstatus','no',0),('18147773876','weight','0',0),('18147773876','autofill','no',0),('18147773876','ringinuse','yes',0),('18147773876','reportholdtime','no',0),('18147773876','autopause','no',0),('18147773876','autopausedelay','0',0),('18147773876','servicelevel','60',0),('18147773876','memberdelay','0',0),('18147773876','timeoutrestart','no',0),('18147773876','skip_joinannounce','',0),('18147773876','cron_schedule','never',0),('18147773876','autopausebusy','no',0),('18147773876','autopauseunavail','no',0),('18147773876','timeoutpriority','app',0),('18147773876','penaltymemberslimit','0',0),('18147773876','answered_elsewhere','0',0),('18147773876','member','Agent/2000,0',0),('18147773876','member','Agent/2001,0',1),('18147773876','member','Agent/2002,0',2),('18147773876','member','Agent/2003,0',3),('18147773876','member','Agent/2004,0',4),('18147773876','member','Agent/2005,0',5),('18147773876','member','Agent/2006,0',6),('18147773876','member','Agent/2007,0',7),('18147773876','member','Agent/2008,0',8),('18147773876','member','Agent/2009,0',9),('18147773878','maxlen','0',0),('18147773878','joinempty','yes',0),('18147773878','leavewhenempty','no',0),('18147773878','strategy','random',0),('18147773878','timeout','0',0),('18147773878','retry','5',0),('18147773878','wrapuptime','0',0),('18147773878','announce-frequency','0',0),('18147773878','announce-holdtime','no',0),('18147773878','announce-position','no',0),('18147773878','queue-youarenext','silence/1',0),('18147773878','queue-thereare','silence/1',0),('18147773878','queue-callswaiting','silence/1',0),('18147773878','queue-thankyou','',0),('18147773878','periodic-announce-frequency','0',0),('18147773878','monitor-format','',0),('18147773878','monitor-join','yes',0),('18147773878','eventwhencalled','no',0),('18147773878','eventmemberstatus','no',0),('18147773878','weight','0',0),('18147773878','autofill','no',0),('18147773878','ringinuse','yes',0),('18147773878','reportholdtime','no',0),('18147773878','autopause','no',0),('18147773878','autopausedelay','0',0),('18147773878','servicelevel','60',0),('18147773878','memberdelay','0',0),('18147773878','timeoutrestart','no',0),('18147773878','skip_joinannounce','',0),('18147773878','cron_schedule','never',0),('18147773878','autopausebusy','no',0),('18147773878','autopauseunavail','no',0),('18147773878','timeoutpriority','app',0),('18147773878','penaltymemberslimit','0',0),('18147773878','answered_elsewhere','0',0),('18147773878','member','Agent/2000,0',0),('18147773878','member','Agent/2001,0',1),('18147773878','member','Agent/2002,0',2),('18147773878','member','Agent/2003,0',3),('18147773878','member','Agent/2004,0',4),('18147773878','member','Agent/2005,0',5),('18147773878','member','Agent/2006,0',6),('18147773878','member','Agent/2007,0',7),('18147773878','member','Agent/2008,0',8),('18147773878','member','Agent/2009,0',9),('18147773879','maxlen','0',0),('18147773879','joinempty','yes',0),('18147773879','leavewhenempty','no',0),('18147773879','strategy','random',0),('18147773879','timeout','0',0),('18147773879','retry','5',0),('18147773879','wrapuptime','0',0),('18147773879','announce-frequency','0',0),('18147773879','announce-holdtime','no',0),('18147773879','announce-position','no',0),('18147773879','queue-youarenext','silence/1',0),('18147773879','queue-thereare','silence/1',0),('18147773879','queue-callswaiting','silence/1',0),('18147773879','queue-thankyou','',0),('18147773879','periodic-announce-frequency','0',0),('18147773879','monitor-format','',0),('18147773879','monitor-join','yes',0),('18147773879','eventwhencalled','no',0),('18147773879','eventmemberstatus','no',0),('18147773879','weight','0',0),('18147773879','autofill','no',0),('18147773879','ringinuse','yes',0),('18147773879','reportholdtime','no',0),('18147773879','autopause','no',0),('18147773879','autopausedelay','0',0),('18147773879','servicelevel','60',0),('18147773879','memberdelay','0',0),('18147773879','timeoutrestart','no',0),('18147773879','skip_joinannounce','',0),('18147773879','cron_schedule','never',0),('18147773879','autopausebusy','no',0),('18147773879','autopauseunavail','no',0),('18147773879','timeoutpriority','app',0),('18147773879','penaltymemberslimit','0',0),('18147773879','answered_elsewhere','0',0),('18147773879','member','Agent/2000,0',0),('18147773879','member','Agent/2001,0',1),('18147773879','member','Agent/2002,0',2),('18147773879','member','Agent/2003,0',3),('18147773879','member','Agent/2004,0',4),('18147773879','member','Agent/2005,0',5),('18147773879','member','Agent/2006,0',6),('18147773879','member','Agent/2007,0',7),('18147773879','member','Agent/2008,0',8),('18147773879','member','Agent/2009,0',9),('18147773883','maxlen','0',0),('18147773883','joinempty','yes',0),('18147773883','leavewhenempty','no',0),('18147773883','strategy','random',0),('18147773883','timeout','0',0),('18147773883','retry','5',0),('18147773883','wrapuptime','0',0),('18147773883','announce-frequency','0',0),('18147773883','announce-holdtime','no',0),('18147773883','announce-position','no',0),('18147773883','queue-youarenext','silence/1',0),('18147773883','queue-thereare','silence/1',0),('18147773883','queue-callswaiting','silence/1',0),('18147773883','queue-thankyou','',0),('18147773883','periodic-announce-frequency','0',0),('18147773883','monitor-format','',0),('18147773883','monitor-join','yes',0),('18147773883','eventwhencalled','no',0),('18147773883','eventmemberstatus','no',0),('18147773883','weight','0',0),('18147773883','autofill','no',0),('18147773883','ringinuse','yes',0),('18147773883','reportholdtime','no',0),('18147773883','autopause','no',0),('18147773883','autopausedelay','0',0),('18147773883','servicelevel','60',0),('18147773883','memberdelay','0',0),('18147773883','timeoutrestart','no',0),('18147773883','skip_joinannounce','',0),('18147773883','cron_schedule','never',0),('18147773883','autopausebusy','no',0),('18147773883','autopauseunavail','no',0),('18147773883','timeoutpriority','app',0),('18147773883','penaltymemberslimit','0',0),('18147773883','answered_elsewhere','0',0),('18147773883','member','Agent/2000,0',0),('18147773883','member','Agent/2001,0',1),('18147773883','member','Agent/2002,0',2),('18147773883','member','Agent/2003,0',3),('18147773883','member','Agent/2004,0',4),('18147773883','member','Agent/2005,0',5),('18147773883','member','Agent/2006,0',6),('18147773883','member','Agent/2007,0',7),('18147773883','member','Agent/2008,0',8),('18147773883','member','Agent/2009,0',9),('18147773882','member','Agent/2005,0',5),('18147773882','member','Agent/2006,0',6),('18147773882','member','Agent/2001,0',1),('18147773882','member','Agent/2002,0',2),('18147773882','member','Agent/2003,0',3),('18147773882','member','Agent/2004,0',4),('18147773882','penaltymemberslimit','0',0),('18147773882','answered_elsewhere','0',0),('18147773882','member','Agent/2000,0',0),('18147773882','autopauseunavail','no',0),('18147773882','timeoutpriority','app',0),('18147773882','skip_joinannounce','',0),('18147773882','cron_schedule','never',0),('18147773882','autopausebusy','no',0),('18147773882','reportholdtime','no',0),('18147773882','autopause','no',0),('18147773882','autopausedelay','0',0),('18147773882','servicelevel','60',0),('18147773882','memberdelay','0',0),('18147773882','timeoutrestart','no',0),('18147773882','maxlen','0',0),('18147773882','joinempty','yes',0),('18147773882','leavewhenempty','no',0),('18147773882','strategy','random',0),('18147773882','timeout','0',0),('18147773882','retry','5',0),('18147773882','wrapuptime','0',0),('18147773882','announce-frequency','0',0),('18147773882','announce-holdtime','no',0),('18147773882','announce-position','no',0),('18147773882','queue-youarenext','silence/1',0),('18147773882','queue-thereare','silence/1',0),('18147773882','queue-callswaiting','silence/1',0),('18147773882','queue-thankyou','',0),('18147773882','periodic-announce-frequency','0',0),('18147773882','monitor-format','',0),('18147773882','monitor-join','yes',0),('18147773882','eventwhencalled','no',0),('18147773882','eventmemberstatus','no',0),('18147773882','weight','0',0),('18147773882','autofill','no',0),('18147773882','ringinuse','yes',0),('13335605356','maxlen','0',0),('13335605356','joinempty','yes',0),('13335605356','leavewhenempty','no',0),('13335605356','strategy','random',0),('13335605356','timeout','0',0),('13335605356','retry','5',0),('13335605356','wrapuptime','0',0),('13335605356','announce-frequency','0',0),('13335605356','announce-holdtime','no',0),('13335605356','announce-position','no',0),('13335605356','queue-youarenext','silence/1',0),('13335605356','queue-thereare','silence/1',0),('13335605356','queue-callswaiting','silence/1',0),('13335605356','queue-thankyou','',0),('13335605356','periodic-announce-frequency','0',0),('13335605356','monitor-format','',0),('13335605356','monitor-join','yes',0),('13335605356','eventwhencalled','no',0),('13335605356','eventmemberstatus','no',0),('13335605356','weight','0',0),('13335605356','autofill','no',0),('13335605356','ringinuse','yes',0),('13335605356','reportholdtime','no',0),('13335605356','autopause','no',0),('13335605356','autopausedelay','0',0),('13335605356','servicelevel','60',0),('13335605356','memberdelay','0',0),('13335605356','timeoutrestart','no',0),('13335605356','skip_joinannounce','',0),('13335605356','cron_schedule','never',0),('13335605356','autopausebusy','no',0),('13335605356','autopauseunavail','no',0),('13335605356','timeoutpriority','app',0),('13335605356','penaltymemberslimit','0',0),('13335605356','answered_elsewhere','0',0),('13335605356','member','Agent/2000,0',0),('13335605356','member','Agent/2001,0',1),('13335605356','member','Agent/2002,0',2),('13335605356','member','Agent/2003,0',3),('13335605356','member','Agent/2004,0',4),('13335605356','member','Agent/2005,0',5),('13335605356','member','Agent/2006,0',6),('13335605356','member','Agent/2007,0',7),('13335605356','member','Agent/2008,0',8),('13335605356','member','Agent/2009,0',9),('1008177700100','cron_schedule','never',0),('1008177700100','autopausebusy','no',0),('1008177700100','autopauseunavail','no',0),('1008177700100','timeoutpriority','app',0),('1008177700100','penaltymemberslimit','0',0),('1008177700100','answered_elsewhere','0',0),('1008177700100','periodic-announce-frequency','0',0),('1008177700100','monitor-format','wav',0),('1008177700100','monitor-join','yes',0),('1008177700100','eventwhencalled','no',0),('1008177700100','eventmemberstatus','no',0),('1008177700100','weight','0',0),('1008177700100','autofill','no',0),('1008177700100','ringinuse','yes',0),('1008177700100','reportholdtime','no',0),('1008177700100','autopause','no',0),('1008177700100','autopausedelay','0',0),('1008177700100','servicelevel','60',0),('1008177700100','memberdelay','0',0),('1008177700100','timeoutrestart','no',0),('1008177700100','skip_joinannounce','',0),('1008177700100','announce-holdtime','no',0),('1008177700100','announce-position','no',0),('1008177700100','queue-youarenext','silence/1',0),('1008177700100','queue-thereare','silence/1',0),('1008177700100','queue-callswaiting','silence/1',0),('1008177700100','queue-thankyou','',0),('1008177700100','maxlen','0',0),('1008177700100','joinempty','yes',0),('1008177700100','leavewhenempty','no',0),('1008177700100','strategy','random',0),('1008177700100','timeout','0',0),('1008177700100','retry','5',0),('1008177700100','wrapuptime','0',0),('1008177700100','announce-frequency','0',0),('18147773881','ringinuse','yes',0),('18147773881','reportholdtime','no',0),('18147773881','queue-thereare','silence/1',0),('18147773881','queue-youarenext','silence/1',0),('18147773881','maxlen','0',0),('18147773881','joinempty','yes',0),('18147773881','autopause','no',0),('18147773881','periodic-announce-frequency','0',0),('18147773881','monitor-format','wav',0),('18147773881','monitor-join','yes',0),('18147773881','eventwhencalled','no',0),('18147773881','eventmemberstatus','no',0),('18147773881','weight','0',0),('18147773881','autofill','no',0),('18147773881','leavewhenempty','no',0),('18147773881','queue-callswaiting','silence/1',0),('18147773881','queue-thankyou','',0),('18147773881','strategy','random',0),('18147773881','timeout','0',0),('18147773881','retry','5',0),('18147773881','wrapuptime','0',0),('18147773881','announce-frequency','0',0),('18147773881','announce-holdtime','no',0),('18147773881','announce-position','no',0),('1008177700100','member','Agent/2009,0',9),('1008177700100','member','Agent/2008,0',8),('1008177700100','member','Agent/2007,0',7),('1008177700100','member','Agent/2006,0',6),('1008177700100','member','Agent/2005,0',5),('1008177700100','member','Agent/2004,0',4),('1008177700100','member','Agent/2003,0',3),('1008177700100','member','Agent/2002,0',2),('1008177700100','member','Agent/2001,0',1),('1008177700100','member','Agent/2000,0',0),('18147773881','servicelevel','60',0),('18147773881','memberdelay','0',0),('18147773881','timeoutrestart','no',0),('18147773881','skip_joinannounce','',0),('18147773881','cron_schedule','never',0),('18147773881','autopausebusy','no',0),('18147773881','autopauseunavail','no',0),('18147773881','timeoutpriority','app',0),('18147773881','penaltymemberslimit','0',0),('18147773881','answered_elsewhere','0',0),('18147773881','member','Agent/2007,0',0),('18147773882','member','Agent/2007,0',7),('18147773882','member','Agent/2008,0',8),('18147773882','member','Agent/2009,0',9),('18147773884','maxlen','0',0),('18147773884','joinempty','yes',0),('18147773884','leavewhenempty','no',0),('18147773884','strategy','random',0),('18147773884','timeout','0',0),('18147773884','retry','5',0),('18147773884','wrapuptime','0',0),('18147773884','announce-frequency','0',0),('18147773884','announce-holdtime','no',0),('18147773884','announce-position','no',0),('18147773884','queue-youarenext','silence/1',0),('18147773884','queue-thereare','silence/1',0),('18147773884','queue-callswaiting','silence/1',0),('18147773884','queue-thankyou','',0),('18147773884','periodic-announce-frequency','0',0),('18147773884','monitor-format','',0),('18147773884','monitor-join','yes',0),('18147773884','eventwhencalled','no',0),('18147773884','eventmemberstatus','no',0),('18147773884','weight','0',0),('18147773884','autofill','no',0),('18147773884','ringinuse','yes',0),('18147773884','reportholdtime','no',0),('18147773884','autopause','no',0),('18147773884','autopausedelay','0',0),('18147773884','servicelevel','60',0),('18147773884','memberdelay','0',0),('18147773884','timeoutrestart','no',0),('18147773884','skip_joinannounce','',0),('18147773884','cron_schedule','never',0),('18147773884','autopausebusy','no',0),('18147773884','autopauseunavail','no',0),('18147773884','timeoutpriority','app',0),('18147773884','penaltymemberslimit','0',0),('18147773884','answered_elsewhere','0',0),('18147773884','member','Agent/2000,0',0),('18147773884','member','Agent/2001,0',1),('18147773884','member','Agent/2002,0',2),('18147773884','member','Agent/2003,0',3),('18147773884','member','Agent/2004,0',4),('18147773884','member','Agent/2005,0',5),('18147773884','member','Agent/2006,0',6),('18147773884','member','Agent/2007,0',7),('18147773884','member','Agent/2008,0',8),('18147773884','member','Agent/2009,0',9),('18147773885','maxlen','0',0),('18147773885','joinempty','yes',0),('18147773885','leavewhenempty','no',0),('18147773885','strategy','random',0),('18147773885','timeout','0',0),('18147773885','retry','5',0),('18147773885','wrapuptime','0',0),('18147773885','announce-frequency','0',0),('18147773885','announce-holdtime','no',0),('18147773885','announce-position','no',0),('18147773885','queue-youarenext','silence/1',0),('18147773885','queue-thereare','silence/1',0),('18147773885','queue-callswaiting','silence/1',0),('18147773885','queue-thankyou','',0),('18147773885','periodic-announce-frequency','0',0),('18147773885','monitor-format','',0),('18147773885','monitor-join','yes',0),('18147773885','eventwhencalled','no',0),('18147773885','eventmemberstatus','no',0),('18147773885','weight','0',0),('18147773885','autofill','no',0),('18147773885','ringinuse','yes',0),('18147773885','reportholdtime','no',0),('18147773885','autopause','no',0),('18147773885','autopausedelay','0',0),('18147773885','servicelevel','60',0),('18147773885','memberdelay','0',0),('18147773885','timeoutrestart','no',0),('18147773885','skip_joinannounce','',0),('18147773885','cron_schedule','never',0),('18147773885','autopausebusy','no',0),('18147773885','autopauseunavail','no',0),('18147773885','timeoutpriority','app',0),('18147773885','penaltymemberslimit','0',0),('18147773885','answered_elsewhere','0',0),('18147773885','member','Agent/2000,0',0),('18147773885','member','Agent/2001,0',1),('18147773885','member','Agent/2002,0',2),('18147773885','member','Agent/2003,0',3),('18147773885','member','Agent/2004,0',4),('18147773885','member','Agent/2005,0',5),('18147773885','member','Agent/2006,0',6),('18147773885','member','Agent/2007,0',7),('18147773885','member','Agent/2008,0',8),('18147773885','member','Agent/2009,0',9),('18147773887','maxlen','0',0),('18147773887','joinempty','yes',0),('18147773887','leavewhenempty','no',0),('18147773887','strategy','random',0),('18147773887','timeout','0',0),('18147773887','retry','5',0),('18147773887','wrapuptime','0',0),('18147773887','announce-frequency','0',0),('18147773887','announce-holdtime','no',0),('18147773887','announce-position','no',0),('18147773887','queue-youarenext','silence/1',0),('18147773887','queue-thereare','silence/1',0),('18147773887','queue-callswaiting','silence/1',0),('18147773887','queue-thankyou','',0),('18147773887','periodic-announce-frequency','0',0),('18147773887','monitor-format','',0),('18147773887','monitor-join','yes',0),('18147773887','eventwhencalled','no',0),('18147773887','eventmemberstatus','no',0),('18147773887','weight','0',0),('18147773887','autofill','no',0),('18147773887','ringinuse','yes',0),('18147773887','reportholdtime','no',0),('18147773887','autopause','no',0),('18147773887','autopausedelay','0',0),('18147773887','servicelevel','60',0),('18147773887','memberdelay','0',0),('18147773887','timeoutrestart','no',0),('18147773887','skip_joinannounce','',0),('18147773887','cron_schedule','never',0),('18147773887','autopausebusy','no',0),('18147773887','autopauseunavail','no',0),('18147773887','timeoutpriority','app',0),('18147773887','penaltymemberslimit','0',0),('18147773887','answered_elsewhere','0',0),('18147773887','member','Agent/2000,0',0),('18147773887','member','Agent/2001,0',1),('18147773887','member','Agent/2002,0',2),('18147773887','member','Agent/2003,0',3),('18147773887','member','Agent/2004,0',4),('18147773887','member','Agent/2005,0',5),('18147773887','member','Agent/2006,0',6),('18147773887','member','Agent/2007,0',7),('18147773887','member','Agent/2008,0',8),('18147773887','member','Agent/2009,0',9),('15588804687','maxlen','0',0),('15588804687','joinempty','yes',0),('15588804687','leavewhenempty','no',0),('15588804687','strategy','random',0),('15588804687','timeout','0',0),('15588804687','retry','5',0),('15588804687','wrapuptime','0',0),('15588804687','announce-frequency','0',0),('15588804687','announce-holdtime','no',0),('15588804687','announce-position','no',0),('15588804687','queue-youarenext','silence/1',0),('15588804687','queue-thereare','silence/1',0),('15588804687','queue-callswaiting','silence/1',0),('15588804687','queue-thankyou','',0),('15588804687','periodic-announce-frequency','0',0),('15588804687','monitor-format','',0),('15588804687','monitor-join','yes',0),('15588804687','eventwhencalled','no',0),('15588804687','eventmemberstatus','no',0),('15588804687','weight','0',0),('15588804687','autofill','no',0),('15588804687','ringinuse','yes',0),('15588804687','reportholdtime','no',0),('15588804687','autopause','no',0),('15588804687','autopausedelay','0',0),('15588804687','servicelevel','60',0),('15588804687','memberdelay','0',0),('15588804687','timeoutrestart','no',0),('15588804687','skip_joinannounce','',0),('15588804687','cron_schedule','never',0),('15588804687','autopausebusy','no',0),('15588804687','autopauseunavail','no',0),('15588804687','timeoutpriority','app',0),('15588804687','penaltymemberslimit','0',0),('15588804687','answered_elsewhere','0',0),('15588804687','member','Agent/2000,0',0),('15588804687','member','Agent/2001,0',1),('15588804687','member','Agent/2002,0',2),('15588804687','member','Agent/2003,0',3),('15588804687','member','Agent/2004,0',4),('15588804687','member','Agent/2005,0',5),('15588804687','member','Agent/2006,0',6),('15588804687','member','Agent/2007,0',7),('15588804687','member','Agent/2008,0',8),('15588804687','member','Agent/2009,0',9),('18147773888','maxlen','0',0),('18147773888','joinempty','yes',0),('18147773888','leavewhenempty','no',0),('18147773888','strategy','random',0),('18147773888','timeout','0',0),('18147773888','retry','5',0),('18147773888','wrapuptime','0',0),('18147773888','announce-frequency','0',0),('18147773888','announce-holdtime','no',0),('18147773888','announce-position','no',0),('18147773888','queue-youarenext','silence/1',0),('18147773888','queue-thereare','silence/1',0),('18147773888','queue-callswaiting','silence/1',0),('18147773888','queue-thankyou','',0),('18147773888','periodic-announce-frequency','0',0),('18147773888','monitor-format','',0),('18147773888','monitor-join','yes',0),('18147773888','eventwhencalled','no',0),('18147773888','eventmemberstatus','no',0),('18147773888','weight','0',0),('18147773888','autofill','no',0),('18147773888','ringinuse','yes',0),('18147773888','reportholdtime','no',0),('18147773888','autopause','no',0),('18147773888','autopausedelay','0',0),('18147773888','servicelevel','60',0),('18147773888','memberdelay','0',0),('18147773888','timeoutrestart','no',0),('18147773888','skip_joinannounce','',0),('18147773888','cron_schedule','never',0),('18147773888','autopausebusy','no',0),('18147773888','autopauseunavail','no',0),('18147773888','timeoutpriority','app',0),('18147773888','penaltymemberslimit','0',0),('18147773888','answered_elsewhere','0',0),('18147773888','member','Agent/2000,0',0),('18147773888','member','Agent/2001,0',1),('18147773888','member','Agent/2002,0',2),('18147773888','member','Agent/2003,0',3),('18147773888','member','Agent/2004,0',4),('18147773888','member','Agent/2005,0',5),('18147773888','member','Agent/2006,0',6),('18147773888','member','Agent/2007,0',7),('18147773888','member','Agent/2008,0',8),('18147773888','member','Agent/2009,0',9),('18147773889','maxlen','0',0),('18147773889','joinempty','yes',0),('18147773889','leavewhenempty','no',0),('18147773889','strategy','random',0),('18147773889','timeout','0',0),('18147773889','retry','5',0),('18147773889','wrapuptime','0',0),('18147773889','announce-frequency','0',0),('18147773889','announce-holdtime','no',0),('18147773889','announce-position','no',0),('18147773889','queue-youarenext','silence/1',0),('18147773889','queue-thereare','silence/1',0),('18147773889','queue-callswaiting','silence/1',0),('18147773889','queue-thankyou','',0),('18147773889','periodic-announce-frequency','0',0),('18147773889','monitor-format','',0),('18147773889','monitor-join','yes',0),('18147773889','eventwhencalled','no',0),('18147773889','eventmemberstatus','no',0),('18147773889','weight','0',0),('18147773889','autofill','no',0),('18147773889','ringinuse','yes',0),('18147773889','reportholdtime','no',0),('18147773889','autopause','no',0),('18147773889','autopausedelay','0',0),('18147773889','servicelevel','60',0),('18147773889','memberdelay','0',0),('18147773889','timeoutrestart','no',0),('18147773889','skip_joinannounce','',0),('18147773889','cron_schedule','never',0),('18147773889','autopausebusy','no',0),('18147773889','autopauseunavail','no',0),('18147773889','timeoutpriority','app',0),('18147773889','penaltymemberslimit','0',0),('18147773889','answered_elsewhere','0',0),('18147773889','member','Agent/2000,0',0),('18147773889','member','Agent/2001,0',1),('18147773889','member','Agent/2002,0',2),('18147773889','member','Agent/2003,0',3),('18147773889','member','Agent/2004,0',4),('18147773889','member','Agent/2005,0',5),('18147773889','member','Agent/2006,0',6),('18147773889','member','Agent/2007,0',7),('18147773889','member','Agent/2008,0',8),('18147773889','member','Agent/2009,0',9),('15589958536','maxlen','0',0),('15589958536','joinempty','yes',0),('15589958536','leavewhenempty','no',0),('15589958536','strategy','random',0),('15589958536','timeout','0',0),('15589958536','retry','5',0),('15589958536','wrapuptime','0',0),('15589958536','announce-frequency','0',0),('15589958536','announce-holdtime','no',0),('15589958536','announce-position','no',0),('15589958536','queue-youarenext','silence/1',0),('15589958536','queue-thereare','silence/1',0),('15589958536','queue-callswaiting','silence/1',0),('15589958536','queue-thankyou','',0),('15589958536','periodic-announce-frequency','0',0),('15589958536','monitor-format','',0),('15589958536','monitor-join','yes',0),('15589958536','eventwhencalled','no',0),('15589958536','eventmemberstatus','no',0),('15589958536','weight','0',0),('15589958536','autofill','no',0),('15589958536','ringinuse','yes',0),('15589958536','reportholdtime','no',0),('15589958536','autopause','no',0),('15589958536','autopausedelay','0',0),('15589958536','servicelevel','60',0),('15589958536','memberdelay','0',0),('15589958536','timeoutrestart','no',0),('15589958536','skip_joinannounce','',0),('15589958536','cron_schedule','never',0),('15589958536','autopausebusy','no',0),('15589958536','autopauseunavail','no',0),('15589958536','timeoutpriority','app',0),('15589958536','penaltymemberslimit','0',0),('15589958536','answered_elsewhere','0',0),('15589958536','member','Agent/2000,0',0),('15589958536','member','Agent/2001,0',1),('15589958536','member','Agent/2002,0',2),('15589958536','member','Agent/2003,0',3),('15589958536','member','Agent/2004,0',4),('15589958536','member','Agent/2005,0',5),('15589958536','member','Agent/2006,0',6),('15589958536','member','Agent/2007,0',7),('15589958536','member','Agent/2008,0',8),('15589958536','member','Agent/2009,0',9),('13335605357','maxlen','0',0),('13335605357','joinempty','yes',0),('13335605357','leavewhenempty','no',0),('13335605357','strategy','ringall',0),('13335605357','timeout','0',0),('13335605357','retry','5',0),('13335605357','wrapuptime','0',0),('13335605357','announce-frequency','0',0),('13335605357','announce-holdtime','no',0),('13335605357','announce-position','no',0),('13335605357','queue-youarenext','silence/1',0),('13335605357','queue-thereare','silence/1',0),('13335605357','queue-callswaiting','silence/1',0),('13335605357','queue-thankyou','',0),('13335605357','periodic-announce-frequency','0',0),('13335605357','monitor-format','',0),('13335605357','monitor-join','yes',0),('13335605357','eventwhencalled','no',0),('13335605357','eventmemberstatus','no',0),('13335605357','weight','0',0),('13335605357','autofill','no',0),('13335605357','ringinuse','yes',0),('13335605357','reportholdtime','no',0),('13335605357','autopause','no',0),('13335605357','autopausedelay','0',0),('13335605357','servicelevel','60',0),('13335605357','memberdelay','0',0),('13335605357','timeoutrestart','no',0),('13335605357','skip_joinannounce','',0),('13335605357','cron_schedule','never',0),('13335605357','autopausebusy','no',0),('13335605357','autopauseunavail','no',0),('13335605357','timeoutpriority','app',0),('13335605357','penaltymemberslimit','0',0),('13335605357','answered_elsewhere','0',0),('13335605357','member','Agent/2000,0',0),('13335605357','member','Agent/2001,0',1),('13335605357','member','Agent/2002,0',2),('13335605357','member','Agent/2003,0',3),('13335605357','member','Agent/2004,0',4),('13335605357','member','Agent/2005,0',5),('13335605357','member','Agent/2006,0',6),('13335605357','member','Agent/2007,0',7),('13335605357','member','Agent/2008,0',8),('13335605357','member','Agent/2009,0',9),('15000000000','member','Agent/2004,0',5),('15000000000','monitor-join','yes',0),('15000000000','eventwhencalled','no',0),('15000000000','eventmemberstatus','no',0),('15000000000','weight','0',0),('15000000000','autofill','no',0),('15000000000','ringinuse','yes',0),('15000000000','reportholdtime','no',0),('15000000000','autopause','no',0),('15000000000','wrapuptime','0',0),('15000000000','announce-frequency','0',0),('15000000000','announce-holdtime','no',0),('15000000000','announce-position','no',0),('15000000000','queue-youarenext','silence/1',0),('15000000000','queue-thereare','silence/1',0),('15000000000','queue-callswaiting','silence/1',0),('15000000000','queue-thankyou','',0),('15000000000','periodic-announce-frequency','0',0),('15000000000','monitor-format','',0),('15000000000','maxlen','0',0),('15000000000','joinempty','yes',0),('15000000000','leavewhenempty','no',0),('15000000000','strategy','random',0),('15000000000','timeout','0',0),('15000000000','retry','5',0),('15588804686','member','Agent/2008,0',8),('15588804686','penaltymemberslimit','0',0),('15588804686','answered_elsewhere','0',0),('15588804686','member','Agent/2000,0',0),('15588804686','autopauseunavail','no',0),('15588804686','timeoutpriority','app',0),('15588804686','weight','0',0),('15588804686','autofill','no',0),('15588804686','ringinuse','yes',0),('15588804686','reportholdtime','no',0),('15588804686','autopause','no',0),('15588804686','autopausedelay','0',0),('15588804686','member','Agent/2009,0',9),('12228800361','maxlen','0',0),('12228800361','joinempty','yes',0),('12228800361','leavewhenempty','no',0),('12228800361','strategy','random',0),('12228800361','timeout','0',0),('12228800361','retry','5',0),('12228800361','wrapuptime','0',0),('12228800361','announce-frequency','0',0),('12228800361','announce-holdtime','no',0),('12228800361','announce-position','no',0),('12228800361','queue-youarenext','silence/1',0),('12228800361','queue-thereare','silence/1',0),('12228800361','queue-callswaiting','silence/1',0),('12228800361','queue-thankyou','',0),('12228800361','periodic-announce-frequency','0',0),('12228800361','monitor-format','',0),('12228800361','monitor-join','yes',0),('12228800361','eventwhencalled','no',0),('12228800361','eventmemberstatus','no',0),('12228800361','weight','0',0),('12228800361','autofill','no',0),('12228800361','ringinuse','yes',0),('12228800361','reportholdtime','no',0),('12228800361','autopause','no',0),('12228800361','autopausedelay','0',0),('12228800361','servicelevel','60',0),('12228800361','memberdelay','0',0),('12228800361','timeoutrestart','no',0),('12228800361','skip_joinannounce','',0),('12228800361','cron_schedule','never',0),('12228800361','autopausebusy','no',0),('12228800361','autopauseunavail','no',0),('12228800361','timeoutpriority','app',0),('12228800361','penaltymemberslimit','0',0),('12228800361','answered_elsewhere','0',0),('12228800361','member','Agent/2000,0',0),('12228800361','member','Agent/2001,0',1),('12228800361','member','Agent/2002,0',2),('12228800361','member','Agent/2003,0',3),('12228800361','member','Agent/2004,0',4),('12228800361','member','Agent/2005,0',5),('12228800361','member','Agent/2006,0',6),('12228800361','member','Agent/2007,0',7),('12228800361','member','Agent/2008,0',8),('12228800361','member','Agent/2009,0',9),('18177701576','ringinuse','yes',0),('18177701576','reportholdtime','no',0),('18177700385','member','Agent/2011,0',11),('1000','penaltymemberslimit','0',0),('18147370246','member','Agent/2011,0',11),('18147370245','member','Agent/2011,0',11),('98177700100','member','Agent/2011,0',11),('28177700100','member','Agent/2010,0',10),('18177700384','member','Agent/2011,0',11),('18147370242','member','Agent/2011,0',11),('18147370241','member','Agent/2011,0',11),('19847770191','member','Agent/2011,0',11),('18147370240','member','Agent/2011,0',11),('18177700106','member','Agent/2011,0',11),('18147370247','member','Agent/2011,0',11),('18177700105','member','Agent/2011,0',11),('18177700104','member','Agent/2011,0',11),('18177700103','member','Agent/2011,0',11),('18177700102','member','Agent/2011,0',11),('18177700101','member','Agent/2011,0',11),('98147370215','member','Agent/2011,0',11),('18177700387','member','Agent/2011,0',11),('18177700108','answered_elsewhere','0',0),('18147370215','member','Agent/2011,0',11),('18147370239','member','Agent/2011,0',11),('18177700110','member','Agent/2011,0',11),('19847770192','member','Agent/2011,0',11),('1000','member','Agent/2011,0',11),('18177700109','member','Agent/2011,0',11),('18177700111','member','Agent/2011,0',11),('12228800361','member','Agent/2010,0',10),('15000000000','member','Agent/2005,0',6),('13335605357','member','Agent/2010,0',10),('15589958536','member','Agent/2010,0',10),('18147773889','member','Agent/2010,0',10),('18147773888','member','Agent/2010,0',10),('15588804687','member','Agent/2010,0',10),('18147773887','member','Agent/2010,0',10),('18147773885','member','Agent/2010,0',10),('18147773884','member','Agent/2010,0',10),('1008177700100','member','Agent/2010,0',10),('13335605356','member','Agent/2010,0',10),('18147773882','member','Agent/2010,0',10),('18147773883','member','Agent/2010,0',10),('18147773879','member','Agent/2010,0',10),('18147773878','member','Agent/2010,0',10),('18147773876','member','Agent/2010,0',10),('18147773875','member','Agent/2010,0',10),('18147773874','member','Agent/2010,0',10),('18147773877','member','Agent/2010,0',10),('15588804684','member','Agent/2000,0',0),('18147773873','member','Agent/2010,0',10),('18147773871','member','Agent/2010,0',10),('18147773870','member','Agent/2010,0',10),('18177701579','member','Agent/2010,0',10),('18177701578','member','Agent/2010,0',10),('18177701577','member','Agent/2010,0',10),('18177701576','answered_elsewhere','0',0),('18177701575',